/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockNodeToControllerChannelManager;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004:\u0001\u0001\u0006I!\f\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0013!\u0005B\u0002%\u0001A\u0003%Q\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r9\u0003\u0001\u0015!\u0003L\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u0016\u0001!\u0002\u0013\t\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007C\u0002\u0001\u000b\u0011B,\t\u000b\t\u0004A\u0011B2\t\u000b\u001d\u0004A\u0011\u00025\t\u000b1\u0004A\u0011\u00025\t\u000b5\u0004A\u0011\u00018\t\u000bu\u0004A\u0011\u00018\t\u000b}\u0004A\u0011\u00018\t\r\u0005\r\u0001\u0001\"\u0001o\u0011\u0019\t9\u0001\u0001C\u0001]\"1\u00111\u0002\u0001\u0005\u00029Dq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u0010\u0001!I!!\u0013\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\t)bi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:UKN$(B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005!A/[7f+\u0005i\u0003C\u0001\u00188\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0005q\u0011$B\u0001\u00104\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005az#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r\rd\u0017.\u001a8u+\u0005a\u0004CA\u001fA\u001b\u0005q$BA 3\u0003\u001d\u0019G.[3oiNL!!\u0011 \u0003\u00155{7m[\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002-\r|g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ,\u0012!\u0012\t\u0003U\u0019K!aR\u000e\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\fqcY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\u0011\u0002%\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\u000b\u0002\u0017B\u0011!\u0006T\u0005\u0003\u001bn\u0011!%T8dW:{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013!\u00054pe^\f'\u000fZ5oO6\u000bg.Y4feV\t\u0011\u000b\u0005\u0002+%&\u00111k\u0007\u0002\u0016\r>\u0014x/\u0019:eS:<W*\u00198bO\u0016\u0014\u0018*\u001c9m\u0003I1wN]<be\u0012LgnZ'b]\u0006<WM\u001d\u0011\u0002!A\u0014\u0018N\\2ja\u0006d')^5mI\u0016\u0014X#A,\u0011\u0005a{V\"A-\u000b\u0005i[\u0016!D1vi\",g\u000e^5dCR|'O\u0003\u0002];\u0006A1/Z2ve&$\u0018P\u0003\u0002_e\u000511m\\7n_:L!\u0001Y-\u00039\u0011+g-Y;mi.\u000bgm[1Qe&t7-\u001b9bY\n+\u0018\u000e\u001c3fe\u0006\t\u0002O]5oG&\u0004\u0018\r\u001c\"vS2$WM\u001d\u0011\u0002+\r|g\u000e\u001e:pY2,'/\u00119j-\u0016\u00148/[8ogV\tA\r\u0005\u0002>K&\u0011aM\u0010\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u0006q1m\u001c8ue>dG.\u001a:J]\u001a|W#A5\u0011\u0005)R\u0017BA6\u001c\u0005U\u0019uN\u001c;s_2dWM]%oM>\u0014X.\u0019;j_:\f1#Z7qif\u001cuN\u001c;s_2dWM]%oM>\f\u0011\u0005^3tiJ+7\u000f]8og\u0016\u001cuN\u001d:fY\u0006$\u0018n\u001c8JI6K7/\\1uG\"$\u0012a\u001c\t\u0003EAL!!]\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003#M\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ys\u00069!.\u001e9ji\u0016\u0014(B\u0001>6\u0003\u0015QWO\\5u\u0013\taXO\u0001\u0003UKN$\u0018a\u0006;fgR,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8tQ\t\u00112/\u0001\u001auKN$hi\u001c:xCJ$\u0017N\\4US6,w.\u001e;XC&$\u0018N\\4G_J\u001cuN\u001c;s_2dWM\u001d#jg\u000e|g/\u001a:zQ\t\u00192/A\u0010uKN$hi\u001c:xCJ$\u0017N\\4US6,w.\u001e;BMR,'OU3uefD#\u0001F:\u0002OQ,7\u000f^+ogV\u0004\bo\u001c:uK\u00124VM]:j_:4%o\\7OKR<xN]6DY&,g\u000e\u001e\u0015\u0003+M\f\u0001\u0004^3ti\u001a\u000b\u0017\u000e\\3e\u0003V$\b.\u001a8uS\u000e\fG/[8oQ\t12/\u0001\u0007ck&dGMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0014\u0005U\u0012q\b\t\bE\u0005U\u0011\u0011DA\u0013\u0013\r\t9b\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b^\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0012\u0003;\u0011QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\b\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0004]&|'BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012\u0011\u0006\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA\u001c/\u0001\u0007\u0011\u0011H\u0001\u0005E>$\u0017\u0010\u0005\u0003\u0002\u001c\u0005m\u0012\u0002BA\u001f\u0003;\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003\u0003:\u0002\u0019AA\"\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JIB\u0019!%!\u0012\n\u0007\u0005\u001d3EA\u0002J]R$\u0002\"a\u0013\u0002`\u0005\r\u0014q\r\t\u0005\u0003\u001b\nIF\u0004\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019&H\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t9&!\u0015\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u00111LA/\u0005\u001d\u0011V-];fgRTA!a\u0016\u0002R!9\u0011\u0011\r\rA\u0002\u0005e\u0011!\u0004:fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0002fa\u0001\r!!\n\u0002\u001bI,\u0017/^3ti\n+hMZ3s\u0011\u001d\tI\u0007\u0007a\u0001\u0003W\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d\\\u0003\u0011\tW\u000f\u001e5\n\t\u0005U\u0014q\u000e\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003Y!Xm\u001d;BYR,'oQ8oM&<'+Z9vKN$XCAA>!\u0011\tY\"! \n\t\u0005}\u0014Q\u0004\u0002\u0014\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f\u001e")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockNodeToControllerChannelManager brokerToController = new MockNodeToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), 60000, 30000);
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((NodeToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockNodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava());
    }

    private ControllerInformation controllerInfo() {
        return new ControllerInformation((Option)new Some((Object)new Node(0, "host", 1234)), new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    private ControllerInformation emptyControllerInfo() {
        return new ControllerInformation((Option)None$.MODULE$, new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)var4_4, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().createPendingAuthenticationError((Node)this.controllerInfo().node().get(), 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }
}

