/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015BQ\u0001\u000b\u0001\u0005\n%BQA\r\u0001\u0005\u0002MBQ\u0001\u0012\u0001\u0005\u0002MBQA\u0012\u0001\u0005\u0002MBQ\u0001\u0013\u0001\u0005\u0002MBQA\u0013\u0001\u0005\u0002MBQ\u0001\u0014\u0001\u0005\u0002MBQA\u0014\u0001\u0005\u0002MBQ\u0001\u0015\u0001\u0005\u0002MBQA\u0015\u0001\u0005\u0002MBQ\u0001\u0016\u0001\u0005\u0002MBQA\u0016\u0001\u0005\u0002MBQ\u0001\u0017\u0001\u0005\u0002MBQA\u0017\u0001\u0005\u0002M2A\u0001\u0018\u0001\u0001;\"Aq\r\u0005B\u0001B\u0003%\u0001\u000eC\u0003%!\u0011\u00051\u000fC\u0003x\u0001\u0011\u00051\u0007C\u0003z\u0001\u0011\u00051\u0007C\u0003|\u0001\u0011\u00051\u0007C\u0003~\u0001\u0011\u0005aPA\bTi>\u0014\u0018mZ3U_>dG+Z:u\u0015\tI\"$A\u0003u_>d7OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002(\u00015\t\u0001$\u0001\roK^\u001cV\r\u001c4NC:\fw-\u001a3Qe>\u0004XM\u001d;jKN$\u0012A\u000b\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005)\u0001&o\u001c9feRLWm]\u0001\u001bi\u0016\u001cHoQ8oM&<Gk\u001c'pO\u0012K'/Z2u_JLWm\u001d\u000b\u0002iA\u0011q$N\u0005\u0003m\u0001\u0012A!\u00168ji\"\u00121\u0001\u000f\t\u0003s\tk\u0011A\u000f\u0006\u0003wq\n1!\u00199j\u0015\tid(A\u0004kkBLG/\u001a:\u000b\u0005}\u0002\u0015!\u00026v]&$(\"A!\u0002\u0007=\u0014x-\u0003\u0002Du\t!A+Z:u\u0003!\"Xm\u001d;D_:4\u0017n\u001a+p\u0019><G)\u001b:fGR|'/[3t/&$\b.T3uC2{w\rR5sQ\t!\u0001(A\u0010uKN$\u0018J\u001c4p\u0007>lW.\u00198e\u001f:,U\u000e\u001d;z\t&\u0014Xm\u0019;pefD#!\u0002\u001d\u0002CQ,7\u000f^%oM>\u001cu.\\7b]\u0012|e.T5tg&tw\rR5sK\u000e$xN]=)\u0005\u0019A\u0014\u0001\t;fgRLeNZ8D_6l\u0017M\u001c3P]\u0012K'/Z2u_JL\u0018i\u001d$jY\u0016D#a\u0002\u001d\u0002OQ,7\u000f^%oM><\u0016\u000e\u001e5NSNl\u0017\r^2iK\u0012dUmZ1ds.\u000bgm[1D_:4\u0017n\u001a\u0015\u0003\u0011a\nA\u0006^3ti&sgm\\,ji\"l\u0015n]7bi\u000eDW\rZ*fY\u001al\u0015M\\1hK\u0012\\\u0015MZ6b\u0007>tg-[4)\u0005%A\u0014\u0001\u0007;fgR4uN]7bi\u0016k\u0007\u000f^=ESJ,7\r^8ss\"\u0012!\u0002O\u0001\u001fi\u0016\u001cHOR8s[\u0006$x+\u001b;i\u0013:4\u0018\r\\5e\u00072,8\u000f^3s\u0013\u0012D#a\u0003\u001d\u00025Q,7\u000f\u001e#fM\u0006,H\u000e^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u00051A\u0014!\b;fgR\u001cuN\u001c4jOV\u0014X\rZ'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u00055A\u0014\u0001\u0007;fgRlU\r^1eCR\fg+\u001a:tS>tg\t\\1hg\"\u0012a\u0002O\u0001\ri\u0016\u001cH/\u00113e'\u000e\u0014\u0018-\u001c\u0015\u0003\u001fa\u0012\u0001d\u0015;pe\u0006<W\rV8pYR+7\u000f^#yG\u0016\u0004H/[8o'\t\u0001b\f\u0005\u0002`K6\t\u0001M\u0003\u0002bE\u000611m\\7n_:T!aG2\u000b\u0005\u0011\u0004\u0015AB1qC\u000eDW-\u0003\u0002gA\nq1*\u00194lC\u0016C8-\u001a9uS>t\u0017aB7fgN\fw-\u001a\t\u0003SBt!A\u001b8\u0011\u0005-\u0004S\"\u00017\u000b\u00055d\u0012A\u0002\u001fs_>$h(\u0003\u0002pA\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty\u0007\u0005\u0006\u0002umB\u0011Q\u000fE\u0007\u0002\u0001!)qM\u0005a\u0001Q\u0006yB/Z:u'\u000e\u0014\u0018-\\,ji\"\u0014\u0015\rZ'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u0005MA\u0014A\b;fgRtunU2sC6<\u0016\u000e\u001e5NKR\fG-\u0019;b-\u0016\u00148/[8oQ\t!\u0002(A\u000buKN$H)\u001b:Vk&$w)\u001a8fe\u0006$\u0018n\u001c8)\u0005UA\u0014\u0001\f;fgR4uN]7biRLgnZ+ogR\f'\r\\3NKR\fG-\u0019;b-\u0016\u00148/[8o\u00052|7m[3e)\t!t\u0010C\u0004\u0002\u0002Y\u0001\r!a\u0001\u0002\u001d\u0015t\u0017M\u00197f+:\u001cH/\u00192mKB\u0019q$!\u0002\n\u0007\u0005\u001d\u0001EA\u0004C_>dW-\u00198)\u0007Y\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002P\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005U\u0011q\u0002\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\f\u0002\u001a\u0005\u0015\u0012q\u0005\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)!\u0011qDA\b\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA\u0012\u0003;\u00111BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002*\u0005-\u0012$\u0001\u0001\u001a\u0003\u0005As\u0001AA\u0018\u0003k\t9\u0004E\u0002:\u0003cI1!a\r;\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u000b")
public class StorageToolTest {
    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo,/tmp/bar");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        return properties;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(246).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedSelfManagedKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatEmptyDirectory() {
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            Assertions.assertTrue((boolean)stream.toString().startsWith(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tempDir}))));
            try {
                Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(new ByteArrayOutputStream()), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            }
            catch (TerseFailure e) {
                Assertions.assertEquals((Object)new StringBuilder(107).append("Log directory ").append(tempDir).append(" is already ").append("formatted. Use --ignore-formatted to ignore this directory and format the ").append("others.").toString(), (Object)e.getMessage());
            }
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream2), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), true));
            Assertions.assertEquals((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("All of the log directories are already formatted.%n"), (scala.collection.immutable.Seq)Nil$.MODULE$), (Object)stream2.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatWithInvalidClusterId() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)"Cluster ID string invalid does not appear to be a valid UUID: Input string `invalid` decoded as 5 bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.buildMetadataProperties("invalid", config)).getMessage());
    }

    @Test
    public void testDefaultMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"});
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
        Assertions.assertEquals((short)MetadataVersion.LATEST_PRODUCTION.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be the latest production version");
    }

    @Test
    public void testConfiguredMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"});
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)new Some((Object)MetadataVersion.IBP_3_3_IV2.toString()));
        Assertions.assertEquals((short)MetadataVersion.IBP_3_3_IV2.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be 3.3-IV2");
    }

    @Test
    public void testMetadataVersionFlags() {
        MetadataVersion mv = StorageToolTest.parseMetadataVersion$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0"}));
        Assertions.assertEquals((Object)"3.0", (Object)mv.shortVersion());
        mv = StorageToolTest.parseMetadataVersion$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0-IV1"}));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)mv);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageToolTest.parseMetadataVersion$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "0.0"})));
    }

    @Test
    public void testAddScram() {
        Option scramRecords = StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)Nil$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)scramRecords);
        scramRecords = StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]", "-S", "SCRAM-SHA-256=[name=george,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"}));
        Assertions.assertEquals((int)2, (int)((SeqOps)scramRecords.get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'name' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must only supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'salt' with 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice,iterations=4096]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16385]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be <= 16384 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16384]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4095]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be >= 4096 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4096]"})).get()).size());
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice]"})).get()).size());
    }

    @Test
    public void testScramWithBadMetadataVersion() {
        ObjectRef exitString = ObjectRef.create((Object)"");
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitStatus, message) -> this.exitProcedure$1(BoxesRunTime.unboxToInt((Object)exitStatus), message, exitString);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var7_2 = null;
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4", "-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=8192]"};
        try {
            try {
                Integer n = BoxesRunTime.boxToInteger((int)1);
                StorageTool$.MODULE$.main(args);
                Assertions.assertEquals((Object)n, (Object)BoxedUnit.UNIT);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"SCRAM is only supported in metadataVersion IBP_3_5_IV2 or later.", (Object)((String)exitString.elem));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testNoScramWithMetadataVersion() {
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, message) -> this.exitProcedure$2(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var8_3 = null;
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), TestUtils.tempDirectory(null, null).toString());
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4"};
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
                Assertions.assertEquals((int)0, (int)exitStatus.elem);
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testDirUuidGeneration() {
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            MetaProperties metaProperties = new MetaProperties.Builder().setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            File metaPropertiesFile = Paths.get(tempDir.toURI()).resolve("meta.properties").toFile();
            Assertions.assertTrue((boolean)metaPropertiesFile.exists());
            MetaProperties metaProps = new MetaProperties.Builder(PropertiesUtils.readPropertiesFile((String)metaPropertiesFile.getAbsolutePath())).build();
            Assertions.assertTrue((boolean)metaProps.directoryId().isPresent());
            Assertions.assertFalse((boolean)DirectoryId.reserved((Uuid)((Uuid)metaProps.directoryId().get())));
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormattingUnstableMetadataVersionBlocked(boolean enableUnstable) {
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, message) -> this.exitProcedure$3(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var10_4 = null;
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try (OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);){
            properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), TestUtils.tempDirectory(null, null).toString());
            properties.setProperty(KafkaConfig$.MODULE$.UnstableMetadataVersionsEnableProp(), Boolean.toString(enableUnstable));
            properties.store(propsStream, "config.props");
        }
        String[] args = new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", MetadataVersion.latestTesting().toString()};
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        if (enableUnstable) {
            Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
            Assertions.assertEquals((int)0, (int)exitStatus.elem);
            return;
        }
        Assertions.assertEquals((Object)new StringBuilder(54).append("Metadata version ").append(MetadataVersion.latestTesting().toString()).append(" is not ready for ").append("production use yet.").toString(), (Object)((String)exitString.elem));
        Assertions.assertEquals((int)1, (int)exitStatus.elem);
    }

    private static final MetadataVersion parseMetadataVersion$1(scala.collection.immutable.Seq strings) {
        Seq args = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (Seq)args.$plus$plus((IterableOnce)strings);
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
    }

    private static final Option parseAddScram$1(scala.collection.immutable.Seq strings) {
        Seq args = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (Seq)args.$plus$plus((IterableOnce)strings);
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getUserScramCredentialRecords(namespace);
    }

    private final Nothing$ exitProcedure$1(int exitStatus, Option message, ObjectRef exitString$1) {
        exitString$1.elem = (String)message.getOrElse((Function0 & Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$1.elem);
    }

    private final Nothing$ exitProcedure$2(int status, Option message, IntRef exitStatus$1, ObjectRef exitString$2) {
        exitStatus$1.elem = status;
        exitString$2.elem = (String)message.getOrElse((Function0 & Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$2.elem);
    }

    private final Nothing$ exitProcedure$3(int status, Option message, IntRef exitStatus$2, ObjectRef exitString$3) {
        exitStatus$2.elem = status;
        exitString$3.elem = (String)message.getOrElse((Function0 & Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$3.elem);
    }

    public class StorageToolTestException
    extends KafkaException {
        public /* synthetic */ StorageToolTest kafka$tools$StorageToolTest$StorageToolTestException$$$outer() {
            return StorageToolTest.this;
        }

        public StorageToolTestException(String message) {
            if (StorageToolTest.this == null) {
                throw null;
            }
            super(message);
        }
    }
}

