/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00048\u0001\u0001\u0006IA\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u00191\u0005\u0001)A\u0005u!)q\t\u0001C\u0001\u0011\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a!\u0001\t\u0013\t)\tC\u0004\u00026\u0002!I!a.\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bbBA~\u0001\u0011%\u0011Q \u0005\n\u00053\u0001\u0011\u0013!C\u0005\u000579QA[\u000e\t\u0002-4QAG\u000e\t\u00021DQ!\n\n\u0005\u0002A4A!\u001d\n\u0001e\")Q\u0005\u0006C\u0001}\"9\u00111\u0001\u000b\u0005B\u0005\u0015aABA!%\u0001\t\u0019\u0005\u0003\u0004&/\u0011\u0005\u0011Q\t\u0005\b\u0003\u00079B\u0011IA%\u0005\u0019bunZ\"mK\u0006tWM\u001d)be\u0006lW\r^3sSj,G-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u00039u\t1\u0001\\8h\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003mI!\u0001J\u000e\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0012\u0001\u0003\u0011!\u0018.\\3\u0016\u0003)\u0002\"aK\u001b\u000e\u00031R!!\f\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0003_A\naa]3sm\u0016\u0014(B\u0001\u00102\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\n\u0005Yb#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u000f\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0003\u0014AB2p[6|g.\u0003\u0002F\u0005\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u0005%c\u0005CA\u001eK\u0013\tYEH\u0001\u0003V]&$\b\"B'\u0007\u0001\u0004q\u0015!B2pI\u0016\u001c\u0007CA(S\u001b\u0005\u0001&BA)C\u0003\u0019\u0011XmY8sI&\u00111\u000b\u0015\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"\u0012a!\u0016\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000ba\u0001]1sC6\u001c(B\u0001.\\\u0003\u001dQW\u000f]5uKJT!\u0001X\u001a\u0002\u000b),h.\u001b;\n\u0005y;&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"\"a\u0001\u00194h!\t\tG-D\u0001c\u0015\t\u0019w+\u0001\u0005qe>4\u0018\u000eZ3s\u0013\t)'MA\bBe\u001e,X.\u001a8ugN{WO]2f\u0003\u00151\u0018\r\\;fG\u0005A\u0007CA5\u0015\u001d\t\u0011\u0013#\u0001\u0014M_\u001e\u001cE.Z1oKJ\u0004\u0016M]1nKR,'/\u001b>fI&sG/Z4sCRLwN\u001c+fgR\u0004\"A\t\n\u0014\u0005Ii\u0007CA\u001eo\u0013\tyGH\u0001\u0004B]f\u0014VM\u001a\u000b\u0002W\ny\u0011\t\u001c7D_6\u0004(/Z:tS>t7oE\u0002\u0015gn\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\tQXO\u0001\u0004PE*,7\r\u001e\t\u0003CrL!! 2\u0003#\u0005\u0013x-^7f]R\u001c\bK]8wS\u0012,'\u000fF\u0001\u0000!\r\t\t\u0001F\u0007\u0002%\u0005\u0001\u0002O]8wS\u0012,\u0017I]4v[\u0016tGo\u001d\u000b\u0005\u0003\u000f\ti\u0003\r\u0003\u0002\n\u0005m\u0001CBA\u0006\u0003'\t9\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0019\u0019HO]3b[*\u0011Qf^\u0005\u0005\u0003+\tiA\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u00033\tY\u0002\u0004\u0001\u0005\u0017\u0005ua#!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0004?\u0012\n\u0014\u0003BA\u0011\u0003O\u00012aOA\u0012\u0013\r\t)\u0003\u0010\u0002\b\u001d>$\b.\u001b8h!\r\t\u0017\u0011F\u0005\u0004\u0003W\u0011'!C!sOVlWM\u001c;t\u0011\u001d\tyC\u0006a\u0001\u0003c\tqaY8oi\u0016DH\u000f\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013\u0015DH/\u001a8tS>t'bAA\u001e3\u0006\u0019\u0011\r]5\n\t\u0005}\u0012Q\u0007\u0002\u0011\u000bb$XM\\:j_:\u001cuN\u001c;fqR\u00141\"\u0012=dYV$WMW:uIN\u0019qc]>\u0015\u0005\u0005\u001d\u0003cAA\u0001/Q!\u00111JA+a\u0011\ti%!\u0015\u0011\r\u0005-\u00111CA(!\u0011\tI\"!\u0015\u0005\u0017\u0005M\u0013$!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0004?\u0012\u0012\u0004bBA\u00183\u0001\u0007\u0011\u0011G\u0001(i\u0016\u001cHo\u00117fC:\u001c8i\\7cS:,GmQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3U_BL7\rF\u0002J\u00037BQ!T\u0004A\u00029C#aB+)\t\u001d\u0001gmZ\u0001\u001fi\u0016\u001cHo\u00117fC:,'oV5uQ6+7o]1hK\u001a{'/\\1u-B\"2!SA3\u0011\u0015i\u0005\u00021\u0001OQ\tAQ\u000bK\u0003\tA\u001a\fYg\t\u0002\u0002nA\u0011\u0011nF\u0001&i\u0016\u001cHo\u00117fC:Lgn\u001a(fgR,G-T3tg\u0006<Wm],ji\"4\u0006'\u00118e-F\"2!SA:\u0011\u0015i\u0015\u00021\u0001OQ\tIQ\u000bK\u0003\nA\u001a\fY'A\fdY\u0016\fg.\u001a:D_:4\u0017nZ+qI\u0006$X\rV3tiR\u0019\u0011*! \t\u000b5S\u0001\u0019\u0001()\u0005))\u0006\u0006\u0002\u0006aM\u001e\f\u0001c\u00195fG.d\u0015m\u001d;DY\u0016\fg.\u001a3\u0015\u000f%\u000b9)!)\u0002,\"9\u0011\u0011R\u0006A\u0002\u0005-\u0015!\u0002;pa&\u001c\u0007\u0003BAG\u00037sA!a$\u0002\u0018B\u0019\u0011\u0011\u0013\u001f\u000e\u0005\u0005M%bAAK?\u00051AH]8pizJ1!!'=\u0003\u0019\u0001&/\u001a3fM&!\u0011QTAP\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0014\u001f\t\u000f\u0005\r6\u00021\u0001\u0002&\u0006Y\u0001/\u0019:uSRLwN\\%e!\rY\u0014qU\u0005\u0004\u0003Sc$aA%oi\"9\u0011QV\u0006A\u0002\u0005=\u0016A\u00034jeN$H)\u001b:usB\u00191(!-\n\u0007\u0005MFH\u0001\u0003M_:<\u0017AG2iK\u000e\\Gj\\4BMR,'/\u00119qK:$\u0017N\\4EkB\u001cHcB%\u0002:\u0006\u0005\u0017Q\u0019\u0005\u000791\u0001\r!a/\u0011\u0007\t\ni,C\u0002\u0002@n\u0011!\"\u00168jM&,G\rT8h\u0011\u001d\t\u0019\r\u0004a\u0001\u0003_\u000b\u0011b\u001d;beR\u001c\u0016N_3\t\u000f\u0005\u001dG\u00021\u0001\u0002J\u00069\u0011\r\u001d9f]\u0012\u001c\bCBAf\u0003#\f).\u0004\u0002\u0002N*\u0019\u0011q\u001a\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u00065'aA*fcBI1(a6\u0002&\u0006-\u0015qV\u0005\u0004\u00033d$A\u0002+va2,7'A\u0003u_6\u000b\u0007\u000f\u0006\u0003\u0002`\u0006-\b\u0003CAf\u0003C\f)+!:\n\t\u0005\r\u0018Q\u001a\u0002\u0004\u001b\u0006\u0004\bcB\u001e\u0002h\u0006-\u0015qV\u0005\u0004\u0003Sd$A\u0002+va2,'\u0007C\u0004\u0002n6\u0001\r!a<\u0002\u00115,7o]1hKN\u0004b!a3\u0002r\u0006U\u0017\u0002BAz\u0003\u001b\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\fe\u0016\fGM\u0012:p[2{w\r\u0006\u0003\u0002p\u0006e\bB\u0002\u000f\u000f\u0001\u0004\tY,A\rxe&$X\rR;qgNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$HCDAe\u0003\u007f\u0014\u0019Aa\u0002\u0003\n\t-!q\u0002\u0005\b\u0005\u0003y\u0001\u0019AAS\u0003\u001dqW/\\&fsNDqA!\u0002\u0010\u0001\u0004\t)+A\u0004ok6$U\u000f]:\t\rqy\u0001\u0019AA^\u0011\u0015iu\u00021\u0001O\u0011%\u0011ia\u0004I\u0001\u0002\u0004\t)+\u0001\u0005ti\u0006\u0014HoS3z\u0011\u001d\u0011\tb\u0004a\u0001\u0005'\t!\"\\1hS\u000e4\u0016\r\\;f!\rY$QC\u0005\u0004\u0005/a$\u0001\u0002\"zi\u0016\f1e\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fi\u0012\"WMZ1vYR$S'\u0006\u0002\u0003\u001e)\"\u0011Q\u0015B\u0010W\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0016y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=\"Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType codec) {
        void var4_4;
        void var5_5;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var5_5.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var5_5, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        int x$12 = largeMessageKey + 1;
        byte x$17 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(100, 3, log, codec, x$12, x$17);
        Seq appends2 = (Seq)((IterableOps)appends.$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var4_4, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dups);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), null).read().contains((Object)this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType codec) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put("retention.ms", retentionMs);
        logProps.put("cleanup.policy", "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        long endOffset = var5_5.logEndOffset();
        var5_5.logSegments().forEach(x$4 -> x$4.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$3((UnifiedLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for deletion of old segments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cleaner().shutdown();
        this.closeLog((UnifiedLog)var5_5);
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, codec);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log2 = (UnifiedLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((UnifiedLog)var9_11);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)var10_12), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0(CompressionType codec) {
        void var4_4;
        void var5_5;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = CompressionType.NONE.equals(codec) ? var5_5.sizeInBytes() : var5_5.sizeInBytes() + 6;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$72 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$72, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$13 = this.logConfigProperties$default$1();
        float x$14 = this.logConfigProperties$default$3();
        long x$15 = this.logConfigProperties$default$4();
        int x$16 = this.logConfigProperties$default$5();
        int x$17 = this.logConfigProperties$default$6();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$13, maxMessageSize, x$14, x$15, x$16, x$17, x$18);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$24 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, x$24, (byte)0);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$30 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(40, 3, log, codec, x$30, (byte)0);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var5_5, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        props.put("message.format.version", MetadataVersion.IBP_0_11_0_IV0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(40, 3, log, codec, 30, (byte)1);
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(5, 3, log, codec, 15, (byte)2);
        Seq appends2 = (Seq)((IterableOps)((IterableOps)((IterableOps)appends.$plus$plus(dupsV0)).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var4_4, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dupsV1)).$plus$plus(dupsV2);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0AndV1(CompressionType codec) {
        int maxMessageSize = 192;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$82 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$82, 256, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, maxMessageSize, x$15, x$16, x$17, 256, x$18);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$24 = 0;
        Seq appendsV0 = this.writeDupsSingleMessageSet(2, 3, log, codec, x$24, (byte)0);
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, codec, 3, (byte)0));
        props.put("message.format.version", MetadataVersion.IBP_0_10_0_IV1.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        Seq appendsV1 = this.writeDupsSingleMessageSet(2, 2, log, codec, 4, (byte)1);
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, codec, 4, (byte)1));
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, codec, 6, (byte)1));
        Seq appends = (Seq)appendsV0.$plus$plus((IterableOnce)appendsV1);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType codec) {
        void var4_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var4_4.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$92 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, 1L, maxMessageSize, x$7, x$8, x$92, x$10, (Option<Object>)x$4, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize, this.cleaner().currentConfig().dedupeBufferLoadFactor, 100000, this.cleaner().currentConfig().maxMessageSize, this.cleaner().currentConfig().maxIoBytesPerSecond, this.cleaner().currentConfig().backoffMs, true));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString());
    }

    private void checkLogAfterAppendingDups(UnifiedLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((IterableOnceOps)messages.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
                String value = (String)x0$1._2();
                long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)deepLogEntry -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2())));
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, UnifiedLog log, CompressionType codec, int startKey, byte magicValue) {
        void withRecords_timestampType;
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$10 -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)x$10)));
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                String payload = (String)x0$1._2();
                return new SimpleRecord(Integer.toString(key).getBytes(), payload.getBytes());
            }
            throw new MatchError(null);
        });
        SimpleRecord[] withRecords_records = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_9 = null;
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (long)withRecords_initialOffset, (CompressionType)codec, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((IndexedSeqOps)kvs.zip((IterableOnce)offsets)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Tuple2 kv = (Tuple2)x0$2._1();
                long offset = x0$2._2$mcJ$sp();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            }
            throw new MatchError(null);
        });
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType codec$1) {
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()), 1));
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, codec$1, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$3(UnifiedLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1 && log$1.numberOfSegments() == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$4() {
        return "Timed out waiting for deletion of old segments";
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), Integer.toString(cleanerConfig.numThreads));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), Long.toString(cleanerConfig.dedupeBufferSize));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), Double.toString(cleanerConfig.dedupeBufferLoadFactor));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), Integer.toString(cleanerConfig.ioBufferSize));
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(cleanerConfig.maxMessageSize));
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), Long.toString(cleanerConfig.backoffMs));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), Double.toString(cleanerConfig.maxIoBytesPerSecond));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int x$10) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$11)))), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$11) {
            CompressionType compressionType = x$11;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

