/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LazyIndex;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class LogTestUtils$ {
    public static final LogTestUtils$ MODULE$ = new LogTestUtils$();

    public LogSegment createSegment(long offset, File logDir, int indexIntervalBytes, Time time) {
        File open_file = LogFileUtils.logFile((File)logDir, (long)offset, (String)"");
        boolean open_mutable = true;
        Object var10_5 = null;
        FileRecords ms = FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
        LazyIndex idx = LazyIndex.forOffset((File)LogFileUtils.offsetIndexFile((File)logDir, (long)offset, (String)""), (long)offset, (int)1000);
        LazyIndex timeIdx = LazyIndex.forTime((File)LogFileUtils.timeIndexFile((File)logDir, (long)offset, (String)""), (long)offset, (int)1500);
        String transactionIndexFile_suffix = "";
        Object var11_10 = null;
        TransactionIndex txnIndex = new TransactionIndex(offset, LogFileUtils.transactionIndexFile((File)logDir, (long)offset, (String)transactionIndexFile_suffix));
        return new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, time);
    }

    public int createSegment$default$3() {
        return 10;
    }

    public Time createSegment$default$4() {
        return Time.SYSTEM;
    }

    public LogConfig createLogConfig(long segmentMs, int segmentBytes, long retentionMs, long localRetentionMs, long retentionBytes, long localRetentionBytes, long segmentJitterMs, String cleanupPolicy, int maxMessageBytes, int indexIntervalBytes, int segmentIndexBytes, long fileDeleteDelayMs, boolean remoteLogStorageEnable) {
        Properties logProps = new Properties();
        logProps.put("segment.ms", Predef$.MODULE$.long2Long(segmentMs));
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentBytes));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(retentionMs));
        logProps.put("local.retention.ms", Predef$.MODULE$.long2Long(localRetentionMs));
        logProps.put("retention.bytes", Predef$.MODULE$.long2Long(retentionBytes));
        logProps.put("local.retention.bytes", Predef$.MODULE$.long2Long(localRetentionBytes));
        logProps.put("segment.jitter.ms", Predef$.MODULE$.long2Long(segmentJitterMs));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("max.message.bytes", Predef$.MODULE$.int2Integer(maxMessageBytes));
        logProps.put("index.interval.bytes", Predef$.MODULE$.int2Integer(indexIntervalBytes));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(segmentIndexBytes));
        logProps.put("file.delete.delay.ms", Predef$.MODULE$.long2Long(fileDeleteDelayMs));
        logProps.put("remote.storage.enable", Predef$.MODULE$.boolean2Boolean(remoteLogStorageEnable));
        return new LogConfig((Map)logProps);
    }

    public UnifiedLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, ConcurrentMap<String, Object> numRemainingSegments, boolean remoteStorageSystemEnable, Option<RemoteLogManager> remoteLogManager, LogOffsetsListener logOffsetsListener) {
        return UnifiedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxTransactionTimeoutMs, producerStateManagerConfig, producerIdExpirationCheckIntervalMs, new LogDirFailureChannel(10), lastShutdownClean, topicId, keepPartitionMetadataFile, numRemainingSegments, remoteStorageSystemEnable, logOffsetsListener);
    }

    public long createLogConfig$default$1() {
        return 604800000L;
    }

    public int createLogConfig$default$2() {
        return 0x40000000;
    }

    public long createLogConfig$default$3() {
        return 604800000L;
    }

    public long createLogConfig$default$4() {
        return -2L;
    }

    public long createLogConfig$default$5() {
        return -1L;
    }

    public long createLogConfig$default$6() {
        return -2L;
    }

    public long createLogConfig$default$7() {
        return 0L;
    }

    public String createLogConfig$default$8() {
        return "delete";
    }

    public int createLogConfig$default$9() {
        return 0x10000C;
    }

    public int createLogConfig$default$10() {
        return 4096;
    }

    public int createLogConfig$default$11() {
        return 0xA00000;
    }

    public long createLogConfig$default$12() {
        return 60000L;
    }

    public boolean createLogConfig$default$13() {
        return false;
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 300000;
    }

    public ProducerStateManagerConfig createLog$default$9() {
        return new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
    }

    public int createLog$default$10() {
        return Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public boolean createLog$default$11() {
        return true;
    }

    public Option<Uuid> createLog$default$12() {
        return None$.MODULE$;
    }

    public boolean createLog$default$13() {
        return true;
    }

    public ConcurrentMap<String, Object> createLog$default$14() {
        return new ConcurrentHashMap<String, Object>();
    }

    public boolean createLog$default$15() {
        return false;
    }

    public Option<RemoteLogManager> createLog$default$16() {
        return None$.MODULE$;
    }

    public LogOffsetsListener createLog$default$17() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public boolean hasOffsetOverflow(UnifiedLog log) {
        return this.firstOverflowSegment(log).isDefined();
    }

    public Option<LogSegment> firstOverflowSegment(UnifiedLog log) {
        Object object = new Object();
        try {
            CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().foreach((Function1 & Serializable)segment -> {
                LogTestUtils$.$anonfun$firstOverflowSegment$1(object, segment);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public FileRecords rawSegment(File logDir, long baseOffset) {
        File open_file = LogFileUtils.logFile((File)logDir, (long)baseOffset, (String)"");
        boolean open_mutable = true;
        return FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
    }

    public void initializeLogDirWithOverflowedSegment(File logDir) {
        long nextOffset = 0L;
        nextOffset = this.writeNormalSegment$1(nextOffset, logDir);
        nextOffset = this.writeOverflowSegment$1(nextOffset, logDir);
        this.writeNormalSegment$1(nextOffset, logDir);
    }

    public Iterable<Object> keysInLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)logSegment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable)batch -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().withFilter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$keysInLog$4(record))).map((Function1 & Serializable)record -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())))))));
    }

    public UnifiedLog recoverAndCheck(File logDir, LogConfig config, Iterable<Object> expectedKeys, BrokerTopicStats brokerTopicStats, Time time, Scheduler scheduler) {
        long x$7 = 0L;
        long x$8 = 0L;
        int x$9 = 300000;
        ProducerStateManagerConfig x$10 = this.createLog$default$9();
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        ConcurrentHashMap<String, Object> x$14 = new ConcurrentHashMap<String, Object>();
        boolean x$15 = false;
        None$ x$16 = None$.MODULE$;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        UnifiedLog recoveredLog = this.createLog(logDir, config, brokerTopicStats, scheduler, time, x$7, x$8, x$9, x$10, x$11, false, (Option<Uuid>)x$12, x$13, x$14, x$15, (Option<RemoteLogManager>)x$16, x$17);
        time.sleep(config.fileDeleteDelayMs + 1L);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)file -> {
            LogTestUtils$.$anonfun$recoverAndCheck$1(file);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(expectedKeys, this.keysInLog(recoveredLog));
        Assertions.assertFalse((boolean)this.hasOffsetOverflow(recoveredLog));
        return recoveredLog;
    }

    public LogAppendInfo appendEndTxnMarkerAsLeader(UnifiedLog log, long producerId, short producerEpoch, ControlRecordType controlType, long timestamp, int coordinatorEpoch, int leaderEpoch) {
        long x$6 = 0L;
        int x$7 = 0;
        MemoryRecords records = this.endTxnRecords(controlType, producerId, producerEpoch, x$6, coordinatorEpoch, x$7, timestamp);
        MetadataVersion x$11 = log.appendAsLeader$default$4();
        RequestLocal x$12 = log.appendAsLeader$default$5();
        VerificationGuard x$13 = log.appendAsLeader$default$6();
        return log.appendAsLeader(records, leaderEpoch, AppendOrigin.COORDINATOR, x$11, x$12, x$13);
    }

    public int appendEndTxnMarkerAsLeader$default$6() {
        return 0;
    }

    public int appendEndTxnMarkerAsLeader$default$7() {
        return 0;
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short epoch, long offset, int coordinatorEpoch, int partitionLeaderEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)epoch, (EndTransactionMarker)marker);
    }

    private long endTxnRecords$default$4() {
        return 0L;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    public FetchDataInfo readLog(UnifiedLog log, long startOffset, int maxLength, FetchIsolation isolation, boolean minOneMessage) {
        return log.read(startOffset, maxLength, isolation, minOneMessage);
    }

    public FetchIsolation readLog$default$4() {
        return FetchIsolation.LOG_END;
    }

    public boolean readLog$default$5() {
        return true;
    }

    public Iterable<AbortedTxn> allAbortedTransactions(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.txnIndex().allAbortedTxns()).asScala());
    }

    public void deleteProducerSnapshotFiles(File logDir) {
        Object[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$1(f)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(files), (Function1 & Serializable)x$1 -> {
            LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Object> listProducerSnapshotOffsets(File logDir) {
        return ((IterableOnceOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)logDir)).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset))).sorted((Ordering)Ordering.Long$.MODULE$)).toSeq();
    }

    public void assertLeaderEpochCacheEmpty(UnifiedLog log) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.leaderEpochCache());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        File newFile_dir = log.dir();
        Object var2_2 = null;
        Assertions.assertFalse((boolean)new File(newFile_dir, "leader-epoch-checkpoint").exists());
    }

    /*
     * WARNING - void declaration
     */
    public void appendNonTransactionalAsLeader(UnifiedLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        IndexedSeq simpleRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)seq -> LogTestUtils$.$anonfun$appendNonTransactionalAsLeader$1(BoxesRunTime.unboxToInt((Object)seq)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var5_5 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    public Function1<Object, BoxedUnit> appendTransactionalAsLeader(UnifiedLog log, long producerId, short producerEpoch, Time time) {
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, time, true);
    }

    public Function1<Object, BoxedUnit> appendIdempotentAsLeader(UnifiedLog log, long producerId, short producerEpoch, Time time, boolean isTransactional) {
        return arg_0 -> LogTestUtils$.$anonfun$appendIdempotentAsLeader$1(IntRef.create((int)0), time, isTransactional, producerId, producerEpoch, log, arg_0);
    }

    public boolean appendIdempotentAsLeader$default$5() {
        return false;
    }

    private static final boolean hasOverflow$1(long baseOffset, RecordBatch batch) {
        return batch.lastOffset() > baseOffset + Integer.MAX_VALUE || batch.baseOffset() < baseOffset;
    }

    public static final /* synthetic */ void $anonfun$firstOverflowSegment$1(Object nonLocalReturnKey1$1, LogSegment segment) {
        if (CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().find((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.hasOverflow$1(segment.baseOffset(), (RecordBatch)batch))).isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)segment));
        }
    }

    private static final SimpleRecord record$1(long offset) {
        byte[] data = Long.toString(offset).getBytes();
        return new SimpleRecord(data, data);
    }

    /*
     * WARNING - void declaration
     */
    private static final long writeSampleBatches$1(long baseOffset, FileRecords segment, File logDir$1) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset)};
        boolean bl = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var4_5 = null;
        simpleRecordArray = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)baseOffset, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + 1L), LogTestUtils$.record$1(baseOffset + 2L)};
        boolean bl2 = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = baseOffset + 1L;
        compressionType = null;
        simpleRecordArray2 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + Integer.MAX_VALUE - 1L)};
        boolean bl3 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = baseOffset + Integer.MAX_VALUE - 1L;
        compressionType2 = null;
        simpleRecordArray3 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        Files.createFile(LogFileUtils.offsetIndexFile((File)logDir$1, (long)baseOffset, (String)"").toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.timeIndexFile((File)logDir$1, (long)baseOffset, (String)"").toPath(), new FileAttribute[0]);
        return baseOffset + Integer.MAX_VALUE;
    }

    private final long writeNormalSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1);
        }
        return l;
    }

    private final long writeOverflowSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1), segment, logDir$1);
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$4(Record record) {
        return record.hasValue() && record.hasKey();
    }

    public static final /* synthetic */ void $anonfun$recoverAndCheck$1(File file) {
        Assertions.assertFalse((boolean)file.getName().endsWith(".deleted"), (String)"Unexpected .deleted file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix()), (String)"Unexpected .cleaned file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix()), (String)"Unexpected .swap file after recovery");
    }

    public static final /* synthetic */ boolean $anonfun$deleteProducerSnapshotFiles$1(File f) {
        return f.isFile() && f.getName().endsWith(".snapshot");
    }

    public static final /* synthetic */ void $anonfun$deleteProducerSnapshotFiles$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendNonTransactionalAsLeader$1(int seq) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(Time time$1, int seq) {
        return new SimpleRecord(time$1.milliseconds(), String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$appendIdempotentAsLeader$1(IntRef sequence$1, Time time$1, boolean isTransactional$1, long producerId$1, short producerEpoch$1, UnifiedLog log$1, int numRecords) {
        MemoryRecords memoryRecords;
        IndexedSeq simpleRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(sequence$1.elem), sequence$1.elem + numRecords).map((Function1 & Serializable)seq -> LogTestUtils$.$anonfun$appendIdempotentAsLeader$2(time$1, BoxesRunTime.unboxToInt((Object)seq)));
        if (isTransactional$1) {
            void withTransactionalRecords_records;
            void withTransactionalRecords_baseSequence;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            int n = sequence$1.elem;
            CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
            memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId$1, (short)producerEpoch$1, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
            Object var10_10 = null;
            simpleRecordArray = null;
        } else {
            void withIdempotentRecords_records;
            void withIdempotentRecords_baseSequence;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            int n = sequence$1.elem;
            CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
            memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId$1, (short)producerEpoch$1, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
            Object var13_13 = null;
            simpleRecordArray = null;
        }
        MemoryRecords records = memoryRecords;
        log$1.appendAsLeader(records, 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        sequence$1.elem += numRecords;
    }

    private LogTestUtils$() {
    }
}

