/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.util.ShutdownableThread;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0005=2A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)\u0001\u0006\u0001C\u0001/!)Q\u0006\u0001C\u0001/\t12\u000b[;uI><h.\u00192mKRC'/Z1e)\u0016\u001cHO\u0003\u0002\b\u0011\u0005)Q\u000f^5mg*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011Q\u0003A\u0007\u0002\r\u0005AA/Z1s\t><h\u000eF\u0001\u0019!\ti\u0011$\u0003\u0002\u001b\u001d\t!QK\\5uQ\t\u0011A\u0004\u0005\u0002\u001eM5\taD\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0005\u0005\u0012\u0013a\u00026va&$XM\u001d\u0006\u0003G\u0011\nQA[;oSRT\u0011!J\u0001\u0004_J<\u0017BA\u0014\u001f\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0014uKN$8\u000b[;uI><hn\u00165f]\u000e\u000bG\u000e\\3e\u0003\u001a$XM\u001d+ie\u0016\fGm\u0015;beRD#a\u0001\u0016\u0011\u0005uY\u0013B\u0001\u0017\u001f\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f^%t)\"\u0014X-\u00193Ti\u0006\u0014H/\u001a3)\u0005\u0011Q\u0003")
public class ShutdownableThreadTest {
    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShutdownWhenCalledAfterThreadStart() {
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(statusCode, x$1) -> ShutdownableThreadTest.$anonfun$testShutdownWhenCalledAfterThreadStart$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_2 = null;
        CountDownLatch latch = new CountDownLatch(1);
        ShutdownableThread thread = new ShutdownableThread(null, latch){
            private final CountDownLatch latch$1;

            public void doWork() {
                this.latch$1.countDown();
                throw new FatalExitError();
            }
            {
                this.latch$1 = latch$1;
                super("shutdownable-thread-test");
            }
        };
        thread.start();
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS), (String)"doWork was not invoked");
        thread.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((Option)statusCodeOption.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Status code was not set by exit procedure");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)((Option)statusCodeOption.elem).get()));
    }

    @Test
    public void testIsThreadStarted() {
        CountDownLatch latch = new CountDownLatch(1);
        ShutdownableThread thread = new ShutdownableThread(null, latch){
            private final CountDownLatch latch$2;

            public void doWork() {
                this.latch$2.countDown();
            }
            {
                this.latch$2 = latch$2;
                super("shutdownable-thread-test");
            }
        };
        Assertions.assertFalse((boolean)thread.isStarted());
        thread.start();
        latch.await();
        Assertions.assertTrue((boolean)thread.isStarted());
        thread.shutdown();
    }

    public static final /* synthetic */ Nothing$ $anonfun$testShutdownWhenCalledAfterThreadStart$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        Thread.sleep(Long.MAX_VALUE);
        throw new AssertionError();
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownWhenCalledAfterThreadStart$2(VolatileObjectRef statusCodeOption$1) {
        return ((Option)statusCodeOption$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testShutdownWhenCalledAfterThreadStart$3() {
        return "Status code was not set by exit procedure";
    }
}

