/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001B,Y\u0001uCQ\u0001\u001a\u0001\u0005\u0002\u0015D\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011B5\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0013\u0019\b\"C=\u0001\u0001\u0004\u0005\t\u0015)\u0003k\u0011%Q\b\u00011AA\u0002\u0013%1\u0010C\u0006\u0002\u0016\u0001\u0001\r\u00111A\u0005\n\u0005]\u0001BCA\u000e\u0001\u0001\u0007\t\u0011)Q\u0005y\"I\u0011Q\u0004\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\"!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u00024!I\u00111\b\u0001C\u0002\u0013%\u0011Q\b\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002@!I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002L!I\u00111\u000b\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u00024!I\u0011q\u000b\u0001C\u0002\u0013%\u0011\u0011\f\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002\\!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBAB\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003\u001b\u0003A\u0011AA6\u0011\u001d\t9\n\u0001C\u0001\u0003WBq!a'\u0001\t\u0003\tY\u0007C\u0004\u0002 \u0002!\t!a\u001b\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002l!9\u0011q\u0015\u0001\u0005\u0002\u0005-\u0004bBAV\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003_\u0003A\u0011AA6\u0011\u001d\t\u0019\f\u0001C\u0001\u0003WBq!a.\u0001\t\u0003\tI\fC\u0004\u00028\u0002!\t!!6\t\u000f\u0005m\u0007\u0001\"\u0001\u0002l!9\u0011q\u001c\u0001\u0005\u0002\u0005-\u0004bBAr\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003O\u0004A\u0011AA6\u0011\u001d\tY\u000f\u0001C\u0001\u0003WBq!a<\u0001\t\u0003\tY\u0007C\u0004\u0002t\u0002!\t!a\u001b\t\u000f\u0005]\b\u0001\"\u0001\u0002l!9\u00111 \u0001\u0005\u0002\u0005-\u0004bBA\u0000\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005\u0007\u0001A\u0011AA6\u0011\u001d\u00119\u0001\u0001C\u0001\u0003WBqAa\u0003\u0001\t\u0003\tY\u0007C\u0004\u0003\u0010\u0001!\t!a\u001b\t\u000f\tM\u0001\u0001\"\u0001\u0002l!9!q\u0003\u0001\u0005\u0002\u0005-\u0004b\u0002B\u000e\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005?\u0001A\u0011AA6\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003WBqAa\n\u0001\t\u0003\tY\u0007C\u0004\u0003,\u0001!\t!a\u001b\t\u000f\t=\u0002\u0001\"\u0001\u0002l!9!1\u0007\u0001\u0005\u0002\u0005-\u0004b\u0002B\u001c\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005w\u0001A\u0011AA6\u0011\u001d\u0011y\u0004\u0001C\u0001\u0003WBqAa\u0011\u0001\t\u0003\tY\u0007C\u0004\u0003H\u0001!\t!a\u001b\t\u000f\t-\u0003\u0001\"\u0001\u0002l!9!q\n\u0001\u0005\u0002\u0005-\u0004b\u0002B*\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005/\u0002A\u0011AA6\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003WBqAa\u0018\u0001\t\u0003\tY\u0007C\u0004\u0003d\u0001!\t!a\u001b\t\u000f\t\u001d\u0004\u0001\"\u0001\u0002l!9!1\u000e\u0001\u0005\u0002\u0005-\u0004b\u0002B8\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005g\u0002A\u0011AA6\u0011\u001d\u00119\b\u0001C\u0001\u0003WBqAa\u001f\u0001\t\u0003\tY\u0007C\u0004\u0003\u0000\u0001!\t!a\u001b\t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\"9!Q\u0017\u0001\u0005\u0002\u0005-\u0004b\u0002B]\u0001\u0011%!1\u0018\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0011%\u0019\u0019\u0002AI\u0001\n\u0013\u0019)\u0002C\u0005\u0004,\u0001\t\n\u0011\"\u0003\u0004.!91\u0011\u0007\u0001\u0005\n\rM\u0002\"CB)\u0001E\u0005I\u0011BB\u0017\u0011%\u0019\u0019\u0006AI\u0001\n\u0013\u0019)\u0006C\u0005\u0004Z\u0001\t\n\u0011\"\u0003\u0004\\!91\u0011\u0007\u0001\u0005\n\r}\u0003bBB:\u0001\u0011%1Q\u000f\u0002\u0019!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:UKN$(BA-[\u0003\rawn\u001a\u0006\u00027\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001_!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u001a\t\u0003O\u0002i\u0011\u0001W\u0001\u0007Y><G)\u001b:\u0016\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\u0005%|'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u0014AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005Q<\bCA0v\u0013\t1\bM\u0001\u0003V]&$\bb\u0002=\u0004\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\rgR\fG/Z'b]\u0006<WM]\u000b\u0002yB\u0019Q0!\u0005\u000e\u0003yT!!W@\u000b\t\u0005\u0005\u00111A\u0001\nS:$XM\u001d8bYNTA!!\u0002\u0002\b\u000591\u000f^8sC\u001e,'bA.\u0002\n)!\u00111BA\u0007\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qB\u0001\u0004_J<\u0017bAA\n}\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0007Q\fI\u0002C\u0004y\r\u0005\u0005\t\u0019\u0001?\u0002\u001bM$\u0018\r^3NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)C\u0003\u0003\u0002(\u0005\u001d\u0011AB2p[6|g.\u0003\u0003\u0002,\u0005\u0015\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\u0011\u00111\u0007\t\u0004?\u0006U\u0012bAA\u001cA\n!Aj\u001c8h\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002/5\f\u0007\u0010\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001bXCAA !\ry\u0016\u0011I\u0005\u0004\u0003\u0007\u0002'aA%oi\u0006AR.\u0019=Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u00025A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\u0005-\u0003cA?\u0002N%\u0019\u0011q\n@\u00035A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u00027A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4!\u0003aa\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj]\u0001\u001aY\u0006$X\r\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\b%\u0001\u0003uS6,WCAA.!\u0011\ti&a\u0019\u000e\u0005\u0005}#\u0002BA1\u0003K\tQ!\u001e;jYNLA!!\u001a\u0002`\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0003tKR,\u0006\u000fF\u0001uQ\r!\u0012q\u000e\t\u0005\u0003c\ny(\u0004\u0002\u0002t)!\u0011QOA<\u0003\r\t\u0007/\u001b\u0006\u0005\u0003s\nY(A\u0004kkBLG/\u001a:\u000b\t\u0005u\u0014QB\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0003\u000b\u0019H\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004+\u0005\u001d\u0005\u0003BA9\u0003\u0013KA!a#\u0002t\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0013i\u0016\u001cHOQ1tS\u000eLE-T1qa&tw\rK\u0002\u0017\u0003#\u0003B!!\u001d\u0002\u0014&!\u0011QSA:\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f^!qa\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:XSRDgj\u001c)s_\u0012,8-\u001a:Ti\u0006$X\rK\u0002\u0018\u0003#\u000ba\u0004^3tiB\u0013x\u000eZ;dKJ\u001cV-];f]\u000e,wK]1q\u0003J|WO\u001c3)\u0007a\t\t*A\u0017uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z,ji\"<&/\u00199Be>,h\u000e\u001a\"bi\u000eD'+Z2pe\u0012D3!GAI\u0003\u0015\"Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK&sg/\u00197jI^\u0013\u0018\r]!s_VtG\rK\u0002\u001b\u0003#\u000b!\u0006^3ti:{g+\u00197jI\u0006$\u0018n\u001c8P]\u001aK'o\u001d;F]R\u0014\u0018p\u00165f]2{\u0017\rZ5oO2{w\rK\u0002\u001c\u0003#\u000b1\u0005^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:e\u0005Vl\u0007o\u001d)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eK\u0002\u001d\u0003#\u000b\u0001\u0005^3tiRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006\u001c\u0015m\u00195fI\"\u001aQ$!%\u00023Q,7\u000f^*lSB,U\u000e\u001d;z)J\fgn]1di&|gn\u001d\u0015\u0004=\u0005E\u0015aF1tg\u0016\u0014H\u000f\u0016=o\u001b\u0016$\u0018\rZ1uC\u0016\u000bX/\u00197t)\u0015!\u00181XAi\u0011\u001d\til\ba\u0001\u0003\u007f\u000b\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0007\u0003\u0003\f9-a3\u000e\u0005\u0005\r'bAAc]\u0006!Q\u000f^5m\u0013\u0011\tI-a1\u0003\t1K7\u000f\u001e\t\u0004{\u00065\u0017bAAh}\nYA\u000b\u001f8NKR\fG-\u0019;b\u0011\u001d\t\u0019n\ba\u0001\u0003\u007f\u000ba!Y2uk\u0006dG#\u0002;\u0002X\u0006e\u0007bBA_A\u0001\u0007\u00111\u001a\u0005\b\u0003'\u0004\u0003\u0019AAf\u0003Y!Xm\u001d;ICNd\u0015\r^3Ue\u0006t7/Y2uS>t\u0007fA\u0011\u0002\u0012\u0006aC/Z:u\u0011\u0006\u001cH*\u0019;f)J\fgn]1di&|g.\u00138ji&\fG.\u001b>fI\u00063G/\u001a:SK2|\u0017\r\u001a\u0015\u0004E\u0005E\u0015a\r;fgRD\u0015m\u001d'bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8Va\u0012\fG/\u001a3BMR,'\u000fU1si&\fG\u000e\u0016:v]\u000e\fG/[8oQ\r\u0019\u0013\u0011S\u00011i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]V\u0003H-\u0019;fI\u00063G/\u001a:Gk2dGK];oG\u0006$\u0018n\u001c8)\u0007\u0011\n\t*\u0001\u0011uKN$H*Y:u'R\f'\r\\3PM\u001a\u001cX\r^\"p[BdW\r^3e)bt\u0007fA\u0013\u0002\u0012\u0006qB/Z:u!J,\u0007/\u0019:f+B$\u0017\r^3E_\u0016\u001chj\u001c;NkR\fG/\u001a\u0015\u0004M\u0005E\u0015AH;qI\u0006$X\r\u0015:pIV\u001cWM\u001d+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;fQ\r9\u0013\u0011S\u0001-i\u0016\u001cHoT;u\u001f\u001a\u001cV-];f]\u000e,\u0017I\u001a;fe\u000e{g\u000e\u001e:pYJ+7m\u001c:e\u000bB|7\r\u001b\"v[BD3\u0001KAI\u0003A\"Xm\u001d;O_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0003\b/\u001a8e/&$\bn\u00148h_&tw\r\u0016:b]N\f7\r^5p]\"\u001a\u0011&!%\u0002_Q,7\u000f\u001e+sk:\u001c\u0017\r^3B]\u0012\u0014V\r\\8bIJ+Wn\u001c<fg>+Ho\u00144SC:<Wm\u00158baNDw\u000e^:)\u0007)\n\t*\u0001\tuKN$H+Y6f':\f\u0007o\u001d5pi\"\u001a1&!%\u0002=Q,7\u000f\u001e$fi\u000eD7K\\1qg\"|G/R7qif\u001cf.\u00199TQ>$\bf\u0001\u0017\u0002\u0012\u0006aC/Z:u%\u0016\u001cwN^3s\rJ|Wn\u00158baNDw\u000e^+oM&t\u0017n\u001d5fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004[\u0005E\u0015A\u000b;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\r&t\u0017n\u001d5fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004]\u0005E\u0015a\n;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\u000b6\u0004H/\u001f+sC:\u001c\u0018m\u0019;j_:D3aLAI\u0003!\"Xm\u001d;Qe>$WoY3s'R\fG/Z!gi\u0016\u0014h)\u001a8dS:<\u0017IY8si6\u000b'o[3sQ\r\u0001\u0014\u0011S\u0001\u001ei\u0016\u001cHOU3n_Z,W\t\u001f9je\u0016$\u0007+\u001b3t\u001f:\u0014V\r\\8bI\"\u001a\u0011'!%\u0002[Q,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i_V$\bK]8ek\u000e,'o\u0015;bi\u0016|eNU3qY&\u001c\u0017\rK\u00023\u0003#\u000b\u0011\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRD7+Z9vK:\u001cWmR1qg>s'+\u001a9mS\u000e\f\u0007fA\u001a\u0002\u0012\u0006IB/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\n+gm\u001c:fQ\r!\u0014\u0011S\u0001\u001ci\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;)\u0007U\n\t*A\nuKN$(+\u001a7pC\u0012\u001cf.\u00199tQ>$8\u000fK\u00027\u0003#\u000ba\u0005^3ti\u001aK'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\r9\u0014\u0011S\u0001/i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;SKR\f\u0017N\\:O_:,\u0005\u0010]5sK\u0012\u0004&o\u001c3vG\u0016\u00148\u000fK\u00029\u0003#\u000b\u0011\u0005^3tiN[\u0017\u000e]*oCB\u001c\bn\u001c;JM>3gm]3u+:\u001c\u0007.\u00198hK\u0012D3!OAI\u0003a!Xm\u001d;QS\u0012,\u0005\u0010]5sCRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0004u\u0005E\u0015a\u0006;fgR4\u0015N]:u+:\u001cH/\u00192mK>3gm]3uQ\rY\u0014\u0011S\u0001/i\u0016\u001cH\u000f\u0015:pIV\u001cWM]:XSRDwJ\\4pS:<GK]1og\u0006\u001cG/[8og\u0012{g\u000e^#ya&\u0014X\rK\u0002=\u0003#\u000bQ\u0006^3tiN+\u0017/^3oG\u0016tu\u000e\u001e,bY&$\u0017\r^3e\r>\u0014xI]8va6+G/\u00193bi\u0006$v\u000e]5dQ\ri\u0014\u0011S\u0001\u001di\u0016\u001cHo\u00147e\u000bB|7\r\u001b$pe\u000e{g\u000e\u001e:pYJ+7m\u001c:eQ\rq\u0014\u0011S\u0001\u0017i\u0016\u001cHoQ8pe\u0012Lg.\u0019;pe\u001a+gnY5oO\"\u001aq(!%\u0002AQ,7\u000f^\"p_J$\u0017N\\1u_J4UM\\2fI\u00063G/\u001a:SK2|\u0017\r\u001a\u0015\u0004\u0001\u0006E\u0015!\b;fgRdu.\u00193Ge>lW)\u001c9usNs\u0017\r]:i_R4\u0015\u000e\\3)\u0007\u0005\u000b\t*A\u0011uKN$Hj\\1e\rJ|W\u000e\u0016:v]\u000e\fG/\u001a3T]\u0006\u00048\u000f[8u\r&dW\rK\u0002C\u0003#\u000bq\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$h)\u001b7fQ\r\u0019\u0015\u0011S\u0001\u001ci\u0016\u001cH/\u00119qK:$W)\u001c9us\u000e{g\u000e\u001e:pY\n\u000bGo\u00195)\u0007\u0011\u000b\t*A\u0019uKN$(+Z7pm\u0016\u001cFO]1z':\f\u0007o\u001d5piN\\U-\u001a9DY\u0016\fgn\u00155vi\u0012|wO\\*oCB\u001c\bn\u001c;)\u0007\u0015\u000b\t*A\u000euKN$(+Z7pm\u0016\fE\u000e\\*ue\u0006L8K\\1qg\"|Go\u001d\u0015\u0004\r\u0006E\u0015\u0001\n;fgR\u0014V-\\8wK\u0006sG-T1sWNs\u0017\r]:i_R4uN\u001d#fY\u0016$\u0018n\u001c8)\u0007\u001d\u000b\t*\u0001\u001auKN$(+Z7pm\u0016\fe\u000eZ'be.\u001cf.\u00199tQ>$hi\u001c:EK2,G/[8o\u00032\u0014X-\u00193z\t\u0016dW\r^3eQ\rA\u0015\u0011S\u0001\u0019i\u0016\u001cH/\u00128uef4uN\u001d,fe&4\u0017nY1uS>t\u0007fA%\u0002\u0012\u00069C/Z:u'\u0016\fX/\u001a8dK\u0006sG-\u00129pG\"LeNV3sS\u001aL7-\u0019;j_:,e\u000e\u001e:zQ\rQ\u0015\u0011S\u00019i\u0016\u001cH\u000f\u00165s_^|U\u000f^(g\u001fJ$WM]*fcV,gnY3XSRDg+\u001a:jM&\u001c\u0017\r^5p]N+\u0017/^3oG\u0016\u001c\u0005.Z2l)\r!(q\u0011\u0005\b\u0005\u0013[\u0005\u0019\u0001BF\u0003I!\u0017P\\1nS\u000e\fG\u000e\\=ESN\f'\r\\3\u0011\u0007}\u0013i)C\u0002\u0003\u0010\u0002\u0014qAQ8pY\u0016\fg\u000eK\u0002L\u0005'\u0003BA!&\u0003\u001c6\u0011!q\u0013\u0006\u0005\u00053\u000b9(\u0001\u0004qCJ\fWn]\u0005\u0005\u0005;\u00139JA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDsa\u0013BQ\u0005[\u0013y\u000b\u0005\u0003\u0003$\n%VB\u0001BS\u0015\u0011\u00119Ka&\u0002\u0011A\u0014xN^5eKJLAAa+\u0003&\nYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006\u0002BY\u0005gK\u0012!A\r\u0002\u0001\u0005!C/Z:u-\u0016\u0014\u0018NZ5dCRLwN\\*uCR,WI\u001c;ss\u0016C\b/\u001b:bi&|g\u000eK\u0002M\u0003#\u000b1\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$Hc\u0001;\u0003>\"9!qX'A\u0002\t\u0005\u0017aD7bW\u00164\u0015\u000e\\3D_J\u0014X\u000f\u001d;\u0011\r}\u0013\u0019Ma2u\u0013\r\u0011)\r\u0019\u0002\n\rVt7\r^5p]F\u0002BA!3\u0003T6\u0011!1\u001a\u0006\u0005\u0005\u001b\u0014y-\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011\tN\\\u0001\u0004]&|\u0017\u0002\u0002Bk\u0005\u0017\u00141BR5mK\u000eC\u0017M\u001c8fY\u0006\u0011\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3s)A\u0011YNa:\u0003l\n5(q_B\u0004\u0007\u0017\u0019y\u0001E\u0003`\u0005;\u0014\t/C\u0002\u0003`\u0002\u0014aa\u00149uS>t\u0007cA?\u0003d&\u0019!Q\u001d@\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\r\t%h\n1\u0001}\u0003\u001di\u0017\r\u001d9j]\u001eDq!a\fO\u0001\u0004\t\u0019\u0004C\u0004\u0003p:\u0003\rA!=\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\ry&1_\u0005\u0004\u0005k\u0004'!B*i_J$\bb\u0002B}\u001d\u0002\u0007!1`\u0001\fG>tGO]8m)f\u0004X\r\u0005\u0003\u0003~\u000e\rQB\u0001B\u0000\u0015\u0011\u0019\t!!\n\u0002\rI,7m\u001c:e\u0013\u0011\u0019)Aa@\u0003#\r{g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\rC\u0004\u0004\n9\u0003\r!a\r\u0002\r=4gm]3u\u0011%\u0019iA\u0014I\u0001\u0002\u0004\ty$\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"I1\u0011\u0003(\u0011\u0002\u0003\u0007\u00111G\u0001\ni&lWm\u001d;b[B\fA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0004\u0018)\"\u0011qHB\rW\t\u0019Y\u0002\u0005\u0003\u0004\u001e\r\u001dRBAB\u0010\u0015\u0011\u0019\tca\t\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0013A\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r%2q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001H1qa\u0016tG-\u00128e)btW*\u0019:lKJ$C-\u001a4bk2$HeN\u000b\u0003\u0007_QC!a\r\u0004\u001a\u00051\u0011\r\u001d9f]\u0012$\u0012\u0003^B\u001b\u0007o\u0019Ida\u000f\u0004@\r\u000531IB$\u0011\u0015Q\u0018\u000b1\u0001}\u0011\u001d\ty#\u0015a\u0001\u0003gAqAa<R\u0001\u0004\u0011\t\u0010C\u0004\u0004>E\u0003\r!a\u0010\u0002\u0007M,\u0017\u000fC\u0004\u0004\nE\u0003\r!a\r\t\u0013\rE\u0011\u000b%AA\u0002\u0005M\u0002\"CB##B\u0005\t\u0019\u0001BF\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007\"CB%#B\u0005\t\u0019AB&\u0003\u0019y'/[4j]B\u0019Qp!\u0014\n\u0007\r=cP\u0001\u0007BaB,g\u000eZ(sS\u001eLg.\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HeN\u000b\u0003\u0007/RCAa#\u0004\u001a\u0005\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007;RCaa\u0013\u0004\u001aQYAo!\u0019\u0004d\r\u00154qMB9\u0011\u0015QX\u000b1\u0001}\u0011\u001d\ty#\u0016a\u0001\u0003gAqa!\u0003V\u0001\u0004\t\u0019\u0004C\u0004\u0004jU\u0003\raa\u001b\u0002\u000b\t\fGo\u00195\u0011\t\tu8QN\u0005\u0005\u0007_\u0012yPA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007bBB%+\u0002\u000711J\u0001\u0017GV\u0014(/\u001a8u':\f\u0007o\u001d5pi>3gm]3ugV\u00111q\u000f\t\u0007\u0007s\u001a9)a\r\u000f\t\rm41\u0011\t\u0004\u0007{\u0002WBAB@\u0015\r\u0019\t\tX\u0001\u0007yI|w\u000e\u001e \n\u0007\r\u0015\u0005-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007\u0013\u001bYIA\u0002TKRT1a!\"a\u0001")
public class ProducerStateManagerTest {
    private File logDir;
    private ProducerStateManager stateManager;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), true);
    private final long lateTransactionTimeoutMs = (long)this.maxTransactionTimeoutMs() + 300000L;
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private long lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, AppendOrigin.CLIENT));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, AppendOrigin.CLIENT);
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.REPLICATION);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L), 2020L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), this.stateManager().lastEntry(this.producerId()).map(x$3 -> BoxesRunTime.boxToLong((long)x$3.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry.empty((long)this.producerId()), AppendOrigin.CLIENT, this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), seq, producerEpoch));
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals(Optional.of(firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), 16L), (TxnMetadata)firstAppend.startedTransactions().get(0));
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        int size = secondAppend.startedTransactions().size();
        Assertions.assertEquals((int)2, (int)size);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L)), (TxnMetadata)secondAppend.startedTransactions().get(0));
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L)), (TxnMetadata)secondAppend.startedTransactions().get(size - 1));
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(30L)), (Object)this.stateManager().firstUnstableOffset());
    }

    public void assertTxnMetadataEquals(List<TxnMetadata> expected, List<TxnMetadata> actual) {
        Iterator<TxnMetadata> expectedIter = expected.iterator();
        Iterator<TxnMetadata> actualIter = actual.iterator();
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            this.assertTxnMetadataEquals(expectedIter.next(), actualIter.next());
        }
    }

    public void assertTxnMetadataEquals(TxnMetadata expected, TxnMetadata actual) {
        Assertions.assertEquals((long)expected.producerId, (long)actual.producerId);
        Assertions.assertEquals((Object)expected.firstOffset, (Object)actual.firstOffset);
        Assertions.assertEquals((Object)expected.lastOffset, (Object)actual.lastOffset);
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), this.time().milliseconds());
        Assertions.assertTrue((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L), 20L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, AppendOrigin.CLIENT);
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Optional completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isPresent());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId);
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset);
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset);
        Assertions.assertFalse((boolean)completedTxn.isAborted);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = AppendOrigin.CLIENT;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = AppendOrigin.CLIENT;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = AppendOrigin.CLIENT;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = AppendOrigin.CLIENT;
            this.append(x$9, x$10, epoch, 1, 1L, x$15, false, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())))), (String)"Snapshot file is empty");
    }

    @Test
    public void testFetchSnapshotEmptySnapShot() {
        int offset = 1;
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().fetchSnapshot((long)offset));
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = AppendOrigin.CLIENT;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$7 = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Optional lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isPresent());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)recoveredMapping.activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        boolean x$8 = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, x$8, AppendOrigin.REPLICATION);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)recoveredMapping.activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            boolean x$8 = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, x$8, AppendOrigin.CLIENT);
        });
        Assertions.assertTrue((boolean)this.stateManager().activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((long)0L, (long)producerStateEntry.lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        boolean x$16 = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, x$16, AppendOrigin.REPLICATION);
        ProducerStateEntry producerStateEntryForReplication = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntryForReplication);
        Assertions.assertEquals((int)outOfOrderSequence, (int)producerStateEntryForReplication.lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testReloadSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Object[] pathAndDataList = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> new Tuple2((Object)file.toPath(), (Object)Files.readAllBytes(file.toPath())), ClassTag$.MODULE$.apply(Tuple2.class));
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.currentSnapshotOffsets());
        this.stateManager().truncateAndReload(3L, 5L, this.time().milliseconds());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.currentSnapshotOffsets());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(pathAndDataList), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                byte[] data = (byte[])x0$1._2();
                return Files.write(path, data, new OpenOption[0]);
            }
            throw new MatchError(null);
        });
        this.stateManager().truncateFullyAndReloadSnapshots();
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Optional entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Optional entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)this.stateManager().activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, anotherPid, epoch, sequence, 105L, x$15, true, x$16);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.of(105L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, AppendOrigin.COORDINATOR);
        long x$10 = this.producerId();
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, AppendOrigin.COORDINATOR);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Optional lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), lastEntry.map(x -> BoxesRunTime.boxToInteger((int)x.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, AppendOrigin.CLIENT);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(5L)));
        Assertions.assertEquals((Object)OptionalLong.of(42L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(5L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(42L)));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(".deleted"));
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Files.delete(file.toPath());
        Assertions.assertTrue((!manager.removeAndMarkSnapshotForDeletion(5L).isPresent() ? 1 : 0) != 0);
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testEntryForVerification() {
        VerificationGuard originalEntryVerificationGuard = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0).verificationGuard();
        VerificationStateEntry updatedEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$1(this.producerId(), updatedEntry, originalEntryVerificationGuard);
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, (short)0, 0, 0L, x$7, true, x$8);
        this.stateManager().clearVerificationStateEntry(this.producerId());
        Assertions.assertNull((Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testSequenceAndEpochInVerificationEntry() {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 1, (short)0);
        VerificationGuard originalEntryVerificationGuard = originalEntry.verificationGuard();
        this.verifyEntry$2(this.producerId(), originalEntry, 1, (short)0, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$2(this.producerId(), updatedEntry, 0, (short)0, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntryNewEpoch = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 2, (short)1);
        this.verifyEntry$2(this.producerId(), updatedEntryNewEpoch, 2, (short)1, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntryOldEpoch = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$2(this.producerId(), updatedEntryOldEpoch, 2, (short)1, originalEntryVerificationGuard);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testThrowOutOfOrderSequenceWithVerificationSequenceCheck(boolean dynamicallyDisable) {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        if (dynamicallyDisable) {
            this.producerStateManagerConfig().setTransactionVerificationEnabled(false);
        }
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$7 = this.append$default$6();
            AppendOrigin x$8 = AppendOrigin.CLIENT;
            this.append(x$1, x$2, (short)0, 4, 0L, x$7, true, x$8);
        });
        Assertions.assertEquals((Object)originalEntry, (Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testVerificationStateEntryExpiration() {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() / 2));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertEquals((Object)originalEntry, (Object)this.stateManager().verificationStateEntry(this.producerId()));
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() / 2 + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertNull((Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)latestSnapshotOffset);
        File snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)latestSnapshotOffset.getAsLong());
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)loadedProducerState);
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, AppendOrigin.COORDINATOR);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp)));
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable)x$1 -> {
            mapping.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, Optional.empty());
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.CLIENT;
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)UnifiedLog$.MODULE$.offsetFromFile(file)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds())));
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry.empty((long)producerId), AppendOrigin.CLIENT, this.stateManager().maybeCreateVerificationStateEntry(producerId, 0, producerEpoch$3));
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap(new byte[]{37}), file.size() / 2L);
    }

    private final void verifyEntry$1(long producerId, VerificationStateEntry newEntry, VerificationGuard originalEntryVerificationGuard$1) {
        VerificationStateEntry entry = this.stateManager().verificationStateEntry(producerId);
        Assertions.assertEquals((Object)originalEntryVerificationGuard$1, (Object)entry.verificationGuard());
        Assertions.assertEquals((Object)entry.verificationGuard(), (Object)newEntry.verificationGuard());
    }

    private final void verifyEntry$2(long producerId, VerificationStateEntry newEntry, int expectedSequence, short expectedEpoch, VerificationGuard originalEntryVerificationGuard$2) {
        VerificationStateEntry entry = this.stateManager().verificationStateEntry(producerId);
        Assertions.assertEquals((Object)originalEntryVerificationGuard$2, (Object)entry.verificationGuard());
        Assertions.assertEquals((Object)entry.verificationGuard(), (Object)newEntry.verificationGuard());
        Assertions.assertEquals((int)expectedSequence, (int)entry.lowestSequence());
        Assertions.assertEquals((short)expectedEpoch, (short)entry.epoch());
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

