/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.DelayedRemoteFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00042\u0001\u0001\u0006IA\f\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u00199\u0004\u0001)A\u0005i!9\u0001\b\u0001b\u0001\n\u0013I\u0004BB#\u0001A\u0003%!\bC\u0004G\u0001\t\u0007I\u0011B$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u001da\u0005A1A\u0005\n\u001dCa!\u0014\u0001!\u0002\u0013A\u0005b\u0002(\u0001\u0005\u0004%Ia\u0014\u0005\u0007=\u0002\u0001\u000b\u0011\u0002)\t\u000f}\u0003!\u0019!C\u0005A\"1A\r\u0001Q\u0001\n\u0005Dq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004r\u0001\u0001\u0006Ia\u001a\u0005\u0006e\u0002!\ta\u001d\u0005\u0007\u0003\u000b\u0001A\u0011A:\t\r\u0005%\u0001\u0001\"\u0001t\u0011\u0019\ti\u0001\u0001C\u0001g\"1\u0011\u0011\u0003\u0001\u0005\u0002MDq!!\u0006\u0001\t\u0013\t9\u0002C\u0004\u0002\"\u0001!I!a\t\t\u0013\u0005\r\u0003!%A\u0005\n\u0005\u0015\u0003\"CA.\u0001E\u0005I\u0011BA#\u0005Y!U\r\\1zK\u0012\u0014V-\\8uK\u001a+Go\u00195UKN$(BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00029\u0005AQ.\u0019=CsR,7/F\u0001/!\t\u0019s&\u0003\u00021I\t\u0019\u0011J\u001c;\u0002\u00135\f\u0007PQ=uKN\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002iA\u00111&N\u0005\u0003mq\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.F\u0001;!\tY4)D\u0001=\u0015\tid(\u0001\u0004d_6lwN\u001c\u0006\u0003?}R!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO&\u0011A\t\u0010\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8!\u0003-1W\r^2i\u001f\u001a47/\u001a;\u0016\u0003!\u0003\"aI%\n\u0005)##\u0001\u0002'p]\u001e\fABZ3uG\"|eMZ:fi\u0002\na\u0002\\8h'R\f'\u000f^(gMN,G/A\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;!\u0003I\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195\u0016\u0003A\u00032!\u0015,Y\u001b\u0005\u0011&BA*U\u0003\u0011)H/\u001b7\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\t\u001fB$\u0018n\u001c8bYB\u0011\u0011\fX\u0007\u00025*\u00111\fV\u0001\u0005Y\u0006tw-\u0003\u0002^5\n9\u0011J\u001c;fO\u0016\u0014\u0018aE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\u0004\u0013a\u00034fi\u000eD7\u000b^1ukN,\u0012!\u0019\t\u0003W\tL!a\u0019\u000f\u0003)\u0019+Go\u00195QCJ$\u0018\u000e^5p]N#\u0018\r^;t\u000311W\r^2i'R\fG/^:!\u0003-1W\r^2i!\u0006\u0014\u0018-\\:\u0016\u0003\u001d\u0004\"\u0001[8\u000e\u0003%T!A[6\u0002\u00071|wM\u0003\u0002m[\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003]z\nqa\u001d;pe\u0006<W-\u0003\u0002qS\nYa)\u001a;dQB\u000b'/Y7t\u000311W\r^2i!\u0006\u0014\u0018-\\:!\u0003%!Xm\u001d;GKR\u001c\u0007\u000eF\u0001u!\t\u0019S/\u0003\u0002wI\t!QK\\5uQ\t\u0011\u0002\u0010E\u0002z\u0003\u0003i\u0011A\u001f\u0006\u0003wr\f1!\u00199j\u0015\tih0A\u0004kkBLG/\u001a:\u000b\u0005}\f\u0015!\u00026v]&$\u0018bAA\u0002u\n!A+Z:u\u0003E!Xm\u001d;G_2dwn^3s\r\u0016$8\r\u001b\u0015\u0003'a\fq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0005QA\u0018\u0001\u0006;fgR,%O]8s\u0019><'+Z1e\u0013:4w\u000e\u000b\u0002\u0016q\u0006\tB/Z:u%\u0016\fX/Z:u\u000bb\u0004\u0018N]=)\u0005YA\u0018\u0001\u00052vS2$g)\u001a;dQB\u000b'/Y7t)\u00159\u0017\u0011DA\u000f\u0011\u0019\tYb\u0006a\u0001]\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\u0007\u0003?9\u0002\u0019\u0001\u0018\u0002\u00135\f\u0007pV1ji6\u001b\u0018a\u00042vS2$'+Z1e%\u0016\u001cX\u000f\u001c;\u0015\u0011\u0005\u0015\u00121FA\u001e\u0003\u007f\u00012aKA\u0014\u0013\r\tI\u0003\b\u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\t\u000f\u00055\u0002\u00041\u0001\u00020\u0005)QM\u001d:peB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026q\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\u0004FeJ|'o\u001d\u0005\t\u0003{A\u0002\u0013!a\u0001]\u0005i\u0001.[4i/\u0006$XM]7be.D\u0001\"!\u0011\u0019!\u0003\u0005\rAL\u0001\u0015Y\u0016\fG-\u001a:M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u00023\t,\u0018\u000e\u001c3SK\u0006$'+Z:vYR$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fR3ALA%W\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA+I\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0013q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00072vS2$'+Z1e%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uIM\u0002")
public class DelayedRemoteFetchTest {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
    private final long fetchOffset;
    private final long logStartOffset;
    private final Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
    private final FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(this.fetchOffset()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, this.fetchOffset(), this.logStartOffset(), this.maxBytes(), this.currentLeaderEpoch()));
    private final FetchParams fetchParams = this.buildFetchParams(-1, 500);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    private long fetchOffset() {
        return this.fetchOffset;
    }

    private long logStartOffset() {
        return this.logStartOffset;
    }

    private Optional<Integer> currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    private FetchPartitionStatus fetchStatus() {
        return this.fetchStatus;
    }

    private FetchParams fetchParams() {
        return this.fetchParams;
    }

    @Test
    public void testFetch() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$1(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)actualTopicPartition.elem).isDefined());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
        Assertions.assertEquals((long)highWatermark, (long)fetchResult.highWatermark);
        Assertions.assertEquals((long)leaderLogStartOffset, (long)fetchResult.logStartOffset);
    }

    @Test
    public void testFollowerFetch() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        FetchParams fetchParams = this.buildFetchParams(1, 500);
        Assertions.assertThrows(IllegalStateException.class, () -> new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$2(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        }));
    }

    @Test
    public void testNotLeaderOrFollower() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(this.topicIdPartition()).append(" not available").toString())});
        CompletableFuture future = new CompletableFuture();
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, 0, 0);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$3(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testErrorLogReadInfo() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        LogReadResult logReadInfo = this.buildReadResult(Errors.FENCED_LEADER_EPOCH, 0, 0);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$4(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)((FetchPartitionData)((Option)fetchResultOpt.elem).get()).error);
    }

    @Test
    public void testRequestExpiry() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        Future remoteFetchTask = (Future)Mockito.mock(Future.class);
        CompletableFuture future = new CompletableFuture();
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null, false);
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(remoteFetchTask, future, fetchInfo, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$5(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteFetchTest.$anonfun$testRequestExpiry$2(x$1))));
        delayedRemoteFetch.run();
        ((Future)Mockito.verify((Object)remoteFetchTask)).cancel(true);
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteFetchTest.$anonfun$testRequestExpiry$3(x$2))));
        Assertions.assertTrue((boolean)((Option)actualTopicPartition.elem).isDefined());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
        Assertions.assertEquals((long)highWatermark, (long)fetchResult.highWatermark);
        Assertions.assertEquals((long)leaderLogStartOffset, (long)fetchResult.logStartOffset);
    }

    private FetchParams buildFetchParams(int replicaId, int maxWaitMs) {
        return new FetchParams(ApiKeys.FETCH.latestVersion(), replicaId, 1L, (long)maxWaitMs, 1, this.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
    }

    private LogReadResult buildReadResult(Errors error, int highWatermark, int leaderLogStartOffset) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY);
        None$ x$3 = None$.MODULE$;
        long x$4 = highWatermark;
        long x$5 = leaderLogStartOffset;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        return new LogReadResult(x$2, (Option)x$3, x$4, x$5, -1L, -1L, -1L, (Option)x$9, (Option)x$10, (Option)x$1);
    }

    private int buildReadResult$default$2() {
        return 0;
    }

    private int buildReadResult$default$3() {
        return 0;
    }

    private static final void callback$1(Seq responses, ObjectRef actualTopicPartition$1, ObjectRef fetchResultOpt$1) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$1.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef actualTopicPartition$2, ObjectRef fetchResultOpt$2) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$2.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef actualTopicPartition$3, ObjectRef fetchResultOpt$3) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$3.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef actualTopicPartition$4, ObjectRef fetchResultOpt$4) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$4.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$5(Seq responses, ObjectRef actualTopicPartition$5, ObjectRef fetchResultOpt$5) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$5.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$5.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testRequestExpiry$2(MetricName x$1) {
        String string = x$1.getMBeanName();
        String string2 = "kafka.server:type=DelayedRemoteFetchMetrics,name=ExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testRequestExpiry$3(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.server:type=DelayedRemoteFetchMetrics,name=ExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public DelayedRemoteFetchTest() {
        this.maxBytes = 1024;
        this.fetchOffset = 500L;
        this.logStartOffset = 0L;
    }
}

