/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.test.ClusterInstance;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.utils.NotNothing;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.junit.jupiter.api.Assertions;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\rug\u0001\u0002 @\u0001\u0011C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006%\u0002!\ta\u0015\u0005\u0006/\u0002!I\u0001\u0017\u0005\u0006Q\u0002!I!\u001b\u0005\u0006]\u0002!\tb\u001c\u0005\u0006g\u0002!\t\u0002\u001e\u0005\b\u0003\u0013\u0001A\u0011CA\u0006\u0011\u001d\t\u0019\u0002\u0001C\t\u0003\u0017Aq!!\u0006\u0001\t#\t9\u0002C\u0004\u0002^\u0001!\t\"a\u0018\t\u000f\u0005u\u0003\u0001\"\u0005\u0002\u0014\"9\u0011Q\u0015\u0001\u0005\u0012\u0005\u001d\u0006\"CA]\u0001E\u0005I\u0011CA^\u0011%\t\t\u000eAI\u0001\n#\tY\fC\u0004\u0002T\u0002!I!!6\t\u000f\u0005m\u0007\u0001\"\u0005\u0002^\"I!Q\u0005\u0001\u0012\u0002\u0013E!q\u0005\u0005\n\u0005W\u0001\u0011\u0013!C\t\u0005OA\u0011B!\f\u0001#\u0003%\tBa\f\t\u0013\tM\u0002!%A\u0005\u0012\t\u001d\u0002\"\u0003B\u001b\u0001E\u0005I\u0011\u0003B\u0014\u0011%\u00119\u0004AI\u0001\n#\u0011I\u0004C\u0005\u0003>\u0001\t\n\u0011\"\u0005\u0002<\"I!q\b\u0001\u0012\u0002\u0013E!\u0011\t\u0005\b\u0005\u000b\u0002A\u0011\u0003B$\u0011%\u0011\t\u0007AI\u0001\n#\u00119\u0003C\u0005\u0003d\u0001\t\n\u0011\"\u0005\u0003(!I!Q\r\u0001\u0012\u0002\u0013E!q\u0005\u0005\n\u0005O\u0002\u0011\u0013!C\t\u0005OA\u0011B!\u001b\u0001#\u0003%\tB!\u000f\t\u0013\t-\u0004!%A\u0005\u0012\t\u0005\u0003b\u0002B7\u0001\u0011E!q\u000e\u0005\n\u0005\u0007\u0003\u0011\u0013!C\t\u0005sA\u0011B!\"\u0001#\u0003%\tB!\u000f\t\u0013\t\u001d\u0005!%A\u0005\u0012\t%\u0005b\u0002BG\u0001\u0011E!q\u0012\u0005\n\u00053\u0003\u0011\u0013!C\t\u0005sA\u0011Ba'\u0001#\u0003%\tB!#\t\u000f\tu\u0005\u0001\"\u0005\u0003 \"9!1\u0015\u0001\u0005\u0012\t\u0015\u0006b\u0002BW\u0001\u0011E!q\u0016\u0005\b\u0005\u0013\u0004A\u0011\u0003Bf\u0011%\u0011\u0019\u000fAI\u0001\n#\u0011\t\u0005C\u0004\u0003f\u0002!\tBa:\t\u0013\tm\b!%A\u0005\u0012\t\u001d\u0002\"\u0003B\u007f\u0001E\u0005I\u0011CA^\u0011\u001d\u0011y\u0010\u0001C\t\u0007\u0003A\u0011ba\u000e\u0001#\u0003%\tBa\n\t\u0013\re\u0002!%A\u0005\u0012\rm\u0002\"CB \u0001E\u0005I\u0011\u0003B\u0014\u0011%\u0019\t\u0005AI\u0001\n#\u00119\u0003C\u0005\u0004D\u0001\t\n\u0011\"\u0005\u0004<!I1Q\t\u0001\u0012\u0002\u0013E!q\u0005\u0005\n\u0007\u000f\u0002\u0011\u0013!C\t\u0007\u0013B\u0011b!\u0014\u0001#\u0003%\tba\u0014\t\u000f\rM\u0003\u0001\"\u0005\u0004V!911\f\u0001\u0005\u0012\ru\u0003\"CB;\u0001E\u0005I\u0011CB%\u0011\u001d\u00199\b\u0001C\t\u0007sBqaa!\u0001\t#\u0019)\tC\u0004\u0004\u0010\u0002!\tb!%\u0003?\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014()Y:f%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002A\u0003\u000611/\u001a:wKJT\u0011AQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\ti\u0005+D\u0001O\u0015\ty\u0015)\u0001\u0003uKN$\u0018BA)O\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002U-B\u0011Q\u000bA\u0007\u0002\u007f!)1J\u0001a\u0001\u0019\u00069!M]8lKJ\u001cH#A-\u0011\u0007i\u0013WM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011alQ\u0001\u0007yI|w\u000e\u001e \n\u0003!K!!Y$\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0004'\u0016\f(BA1H!\t)f-\u0003\u0002h\u007f\tY1*\u00194lC\n\u0013xn[3s\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o\u001d\u000b\u0002UB\u0019!LY6\u0011\u0005Uc\u0017BA7@\u0005A\u0019uN\u001c;s_2dWM]*feZ,'/\u0001\nde\u0016\fG/Z(gMN,Go\u001d+pa&\u001cG#\u00019\u0011\u0005\u0019\u000b\u0018B\u0001:H\u0005\u0011)f.\u001b;\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0004aV|\b\"\u0002<\u0007\u0001\u00049\u0018!\u0002;pa&\u001c\u0007C\u0001=}\u001d\tI(\u0010\u0005\u0002]\u000f&\u00111pR\u0001\u0007!J,G-\u001a4\n\u0005ut(AB*ue&twM\u0003\u0002|\u000f\"9\u0011\u0011\u0001\u0004A\u0002\u0005\r\u0011!\u00048v[B\u000b'\u000f^5uS>t7\u000fE\u0002G\u0003\u000bI1!a\u0002H\u0005\rIe\u000e^\u0001\u0015SN,fn\u001d;bE2,\u0017\t]5F]\u0006\u0014G.\u001a3\u0016\u0005\u00055\u0001c\u0001$\u0002\u0010%\u0019\u0011\u0011C$\u0003\u000f\t{w\u000e\\3b]\u0006a\u0012n\u001d(fo\u001e\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014XI\\1cY\u0016$\u0017\u0001D2p[6LGo\u00144gg\u0016$H#\u00059\u0002\u001a\u0005u\u0011\u0011EA\u0013\u0003O\tY#!\u000e\u0002T!1\u00111D\u0005A\u0002]\fqa\u001a:pkBLE\r\u0003\u0004\u0002 %\u0001\ra^\u0001\t[\u0016l'-\u001a:JI\"9\u00111E\u0005A\u0002\u0005\r\u0011aC7f[\n,'/\u00129pG\"DQA^\u0005A\u0002]Dq!!\u000b\n\u0001\u0004\t\u0019!A\u0005qCJ$\u0018\u000e^5p]\"9\u0011QF\u0005A\u0002\u0005=\u0012AB8gMN,G\u000fE\u0002G\u0003cI1!a\rH\u0005\u0011auN\\4\t\u000f\u0005]\u0012\u00021\u0001\u0002:\u0005iQ\r\u001f9fGR,G-\u0012:s_J\u0004B!a\u000f\u0002P5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0005qe>$xnY8m\u0015\u0011\t\u0019%!\u0012\u0002\r\r|W.\\8o\u0015\r\u0011\u0015q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\n1a\u001c:h\u0013\u0011\t\t&!\u0010\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\t)&\u0003a\u0001\u0003/\nqA^3sg&|g\u000eE\u0002G\u00033J1!a\u0017H\u0005\u0015\u0019\u0006n\u001c:u\u000311W\r^2i\u001f\u001a47/\u001a;t)9\t\t'!\u001e\u0002x\u0005e\u00141PAG\u0003#\u0003B!a\u0019\u0002p9!\u0011QMA6\u001b\t\t9G\u0003\u0003\u0002j\u0005\u0005\u0013aB7fgN\fw-Z\u0005\u0005\u0003[\n9'A\fPM\u001a\u001cX\r\u001e$fi\u000eD'+Z:q_:\u001cX\rR1uC&!\u0011\u0011OA:\u0005ayeMZ:fi\u001a+Go\u00195SKN\u0004xN\\:f\u000fJ|W\u000f\u001d\u0006\u0005\u0003[\n9\u0007\u0003\u0004\u0002\u001c)\u0001\ra\u001e\u0005\u0007\u0003?Q\u0001\u0019A<\t\u000f\u0005\r\"\u00021\u0001\u0002\u0004!9\u0011Q\u0010\u0006A\u0002\u0005}\u0014A\u00039beRLG/[8ogB)!,!!\u0002\u0006&\u0019\u00111\u00113\u0003\t1K7\u000f\u001e\t\u0005\u0003\u000f\u000bI)\u0004\u0002\u0002B%!\u00111RA!\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a$\u000b\u0001\u0004\ti!A\u0007sKF,\u0018N]3Ti\u0006\u0014G.\u001a\u0005\b\u0003+R\u0001\u0019AA,)!\t)*a&\u0002\"\u0006\r\u0006#\u0002.\u0002\u0002\u0006\u0005\u0004bBAM\u0017\u0001\u0007\u00111T\u0001\u0007OJ|W\u000f]:\u0011\ra\fij^A@\u0013\r\tyJ \u0002\u0004\u001b\u0006\u0004\bbBAH\u0017\u0001\u0007\u0011Q\u0002\u0005\b\u0003+Z\u0001\u0019AA,\u00031!W\r\\3uK>3gm]3u)5\u0001\u0018\u0011VAV\u0003[\u000by+a-\u00028\"1\u00111\u0004\u0007A\u0002]DQA\u001e\u0007A\u0002]Dq!!\u000b\r\u0001\u0004\t\u0019\u0001C\u0005\u000222\u0001\n\u00111\u0001\u0002:\u0005)R\r\u001f9fGR,GMU3ta>t7/Z#se>\u0014\b\"CA[\u0019A\u0005\t\u0019AA\u001d\u0003Y)\u0007\u0010]3di\u0016$\u0007+\u0019:uSRLwN\\#se>\u0014\bbBA+\u0019\u0001\u0007\u0011qK\u0001\u0017I\u0016dW\r^3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0018\u0016\u0005\u0003s\tyl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tYmR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y!W\r\\3uK>3gm]3uI\u0011,g-Y;mi\u0012*\u0014aE:peR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cHc\u00019\u0002X\"9\u0011\u0011\\\bA\u0002\u0005\u0005\u0014!B4s_V\u0004\u0018\u0001G:z]\u000e<%o\\;q/&$\bn\u00147e!J|Go\\2pYRA\u0012q\\As\u0003O\fI/!<\u0002r\u0006U(\u0011\u0002B\u0007\u0005#\u0011\tCa\t\u0011\t\u0005\u0015\u0014\u0011]\u0005\u0005\u0003G\f9GA\u000bTs:\u001cwI]8vaJ+7\u000f]8og\u0016$\u0015\r^1\t\r\u0005m\u0001\u00031\u0001x\u0011\u0019\ty\u0002\u0005a\u0001o\"9\u00111\u001e\tA\u0002\u0005\r\u0011\u0001D4f]\u0016\u0014\u0018\r^5p]&#\u0007\u0002CAx!A\u0005\t\u0019A<\u0002\u0019A\u0014x\u000e^8d_2$\u0016\u0010]3\t\u0011\u0005M\b\u0003%AA\u0002]\fA\u0002\u001d:pi>\u001cw\u000e\u001c(b[\u0016D\u0011\"a>\u0011!\u0003\u0005\r!!?\u0002\u0017\u0005\u001c8/[4o[\u0016tGo\u001d\t\u00065\u0006\u0005\u00151 \t\u0005\u0003{\u0014\u0019A\u0004\u0003\u0002f\u0005}\u0018\u0002\u0002B\u0001\u0003O\nAcU=oG\u001e\u0013x.\u001e9SKF,Xm\u001d;ECR\f\u0017\u0002\u0002B\u0003\u0005\u000f\u0011!dU=oG\u001e\u0013x.\u001e9SKF,Xm\u001d;BgNLwM\\7f]RTAA!\u0001\u0002h!A!1\u0002\t\u0011\u0002\u0003\u0007q/\u0001\u000bfqB,7\r^3e!J|Go\\2pYRK\b/\u001a\u0005\t\u0005\u001f\u0001\u0002\u0013!a\u0001o\u0006!R\r\u001f9fGR,G\r\u0015:pi>\u001cw\u000e\u001c(b[\u0016D\u0011Ba\u0005\u0011!\u0003\u0005\rA!\u0006\u0002%\u0015D\b/Z2uK\u0012\f5o]5h]6,g\u000e\u001e\t\u0006\r\n]!1D\u0005\u0004\u000539%!B!se\u0006L\bc\u0001$\u0003\u001e%\u0019!qD$\u0003\t\tKH/\u001a\u0005\n\u0003o\u0001\u0002\u0013!a\u0001\u0003sA\u0011\"!\u0016\u0011!\u0003\u0005\r!a\u0016\u0002EMLhnY$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011ICK\u0002x\u0003\u007f\u000b!e]=oG\u001e\u0013x.\u001e9XSRDw\n\u001c3Qe>$xnY8mI\u0011,g-Y;mi\u0012*\u0014AI:z]\u000e<%o\\;q/&$\bn\u00147e!J|Go\\2pY\u0012\"WMZ1vYR$c'\u0006\u0002\u00032)\"\u0011\u0011`A`\u0003\t\u001a\u0018P\\2He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%o\u0005\u00113/\u001f8d\u000fJ|W\u000f],ji\"|E\u000e\u001a)s_R|7m\u001c7%I\u00164\u0017-\u001e7uIa\n!e]=oG\u001e\u0013x.\u001e9XSRDw\n\u001c3Qe>$xnY8mI\u0011,g-Y;mi\u0012JTC\u0001B\u001eU\u0011\u0011)\"a0\u0002GMLhnY$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u00132a\u0005\u00193/\u001f8d\u000fJ|W\u000f],ji\"|E\u000e\u001a)s_R|7m\u001c7%I\u00164\u0017-\u001e7uIE\nTC\u0001B\"U\u0011\t9&a0\u0002\u001fM,g\u000e\u001a&pS:\u0014V-];fgR$\u0002C!\u0013\u0003P\tE#1\u000bB,\u00053\u0012YFa\u0018\u0011\t\u0005\u0015$1J\u0005\u0005\u0005\u001b\n9GA\u000bK_&twI]8vaJ+7\u000f]8og\u0016$\u0015\r^1\t\r\u0005m\u0011\u00041\u0001x\u0011!\ty\"\u0007I\u0001\u0002\u00049\b\u0002\u0003B+3A\u0005\t\u0019A<\u0002\u001f\u001d\u0014x.\u001e9J]N$\u0018M\\2f\u0013\u0012D\u0001\"a<\u001a!\u0003\u0005\ra\u001e\u0005\t\u0003gL\u0002\u0013!a\u0001o\"I!QL\r\u0011\u0002\u0003\u0007!QC\u0001\t[\u0016$\u0018\rZ1uC\"I\u0011QK\r\u0011\u0002\u0003\u0007\u0011qK\u0001\u001ag\u0016tGMS8j]J+\u0017/^3ti\u0012\"WMZ1vYR$#'A\rtK:$'j\\5o%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u001a\u0014!G:f]\u0012Tu.\u001b8SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIQ\n\u0011d]3oI*{\u0017N\u001c*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u0005I2/\u001a8e\u0015>LgNU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003e\u0019XM\u001c3K_&t'+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001c\u0002O)|\u0017N\u001c#z]\u0006l\u0017nY\"p]N,X.\u001a:He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u000b\u000b\u0005c\u00129H!\u001f\u0003|\t}\u0004C\u0002$\u0003t]\f\u0019!C\u0002\u0003v\u001d\u0013a\u0001V;qY\u0016\u0014\u0004BBA\u000eA\u0001\u0007q\u000fC\u0005\u0003^\u0001\u0002\n\u00111\u0001\u0003\u0016!I!Q\u0010\u0011\u0011\u0002\u0003\u0007!QC\u0001\u000bCN\u001c\u0018n\u001a8nK:$\b\"\u0003BAAA\u0005\t\u0019AA\u0007\u0003E\u0019w.\u001c9mKR,'+\u001a2bY\u0006t7-Z\u00012U>Lg\u000eR=oC6L7mQ8ogVlWM]$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003ERw.\u001b8Es:\fW.[2D_:\u001cX/\\3s\u000fJ|W\u000f],ji\"|E\u000e\u001a)s_R|7m\u001c7%I\u00164\u0017-\u001e7uIM\n\u0011G[8j]\u0012Kh.Y7jG\u000e{gn];nKJ<%o\\;q/&$\bn\u00147e!J|Go\\2pY\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\f*\"\u0011QBA`\u0003\u0019Rw.\u001b8Ti\u0006$\u0018nY\"p]N,X.\u001a:He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u000b\u000b\u0005c\u0012\tJa%\u0003\u0016\n]\u0005BBA\u000eI\u0001\u0007q\u000f\u0003\u0004\u0003V\u0011\u0002\ra\u001e\u0005\n\u0005;\"\u0003\u0013!a\u0001\u0005+A\u0011B!!%!\u0003\u0005\r!!\u0004\u0002a)|\u0017N\\*uCRL7mQ8ogVlWM]$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003ARw.\u001b8Ti\u0006$\u0018nY\"p]N,X.\u001a:He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0001#n\\5o\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRDg*Z<Qe>$xnY8m)\u0011\u0011\tH!)\t\r\u0005mq\u00051\u0001x\u0003EQw.\u001b8D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u000b\u0007\u0005c\u00129K!+\t\r\u0005m\u0001\u00061\u0001x\u0011\u001d\u0011Y\u000b\u000ba\u0001\u0003\u001b\ta\"^:f\u001d\u0016<\bK]8u_\u000e|G.\u0001\u0006mSN$xI]8vaN$bA!-\u0003B\n\u001d\u0007#\u0002.\u0002\u0002\nM\u0006\u0003\u0002B[\u0005wsA!!\u001a\u00038&!!\u0011XA4\u0003Ya\u0015n\u001d;He>,\bo\u001d*fgB|gn]3ECR\f\u0017\u0002\u0002B_\u0005\u007f\u00131\u0002T5ti\u0016$wI]8va*!!\u0011XA4\u0011\u001d\u0011\u0019-\u000ba\u0001\u0005\u000b\fAb\u001d;bi\u0016\u001ch)\u001b7uKJ\u0004BAWAAo\"9\u0011QK\u0015A\u0002\u0005]\u0013A\u00043fg\u000e\u0014\u0018NY3He>,\bo\u001d\u000b\u0007\u0005\u001b\u0014iN!9\u0011\u000bi\u000b\tIa4\u0011\t\tE'q\u001b\b\u0005\u0003K\u0012\u0019.\u0003\u0003\u0003V\u0006\u001d\u0014A\u0007#fg\u000e\u0014\u0018NY3He>,\bo\u001d*fgB|gn]3ECR\f\u0017\u0002\u0002Bm\u00057\u0014a\u0002R3tGJL'-\u001a3He>,\bO\u0003\u0003\u0003V\u0006\u001d\u0004b\u0002BpU\u0001\u0007!QY\u0001\tOJ|W\u000f]%eg\"I\u0011Q\u000b\u0016\u0011\u0002\u0003\u0007\u0011qK\u0001\u0019I\u0016\u001c8M]5cK\u001e\u0013x.\u001e9tI\u0011,g-Y;mi\u0012\u0012\u0014!\u00035fCJ$(-Z1u)9\u0011IOa<\u0003r\nM(Q\u001fB|\u0005s\u0004B!!\u001a\u0003l&!!Q^A4\u0005UAU-\u0019:uE\u0016\fGOU3ta>t7/\u001a#bi\u0006Da!a\u0007-\u0001\u00049\bbBAvY\u0001\u0007\u00111\u0001\u0005\u0007\u0003?a\u0003\u0019A<\t\u0011\tUC\u0006%AA\u0002]D\u0011\"a\u000e-!\u0003\u0005\r!!\u000f\t\u000f\u0005UC\u00061\u0001\u0002X\u0005\u0019\u0002.Z1si\n,\u0017\r\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0019\u0002.Z1si\n,\u0017\r\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u000512m\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fG\u000f\u0006\u000b\u0004\u0004\r%11BB\u0007\u0007\u001f\u0019\u0019ba\u0006\u0004\u001c\r}11\u0005\t\u0005\u0003K\u001a)!\u0003\u0003\u0004\b\u0005\u001d$AI\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;SKN\u0004xN\\:f\t\u0006$\u0018\r\u0003\u0004\u0002\u001c=\u0002\ra\u001e\u0005\t\u0003?y\u0003\u0013!a\u0001o\"I\u00111E\u0018\u0011\u0002\u0003\u0007\u00111\u0001\u0005\t\u0007#y\u0003\u0013!a\u0001o\u0006Q\u0011N\\:uC:\u001cW-\u00133\t\u0011\rUq\u0006%AA\u0002]\faA]1dW&#\u0007\"CB\r_A\u0005\t\u0019AA\u0002\u0003I\u0011XMY1mC:\u001cW\rV5nK>,H/T:\t\u0011\ruq\u0006%AA\u0002]\fab]3sm\u0016\u0014\u0018i]:jO:|'\u000fC\u0005\u0004\"=\u0002\n\u00111\u0001\u0003F\u0006!2/\u001e2tGJL'-\u001a3U_BL7MT1nKND\u0011b!\n0!\u0003\u0005\raa\n\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004RAWAA\u0007S\u0001Baa\u000b\u000429!\u0011QMB\u0017\u0013\u0011\u0019y#a\u001a\u0002C\r{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR\u0014V-];fgR$\u0015\r^1\n\t\rM2Q\u0007\u0002\u0010)>\u0004\u0018n\u0019)beRLG/[8og*!1qFA4\u0003\u0001\u001awN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$H\u0005Z3gCVdG\u000f\n\u001a\u0002A\r|gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR$C-\u001a4bk2$HeM\u000b\u0003\u0007{QC!a\u0001\u0002@\u0006\u00013m\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\u0001\u001awN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$H\u0005Z3gCVdG\u000fJ\u001b\u0002A\r|gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR$C-\u001a4bk2$HEN\u0001!G>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3bi\u0012\"WMZ1vYR$s'\u0001\u0011d_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1uI\u0011,g-Y;mi\u0012BTCAB&U\u0011\u0011)-a0\u0002A\r|gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR$C-\u001a4bk2$H%O\u000b\u0003\u0007#RCaa\n\u0002@\u0006IB.Z1wK\u001e\u0013x.\u001e9XSRDg*Z<Qe>$xnY8m)\u0019\u0019\u0019aa\u0016\u0004Z!1\u00111\u0004\u001dA\u0002]Da!a\b9\u0001\u00049\u0018!\u00077fCZ,wI]8va^KG\u000f[(mIB\u0013x\u000e^8d_2$R\u0002]B0\u0007C\u001a)g!\u001b\u0004n\rM\u0004BBA\u000es\u0001\u0007q\u000fC\u0004\u0004de\u0002\rA!2\u0002\u00135,WNY3s\u0013\u0012\u001c\b\"CB4sA\u0005\t\u0019\u0001Bc\u0003A9'o\\;q\u0013:\u001cH/\u00198dK&#7\u000fC\u0004\u0004le\u0002\r!!\u000f\u0002/\u0015D\b/Z2uK\u0012dU-\u0019<f\u000fJ|W\u000f]#se>\u0014\bbBB8s\u0001\u00071\u0011O\u0001\u0015Kb\u0004Xm\u0019;fI6+WNY3s\u000bJ\u0014xN]:\u0011\u000bi\u000b\t)!\u000f\t\u000f\u0005U\u0013\b1\u0001\u0002X\u0005\u0019C.Z1wK\u001e\u0013x.\u001e9XSRDw\n\u001c3Qe>$xnY8mI\u0011,g-Y;mi\u0012\u001a\u0014A\u00037fCZ,wI]8vaRI\u0001oa\u001f\u0004~\r}4\u0011\u0011\u0005\u0007\u00037Y\u0004\u0019A<\t\r\u0005}1\b1\u0001x\u0011\u001d\u0011Yk\u000fa\u0001\u0003\u001bAq!!\u0016<\u0001\u0004\t9&\u0001\u0007eK2,G/Z$s_V\u00048\u000fF\u0004q\u0007\u000f\u001bIi!$\t\u000f\t}G\b1\u0001\u0003F\"911\u0012\u001fA\u0002\rE\u0014AD3ya\u0016\u001cG/\u001a3FeJ|'o\u001d\u0005\b\u0003+b\u0004\u0019AA,\u0003E\u0019wN\u001c8fGR\fe\u000e\u001a*fG\u0016Lg/Z\u000b\u0005\u0007'\u001bY\n\u0006\u0003\u0004\u0016\u000eMGCBBL\u0007g\u001b\u0019\r\u0005\u0003\u0004\u001a\u000emE\u0002\u0001\u0003\b\u0007;k$\u0019ABP\u0005\u0005!\u0016\u0003BBQ\u0007O\u00032ARBR\u0013\r\u0019)k\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\u0019Ika,\u000e\u0005\r-&\u0002BBW\u0003\u0003\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007c\u001bYK\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\"91QW\u001fA\u0004\r]\u0016\u0001C2mCN\u001cH+Y4\u0011\r\re6qXBL\u001b\t\u0019YLC\u0002\u0004>\u001e\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0004B\u000em&\u0001C\"mCN\u001cH+Y4\t\u000f\r\u0015W\bq\u0001\u0004H\u0006\u0011aN\u001c\t\u0007\u0007\u0013\u001cyma&\u000e\u0005\r-'bABg\u0003\u0006)Q\u000f^5mg&!1\u0011[Bf\u0005)qu\u000e\u001e(pi\"Lgn\u001a\u0005\b\u0007+l\u0004\u0019ABl\u0003\u001d\u0011X-];fgR\u0004Ba!+\u0004Z&!11\\BV\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b")
public class GroupCoordinatorBaseRequestTest {
    private final ClusterInstance cluster;

    private scala.collection.immutable.Seq<KafkaBroker> brokers() {
        if (this.cluster.isKRaftTest()) {
            return CollectionConverters$.MODULE$.ListHasAsScala(((RaftClusterInvocationContext.RaftClusterInstance)this.cluster).brokers().collect(Collectors.toList())).asScala().toSeq();
        }
        return CollectionConverters$.MODULE$.ListHasAsScala(((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).servers().collect(Collectors.toList())).asScala().toSeq();
    }

    private scala.collection.immutable.Seq<ControllerServer> controllerServers() {
        if (this.cluster.isKRaftTest()) {
            return CollectionConverters$.MODULE$.CollectionHasAsScala(((RaftClusterInvocationContext.RaftClusterInstance)this.cluster).controllerServers()).asScala().toSeq();
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    public void createOffsetsTopic() {
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(this.cluster.createAdminClient(), this.brokers(), (Seq<ControllerServer>)this.controllerServers());
    }

    public void createTopic(String topic, int numPartitions) {
        Admin x$1 = this.cluster.createAdminClient();
        scala.collection.immutable.Seq<KafkaBroker> x$2 = this.brokers();
        scala.collection.immutable.Seq<ControllerServer> x$3 = this.controllerServers();
        int x$6 = 1;
        Map x$7 = (Map)Map$.MODULE$.empty();
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, topic, x$2, (Seq<ControllerServer>)x$3, numPartitions, x$6, (Map<Object, Seq<Object>>)x$7, x$8);
    }

    public boolean isUnstableApiEnabled() {
        String string = this.cluster.config().serverProperties().getProperty("unstable.api.versions.enable");
        String string2 = "true";
        return string != null && string.equals(string2);
    }

    public boolean isNewGroupCoordinatorEnabled() {
        String string = this.cluster.config().serverProperties().getProperty("group.coordinator.new.enable");
        String string2 = "true";
        return string != null && string.equals(string2);
    }

    public void commitOffset(String groupId, String memberId, int memberEpoch, String topic, int partition, long offset, Errors expectedError, short version) {
        OffsetCommitRequest request = new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationIdOrMemberEpoch(memberEpoch).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedOffset(offset), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()), this.isUnstableApiEnabled()).build(version);
        OffsetCommitResponseData expectedResponse = new OffsetCommitResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition).setErrorCode(expectedError.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        OffsetCommitResponse response = (OffsetCommitResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetCommitResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)expectedResponse, (Object)response.data());
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchOffsets(String groupId, String memberId, int memberEpoch, List<TopicPartition> partitions, boolean requireStable, short version) {
        OffsetFetchResponseData.OffsetFetchResponseGroup offsetFetchResponseGroup;
        OffsetFetchRequest request = new OffsetFetchRequest.Builder(groupId, memberId, memberEpoch, requireStable, partitions == null ? null : CollectionConverters$.MODULE$.SeqHasAsJava(partitions).asJava(), false).build(version);
        OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        if (version >= 8) {
            Assertions.assertEquals((int)1, (int)response.data().groups().size());
            Assertions.assertEquals((Object)groupId, (Object)((OffsetFetchResponseData.OffsetFetchResponseGroup)response.data().groups().get(0)).groupId());
            offsetFetchResponseGroup = (OffsetFetchResponseData.OffsetFetchResponseGroup)CollectionConverters$.MODULE$.ListHasAsScala(response.data().groups()).asScala().head();
        } else {
            offsetFetchResponseGroup = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setErrorCode(response.data().errorCode()).setTopics(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(response.data().topics()).asScala().map((Function1 & Serializable)topic -> new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic.name()).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().map((Function1 & Serializable)partition -> new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition.partitionIndex()).setErrorCode(partition.errorCode()).setCommittedOffset(partition.committedOffset()).setCommittedLeaderEpoch(partition.committedLeaderEpoch()).setMetadata(partition.metadata()))).asJava()))).asJava());
        }
        OffsetFetchResponseData.OffsetFetchResponseGroup groupResponse = offsetFetchResponseGroup;
        this.sortTopicPartitions(groupResponse);
        return groupResponse;
    }

    public List<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(scala.collection.immutable.Map<String, List<TopicPartition>> groups, boolean requireStable, short version) {
        if (version < 8) {
            Assertions.fail((String)new StringBuilder(54).append("OffsetFetch API version ").append(version).append(" cannot fetch multiple groups.").toString());
        }
        OffsetFetchRequest request = new OffsetFetchRequest.Builder(CollectionConverters$.MODULE$.MapHasAsJava((Map)groups.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                List v = (List)x0$1._2();
                return new Tuple2((Object)k, (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)v).asJava());
            }
            throw new MatchError(null);
        })).asJava(), requireStable, false).build(version);
        OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        CollectionConverters$.MODULE$.ListHasAsScala(response.data().groups()).asScala().foreach((Function1 & Serializable)group -> {
            this.sortTopicPartitions(group);
            return BoxedUnit.UNIT;
        });
        return CollectionConverters$.MODULE$.ListHasAsScala(response.data().groups()).asScala().toList();
    }

    public void deleteOffset(String groupId, String topic, int partition, Errors expectedResponseError, Errors expectedPartitionError, short version) {
        Errors errors = expectedResponseError;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            Errors errors3 = expectedPartitionError;
            Errors errors4 = Errors.NONE;
            if (errors3 == null ? errors4 != null : !errors3.equals(errors4)) {
                Assertions.fail((String)"deleteOffset: neither expectedResponseError nor expectedTopicError is Errors.NONE.");
            }
        }
        OffsetDeleteRequest request = new OffsetDeleteRequest.Builder(new OffsetDeleteRequestData().setGroupId(groupId).setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(partition), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava().iterator()))).build(version);
        OffsetDeleteResponseData expectedResponse = new OffsetDeleteResponseData();
        Errors errors5 = expectedResponseError;
        Errors errors6 = Errors.NONE;
        if (!(errors5 != null ? !errors5.equals(errors6) : errors6 != null)) {
            expectedResponse.setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition).setErrorCode(expectedPartitionError.code()), (List)Nil$.MODULE$)).asJava().iterator())), (List)Nil$.MODULE$)).asJava().iterator()));
        } else {
            expectedResponse.setErrorCode(expectedResponseError.code());
        }
        OffsetDeleteResponse response = (OffsetDeleteResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetDeleteResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)expectedResponse, (Object)response.data());
    }

    public Errors deleteOffset$default$4() {
        return Errors.NONE;
    }

    public Errors deleteOffset$default$5() {
        return Errors.NONE;
    }

    private void sortTopicPartitions(OffsetFetchResponseData.OffsetFetchResponseGroup group) {
        group.topics().sort((t1, t2) -> t1.name().compareTo(t2.name()));
        CollectionConverters$.MODULE$.ListHasAsScala(group.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            GroupCoordinatorBaseRequestTest.$anonfun$sortTopicPartitions$2(topic);
            return BoxedUnit.UNIT;
        });
    }

    public SyncGroupResponseData syncGroupWithOldProtocol(String groupId, String memberId, int generationId, String protocolType, String protocolName, List<SyncGroupRequestData.SyncGroupRequestAssignment> assignments, String expectedProtocolType, String expectedProtocolName, byte[] expectedAssignment, Errors expectedError, short version) {
        SyncGroupRequestData syncGroupRequestData = new SyncGroupRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(generationId).setProtocolType(protocolType).setProtocolName(protocolName).setAssignments(CollectionConverters$.MODULE$.SeqHasAsJava(assignments).asJava());
        SyncGroupRequest syncGroupRequest = new SyncGroupRequest.Builder(syncGroupRequestData).build(version);
        SyncGroupResponse syncGroupResponse = (SyncGroupResponse)this.connectAndReceive((AbstractRequest)syncGroupRequest, ClassTag$.MODULE$.apply(SyncGroupResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)new SyncGroupResponseData().setErrorCode(expectedError.code()).setProtocolType(version >= 5 ? expectedProtocolType : null).setProtocolName(version >= 5 ? expectedProtocolName : null).setAssignment(expectedAssignment), (Object)syncGroupResponse.data());
        return syncGroupResponse.data();
    }

    public String syncGroupWithOldProtocol$default$4() {
        return "consumer";
    }

    public String syncGroupWithOldProtocol$default$5() {
        return "consumer-range";
    }

    public List<SyncGroupRequestData.SyncGroupRequestAssignment> syncGroupWithOldProtocol$default$6() {
        return package$.MODULE$.List().empty();
    }

    public String syncGroupWithOldProtocol$default$7() {
        return "consumer";
    }

    public String syncGroupWithOldProtocol$default$8() {
        return "consumer-range";
    }

    public byte[] syncGroupWithOldProtocol$default$9() {
        return (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public Errors syncGroupWithOldProtocol$default$10() {
        return Errors.NONE;
    }

    public short syncGroupWithOldProtocol$default$11() {
        return ApiKeys.SYNC_GROUP.latestVersion(this.isUnstableApiEnabled());
    }

    /*
     * WARNING - void declaration
     */
    public JoinGroupResponseData sendJoinRequest(String groupId, String memberId, String groupInstanceId, String protocolType, String protocolName, byte[] metadata, short version) {
        JoinGroupResponse joinGroupResponse;
        JoinGroupRequestData joinGroupRequestData = new JoinGroupRequestData().setGroupId(groupId).setMemberId(memberId).setGroupInstanceId(groupInstanceId).setRebalanceTimeoutMs(250000).setSessionTimeoutMs(600000).setProtocolType(protocolType).setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocolName).setMetadata(metadata), (List)Nil$.MODULE$)).asJava().iterator()));
        JoinGroupRequest joinGroupRequest = new JoinGroupRequest.Builder(joinGroupRequestData).build(version);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((joinGroupResponse = (JoinGroupResponse)this.connectAndReceive((AbstractRequest)joinGroupRequest, ClassTag$.MODULE$.apply(JoinGroupResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))) != null)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(54).append("Could not join the group successfully. Last response ").append(joinGroupResponse).append(".").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return joinGroupResponse.data();
    }

    public String sendJoinRequest$default$2() {
        return "";
    }

    public String sendJoinRequest$default$3() {
        return null;
    }

    public String sendJoinRequest$default$4() {
        return "consumer";
    }

    public String sendJoinRequest$default$5() {
        return "consumer-range";
    }

    public byte[] sendJoinRequest$default$6() {
        return (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public short sendJoinRequest$default$7() {
        return ApiKeys.JOIN_GROUP.latestVersion(this.isUnstableApiEnabled());
    }

    public Tuple2<String, Object> joinDynamicConsumerGroupWithOldProtocol(String groupId, byte[] metadata, byte[] assignment, boolean completeRebalance) {
        String x$3 = this.sendJoinRequest$default$2();
        String x$4 = this.sendJoinRequest$default$3();
        String x$5 = this.sendJoinRequest$default$4();
        String x$6 = this.sendJoinRequest$default$5();
        short x$7 = this.sendJoinRequest$default$7();
        JoinGroupResponseData joinGroupResponseData = this.sendJoinRequest(groupId, x$3, x$4, x$5, x$6, metadata, x$7);
        Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinGroupResponseData.errorCode());
        String x$9 = joinGroupResponseData.memberId();
        String x$11 = this.sendJoinRequest$default$3();
        String x$12 = this.sendJoinRequest$default$4();
        String x$13 = this.sendJoinRequest$default$5();
        short x$14 = this.sendJoinRequest$default$7();
        JoinGroupResponseData rejoinGroupResponseData = this.sendJoinRequest(groupId, x$9, x$11, x$12, x$13, metadata, x$14);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)rejoinGroupResponseData.errorCode());
        if (completeRebalance) {
            String x$16 = rejoinGroupResponseData.memberId();
            int x$17 = rejoinGroupResponseData.generationId();
            .colon.colon x$18 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(rejoinGroupResponseData.memberId()).setAssignment(assignment), (List)Nil$.MODULE$);
            String x$20 = this.syncGroupWithOldProtocol$default$4();
            String x$21 = this.syncGroupWithOldProtocol$default$5();
            String x$22 = this.syncGroupWithOldProtocol$default$7();
            String x$23 = this.syncGroupWithOldProtocol$default$8();
            Errors x$24 = this.syncGroupWithOldProtocol$default$10();
            short x$25 = this.syncGroupWithOldProtocol$default$11();
            this.syncGroupWithOldProtocol(groupId, x$16, x$17, x$20, x$21, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$18, x$22, x$23, assignment, x$24, x$25);
        }
        return new Tuple2((Object)rejoinGroupResponseData.memberId(), (Object)BoxesRunTime.boxToInteger((int)rejoinGroupResponseData.generationId()));
    }

    public byte[] joinDynamicConsumerGroupWithOldProtocol$default$2() {
        return (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public byte[] joinDynamicConsumerGroupWithOldProtocol$default$3() {
        return (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public boolean joinDynamicConsumerGroupWithOldProtocol$default$4() {
        return true;
    }

    public Tuple2<String, Object> joinStaticConsumerGroupWithOldProtocol(String groupId, String groupInstanceId, byte[] metadata, boolean completeRebalance) {
        String x$4 = this.sendJoinRequest$default$2();
        String x$5 = this.sendJoinRequest$default$4();
        String x$6 = this.sendJoinRequest$default$5();
        short x$7 = this.sendJoinRequest$default$7();
        JoinGroupResponseData joinGroupResponseData = this.sendJoinRequest(groupId, x$4, groupInstanceId, x$5, x$6, metadata, x$7);
        if (completeRebalance) {
            this.syncGroupWithOldProtocol(groupId, joinGroupResponseData.memberId(), joinGroupResponseData.generationId(), this.syncGroupWithOldProtocol$default$4(), this.syncGroupWithOldProtocol$default$5(), this.syncGroupWithOldProtocol$default$6(), this.syncGroupWithOldProtocol$default$7(), this.syncGroupWithOldProtocol$default$8(), this.syncGroupWithOldProtocol$default$9(), this.syncGroupWithOldProtocol$default$10(), this.syncGroupWithOldProtocol$default$11());
        }
        return new Tuple2((Object)joinGroupResponseData.memberId(), (Object)BoxesRunTime.boxToInteger((int)joinGroupResponseData.generationId()));
    }

    public byte[] joinStaticConsumerGroupWithOldProtocol$default$3() {
        return (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public boolean joinStaticConsumerGroupWithOldProtocol$default$4() {
        return true;
    }

    public Tuple2<String, Object> joinConsumerGroupWithNewProtocol(String groupId) {
        .colon.colon x$3 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$4 = package$.MODULE$.List().empty();
        String x$5 = this.consumerGroupHeartbeat$default$2();
        int x$6 = this.consumerGroupHeartbeat$default$3();
        String x$7 = this.consumerGroupHeartbeat$default$4();
        String x$8 = this.consumerGroupHeartbeat$default$5();
        String x$9 = this.consumerGroupHeartbeat$default$7();
        ConsumerGroupHeartbeatResponseData consumerGroupHeartbeatResponseData = this.consumerGroupHeartbeat(groupId, x$5, x$6, x$7, x$8, 300000, x$9, (List<String>)x$3, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$4);
        return new Tuple2((Object)consumerGroupHeartbeatResponseData.memberId(), (Object)BoxesRunTime.boxToInteger((int)consumerGroupHeartbeatResponseData.memberEpoch()));
    }

    public Tuple2<String, Object> joinConsumerGroup(String groupId, boolean useNewProtocol) {
        if (useNewProtocol) {
            return this.joinConsumerGroupWithNewProtocol(groupId);
        }
        return this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
    }

    public List<ListGroupsResponseData.ListedGroup> listGroups(List<String> statesFilter, short version) {
        ListGroupsRequest request = new ListGroupsRequest.Builder(new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava(statesFilter).asJava())).build(version);
        ListGroupsResponse response = (ListGroupsResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(ListGroupsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return CollectionConverters$.MODULE$.ListHasAsScala(response.data().groups()).asScala().toList();
    }

    public List<DescribeGroupsResponseData.DescribedGroup> describeGroups(List<String> groupIds, short version) {
        DescribeGroupsRequest describeGroupsRequest = new DescribeGroupsRequest.Builder(new DescribeGroupsRequestData().setGroups(CollectionConverters$.MODULE$.SeqHasAsJava(groupIds).asJava())).build(version);
        DescribeGroupsResponse describeGroupsResponse = (DescribeGroupsResponse)this.connectAndReceive((AbstractRequest)describeGroupsRequest, ClassTag$.MODULE$.apply(DescribeGroupsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return CollectionConverters$.MODULE$.ListHasAsScala(describeGroupsResponse.data().groups()).asScala().toList();
    }

    public short describeGroups$default$2() {
        return ApiKeys.DESCRIBE_GROUPS.latestVersion(this.isUnstableApiEnabled());
    }

    public HeartbeatResponseData heartbeat(String groupId, int generationId, String memberId, String groupInstanceId, Errors expectedError, short version) {
        HeartbeatRequest heartbeatRequest = new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId(groupId).setGenerationId(generationId).setMemberId(memberId).setGroupInstanceId(groupInstanceId)).build(version);
        HeartbeatResponse heartbeatResponse = (HeartbeatResponse)this.connectAndReceive((AbstractRequest)heartbeatRequest, ClassTag$.MODULE$.apply(HeartbeatResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)expectedError.code(), (short)heartbeatResponse.data().errorCode());
        return heartbeatResponse.data();
    }

    public String heartbeat$default$4() {
        return null;
    }

    public Errors heartbeat$default$5() {
        return Errors.NONE;
    }

    /*
     * WARNING - void declaration
     */
    public ConsumerGroupHeartbeatResponseData consumerGroupHeartbeat(String groupId, String memberId, int memberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String serverAssignor, List<String> subscribedTopicNames, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> topicPartitions) {
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(memberEpoch).setInstanceId(instanceId).setRackId(rackId).setRebalanceTimeoutMs(rebalanceTimeoutMs).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava(subscribedTopicNames).asJava()).setServerAssignor(serverAssignor).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava()), true).build();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data().errorCode() == Errors.NONE.code())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(49).append("Could not heartbeat successfully. Last response ").append(consumerGroupHeartbeatResponse).append(".").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return consumerGroupHeartbeatResponse.data();
    }

    public String consumerGroupHeartbeat$default$2() {
        return "";
    }

    public int consumerGroupHeartbeat$default$3() {
        return 0;
    }

    public String consumerGroupHeartbeat$default$4() {
        return null;
    }

    public String consumerGroupHeartbeat$default$5() {
        return null;
    }

    public int consumerGroupHeartbeat$default$6() {
        return -1;
    }

    public String consumerGroupHeartbeat$default$7() {
        return null;
    }

    public List<String> consumerGroupHeartbeat$default$8() {
        return null;
    }

    public List<ConsumerGroupHeartbeatRequestData.TopicPartitions> consumerGroupHeartbeat$default$9() {
        return null;
    }

    public ConsumerGroupHeartbeatResponseData leaveGroupWithNewProtocol(String groupId, String memberId) {
        return this.consumerGroupHeartbeat(groupId, memberId, -1, this.consumerGroupHeartbeat$default$4(), this.consumerGroupHeartbeat$default$5(), this.consumerGroupHeartbeat$default$6(), this.consumerGroupHeartbeat$default$7(), this.consumerGroupHeartbeat$default$8(), this.consumerGroupHeartbeat$default$9());
    }

    public void leaveGroupWithOldProtocol(String groupId, List<String> memberIds, List<String> groupInstanceIds, Errors expectedLeaveGroupError, List<Errors> expectedMemberErrors, short version) {
        LeaveGroupRequest leaveGroupRequest = new LeaveGroupRequest.Builder(groupId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().tabulate(memberIds.length(), (Function1 & Serializable)i -> GroupCoordinatorBaseRequestTest.$anonfun$leaveGroupWithOldProtocol$1(memberIds, groupInstanceIds, BoxesRunTime.unboxToInt((Object)i)))).asJava()).build(version);
        LeaveGroupResponseData expectedResponseData = new LeaveGroupResponseData();
        Errors errors = expectedLeaveGroupError;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            expectedResponseData.setErrorCode(expectedLeaveGroupError.code());
        } else {
            expectedResponseData.setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().tabulate(expectedMemberErrors.length(), (Function1 & Serializable)i -> GroupCoordinatorBaseRequestTest.$anonfun$leaveGroupWithOldProtocol$2(memberIds, groupInstanceIds, expectedMemberErrors, BoxesRunTime.unboxToInt((Object)i)))).asJava());
        }
        LeaveGroupResponse leaveGroupResponse = (LeaveGroupResponse)this.connectAndReceive((AbstractRequest)leaveGroupRequest, ClassTag$.MODULE$.apply(LeaveGroupResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)expectedResponseData, (Object)leaveGroupResponse.data());
    }

    public void leaveGroup(String groupId, String memberId, boolean useNewProtocol, short version) {
        if (useNewProtocol) {
            this.leaveGroupWithNewProtocol(groupId, memberId);
            return;
        }
        this.leaveGroupWithOldProtocol(groupId, (List<String>)new .colon.colon((Object)memberId, (List)Nil$.MODULE$), null, Errors.NONE, (List<Errors>)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), version);
    }

    public List<String> leaveGroupWithOldProtocol$default$3() {
        return null;
    }

    public void deleteGroups(List<String> groupIds, List<Errors> expectedErrors, short version) {
        if (groupIds.size() != expectedErrors.size()) {
            Assertions.fail((String)"deleteGroups: groupIds and expectedErrors have unmatched sizes.");
        }
        DeleteGroupsRequest deleteGroupsRequest = new DeleteGroupsRequest.Builder(new DeleteGroupsRequestData().setGroupsNames(CollectionConverters$.MODULE$.SeqHasAsJava(groupIds).asJava())).build(version);
        DeleteGroupsResponseData expectedResponseData = new DeleteGroupsResponseData().setResults(new DeleteGroupsResponseData.DeletableGroupResultCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().tabulate(groupIds.length(), (Function1 & Serializable)i -> GroupCoordinatorBaseRequestTest.$anonfun$deleteGroups$1(groupIds, expectedErrors, BoxesRunTime.unboxToInt((Object)i)))).asJava().iterator()));
        DeleteGroupsResponse deleteGroupsResponse = (DeleteGroupsResponse)this.connectAndReceive((AbstractRequest)deleteGroupsRequest, ClassTag$.MODULE$.apply(DeleteGroupsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)expectedResponseData.results()).asScala().toSet(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)deleteGroupsResponse.data().results()).asScala().toSet());
    }

    public <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, ClassTag<T> classTag, NotNothing<T> nn) {
        return IntegrationTestUtils$.MODULE$.connectAndReceive(request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), classTag, nn);
    }

    public static final /* synthetic */ void $anonfun$sortTopicPartitions$2(OffsetFetchResponseData.OffsetFetchResponseTopics topic) {
        topic.partitions().sort(Comparator.comparingInt(x$1 -> x$1.partitionIndex()));
    }

    public static final /* synthetic */ boolean $anonfun$sendJoinRequest$1(GroupCoordinatorBaseRequestTest $this, ObjectRef joinGroupResponse$1, JoinGroupRequest joinGroupRequest$1) {
        joinGroupResponse$1.elem = (JoinGroupResponse)$this.connectAndReceive((AbstractRequest)joinGroupRequest$1, ClassTag$.MODULE$.apply(JoinGroupResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return (JoinGroupResponse)joinGroupResponse$1.elem != null;
    }

    public static final /* synthetic */ String $anonfun$sendJoinRequest$2(ObjectRef joinGroupResponse$1) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((JoinGroupResponse)joinGroupResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$consumerGroupHeartbeat$1(GroupCoordinatorBaseRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$1) {
        consumerGroupHeartbeatResponse$1.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest$1, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$consumerGroupHeartbeat$2(ObjectRef consumerGroupHeartbeatResponse$1) {
        return new StringBuilder(49).append("Could not heartbeat successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ LeaveGroupRequestData.MemberIdentity $anonfun$leaveGroupWithOldProtocol$1(List memberIds$1, List groupInstanceIds$1, int i) {
        return new LeaveGroupRequestData.MemberIdentity().setMemberId((String)memberIds$1.apply(i)).setGroupInstanceId(groupInstanceIds$1 == null ? null : (String)groupInstanceIds$1.apply(i));
    }

    public static final /* synthetic */ LeaveGroupResponseData.MemberResponse $anonfun$leaveGroupWithOldProtocol$2(List memberIds$1, List groupInstanceIds$1, List expectedMemberErrors$1, int i) {
        return new LeaveGroupResponseData.MemberResponse().setMemberId((String)memberIds$1.apply(i)).setGroupInstanceId(groupInstanceIds$1 == null ? null : (String)groupInstanceIds$1.apply(i)).setErrorCode(((Errors)expectedMemberErrors$1.apply(i)).code());
    }

    public static final /* synthetic */ DeleteGroupsResponseData.DeletableGroupResult $anonfun$deleteGroups$1(List groupIds$1, List expectedErrors$1, int i) {
        return new DeleteGroupsResponseData.DeletableGroupResult().setGroupId((String)groupIds$1.apply(i)).setErrorCode(((Errors)expectedErrors$1.apply(i)).code());
    }

    public GroupCoordinatorBaseRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

