/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u0017/\u0001UBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u0012\u0001\u0005B\u0015CqA\u0015\u0001C\u0002\u0013\u00051\u000b\u0003\u0004]\u0001\u0001\u0006I\u0001\u0016\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0011\u0019A\u0007\u0001)A\u0005?\"9\u0011\u000e\u0001b\u0001\n\u0003q\u0006B\u00026\u0001A\u0003%q\fC\u0005l\u0001\u0001\u0007\t\u0019!C\u0001Y\"IA\u0010\u0001a\u0001\u0002\u0004%\t! \u0005\u000b\u0003\u000f\u0001\u0001\u0019!A!B\u0013i\u0007bCA\u0005\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0017A1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001e!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0007\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%\t!!\n\t\u0017\u0005E\u0002\u00011AA\u0002\u0013\u0005\u00111\u0007\u0005\f\u0003o\u0001\u0001\u0019!A!B\u0013\t9\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005}\u0003bBA:\u0001\u0011\u0005\u0011q\f\u0005\b\u0003o\u0002A\u0011AA0\u0011\u001d\tY\b\u0001C\u0001\u0003?Bq!a \u0001\t\u0003\ty\u0006C\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"I\u0011Q\u0015\u0001\u0012\u0002\u0013%\u0011q\u0015\u0005\b\u0003{\u0003A\u0011BA0\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003Dq!a1\u0001\t\u0013\t)\rC\u0004\u0002Z\u0002!I!a\u0003\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011q\u001e\u0001\u0005\n\u0005E\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CA\u0011B!\u000f\u0001#\u0003%I!a*\t\u0013\tm\u0002!%A\u0005\n\u0005\u001d\u0006b\u0002B\u001f\u0001\u0011%!q\b\u0005\b\u0005\u001b\u0002A\u0011BA\u0006\u0011\u001d\tI\t\u0001C\u0005\u0005\u001fBq!!$\u0001\t\u0013\u0011y\u0005C\u0004\u0003R\u0001!IAa\u0015\t\u0013\t\r\u0004!%A\u0005\n\t\u0015$\u0001L#q_\u000eDGI]5wK:\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Qe>$xnY8m\u0003\u000e\u001cW\r\u001d;b]\u000e,G+Z:u\u0015\ty\u0003'A\u0003fa>\u001c\u0007N\u0003\u00022e\u000511/\u001a:wKJT\u0011aM\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001aG\u000f\t\u0003oaj\u0011\u0001M\u0005\u0003sA\u0012\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\tYd(D\u0001=\u0015\ti$'A\u0003vi&d7/\u0003\u0002@y\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001C!\t\u0019\u0005!D\u0001/\u0003=iW\r^1eCR\fg+\u001a:tS>tW#\u0001$\u0011\u0005\u001d\u0003V\"\u0001%\u000b\u0005%S\u0015AB2p[6|gN\u0003\u00022\u0017*\u00111\u0007\u0014\u0006\u0003\u001b:\u000ba!\u00199bG\",'\"A(\u0002\u0007=\u0014x-\u0003\u0002R\u0011\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g.A\u0003u_BL7-F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0002ng\u001e,\u0012a\u0018\t\u0004A\u000e,W\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u00014\u0017BA4b\u0005\u0011\u0011\u0015\u0010^3\u0002\t5\u001cx\rI\u0001\n[N<')[4hKJ\f!\"\\:h\u0005&<w-\u001a:!\u0003\u001d\u0011'o\\6feN,\u0012!\u001c\t\u0004]ZLhBA8u\u001d\t\u00018/D\u0001r\u0015\t\u0011H'\u0001\u0004=e>|GOP\u0005\u0002E&\u0011Q/Y\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0002TKFT!!^1\u0011\u0005]R\u0018BA>1\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017\t\u0014xn[3sg~#S-\u001d\u000b\u0004}\u0006\r\u0001C\u00011\u0000\u0013\r\t\t!\u0019\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0006)\t\t\u00111\u0001n\u0003\rAH%M\u0001\tEJ|7.\u001a:tA\u0005A\u0001O]8ek\u000e,'/\u0006\u0002\u0002\u000eA1\u0011qBA\f?~k!!!\u0005\u000b\t\u0005%\u00111\u0003\u0006\u0004\u0003+Y\u0015aB2mS\u0016tGo]\u0005\u0005\u00033\t\tBA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM]\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0004}\u0006}\u0001\"CA\u0003\u001b\u0005\u0005\t\u0019AA\u0007\u0003%\u0001(o\u001c3vG\u0016\u0014\b%\u0001\u0005d_:\u001cX/\\3s+\t\t9\u0003\u0005\u0004\u0002*\u00055rlX\u0007\u0003\u0003WQA!a\t\u0002\u0014%!\u0011qFA\u0016\u0005!\u0019uN\\:v[\u0016\u0014\u0018\u0001D2p]N,X.\u001a:`I\u0015\fHc\u0001@\u00026!I\u0011Q\u0001\t\u0002\u0002\u0003\u0007\u0011qE\u0001\nG>t7/^7fe\u0002\nQa]3u+B$2A`A\u001f\u0011\u001d\tyD\u0005a\u0001\u0003\u0003\n\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u0007\n\t&\u0004\u0002\u0002F)!\u0011qIA%\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0017\ni%A\u0004kkBLG/\u001a:\u000b\u0007\u0005=c*A\u0003kk:LG/\u0003\u0003\u0002T\u0005\u0015#\u0001\u0003+fgRLeNZ8)\u0007I\t9\u0006\u0005\u0003\u0002D\u0005e\u0013\u0002BA.\u0003\u000b\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001@)\u0007M\t\u0019\u0007\u0005\u0003\u0002D\u0005\u0015\u0014\u0002BA4\u0003\u000b\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002IMDw.\u001e7e\r>dGn\\<MK\u0006$WM]#q_\u000eD')Y:jG^{'o\u001b4m_^D3\u0001FA7!\u0011\t\u0019%a\u001c\n\t\u0005E\u0014Q\t\u0002\u0005)\u0016\u001cH/A\u000etQ>,H\u000e\u001a(pi\u0006cGn\\<ESZ,'oZ3oi2{wm\u001d\u0015\u0004+\u00055\u0014aG8gMN,Go]*i_VdGMT8u\u000f>\u0014\u0015mY6xCJ$7\u000fK\u0002\u0017\u0003[\nQd\u001d5pk2$7+\u001e:wSZ,g)Y:u\u0019\u0016\fG-\u001a:DQ\u0006tw-\u001a\u0015\u0004/\u00055\u0014\u0001\f7pON\u001c\u0006n\\;mI:{G\u000fR5wKJ<Wm\u00148V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8tQ\rA\u0012QN\u0001\u0004Y><G#\u0002@\u0002\b\u0006-\u0005BBAE3\u0001\u0007\u00110\u0001\u0004mK\u0006$WM\u001d\u0005\u0007\u0003\u001bK\u0002\u0019A=\u0002\u0011\u0019|G\u000e\\8xKJ\f!c^1ji\u001a{'\u000fT8hgR{W*\u0019;dQR9a0a%\u0002\u0018\u0006m\u0005BBAK5\u0001\u0007\u00110\u0001\u0002cc!1\u0011\u0011\u0014\u000eA\u0002e\f!A\u0019\u001a\t\u0013\u0005u%\u0004%AA\u0002\u0005}\u0015!\u00039beRLG/[8o!\r\u0001\u0017\u0011U\u0005\u0004\u0003G\u000b'aA%oi\u0006ar/Y5u\r>\u0014Hj\\4t)>l\u0015\r^2iI\u0011,g-Y;mi\u0012\u001aTCAAUU\u0011\ty*a+,\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a.b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\u000b\tLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:j]R\u001cVmZ7f]R\u001c\u0018!D:uCJ$8i\u001c8tk6,'\u000f\u0006\u0002\u0002(\u0005IB-\u001a7fi\u0016lUm]:bO\u0016\u001chI]8n\u0019><g)\u001b7f)\u001dq\u0018qYAi\u0003+Dq!!3\u001f\u0001\u0004\tY-A\u0003csR,7\u000fE\u0002a\u0003\u001bL1!a4b\u0005\u0011auN\\4\t\r\u0005Mg\u00041\u0001z\u0003\u0019\u0011'o\\6fe\"9\u0011q\u001b\u0010A\u0002\u0005}\u0015a\u00039beRLG/[8o\u0013\u0012\fqc\u0019:fCR,')\u001e4gKJLgn\u001a)s_\u0012,8-\u001a:\u0002\u0015\u001d,G\u000fT8h\r&dW\r\u0006\u0004\u0002`\u0006-\u0018Q\u001e\t\u0005\u0003C\f9/\u0004\u0002\u0002d*\u0019\u0011Q\u001d-\u0002\u0005%|\u0017\u0002BAu\u0003G\u0014AAR5mK\"1\u00111\u001b\u0011A\u0002eDq!!(!\u0001\u0004\ty*\u0001\u0004hKRdun\u001a\u000b\u0007\u0003g\fi0a@\u0011\t\u0005U\u0018\u0011`\u0007\u0003\u0003oT1!a!3\u0013\u0011\tY0a>\u0003\u0015Us\u0017NZ5fI2{w\r\u0003\u0004\u0002T\u0006\u0002\r!\u001f\u0005\b\u0003;\u000b\u0003\u0019AAP\u0003\u0019\u0011w.\u001e8dKR\u0019aP!\u0002\t\r\u00055%\u00051\u0001z\u0003))\u0007o\\2i\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0005\u0017\u0011i\u0002\u0005\u0003\u0003\u000e\teQB\u0001B\b\u0015\ry#\u0011\u0003\u0006\u0005\u0005'\u0011)\"A\u0005j]R,'O\\1mg*\u0019!qC&\u0002\u000fM$xN]1hK&!!1\u0004B\b\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\"1\u00111[\u0012A\u0002e\fA\u0002\\1uKN$(+Z2pe\u0012$\u0002Ba\t\u00032\tM\"q\u0007\t\u0005\u0005K\u0011i#\u0004\u0002\u0003()!!\u0011\u0006B\u0016\u0003\u0019\u0011XmY8sI*\u0011\u0011jS\u0005\u0005\u0005_\u00119CA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007BBAEI\u0001\u0007\u0011\u0010C\u0005\u00036\u0011\u0002\n\u00111\u0001\u0002 \u00061qN\u001a4tKRD\u0011\"!(%!\u0003\u0005\r!a(\u0002-1\fG/Z:u%\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uII\na\u0003\\1uKN$(+Z2pe\u0012$C-\u001a4bk2$HeM\u0001\tC^\f\u0017\u000e^%T%R\u0019aP!\u0011\t\u000f\t\rs\u00051\u0001\u0003F\u0005\u0011A\u000f\u001d\t\u0005\u0005\u000f\u0012I%\u0004\u0002\u0003,%!!1\nB\u0016\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fab\u0019:fCR,\u0007K]8ek\u000e,'/F\u0001z\u0003E\u0019'/Z1uK\n\u0013xn[3s\r>\u0014\u0018\n\u001a\u000b\u0006s\nU#\u0011\f\u0005\b\u0005/Z\u0003\u0019AAP\u0003\tIG\rC\u0005\u0003\\-\u0002\n\u00111\u0001\u0003^\u0005YRM\\1cY\u0016,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:\u00042\u0001\u0019B0\u0013\r\u0011\t'\u0019\u0002\b\u0005>|G.Z1o\u0003m\u0019'/Z1uK\n\u0013xn[3s\r>\u0014\u0018\n\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\r\u0016\u0005\u0005;\nY\u000b")
public class EpochDrivenReplicationProtocolAcceptanceTest
extends QuorumTestHarness {
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private scala.collection.immutable.Seq<KafkaServer> brokers;
    private KafkaProducer<byte[], byte[]> producer;
    private Consumer<byte[], byte[]> consumer;

    @Override
    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public scala.collection.immutable.Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers(), true);
        super.tearDown();
    }

    @Test
    public void shouldFollowLeaderEpochBasicWorkflow() {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable)x$4 -> this.createBrokerForId(BoxesRunTime.unboxToInt((Object)x$4), false)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((int)0, (int)this.latestRecord(this.leader(), -1, 0).partitionLeaderEpoch());
        Assertions.assertEquals((int)0, (int)this.latestRecord(this.follower(), -1, 0).partitionLeaderEpoch());
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(0, 0L)), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(0, 0L)), (Object)this.epochCache(this.follower()).epochEntries());
        this.bounce(this.follower());
        this.awaitISR(tp);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L)), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(0, 0L)), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L)), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L)), (Object)this.epochCache(this.follower()).epochEntries());
        Assertions.assertEquals((int)1, (int)this.latestRecord(this.leader(), -1, 0).partitionLeaderEpoch());
        Assertions.assertEquals((int)1, (int)this.latestRecord(this.follower(), -1, 0).partitionLeaderEpoch());
        this.bounce(this.leader());
        this.awaitISR(tp);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L)), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((int)2, (int)this.latestRecord(this.leader(), -1, 0).partitionLeaderEpoch());
        Assertions.assertEquals((int)2, (int)this.latestRecord(this.follower(), -1, 0).partitionLeaderEpoch());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)), (Object)this.epochCache(this.follower()).epochEntries());
    }

    @Test
    public void shouldNotAllowDivergentLogs() {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable)id -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$1(this, BoxesRunTime.unboxToInt((Object)id))));
        KafkaServer broker100 = (KafkaServer)this.brokers().apply(0);
        KafkaServer broker101 = (KafkaServer)this.brokers().apply(1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$2(this, BoxesRunTime.unboxToInt((Object)i)));
        broker101.shutdown();
        broker100.shutdown();
        new File((String)broker100.config().logDirs().head(), ".kafka_cleanshutdown").delete();
        this.deleteMessagesFromLogFile(5 * this.msg().length, broker100, 0);
        broker100.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable)i -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$3(this, BoxesRunTime.unboxToInt((Object)i))).foreach((Function1 & Serializable)x$5 -> (RecordMetadata)x$5.get());
        broker101.startup();
        this.waitForLogsToMatch(broker100, broker101, 0);
        Assertions.assertEquals((long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length(), (String)"Log files should match Broker0 vs Broker 1");
    }

    @Test
    public void offsetsShouldNotGoBackwards() {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable)x$6 -> this.createBrokerForId(BoxesRunTime.unboxToInt((Object)x$6), false)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.brokers().foreach((Function1 & Serializable)b -> {
            b.shutdown();
            return BoxedUnit.UNIT;
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), ".kafka_cleanshutdown").delete();
        this.deleteMessagesFromLogFile(this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length() / 2L, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable)x$8 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$4(this, BoxesRunTime.unboxToInt((Object)x$8)));
        this.producer().flush();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable)x$9 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$5(this, BoxesRunTime.unboxToInt((Object)x$9)));
        this.producer().flush();
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), 0);
        this.printSegments();
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        this.startConsumer();
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(this.consumer(), 100, 15000L);
        LongRef prevOffset = LongRef.create((long)-1L);
        records.foreach((Function1 & Serializable)r -> {
            EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$6(prevOffset, r);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length(), (String)"Log files should match Broker0 vs Broker 1");
    }

    @Test
    public void shouldSurviveFastLeaderChange() {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable)x$10 -> this.createBrokerForId(BoxesRunTime.unboxToInt((Object)x$10), false)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        IntRef messagesWritten = IntRef.create((int)1);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
            KafkaServer leader = (KafkaServer)((SeqOps)this.brokers().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$3(leaderId, x$11)))).apply(0);
            KafkaServer follower = (KafkaServer)((SeqOps)this.brokers().filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$4(leaderId, x$12)))).apply(0);
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
            ++messagesWritten$1.elem;
            this.bounce(follower);
            this.log(leader, follower);
            this.awaitISR(tp);
            this.bounce(leader);
            this.log(leader, follower);
            this.awaitISR(tp);
            Assertions.assertTrue((boolean)this.brokers().forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$5(this, messagesWritten, broker))));
        });
    }

    @Test
    public void logsShouldNotDivergeOnUncleanLeaderElections() {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable)x$13 -> this.createBrokerForId(BoxesRunTime.unboxToInt((Object)x$13), true)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), (Seq<KafkaBroker>)this.brokers(), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.MinInSyncReplicasProp(), (Object)"1")})));
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), 0);
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), 0);
        this.printSegments();
        scala.collection.immutable.Seq seq = this.crcSeq$1((KafkaServer)this.brokers().apply(0), 0);
        scala.collection.immutable.Seq seq2 = this.crcSeq$1((KafkaServer)this.brokers().apply(1), 0);
        Assertions.assertTrue((!(seq != null ? !seq.equals(seq2) : seq2 != null) ? 1 : 0) != 0, (String)"Logs on Broker 100 and Broker 101 should match");
    }

    private void log(KafkaServer leader, KafkaServer follower) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Bounce complete for follower ").append(follower.config().brokerId()).toString());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Leader: leo").append(leader.config().brokerId()).append(": ").append(this.getLog(leader, 0).logEndOffset()).append(" cache: ").append(this.epochCache(leader).epochEntries()).toString());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Follower: leo").append(follower.config().brokerId()).append(": ").append(this.getLog(follower, 0).logEndOffset()).append(" cache: ").append(this.epochCache(follower).epochEntries()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForLogsToMatch(KafkaServer b1, KafkaServer b2, int partition) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$waitForLogsToMatch$1(this, b1, partition, b2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Logs didn't match.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private int waitForLogsToMatch$default$3() {
        return 0;
    }

    private void printSegments() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Broker0:");
        DumpLogSegments$.MODULE$.main((String[])new .colon.colon((Object)"--files", (List)new .colon.colon((Object)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).getCanonicalPath(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)));
        this.info((Function0<String>)(Function0 & Serializable)() -> "Broker1:");
        DumpLogSegments$.MODULE$.main((String[])new .colon.colon((Object)"--files", (List)new .colon.colon((Object)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).getCanonicalPath(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private Consumer<byte[], byte[]> startConsumer() {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()));
        consumerConfig.put("fetch.max.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        consumerConfig.put("max.partition.fetch.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        this.consumer_$eq((Consumer<byte[], byte[]>)new KafkaConsumer(consumerConfig, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), 0), (List)Nil$.MODULE$)).asJava());
        this.consumer().seek(new TopicPartition(this.topic(), 0), 0L);
        return this.consumer();
    }

    private void deleteMessagesFromLogFile(long bytes, KafkaServer broker, int partitionId) {
        File logFile = this.getLogFile(broker, partitionId);
        RandomAccessFile writable = new RandomAccessFile(logFile, "rwd");
        writable.setLength(logFile.length() - bytes);
        writable.close();
    }

    private KafkaProducer<byte[], byte[]> createBufferingProducer() {
        String x$1 = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        int x$4 = this.msg().length * 1000;
        long x$6 = 60000L;
        long x$7 = 0x100000L;
        int x$8 = Integer.MAX_VALUE;
        int x$9 = 30000;
        int x$10 = 20000;
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        return TestUtils$.MODULE$.createProducer(x$1, -1, x$6, x$7, x$8, x$9, 10000, x$4, "snappy", x$10, x$11, (Option<File>)x$12, (Option<Properties>)x$13, x$14, x$15, x$16);
    }

    private File getLogFile(KafkaServer broker, int partition) {
        UnifiedLog log = this.getLog(broker, partition);
        log.flush(false);
        return ((File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])log.dir().listFiles()), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$getLogFile$1(x$15))))[0];
    }

    private UnifiedLog getLog(KafkaServer broker, int partition) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(this.topic(), partition);
        boolean x$2 = qual$1.getLog$default$2();
        return (UnifiedLog)qual$1.getLog(x$1, x$2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void bounce(KafkaServer follower) {
        follower.shutdown();
        follower.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private LeaderEpochFileCache epochCache(KafkaServer broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache().get();
    }

    private RecordBatch latestRecord(KafkaServer leader, int offset, int partition) {
        return (RecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(this.getLog((KafkaServer)leader, (int)partition).activeSegment().read((long)0L, (int)Integer.MAX_VALUE).records.batches()).asScala().toSeq().last();
    }

    private int latestRecord$default$2() {
        return -1;
    }

    private int latestRecord$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$awaitISR$1(this, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for replicas to join ISR");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), -1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);
    }

    private KafkaServer leader() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((IterableOps)this.brokers().filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$leader$1(leaderId, x$16)))).head();
    }

    private KafkaServer follower() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leader = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((IterableOps)this.brokers().filter((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$follower$1(leader, x$17)))).head();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaServer createBrokerForId(int id, boolean enableUncleanLeaderElection) {
        void createServer_time;
        void createServer_config;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        TestUtils$.MODULE$.setIbpAndMessageFormatVersions(config, this.metadataVersion());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(enableUncleanLeaderElection));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(config);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        return createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
    }

    private boolean createBrokerForId$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ KafkaServer $anonfun$shouldNotAllowDivergentLogs$1(EpochDrivenReplicationProtocolAcceptanceTest $this, int id) {
        void createServer_time;
        Time time = Time.SYSTEM;
        KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, $this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
    }

    public static final /* synthetic */ RecordMetadata $anonfun$shouldNotAllowDivergentLogs$2(EpochDrivenReplicationProtocolAcceptanceTest $this, int i) {
        return (RecordMetadata)$this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)$this.msg())).get();
    }

    public static final /* synthetic */ Future $anonfun$shouldNotAllowDivergentLogs$3(EpochDrivenReplicationProtocolAcceptanceTest $this, int i) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$4(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$8) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$5(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$9) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ void $anonfun$offsetsShouldNotGoBackwards$6(LongRef prevOffset$1, ConsumerRecord r) {
        Assertions.assertTrue((r.offset() > prevOffset$1.elem ? 1 : 0) != 0, (String)new StringBuilder(21).append("Offset ").append(prevOffset$1.elem).append(" came before ").append(r.offset()).append(" ").toString());
        prevOffset$1.elem = r.offset();
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$3(int leaderId$1, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$4(int leaderId$1, KafkaServer x$12) {
        return x$12.config().brokerId() != leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$5(EpochDrivenReplicationProtocolAcceptanceTest $this, IntRef messagesWritten$1, KafkaServer broker) {
        return $this.getLog(broker, 0).logEndOffset() == (long)messagesWritten$1.elem;
    }

    private final scala.collection.immutable.Seq crcSeq$1(KafkaServer broker, int partition) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.IterableHasAsScala(this.getLog((KafkaServer)broker, (int)partition).activeSegment().read((long)0L, (int)Integer.MAX_VALUE).records.batches()).asScala().toSeq().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.checksum()));
    }

    private static final int crcSeq$default$2$1() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$waitForLogsToMatch$1(EpochDrivenReplicationProtocolAcceptanceTest $this, KafkaServer b1$1, int partition$1, KafkaServer b2$1) {
        return $this.getLog(b1$1, partition$1).logEndOffset() == $this.getLog(b2$1, partition$1).logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitForLogsToMatch$2() {
        return "Logs didn't match.";
    }

    public static final /* synthetic */ boolean $anonfun$getLogFile$1(File x$15) {
        return x$15.getName().endsWith(".log");
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(EpochDrivenReplicationProtocolAcceptanceTest $this, TopicPartition tp$2) {
        return ((Partition)$this.leader().replicaManager().onlinePartition(tp$2).get()).inSyncReplicaIds().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    public static final /* synthetic */ boolean $anonfun$leader$1(int leaderId$2, KafkaServer x$16) {
        return x$16.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$follower$1(int leader$2, KafkaServer x$17) {
        return x$17.config().brokerId() != leader$2;
    }

    public EpochDrivenReplicationProtocolAcceptanceTest() {
        this.topic = "topic1";
    }
}

