/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Q3A!\u0002\u0004\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C))!)Q\u0005\u0001C\u0001M!)a\n\u0001C\u0001\u001f\nq3i\u001c8tk6,'oV5uQ2+w-Y2z\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;J]R,wM]1uS>tG+Z:u\u0015\t9\u0001\"A\u0002ba&T\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\ta!\u0003\u0002\u0010\r\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#\u0001\n\u0011\u00055\u0001\u0011a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0003V]&$\b\"\u0002\u000f\u0003\u0001\u0004i\u0012A\u00039s_B,'\u000f^5fgB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005kRLGNC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"A\u0003)s_B,'\u000f^5fg\u0006\u0019B/Z:u\u001f\u001a47/\u001a;t\r>\u0014H+[7fgR\u0011Qc\n\u0005\u0006Q\r\u0001\r!K\u0001\u0007cV|'/^7\u0011\u0005)\ndBA\u00160!\tas#D\u0001.\u0015\tq#\"\u0001\u0004=e>|GOP\u0005\u0003a]\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001g\u0006\u0015\u0003\u0007U\u0002\"AN \u000e\u0003]R!\u0001O\u001d\u0002\rA\f'/Y7t\u0015\tQ4(A\u0004kkBLG/\u001a:\u000b\u0005qj\u0014!\u00026v]&$(\"\u0001 \u0002\u0007=\u0014x-\u0003\u0002Ao\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\t\r\u0011\u0005*\u0013\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b^\n\u0001\u0002\u001d:pm&$WM]\u0005\u0003\u000f\u0012\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHF\u0001&MC\u0005Y\u0015A\u0001>lC\u0005i\u0015!B6sC\u001a$\u0018a\u0007;fgR,\u0015M\u001d7jKN$xJ\u001d'bi\u0016\u001cHo\u00144gg\u0016$8\u000f\u0006\u0002\u0016!\")\u0001\u0006\u0002a\u0001S!\u0012A!\u000e\u0015\u0005\t\tC5\u000b\f\u0002K\u0019\u0002")
public class ConsumerWithLegacyMessageFormatIntegrationTest
extends AbstractConsumerTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        if (!this.isKRaftTest()) {
            properties.put("inter.broker.protocol.version", "2.8");
            return;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetsForTimes(String quorum) {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic1, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic2, numParts, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic3, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition(topic1, 0), Predef$.MODULE$.long2Long(-1L))));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)topic -> {
            ConsumerWithLegacyMessageFormatIntegrationTest.$anonfun$testOffsetsForTimes$2(this, numParts, producer, timestampsToSearch, i, topic);
            return BoxedUnit.UNIT;
        });
        Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTopic1P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0));
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P0.leaderEpoch());
        OffsetAndTimestamp timestampTopic1P1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1));
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P1.leaderEpoch());
        if (!this.isKRaftTest()) {
            Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic2, 0)), (String)"null should be returned when message format is 0.9.0");
            Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic2, 1)), (String)"null should be returned when message format is 0.9.0");
        } else {
            OffsetAndTimestamp timestampTopic2P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic2, 0));
            Assertions.assertEquals((long)40L, (long)timestampTopic2P0.offset());
            Assertions.assertEquals((long)40L, (long)timestampTopic2P0.timestamp());
            Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic2P0.leaderEpoch());
            OffsetAndTimestamp timestampTopic2P1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic2, 1));
            Assertions.assertEquals((long)60L, (long)timestampTopic2P1.offset());
            Assertions.assertEquals((long)60L, (long)timestampTopic2P1.timestamp());
            Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic2P1.leaderEpoch());
        }
        OffsetAndTimestamp timestampTopic3P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0));
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.offset());
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic3P0.leaderEpoch());
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEarliestOrLatestOffsets(String quorum) {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.createTopicAndSendRecords(producer, topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic1, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 100, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t0p0)));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t0p1)));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t1p0)));
        Map latests = consumer.endOffsets((Collection)partitions);
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t0p0)));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t0p1)));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t1p0)));
    }

    public static final /* synthetic */ void $anonfun$testOffsetsForTimes$2(ConsumerWithLegacyMessageFormatIntegrationTest $this, int numParts$1, KafkaProducer producer$1, HashMap timestampsToSearch$1, IntRef i$1, String topic) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numParts$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic, part);
            $this.sendRecords((KafkaProducer<byte[], byte[]>)producer$1, 100, tp, 0L);
            timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
    }
}

