/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.RequestLocal$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.Lz4Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.compress.SnappyCompression;
import org.apache.kafka.common.compress.ZstdCompression;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.RecordValidationException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001da\u0001\u00021b\u0001\u0019DQ!\u001c\u0001\u0005\u00029Dq!\u001d\u0001C\u0002\u0013\u0005!\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B:\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0001\u0002CA\b\u0001\u0001\u0006I!a\u0002\t\u0013\u0005E\u0001A1A\u0005\u0002\u0005M\u0001\u0002CA\u001f\u0001\u0001\u0006I!!\u0006\t\u0013\u0005}\u0002A1A\u0005\u0002\u0005\u0005\u0003\u0002CA/\u0001\u0001\u0006I!a\u0011\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0004bBAB\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003\u000f\u0003A\u0011AA1\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!!,\u0001\t\u0013\ty\u000bC\u0004\u00028\u0002!I!!/\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9!q\u0002\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B\n\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005/\u0001A\u0011AA1\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqA!\t\u0001\t\u0003\t\t\u0007C\u0004\u0003&\u0001!IAa\n\t\u000f\t5\u0002\u0001\"\u0001\u0002b!9!\u0011\u0007\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B\u001b\u0001\u0011%!q\u0007\u0005\b\u0005w\u0001A\u0011AA1\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003Z\u0001!\t!!\u0019\t\u000f\tu\u0003\u0001\"\u0001\u0002b!9!\u0011\r\u0001\u0005\n\t\r\u0004b\u0002B4\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005W\u0002A\u0011AA1\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005cBqA!\u001e\u0001\t\u0003\t\t\u0007C\u0004\u0003z\u0001!\t!!\u0019\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000!9!Q\u0011\u0001\u0005\u0002\u0005\u0005\u0004b\u0002BE\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005\u001b\u0003A\u0011AA1\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'CqAa&\u0001\t\u0003\t\t\u0007C\u0004\u0003\u001c\u0002!\t!!\u0019\t\u000f\t}\u0005\u0001\"\u0001\u0002b!9!1\u0015\u0001\u0005\u0002\u0005\u0005\u0004b\u0002BT\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005W\u0003A\u0011AA1\u0011\u001d\u0011y\u000b\u0001C\u0001\u0003CBqAa-\u0001\t\u0003\t\t\u0007C\u0004\u00038\u0002!\t!!\u0019\t\u000f\tm\u0006\u0001\"\u0001\u0002b!9!q\u0018\u0001\u0005\u0002\u0005\u0005\u0004b\u0002Bb\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005\u000f\u0004A\u0011AA1\u0011\u001d\u0011Y\r\u0001C\u0001\u0003CBqAa4\u0001\t\u0003\t\t\u0007C\u0004\u0003T\u0002!\t!!\u0019\t\u000f\t]\u0007\u0001\"\u0001\u0002b!9!1\u001c\u0001\u0005\u0002\u0005\u0005\u0004b\u0002Bp\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005G\u0004A\u0011AA1\u0011\u001d\u00119\u000f\u0001C\u0001\u0003CBqAa;\u0001\t\u0003\t\t\u0007C\u0004\u0003p\u0002!\t!!\u0019\t\u000f\tM\b\u0001\"\u0001\u0002b!9!q\u001f\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B~\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005\u007f\u0004A\u0011AA1\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0003CBqaa\u0002\u0001\t\u0003\t\t\u0007C\u0004\u0004\f\u0001!\t!!\u0019\t\u000f\r=\u0001\u0001\"\u0001\u0002b!911\u0003\u0001\u0005\u0002\u0005\u0005\u0004bBB\f\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u00077\u0001A\u0011AA1\u0011\u001d\u0019y\u0002\u0001C\u0001\u0003CBqaa\t\u0001\t\u0003\t\t\u0007C\u0004\u0004(\u0001!\t!!\u0019\t\u000f\r-\u0002\u0001\"\u0001\u0002b!91q\u0006\u0001\u0005\u0002\u0005\u0005\u0004bBB\u001a\u0001\u0011%1Q\u0007\u0005\b\u0007w\u0001A\u0011BB\u001f\u0011%\u0019\t\u0006AI\u0001\n\u0013\u0019\u0019\u0006C\u0004\u0004<\u0001!Ia!\u001b\t\u000f\r-\u0005\u0001\"\u0003\u0004\u000e\"I1Q\u0013\u0001\u0012\u0002\u0013%11\u000b\u0005\n\u0007/\u0003\u0011\u0013!C\u0005\u00073Cqa!(\u0001\t\u0013\u0019y\nC\u0004\u0004&\u0002!\taa*\t\u000f\r=\u0006\u0001\"\u0003\u00042\"911\u0018\u0001\u0005\n\ru\u0006bBBe\u0001\u0011\u000511\u001a\u0005\b\u00077\u0004A\u0011ABo\u0011\u001d\u0019I\u000f\u0001C\u0001\u0007W\u0014\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\t\u001c\u0017a\u00017pO*\tA-A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0007C\u00015l\u001b\u0005I'\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_B\u0011\u0001\u000fA\u0007\u0002C\u0006!A/[7f+\u0005\u0019\bC\u0001;\u007f\u001b\u0005)(B\u0001<x\u0003\u0015)H/\u001b7t\u0015\tA\u00180\u0001\u0004d_6lwN\u001c\u0006\u0003IjT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011q0\u001e\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u0017i\u0011a^\u0005\u0004\u0003\u001b9(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005iQ.\u001a;sS\u000e\u001c8*Z=TKR,\"!!\u0006\u0011\r\u0005]\u0011\u0011EA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003?I\u0017AC2pY2,7\r^5p]&!\u00111EA\r\u0005\r\u0019V\r\u001e\t\u0005\u0003O\tI$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011\u0019wN]3\u000b\t\u0005=\u0012\u0011G\u0001\b[\u0016$(/[2t\u0015\u0011\t\u0019$!\u000e\u0002\re\fW.\\3s\u0015\t\t9$A\u0002d_6LA!a\u000f\u0002*\tQQ*\u001a;sS\u000et\u0015-\\3\u0002\u001d5,GO]5dg.+\u0017pU3uA\u0005yQ.\u001a;sS\u000e\u001c(+Z2pe\u0012,'/\u0006\u0002\u0002DA!\u0011QIA,\u001d\u0011\t9%a\u0015\u000e\u0005\u0005%#b\u00012\u0002L)!\u0011QJA(\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002Re\fqa\u001d;pe\u0006<W-\u0003\u0003\u0002V\u0005%\u0013\u0001\u0004'pOZ\u000bG.\u001b3bi>\u0014\u0018\u0002BA-\u00037\u0012q\"T3ue&\u001c7OU3d_J$WM\u001d\u0006\u0005\u0003+\nI%\u0001\tnKR\u0014\u0018nY:SK\u000e|'\u000fZ3sA\u0005\u0001B/Z:u\u001f:d\u0017p\u00148f\u0005\u0006$8\r\u001b\u000b\u0003\u0003G\u00022\u0001[A3\u0013\r\t9'\u001b\u0002\u0005+:LG\u000fK\u0002\u000b\u0003W\u0002B!!\u001c\u0002|5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0002ba&TA!!\u001e\u0002x\u00059!.\u001e9ji\u0016\u0014(bAA=y\u0006)!.\u001e8ji&!\u0011QPA8\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f^!mY><X*\u001e7uS\n\u000bGo\u00195)\u0007-\tY'\u0001\u001buKN$h+\u00197jI\u0006$\u0018n\u001c8PM\n\u000bGo\u00195fg^KG\u000f\u001b(p]N+\u0017/^3oi&\fG.\u00138oKJ|eMZ:fiND3\u0001DA6\u0003E!Xm\u001d;NSNl\u0015\r^2i\u001b\u0006<\u0017n\u0019\u0015\u0004\u001b\u0005-\u0014!E2iK\u000e\\wJ\u001c7z\u001f:,')\u0019;dQRA\u00111MAH\u00033\u000bI\u000bC\u0004\u0002\u0012:\u0001\r!a%\u0002\u000b5\fw-[2\u0011\u0007!\f)*C\u0002\u0002\u0018&\u0014AAQ=uK\"9\u00111\u0014\bA\u0002\u0005u\u0015!E:pkJ\u001cWmQ8naJ,7o]5p]B!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$^\f\u0001bY8naJ,7o]\u0005\u0005\u0003O\u000b\tKA\u0006D_6\u0004(/Z:tS>t\u0007bBAV\u001d\u0001\u0007\u0011QT\u0001\u0012i\u0006\u0014x-\u001a;D_6\u0004(/Z:tS>t\u0017\u0001F2iK\u000e\\\u0017\t\u001c7po6+H\u000e^5CCR\u001c\u0007\u000e\u0006\u0005\u0002d\u0005E\u00161WA[\u0011\u001d\t\tj\u0004a\u0001\u0003'Cq!a'\u0010\u0001\u0004\ti\nC\u0004\u0002,>\u0001\r!!(\u0002%\rDWmY6NSNl\u0017\r^2i\u001b\u0006<\u0017n\u0019\u000b\t\u0003G\nY,a0\u0002D\"9\u0011Q\u0018\tA\u0002\u0005M\u0015A\u00032bi\u000eDW*Y4jG\"9\u0011\u0011\u0019\tA\u0002\u0005M\u0015a\u0003:fG>\u0014H-T1hS\u000eDq!!2\u0011\u0001\u0004\ti*A\u0006d_6\u0004(/Z:tS>t\u0017\u0001\u0005<bY&$\u0017\r^3NKN\u001c\u0018mZ3t))\tY-!=\u0003\u0002\t\r!Q\u0002\t\u0005\u0003\u001b\fiO\u0004\u0003\u0002P\u0006Mc\u0002BAi\u0003WtA!a5\u0002j:!\u0011Q[At\u001d\u0011\t9.!:\u000f\t\u0005e\u00171\u001d\b\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\\3\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0018BA>}\u0013\t!'0C\u0002\u0002ReLA!!\u0014\u0002P%\u0019!-a\u0013\n\t\u0005=\u00181\f\u0002\u0011-\u0006d\u0017\u000eZ1uS>t'+Z:vYRDq!a=\u0012\u0001\u0004\t)0A\u0004sK\u000e|'\u000fZ:\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?x\u0003\u0019\u0011XmY8sI&!\u0011q`A}\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011\u0011S\tA\u0002\u0005M\u0005b\u0002B\u0003#\u0001\u0007!qA\u0001\u0016g>,(oY3D_6\u0004(/Z:tS>tG+\u001f9f!\u0011\t9P!\u0003\n\t\t-\u0011\u0011 \u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"9\u00111V\tA\u0002\u0005u\u0015\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-BB3AEA6\u0003\u0001\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007M\tY'\u0001\u0011uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u0013\u0004f\u0001\u000b\u0002l\u0005y2\r[3dW2{w-\u00119qK:$G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3\u0015\t\u0005\r$q\u0004\u0005\b\u0003#+\u0002\u0019AAJ\u0003\u0011\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]Z\u000b\u0004f\u0001\f\u0002l\u0005\u00193\r[3dW2{w-\u00119qK:$G+[7f/&$\bNU3d_6\u0004(/Z:tS>tG\u0003BA2\u0005SAqAa\u000b\u0018\u0001\u0004\t\u0019*A\u0006uCJ<W\r^'bO&\u001c\u0017\u0001\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f\u001b*fG>l\u0007O]3tg&|gN\u0016\u001a)\u0007a\tY'A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u000b\u0004fA\r\u0002l\u000513\r[3dW2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\t\u0005\r$\u0011\b\u0005\b\u0003#S\u0002\u0019AAJ\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e*b]\u001e,\u0017I\u001c3SK\u000e|'\u000fZ\"pk:$\bfA\u000e\u0002l\u0005\u0001\u0013m]:feRLeN^1mS\u0012\u0014\u0015\r^2i\u0007>,h\u000e^(wKJ\u0014\u0018\u000eZ3t)\u0019\t\u0019Ga\u0011\u0003N!9!Q\t\u000fA\u0002\t\u001d\u0013a\u00047bgR|eMZ:fi\u0012+G\u000e^1\u0011\u0007!\u0014I%C\u0002\u0003L%\u00141!\u00138u\u0011\u001d\u0011y\u0005\ba\u0001\u0005\u000f\nQaY8v]R\fQE^1mS\u0012\fG/\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5D_VtGo\u0014<feJLG-Z:\u0015\r\u0005\r$Q\u000bB,\u0011\u001d\u0011)%\ba\u0001\u0005\u000fBqAa\u0014\u001e\u0001\u0004\u00119%A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u0013\u0004f\u0001\u0010\u0002l\u0005\u0019B/Z:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3Wc!\u001aq$a\u001b\u0002%\rDWmY6O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003G\u0012)\u0007C\u0004\u0002\u0012\u0002\u0002\r!a%\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007\u0005\nY'A\nuKN$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007K\u0002#\u0003W\n!c\u00195fG.\u0014VmY8naJ,7o]5p]R!\u00111\rB:\u0011\u001d\t\tj\ta\u0001\u0003'\u000b1\u0003^3tiJ+7m\\7qe\u0016\u001c8/[8o-JB3\u0001JA6\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o-B\"vNV\u0019)\u0007\u0015\nY'A\u0011dQ\u0016\u001c7n\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c$s_64\u0006\u0007\u0006\u0003\u0002d\t\u0005\u0005b\u0002BBM\u0001\u0007\u00111S\u0001\bi>l\u0015mZ5d\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o-B\"vN\u0016\u001a)\u0007\u001d\nY'\u0001\u0011uKN$8I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gNV\u0019U_Z\u0013\u0004f\u0001\u0015\u0002l\u0005\u0001B/Z:u\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004S\u0005-\u0014aD2iK\u000e\\7i\\7qe\u0016\u001c8/\u001a3\u0015\t\u0005\r$Q\u0013\u0005\b\u0003#S\u0003\u0019AAJ\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124&\u0007K\u0002,\u0003W\nA\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004Y\u0005-\u0014\u0001\n;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u00075\nY'A\u0011uKN$\u0018J\u001c<bY&$7I]3bi\u0016$\u0016.\\3D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002/\u0003W\n\u0011\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWmQ8naJ,7o]3e-JB3aLA6\u0003%\"Xm\u001d;BEN|G.\u001e;f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fI\"\u001a\u0001'a\u001b\u0002MQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,G\rK\u00022\u0003W\n1\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004e\u0005-\u0014a\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007M\nY'\u0001\u0015uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u00124\u0016\u0007K\u00025\u0003W\n\u0001\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3e-JB3!NA6\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3ANA6\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u0013dj\u001c8D_6\u0004(/Z:tK\u0012D3aNA6\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000b4i\\7qe\u0016\u001c8/\u001a3)\u0007a\nY'A\u001buKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,3\u0007>l\u0007O]3tg\u0016$\u0007fA\u001d\u0002l\u00059C/Z:u\u0007>tGO]8m%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$gI]8n\u00072LWM\u001c;tQ\rQ\u00141N\u0001 i\u0016\u001cHoQ8oiJ|GNU3d_J$7OT8u\u0007>l\u0007O]3tg\u0016$\u0007fA\u001e\u0002l\u0005QD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-F\"vN\u0016\u0019O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004y\u0005-\u0014a\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4\u0016\u0007V8Wa\r{W\u000e\u001d:fgN,G\rK\u0002>\u0003W\n\u0001\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WcQ{gK\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002?\u0003W\nQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WcQ{gKM\"p[B\u0014Xm]:fI\"\u001aq(a\u001b\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016GT8o\u0007>l\u0007O]3tg\u0016$\u0007f\u0001!\u0002l\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vNV\u0019D_6\u0004(/Z:tK\u0012D3!QA6\u0003Q\"Xm\u001d;E_^t7i\u001c8wKJ\u001c\u0018n\u001c8PMR\u0013\u0018M\\:bGRLwN\\1m%\u0016\u001cwN\u001d3t\u001d>$\b+\u001a:nSR$X\r\u001a\u0015\u0004\u0005\u0006-\u0014!\r;fgR$un\u001e8D_:4XM]:j_:|e-\u00133f[B|G/\u001a8u%\u0016\u001cwN\u001d3t\u001d>$\b+\u001a:nSR$X\r\u001a\u0015\u0004\u0007\u0006-\u0014A\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4&\u0007V8Wa9{gnQ8naJ,7o]3eQ\r!\u00151N\u00018i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u00034i\\7qe\u0016\u001c8/\u001a3)\u0007\u0015\u000bY'\u0001\u001auKN$hj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:e\u0005\u0006$8\r\u001b%bg6+GO]5dg2{wmZ3eQ\r1\u00151N\u0001,i\u0016\u001cHoQ8naJ,7o]3e\u0005\u0006$8\r[,ji\"|W\u000f\u001e*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\"\u001aq)a\u001b\u0002WQ,7\u000f\u001e.Ti\u0012\u001cu.\u001c9sKN\u001cX\rZ,ji\",f.\u0019<bS2\f'\r\\3J\u0005B3VM]:j_:D3\u0001SA6\u00035\"Xm\u001d;V]\u000e|W\u000e\u001d:fgN,GMQ1uG\"<\u0016\u000e\u001e5pkR\u0014VmY8sINtu\u000e^!mY><X\r\u001a\u0015\u0004\u0013\u0006-\u0014!\f;fgR\u0014VmY8naJ,7o]3e\u0005\u0006$8\r[,ji\"|W\u000f\u001e*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\"\u001a!*a\u001b\u0002UQ,7\u000f^%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7q\u000bb\u001cW\r\u001d;j_:D\u0015m\u001d\"bi\u000eD\u0017J\u001c3fq\"\u001a1*a\u001b\u0002OQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fG>\u0014H-\u0012=dKB$\u0018n\u001c8ICN\u0014\u0015\r^2i\u0013:$W\r\u001f\u0015\u0004\u0019\u0006-\u0014A\f;fgR\u0014\u0015\r^2i/&$\b.\u00138wC2LGMU3d_J$7/\u00118e\u0013:4\u0018\r\\5e)&lWm\u001d;b[BD3!TA6\u0003\u0015\"Xm\u001d;SK\u000e|'\u000fZ,ji\"\u0004\u0016m\u001d;US6,7\u000f^1na&\u001b(+\u001a6fGR,G\rK\u0002O\u0003W\nq\u0005^3tiJ+7m\u001c:e/&$\bNR;ukJ,G+[7fgR\fW\u000e]%t%\u0016TWm\u0019;fI\"\u001aq*a\u001b\u0002WQ,7\u000f\u001e#jM\u001a,'/\u001a8u\u0019\u00164X\r\u001c#pKNtu\u000e^\"bkN,'+Z2p[B\u0014Xm]:j_:D3\u0001UA6\u0003\u0015\"Xm\u001d;ES\u001a4WM]3oi\u000e{G-Z2DCV\u001cXm\u001d*fG>l\u0007O]3tg&|g\u000eK\u0002R\u0003W\n\u0011\u0005^3ti\n\u000bGo\u00195XSRDw.\u001e;SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u0012$b!a\u0019\u00048\re\u0002bBAN%\u0002\u0007!q\u0001\u0005\b\u0003W\u0013\u0006\u0019AAO\u00035\u0019'/Z1uKJ+7m\u001c:egRA\u0011Q_B \u0007\u0007\u001ai\u0005C\u0004\u0004BM\u0003\r!a%\u0002\u00155\fw-[2WC2,X\rC\u0005\u0004FM\u0003\n\u00111\u0001\u0004H\u0005IA/[7fgR\fW\u000e\u001d\t\u0004Q\u000e%\u0013bAB&S\n!Aj\u001c8h\u0011\u001d\u0019ye\u0015a\u0001\u0003;\u000bQaY8eK\u000e\fqc\u0019:fCR,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rU#\u0006BB$\u0007/Z#a!\u0017\u0011\t\rm3QM\u0007\u0003\u0007;RAaa\u0018\u0004b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007GJ\u0017AC1o]>$\u0018\r^5p]&!1qMB/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u000b\u0003k\u001cYg!\"\u0004\b\u000e%\u0005bBAz+\u0002\u00071Q\u000e\t\u0007\u0007_\u001aIha \u000f\t\rE4Q\u000f\b\u0005\u00037\u001c\u0019(C\u0001k\u0013\r\u00199([\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019Yh! \u0003\t1K7\u000f\u001e\u0006\u0004\u0007oJ\u0007#\u00025\u0004\u0002\u0006M\u0015bABBS\n)\u0011I\u001d:bs\"91\u0011I+A\u0002\u0005M\u0005bBB#+\u0002\u00071q\t\u0005\b\u0007\u001f*\u0006\u0019AAO\u0003\u0001\u001a'/Z1uK:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000fZ:\u0015\u0011\u0005U8qRBI\u0007'Cqa!\u0011W\u0001\u0004\t\u0019\nC\u0005\u0004FY\u0003\n\u00111\u0001\u0004H!I1q\n,\u0011\u0002\u0003\u0007\u0011QT\u0001+GJ,\u0017\r^3O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003)\u001a'/Z1uK:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"aa'+\t\u0005u5qK\u0001\u0018GJ,\u0017\r^3Uo>\u0014\u0015\r^2iK\u0012\u0014VmY8sIN$b!!>\u0004\"\u000e\r\u0006bBB!3\u0002\u0007\u00111\u0013\u0005\b\u0007\u001fJ\u0006\u0019AAO\u00031\u0019\u0007.Z2l\u001f\u001a47/\u001a;t)\u0019\t\u0019g!+\u0004,\"9\u00111\u001f.A\u0002\u0005U\bbBBW5\u0002\u00071qI\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018\u0001\n:fG>\u0014Hm],ji\"tuN\\*fcV,g\u000e^5bY&sg.\u001a:PM\u001a\u001cX\r^:\u0015\u0011\u0005U81WB[\u0007oCqa!\u0011\\\u0001\u0004\t\u0019\nC\u0004\u0002Fn\u0003\r!!(\t\u000f\re6\f1\u0001\u0003H\u0005Qa.^7SK\u000e|'\u000fZ:\u00029I,7m\u001c:eg^KG\u000f[%om\u0006d\u0017\u000eZ%o]\u0016\u0014X*Y4jGRA\u0011Q_B`\u0007\u0007\u001c9\rC\u0004\u0004Br\u0003\r!a%\u0002\u001f\t\fGo\u00195NC\u001eL7MV1mk\u0016Dqa!2]\u0001\u0004\t\u0019*\u0001\tsK\u000e|'\u000fZ'bO&\u001cg+\u00197vK\"91q\n/A\u0002\u0005u\u0015aF7bs\n,7\t[3dW\n\u000b7/\u001a+j[\u0016\u001cH/Y7q)\u0019\t\u0019g!4\u0004R\"91qZ/A\u0002\r\u001d\u0013\u0001C3ya\u0016\u001cG/\u001a3\t\u000f\rMW\f1\u0001\u0004V\u0006)!-\u0019;dQB!\u0011q_Bl\u0013\u0011\u0019I.!?\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r[\u0001\u0016m\u0006d\u0017\u000eZ1uK2{w-\u00119qK:$G+[7f)!\t\u0019ga8\u0004d\u000e\u001d\bbBBq=\u0002\u00071qI\u0001\u0016Kb\u0004Xm\u0019;fI2{w-\u00119qK:$G+[7f\u0011\u001d\u0019)O\u0018a\u0001\u0007\u000f\nQ#\u001a=qK\u000e$X\r\u001a\"bg\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0004Tz\u0003\ra!6\u00027Y,'/\u001b4z%\u0016\u001cwN\u001d3WC2LG-\u0019;j_:\u001cF/\u0019;t))\t\u0019g!<\u0004x\u000em8Q \u0005\b\u0007_|\u0006\u0019ABy\u0003\u0015\u0019H/\u0019;t!\u0011\t9pa=\n\t\rU\u0018\u0011 \u0002\u0016%\u0016\u001cwN\u001d3WC2LG-\u0019;j_:\u001cF/\u0019;t\u0011\u001d\u0019Ip\u0018a\u0001\u0005\u000f\n1C\\;n\u0007>tg/\u001a:uK\u0012\u0014VmY8sINDq!a=`\u0001\u0004\t)\u0010C\u0004\u0004\u0000~\u0003\r\u0001\"\u0001\u0002\u0015\r|W\u000e\u001d:fgN,G\rE\u0002i\t\u0007I1\u0001\"\u0002j\u0005\u001d\u0011un\u001c7fC:\u0004")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();
    private final LogValidator.MetricsRecorder metricsRecorder;

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    public LogValidator.MetricsRecorder metricsRecorder() {
        return this.metricsRecorder;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, (Compression)new GzipCompression.Builder().build(), (Compression)new GzipCompression.Builder().build());
        this.checkOnlyOneBatch((byte)1, (Compression)new GzipCompression.Builder().build(), (Compression)new GzipCompression.Builder().build());
        this.checkOnlyOneBatch((byte)2, (Compression)new GzipCompression.Builder().build(), (Compression)new GzipCompression.Builder().build());
        this.checkOnlyOneBatch((byte)0, (Compression)new GzipCompression.Builder().build(), (Compression)Compression.NONE);
        this.checkOnlyOneBatch((byte)1, (Compression)new GzipCompression.Builder().build(), (Compression)Compression.NONE);
        this.checkOnlyOneBatch((byte)2, (Compression)new GzipCompression.Builder().build(), (Compression)Compression.NONE);
        this.checkOnlyOneBatch((byte)2, (Compression)Compression.NONE, (Compression)Compression.NONE);
        this.checkOnlyOneBatch((byte)2, (Compression)Compression.NONE, (Compression)new GzipCompression.Builder().build());
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, (Compression)Compression.NONE, (Compression)Compression.NONE);
        this.checkAllowMultiBatch((byte)1, (Compression)Compression.NONE, (Compression)Compression.NONE);
        this.checkAllowMultiBatch((byte)0, (Compression)Compression.NONE, (Compression)new GzipCompression.Builder().build());
        this.checkAllowMultiBatch((byte)1, (Compression)Compression.NONE, (Compression)new GzipCompression.Builder().build());
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values()), (Function1 & Serializable)version -> {
            this.testMessageValidation$1(version.value);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMisMatchMagic() {
        GzipCompression compression = new GzipCompression.Builder().build();
        this.checkMismatchMagic((byte)0, (byte)1, (Compression)compression);
        this.checkMismatchMagic((byte)1, (byte)0, (Compression)compression);
    }

    private void checkOnlyOneBatch(byte magic, Compression sourceCompression, Compression targetCompression) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(this.createTwoBatchedRecords(magic, sourceCompression), magic, sourceCompression.type(), targetCompression));
    }

    private void checkAllowMultiBatch(byte magic, Compression sourceCompression, Compression targetCompression) {
        this.validateMessages(this.createTwoBatchedRecords(magic, sourceCompression), magic, sourceCompression.type(), targetCompression);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, Compression compression) {
        Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compression), batchMagic, compression.type(), compression));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, Compression targetCompression) {
        MockTime mockTime = new MockTime(0L, 0L);
        return new LogValidator(records, this.topicPartition(), (Time)mockTime, sourceCompressionType, targetCompression, false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.IBP_2_3_IV1).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    @Test
    public void testLogAppendTimeNonCompressedV0() {
        this.checkLogAppendTimeNonCompressed((byte)0);
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    @Test
    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        int n;
        MockTime mockTime = new MockTime();
        MemoryRecords records = this.createRecords(magic, 1234L, (Compression)Compression.NONE);
        PrimitiveRef.LongRef offsetCounter = PrimitiveRef.ofLong((long)0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.NONE, (Compression)Compression.NONE, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(offsetCounter, this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        Assertions.assertEquals((long)offsetCounter.value, (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size(), (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        if (magic >= 1) {
            validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        }
        Assertions.assertEquals((long)(magic == 0 ? -1L : now), (long)validatedResults.maxTimestampMs);
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        switch (magic) {
            case 0: {
                n = -1;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            default: {
                n = 2;
            }
        }
        Assertions.assertEquals((long)n, (long)validatedResults.shallowOffsetOfMaxTimestamp);
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 0, records, false);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        GzipCompression compression = new GzipCompression.Builder().build();
        MockTime mockTime = new MockTime();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)compression);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.GZIP, (Compression)compression, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size(), (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, -1L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)2L, (long)validatedResults.shallowOffsetOfMaxTimestamp, (String)"The shallow offset of max timestamp should be 2 if logAppendTime is used");
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size may have been changed");
        RecordValidationStats stats = validatedResults.recordValidationStats;
        this.verifyRecordValidationStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        GzipCompression compression = new GzipCompression.Builder().build();
        MockTime mockTime = new MockTime();
        MemoryRecords records = this.createRecords(magic, 1234L, (Compression)compression);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.GZIP, (Compression)compression, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size(), (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)2L, (long)validatedResults.shallowOffsetOfMaxTimestamp, (String)"The shallow offset of max timestamp should be the last offset 2 if logAppendTime is used");
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, (Compression)Compression.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)new GzipCompression.Builder().build(), false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        .colon.colon recordList = new .colon.colon((Object)new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes()), (List)Nil$.MODULE$)));
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])((SimpleRecord[])recordList.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        PrimitiveRef.LongRef offsetCounter = PrimitiveRef.ofLong((long)0L);
        LogValidator.ValidationResult validatingResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)Compression.NONE, false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(offsetCounter, this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatingResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, bl2, n3, i, arg_0));
        Assertions.assertEquals((long)i.elem, (long)offsetCounter.value);
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        if (magic >= 2) {
            Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().size());
            Assertions.assertEquals((long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp);
        } else {
            Assertions.assertEquals((int)3, (int)CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().size());
            Assertions.assertEquals((long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp);
        }
        Assertions.assertFalse((boolean)validatingResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordValidationStats(validatingResults.recordValidationStats, 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        Assertions.assertEquals((int)(magic >= 2 ? 1 : 3), (int)CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().size());
        LogValidator.ValidationResult validatingResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)new GzipCompression.Builder().build(), false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatingResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().size());
        Assertions.assertEquals((long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp);
        Assertions.assertTrue((boolean)validatingResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordValidationStats(validatingResults.recordValidationStats, 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        GzipCompression compression = new GzipCompression.Builder().build();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)compression);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)compression, false, toMagic, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)validatedResults.maxTimestampMs, (long)-1L, (String)new StringBuilder(36).append("Max timestamp should be ").append(-1L).toString());
        Assertions.assertEquals((long)-1L, (long)validatedResults.shallowOffsetOfMaxTimestamp);
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)1, timestamp, (Compression)compression);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)compression, false, 2, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)timestamp, (long)validatedResults.maxTimestampMs);
        Assertions.assertEquals((long)2L, (long)validatedResults.shallowOffsetOfMaxTimestamp, (String)"Offset of max timestamp should be the last offset 2.");
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        .colon.colon recordList = new .colon.colon((Object)new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes()), (List)Nil$.MODULE$)));
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)new GzipCompression.Builder().build(), (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])((SimpleRecord[])recordList.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)new GzipCompression.Builder().build(), false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)2, (long)validatedResults.shallowOffsetOfMaxTimestamp, (String)"Shallow offset of max timestamp should be 2");
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, (Compression)Compression.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)Compression.NONE, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, (Compression)Compression.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)Compression.NONE, false, 2, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, (Compression)compression);
        Assertions.assertThrows(RecordValidationException.class, () -> LogValidatorTest.$anonfun$testInvalidCreateTimeCompressedV1$1(this, records, (Compression)compression));
    }

    @Test
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, (Compression)compression);
        Assertions.assertThrows(RecordValidationException.class, () -> LogValidatorTest.$anonfun$testInvalidCreateTimeCompressedV2$1(this, records, (Compression)compression));
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        NoCompression x$2 = Compression.NONE;
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        GzipCompression compression = new GzipCompression.Builder().build();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)compression);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, (Compression)Compression.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, (Compression)Compression.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)1, now, (Compression)compression);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, now, (Compression)compression);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        NoCompression x$2 = Compression.NONE;
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)Compression.NONE, false, 1, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        NoCompression x$2 = Compression.NONE;
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)Compression.NONE, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        GzipCompression compression = new GzipCompression.Builder().build();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)compression);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)compression, false, 1, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        GzipCompression compression = new GzipCompression.Builder().build();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, (Compression)compression);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)compression, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordValidationStats(validatedResults.recordValidationStats, 3, records, true);
    }

    @Test
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)Compression.NONE, false, 2, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        java.util.List batches = TestUtils.toList((Iterable)new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)new SnappyCompression.Builder().build(), (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.COORDINATOR, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords.batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, (Compression)Compression.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)1, now, (Compression)compression);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        NoCompression x$2 = Compression.NONE;
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)1, x$3, (Compression)x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)2, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        GzipCompression compression = new GzipCompression.Builder().build();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)1, x$3, (Compression)compression);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)2, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, (Compression)Compression.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, now, (Compression)compression);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        void withTransactionalRecords_records;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        NoCompression withTransactionalRecords_compression = Compression.NONE;
        Object var7_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)new GzipCompression.Builder().build(), false, 1, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        void withIdempotentRecords_records;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        NoCompression withIdempotentRecords_compression = Compression.NONE;
        Object var7_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withIdempotentRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)new GzipCompression.Builder().build(), false, 1, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, (Compression)Compression.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (Compression)Compression.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, now, (Compression)compression);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (Compression)compression, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, -1L, (Compression)Compression.NONE);
        ((MutableRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().head()).setLastOffset(2L);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, (Compression)new GzipCompression.Builder().build(), false, 0, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.GZIP, (Compression)new GzipCompression.Builder().build());
    }

    @Test
    public void testZStdCompressedWithUnavailableIBPVersion() {
        MemoryRecords records = this.createRecords((byte)2, 1234L, (Compression)Compression.NONE);
        Assertions.assertThrows(UnsupportedCompressionTypeException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, (Compression)new ZstdCompression.Builder().build(), false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.IBP_2_0_IV1).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.NONE, (Compression)Compression.NONE);
    }

    @Test
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.NONE, (Compression)new GzipCompression.Builder().build());
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, (Compression)compression);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> LogValidatorTest.$anonfun$testInvalidTimestampExceptionHasBatchIndex$1(this, records, (Compression)compression));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> {
            GzipCompression compression = new GzipCompression.Builder().build();
            this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, (Compression)compression), (byte)0, CompressionType.GZIP, (Compression)compression);
        });
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)20);
        CollectionConverters$.MODULE$.ListHasAsScala(e.recordErrors()).asScala().foreach((Function1 & Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        GzipCompression compression = new GzipCompression.Builder().build();
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id)));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        byte[] create_value = "timestamp".getBytes();
        Object var7_5 = null;
        builder.appendUncheckedWithOffset(Int$.MODULE$.int2long(offset.elem), LegacyRecord.create((byte)1, (long)1200L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME));
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$3(this, invalidOffsetTimestampRecords, (Compression)compression));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)6, (int)e.recordErrors().size());
    }

    @Test
    public void testRecordWithPastTimestampIsRejected() {
        long timestampBeforeMaxConfig = 86400000L;
        long timestampAfterMaxConfig = 3600000L;
        long fiveMinutesBeforeThreshold = System.currentTimeMillis() - timestampBeforeMaxConfig - 300000L;
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, fiveMinutesBeforeThreshold, (Compression)compression);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> LogValidatorTest.$anonfun$testRecordWithPastTimestampIsRejected$1(this, records, (Compression)compression, timestampBeforeMaxConfig, timestampAfterMaxConfig));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testRecordWithFutureTimestampIsRejected() {
        long timestampBeforeMaxConfig = 86400000L;
        long timestampAfterMaxConfig = 3600000L;
        long fiveMinutesAfterThreshold = System.currentTimeMillis() + timestampAfterMaxConfig + 300000L;
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords records = this.createRecords((byte)2, fiveMinutesAfterThreshold, (Compression)compression);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> LogValidatorTest.$anonfun$testRecordWithFutureTimestampIsRejected$1(this, records, (Compression)compression, timestampBeforeMaxConfig, timestampAfterMaxConfig));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testDifferentLevelDoesNotCauseRecompression() {
        .colon.colon records = new .colon.colon((Object)package$.MODULE$.List().fill(256, (Function0 & Serializable)() -> "some").mkString("").getBytes(), (List)new .colon.colon((Object)package$.MODULE$.List().fill(256, (Function0 & Serializable)() -> "data").mkString("").getBytes(), (List)Nil$.MODULE$));
        GzipCompression gzipMax = new GzipCompression.Builder().level(9).build();
        MemoryRecords recordsGzipMax = this.createRecords((List<byte[]>)records, (byte)2, -1L, (Compression)gzipMax);
        GzipCompression gzipMin = new GzipCompression.Builder().level(1).build();
        MemoryRecords recordsGzipMin = this.createRecords((List<byte[]>)records, (byte)2, -1L, (Compression)gzipMin);
        Assertions.assertNotEquals((Object)recordsGzipMax, (Object)recordsGzipMin);
        LogValidator.ValidationResult result = new LogValidator(recordsGzipMax, this.topicPartition(), this.time(), gzipMax.type(), (Compression)gzipMin, false, 2, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        Assertions.assertEquals((Object)recordsGzipMax, (Object)result.validatedRecords);
        Assertions.assertNotEquals((Object)recordsGzipMin, (Object)result.validatedRecords);
    }

    @Test
    public void testDifferentCodecCausesRecompression() {
        .colon.colon records = new .colon.colon((Object)package$.MODULE$.List().fill(256, (Function0 & Serializable)() -> "some").mkString("").getBytes(), (List)new .colon.colon((Object)package$.MODULE$.List().fill(256, (Function0 & Serializable)() -> "data").mkString("").getBytes(), (List)Nil$.MODULE$));
        GzipCompression gzipMax = new GzipCompression.Builder().level(9).build();
        MemoryRecords recordsGzipMax = this.createRecords((List<byte[]>)records, (byte)2, -1L, (Compression)gzipMax);
        Lz4Compression lz4Min = new Lz4Compression.Builder().level(1).build();
        MemoryRecords recordsLz4Min = this.createRecords((List<byte[]>)records, (byte)2, -1L, (Compression)lz4Min);
        LogValidator.ValidationResult result = new LogValidator(recordsGzipMax, this.topicPartition(), this.time(), gzipMax.type(), (Compression)lz4Min, false, 2, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        Assertions.assertEquals((Object)recordsLz4Min, (Object)result.validatedRecords);
    }

    /*
     * WARNING - void declaration
     */
    private void testBatchWithoutRecordsNotAllowed(CompressionType sourceCompression, Compression targetCompression) {
        void writeEmptyHeader_isControlRecord;
        void var4_8;
        void writeEmptyHeader_timestamp;
        void writeEmptyHeader_timestampType;
        void writeEmptyHeader_baseOffset;
        void writeEmptyHeader_lastOffset;
        int offset = 1234567;
        int n = 40;
        boolean bl = true;
        int n2 = 984;
        short s = (short)10;
        long producerId = 1324L;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long l2 = 5L;
        long l3 = 0L;
        byte writeEmptyHeader_magic = 2;
        int writeEmptyHeader_offsetDelta = (int)(writeEmptyHeader_lastOffset - writeEmptyHeader_baseOffset);
        DefaultRecordBatch.writeHeader((ByteBuffer)buffer, (long)writeEmptyHeader_baseOffset, (int)writeEmptyHeader_offsetDelta, (int)61, (byte)writeEmptyHeader_magic, (CompressionType)CompressionType.NONE, (TimestampType)writeEmptyHeader_timestampType, (long)-1L, (long)writeEmptyHeader_timestamp, (long)var4_8, (short)s, (int)n2, (boolean)bl, (boolean)writeEmptyHeader_isControlRecord, (boolean)false, (int)n, (int)0);
        timestampType = null;
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), sourceCompression, targetCompression, false, 2, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, Compression codec) {
        .colon.colon records = new .colon.colon((Object)"hello".getBytes(), (List)new .colon.colon((Object)"there".getBytes(), (List)new .colon.colon((Object)"beautiful".getBytes(), (List)Nil$.MODULE$)));
        return this.createRecords((List<byte[]>)records, magicValue, timestamp, codec);
    }

    private MemoryRecords createRecords(List<byte[]> records, byte magicValue, long timestamp, Compression codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> builder.appendWithOffset(Int$.MODULE$.int2long(offset), timestamp, null, (byte[])records.apply(offset)));
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, Compression codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private Compression createNonIncreasingOffsetRecords$default$3() {
        return Compression.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, Compression codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().nonEmpty(), (String)"Message set should not be empty");
        LongRef offset = LongRef.create((long)baseOffset);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().foreach((Function1 & Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, Compression compression, int numRecords) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)id -> LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id)));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, Compression codec) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)records.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assertions.assertEquals((long)expected, (long)defaultRecordBatch.baseTimestamp(), (String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assertions.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assertions.assertEquals((long)expectedLogAppendTime, (long)batch.maxTimestamp(), (String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordValidationStats(RecordValidationStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assertions.assertNotNull((Object)stats, (String)"Records processing info is null");
        Assertions.assertEquals((int)numConvertedRecords, (int)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assertions.assertTrue((stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString());
            Assertions.assertTrue((stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0, (String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString());
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assertions.assertTrue((tempBytes > (long)originalSize ? 1 : 0) != 0, (String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString());
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assertions.assertTrue((tempBytes > 0L ? 1 : 0) != 0, (String)"Temp bytes not updated");
            return;
        }
        Assertions.assertEquals((long)0L, (long)tempBytes);
    }

    public static final /* synthetic */ void $anonfun$testValidationOfBatchesWithNonSequentialInnerOffsets$1(LogValidatorTest $this, MemoryRecords invalidRecords$1, byte magicValue$1, Compression compression$1) {
        $this.validateMessages(invalidRecords$1, magicValue$1, CompressionType.GZIP, compression$1);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        GzipCompression compression = new GzipCompression.Builder().build();
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, (Compression)compression, numRecords);
        if (magicValue >= 2) {
            Assertions.assertThrows(InvalidRecordException.class, () -> LogValidatorTest.$anonfun$testValidationOfBatchesWithNonSequentialInnerOffsets$1(this, invalidRecords, magicValue, (Compression)compression));
            return;
        }
        LogValidator.ValidationResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, (Compression)compression);
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(result.validatedRecords.records()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset())));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$1, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$1, (int)batch.baseSequence());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assertions.assertEquals((int)partitionLeaderEpoch$1, (int)batch.partitionLeaderEpoch());
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$2, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$2, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$2, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$2, (int)batch.partitionLeaderEpoch());
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assertions.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assertions.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$3, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$3, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$3, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$3, (int)batch.partitionLeaderEpoch());
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testInvalidCreateTimeCompressedV1$1(LogValidatorTest $this, MemoryRecords records$3, Compression compression$3) {
        new LogValidator(records$3, $this.topicPartition(), $this.time(), CompressionType.GZIP, compression$3, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), $this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    public static final /* synthetic */ void $anonfun$testInvalidCreateTimeCompressedV2$1(LogValidatorTest $this, MemoryRecords records$4, Compression compression$4) {
        new LogValidator(records$4, $this.topicPartition(), $this.time(), CompressionType.GZIP, compression$4, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), $this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidTimestampExceptionHasBatchIndex$1(LogValidatorTest $this, MemoryRecords records$10, Compression compression$5) {
        new LogValidator(records$10, $this.topicPartition(), $this.time(), CompressionType.GZIP, compression$5, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), $this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError x$10) {
        Assertions.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        byte[] create_value = Integer.toString(id).getBytes();
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$4, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$4.elem += 30;
        builder$1.appendUncheckedWithOffset(Int$.MODULE$.int2long(offset$4.elem), record);
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$3(LogValidatorTest $this, MemoryRecords invalidOffsetTimestampRecords$1, Compression compression$6) {
        $this.validateMessages(invalidOffsetTimestampRecords$1, (byte)0, CompressionType.GZIP, compression$6);
    }

    public static final /* synthetic */ void $anonfun$testRecordWithPastTimestampIsRejected$1(LogValidatorTest $this, MemoryRecords records$11, Compression compression$7, long timestampBeforeMaxConfig$1, long timestampAfterMaxConfig$1) {
        new LogValidator(records$11, $this.topicPartition(), $this.time(), CompressionType.GZIP, compression$7, false, 2, TimestampType.CREATE_TIME, timestampBeforeMaxConfig$1, timestampAfterMaxConfig$1, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), $this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    public static final /* synthetic */ void $anonfun$testRecordWithFutureTimestampIsRejected$1(LogValidatorTest $this, MemoryRecords records$12, Compression compression$8, long timestampBeforeMaxConfig$2, long timestampAfterMaxConfig$2) {
        new LogValidator(records$12, $this.topicPartition(), $this.time(), CompressionType.GZIP, compression$8, false, 2, TimestampType.CREATE_TIME, timestampBeforeMaxConfig$2, timestampAfterMaxConfig$2, -1, AppendOrigin.CLIENT, MetadataVersion.latestTesting()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), $this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$6, Record entry) {
        Assertions.assertEquals((long)offset$6.elem, (long)entry.offset(), (String)"Unexpected offset in message set iterator");
        ++offset$6.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(Integer.toString(id).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        void create_value;
        void create_key;
        byte[] byArray = Integer.toString(id).getBytes();
        byte[] byArray2 = Integer.toString(id).getBytes();
        long create_timestamp = -1L;
        return LegacyRecord.create((byte)recordMagicValue$1, (long)create_timestamp, (byte[])create_key, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$4, IntRef offset$7, LegacyRecord record) {
        builder$4.appendUncheckedWithOffset(Int$.MODULE$.int2long(offset$7.elem), record);
        ++offset$7.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)expectedLogAppendTime$1, (long)record.timestamp(), (String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString());
    }

    public LogValidatorTest() {
        BrokerTopicMetrics newValidatorMetricsRecorder_allTopicsStats = new BrokerTopicStats(false).allTopicsStats();
        this.metricsRecorder = new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

