/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013\u0001\u0003\u0001\u0019!a\u0001\n\u0003\t\u0005\"C$\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011%A\u0005\u00011AA\u0002\u0013\u0005\u0011\nC\u0005U\u0001\u0001\u0007\t\u0019!C\u0001+\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006KA\u0013\u0005\u00061\u0002!\t!\u0017\u0005\u0006O\u0002!\t!\u0017\u0005\u0006Y\u0002!\t!\u0017\u0005\u0006c\u0002!\t!\u0017\u0005\u0006g\u0002!\t!\u0017\u0005\u0006k\u0002!\t!\u0017\u0005\u0006o\u0002!\t!\u0017\u0005\u0006s\u0002!\t!\u0017\u0005\u0006w\u0002!\t!\u0017\u0005\u0006{\u0002!\t!\u0017\u0005\u0006\u007f\u0002!\t!\u0017\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K2a!!\u0006\u0001\u0001\u0005]\u0001BCA\r+\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u0011\u0011E\u000b\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005URC!b\u0001\n\u0003\t9\u0004\u0003\u0006\u0002:U\u0011\t\u0011)A\u0005\u0003GAa\u0001N\u000b\u0005\u0002\u0005m\u0002\"CA\"+\u0001\u0007I\u0011AA#\u0011%\ti%\u0006a\u0001\n\u0003\ty\u0005\u0003\u0005\u0002TU\u0001\u000b\u0015BA$\u0011\u0019\t)&\u0006C\u00013\"9\u0011qK\u000b\u0005B\u0005e\u0003BBA.+\u0011\u0005\u0013\f\u0003\u0004\u0002^U!\t%W\u0004\n\u0003\u001f\u0003\u0011\u0011!E\u0001\u0003#3\u0011\"!\u0006\u0001\u0003\u0003E\t!a%\t\rQ\u001aC\u0011AAK\u0011%\t9jII\u0001\n\u0003\tI\nC\u0005\u00020\u000e\n\n\u0011\"\u0001\u0002\u001a\n!B)\u001a7bs\u0016$w\n]3sCRLwN\u001c+fgRT!!\u000b\u0016\u0002\rM,'O^3s\u0015\u0005Y\u0013!B6bM.\f7\u0001A\n\u0003\u00019\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001)\u0003%\u0001XO]4bi>\u0014\u00180F\u0001;!\r94(P\u0005\u0003y!\u0012\u0011\u0004R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8QkJ<\u0017\r^8ssB\u0011qGP\u0005\u0003\u007f!\u0012\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u001bA,(oZ1u_JLx\fJ3r)\t\u0011U\t\u0005\u00020\u0007&\u0011A\t\r\u0002\u0005+:LG\u000fC\u0004G\u0007\u0005\u0005\t\u0019\u0001\u001e\u0002\u0007a$\u0013'\u0001\u0006qkJ<\u0017\r^8ss\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002\u0015B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(Q\u0003\u0011)H/\u001b7\u000b\u0003E\u000bAA[1wC&\u00111\u000b\u0014\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0019R\r_3dkR|'oU3sm&\u001cWm\u0018\u0013fcR\u0011!I\u0016\u0005\b\r\u001a\t\t\u00111\u0001K\u0003A)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007%A\u0003tKR,\u0006\u000fF\u0001CQ\tA1\f\u0005\u0002]K6\tQL\u0003\u0002_?\u0006\u0019\u0011\r]5\u000b\u0005\u0001\f\u0017a\u00026va&$XM\u001d\u0006\u0003E\u000e\fQA[;oSRT\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014^\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0011\"\u001b\t\u00039*L!a[/\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgRdunY6J]R\u0013\u0018pQ8na2,G/Z#mg\u0016<\u0016\r^2iQ\tQa\u000e\u0005\u0002]_&\u0011\u0001/\u0018\u0002\u0005)\u0016\u001cH/A\ruKN$8+\u00194f)JL8i\\7qY\u0016$Xm\u0014:FYN,\u0007FA\u0006o\u0003]!Xm\u001d;SKF,Xm\u001d;TCRL7OZ1di&|g\u000e\u000b\u0002\r]\u0006\tB/Z:u%\u0016\fX/Z:u\u000bb\u0004\u0018N]=)\u00055q\u0017!\u0005;fgR$U\r\\1zK\u00124U\u000f^;sK\"\u0012aB\\\u0001\u0011i\u0016\u001cHOU3rk\u0016\u001cH\u000fU;sO\u0016D#a\u00048\u0002]MDw.\u001e7e\u0007\u0006t7-\u001a7G_J\\U-\u001f*fiV\u0014h.\u001b8h\u0007\u0006t7-\u001a7mK\u0012|\u0005/\u001a:bi&|gn\u001d\u0015\u0003!9\f\u0011h\u001d5pk2$'+\u001a;ve:t\u0015\u000e\\(qKJ\fG/[8og>s7)\u00198dK24uN]&fs^CWM\\&fs\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0003#9\f!\u0005^3tiR\u0013\u0018pQ8na2,G/Z,ji\"lU\u000f\u001c;ja2,G\u000b\u001b:fC\u0012\u001c\bF\u0001\no\u0003i1XM]5gs\u0012+G.Y=fI>\u0003XM]1uS>tGj\\2l)\u0015\u0011\u0015qAA0\u0011!\tIa\u0005CA\u0002\u0005-\u0011\u0001F7pG.$U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eE\u00030\u0003\u001b\t\t\"C\u0002\u0002\u0010A\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004\u0003')R\"\u0001\u0001\u0003)5{7m\u001b#fY\u0006LX\rZ(qKJ\fG/[8o'\t)R(A\u0004eK2\f\u00170T:\u0011\u0007=\ni\"C\u0002\u0002 A\u0012A\u0001T8oO\u00069An\\2l\u001fB$\b#B\u0018\u0002&\u0005%\u0012bAA\u0014a\t1q\n\u001d;j_:\u0004B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_a\u0015!\u00027pG.\u001c\u0018\u0002BA\u001a\u0003[\u0011QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017a\u0004:fgB|gn]3M_\u000e\\w\n\u001d;\u0016\u0005\u0005\r\u0012\u0001\u0005:fgB|gn]3M_\u000e\\w\n\u001d;!)!\t\t\"!\u0010\u0002@\u0005\u0005\u0003bBA\r5\u0001\u0007\u00111\u0004\u0005\n\u0003CQ\u0002\u0013!a\u0001\u0003GA\u0011\"!\u000e\u001b!\u0003\u0005\r!a\t\u0002\u0017\r|W\u000e\u001d7fi\u0006\u0014G.Z\u000b\u0003\u0003\u000f\u00022aLA%\u0013\r\tY\u0005\r\u0002\b\u0005>|G.Z1o\u0003=\u0019w.\u001c9mKR\f'\r\\3`I\u0015\fHc\u0001\"\u0002R!Aa\tHA\u0001\u0002\u0004\t9%\u0001\u0007d_6\u0004H.\u001a;bE2,\u0007%A\bbo\u0006LG/\u0012=qSJ\fG/[8o\u0003-!(/_\"p[BdW\r^3\u0015\u0005\u0005\u001d\u0013\u0001D8o\u000bb\u0004\u0018N]1uS>t\u0017AC8o\u0007>l\u0007\u000f\\3uK\"9\u0011\u0011M\nA\u0002\u0005\u001d\u0013aD7jg6\fGo\u00195fI2{7m[:\u0002%I,hn\u00148B]>$\b.\u001a:UQJ,\u0017\r\u001a\u000b\u0007\u0003O\n))a#1\t\u0005%\u00141\u000f\t\u0006\u0017\u0006-\u0014qN\u0005\u0004\u0003[b%A\u0002$viV\u0014X\r\u0005\u0003\u0002r\u0005MD\u0002\u0001\u0003\f\u0003k\"\u0012\u0011!A\u0001\u0006\u0003\t9HA\u0002`II\nB!!\u001f\u0002\u0000A\u0019q&a\u001f\n\u0007\u0005u\u0004GA\u0004O_RD\u0017N\\4\u0011\u0007=\n\t)C\u0002\u0002\u0004B\u00121!\u00118z\u0011!\t9\t\u0006CA\u0002\u0005%\u0015a\u00014v]B!q&!\u0004C\u0011\u001d\ti\t\u0006a\u0001\u0003\u000f\nab\u001d5pk2$7i\\7qY\u0016$X-\u0001\u000bN_\u000e\\G)\u001a7bs\u0016$w\n]3sCRLwN\u001c\t\u0004\u0003'\u00193CA\u0012/)\t\t\t*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u00037SC!a\t\u0002\u001e.\u0012\u0011q\u0014\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003%)hn\u00195fG.,GMC\u0002\u0002*B\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti+a)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<DelayedOperation> purgatory;
    private ExecutorService executorService;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<DelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<DelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<DelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", 0, 1000, true, true));
    }

    @AfterEach
    public void tearDown() {
        this.purgatory().shutdown();
        if (this.executorService() != null) {
            this.executorService().shutdown();
            return;
        }
    }

    @Test
    public void testLockInTryCompleteElseWatch() {
        DelayedOperation op = new DelayedOperation(null){

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assertions.assertTrue((boolean)((ReentrantLock)this.lock()).isHeldByCurrentThread());
                return false;
            }

            public boolean safeTryComplete() {
                Assertions.fail((String)"tryCompleteElseWatch should not use safeTryComplete");
                return super.safeTryComplete();
            }
        };
        this.purgatory().tryCompleteElseWatch(op, (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
    }

    @Test
    public void testSafeTryCompleteOrElse() {
        BooleanRef pass = BooleanRef.create((boolean)false);
        boolean op$1_shouldComplete = false;
        Assertions.assertFalse((boolean)new DelayedOperation(null, op$1_shouldComplete){
            private final boolean shouldComplete$1;

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assertions.assertTrue((boolean)((ReentrantLock)this.lock()).isHeldByCurrentThread());
                return this.shouldComplete$1;
            }
            {
                this.shouldComplete$1 = shouldComplete$1;
                super(100000L, (Option)None$.MODULE$);
            }
        }.safeTryCompleteOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            pass$1.elem = true;
        }));
        Assertions.assertTrue((boolean)pass.elem);
        boolean op$1_shouldComplete2 = true;
        Assertions.assertTrue((boolean)new /* invalid duplicate definition of identical inner class */.safeTryCompleteOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"this method should NOT be executed")));
    }

    @Test
    public void testRequestSatisfaction() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"With no waiting requests, nothing should be satisfied");
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})), (String)"r1 not satisfied and hence watched");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"Still nothing satisfied");
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})), (String)"r2 not satisfied and hence watched");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test2"), (String)"Still nothing satisfied");
        r1.completable_$eq(true);
        Assertions.assertEquals((int)1, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"r1 satisfied");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"Nothing satisfied");
        r2.completable_$eq(true);
        Assertions.assertEquals((int)1, (int)this.purgatory().checkAndComplete((Object)"test2"), (String)"r2 satisfied");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test2"), (String)"Nothing satisfied");
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})), (String)"r1 not satisfied and hence watched");
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})), (String)"r2 not satisfied and hence watched");
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assertions.assertTrue((boolean)r1.isCompleted(), (String)"r1 completed due to expiration");
        Assertions.assertFalse((boolean)r2.isCompleted(), (String)"r2 hasn't completed");
        Assertions.assertTrue((elapsed >= expiration ? 1 : 0) != 0, (String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expiration).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        try {
            AtomicInteger result = new AtomicInteger();
            Assertions.assertFalse((boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName), (String)"Unnecessary thread created");
            .colon.colon futures1 = new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)10)), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)11)), (List)Nil$.MODULE$));
            Assertions.assertTrue((boolean)purgatory.tryCompleteElseWatch(100000L, (Seq)futures1, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$5((List)futures1, result))).isCompleted(), (String)"r1 not completed");
            Assertions.assertEquals((int)21, (int)result.get());
            Assertions.assertFalse((boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName), (String)"Unnecessary thread created");
            result.set(-1);
            .colon.colon futures2 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
            DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures2, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$6((List)futures2, result)));
            Assertions.assertFalse((boolean)r2.isCompleted(), (String)"r2 should be incomplete");
            ((CompletableFuture)futures2.head()).complete(Predef$.MODULE$.int2Integer(20));
            Assertions.assertFalse((boolean)r2.isCompleted());
            Assertions.assertEquals((int)-1, (int)result.get());
            ((CompletableFuture)futures2.apply(1)).complete(Predef$.MODULE$.int2Integer(21));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!r2.isCompleted()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"r2 not completed");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!DelayedOperationTest.$anonfun$testDelayedFuture$9(result)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"callback not invoked");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName), (String)"Thread not created for executing delayed task");
            result.set(-1);
            .colon.colon futures3 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)31)), (List)Nil$.MODULE$));
            DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures3, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$11((List)futures3, result)));
            Assertions.assertFalse((boolean)r3.isCompleted(), (String)"r3 should be incomplete");
            Assertions.assertEquals((int)-1, (int)result.get());
            ((CompletableFuture)futures3.head()).complete(Predef$.MODULE$.int2Integer(30));
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!r3.isCompleted()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"r3 not completed");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            long l4 = 100L;
            long waitUntilTrue_waitTimeMs4 = 15000L;
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!DelayedOperationTest.$anonfun$testDelayedFuture$14(result)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                    Assertions.fail((String)"callback not invoked");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
            }
            result.set(-1);
            long start = Time.SYSTEM.hiResClockMs();
            long expirationMs = 2000L;
            .colon.colon futures4 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
            DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (Seq)futures4, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$16((List)futures4, result)));
            ((CompletableFuture)futures4.head()).complete(Predef$.MODULE$.int2Integer(40));
            long l5 = 100L;
            long waitUntilTrue_waitTimeMs5 = 15000L;
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!DelayedOperationTest.$anonfun$testDelayedFuture$17((List)futures4)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                    Assertions.fail((String)"r4 futures not expired");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)r4.isCompleted(), (String)"r4 not completed after timeout");
            long elapsed = Time.SYSTEM.hiResClockMs() - start;
            Assertions.assertTrue((elapsed >= expirationMs ? 1 : 0) != 0, (String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expirationMs).toString());
            Assertions.assertEquals((int)40, (Integer)((Integer)((CompletableFuture)futures4.head()).get()));
            Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> DelayedOperationTest.$anonfun$testDelayedFuture$19((List)futures4)).getCause().getClass());
            Assertions.assertEquals((int)40, (int)result.get());
        }
        finally {
            purgatory.shutdown();
        }
    }

    @Test
    public void testRequestPurge() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assertions.assertEquals((int)3, (int)this.purgatory().numDelayed(), (String)"Purgatory should have 3 total delayed operations");
        Assertions.assertEquals((int)6, (int)this.purgatory().watched(), (String)"Purgatory should have 6 watched elements");
        r2.completable_$eq(true);
        r2.tryComplete();
        Assertions.assertEquals((int)2, (int)this.purgatory().numDelayed(), (String)new StringBuilder(60).append("Purgatory should have 2 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assertions.assertEquals((int)1, (int)this.purgatory().numDelayed(), (String)new StringBuilder(60).append("Purgatory should have 1 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString());
        this.purgatory().checkAndComplete((Object)"test1");
        Assertions.assertEquals((int)4, (int)this.purgatory().watched(), (String)new StringBuilder(52).append("Purgatory should have 4 watched elements instead of ").append(this.purgatory().watched()).toString());
        this.purgatory().checkAndComplete((Object)"test2");
        Assertions.assertEquals((int)2, (int)this.purgatory().watched(), (String)new StringBuilder(52).append("Purgatory should have 2 watched elements instead of ").append(this.purgatory().watched()).toString());
        this.purgatory().checkAndComplete((Object)"test3");
        Assertions.assertEquals((int)1, (int)this.purgatory().watched(), (String)new StringBuilder(52).append("Purgatory should have 1 watched elements instead of ").append(this.purgatory().watched()).toString());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)new .colon.colon((Object)"key2", (List)Nil$.MODULE$));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assertions.assertEquals((int)2, (int)cancelledOperations.size());
        Assertions.assertEquals((int)1, (int)this.purgatory().numDelayed());
        Assertions.assertEquals((int)1, (int)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    @Test
    public void testTryCompleteWithMultipleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        IndexedSeq ops = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)index -> {
            public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
            extends MockDelayedOperation {
                private final String key;
                private final AtomicInteger completionAttemptsRemaining;
                private final Random random$1;
                private final int maxDelayMs$1;

                public String key() {
                    return this.key;
                }

                public AtomicInteger completionAttemptsRemaining() {
                    return this.completionAttemptsRemaining;
                }

                public boolean tryComplete() {
                    boolean shouldComplete = this.completable();
                    Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                    if (shouldComplete) {
                        return this.forceComplete();
                    }
                    return false;
                }

                public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, int completionAttempts$1, Random random$1, int maxDelayMs$1) {
                    this.random$1 = random$1;
                    this.maxDelayMs$1 = maxDelayMs$1;
                    if ($outer.MockDelayedOperation() == null) {
                        throw null;
                    }
                    if ($outer.MockDelayedOperation() == null) {
                        throw null;
                    }
                    super($outer, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
                    this.key = new StringBuilder(3).append("key").append(index).toString();
                    this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                }
            }
            return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1(this, completionAttempts, random, maxDelayMs, BoxesRunTime.unboxToInt((Object)index));
        });
        ((IterableOnceOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), completionAttempts).flatMap((Function1 & Serializable)x$7 -> DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2(this, ops, random, maxDelayMs, executor, BoxesRunTime.unboxToInt((Object)x$7)))).foreach((Function1 & Serializable)future -> future.get());
        ops.foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$5(op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        int createDelayedOperations$1_count = 2;
        ObjectRef ops = ObjectRef.create((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count).map((Function1 & Serializable)x$8 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$8))));
        this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)ops.elem, key);
        int createDelayedOperations$1_count2 = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count2).map((Function1 & Serializable)x$8 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$8)));
        Lock inLock_lock = ((DelayedOperation)((scala.collection.immutable.Seq)ops.elem).apply(1)).lock();
        inLock_lock.lock();
        try {
            this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)ops.elem, key);
        }
        finally {
            inLock_lock.unlock();
        }
        Object var6_7 = null;
        int createDelayedOperations$1_count3 = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count3).map((Function1 & Serializable)x$8 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$8)));
        boolean bl = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().lock();
        Future<?> runOnAnotherThread_future = this.executorService().submit(new Runnable(null, (Function0)runOnAnotherThread_fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future.isDone(), (String)"Should not have completed");
        }
        Object var8_11 = null;
        Object var10_12 = null;
        try {
            this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(1))), (List)Nil$.MODULE$), key);
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().unlock();
            Future<?> runOnAnotherThread_future2 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assertions.assertFalse((boolean)runOnAnotherThread_future2.isDone(), (String)"Should not have completed");
            }
            Object var11_15 = null;
            Object var13_16 = null;
            this.checkAndComplete$1((scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), key);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().unlock();
        Future<?> runOnAnotherThread_future3 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future3.isDone(), (String)"Should not have completed");
        }
        Object var14_18 = null;
        Object var16_19 = null;
        this.checkAndComplete$1((scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))), (List)Nil$.MODULE$), key);
        int createDelayedOperations$1_count4 = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count4).map((Function1 & Serializable)x$8 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$8)));
        ((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1 & Serializable)lock -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9(this, ops, mismatchedLocks, key, lock);
            return BoxedUnit.UNIT;
        });
        int createCompletableOperations$1_count = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createCompletableOperations$1_count).map((Function1 & Serializable)x$9 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation, BoxesRunTime.unboxToInt((Object)x$9)));
        ((scala.collection.immutable.Seq)ops.elem).foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
            return BoxedUnit.UNIT;
        });
    }

    private Future<?> runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        Future<?> future = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (shouldComplete) {
            future.get();
        } else {
            Assertions.assertFalse((boolean)future.isDone(), (String)"Should not have completed");
        }
        return future;
    }

    private final void MockDelayedOperation$lzycompute$1() {
        synchronized (this) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
            return;
        }
    }

    private static final DelayedOperation op$1(boolean shouldComplete) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$3 -> x$3.getName())).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains(new StringBuilder(16).append("DelayedExecutor-").append(purgatoryName$1).toString())));
    }

    public static final /* synthetic */ int $anonfun$testDelayedFuture$4(CompletableFuture x$6) {
        return (Integer)x$6.get();
    }

    private static final void updateResult$1(List futures, AtomicInteger result$1) {
        result$1.set(BoxesRunTime.unboxToInt((Object)futures.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isCompletedExceptionally())).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)DelayedOperationTest.$anonfun$testDelayedFuture$4(x$6))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$5(List futures1$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures1$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$6(List futures2$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures2$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$7(DelayedFuture r2$1) {
        return r2$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$8() {
        return "r2 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$9(AtomicInteger result$1) {
        return result$1.get() == 41;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$10() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$11(List futures3$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures3$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$12(DelayedFuture r3$1) {
        return r3$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$13() {
        return "r3 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$14(AtomicInteger result$1) {
        return result$1.get() == 61;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$15() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$16(List futures4$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures4$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$17(List futures4$1) {
        return ((CompletableFuture)futures4$1.apply(1)).isDone();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$18() {
        return "r4 futures not expired";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$19(List futures4$1) {
        ((CompletableFuture)futures4$1.apply(1)).get();
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, int index) {
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1($this, index, completionAttempts$1, random$1, maxDelayMs$1);
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)new .colon.colon((Object)op.key(), (List)Nil$.MODULE$));
        return op;
    }

    private final Future scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$2;

            public void run() {
                if (this.op$2.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$2.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$2.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$2 = op$2;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, int x$7) {
        return (IndexedSeq)ops$1.map((Function1 & Serializable)op -> {
            return $this.scheduleTryComplete$1((Kafka_server_DelayedOperationTest$TestDelayOperation$1)((Object)op), random$1.nextInt(maxDelayMs$1), executor$1);
        });
    }

    public static final /* synthetic */ void $anonfun$testTryCompleteWithMultipleThreads$5(TestDelayOperation.1 op) {
        Assertions.assertTrue((boolean)op.isCompleted(), (String)"Operation should have completed");
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$1, int x$8) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)new .colon.colon((Object)key$1, (List)Nil$.MODULE$));
        Assertions.assertFalse((boolean)op.isCompleted(), (String)"Not completable");
        return op;
    }

    private final scala.collection.immutable.Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$1) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)x$8 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$8)));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$9) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return op;
    }

    private static final scala.collection.immutable.Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)x$9 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation, BoxesRunTime.unboxToInt((Object)x$9)));
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assertions.assertTrue((boolean)op.isCompleted(), (String)"Should have completed");
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assertions.assertFalse((boolean)op.isCompleted(), (String)"Should not have completed");
    }

    private final void checkAndComplete$1(scala.collection.immutable.Seq completableOps, scala.collection.immutable.Seq expectedComplete, String key$1) {
        completableOps.foreach((Function1 & Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$1);
        Assertions.assertEquals((int)expectedComplete.size(), (int)completed);
        expectedComplete.foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        ((Set)completableOps.toSet().$minus$minus((IterableOnce)expectedComplete)).foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$6(DelayedOperationTest $this, ObjectRef ops$2, String key$1) {
        $this.checkAndComplete$1((scala.collection.immutable.Seq)ops$2.elem, (scala.collection.immutable.Seq)ops$2.elem, key$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$1, ReentrantLock lock) {
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        boolean bl = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> lock.lock();
        Future<?> runOnAnotherThread_future = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future.isDone(), (String)"Should not have completed");
        }
        Object var6_6 = null;
        Object var8_7 = null;
        try {
            try {
                $this.checkAndComplete$1((scala.collection.immutable.Seq)ops$2.elem, (scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(1))), (List)Nil$.MODULE$), key$1);
                Assertions.assertFalse((boolean)mismatchedLocks$1, (String)"Should have failed with mismatched locks");
            }
            catch (IllegalStateException illegalStateException) {
                Assertions.assertTrue((boolean)mismatchedLocks$1, (String)"Should not have failed with valid locks");
            }
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
            Future<?> runOnAnotherThread_future2 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assertions.assertFalse((boolean)runOnAnotherThread_future2.isDone(), (String)"Should not have completed");
            }
            Object var9_10 = null;
            Object var11_11 = null;
            $this.checkAndComplete$1((scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), key$1);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
        Future<?> runOnAnotherThread_future3 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future3.isDone(), (String)"Should not have completed");
        }
        Object var12_13 = null;
        Object var14_14 = null;
        $this.checkAndComplete$1((scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))), (List)Nil$.MODULE$), key$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$1, MockDelayedOperation op) {
        Assertions.assertTrue((boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)new .colon.colon((Object)key$1, (List)Nil$.MODULE$)), (String)"Should have completed");
        Assertions.assertTrue((boolean)op.isCompleted(), (String)"Should have completed");
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            if (this.completable()) {
                return this.forceComplete();
            }
            return false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1 & Serializable)lock -> {
                MockDelayedOperation.$anonfun$onComplete$1(lock);
                return BoxedUnit.UNIT;
            });
            synchronized (this) {
                this.notify();
                return;
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

