/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.log.LogManager;
import kafka.log.remote.RemoteLogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=a\u0001\u0002\u001b6\u0001iBQ!\u0011\u0001\u0005\u0002\tCQ!\u0012\u0001\u0005\u0002\u0019CQa\u0016\u0001\u0005\u0002\u0019CQ!\u0017\u0001\u0005\u0002\u0019CQa\u0017\u0001\u0005\u0002\u0019CQ!\u0018\u0001\u0005\u0002\u0019CQa\u0018\u0001\u0005\u0002\u0019CQ!\u0019\u0001\u0005\u0002\u0019CQa\u0019\u0001\u0005\u0002\u0019CQ!\u001a\u0001\u0005\u0002\u0019CQa\u001a\u0001\u0005\n!Dq!a\u0004\u0001\t\u0013\t\t\u0002\u0003\u0004\u0002<\u0001!\tA\u0012\u0005\u0007\u0003\u007f\u0001A\u0011\u0001$\t\r\u0005\r\u0003\u0001\"\u0001G\r\u0019\t9\u0005\u0001\u0001\u0002J!1\u0011\t\u0005C\u0001\u0003WB\u0011\"!\u001d\u0011\u0001\u0004%\t!a\u001d\t\u0013\u0005e\u0004\u00031A\u0005\u0002\u0005m\u0004\u0002CAA!\u0001\u0006K!!\u001e\t\u000f\u0005-\u0005\u0003\"\u0011\u0002\u000e\"9\u0011q\u0019\t\u0005B\u0005%\u0007bBAw!\u0011\u0005\u0013q\u001e\u0005\b\u00053\u0001B\u0011\tB\u000e\u0011\u001d\u0011y\u0004\u0005C!\u0005\u0003BaA!\u0014\u0011\t\u00032\u0005b\u0002B(!\u0011\u0005#\u0011\u000b\u0005\b\u0005S\u0002B\u0011\tB6\u0011\u001d\u0011\u0019\b\u0005C!\u0005kBqAa!\u0011\t\u0003\u0012)\t\u0003\u0004\u0003\u0014\u0002!\tA\u0012\u0005\b\u0005/\u0003A\u0011\u0002BM\u0011\u0019\u0011I\u000b\u0001C\u0001\r\"9!Q\u0016\u0001\u0005\n\t=\u0006B\u0002B[\u0001\u0011\u0005a\t\u0003\u0004\u0003:\u0002!\tA\u0012\u0005\u0007\u0005{\u0003A\u0011\u0001$\t\r\t\u0005\u0007\u0001\"\u0001G\u0011\u0019\u0011)\r\u0001C\u0001\r\"1!\u0011\u001a\u0001\u0005\u0002\u0019CaA!4\u0001\t\u00031\u0005B\u0002Bi\u0001\u0011\u0005a\t\u0003\u0004\u0003V\u0002!\tA\u0012\u0005\u0007\u00053\u0004A\u0011\u0001$\t\r\tu\u0007\u0001\"\u0001G\u0011\u0019\u0011\t\u000f\u0001C\u0001\r\"1!Q\u001d\u0001\u0005\u0002\u0019CaA!;\u0001\t\u00031\u0005B\u0002Bw\u0001\u0011\u0005a\t\u0003\u0004\u0003r\u0002!\tA\u0012\u0005\b\u0005k\u0004A\u0011\u0001B|\u0005]!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h)\u0016\u001cHO\u0003\u00027o\u000511/\u001a:wKJT\u0011\u0001O\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0003\"\u0001\u0012\u0001\u000e\u0003U\n\u0001\u0003^3ti\u000e{gNZ5h+B$\u0017\r^3\u0015\u0003\u001d\u0003\"\u0001\u0010%\n\u0005%k$\u0001B+oSRD#AA&\u0011\u00051+V\"A'\u000b\u00059{\u0015aA1qS*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00116+A\u0003kk:LGOC\u0001U\u0003\ry'oZ\u0005\u0003-6\u0013A\u0001V3ti\u00061C/Z:u\u000b:\f'\r\\3EK\u001a\fW\u000f\u001c;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0005\rY\u0015a\u0007;fgR,\u0006\u000fZ1uK\u0012Kh.Y7jGRC'/Z1e!>|G\u000e\u000b\u0002\u0005\u0017\u00061C/Z:u\u0007>tg-[4Va\u0012\fG/Z,ji\"\u001cv.\\3J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005\u0015Y\u0015a\r;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bNU3d_:4\u0017nZ;sC\ndWMV1mS\u0012\fG/[8o\r\u0006LG.\u001e:fQ\t11*\u0001\u000fuKN$(+Z2p]\u001aLw-\u001e:bE2,g+\u00197jI\u0006$\u0018n\u001c8)\u0005\u001dY\u0015a\u0005;fgR\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\bF\u0001\u0005L\u0003M!Xm\u001d;D_:tWm\u0019;j_:\fVo\u001c;bQ\tI1*A\fuKN$8i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uC\"\u0012!bS\u0001\u0013m\u0016\u0014\u0018NZ=D_:4\u0017nZ+qI\u0006$X\rF\u0004HSZ\f\t!a\u0003\t\u000b)\\\u0001\u0019A6\u0002\t9\fW.\u001a\t\u0003YNt!!\\9\u0011\u00059lT\"A8\u000b\u0005AL\u0014A\u0002\u001fs_>$h(\u0003\u0002s{\u00051\u0001K]3eK\u001aL!\u0001^;\u0003\rM#(/\u001b8h\u0015\t\u0011X\bC\u0003x\u0017\u0001\u0007\u00010A\u0003wC2,X\r\u0005\u0002z}6\t!P\u0003\u0002|y\u0006!A.\u00198h\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a >\u0003\r=\u0013'.Z2u\u0011\u001d\t\u0019a\u0003a\u0001\u0003\u000b\tq\u0002]3s\u0005J|7.\u001a:D_:4\u0017n\u001a\t\u0004y\u0005\u001d\u0011bAA\u0005{\t9!i\\8mK\u0006t\u0007bBA\u0007\u0017\u0001\u0007\u0011QA\u0001\u000eKb\u0004Xm\u0019;GC&dWO]3\u0002GY,'/\u001b4z\u0007>tg-[4Va\u0012\fG/Z,ji\"LeN^1mS\u0012\u001cuN\u001c4jORIq)a\u0005\u0002\u001e\u00055\u0012q\u0007\u0005\b\u0003+a\u0001\u0019AA\f\u0003\u0019\u0019wN\u001c4jOB\u0019A)!\u0007\n\u0007\u0005mQGA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBA\u0010\u0019\u0001\u0007\u0011\u0011E\u0001\n_JLw\r\u0015:paN\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003Oa\u0018\u0001B;uS2LA!a\u000b\u0002&\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005=B\u00021\u0001\u00022\u0005Qa/\u00197jIB\u0013x\u000e]:\u0011\u000b1\f\u0019d[6\n\u0007\u0005UROA\u0002NCBDq!!\u000f\r\u0001\u0004\t\t$\u0001\u0007j]Z\fG.\u001b3Qe>\u00048/\u0001\u000fuKN$\b+Y:to>\u0014HmQ8oM&<WI\\2ssB$\u0018n\u001c8)\u00055Y\u0015!\n;fgR\u0004\u0016m]:x_J$7i\u001c8gS\u001e,enY8eKJ\u001cVm\u0019:fi\u000eC\u0017M\\4fQ\tq1*A\ruKN$H)\u001f8b[&\u001cG*[:uK:,'oQ8oM&<\u0007FA\bL\u00059!Vm\u001d;BkRDwN]5{KJ\u001cb\u0001\u0005=\u0002L\u0005}\u0003\u0003BA'\u00037j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(b\u0001\u001c\u0002V)\u0019\u0001(a\u0016\u000b\u0007\u0005e3+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003;\nyE\u0001\u0006BkRDwN]5{KJ\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0005\u0003K\n)&\u0001\u0004d_6lwN\\\u0005\u0005\u0003S\n\u0019G\u0001\bSK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0005\u00055\u0004cAA8!5\t\u0001!\u0001\u0006tkB,'/V:feN,\"!!\u001e\u0011\u0007e\f9(\u0003\u0002uu\u0006q1/\u001e9feV\u001bXM]:`I\u0015\fHcA$\u0002~!I\u0011qP\n\u0002\u0002\u0003\u0007\u0011QO\u0001\u0004q\u0012\n\u0014aC:va\u0016\u0014Xk]3sg\u0002B3\u0001FAC!\ra\u0014qQ\u0005\u0004\u0003\u0013k$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000bM$\u0018M\u001d;\u0015\t\u0005=\u0015Q\u0018\u0019\u0005\u0003#\u000by\n\u0005\u0005\u0002$\u0005M\u0015QSAN\u0013\u0011\t)$!\n\u0011\t\u0005\u0005\u0014qS\u0005\u0005\u00033\u000b\u0019G\u0001\u0005F]\u0012\u0004x.\u001b8u!\u0011\ti*a(\r\u0001\u0011Y\u0011\u0011U\u000b\u0002\u0002\u0003\u0005)\u0011AAR\u0005\ryF\u0005O\t\u0005\u0003K\u000bY\u000bE\u0002=\u0003OK1!!+>\u0005\u001dqu\u000e\u001e5j]\u001e\u0004b!!,\u00024\u0006]VBAAX\u0015\u0011\t\t,!\n\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00026\u0006=&aD\"p[BdW\r^5p]N#\u0018mZ3\u0011\u0007e\fI,C\u0002\u0002<j\u0014AAV8jI\"9\u0011qX\u000bA\u0002\u0005\u0005\u0017AC:feZ,'/\u00138g_B!\u0011QJAb\u0013\u0011\t)-a\u0014\u0003)\u0005+H\u000f[8sSj,'oU3sm\u0016\u0014\u0018J\u001c4p\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0004\u0002L\u0006]\u0017\u0011\u001d\t\u0007\u0003G\ti-!5\n\t\u0005=\u0017Q\u0005\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002N\u0005M\u0017\u0002BAk\u0003\u001f\u00121#Q;uQ>\u0014\u0018N_1uS>t'+Z:vYRDq!!7\u0017\u0001\u0004\tY.\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\u00055\u0013Q\\\u0005\u0005\u0003?\fyE\u0001\u000eBkRDwN]5{C\ndWMU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002dZ\u0001\r!!:\u0002\u000f\u0005\u001cG/[8ogB1\u00111EAg\u0003O\u0004B!!\u0014\u0002j&!\u00111^A(\u0005\u0019\t5\r^5p]\u0006Q1M]3bi\u0016\f5\r\\:\u0015\r\u0005E(Q\u0001B\u0004a\u0011\t\u00190a>\u0011\r\u0005\r\u0012QZA{!\u0011\ti*a>\u0005\u0017\u0005ex#!A\u0001\u0002\u000b\u0005\u00111 \u0002\u0004?\u0012J\u0014\u0003BAS\u0003{\u0004b!!,\u00024\u0006}\b\u0003BA'\u0005\u0003IAAa\u0001\u0002P\ty\u0011i\u00197De\u0016\fG/\u001a*fgVdG\u000fC\u0004\u0002Z^\u0001\r!a7\t\u000f\t%q\u00031\u0001\u0003\f\u0005Y\u0011m\u00197CS:$\u0017N\\4t!\u0019\t\u0019#!4\u0003\u000eA!!q\u0002B\u000b\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\u0005\r\u0014aA1dY&!!q\u0003B\t\u0005)\t5\r\u001c\"j]\u0012LgnZ\u0001\u000bI\u0016dW\r^3BG2\u001cHC\u0002B\u000f\u0005c\u0011\u0019\u0004\r\u0003\u0003 \t\r\u0002CBA\u0012\u0003\u001b\u0014\t\u0003\u0005\u0003\u0002\u001e\n\rBa\u0003B\u00131\u0005\u0005\t\u0011!B\u0001\u0005O\u0011Aa\u0018\u00132aE!\u0011Q\u0015B\u0015!\u0019\ti+a-\u0003,A!\u0011Q\nB\u0017\u0013\u0011\u0011y#a\u0014\u0003\u001f\u0005\u001bG\u000eR3mKR,'+Z:vYRDq!!7\u0019\u0001\u0004\tY\u000eC\u0004\u00036a\u0001\rAa\u000e\u0002#\u0005\u001cGNQ5oI&twMR5mi\u0016\u00148\u000f\u0005\u0004\u0002$\u00055'\u0011\b\t\u0005\u0005\u001f\u0011Y$\u0003\u0003\u0003>\tE!\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0003\u0011\t7\r\\:\u0015\t\t\r#\u0011\n\t\u0006s\n\u0015#QB\u0005\u0004\u0005\u000fR(\u0001C%uKJ\f'\r\\3\t\u000f\t-\u0013\u00041\u0001\u0003:\u00051a-\u001b7uKJ\fQa\u00197pg\u0016\f\u0011bY8oM&<WO]3\u0015\u0007\u001d\u0013\u0019\u0006C\u0004\u0003Vm\u0001\rAa\u0016\u0002\u000f\r|gNZ5hgB\"!\u0011\fB/!\u001d\t\u0019#a%l\u00057\u0002B!!(\u0003^\u0011a!q\fB*\u0003\u0003\u0005\tQ!\u0001\u0003b\t!q\fJ\u00192#\u0011\t)Ka\u0019\u0011\u0007q\u0012)'C\u0002\u0003hu\u00121!\u00118z\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON$\"A!\u001c\u0011\u000b\u0005\r\"qN6\n\t\tE\u0014Q\u0005\u0002\u0004'\u0016$\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\r9%q\u000f\u0005\b\u0005+j\u0002\u0019\u0001B=a\u0011\u0011YHa \u0011\u000f\u0005\r\u00121S6\u0003~A!\u0011Q\u0014B@\t1\u0011\tIa\u001e\u0002\u0002\u0003\u0005)\u0011\u0001B1\u0005\u0011yF%\r\u001a\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0004\u000f\n\u001d\u0005b\u0002B+=\u0001\u0007!\u0011\u0012\u0019\u0005\u0005\u0017\u0013y\tE\u0004\u0002$\u0005M5N!$\u0011\t\u0005u%q\u0012\u0003\r\u0005#\u00139)!A\u0001\u0002\u000b\u0005!\u0011\r\u0002\u0005?\u0012\n4'\u0001\u000buKN$\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003?-\u000bad\u0019:fCR,7i\\7cS:,GmQ8oiJ|G\u000e\\3s\u0007>tg-[4\u0015\r\u0005\u0005\"1\u0014BS\u0011\u001d\u0011i\n\ta\u0001\u0005?\u000baA\\8eK&#\u0007c\u0001\u001f\u0003\"&\u0019!1U\u001f\u0003\u0007%sG\u000fC\u0004\u0003(\u0002\u0002\rAa(\u0002\tA|'\u000f^\u0001'i\u0016\u001cHoQ8nE&tW\rZ\"p]R\u0014x\u000e\u001c7fe\u0006+H\u000f[8sSj,'oQ8oM&<\u0007FA\u0011L\u0003y\u0019'/Z1uK&\u001bx\u000e\\1uK\u0012\u001cuN\u001c;s_2dWM]\"p]\u001aLw\r\u0006\u0004\u0002\"\tE&1\u0017\u0005\b\u0005;\u0013\u0003\u0019\u0001BP\u0011\u001d\u00119K\ta\u0001\u0005?\u000ba\u0005^3ti&\u001bx\u000e\\1uK\u0012\u001cuN\u001c;s_2dWM]!vi\"|'/\u001b>fe\u000e{gNZ5hQ\t\u00193*\u0001\u0007uKN$8+\u001f8p]fl7\u000f\u000b\u0002%\u0017\u0006\tD/Z:u\tft\u0017-\\5d\u0007>tg-[4J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8XSRDw.\u001e;D_:4\u0017nZ:J]j[\u0005FA\u0013L\u0003u!Xm\u001d;J[B\u0014x\u000e]3s\u0007>tg-[4t\u0003J,'+Z7pm\u0016$\u0007F\u0001\u0014L\u0003e!Xm\u001d;Va\u0012\fG/Z'fiJL7MU3q_J$XM]:)\u0005\u001dZ\u0015A\n;fgR,\u0006\u000fZ1uK6+GO]5d%\u0016\u0004xN\u001d;feNtuNS7y%\u0016\u0004xN\u001d;fe\"\u0012\u0001fS\u00012i\u0016\u001cHOT8o\u0013:$XM\u001d8bYZ\u000bG.^3t\t>,7OT8u\u000bb\u0004xn]3J]R,'O\\1m\u0007>tg-[4tQ\tI3*\u0001\u0013uKN$H)\u001f8b[&\u001cGj\\4M_\u000e\fGNU3uK:$\u0018n\u001c8Ng\u000e{gNZ5hQ\tQ3*\u0001\u0014uKN$H)\u001f8b[&\u001cGj\\4M_\u000e\fGNU3uK:$\u0018n\u001c8TSj,7i\u001c8gS\u001eD#aK&\u0002aQ,7\u000f\u001e#z]\u0006l\u0017n\u0019'pO2{7-\u00197SKR,g\u000e^5p]N[\u0017\u000e]:P]&sg/\u00197jI\u000e{gNZ5hQ\ta3*A\u001auKN$H)\u001f8b[&\u001cGj\\4M_\u000e\fGNU3uK:$\u0018n\u001c8UQJ|wo](o\u0013:\u001cwN\u001d:fGR\u001cuN\u001c4jO\"\u0012QfS\u0001&i\u0016\u001cH\u000fR=oC6L7MU3n_R,g)\u001a;dQ6\u000b\u0007pV1ji6\u001b8i\u001c8gS\u001eD#AL&\u0002OQ,7\u000f^+qI\u0006$X\rR=oC6L7MU3n_R,Gj\\4NC:\fw-\u001a:D_:4\u0017n\u001a\u0015\u0003_-\u000bA\u0005^3tiJ+Wn\u001c;f\u0019><W*\u00198bO\u0016\u00148i\u001c9z#V|G/Y+qI\u0006$Xm\u001d\u0015\u0003a-\u000bQ\u0005^3tiJ+Wn\u001c;f\u0019><W*\u00198bO\u0016\u0014h)\u001a;dQF+x\u000e^1Va\u0012\fG/Z:)\u0005EZ\u0015!\u000b;fgR\u0014V-\\8uK2{w-T1oC\u001e,'/T;mi&\u0004H.Z\"p]\u001aLw-\u00169eCR,7\u000f\u000b\u00023\u0017\u0006)c/\u001a:jMfLenY8se\u0016\u001cG\u000fT8h\u0019>\u001c\u0017\r\u001c*fi\u0016tG/[8o!J|\u0007o\u001d\u000b\n\u000f\ne81AB\u0004\u0007\u0017AqAa?4\u0001\u0004\u0011i0A\nm_\u001edunY1m%\u0016$XM\u001c;j_:l5\u000fE\u0002=\u0005\u007fL1a!\u0001>\u0005\u0011auN\\4\t\u000f\r\u00151\u00071\u0001\u0003~\u0006Y!/\u001a;f]RLwN\\'t\u0011\u001d\u0019Ia\ra\u0001\u0005{\fa\u0003\\8h\u0019>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u0005f$Xm\u001d\u0005\b\u0007\u001b\u0019\u0004\u0019\u0001B\u007f\u00039\u0011X\r^3oi&|gNQ=uKN\u0004")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put("listener.name.external.ssl.keystore.location", newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn(package$.MODULE$.Iterable().empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var32_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var33_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var34_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("num.io.threads", "4");
        origProps.put("num.network.threads", "2");
        origProps.put("num.replica.fetchers", "1");
        origProps.put("num.recovery.threads.per.data.dir", "1");
        origProps.put("background.threads", "3");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put("num.io.threads", "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put("num.network.threads", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey("num.network.threads"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get("num.network.threads"));
        props.put("num.replica.fetchers", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put("num.recovery.threads.per.data.dir", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put("background.threads", "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("ssl.keystore.type", "JKS");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        scala.collection.immutable.Map excludedTopicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ServerLogConfigs.LOG_MESSAGE_FORMAT_VERSION_CONFIG), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("log.cleaner.dedupe.buffer.size", "100000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "broker.id", "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "log.cleaner.dedupe.buffer.size", "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate("max.connections.per.ip", "100", true, false);
        this.verifyConfigUpdate("max.connections.per.ip", "100", false, false);
        this.verifyConfigUpdate("max.connections.per.ip", "0", false, true);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName#:100", true, true);
        this.verifyConfigUpdate("max.connections", "100", true, false);
        this.verifyConfigUpdate("max.connections", "100", false, false);
        String listenerMaxConnectionsProp = "listener.name.external.max.connections";
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate("max.connection.creation.rate", "110", true, false);
        this.verifyConfigUpdate("max.connection.creation.rate", "120", false, false);
        String listenerMaxConnectionsProp = "listener.name.external.max.connection.creation.rate";
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_19 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        configProps.put("password.encoder.secret", "broker.secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig configWithoutSecret = new KafkaConfig((java.util.Map)props, apply_doLog);
        props.put("password.encoder.secret", "config-encoder-secret");
        boolean apply_doLog2 = true;
        KafkaConfig configWithSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        Properties dynamicProps = new Properties();
        dynamicProps.put("sasl.jaas.config", "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty("sasl.jaas.config").contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty("sasl.jaas.config"));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var31_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var32_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var33_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("sasl.jaas.config", "staticLoginModule required;");
        props.put("password.encoder.secret", "config-encoder-secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put("sasl.jaas.config", "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty("sasl.jaas.config").contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get("sasl.jaas.config")).value());
        boolean apply_doLog2 = true;
        KafkaConfig newConfigWithSameSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get("sasl.jaas.config")).value());
        props.put("password.encoder.secret", "new-encoder-secret");
        props.put("password.encoder.old.secret", "config-encoder-secret");
        boolean apply_doLog3 = true;
        KafkaConfig newConfigWithNewAndOldSecret = new KafkaConfig((java.util.Map)props, apply_doLog3);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get("sasl.jaas.config")).value());
        props.put("password.encoder.secret", "another-new-encoder-secret");
        boolean apply_doLog4 = true;
        KafkaConfig newConfigWithNewSecret = new KafkaConfig((java.util.Map)props, apply_doLog4);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get("sasl.jaas.config")).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put("listeners", "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        boolean apply_doLog = true;
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean apply_doLog = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put("process.roles", "broker,controller");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", new StringBuilder(25).append(retval.get("listeners")).append(",CONTROLLER://localhost:0").toString());
        retval.put("controller.quorum.voters", new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put("process.roles", "controller");
        retval.remove("advertised.listeners");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", "CONTROLLER://localhost:0");
        retval.put("controller.quorum.voters", new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.hours", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties initialProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        initialProps.remove("background.threads");
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(initialProps);
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient), (Option)None$.MODULE$);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put("num.io.threads", "10");
        newprops.put("background.threads", "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put("max.connections", "9999");
        newProps.put("message.max.bytes", "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put("max.connections", "INVALID_INT");
        newProps.put("message.max.bytes", "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put("metric.reporters", MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("auto.include.jmx.reporter", "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put("metric.reporters", MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove("metric.reporters");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testNonInternalValuesDoesNotExposeInternalConfigs() {
        Properties props = new Properties();
        props.put("zookeeper.connect", "localhost:2181");
        props.put("metadata.log.segment.min.bytes", "1024");
        KafkaConfig config = new KafkaConfig((java.util.Map)props);
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey("metadata.log.segment.min.bytes"));
        config.updateCurrentConfig(new KafkaConfig((java.util.Map)props));
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey("metadata.log.segment.min.bytes"));
    }

    @Test
    public void testDynamicLogLocalRetentionMsConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2592000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", "2160000000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)2160000000L, (Long)config.logLocalRetentionMs());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.ms", "2150000000");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)2150000000L, (Long)config.logLocalRetentionMs());
    }

    @Test
    public void testDynamicLogLocalRetentionSizeConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "4294967296");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.bytes", "4294967295");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)0xFFFFFFFFL, (Long)config.logLocalRetentionBytes());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.bytes", "4294967294");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)0xFFFFFFFEL, (Long)config.logLocalRetentionBytes());
    }

    @Test
    public void testDynamicLogLocalRetentionSkipsOnInvalidConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var23_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var24_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var25_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("log.local.retention.ms", "1000");
        props.put("log.local.retention.bytes", "1024");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.ms"), (Object)"-3")}))));
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.bytes"), (Object)"-3")}))));
    }

    @Test
    public void testDynamicLogLocalRetentionThrowsOnIncorrectConfig() {
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, 2L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(500L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(-1L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, -1L, 100L);
    }

    @Test
    public void testDynamicRemoteFetchMaxWaitMsConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        KafkaBroker kafkaBroker = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaBroker.config()).thenReturn((Object)config);
        Assertions.assertEquals((int)500, (Integer)config.remoteFetchMaxWaitMs());
        DynamicRemoteLogConfig dynamicRemoteLogConfig = new DynamicRemoteLogConfig(kafkaBroker);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicRemoteLogConfig);
        Properties newProps = new Properties();
        newProps.put("remote.fetch.max.wait.ms", "30000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)30000, (Integer)config.remoteFetchMaxWaitMs());
        newProps.put("remote.fetch.max.wait.ms", "10000");
        config.dynamicConfig().validate(newProps, true);
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((int)10000, (Integer)config.remoteFetchMaxWaitMs());
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, 0})).foreach((Function1 & Serializable)maxWaitMs -> DynamicBrokerConfigTest.$anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(newProps, config, BoxesRunTime.unboxToInt((Object)maxWaitMs)));
    }

    @Test
    public void testUpdateDynamicRemoteLogManagerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("remote.log.index.file.cache.total.size.bytes", "2");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Option remoteLogManagerMockOpt = Option$.MODULE$.apply(Mockito.mock(RemoteLogManager.class));
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)remoteLogManagerMockOpt);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.index.file.cache.total.size.bytes", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (Long)config.getLong("remote.log.index.file.cache.total.size.bytes"));
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManagerMockOpt.get())).resizeCacheSize(4L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManagerMockOpt.get()});
    }

    @Test
    public void testRemoteLogManagerCopyQuotaUpdates() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig((KafkaBroker)serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerCopyMaxBytesPerSecond());
        props.put("remote.log.manager.copy.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        props.put("remote.log.manager.copy.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerFetchQuotaUpdates() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig((KafkaBroker)serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerFetchMaxBytesPerSecond());
        props.put("remote.log.manager.fetch.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(100L);
        props.put("remote.log.manager.fetch.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerMultipleConfigUpdates() {
        String indexFileCacheSizeProp = "remote.log.index.file.cache.total.size.bytes";
        String copyQuotaProp = "remote.log.manager.copy.max.bytes.per.second";
        String fetchQuotaProp = "remote.log.manager.fetch.max.bytes.per.second";
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_18 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig((KafkaBroker)serverMock));
        Assertions.assertEquals((long)0x40000000L, (long)config.remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerFetchMaxBytesPerSecond());
        props.put(indexFileCacheSizeProp, "4");
        props.put(copyQuotaProp, "100");
        props.put(fetchQuotaProp, "200");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        props.put(indexFileCacheSizeProp, "8");
        props.put(copyQuotaProp, "200");
        props.put(fetchQuotaProp, "400");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)8L, (long)config.remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)400L, (long)config.remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(8L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(400L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    public void verifyIncorrectLogLocalRetentionProps(long logLocalRetentionMs, long retentionMs, long logLocalRetentionBytes, long retentionBytes) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var33_13 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var34_16 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var35_19 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, Long.toString(retentionMs));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, Long.toString(retentionBytes));
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", Long.toString(logLocalRetentionMs));
        newProps.put("log.local.retention.bytes", Long.toString(logLocalRetentionBytes));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, false));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, true));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get("log.cleaner.threads").toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1), config$3.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1, config$3.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }

    public static final /* synthetic */ ConfigException $anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(Properties newProps$1, KafkaConfig config$5, int maxWaitMs) {
        newProps$1.put("remote.fetch.max.wait.ms", Integer.toString(maxWaitMs));
        Assertions.assertThrows(ConfigException.class, () -> config$5.dynamicConfig().validate(newProps$1, true));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> config$5.dynamicConfig().validate(newProps$1, false));
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

