/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005B]BqA\u0010\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004@\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0003a\u0005BB.\u0001A\u0003%Q\nC\u0004]\u0001\t\u0007I\u0011A!\t\ru\u0003\u0001\u0015!\u0003C\u0011\u001dq\u0006A1A\u0005\u00021Caa\u0018\u0001!\u0002\u0013i\u0005b\u00021\u0001\u0005\u0004%\t!\u0011\u0005\u0007C\u0002\u0001\u000b\u0011\u0002\"\t\u000f\t\u0004!\u0019!C\u0001\u0019\"11\r\u0001Q\u0001\n5Cq\u0001\u001a\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004f\u0001\u0001\u0006IA\u0011\u0005\bM\u0002\u0011\r\u0011\"\u0001M\u0011\u00199\u0007\u0001)A\u0005\u001b\"9\u0001\u000e\u0001b\u0001\n\u0003\t\u0005BB5\u0001A\u0003%!\tC\u0004k\u0001\t\u0007I\u0011\u0001'\t\r-\u0004\u0001\u0015!\u0003N\u0011%9\u0003\u00011AA\u0002\u0013\u0005A\u000eC\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0005\u000b\u0015B7\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003o\u0002A\u0011AA=\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u00111\u0017\u0001\u0005\u0002\u0005U&!E!eIB\u000b'\u000f^5uS>t7\u000fV3ti*\u0011q\u0005K\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002S\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001-!\ti\u0003'D\u0001/\u0015\ty\u0003&\u0001\u0004tKJ4XM]\u0005\u0003c9\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0002\"!\u000e\u0001\u000e\u0003\u0019\n1B\u0019:pW\u0016\u00148i\\;oiV\t\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0002J]R\f1\u0002]1si&$\u0018n\u001c8JI\u0006a\u0001/\u0019:uSRLwN\\%eA\u00051Ao\u001c9jGF*\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019\u0019FO]5oO\u00069Ao\u001c9jGF\u0002\u0013\u0001\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8u+\u0005i\u0005\u0003\u0002(TqUk\u0011a\u0014\u0006\u0003!F\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005IS\u0014AC2pY2,7\r^5p]&\u0011Ak\u0014\u0002\u0004\u001b\u0006\u0004\bC\u0001,Z\u001b\u00059&B\u0001-)\u0003)\u0019wN\u001c;s_2dWM]\u0005\u00035^\u0013\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5dc\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005\u0001Bo\u001c9jGJ\n5o]5h]6,g\u000e^\u0001\u0012i>\u0004\u0018n\u0019\u001aBgNLwM\\7f]R\u0004\u0013A\u0002;pa&\u001c7'A\u0004u_BL7m\r\u0011\u0002!Q|\u0007/[24\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001c7'Q:tS\u001etW.\u001a8uA\u00051Ao\u001c9jGR\nq\u0001^8qS\u000e$\u0004%\u0001\tu_BL7\rN!tg&<g.\\3oi\u0006\tBo\u001c9jGR\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[26\u0003\u001d!x\u000e]5dk\u0001\n\u0001\u0003^8qS\u000e,\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[26\u0003N\u001c\u0018n\u001a8nK:$\b%F\u0001n!\tqw/D\u0001p\u0015\t9\u0003O\u0003\u0002re\u000691\r\\5f]R\u001c(BA\u0015t\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\n\u0005a|'!B!e[&t\u0017!C1e[&tw\fJ3r)\tYh\u0010\u0005\u0002:y&\u0011QP\u000f\u0002\u0005+:LG\u000fC\u0004\u00005\u0005\u0005\t\u0019A7\u0002\u0007a$\u0013'\u0001\u0004bI6Lg\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004w\u0006\u001d\u0001bBA\u00059\u0001\u0007\u00111B\u0001\ti\u0016\u001cH/\u00138g_B!\u0011QBA\u000e\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011aA1qS*!\u0011QCA\f\u0003\u001dQW\u000f]5uKJT1!!\u0007v\u0003\u0015QWO\\5u\u0013\u0011\ti\"a\u0004\u0003\u0011Q+7\u000f^%oM>D3\u0001HA\u0011!\u0011\ti!a\t\n\t\u0005\u0015\u0012q\u0002\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0006;fgR<&o\u001c8h%\u0016\u0004H.[2b\u0007>,h\u000e\u001e\u000b\u0004w\u0006-\u0002bBA\u0017;\u0001\u0007\u0011qF\u0001\u0007cV|'/^7\u0011\t\u0005E\u0012q\b\b\u0005\u0003g\tY\u0004E\u0002\u00026ij!!a\u000e\u000b\u0007\u0005e\"&\u0001\u0004=e>|GOP\u0005\u0004\u0003{Q\u0014A\u0002)sK\u0012,g-C\u0002J\u0003\u0003R1!!\u0010;Q\ri\u0012Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)!\u00111JA\n\u0003\u0019\u0001\u0018M]1ng&!\u0011qJA%\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b;\u0005M\u0013qLA1!\u0011\t)&a\u0017\u000e\u0005\u0005]#\u0002BA-\u0003\u0013\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003;\n9FA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003G\n9'\t\u0002\u0002f\u0005\u0011!p[\u0011\u0003\u0003S\nQa\u001b:bMR\f1\u0005^3ti6K7o]5oOB\u000b'\u000f^5uS>t7/\u00138De\u0016\fG/\u001a+pa&\u001c7\u000fF\u0002|\u0003_Bq!!\f\u001f\u0001\u0004\ty\u0003K\u0002\u001f\u0003\u000bBsAHA*\u0003?\n)\b\f\u0003\u0002d\u0005\u001d\u0014a\n;fgRl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|gn]%o\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N$2a_A>\u0011\u001d\tic\ba\u0001\u0003_A3aHA#Q\u001dy\u00121KA0\u0003\u0003cC!a\u0019\u0002h\u00059B/Z:u\u0013:\u001c'/Z7f]R\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004w\u0006\u001d\u0005bBA\u0017A\u0001\u0007\u0011q\u0006\u0015\u0004A\u0005\u0015\u0003f\u0002\u0011\u0002T\u0005}\u0013Q\u0012\u0017\u0005\u0003G\n9'\u0001\u0010uKN$X*\u00198vC2\f5o]5h]6,g\u000e^(g%\u0016\u0004H.[2bgR\u001910a%\t\u000f\u00055\u0012\u00051\u0001\u00020!\u001a\u0011%!\u0012)\u000f\u0005\n\u0019&a\u0018\u0002\u001a2\"\u00111MA4\u0003y!Xm\u001d;SKBd\u0017nY1QY\u0006\u001cW-\\3oi\u0006cGnU3sm\u0016\u00148\u000fF\u0002|\u0003?Cq!!\f#\u0001\u0004\ty\u0003K\u0002#\u0003\u000bBsAIA*\u0003?\n)\u000b\f\u0002\u0002d\u0005\u0011C/Z:u%\u0016\u0004H.[2b!2\f7-Z7f]R\u0004\u0016M\u001d;jC2\u001cVM\u001d<feN$2a_AV\u0011\u001d\tic\ta\u0001\u0003_A3aIA#Q\u001d\u0019\u00131KA0\u0003cc#!a\u0019\u00023Y\fG.\u001b3bi\u0016dU-\u00193fe\u0006sGMU3qY&\u001c\u0017m\u001d\u000b\nw\u0006]\u0016Q]At\u0003WDq!!/%\u0001\u0004\tY,\u0001\u0005nKR\fG-\u0019;b!\u0011\ti,a8\u000f\t\u0005}\u0016\u0011\u001c\b\u0005\u0003\u0003\f\u0019N\u0004\u0003\u0002D\u0006=g\u0002BAc\u0003\u001btA!a2\u0002L:!\u0011QGAe\u0013\u00051\u0018B\u0001;v\u0013\tI3/C\u0002\u0002RJ\faaY8n[>t\u0017\u0002BAk\u0003/\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0004\u0003#\u0014\u0018\u0002BAn\u0003;\f\u0001#T3uC\u0012\fG/\u0019*fgB|gn]3\u000b\t\u0005U\u0017q[\u0005\u0005\u0003C\f\u0019OA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0006\u0005\u00037\fi\u000eC\u0003?I\u0001\u0007\u0001\b\u0003\u0004\u0002j\u0012\u0002\r\u0001O\u0001\u0011Kb\u0004Xm\u0019;fI2+\u0017\rZ3s\u0013\u0012Dq!!<%\u0001\u0004\ty/\u0001\tfqB,7\r^3e%\u0016\u0004H.[2bgB)\u0011\u0011GAyq%!\u00111_A!\u0005\r\u0019V\r\u001e")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment;
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment;
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment;
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment;
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.isKRaftTest()) {
            this.brokers().foreach((Function1 & Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        }
        this.createTopicWithAssignment(this.topic1(), (Map<Object, Seq<Object>>)((Map)this.topic1Assignment().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic2(), (Map<Object, Seq<Object>>)((Map)this.topic2Assignment().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic3(), (Map<Object, Seq<Object>>)((Map)this.topic3Assignment().map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int k = x0$3._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$3._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic4(), (Map<Object, Seq<Object>>)((Map)this.topic4Assignment().map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                int k = x0$4._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$4._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.admin_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongReplicaCount(String quorum) {
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)2, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause().getClass());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testMissingPartitionsInCreateTopics(String quorum) {
        HashMap<Integer, java.util.List<Integer>> topic6Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic6Placements.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic6Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        HashMap<Integer, java.util.List<Integer>> topic7Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic7Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic7Placements.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        java.util.Map futures = this.admin().createTopics(Arrays.asList(new NewTopic("new-topic6", topic6Placements), new NewTopic("new-topic7", topic7Placements))).values();
        Throwable topic6Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic6")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic6Cause.getClass());
        Assertions.assertTrue((boolean)topic6Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)new StringBuilder(26).append("Unexpected error message: ").append(topic6Cause.getMessage()).toString());
        Throwable topic7Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic7")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic7Cause.getClass());
        Assertions.assertTrue((boolean)topic7Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)new StringBuilder(26).append("Unexpected error message: ").append(topic7Cause.getMessage()).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testMissingPartitionsInCreatePartitions(String quorum) {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, cause.getClass());
        if (this.isKRaftTest()) {
            Assertions.assertTrue((boolean)cause.getMessage().contains("Attempted to add 2 additional partition(s), but only 1 assignment(s) were specified."), (String)new StringBuilder(26).append("Unexpected error message: ").append(cause.getMessage()).toString());
        } else {
            Assertions.assertTrue((boolean)cause.getMessage().contains("Increasing the number of partitions by 2 but 1 assignments provided."), (String)new StringBuilder(26).append("Unexpected error message: ").append(cause.getMessage()).toString());
        }
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> {
                AdminZkClient qual$1 = this.adminZkClient();
                String x$3 = this.topic5();
                scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic5Assignment();
                AdminZkClient qual$2 = this.adminZkClient();
                RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
                Option x$2 = qual$2.getBrokerMetadatas$default$2();
                Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
                Some x$7 = new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
                boolean x$8 = qual$1.addPartitions$default$6();
                qual$1.addPartitions(x$3, x$4, x$5, 2, (Option)x$7, x$8);
            })).getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementPartitions(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testManualAssignmentOfReplicas(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partition1Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        Assertions.assertEquals((int)leader1, (int)partition1Metadata.leader());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partition2Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        Assertions.assertEquals((int)leader2, (int)partition2Metadata.leader());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Buffer partitionMetadata = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        java.util.List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().toSet());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testReplicaPlacementAllServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic3(), NewPartitions.increaseTo((int)7))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 2, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 3, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 4, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 5, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 6, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic3(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testReplicaPlacementPartialServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = CollectionConverters$.MODULE$.ListHasAsScala(metadata.partitionMetadata()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$4)));
        Assertions.assertTrue((boolean)partitionOpt.isDefined(), (String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)expectedLeaderId)), (Object)partition.leaderId, (String)"Partition leader id should match");
        Assertions.assertEquals(expectedReplicas, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicaIds).asScala().toSet(), (String)"Replica set should match");
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$4) {
        return x$4.partition() == partitionId$1;
    }

    /*
     * WARNING - void declaration
     */
    public AddPartitionsTest() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        void apply_removingReplicas3;
        void apply_addingReplicas3;
        void apply_removingReplicas4;
        void apply_addingReplicas4;
        void apply_removingReplicas5;
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        Object[] objectArray = new Tuple2[1];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ apply_addingReplicas5 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Object var1_3 = null;
        Object var2_2 = null;
        nil$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas5, (Seq)apply_removingReplicas5));
        this.topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.topic2 = "new-topic2";
        Object[] objectArray2 = new Tuple2[1];
        Nil$ nil$2 = Nil$.MODULE$;
        Nil$ nil$3 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Object var4_6 = null;
        nil$3 = null;
        nil$2 = null;
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas4, (Seq)apply_removingReplicas4));
        this.topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        this.topic3 = "new-topic3";
        Object[] objectArray3 = new Tuple2[1];
        Nil$ nil$4 = Nil$.MODULE$;
        Nil$ nil$5 = Nil$.MODULE$;
        Seq apply_replicas3 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}));
        Object var7_9 = null;
        nil$5 = null;
        nil$4 = null;
        objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas3, (Seq)apply_addingReplicas3, (Seq)apply_removingReplicas3));
        this.topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        this.topic4 = "new-topic4";
        Object[] objectArray4 = new Tuple2[1];
        Nil$ nil$6 = Nil$.MODULE$;
        Nil$ nil$7 = Nil$.MODULE$;
        Seq apply_replicas4 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3}));
        Object var10_12 = null;
        nil$7 = null;
        nil$6 = null;
        objectArray4[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas4, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2));
        this.topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
        this.topic5 = "new-topic5";
        Object[] objectArray5 = new Tuple2[1];
        Nil$ nil$8 = Nil$.MODULE$;
        Nil$ nil$9 = Nil$.MODULE$;
        Seq apply_replicas5 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Object var13_15 = null;
        nil$9 = null;
        nil$8 = null;
        objectArray5[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReplicaAssignment(apply_replicas5, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        this.topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
    }
}

