/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.admin.ConfigCommand;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.util.StringUtils;
import scala.None$;
import scala.Option;

@ExtendWith(value={ClusterTestExtensions.class})
public class ConfigCommandIntegrationTest {
    private List<String> alterOpts;
    private final String defaultBrokerId = "0";
    private final ClusterInstance cluster;

    private static Runnable run(Stream<String> command) {
        return () -> {
            try {
                ConfigCommand.main((String[])((String[])command.toArray(String[]::new)));
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                Exit.resetExitProcedure();
            }
        };
    }

    public ConfigCommandIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT})
    public void testExitWithNonZeroStatusOnUpdatingUnallowedConfig() {
        this.assertNonZeroStatusExit(Stream.concat(this.quorumArgs(), Stream.of("--entity-name", this.cluster.isKRaftTest() ? "0" : "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT")), errOut -> Assertions.assertTrue((boolean)errOut.contains("Cannot update these configs dynamically: Set(security.inter.broker.protocol)"), (String)errOut));
    }

    @ClusterTest(types={Type.ZK})
    public void testExitWithNonZeroStatusOnZkCommandAlterUserQuota() {
        this.assertNonZeroStatusExit(Stream.concat(this.quorumArgs(), Stream.of("--entity-type", "users", "--entity-name", "admin", "--alter", "--add-config", "consumer_byte_rate=20000")), errOut -> Assertions.assertTrue((boolean)errOut.contains("User configuration updates using ZooKeeper are only supported for SCRAM credential updates."), (String)errOut));
    }

    @ClusterTest(types={Type.CO_KRAFT, Type.KRAFT})
    public void testNullStatusOnKraftCommandAlterUserQuota() {
        Stream<String> command = Stream.concat(this.quorumArgs(), Stream.of("--entity-type", "users", "--entity-name", "admin", "--alter", "--add-config", "consumer_byte_rate=20000"));
        String message = this.captureStandardMsg(ConfigCommandIntegrationTest.run(command));
        Assertions.assertTrue((boolean)StringUtils.isBlank((String)message), (String)message);
    }

    @ClusterTest(types={Type.ZK})
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() throws Exception {
        this.cluster.shutdownBroker(0);
        String zkConnect = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkClient();
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, None$.empty());
        this.alterOpts = Arrays.asList("--zookeeper", zkConnect, "--entity-type", "brokers", "--alter");
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of(brokerId), Collections.singletonMap("message.max.bytes", "110000"));
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.empty(), Collections.singletonMap("message.max.bytes", "120000"));
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of(brokerId), Collections.singletonMap("message.max.bytes", "130000"));
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.empty(), Collections.singletonMap("message.max.bytes", "140000"));
        this.deleteAndVerifyConfig(zkClient, adminZkClient, Optional.of(brokerId), Collections.singleton("message.max.bytes"));
        this.deleteAndVerifyConfig(zkClient, adminZkClient, Optional.empty(), Collections.singleton("message.max.bytes"));
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of(brokerId), Collections.singletonMap("listener.name.internal.ssl.keystore.location", "/tmp/test.jks"));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.of(brokerId), Collections.singletonMap("ssl.keystore.location", "/tmp/test.jks")));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.empty(), Collections.singletonMap("listener.name.internal.ssl.keystore.location", "/tmp/test.jks")));
        this.deleteAndVerifyConfig(zkClient, adminZkClient, Optional.of(brokerId), Collections.singleton("listener.name.internal.ssl.keystore.location"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.of(brokerId), Collections.singletonMap("listener.name.external.ssl.keystore.password", "secret")));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("listener.name.external.ssl.keystore.password", "secret");
        configs.put("log.cleaner.threads", "2");
        HashMap<String, String> encoderConfigs = new HashMap<String, String>(configs);
        encoderConfigs.put("password.encoder.secret", "encoder-secret");
        this.alterConfigWithZk(zkClient, adminZkClient, Optional.of(brokerId), encoderConfigs);
        Properties brokerConfigs = zkClient.getEntityConfigs("brokers", brokerId);
        Assertions.assertFalse((boolean)brokerConfigs.contains("password.encoder.secret"), (String)"Encoder secret stored in ZooKeeper");
        Assertions.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand.createPasswordEncoder(encoderConfigs);
        Assertions.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assertions.assertEquals((int)configs.size(), (int)brokerConfigs.size());
        Map<String, String> encoderConfigs2 = this.generateEncodeConfig();
        this.alterConfigWithZk(zkClient, adminZkClient, Optional.of(brokerId), encoderConfigs2);
        Properties brokerConfigs2 = zkClient.getEntityConfigs("brokers", brokerId);
        String encodedPassword2 = brokerConfigs2.getProperty("listener.name.external.ssl.keystore.password");
        Assertions.assertEquals((Object)"secret2", (Object)ConfigCommand.createPasswordEncoder(encoderConfigs).decode(encodedPassword2).value());
        Assertions.assertEquals((Object)"secret2", (Object)ConfigCommand.createPasswordEncoder(encoderConfigs2).decode(encodedPassword2).value());
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.empty(), encoderConfigs));
        this.registerBrokerInZk(zkClient, Integer.parseInt(brokerId));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.of(brokerId), Collections.singletonMap("message.max.bytes", "210000")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.empty(), Collections.singletonMap("message.max.bytes", "220000")));
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of("2"), Collections.singletonMap("message.max.bytes", "230000"));
    }

    @ClusterTest(types={Type.CO_KRAFT, Type.KRAFT})
    public void testDynamicBrokerConfigUpdateUsingKraft() throws Exception {
        this.alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.createAdminClient();){
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("message.max.bytes", "110000"));
            this.alterAndVerifyConfig(client, Optional.empty(), Collections.singletonMap("message.max.bytes", "120000"));
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("message.max.bytes", "130000"));
            this.alterAndVerifyConfig(client, Optional.empty(), Collections.singletonMap("message.max.bytes", "140000"));
            this.deleteAndVerifyConfigValue(client, "0", Collections.singleton("message.max.bytes"), true);
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("listener.name.internal.ssl.keystore.location", "/tmp/test.jks"));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.empty(), Collections.singletonMap("listener.name.internal.ssl.keystore.location", "/tmp/test.jks")));
            this.deleteAndVerifyConfigValue(client, "0", Collections.singleton("listener.name.internal.ssl.keystore.location"), false);
            this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("listener.name.external.ssl.keystore.password", "secret"));
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("listener.name.external.ssl.keystore.password", "secret");
            configs.put("log.cleaner.threads", "2");
            configs.put("password.encoder.secret", "encoder-secret");
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), configs));
        }
    }

    @ClusterTest(types={Type.ZK})
    public void testAlterReadOnlyConfigInZookeeperThenShouldFail() {
        this.cluster.shutdownBroker(0);
        String zkConnect = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkClient();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, None$.empty());
        this.alterOpts = this.generateDefaultAlterOpts(zkConnect);
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.of("0"), Collections.singletonMap("auto.create.topics.enable", "false")));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.of("0"), Collections.singletonMap("auto.leader.rebalance.enable", "false")));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, adminZkClient, Optional.of("0"), Collections.singletonMap("broker.id", "1")));
    }

    @ClusterTest(types={Type.CO_KRAFT, Type.KRAFT})
    public void testAlterReadOnlyConfigInKRaftThenShouldFail() {
        this.alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.createAdminClient();){
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("auto.create.topics.enable", "false")));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("auto.leader.rebalance.enable", "false")));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("broker.id", "1")));
        }
    }

    @ClusterTest(types={Type.ZK})
    public void testUpdateClusterWideConfigInZookeeperThenShouldSuccessful() {
        this.cluster.shutdownBroker(0);
        String zkConnect = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkClient();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, None$.empty());
        this.alterOpts = this.generateDefaultAlterOpts(zkConnect);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("log.flush.interval.messages", "100");
        configs.put("log.retention.bytes", "20");
        configs.put("log.retention.ms", "2");
        this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of("0"), configs);
    }

    @ClusterTest(types={Type.CO_KRAFT, Type.KRAFT})
    public void testUpdateClusterWideConfigInKRaftThenShouldSuccessful() throws Exception {
        this.alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.createAdminClient();){
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("log.flush.interval.messages", "100"));
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("log.retention.bytes", "20"));
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("log.retention.ms", "2"));
        }
    }

    @ClusterTest(types={Type.ZK})
    public void testUpdatePerBrokerConfigWithListenerNameInZookeeperThenShouldSuccessful() {
        this.cluster.shutdownBroker(0);
        String zkConnect = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkClient();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, None$.empty());
        this.alterOpts = this.generateDefaultAlterOpts(zkConnect);
        String listenerName = "listener.name.internal.";
        String sslTruststoreType = listenerName + "ssl.truststore.type";
        String sslTruststoreLocation = listenerName + "ssl.truststore.location";
        String sslTruststorePassword = listenerName + "ssl.truststore.password";
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(sslTruststoreType, "PKCS12");
        configs.put(sslTruststoreLocation, "/temp/test.jks");
        configs.put("password.encoder.secret", "encoder-secret");
        configs.put(sslTruststorePassword, "password");
        this.alterConfigWithZk(zkClient, adminZkClient, Optional.of("0"), configs);
        Properties properties = zkClient.getEntityConfigs("brokers", "0");
        Assertions.assertTrue((boolean)properties.containsKey(sslTruststorePassword));
        Assertions.assertEquals(configs.get(sslTruststoreType), (Object)properties.getProperty(sslTruststoreType));
        Assertions.assertEquals(configs.get(sslTruststoreLocation), (Object)properties.getProperty(sslTruststoreLocation));
    }

    @ClusterTest(types={Type.CO_KRAFT, Type.KRAFT})
    public void testUpdatePerBrokerConfigWithListenerNameInKRaftThenShouldSuccessful() throws Exception {
        this.alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        String listenerName = "listener.name.internal.";
        try (Admin client = this.cluster.createAdminClient();){
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap(listenerName + "ssl.truststore.type", "PKCS12"));
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap(listenerName + "ssl.truststore.location", "/temp/test.jks"));
            this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap(listenerName + "ssl.truststore.password", "password"));
            this.verifyConfigSecretValue(client, Optional.of("0"), Collections.singleton(listenerName + "ssl.truststore.password"));
        }
    }

    @ClusterTest(types={Type.ZK})
    public void testUpdatePerBrokerConfigInZookeeperThenShouldFail() {
        this.cluster.shutdownBroker(0);
        String zkConnect = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkClient();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, None$.empty());
        this.alterOpts = this.generateDefaultAlterOpts(zkConnect);
        Assertions.assertThrows(ConfigException.class, () -> this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of("0"), Collections.singletonMap("ssl.truststore.type", "PKCS12")));
        Assertions.assertThrows(ConfigException.class, () -> this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of("0"), Collections.singletonMap("ssl.truststore.location", "/temp/test.jks")));
        Assertions.assertThrows(ConfigException.class, () -> this.alterAndVerifyConfig(zkClient, adminZkClient, Optional.of("0"), Collections.singletonMap("ssl.truststore.password", "password")));
    }

    @ClusterTest(types={Type.CO_KRAFT, Type.KRAFT})
    public void testUpdatePerBrokerConfigInKRaftThenShouldFail() {
        this.alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.createAdminClient();){
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("ssl.truststore.type", "PKCS12")));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("ssl.truststore.location", "/temp/test.jks")));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithKraft(client, Optional.of("0"), Collections.singletonMap("ssl.truststore.password", "password")));
        }
    }

    private void assertNonZeroStatusExit(Stream<String> args, Consumer<String> checkErrOut) {
        AtomicReference exitStatus = new AtomicReference();
        Exit.setExitProcedure((status, __) -> {
            exitStatus.set(status);
            throw new RuntimeException();
        });
        String errOut = this.captureStandardMsg(ConfigCommandIntegrationTest.run(args));
        checkErrOut.accept(errOut);
        Assertions.assertNotNull(exitStatus.get());
        Assertions.assertEquals((int)1, (Integer)((Integer)exitStatus.get()));
    }

    private Stream<String> quorumArgs() {
        return this.cluster.isKRaftTest() ? Stream.of("--bootstrap-server", this.cluster.bootstrapServers()) : Stream.of("--zookeeper", ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect());
    }

    private void verifyConfig(KafkaZkClient zkClient, Optional<String> brokerId, Map<String, String> config) {
        Properties entityConfigs = zkClient.getEntityConfigs("brokers", brokerId.orElse("<default>"));
        Assertions.assertEquals(config, (Object)entityConfigs);
    }

    private void alterAndVerifyConfig(KafkaZkClient zkClient, AdminZkClient adminZkClient, Optional<String> brokerId, Map<String, String> configs) {
        this.alterConfigWithZk(zkClient, adminZkClient, brokerId, configs);
        this.verifyConfig(zkClient, brokerId, configs);
    }

    private void alterConfigWithZk(KafkaZkClient zkClient, AdminZkClient adminZkClient, Optional<String> brokerId, Map<String, String> config) {
        String configStr = this.transferConfigMapToString(config);
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(this.alterOpts, this.entityOp(brokerId), Arrays.asList("--add-config", configStr)));
        ConfigCommand.alterConfigWithZk((KafkaZkClient)zkClient, (ConfigCommand.ConfigCommandOptions)addOpts, (AdminZkClient)adminZkClient);
    }

    private List<String> entityOp(Optional<String> brokerId) {
        return brokerId.map(id -> Arrays.asList("--entity-name", id)).orElse(Collections.singletonList("--entity-default"));
    }

    private void deleteAndVerifyConfig(KafkaZkClient zkClient, AdminZkClient adminZkClient, Optional<String> brokerId, Set<String> configNames) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(this.alterOpts, this.entityOp(brokerId), Arrays.asList("--delete-config", String.join((CharSequence)",", configNames))));
        ConfigCommand.alterConfigWithZk((KafkaZkClient)zkClient, (ConfigCommand.ConfigCommandOptions)deleteOpts, (AdminZkClient)adminZkClient);
        this.verifyConfig(zkClient, brokerId, Collections.emptyMap());
    }

    private Map<String, String> generateEncodeConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("password.encoder.secret", "encoder-secret");
        map.put("password.encoder.cipher.algorithm", "DES/CBC/PKCS5Padding");
        map.put("password.encoder.iterations", "1024");
        map.put("password.encoder.keyfactory.algorithm", "PBKDF2WithHmacSHA1");
        map.put("password.encoder.key.length", "64");
        map.put("listener.name.external.ssl.keystore.password", "secret2");
        return map;
    }

    private void registerBrokerInZk(KafkaZkClient zkClient, int id) {
        zkClient.createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo.apply((Broker)Broker.apply((int)id, (EndPoint)endpoint, (Option)None$.empty()), (MetadataVersion)MetadataVersion.latestTesting(), (int)9192);
        zkClient.registerBroker(brokerInfo);
    }

    private List<String> generateDefaultAlterOpts(String bootstrapServers) {
        return Arrays.asList("--bootstrap-server", bootstrapServers, "--entity-type", "brokers", "--alter");
    }

    private void alterAndVerifyConfig(Admin client, Optional<String> brokerId, Map<String, String> config) throws Exception {
        this.alterConfigWithKraft(client, brokerId, config);
        this.verifyConfig(client, brokerId, config);
    }

    private void alterConfigWithKraft(Admin client, Optional<String> brokerId, Map<String, String> config) {
        String configStr = this.transferConfigMapToString(config);
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(this.alterOpts, this.entityOp(brokerId), Arrays.asList("--add-config", configStr)));
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)addOpts);
    }

    private void verifyConfig(Admin client, Optional<String> brokerId, Map<String, String> config) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId.orElse(""));
        TestUtils.waitForCondition(() -> {
            Map<String, String> current = this.getConfigEntryStream(client, configResource).filter(configEntry -> Objects.nonNull(configEntry.value())).collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
            return config.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(current.get(e.getKey())));
        }, (long)10000L, (String)(config + " are not updated"));
    }

    private Stream<ConfigEntry> getConfigEntryStream(Admin client, ConfigResource configResource) throws InterruptedException, ExecutionException {
        return ((Map)client.describeConfigs(Collections.singletonList(configResource)).all().get()).values().stream().flatMap(e -> e.entries().stream());
    }

    private void deleteAndVerifyConfigValue(Admin client, String brokerId, Set<String> config, boolean hasDefaultValue) throws Exception {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(this.alterOpts, Arrays.asList("--entity-name", brokerId), Arrays.asList("--delete-config", String.join((CharSequence)",", config))));
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)deleteOpts);
        this.verifyPerBrokerConfigValue(client, brokerId, config, hasDefaultValue);
    }

    private void verifyPerBrokerConfigValue(Admin client, String brokerId, Set<String> config, boolean hasDefaultValue) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId);
        TestUtils.waitForCondition(() -> {
            if (hasDefaultValue) {
                Map<String, String> current = this.getConfigEntryStream(client, configResource).filter(configEntry -> Objects.nonNull(configEntry.value())).collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
                return config.stream().allMatch(current::containsKey);
            }
            return this.getConfigEntryStream(client, configResource).noneMatch(configEntry -> config.contains(configEntry.name()));
        }, (long)5000L, (String)(config + " are not updated"));
    }

    private void verifyConfigSecretValue(Admin client, Optional<String> brokerId, Set<String> config) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId.orElse(""));
        TestUtils.waitForCondition(() -> {
            Map current = this.getConfigEntryStream(client, configResource).filter(ConfigEntry::isSensitive).collect(HashMap::new, (map, entry) -> map.put(entry.name(), entry.value()), HashMap::putAll);
            return config.stream().allMatch(current::containsKey);
        }, (long)5000L, (String)(config + " are not updated"));
    }

    @SafeVarargs
    private static String[] toArray(List<String> ... lists) {
        return (String[])Stream.of(lists).flatMap(Collection::stream).toArray(String[]::new);
    }

    private String captureStandardMsg(Runnable runnable) {
        return this.captureStandardStream(runnable);
    }

    private String transferConfigMapToString(Map<String, String> configs) {
        return configs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String captureStandardStream(Runnable runnable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream currentStream = System.err;
        Throwable throwable = null;
        try (PrintStream tempStream = new PrintStream(outputStream);){
            String string;
            System.setErr(tempStream);
            try {
                runnable.run();
                string = outputStream.toString().trim();
            }
            catch (Throwable throwable2) {
                try {
                    System.setErr(currentStream);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            System.setErr(currentStream);
            return string;
        }
    }
}

