/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.MyRemoteLogMetadataManager;
import kafka.admin.MyRemoteLogMetadataManager$;
import kafka.admin.MyRemoteStorageManager;
import kafka.admin.MyRemoteStorageManager$;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Random$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tEh\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"I1\n\u0001a\u0001\u0002\u0004%\t\u0001\u0014\u0005\n1\u0002\u0001\r\u00111A\u0005\u0002eC\u0011b\u0018\u0001A\u0002\u0003\u0005\u000b\u0015B'\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\"9Q\r\u0001a\u0001\n\u00031\u0007B\u00025\u0001A\u0003&!\rC\u0004j\u0001\u0001\u0007I\u0011\u0001'\t\u000f)\u0004\u0001\u0019!C\u0001W\"1Q\u000e\u0001Q!\n5CqA\u001c\u0001A\u0002\u0013\u0005A\nC\u0004p\u0001\u0001\u0007I\u0011\u00019\t\rI\u0004\u0001\u0015)\u0003N\u0011\u0015\u0019\b\u0001\"\u0015B\u0011\u0015!\b\u0001\"\u0015v\u0011\u001d\ti\u0001\u0001C)\u0003\u001fAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a*\u0001\t\u0003\tI\u000bC\u0004\u00024\u0002!\t!!.\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u00111\u001e\u0001\u0005\u0002\u00055\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqAa\u0007\u0001\t\u0003\u0011i\u0002C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005/\u0002A\u0011\u0001B-\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003|\u0001!IA! \t\u0013\t\u0005\u0007!%A\u0005\n\t\r\u0007b\u0002Bm\u0001\u0011%!1\u001c\u0005\b\u0005C\u0004A\u0011\u0002Br\u0005M\u0011V-\\8uKR{\u0007/[2DeV$G+Z:u\u0015\t\t$'A\u0003bI6LgNC\u00014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u0012\u0014aA1qS&\u00111\b\u000f\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u0010\t\u0003\u007f\u0001i\u0011\u0001M\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u00131!\u00138u\u00039qW/\u001c)beRLG/[8og\u0002\nAC\\;n%\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018!\u00068v[J+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\u000ei\u0016\u001cH\u000fV8qS\u000et\u0015-\\3\u0016\u00035\u0003\"AT+\u000f\u0005=\u001b\u0006C\u0001)E\u001b\u0005\t&B\u0001*5\u0003\u0019a$o\\8u}%\u0011A\u000bR\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U\t\u0006\tB/Z:u)>\u0004\u0018n\u0019(b[\u0016|F%Z9\u0015\u0005ik\u0006CA\"\\\u0013\taFI\u0001\u0003V]&$\bb\u00020\b\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014A\u0004;fgR$v\u000e]5d\u001d\u0006lW\rI\u0001\u0018gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012,\u0012A\u0019\t\u0003\u0007\u000eL!\u0001\u001a#\u0003\u000f\t{w\u000e\\3b]\u0006Y2/_:SK6|G/Z*u_J\fw-Z#oC\ndW\rZ0%KF$\"AW4\t\u000fyS\u0011\u0011!a\u0001E\u0006A2/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u0011\u0002/M$xN]1hK6\u000bg.Y4fe\u000ec\u0017m]:OC6,\u0017aG:u_J\fw-Z'b]\u0006<WM]\"mCN\u001ch*Y7f?\u0012*\u0017\u000f\u0006\u0002[Y\"9a,DA\u0001\u0002\u0004i\u0015\u0001G:u_J\fw-Z'b]\u0006<WM]\"mCN\u001ch*Y7fA\u0005AR.\u001a;bI\u0006$\u0018-T1oC\u001e,'o\u00117bgNt\u0015-\\3\u000295,G/\u00193bi\u0006l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lWm\u0018\u0013fcR\u0011!,\u001d\u0005\b=B\t\t\u00111\u0001N\u0003eiW\r^1eCR\fW*\u00198bO\u0016\u00148\t\\1tg:\u000bW.\u001a\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0005i3\b\"B<\u0014\u0001\u0004A\u0018!\u00029s_B\u001c\bcA=}}6\t!P\u0003\u0002|\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uT(aA*fcB\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!A\u0003)s_B,'\u000f^5fg\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000fF\u0002y\u0003#Aq!a\u0005\u0015\u0001\u0004\t)\"\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t9\"a\n\u000e\u0005\u0005e!bA\u001d\u0002\u001c)!\u0011QDA\u0010\u0003\u001dQW\u000f]5uKJTA!!\t\u0002$\u0005)!.\u001e8ji*\u0011\u0011QE\u0001\u0004_J<\u0017\u0002BA\u0015\u00033\u0011\u0001\u0002V3ti&sgm\\\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00045\u0006=\u0002bBA\u0019+\u0001\u0007\u0011QC\u0001\u0005S:4w\u000eK\u0002\u0016\u0003k\u0001B!a\u0006\u00028%!\u0011\u0011HA\r\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001,i\u0016\u001cHo\u0011:fCR,'+Z7pi\u0016$v\u000e]5d/&$\bNV1mS\u0012\u0014V\r^3oi&|g\u000eV5nKR\u0019!,a\u0010\t\r\u0005\u0005c\u00031\u0001N\u0003\u0019\tXo\u001c:v[\"\u001aa#!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013RA!a\u0013\u0002\u001c\u00051\u0001/\u0019:b[NLA!a\u0014\u0002J\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000fY\t\u0019&a\u0018\u0002bA!\u0011QKA.\u001b\t\t9F\u0003\u0003\u0002Z\u0005%\u0013\u0001\u00039s_ZLG-\u001a:\n\t\u0005u\u0013q\u000b\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005\r\u0014qM\u0011\u0003\u0003K\n!A_6\"\u0005\u0005%\u0014!B6sC\u001a$\u0018a\u000b;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:\u001c\u0016N_3\u0015\u0007i\u000by\u0007\u0003\u0004\u0002B]\u0001\r!\u0014\u0015\u0004/\u0005\u0015\u0003fB\f\u0002T\u0005}\u0013Q\u000f\u0017\u0005\u0003G\n9'\u0001\u001buKN$8I]3bi\u0016\u0014V-\\8uKR{\u0007/[2XSRD\u0017J\u001c5fe&$X\r\u001a'pG\u0006d'+\u001a;f]RLwN\u001c+j[\u0016$2AWA>\u0011\u0019\t\t\u0005\u0007a\u0001\u001b\"\u001a\u0001$!\u0012)\u000fa\t\u0019&a\u0018\u0002\u00022\"\u00111MA4\u0003Q\"Xm\u001d;De\u0016\fG/\u001a*f[>$X\rV8qS\u000e<\u0016\u000e\u001e5J]\",'/\u001b;fI2{7-\u00197SKR,g\u000e^5p]NK'0\u001a\u000b\u00045\u0006\u001d\u0005BBA!3\u0001\u0007Q\nK\u0002\u001a\u0003\u000bBs!GA*\u0003?\ni\t\f\u0003\u0002d\u0005\u001d\u0014!\f;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"LeN^1mS\u0012\u0014V\r^3oi&|g\u000eV5nKR\u0019!,a%\t\r\u0005\u0005#\u00041\u0001NQ\rQ\u0012Q\t\u0015\b5\u0005M\u0013qLAMY\u0011\t\u0019'a\u001a\u0002[Q,7\u000f^\"sK\u0006$XMU3n_R,Gk\u001c9jG^KG\u000f[%om\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o'&TX\rF\u0002[\u0003?Ca!!\u0011\u001c\u0001\u0004i\u0005fA\u000e\u0002F!:1$a\u0015\u0002`\u0005\u0015F\u0006BA2\u0003O\n\u0001\u0005^3ti\u000e\u0013X-\u0019;f\u0007>l\u0007/Y2uK\u0012\u0014V-\\8uKN#xN]1hKR\u0019!,a+\t\r\u0005\u0005C\u00041\u0001NQ\ra\u0012Q\t\u0015\b9\u0005M\u0013qLAYY\u0011\t\u0019'a\u001a\u0002oQ,7\u000f^\"sK\u0006$XMU3n_R,Gk\u001c9jG^KG\u000f[\"paf$\u0015n]1cY\u0016$\u0017I\u001c3EK2,G/Z(o\t&\u001c\u0018M\u00197f)\u001dQ\u0016qWA]\u0003{Ca!!\u0011\u001e\u0001\u0004i\u0005BBA^;\u0001\u0007!-\u0001\u0007d_BLH)[:bE2,G\r\u0003\u0004\u0002@v\u0001\rAY\u0001\u0010I\u0016dW\r^3P]\u0012K7/\u00192mK\"\u001aQ$!\u0012)\u000fu\t)-a3\u0002NB!\u0011QKAd\u0013\u0011\tI-a\u0016\u0003\u0013\r\u001bhoU8ve\u000e,\u0017!\u0002<bYV,G\u0006CAh\u0003'\f9.a7\"\u0005\u0005E\u0017aD6sC\u001a$H\u0006\u001e:vK2\"(/^3\"\u0005\u0005U\u0017\u0001E6sC\u001a$H\u0006\u001e:vK22\u0017\r\\:fC\t\tI.\u0001\tle\u00064G\u000f\f4bYN,G\u0006\u001e:vK\u0006\u0012\u0011Q\\\u0001\u0012WJ\fg\r\u001e\u0017gC2\u001cX\r\f4bYN,\u0017A\u000f;fgR\u001c%/Z1uKR{\u0007/[2SKR,g\u000e^5p]6\u001bh+\u00197jI\u0006$\u0018n\u001c8XSRD'+Z7pi\u0016\u001cu\u000e]=ESN\f'\r\\3e)\rQ\u00161\u001d\u0005\u0007\u0003\u0003r\u0002\u0019A')\u0007y\t)\u0005K\u0004\u001f\u0003'\ny&!;-\u0005\u0005\u001d\u0014!\u0010;fgR\u001c%/Z1uKR{\u0007/[2SKR,g\u000e^5p]\nKH/Z:WC2LG-\u0019;j_:<\u0016\u000e\u001e5SK6|G/Z\"paf$\u0015n]1cY\u0016$Gc\u0001.\u0002p\"1\u0011\u0011I\u0010A\u00025C3aHA#Q\u001dy\u00121KA0\u0003kd#!a\u001a\u0002MQ,7\u000f^#oC\ndWMU3n_R,Gj\\4P]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5d)\u0016\u001cH\u000fF\u0002[\u0003wDa!!\u0011!\u0001\u0004i\u0005f\u0001\u0011\u0002F!:\u0001%a\u0015\u0002`\t\u0005A\u0006BA2\u0003O\nA\u0007^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e<\u0006.\u001a8TsN$X-\u001c*f[>$Xm\u0015;pe\u0006<W-S:ESN\f'\r\\3e)\rQ&q\u0001\u0005\u0007\u0003\u0003\n\u0003\u0019A')\u0007\u0005\n)\u0005K\u0004\"\u0003'\nyF!\u0004-\t\u0005\r\u0014qM\u00010i\u0016\u001cH/\u00169eCR,Gk\u001c9jG\u000e{gNZ5h/&$\bNV1mS\u0012\u0014V\r^3oi&|g\u000eV5nKR+7\u000f\u001e\u000b\u00045\nM\u0001BBA!E\u0001\u0007Q\nK\u0002#\u0003\u000bBsAIA*\u0003?\u0012I\u0002\f\u0003\u0002d\u0005\u001d\u0014a\f;fgR,\u0006\u000fZ1uKR{\u0007/[2D_:4\u0017nZ,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:\u001c\u0016N_3UKN$Hc\u0001.\u0003 !1\u0011\u0011I\u0012A\u00025C3aIA#Q\u001d\u0019\u00131KA0\u0005KaC!a\u0019\u0002h\u0005!D/Z:u+B$\u0017\r^3U_BL7mQ8oM&<w+\u001b;i\u0013:DWM]5uK\u0012dunY1m%\u0016$XM\u001c;j_:$\u0016.\\3\u0015\u0007i\u0013Y\u0003\u0003\u0004\u0002B\u0011\u0002\r!\u0014\u0015\u0004I\u0005\u0015\u0003f\u0002\u0013\u0002T\u0005}#\u0011\u0007\u0017\u0005\u0003G\n9'\u0001\u001buKN$X\u000b\u001d3bi\u0016$v\u000e]5d\u0007>tg-[4XSRD\u0017J\u001c5fe&$X\r\u001a'pG\u0006d'+\u001a;f]RLwN\\*ju\u0016$2A\u0017B\u001c\u0011\u0019\t\t%\na\u0001\u001b\"\u001aQ%!\u0012)\u000f\u0015\n\u0019&a\u0018\u0003>1\"\u00111MA4\u0003=\"Xm\u001d;Va\u0012\fG/\u001a+pa&\u001c7i\u001c8gS\u001e<\u0016\u000e\u001e5ESN\f'\r\\5oOJ+Wn\u001c;f'R|'/Y4f)\rQ&1\t\u0005\u0007\u0003\u00032\u0003\u0019A')\u0007\u0019\n)\u0005K\u0004'\u0003'\nyF!\u0013-\u0005\u0005\u001d\u0014a\u000b;fgR,\u0006\u000fZ1uK&sg/\u00197jIJ+Wn\u001c;f'R|'/Y4f\u0007>tg-[4V]\u0012,'OW&\u0015\u0007i\u0013y\u0005\u0003\u0004\u0002B\u001d\u0002\r!\u0014\u0015\u0004O\u0005\u0015\u0003fB\u0014\u0002T\u0005}#Q\u000b\u0017\u0003\u0003G\n\u0011\u0003^3tiR{\u0007/[2EK2,G/[8o)\rQ&1\f\u0005\u0007\u0003\u0003B\u0003\u0019A')\u0007!\n)\u0005K\u0004)\u0003'\nyF!\u0019-\t\u0005\r\u0014qM\u0001@i\u0016\u001cHo\u00117vgR,'oV5eK\u0012K7/\u00192mK6,g\u000e^(g)&,'/\u001a3Ti>\u0014\u0018mZ3XSRDWI\\1cY\u0016$G+[3sK\u0012$v\u000e]5d)\rQ&q\r\u0005\u0007\u0003\u0003J\u0003\u0019A')\u0007%\n)\u0005K\u0004*\u0003'\nyF!\u001c-\t\u0005\r\u0014qM\u0001Li\u0016\u001cHo\u00117vgR,'oV5uQ>,H\u000fV5fe\u0016$7\u000b^8sC\u001e,7\u000b^1siN\u001cVoY2fgN4W\u000f\u001c7z\u0013\u001a$v\u000e]5d/&$\b\u000eV5fe&tw\rR5tC\ndW\r\u001a\u000b\u00045\nM\u0004BBA!U\u0001\u0007Q\nK\u0002+\u0003\u000bBsAKA*\u0003?\u0012I\b\f\u0003\u0002d\u0005\u001d\u0014!F1tg\u0016\u0014H\u000f\u00165s_^\u001cX\t_2faRLwN\u001c\u000b\t\u0005\u007f\u0012\tJ!,\u0003>B!!\u0011\u0011BF\u001d\u0011\u0011\u0019Ia\"\u000f\u0007A\u0013))C\u0001F\u0013\r\u0011I\tR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iIa$\u0003\u0013QC'o\\<bE2,'b\u0001BE\t\"9!1S\u0016A\u0002\tU\u0015!D3yG\u0016\u0004H/[8o)f\u0004X\r\r\u0003\u0003\u0018\n\u0005\u0006#\u0002(\u0003\u001a\nu\u0015b\u0001BN/\n)1\t\\1tgB!!q\u0014BQ\u0019\u0001!ABa)\u0003\u0012\u0006\u0005\t\u0011!B\u0001\u0005K\u00131a\u0018\u00132#\u0011\u00119Ka \u0011\u0007\r\u0013I+C\u0002\u0003,\u0012\u0013qAT8uQ&tw\rC\u0004\u00030.\u0002\rA!-\u0002\u0015\u0015DXmY;uC\ndW\r\u0005\u0003\u00034\neVB\u0001B[\u0015\u0011\u00119,!\u0007\u0002\u0011\u0019,hn\u0019;j_:LAAa/\u00036\nQQ\t_3dkR\f'\r\\3\t\u0011\t}6\u0006%AA\u00025\u000bq!\\3tg\u0006<W-A\u0010bgN,'\u000f\u001e+ie><8/\u0012=dKB$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\"A!2+\u00075\u00139m\u000b\u0002\u0003JB!!1\u001aBk\u001b\t\u0011iM\u0003\u0003\u0003P\nE\u0017!C;oG\",7m[3e\u0015\r\u0011\u0019\u000eR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bl\u0005\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m1XM]5gsJ+Wn\u001c;f\u0019><Gk\u001c9jG\u000e{gNZ5hgR\u0019!L!8\t\r\t}W\u00061\u0001\u007f\u0003-!x\u000e]5d\u0007>tg-[4\u0002\u001b=4XM\u001d:jI\u0016\u0004&o\u001c9t)\u0005q\bf\u0002\u0001\u0003h\u0006-'Q\u001e\t\u0005\u0003/\u0011I/\u0003\u0003\u0003l\u0006e!a\u0001+bO\u0006\u0012!q^\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class RemoteTopicCrudTest
extends IntegrationTestHarness {
    private final int numPartitions;
    private final int numReplicationFactor;
    private String testTopicName;
    private boolean sysRemoteStorageEnabled = true;
    private String storageManagerClassName = NoOpRemoteStorageManager.class.getName();
    private String metadataManagerClassName = NoOpRemoteLogMetadataManager.class.getName();

    public int numPartitions() {
        return this.numPartitions;
    }

    public int numReplicationFactor() {
        return this.numReplicationFactor;
    }

    public String testTopicName() {
        return this.testTopicName;
    }

    public void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    public boolean sysRemoteStorageEnabled() {
        return this.sysRemoteStorageEnabled;
    }

    public void sysRemoteStorageEnabled_$eq(boolean x$1) {
        this.sysRemoteStorageEnabled = x$1;
    }

    public String storageManagerClassName() {
        return this.storageManagerClassName;
    }

    public void storageManagerClassName_$eq(String x$1) {
        this.storageManagerClassName = x$1;
    }

    public String metadataManagerClassName() {
        return this.metadataManagerClassName;
    }

    public void metadataManagerClassName_$eq(String x$1) {
        this.metadataManagerClassName = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overrideProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.overrideProps(), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        if (((Method)info.getTestMethod().get()).getName().endsWith("SystemRemoteStorageIsDisabled")) {
            this.sysRemoteStorageEnabled_$eq(false);
        }
        if (((Method)info.getTestMethod().get()).getName().equals("testTopicDeletion")) {
            this.storageManagerClassName_$eq(MyRemoteStorageManager.class.getName());
            this.metadataManagerClassName_$eq(MyRemoteLogMetadataManager.class.getName());
        }
        super.setUp(info);
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        topicConfig.put("local.retention.bytes", "256");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "1001");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "1025");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateCompactedRemoteStorage(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("cleanup.policy", "compact");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,true,true", "kraft,true,false", "kraft,false,true", "kraft,false,false"})
    public void testCreateRemoteTopicWithCopyDisabledAndDeleteOnDisable(String quorum, boolean copyDisabled, boolean deleteOnDisable) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.log.copy.disable", Boolean.toString(copyDisabled));
        topicConfig.put("remote.log.delete.on.disable", Boolean.toString(deleteOnDisable));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicRetentionMsValidationWithRemoteCopyDisabled(String quorum) {
        String testTopicName2 = new StringBuilder(1).append(this.testTopicName()).append("2").toString();
        String testTopicName3 = new StringBuilder(1).append(this.testTopicName()).append("3").toString();
        String errorMsgMs = "When `remote.log.copy.disable` is set to true, the `local.retention.ms` and `retention.ms` must be set to the identical value because there will be no more logs copied to the remote storage.";
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("remote.log.copy.disable", "true");
        topicConfig.put("local.retention.ms", "100");
        topicConfig.put("retention.ms", "1000");
        topicConfig.put("local.retention.bytes", "-2");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Throwable err = this.assertThrowsException(InvalidConfigurationException.class, () -> {
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
        Assertions.assertEquals((Object)errorMsgMs, (Object)err.getMessage());
        topicConfig.put("local.retention.ms", "1000");
        String x$10 = this.testTopicName();
        Buffer<KafkaBroker> x$11 = this.brokers();
        Seq<ControllerServer> x$12 = this.controllerServers();
        int x$13 = this.numPartitions();
        int x$14 = this.numReplicationFactor();
        Map x$16 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$10, x$11, x$12, x$13, x$14, (Map<Object, Seq<Object>>)x$16, topicConfig);
        topicConfig.put("local.retention.ms", "-2");
        Buffer<KafkaBroker> x$19 = this.brokers();
        Seq<ControllerServer> x$20 = this.controllerServers();
        int x$21 = this.numPartitions();
        int x$22 = this.numReplicationFactor();
        Map x$24 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName2, x$19, x$20, x$21, x$22, (Map<Object, Seq<Object>>)x$24, topicConfig);
        topicConfig.clear();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("local.retention.ms", "100");
        topicConfig.put("retention.ms", "1000");
        topicConfig.put("local.retention.bytes", "-2");
        Buffer<KafkaBroker> x$27 = this.brokers();
        Seq<ControllerServer> x$28 = this.controllerServers();
        int x$29 = this.numPartitions();
        int x$30 = this.numReplicationFactor();
        Map x$32 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName3, x$27, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$32, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        Throwable err2 = this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
        Assertions.assertEquals((Object)errorMsgMs, (Object)err2.getMessage());
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "1000"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicRetentionBytesValidationWithRemoteCopyDisabled(String quorum) {
        String testTopicName2 = new StringBuilder(1).append(this.testTopicName()).append("2").toString();
        String testTopicName3 = new StringBuilder(1).append(this.testTopicName()).append("3").toString();
        String errorMsgBytes = "When `remote.log.copy.disable` is set to true, the `local.retention.bytes` and `retention.bytes` must be set to the identical value because there will be no more logs copied to the remote storage.";
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("remote.log.copy.disable", "true");
        topicConfig.put("local.retention.bytes", "100");
        topicConfig.put("retention.bytes", "1000");
        topicConfig.put("local.retention.ms", "-2");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Throwable err = this.assertThrowsException(InvalidConfigurationException.class, () -> {
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
        Assertions.assertEquals((Object)errorMsgBytes, (Object)err.getMessage());
        topicConfig.put("local.retention.bytes", "1000");
        String x$10 = this.testTopicName();
        Buffer<KafkaBroker> x$11 = this.brokers();
        Seq<ControllerServer> x$12 = this.controllerServers();
        int x$13 = this.numPartitions();
        int x$14 = this.numReplicationFactor();
        Map x$16 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$10, x$11, x$12, x$13, x$14, (Map<Object, Seq<Object>>)x$16, topicConfig);
        topicConfig.put("local.retention.bytes", "-2");
        Buffer<KafkaBroker> x$19 = this.brokers();
        Seq<ControllerServer> x$20 = this.controllerServers();
        int x$21 = this.numPartitions();
        int x$22 = this.numReplicationFactor();
        Map x$24 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName2, x$19, x$20, x$21, x$22, (Map<Object, Seq<Object>>)x$24, topicConfig);
        topicConfig.clear();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("local.retention.bytes", "100");
        topicConfig.put("retention.bytes", "1000");
        topicConfig.put("local.retention.ms", "-2");
        Buffer<KafkaBroker> x$27 = this.brokers();
        Seq<ControllerServer> x$28 = this.controllerServers();
        int x$29 = this.numPartitions();
        int x$30 = this.numReplicationFactor();
        Map x$32 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName3, x$27, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$32, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        Throwable err2 = this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
        Assertions.assertEquals((Object)errorMsgBytes, (Object)err2.getMessage());
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "1000"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogOnExistingTopicTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogWhenSystemRemoteStorageIsDisabled(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfigWithRemoteStorage = new Properties();
        topicConfigWithRemoteStorage.put("remote.storage.enable", "true");
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfigWithRemoteStorage);
        }, "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
        TestUtils$.MODULE$.createTopicWithAdmin(admin, this.testTopicName(), this.brokers(), this.controllerServers(), this.numPartitions(), this.numReplicationFactor(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionTimeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionSizeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionTime(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionSize(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "512"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Invalid local retention size");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithDisablingRemoteStorage(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "false"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Disabling remote storage feature on the topic level is not supported.");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testUpdateInvalidRemoteStorageConfigUnderZK(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String errorMsg = "It is invalid to set `remote.log.delete.on.disable` or `remote.log.copy.disable` under Zookeeper's mode.";
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), errorMsg);
        configs.clear();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.delete.on.disable", "true"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), errorMsg);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().set(0);
        int numPartitions = 2;
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, numPartitions, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        TestUtils$.MODULE$.deleteTopicWithAdmin(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName(), this.brokers(), this.controllerServers());
        this.assertThrowsException(UnknownTopicOrPartitionException.class, () -> TestUtils$.MODULE$.describeTopic(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName()), "Topic should be deleted");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$testTopicDeletion$2(numPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Remote log segments should be deleted only once by the leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWideDisablementOfTieredStorageWithEnabledTieredTopic(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        if (this.isKRaftTest()) {
            boolean x$10 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$10, true);
            Assertions.assertTrue((boolean)(this.faultHandler().firstException().getCause() instanceof ConfigException));
            this.faultHandler().setIgnore(true);
            return;
        }
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean x$12 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$12, true);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWithoutTieredStorageStartsSuccessfullyIfTopicWithTieringDisabled(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", Boolean.toString(false));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
    }

    private Throwable assertThrowsException(Class<? extends Throwable> exceptionType, Executable executable, String message) {
        return Assertions.assertThrows(exceptionType, () -> {
            try {
                executable.execute();
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, (String)message);
    }

    private String assertThrowsException$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private void verifyRemoteLogTopicConfigs(Properties topicConfig) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$1(this, topicConfig)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$3(topicConfig));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties overrideProps() {
        Properties props = new Properties();
        props.put("remote.log.storage.system.enable", Boolean.toString(this.sysRemoteStorageEnabled()));
        props.put("remote.log.storage.manager.class.name", this.storageManagerClassName());
        props.put("remote.log.metadata.manager.class.name", this.metadataManagerClassName());
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2000");
        props.put("log.local.retention.ms", "1000");
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "2048");
        props.put("log.local.retention.bytes", "1024");
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$2(int numPartitions$1) {
        return numPartitions$1 * MyRemoteLogMetadataManager$.MODULE$.segmentCountPerPartition() == MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().get();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$3() {
        return "Remote log segments should be deleted only once by the leader";
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteLogTopicConfigs$1(RemoteTopicCrudTest $this, Properties topicConfig$6) {
        Buffer logBuffer = (Buffer)$this.brokers().flatMap((Function1 & Serializable)x$2 -> {
            LogManager qual$1 = x$2.logManager();
            TopicPartition x$1 = new TopicPartition($this.testTopicName(), 0);
            boolean x$22 = qual$1.getLog$default$2();
            return qual$1.getLog(x$1, x$22);
        });
        boolean result = logBuffer.nonEmpty();
        if (result) {
            if (topicConfig$6.containsKey("remote.storage.enable")) {
                boolean bl = result = result && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.storage.enable"))) == ((UnifiedLog)logBuffer.head()).config().remoteStorageEnable();
            }
            if (topicConfig$6.containsKey("local.retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("local.retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionBytes();
            }
            if (topicConfig$6.containsKey("local.retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("local.retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionMs();
            }
            if (topicConfig$6.containsKey("retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().retentionMs;
            }
            if (topicConfig$6.containsKey("retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().retentionSize;
            }
            if (topicConfig$6.contains("remote.log.copy.disable")) {
                boolean bl = result = result && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.log.copy.disable")))), (Object)((UnifiedLog)logBuffer.head()).config().remoteLogCopyDisable());
            }
            if (topicConfig$6.contains("remote.log.delete.on.disable")) {
                result = result && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.log.delete.on.disable")))), (Object)((UnifiedLog)logBuffer.head()).config().remoteLogDeleteOnDisable());
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$verifyRemoteLogTopicConfigs$3(Properties topicConfig$6) {
        return new StringBuilder(30).append("Failed to update topic config ").append(topicConfig$6).toString();
    }

    public RemoteTopicCrudTest() {
        this.numPartitions = 2;
        this.numReplicationFactor = 2;
    }
}

