/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class KafkaClusterTestKitTest {
    @ParameterizedTest
    @ValueSource(ints={0, -1})
    public void testCreateClusterWithBadNumDisksThrows(int disks) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumDisksPerBroker(disks).setNumControllerNodes(1).build()));
        Assertions.assertEquals((Object)"Invalid value for numDisksPerBroker", (Object)e.getMessage());
    }

    @Test
    public void testCreateClusterWithBadNumOfControllers() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(-1).build()));
        Assertions.assertEquals((Object)"Invalid negative value for numControllerNodes", (Object)e.getMessage());
    }

    @Test
    public void testCreateClusterWithBadNumOfBrokers() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(-1).setNumControllerNodes(1).build()));
        Assertions.assertEquals((Object)"Invalid negative value for numBrokerNodes", (Object)e.getMessage());
    }

    @Test
    public void testCreateClusterWithBadPerServerProperties() {
        HashMap<Integer, Map<String, String>> perServerProperties = new HashMap<Integer, Map<String, String>>();
        perServerProperties.put(100, Collections.singletonMap("foo", "foo1"));
        perServerProperties.put(200, Collections.singletonMap("bar", "bar1"));
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setPerServerProperties(perServerProperties).build()));
        Assertions.assertEquals((Object)"Unknown server id 100, 200 in perServerProperties, the existent server ids are 0, 3000", (Object)e.getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCreateClusterAndCloseWithMultipleLogDirs(boolean combined) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(5).setNumDisksPerBroker(2).setCombined(combined).setNumControllerNodes(3).build()).build();){
            Assertions.assertEquals((int)5, (int)cluster.nodes().brokerNodes().size());
            Assertions.assertEquals((int)3, (int)cluster.nodes().controllerNodes().size());
            cluster.nodes().brokerNodes().forEach((brokerId, node) -> {
                Assertions.assertEquals((int)2, (int)node.logDataDirectories().size());
                HashSet<String> expected = new HashSet<String>(Arrays.asList(String.format("broker_%d_data0", brokerId), String.format("broker_%d_data1", brokerId)));
                if (node.combined()) {
                    expected = new HashSet<String>(Arrays.asList(String.format("combined_%d_0", brokerId), String.format("combined_%d_1", brokerId)));
                }
                Assertions.assertEquals(expected, node.logDataDirectories().stream().map(p -> Paths.get(p, new String[0]).getFileName().toString()).collect(Collectors.toSet()));
            });
            cluster.nodes().controllerNodes().forEach((controllerId, node) -> {
                String expected = combined ? String.format("combined_%d_0", controllerId) : String.format("controller_%d", controllerId);
                Assertions.assertEquals((Object)expected, (Object)Paths.get(node.metadataDirectory(), new String[0]).getFileName().toString());
            });
        }
        catch (Exception e) {
            Assertions.fail((String)"failed to init cluster", (Throwable)e);
        }
    }
}

