/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.serializer.Decoder;
import kafka.serializer.IntegerDecoder;
import kafka.serializer.LongDecoder;
import kafka.serializer.StringDecoder;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.VoterSetTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.api.DefaultDecoder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004\\\u0001\u0001\u0006Ia\u0015\u0005\b9\u0002\u0011\r\u0011\"\u0001S\u0011\u0019i\u0006\u0001)A\u0005'\"9a\f\u0001b\u0001\n\u0003y\u0006B\u00024\u0001A\u0003%\u0001\rC\u0004h\u0001\t\u0007I\u0011A0\t\r!\u0004\u0001\u0015!\u0003a\u0011\u001dI\u0007A1A\u0005\u0002}CaA\u001b\u0001!\u0002\u0013\u0001\u0007bB6\u0001\u0005\u0004%\ta\u0018\u0005\u0007Y\u0002\u0001\u000b\u0011\u00021\t\u000f5\u0004!\u0019!C\u0001?\"1a\u000e\u0001Q\u0001\n\u0001Dqa\u001c\u0001C\u0002\u0013\u0005\u0001\u000f\u0003\u0004\u007f\u0001\u0001\u0006I!\u001d\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0001bCA\u0007\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fA1\"a\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u001c\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\tI\u0006\u0001C\u0001\u0003?Aq!a\u0019\u0001\t\u0003\ty\u0002C\u0004\u0002h\u0001!\t!a\b\t\u000f\u0005-\u0004\u0001\"\u0001\u0002 !9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\t\t\u000b\u0001C\u0001\u0003?Aq!!*\u0001\t\u0003\ty\u0002C\u0004\u0002*\u0002!\t!a\b\t\u000f\u00055\u0006\u0001\"\u0001\u0002 !9\u0011\u0011\u0017\u0001\u0005\u0002\u0005}\u0001bBA[\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003s\u0003A\u0011AA\u0010\u0011\u001d\ti\f\u0001C\u0001\u0003?Aq!!1\u0001\t\u0003\ty\u0002C\u0004\u0002F\u0002!\t!a\b\t\u000f\u0005%\u0007\u0001\"\u0001\u0002 !9\u0011Q\u001a\u0001\u0005\u0002\u0005}\u0001bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003?\u0004A\u0011AA\u0010\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003?Aq!a:\u0001\t\u0003\ty\u0002C\u0004\u0002l\u0002!\t!a\b\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9!q\u0001\u0001\u0005\n\t%\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005cAqA!\u0010\u0001\t\u0013\u0011ydB\u0004\u0003D\u0005C\tA!\u0012\u0007\r\u0001\u000b\u0005\u0012\u0001B$\u0011\u0019iu\u0007\"\u0001\u0003J\u00191!1J\u001c\u0001\u0005\u001bB!Ba\u0019:\u0005\u0003\u0005\u000b\u0011\u0002B3\u0011\u0019i\u0015\b\"\u0001\u0003r!9!\u0011P\u001d\u0005B\tmdA\u0002BAo\u0001\u0011\u0019\t\u0003\u0004N{\u0011\u0005!Q\u0011\u0005\b\u0005sjD\u0011\tBE\u0005M!U/\u001c9M_\u001e\u001cVmZ7f]R\u001cH+Z:u\u0015\t\u00115)A\u0003u_>d7OC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\n\u0005\u0002Q\u00015\t\u0011)\u0001\u0004u[B$\u0015N]\u000b\u0002'B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0003S>T\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[+\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\fg\u0016<W.\u001a8u\u001d\u0006lW-F\u0001a!\t\tG-D\u0001c\u0015\t\u0019w+\u0001\u0003mC:<\u0017BA3c\u0005\u0019\u0019FO]5oO\u0006a1/Z4nK:$h*Y7fA\u0005YAn\\4GS2,\u0007+\u0019;i\u00031awn\u001a$jY\u0016\u0004\u0016\r\u001e5!\u00031\u0019h.\u00199tQ>$\b+\u0019;i\u00035\u0019h.\u00199tQ>$\b+\u0019;iA\u0005i\u0011N\u001c3fq\u001aKG.\u001a)bi\"\fa\"\u001b8eKb4\u0015\u000e\\3QCRD\u0007%A\tuS6,\u0017J\u001c3fq\u001aKG.\u001a)bi\"\f!\u0003^5nK&sG-\u001a=GS2,\u0007+\u0019;iA\u0005!A/[7f+\u0005\t\bC\u0001:}\u001b\u0005\u0019(B\u0001;v\u0003\u0011)H/\u001b7\u000b\u0005Y<\u0018AB:feZ,'O\u0003\u0002Eq*\u0011\u0011P_\u0001\u0007CB\f7\r[3\u000b\u0003m\f1a\u001c:h\u0013\ti8O\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\rawnZ\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\n5\u0011\u0011q\u0001\u0006\u0003\u007f\u000eKA!a\u0003\u0002\b\tQQK\\5gS\u0016$Gj\\4\u0002\u000f1|wm\u0018\u0013fcR!\u0011\u0011CA\f!\rA\u00151C\u0005\u0004\u0003+I%\u0001B+oSRD\u0011\"!\u0007\u0014\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013'\u0001\u0003m_\u001e\u0004\u0013!C1gi\u0016\u0014X)Y2i)\t\t\t\u0002K\u0002\u0016\u0003G\u0001B!!\n\u000245\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0002ba&TA!!\f\u00020\u00059!.\u001e9ji\u0016\u0014(bAA\u0019u\u0006)!.\u001e8ji&!\u0011QGA\u0014\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0007de\u0016\fG/\u001a+fgRdunZ\u0001\u0011C\u0012$7+[7qY\u0016\u0014VmY8sIN$b!!\u0005\u0002>\u0005}\u0002BB@\u0018\u0001\u0004\t\u0019\u0001C\u0004\u0002B]\u0001\r!a\u0011\u0002\u000f\t\fGo\u00195fgB1\u0011QIA(\u0003'j!!a\u0012\u000b\t\u0005%\u00131J\u0001\b[V$\u0018M\u00197f\u0015\r\ti%S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA)\u0003\u000f\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0019\u0001+!\u0016\n\u0007\u0005]\u0013IA\u0005CCR\u001c\u0007.\u00138g_\u0006\u0001C/Z:u\u0005\u0006$8\r[!oIJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC>+H\u000f];uQ\rA\u0012Q\f\t\u0005\u0003K\ty&\u0003\u0003\u0002b\u0005\u001d\"\u0001\u0002+fgR\f\u0001\u0003^3tiB\u0013\u0018N\u001c;ECR\fGj\\4)\u0007e\ti&A\fuKN$H)^7q\u0013:$W\r_'jg6\fGo\u00195fg\"\u001a!$!\u0018\u0002/Q,7\u000f\u001e#v[B$\u0016.\\3J]\u0012,\u00070\u0012:s_J\u001c\bfA\u000e\u0002^\u0005q1m\\;oiN+(m\u001d;sS:<GCBA:\u0003s\n\t\nE\u0002I\u0003kJ1!a\u001eJ\u0005\rIe\u000e\u001e\u0005\b\u0003wb\u0002\u0019AA?\u0003\r\u0019HO\u001d\t\u0005\u0003\u007f\niI\u0004\u0003\u0002\u0002\u0006%\u0005cAAB\u00136\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f+\u0015A\u0002\u001fs_>$h(C\u0002\u0002\f&\u000ba\u0001\u0015:fI\u00164\u0017bA3\u0002\u0010*\u0019\u00111R%\t\u000f\u0005ME\u00041\u0001\u0002~\u0005\u00191/\u001e2\u0002\u0015\t\fGo\u00195D_VtG\u000f\u0006\u0003\u0002t\u0005e\u0005bBA>;\u0001\u0007\u0011QP\u0001\fe\u0016\u001cwN\u001d3D_VtG\u000f\u0006\u0003\u0002t\u0005}\u0005bBA>=\u0001\u0007\u0011QP\u0001\u001fi\u0016\u001cH\u000fR;naJ+Wn\u001c;f\u0019><W*\u001a;bI\u0006$\u0018-R7qifD3aHA/\u0003)\"Xm\u001d;Ek6\u0004(+Z7pi\u0016dunZ'fi\u0006$\u0017\r^1P]\u0016\u0014VmY8sI>sWMQ1uG\"D3\u0001IA/\u0003A\"Xm\u001d;Ek6\u0004(+Z7pi\u0016dunZ'fi\u0006$\u0017\r^1Nk2$\u0018\u000e\u001d7f%\u0016\u001cwN\u001d3t\u001f:,')\u0019;dQ\"\u001a\u0011%!\u0018\u0002oQ,7\u000f\u001e#v[B\u0014V-\\8uK2{w-T3uC\u0012\fG/Y'vYRL\u0007\u000f\\3SK\u000e|'\u000fZ:Nk2$\u0018\u000e\u001d7f\u0005\u0006$8\r[3tQ\r\u0011\u0013QL\u0001/i\u0016\u001cH\u000fR;naJ+Wn\u001c;f\u0019><W*\u001a;bI\u0006$\u0018MT8o5\u0016\u0014xn\u0015;beRLgnZ(gMN,G\u000fK\u0002$\u0003;\nq\u0005^3ti\u0012+X\u000e\u001d*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC^KG\u000f[\"peJ,\b\u000f^5p]\"\u001aA%!\u0018\u0002IQ,7\u000f\u001e#v[B\u0014V-\\8uK2{w-T3uC\u0012\fG/Y%p\u000bb\u001cW\r\u001d;j_:D3!JA/\u0003\u0011\"Xm\u001d;Ek6\u0004(+Z7pi\u0016dunZ'fi\u0006$\u0017\r^1O_\u001aKG.Z:GY\u0006<\u0007f\u0001\u0014\u0002^\u0005aC/Z:u\tVl\u0007OU3n_R,Gj\\4NKR\fG-\u0019;b\u001d>\u001cVo\u00195GS2,W\t_2faRLwN\u001c\u0015\u0004O\u0005u\u0013a\u0006;fgR$U/\u001c9NKR\fG-\u0019;b%\u0016\u001cwN\u001d3tQ\rA\u0013QL\u0001\u0019i\u0016\u001cH\u000fR;na6+G/\u00193bi\u0006\u001cf.\u00199tQ>$\bfA\u0015\u0002^\u0005\u0011B/Z:u\tVl\u0007/R7qifLe\u000eZ3yQ\rQ\u0013QL\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000f\u0006\u0003\u0002~\u0005U\u0007bBAlW\u0001\u0007\u0011\u0011\\\u0001\u0005CJ<7\u000fE\u0003I\u00037\fi(C\u0002\u0002^&\u0013Q!\u0011:sCf\fa\u0004^3tiB\u0013\u0018N\u001c;ECR\fGj\\4QCJ$\u0018.\u00197CCR\u001c\u0007.Z:)\u00071\ni&\u0001\ruKN$xJ\u001a4tKR\u001cX*Z:tC\u001e,\u0007+\u0019:tKJD3!LA/\u00039!Xm\u001d;OK^$UmY8eKJD3ALA/\u0003\u0005\"Xm\u001d;D_:4XM\u001d;EKB\u0014XmY1uK\u0012$UmY8eKJ\u001cE.Y:tQ\ry\u0013QL\u0001\u0012e\u0016\fGMQ1uG\"lU\r^1eCR\fG\u0003BAz\u0003s\u0004R\u0001SA{\u0003{J1!a>J\u0005\u0019y\u0005\u000f^5p]\"9\u00111 \u0019A\u0002\u0005u\u0018!\u00027j]\u0016\u001c\bCBA\u0000\u0005\u0007\ti(\u0004\u0002\u0003\u0002)\u0011AoV\u0005\u0005\u0005\u000b\u0011\tA\u0001\u0007MSN$\u0018\n^3sCR|'/A\fsK\u0006$\u0007+\u0019:uS\u0006d')\u0019;dQ\u0016\u001c()\u001f;fgR1\u00111\u000fB\u0006\u0005\u001bAq!a?2\u0001\u0004\ti\u0010C\u0004\u0003\u0010E\u0002\r!a\u001d\u0002\u000b1LW.\u001b;\u0002\u0019\r|WO\u001c;CCR\u001c\u0007.Z:\u0015\t\u0005M$Q\u0003\u0005\b\u0003w\u0014\u0004\u0019AA\u007f\u0003A\u0011X-\u00193CCR\u001c\u0007NU3d_J$7\u000f\u0006\u0003\u0003\u001c\t5\u0002C\u0002B\u000f\u0005O\tiH\u0004\u0003\u0003 \t\rb\u0002BAB\u0005CI\u0011AS\u0005\u0004\u0005KI\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011YCA\u0002TKFT1A!\nJ\u0011\u001d\tYp\ra\u0001\u0003{\f1\u0003]1sg\u0016lU\r^1eCR\fg)[3mIN$BAa\r\u0003:AA\u0011q\u0010B\u001b\u0003{\ni(\u0003\u0003\u00038\u0005=%aA'ba\"9!1\b\u001bA\u0002\u0005u\u0014\u0001\u00027j]\u0016\f1$Y:tKJ$H)^7q\u0019><'+Z2pe\u0012lU\r^1eCR\fG\u0003BA\t\u0005\u0003Baa`\u001bA\u0002\u0005\r\u0011a\u0005#v[BdunZ*fO6,g\u000e^:UKN$\bC\u0001)8'\t9t\t\u0006\u0002\u0003F\tYA+Z:u\t\u0016\u001cw\u000eZ3s'\u0011ItIa\u0014\u0011\r\tE#q\u000bB.\u001b\t\u0011\u0019FC\u0002\u0003V\r\u000b!b]3sS\u0006d\u0017N_3s\u0013\u0011\u0011IFa\u0015\u0003\u000f\u0011+7m\u001c3feB)\u0001*a7\u0003^A\u0019\u0001Ja\u0018\n\u0007\t\u0005\u0014J\u0001\u0003CsR,\u0017!\u00029s_B\u001c\b\u0003\u0002B4\u0005[j!A!\u001b\u000b\u0007\t-4)A\u0003vi&d7/\u0003\u0003\u0003p\t%$\u0001\u0006,fe&4\u0017.\u00192mKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003t\t]\u0004c\u0001B;s5\tq\u0007C\u0004\u0003dm\u0002\rA!\u001a\u0002\u0013\u0019\u0014x.\u001c\"zi\u0016\u001cH\u0003\u0002B.\u0005{BqAa =\u0001\u0004\u0011Y&A\u0003csR,7O\u0001\u0014UKN$H)Z2pI\u0016\u0014x+\u001b;i_V$h+\u001a:jM&\f'\r\\3Qe>\u0004XM\u001d;jKN\u001cB!P$\u0003PQ\u0011!q\u0011\t\u0004\u0005kjD\u0003\u0002B.\u0005\u0017CqAa @\u0001\u0004\u0011Y\u0006")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @AfterEach
    public void afterEach() {
        Option$.MODULE$.apply((Object)this.log()).foreach((Function1 & Serializable)log -> {
            DumpLogSegmentsTest.$anonfun$afterEach$1(log);
            return BoxedUnit.UNIT;
        });
    }

    private UnifiedLog createTestLog() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(false);
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, 600000, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17));
        return this.log();
    }

    private void addSimpleRecords(UnifiedLog log, ArrayBuffer<BatchInfo> batches) {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)fourthBatchRecords, false, false));
        batches.foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            int withRecords_partitionLeaderEpoch = 0;
            NoCompression withRecords_compression = Compression.NONE;
            Object var2_4 = null;
            simpleRecordArray = null;
            return log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        });
        log.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        this.log_$eq(this.createTestLog());
        UnifiedLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        NoCompression withRecords_compression = Compression.NONE;
        Object var36_4 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        GzipCompression withRecords_compression2 = new GzipCompression.Builder().build();
        Object var39_13 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$7 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, 3, x$9, x$10, x$11, x$12);
        UnifiedLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        NoCompression withRecords_compression3 = Compression.NONE;
        Object var42_22 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, 3, x$15, x$16, x$17, x$18);
        UnifiedLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        NoCompression withIdempotentRecords_compression = Compression.NONE;
        Object var45_33 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$19 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withIdempotentRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        VerificationGuard x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, 3, x$21, x$22, x$23, x$24);
        UnifiedLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        GzipCompression withTransactionalRecords_compression = new GzipCompression.Builder().build();
        Object var51_44 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$25 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        VerificationGuard x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, 5, x$27, x$28, x$29, x$30);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        VerificationGuard x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, 7, AppendOrigin.COORDINATOR, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata(this.log());
    }

    @Test
    public void testPrintDataLog() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()}, batches);
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    public int countSubstring(String str, String sub) {
        String qual$1 = Predef$.MODULE$.augmentString(str);
        int x$1 = sub.length();
        int x$2 = StringOps$.MODULE$.sliding$default$2$extension(qual$1);
        return StringOps$.MODULE$.sliding$extension(qual$1, x$1, x$2).count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$countSubstring$1(sub, x$4)));
    }

    public int batchCount(String str) {
        return this.countSubstring(str, "baseOffset:");
    }

    public int recordCount(String str) {
        return this.countSubstring(str, "payload:");
    }

    @Test
    public void testDumpRemoteLogMetadataEmpty() {
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataOneRecordOneBatch() {
        void withRecords_timestampType;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var34_20 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataMultipleRecordsOneBatch() {
        void withRecords_timestampType;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Uuid remoteSegmentId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(topicIdPartition, remoteSegmentId);
        SimpleRecord[] metadataRecords = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time().milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 0), (List)new .colon.colon((Object)new RemotePartitionDeleteMetadata(topicIdPartition, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$)).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize(message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var38_23 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String expectedUpdatePayload = String.format("RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:%s-0, id=%s}, customMetadata=Optional[CustomMetadata{4 bytes}], state=COPY_SEGMENT_FINISHED, eventTimestampMs=0, brokerId=0}", topicId, topicName, remoteSegmentId);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains(expectedUpdatePayload));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataMultipleRecordsMultipleBatches() {
        void withRecords_timestampType;
        void withRecords_timestampType2;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Uuid remoteSegmentId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(topicIdPartition, remoteSegmentId);
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time().milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 0), (List)new .colon.colon((Object)new RemotePartitionDeleteMetadata(topicIdPartition, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$)).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize(message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var44_23 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20, x$21);
        UnifiedLog qual$2 = this.log();
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var45_33 = null;
        MemoryRecords x$22 = MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$24 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$25 = qual$2.appendAsLeader$default$4();
        RequestLocal x$26 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$27 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$22, 0, x$24, x$25, x$26, x$27);
        this.log().flush(false);
        String expectedUpdatePayload = String.format("RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:%s-0, id=%s}, customMetadata=Optional[CustomMetadata{4 bytes}], state=COPY_SEGMENT_FINISHED, eventTimestampMs=0, brokerId=0}", topicId, topicName, remoteSegmentId);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((this.countSubstring(output, expectedUpdatePayload) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.countSubstring(output, expectedDeletePayload) == 2 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataNonZeroStartingOffset() {
        void withRecords_timestampType;
        void withRecords_timestampType2;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] metadataRecords = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var37_20 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20, x$21);
        UnifiedLog qual$2 = this.log();
        Option x$22 = qual$2.roll$default$1();
        LogSegment secondSegment = qual$2.roll(x$22);
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var38_32 = null;
        secondSegment.append(1L, -1L, 1L, MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords));
        secondSegment.flush();
        this.log().flush(true);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", secondSegment.log().file().getAbsolutePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 1"));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataWithCorruption() {
        void withRecords_timestampType;
        SimpleRecord[] metadataRecords = new SimpleRecord[]{new SimpleRecord(null, "corrupted".getBytes())};
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var31_18 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("Could not deserialize metadata record"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataIoException() {
        void withRecords_timestampType;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] metadataRecords = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var32_20 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        Files.setPosixFilePermissions(Paths.get(this.logFilePath(), new String[0]), PosixFilePermissions.fromString("-w-------"));
        Assertions.assertThrows(AccessDeniedException.class, () -> this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
    }

    @Test
    public void testDumpRemoteLogMetadataNoFilesFlag() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$5, message) -> DumpLogSegmentsTest.$anonfun$testDumpRemoteLogMetadataNoFilesFlag$1(BoxesRunTime.unboxToInt((Object)x$5), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var2_1 = null;
        try {
            Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder"}))).getMessage().equals("Missing required argument \"[files]\""));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testDumpRemoteLogMetadataNoSuchFileException() {
        String noSuchFileLogPath = "/tmp/nosuchfile/00000000000000000000.log";
        Assertions.assertThrows(NoSuchFileException.class, () -> this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", noSuchFileLogPath}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)mockTime.scheduler, (Time)mockTime, 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var46_19 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, 1, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var47_33 = null;
        simpleRecordArray = null;
        MemoryRecords x$22 = MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$24 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$25 = qual$2.appendAsLeader$default$4();
        RequestLocal x$26 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$27 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$22, 2, x$24, x$25, x$26, x$27);
        UnifiedLog qual$3 = this.log();
        NoCompression withRecords_compression3 = Compression.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var49_43 = null;
        MemoryRecords x$28 = MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (Compression)withRecords_compression3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$30 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$31 = qual$3.appendAsLeader$default$4();
        RequestLocal x$32 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$33 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$28, 2, x$30, x$31, x$32, x$33);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        Using$.MODULE$.apply((Function0 & Serializable)() -> new RecordsSnapshotWriter.Builder().setTime((Time)new MockTime()).setLastContainedLogTimestamp((long)lastContainedLogTimestamp).setRawSnapshotWriter((RawSnapshotWriter)metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)).get()).setKraftVersion(KRaftVersion.KRAFT_VERSION_1).setVoterSet(Optional.of(VoterSet.fromMap((Map)VoterSetTest.voterMap((IntStream)IntStream.of(1, 2, 3), (boolean)true)))).build((RecordSerde)MetadataRecordSerde.INSTANCE), arg_0 -> DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2$adapted((scala.collection.immutable.Seq)metadataRecords, arg_0), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()), (String)output);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()), (String)output);
    }

    @Test
    public void testDumpEmptyIndex() {
        this.log_$eq(this.createTestLog());
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        int partialBatches = batches.size() / 2;
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = Arrays.asList(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    @Test
    public void testOffsetsMessageParser() {
        CoordinatorRecordSerde serde = new CoordinatorRecordSerde();
        DumpLogSegments.OffsetsMessageParser parser = new DumpLogSegments.OffsetsMessageParser();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using offset topic decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            NoCompression x$3 = Compression.NONE;
            long x$4 = -1L;
            byte x$5 = 2;
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, (Compression)x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"epoch\":10}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":{\"topics\":[\"foo\"],\"userData\":null,\"ownedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"generationId\":0,\"rackId\":\"rack\"},\"assignment\":{\"assignedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"userData\":null}}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"), null, Collections.singletonList(new TopicPartition("foo", 0)), 0, Optional.of("rack")), (short)3))).setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Collections.singletonList(new TopicPartition("foo", 0))), (short)3))))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":\"U3Vic2NyaXB0aW9u\",\"assignment\":\"QXNzaWdubWVudA==\"}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription("Subscription".getBytes()).setAssignment("Assignment".getBytes()))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), null, serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), Short.MAX_VALUE), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Error at offset 0, skipping. Could not read record with version 0 from value's buffer due to: Error reading byte array of 536870911 byte(s): only 1 byte(s) available."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue(), (short)0), serde)));
    }

    @Test
    public void testNewDecoder() {
        DumpLogSegments$.MODULE$.newDecoder(TestDecoder.class.getName());
        DumpLogSegments$.MODULE$.newDecoder(kafka.serializer.DefaultDecoder.class.getName());
        Assertions.assertThrows(Exception.class, () -> DumpLogSegments$.MODULE$.newDecoder(TestDecoderWithoutVerifiableProperties.class.getName()));
    }

    @Test
    public void testConvertDeprecatedDecoderClass() {
        Assertions.assertEquals((Object)DefaultDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(kafka.serializer.DefaultDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.IntegerDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(IntegerDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.LongDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(LongDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.StringDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(StringDecoder.class.getName()));
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private scala.collection.immutable.Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata(UnifiedLog log) {
        FetchDataInfo logReadInfo = log.read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$afterEach$1(UnifiedLog log) {
        Utils.closeQuietly((AutoCloseable)log, (String)"UnifiedLog");
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private static final boolean isBatch$1(int index, ArrayBuffer batches$1) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)batches$1.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args, ArrayBuffer batches$1) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)batches$1.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = batches$1.iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + batches$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - batches$1.size() + index];
            if (DumpLogSegmentsTest.isBatch$1(index, batches$1)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ boolean $anonfun$countSubstring$1(String sub$1, String x$4) {
        String string = x$4;
        return !(string != null ? !string.equals(sub$1) : sub$1 != null);
    }

    public static final /* synthetic */ Nothing$ $anonfun$testDumpRemoteLogMetadataNoFilesFlag$1(int x$5, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(scala.collection.immutable.Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        snapshotWriter.append(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    private static final Record serializedRecord$1(ApiMessageAndVersion key, ApiMessageAndVersion value, CoordinatorRecordSerde serde$1) {
        CoordinatorRecord record = new CoordinatorRecord(key, value);
        byte[] x$1 = serde$1.serializeKey(record);
        byte[] x$2 = serde$1.serializeValue(record);
        NoCompression x$3 = Compression.NONE;
        long x$4 = -1L;
        byte x$5 = 2;
        return (Record)TestUtils$.MODULE$.singletonRecords(x$2, x$1, (Compression)x$3, x$4, x$5).records().iterator().next();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$18)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$20)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(scala.collection.immutable.Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }

    public static class TestDecoder
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }

        public TestDecoder(VerifiableProperties props) {
        }
    }

    public static class TestDecoderWithoutVerifiableProperties
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }
    }
}

