/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.TimeUnit;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00049\u0001\u0001\u0006Ia\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001b\u0001\n\u0013Q\u0004B\u0002!\u0001A\u0003%1\bC\u0004B\u0001\t\u0007I\u0011\u0002\u001e\t\r\t\u0003\u0001\u0015!\u0003<\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Caa\u0013\u0001!\u0002\u0013)\u0005\"\u0002'\u0001\t\u0003i\u0005\"\u0002/\u0001\t\u0003i\u0005\"\u00020\u0001\t\u0003i\u0005\"\u00021\u0001\t\u0003i\u0005\"\u00022\u0001\t\u0003i\u0005\"\u00023\u0001\t\u0003i\u0005\"\u00024\u0001\t\u0003i\u0005\"\u00025\u0001\t\u0003i\u0005\"\u00026\u0001\t\u0003i\u0005\"\u00027\u0001\t\u0013i\u0007\"\u0002?\u0001\t\u0013i\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\u000f#V|G/Y+uS2\u001cH+Z:u\u0015\tQ2$A\u0003vi&d7OC\u0001\u001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t\u0011$\u0001\u0003uS6,W#A\u0016\u0011\u000512T\"A\u0017\u000b\u00059z\u0013\u0001B;uS2T!\u0001M\u0019\u0002\rM,'O^3s\u0015\ta\"G\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<\u0017BA\u001c.\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u00038v[N\u000bW\u000e\u001d7fgV\t1\b\u0005\u0002!y%\u0011Q(\t\u0002\u0004\u0013:$\u0018a\u00038v[N\u000bW\u000e\u001d7fg\u0002\nqb]1na2,w+\u001b8e_^\u001cVmY\u0001\u0011g\u0006l\u0007\u000f\\3XS:$wn^*fG\u0002\n\u0011#\\1y)\"\u0014x\u000e\u001e;mKRKW.Z't\u0003Ii\u0017\r\u001f+ie>$H\u000f\\3US6,Wj\u001d\u0011\u0002\u00155,GO]5d\u001d\u0006lW-F\u0001F!\t1\u0015*D\u0001H\u0015\tA\u0015'\u0001\u0004d_6lwN\\\u0005\u0003\u0015\u001e\u0013!\"T3ue&\u001cg*Y7f\u0003-iW\r\u001e:jG:\u000bW.\u001a\u0011\u0002OQ,7\u000f\u001e+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0016\u000bX/\u00197t#V|G/\u0019\u000b\u0002\u001dB\u0011\u0001eT\u0005\u0003!\u0006\u0012A!\u00168ji\"\u0012AB\u0015\t\u0003'jk\u0011\u0001\u0016\u0006\u0003+Z\u000b1!\u00199j\u0015\t9\u0006,A\u0004kkBLG/\u001a:\u000b\u0005e#\u0014!\u00026v]&$\u0018BA.U\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f\u001e+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\n+Gn\\<Rk>$\u0018\r\u000b\u0002\u000e%\u00061C/Z:u)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,\u0017IY8wKF+x\u000e^1)\u00059\u0011\u0016A\f;fgR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/Z#rk\u0006d7/U;pi\u0006D#a\u0004*\u0002[Q,7\u000f\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\n+Gn\\<Rk>$\u0018\r\u000b\u0002\u0011%\u00069D/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,\u0017IY8wKF+x\u000e^1CK2|w\u000fT5nSRD#!\u0005*\u0002oQ,7\u000f\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0006\u0013wN^3Rk>$\u0018-\u00112pm\u0016d\u0015.\\5uQ\t\u0011\"+\u0001\u001cuKN$H\u000b\u001b:piRdW\rV5nKRC'o\\<t\u000bb\u001cW\r\u001d;j_:Le\r\u0015:pm&$W\r\u001a(p]J\u000bG/Z'fiJL7\r\u000b\u0002\u0014%\u0006iD/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.\u001a+ie><8/\u0012=dKB$\u0018n\u001c8JMB\u0013xN^5eK\u0012tuN\u001c*bi\u0016lU\r\u001e:jG\"\u0012ACU\u0001\u0018cV|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:$BA\u001c;zwB\u0011qN]\u0007\u0002a*\u0011\u0011oR\u0001\b[\u0016$(/[2t\u0013\t\u0019\bOA\fRk>$\u0018MV5pY\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")Q/\u0006a\u0001m\u0006iqNY:feZ,GMV1mk\u0016\u0004\"\u0001I<\n\u0005a\f#A\u0002#pk\ndW\rC\u0003{+\u0001\u0007a/A\u0003rk>$\u0018\rC\u0003:+\u0001\u00071(\u0001\u0007uQJ|G\u000f\u001e7f)&lW\rF\u0004\u007f\u0003\u0007\t)!a\u0002\u0011\u0005\u0001z\u0018bAA\u0001C\t!Aj\u001c8h\u0011\u0015)h\u00031\u0001w\u0011\u0015Qh\u00031\u0001w\u0011\u0015Id\u00031\u0001<\u0003M\u0011w.\u001e8eK\u0012$\u0006N]8ui2,G+[7f)%q\u0018QBA\b\u0003#\t\u0019\u0002C\u0003v/\u0001\u0007a\u000fC\u0003{/\u0001\u0007a\u000fC\u0003:/\u0001\u00071\b\u0003\u0004\u0002\u0016]\u0001\rA`\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nK\u0002")
public class QuotaUtilsTest {
    private final MockTime time = new MockTime();
    private final int numSamples;
    private final int sampleWindowSec;
    private final int maxThrottleTimeMs;
    private final MetricName metricName = new MetricName("test-metric", "groupA", "testA", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());

    private MockTime time() {
        return this.time;
    }

    private int numSamples() {
        return this.numSamples;
    }

    private int sampleWindowSec() {
        return this.sampleWindowSec;
    }

    private int maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName metricName() {
        return this.metricName;
    }

    @Test
    public void testThrottleTimeObservedRateEqualsQuota() {
        int numSamples = 10;
        double observedValue = 16.5;
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples));
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples + 1));
    }

    @Test
    public void testThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 20.4;
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleTimeObservedRateAboveQuota() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)2000L, (long)this.throttleTime(observedValue, quota, 3));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateEqualsQuota() {
        double observedValue = 18.2;
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 22.4;
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples() + 1, this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaBelowLimit() {
        double quota = 50.0;
        double observedValue = 55.0;
        Assertions.assertEquals((long)100L, (long)this.boundedThrottleTime(observedValue, quota, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaAboveLimit() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)this.maxThrottleTimeMs(), (long)this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.throttleTime(new QuotaViolationException(testMetric, 10.0, 20.0), this.time().milliseconds()));
    }

    @Test
    public void testBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.boundedThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs(), this.time().milliseconds()));
    }

    private QuotaViolationException quotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long throttleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.throttleTime(e, this.time().milliseconds());
    }

    private long boundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, maxThrottleTime, this.time().milliseconds());
    }

    public QuotaUtilsTest() {
        this.numSamples = 10;
        this.sampleWindowSec = 1;
        this.maxThrottleTimeMs = 500;
    }
}

