/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AdminClientWithPoliciesIntegrationTest$;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaa\u0016\u0001!\u0002\u0013!\u0006\"\u0002-\u0001\t\u0003J\u0006\"B5\u0001\t\u0003R\u0007\"B8\u0001\t\u0003\u0001\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\u001e9\u0011\u0011\u0016\u0012\t\u0002\u0005-fAB\u0011#\u0011\u0003\ti\u000b\u0003\u00045#\u0011\u0005\u0011Q\u0017\u0005\n\u0003o\u000b\"\u0019!C\u0001\u0003sC\u0001\"!8\u0012A\u0003%\u00111\u0018\u0005\b\u0003?\fB\u0011AAq\r\u0019\tI0\u0005\u0001\u0002|\"1AG\u0006C\u0001\u0005\u0007A1B!\u0003\u0017\u0001\u0004\u0005\r\u0011\"\u0001\u0003\f!Y!1\u0006\fA\u0002\u0003\u0007I\u0011\u0001B\u0017\u0011-\u0011YB\u0006a\u0001\u0002\u0003\u0006KA!\u0004\t\u0013\teb\u00031A\u0005\u0002\tm\u0002\"\u0003B\"-\u0001\u0007I\u0011\u0001B#\u0011!\u0011IE\u0006Q!\n\tu\u0002b\u0002B&-\u0011\u0005!Q\n\u0005\b\u000572B\u0011\u0001B/\u0011\u0019\u0011\u0019G\u0006C\u0001U\n1\u0013\tZ7j]\u000ec\u0017.\u001a8u/&$\b\u000eU8mS\u000eLWm]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r\"\u0013aA1qS*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!F\u0003\u0002,I\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\ti#F\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\ty#'D\u00011\u0015\t\tD%A\u0003vi&d7/\u0003\u00024a\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001#\u0003\u0019\u0019G.[3oiV\t!\b\u0005\u0002<\u000b6\tAH\u0003\u0002>}\u0005)\u0011\rZ7j]*\u0011q\bQ\u0001\bG2LWM\u001c;t\u0015\t)\u0013I\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$=\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0013>\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013A!\u00168ji\"9\u0001kAA\u0001\u0002\u0004Q\u0014a\u0001=%c\u000591\r\\5f]R\u0004\u0013a\u00032s_.,'oQ8v]R,\u0012\u0001\u0016\t\u0003\u0015VK!AV&\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0003tKR,\u0006\u000f\u0006\u0002J5\")1l\u0002a\u00019\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002^G6\taL\u0003\u0002$?*\u0011\u0001-Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00117)A\u0003kk:LG/\u0003\u0002e=\nAA+Z:u\u0013:4w\u000e\u000b\u0002\bMB\u0011QlZ\u0005\u0003Qz\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A%)\u0005!a\u0007CA/n\u0013\tqgLA\u0005BMR,'/R1dQ\u0006a1M]3bi\u0016\u001cuN\u001c4jOV\t\u0011\u000fE\u0003sof\fI!D\u0001t\u0015\t!X/\u0001\u0003vi&d'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u00141!T1q!\rQ\u00181\u0001\b\u0003w~\u0004\"\u0001`&\u000e\u0003uT!A \u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t\taS\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u00051\n\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0014\u00055!AB(cU\u0016\u001cG/A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012QE\u0007\u0003\u0003;Q1!a\bL\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiBA\u0002TKF\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0013AB:feZ,'/\u0003\u0003\u00020\u0005%\"aC&bM.\f7i\u001c8gS\u001e\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0005\u0003k\tY\u0005\u0005\u0004\u00028\u0005\u0005\u0013Q\t\b\u0005\u0003s\tiDD\u0002}\u0003wI\u0011\u0001T\u0005\u0004\u0003\u007fY\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003G\t\u0019EC\u0002\u0002@-\u00032A]A$\u0013\r\tIe\u001d\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B.\f\u0001\u0004a\u0016aE8wKJ\u0014\u0018\u000eZ3O_\u0012,7i\u001c8gS\u001e\u001cHcA%\u0002R!9\u00111\u000b\u0007A\u0002\u0005\u0015\u0013!\u00029s_B\u001c\u0018!\u0006;fgR4\u0016\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\u0004\u0013\u0006e\u0003BBA.\u001b\u0001\u0007\u00110\u0001\u0004rk>\u0014X/\u001c\u0015\u0004\u001b\u0005}\u0003\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015t,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003S\n\u0019GA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!DA7\u0003s\nY\b\u0005\u0003\u0002p\u0005UTBAA9\u0015\u0011\t\u0019(a\u0019\u0002\u0011A\u0014xN^5eKJLA!a\u001e\u0002r\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!! \u0002\u0002\u0006\u0012\u0011qP\u0001\u0003u.\f#!a!\u0002\u000b-\u0014\u0018M\u001a;\u0002/Q,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cHcA%\u0002\n\"1\u00111\f\bA\u0002eD3ADA0Q\u001dq\u0011QNA=\u0003\u001fcC!! \u0002\u0002\u0006\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGf$2!SAK\u0011\u0019\tYf\u0004a\u0001s\"\u001aq\"a\u0018)\u000f=\ti'!\u001f\u0002\u001c2\"\u0011QPAAQ\u001d\u0001\u0011qTAS\u0003O\u00032!XAQ\u0013\r\t\u0019K\u0018\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\u0018AJ!e[&t7\t\\5f]R<\u0016\u000e\u001e5Q_2L7-[3t\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0011q'E\n\u0004#\u0005=\u0006c\u0001&\u00022&\u0019\u00111W&\u0003\r\u0005s\u0017PU3g)\t\tY+A\u0006wC2LG-\u0019;j_:\u001cXCAA^!\u0019\ti,a1\u0002H6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\fi\"A\u0004nkR\f'\r\\3\n\t\u0005\u0015\u0017q\u0018\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\b\u0003BAe\u0003/tA!a3\u0002T6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t.\u0001\u0004q_2L7-\u001f\u0006\u0004\u0003W\u0001\u0015\u0002BAk\u0003\u001b\f\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0013\u0011\tI.a7\u0003\u001fI+\u0017/^3ti6+G/\u00193bi\u0006TA!!6\u0002N\u0006aa/\u00197jI\u0006$\u0018n\u001c8tA\u00051b/\u00197jI\u0006$\u0018n\u001c8t\r>\u0014(+Z:pkJ\u001cW\r\u0006\u0003\u0002d\u0006\u0015\bCBA\u001c\u0003\u0003\n9\rC\u0004\u0002hV\u0001\r!!;\u0002\u0011I,7o\\;sG\u0016\u0004B!a;\u0002v6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0\u0001\u0004d_:4\u0017n\u001a\u0006\u0004\u0003g\u0004\u0015AB2p[6|g.\u0003\u0003\u0002x\u00065(AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0002\u0007!>d\u0017nY=\u0014\u000bY\tI!!@\u0011\t\u0005-\u0017q`\u0005\u0005\u0005\u0003\tiMA\tBYR,'oQ8oM&<\u0007k\u001c7jGf$\"A!\u0002\u0011\u0007\t\u001da#D\u0001\u0012\u0003\u001d\u0019wN\u001c4jON,\"A!\u00041\t\t=!q\u0003\t\u0007u\nE\u0011Pa\u0005\n\u0007a\f9\u0001\u0005\u0003\u0003\u0016\t]A\u0002\u0001\u0003\f\u00053Q\u0012\u0011!A\u0001\u0006\u0003\u0011iBA\u0002`IE\n\u0001bY8oM&<7\u000fI\t\u0005\u0005?\u0011)\u0003E\u0002K\u0005CI1Aa\tL\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0013B\u0014\u0013\r\u0011Ic\u0013\u0002\u0004\u0003:L\u0018aC2p]\u001aLwm]0%KF$2!\u0013B\u0018\u0011!\u0001\u0016$!AA\u0002\tE\u0002\u0007\u0002B\u001a\u0005o\u0001bA\u001fB\ts\nU\u0002\u0003\u0002B\u000b\u0005o!AB!\u0007\u00030\u0005\u0005\t\u0011!B\u0001\u0005;\taa\u00197pg\u0016$WC\u0001B\u001f!\rQ%qH\u0005\u0004\u0005\u0003Z%a\u0002\"p_2,\u0017M\\\u0001\u000bG2|7/\u001a3`I\u0015\fHcA%\u0003H!A\u0001\u000bHA\u0001\u0002\u0004\u0011i$A\u0004dY>\u001cX\r\u001a\u0011\u0002\u0013\r|gNZ5hkJ,GcA%\u0003P!9!\u0011\u0002\u0010A\u0002\tE\u0003\u0007\u0002B*\u0005/\u0002RA]<z\u0005+\u0002BA!\u0006\u0003X\u0011a!\u0011\fB(\u0003\u0003\u0005\tQ!\u0001\u0003\u001e\t\u0019q\f\n\u001a\u0002\u0011Y\fG.\u001b3bi\u0016$2!\u0013B0\u0011\u001d\u0011\tg\ba\u0001\u0003\u000f\fqB]3rk\u0016\u001cH/T3uC\u0012\fG/Y\u0001\u0006G2|7/\u001a")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client;
    private final int brokerCount;

    public static scala.collection.immutable.Seq<AlterConfigPolicy.RequestMetadata> validationsForResource(ConfigResource resource) {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(resource);
    }

    public static ListBuffer<AlterConfigPolicy.RequestMetadata> validations() {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validations();
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), 15000L);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        configs.foreach((Function1 & Serializable)props -> {
            this.overrideNodeConfigs(props);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    public scala.collection.immutable.Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties props = new Properties();
        props.put("alter.config.policy.class.name", Policy.class);
        return new .colon.colon((Object)props, (List)Nil$.MODULE$);
    }

    private void overrideNodeConfigs(Properties props) {
        props.put("alter.config.policy.class.name", Policy.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testValidAlterConfigs(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty("max.message.bytes", "500000");
        topicConfig1.setProperty("retention.ms", "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1, this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), this, topicResource1, topicResource2);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAlterConfigs(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this, this.client());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAlterConfigsDueToPolicy(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId()));
        java.util.List brokerConfigs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("message.max.bytes", "50000"), (List)Nil$.MODULE$)).asJava();
        this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigs))}))).asJava()).all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.bytes"})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        java.util.List topicConfigEntries1 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.9"), (List)new .colon.colon((Object)new ConfigEntry("min.insync.replicas", "2"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.8"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries3 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.insync.replicas", "-1"), (List)Nil$.MODULE$)).asJava();
        java.util.List brokerConfigEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("ssl.truststore.password", "12313"), (List)Nil$.MODULE$)).asJava();
        AlterConfigsResult alterResult = this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), PolicyViolationException.class, (Option<String>)None$.MODULE$);
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource3), InvalidConfigurationException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, (Option<String>)None$.MODULE$);
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get("ssl.truststore.password").value());
        topicConfigEntries2 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.7"), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), PolicyViolationException.class, (Option<String>)None$.MODULE$);
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource3), InvalidConfigurationException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, (Option<String>)None$.MODULE$);
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get("ssl.truststore.password").value());
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections", "9999"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava());
        alterResult.all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections"})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, Object> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, Object> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, Object> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
            this.configs_$eq((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(configs).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().append((Object)requestMetadata);
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(this.configs().nonEmpty(), (Function0 & Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(requestMetadata.resource().name())), (Function0 & Serializable)() -> "resource name should not be empty");
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

