/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.MyRemoteLogMetadataManager;
import kafka.admin.MyRemoteLogMetadataManager$;
import kafka.admin.MyRemoteStorageManager;
import kafka.admin.MyRemoteStorageManager$;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Random$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001A\u0011\u0019I\u0005\u0001)A\u0005\u0003\"I!\n\u0001a\u0001\u0002\u0004%\ta\u0013\u0005\n/\u0002\u0001\r\u00111A\u0005\u0002aC\u0011B\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u000f}\u0003\u0001\u0019!C\u0001A\"9A\r\u0001a\u0001\n\u0003)\u0007BB4\u0001A\u0003&\u0011\rC\u0004i\u0001\u0001\u0007I\u0011A&\t\u000f%\u0004\u0001\u0019!C\u0001U\"1A\u000e\u0001Q!\n1Cq!\u001c\u0001A\u0002\u0013\u00051\nC\u0004o\u0001\u0001\u0007I\u0011A8\t\rE\u0004\u0001\u0015)\u0003M\u0011\u0015\u0011\b\u0001\"\u0015A\u0011\u0015\u0019\b\u0001\"\u0015u\u0011\u001d\tY\u0001\u0001C)\u0003\u001bAq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!!)\u0001\t\u0003\t\u0019\u000bC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\bbBAy\u0001\u0011\u0005\u00111\u001f\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003\"\u0001!\tAa\t\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!\u0011\b\u0001\u0005\u0002\tm\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0005\u00030\u0002\t\n\u0011\"\u0003\u00032\"9!q\u0019\u0001\u0005\n\t%\u0007b\u0002Bh\u0001\u0011%!\u0011\u001b\u0002\u0014%\u0016lw\u000e^3U_BL7m\u0011:vIR+7\u000f\u001e\u0006\u0003aE\nQ!\u00193nS:T\u0011AM\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0007\u0005\u00027s5\tqG\u0003\u00029c\u0005\u0019\u0011\r]5\n\u0005i:$AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u0005y\u0013!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001B!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\rIe\u000e^\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003QqW/\u001c*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0006)b.^7SKBd\u0017nY1uS>tg)Y2u_J\u0004\u0013!\u0004;fgR$v\u000e]5d\u001d\u0006lW-F\u0001M!\tiEK\u0004\u0002O%B\u0011qjQ\u0007\u0002!*\u0011\u0011kM\u0001\u0007yI|w\u000e\u001e \n\u0005M\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\"\u0002#Q,7\u000f\u001e+pa&\u001cg*Y7f?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011!IW\u0005\u00037\u000e\u0013A!\u00168ji\"9QlBA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013aF:zgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3e+\u0005\t\u0007C\u0001\"c\u0013\t\u00197IA\u0004C_>dW-\u00198\u00027ML8OU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$w\fJ3r)\tIf\rC\u0004^\u0015\u0005\u0005\t\u0019A1\u00021ML8OU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$\u0007%A\fti>\u0014\u0018mZ3NC:\fw-\u001a:DY\u0006\u001c8OT1nK\u0006Y2\u000f^8sC\u001e,W*\u00198bO\u0016\u00148\t\\1tg:\u000bW.Z0%KF$\"!W6\t\u000fuk\u0011\u0011!a\u0001\u0019\u0006A2\u000f^8sC\u001e,W*\u00198bO\u0016\u00148\t\\1tg:\u000bW.\u001a\u0011\u000215,G/\u00193bi\u0006l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lW-\u0001\u000fnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d(b[\u0016|F%Z9\u0015\u0005e\u0003\bbB/\u0011\u0003\u0003\u0005\r\u0001T\u0001\u001a[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u000ec\u0017m]:OC6,\u0007%A\u0006ce>\\WM]\"pk:$\u0018!D7pI&4\u0017pQ8oM&<7\u000f\u0006\u0002Zk\")ao\u0005a\u0001o\u0006)\u0001O]8qgB\u0019\u0001p_?\u000e\u0003eT!A_\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002}s\n\u00191+Z9\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\r9\u0018q\u0002\u0005\b\u0003#!\u0002\u0019AA\n\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\u000b\u0003Ki!!a\u0006\u000b\u0007a\nIB\u0003\u0003\u0002\u001c\u0005u\u0011a\u00026va&$XM\u001d\u0006\u0005\u0003?\t\t#A\u0003kk:LGO\u0003\u0002\u0002$\u0005\u0019qN]4\n\t\u0005\u001d\u0012q\u0003\u0002\t)\u0016\u001cH/\u00138g_\u0006)1/\u001a;VaR\u0019\u0011,!\f\t\u000f\u0005=R\u00031\u0001\u0002\u0014\u0005!\u0011N\u001c4pQ\r)\u00121\u0007\t\u0005\u0003+\t)$\u0003\u0003\u00028\u0005]!A\u0003\"fM>\u0014X-R1dQ\u0006YC/Z:u\u0007J,\u0017\r^3SK6|G/\u001a+pa&\u001cw+\u001b;i-\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rF\u0002Z\u0003{Aa!a\u0010\u0017\u0001\u0004a\u0015AB9v_J,X\u000eK\u0002\u0017\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nI\"\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u001b\n9EA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDsAFA)\u0003;\ny\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&a\u0012\u0002\u0011A\u0014xN^5eKJLA!a\u0017\u0002V\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#!!\u0019\"\u0005\u0005\r\u0014!B6sC\u001a$\u0018a\u000b;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:\u001c\u0016N_3\u0015\u0007e\u000bI\u0007\u0003\u0004\u0002@]\u0001\r\u0001\u0014\u0015\u0004/\u0005\r\u0003fB\f\u0002R\u0005u\u0013q\u000e\u0017\u0003\u0003C\nA\u0007^3ti\u000e\u0013X-\u0019;f%\u0016lw\u000e^3U_BL7mV5uQ&s\u0007.\u001a:ji\u0016$Gj\\2bYJ+G/\u001a8uS>tG+[7f)\rI\u0016Q\u000f\u0005\u0007\u0003\u007fA\u0002\u0019\u0001')\u0007a\t\u0019\u0005K\u0004\u0019\u0003#\ni&a\u001f-\u0005\u0005\u0005\u0014\u0001\u000e;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"Le\u000e[3sSR,G\rT8dC2\u0014V\r^3oi&|gnU5{KR\u0019\u0011,!!\t\r\u0005}\u0012\u00041\u0001MQ\rI\u00121\t\u0015\b3\u0005E\u0013QLADY\t\t\t'A\u0017uKN$8I]3bi\u0016\u0014V-\\8uKR{\u0007/[2XSRD\u0017J\u001c<bY&$'+\u001a;f]RLwN\u001c+j[\u0016$2!WAG\u0011\u0019\tyD\u0007a\u0001\u0019\"\u001a!$a\u0011)\u000fi\t\t&!\u0018\u0002\u00142\u0012\u0011\u0011M\u0001.i\u0016\u001cHo\u0011:fCR,'+Z7pi\u0016$v\u000e]5d/&$\b.\u00138wC2LGMU3uK:$\u0018n\u001c8TSj,GcA-\u0002\u001a\"1\u0011qH\u000eA\u00021C3aGA\"Q\u001dY\u0012\u0011KA/\u0003?c#!!\u0019\u0002AQ,7\u000f^\"sK\u0006$XmQ8na\u0006\u001cG/\u001a3SK6|G/Z*u_J\fw-\u001a\u000b\u00043\u0006\u0015\u0006BBA 9\u0001\u0007A\nK\u0002\u001d\u0003\u0007Bs\u0001HA)\u0003;\nY\u000b\f\u0002\u0002b\u00059D/Z:u\u0007J,\u0017\r^3SK6|G/\u001a+pa&\u001cw+\u001b;i\u0007>\u0004\u0018\u0010R5tC\ndW\rZ!oI\u0012+G.\u001a;f\u001f:$\u0015n]1cY\u0016$r!WAY\u0003g\u000b9\f\u0003\u0004\u0002@u\u0001\r\u0001\u0014\u0005\u0007\u0003kk\u0002\u0019A1\u0002\u0019\r|\u0007/\u001f#jg\u0006\u0014G.\u001a3\t\r\u0005eV\u00041\u0001b\u0003=!W\r\\3uK>sG)[:bE2,\u0007fA\u000f\u0002D!:Q$a0\u0002F\u0006\u001d\u0007\u0003BA*\u0003\u0003LA!a1\u0002V\tI1i\u001d<T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\t\u0003\u0013\fi-!5\u0002V\u0006\u0012\u00111Z\u0001\u0010WJ\fg\r\u001e\u0017ueV,G\u0006\u001e:vK\u0006\u0012\u0011qZ\u0001\u0011WJ\fg\r\u001e\u0017ueV,GFZ1mg\u0016\f#!a5\u0002!-\u0014\u0018M\u001a;-M\u0006d7/\u001a\u0017ueV,\u0017EAAl\u0003EY'/\u00194uY\u0019\fGn]3-M\u0006d7/Z\u0001;i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGJ+G/\u001a8uS>tWj\u001d,bY&$\u0017\r^5p]^KG\u000f\u001b*f[>$XmQ8qs\u0012K7/\u00192mK\u0012$2!WAo\u0011\u0019\tyD\ba\u0001\u0019\"\u001aa$a\u0011)\u000fy\t\t&!\u0018\u0002d2\u0012\u0011\u0011M\u0001>i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGJ+G/\u001a8uS>t')\u001f;fgZ\u000bG.\u001b3bi&|gnV5uQJ+Wn\u001c;f\u0007>\u0004\u0018\u0010R5tC\ndW\r\u001a\u000b\u00043\u0006%\bBBA ?\u0001\u0007A\nK\u0002 \u0003\u0007BsaHA)\u0003;\ny\u000f\f\u0002\u0002b\u00051C/Z:u\u000b:\f'\r\\3SK6|G/\u001a'pO>sW\t_5ti&tw\rV8qS\u000e$Vm\u001d;\u0015\u0007e\u000b)\u0010\u0003\u0004\u0002@\u0001\u0002\r\u0001\u0014\u0015\u0004A\u0005\r\u0003f\u0002\u0011\u0002R\u0005u\u00131 \u0017\u0003\u0003C\nA\u0007^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e<\u0006.\u001a8TsN$X-\u001c*f[>$Xm\u0015;pe\u0006<W-S:ESN\f'\r\\3e)\rI&\u0011\u0001\u0005\u0007\u0003\u007f\t\u0003\u0019\u0001')\u0007\u0005\n\u0019\u0005K\u0004\"\u0003#\niFa\u0002-\u0005\u0005\u0005\u0014a\f;fgR,\u0006\u000fZ1uKR{\u0007/[2D_:4\u0017nZ,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:$\u0016.\\3UKN$HcA-\u0003\u000e!1\u0011q\b\u0012A\u00021C3AIA\"Q\u001d\u0011\u0013\u0011KA/\u0005'a#!!\u0019\u0002_Q,7\u000f^+qI\u0006$X\rV8qS\u000e\u001cuN\u001c4jO^KG\u000f\u001b,bY&$'+\u001a;f]RLwN\\*ju\u0016$Vm\u001d;\u0015\u0007e\u0013I\u0002\u0003\u0004\u0002@\r\u0002\r\u0001\u0014\u0015\u0004G\u0005\r\u0003fB\u0012\u0002R\u0005u#q\u0004\u0017\u0003\u0003C\nA\u0007^3tiV\u0003H-\u0019;f)>\u0004\u0018nY\"p]\u001aLwmV5uQ&s\u0007.\u001a:ji\u0016$Gj\\2bYJ+G/\u001a8uS>tG+[7f)\rI&Q\u0005\u0005\u0007\u0003\u007f!\u0003\u0019\u0001')\u0007\u0011\n\u0019\u0005K\u0004%\u0003#\niFa\u000b-\u0005\u0005\u0005\u0014\u0001\u000e;fgR,\u0006\u000fZ1uKR{\u0007/[2D_:4\u0017nZ,ji\"Le\u000e[3sSR,G\rT8dC2\u0014V\r^3oi&|gnU5{KR\u0019\u0011L!\r\t\r\u0005}R\u00051\u0001MQ\r)\u00131\t\u0015\bK\u0005E\u0013Q\fB\u001cY\t\t\t'A\u0018uKN$X\u000b\u001d3bi\u0016$v\u000e]5d\u0007>tg-[4XSRDG)[:bE2Lgn\u001a*f[>$Xm\u0015;pe\u0006<W\rF\u0002Z\u0005{Aa!a\u0010'\u0001\u0004a\u0005f\u0001\u0014\u0002D!:a%!\u0015\u0002^\t\rCFAA1\u0003E!Xm\u001d;U_BL7\rR3mKRLwN\u001c\u000b\u00043\n%\u0003BBA O\u0001\u0007A\nK\u0002(\u0003\u0007BsaJA)\u0003;\u0012y\u0005\f\u0002\u0002b\u0005yD/Z:u\u00072,8\u000f^3s/&$W\rR5tC\ndW-\\3oi>3G+[3sK\u0012\u001cFo\u001c:bO\u0016<\u0016\u000e\u001e5F]\u0006\u0014G.\u001a3US\u0016\u0014X\r\u001a+pa&\u001cGcA-\u0003V!1\u0011q\b\u0015A\u00021C3\u0001KA\"Q\u001dA\u0013\u0011KA/\u00057b#!!\u0019\u0002\u0017R,7\u000f^\"mkN$XM],ji\"|W\u000f\u001e+jKJ,Gm\u0015;pe\u0006<Wm\u0015;beR\u001c8+^2dKN\u001ch-\u001e7ms&3Gk\u001c9jG^KG\u000f\u001b+jKJLgn\u001a#jg\u0006\u0014G.\u001a3\u0015\u0007e\u0013\t\u0007\u0003\u0004\u0002@%\u0002\r\u0001\u0014\u0015\u0004S\u0005\r\u0003fB\u0015\u0002R\u0005u#q\r\u0017\u0003\u0003C\nQ#Y:tKJ$H\u000b\u001b:poN,\u0005pY3qi&|g\u000e\u0006\u0005\u0003n\t}$1\u0014BV!\u0011\u0011yG!\u001f\u000f\t\tE$Q\u000f\b\u0004\u001f\nM\u0014\"\u0001#\n\u0007\t]4)A\u0004qC\u000e\\\u0017mZ3\n\t\tm$Q\u0010\u0002\n)\"\u0014xn^1cY\u0016T1Aa\u001eD\u0011\u001d\u0011\tI\u000ba\u0001\u0005\u0007\u000bQ\"\u001a=dKB$\u0018n\u001c8UsB,\u0007\u0007\u0002BC\u0005\u001f\u0003R!\u0014BD\u0005\u0017K1A!#W\u0005\u0015\u0019E.Y:t!\u0011\u0011iIa$\r\u0001\u0011a!\u0011\u0013B@\u0003\u0003\u0005\tQ!\u0001\u0003\u0014\n\u0019q\fJ\u0019\u0012\t\tU%Q\u000e\t\u0004\u0005\n]\u0015b\u0001BM\u0007\n9aj\u001c;iS:<\u0007b\u0002BOU\u0001\u0007!qT\u0001\u000bKb,7-\u001e;bE2,\u0007\u0003\u0002BQ\u0005Ok!Aa)\u000b\t\t\u0015\u0016qC\u0001\tMVt7\r^5p]&!!\u0011\u0016BR\u0005))\u00050Z2vi\u0006\u0014G.\u001a\u0005\t\u0005[S\u0003\u0013!a\u0001\u0019\u00069Q.Z:tC\u001e,\u0017aH1tg\u0016\u0014H\u000f\u00165s_^\u001cX\t_2faRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0017\u0016\u0004\u0019\nU6F\u0001B\\!\u0011\u0011ILa1\u000e\u0005\tm&\u0002\u0002B_\u0005\u007f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u00057)\u0001\u0006b]:|G/\u0019;j_:LAA!2\u0003<\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027Y,'/\u001b4z%\u0016lw\u000e^3M_\u001e$v\u000e]5d\u0007>tg-[4t)\rI&1\u001a\u0005\u0007\u0005\u001bd\u0003\u0019A?\u0002\u0017Q|\u0007/[2D_:4\u0017nZ\u0001\u000e_Z,'O]5eKB\u0013x\u000e]:\u0015\u0003uDs\u0001\u0001Bk\u0003\u000b\u0014Y\u000e\u0005\u0003\u0002\u0016\t]\u0017\u0002\u0002Bm\u0003/\u00111\u0001V1hC\t\u0011i.A\u0006j]R,wM]1uS>t\u0007")
public class RemoteTopicCrudTest
extends IntegrationTestHarness {
    private final int numPartitions;
    private final int numReplicationFactor;
    private String testTopicName;
    private boolean sysRemoteStorageEnabled = true;
    private String storageManagerClassName = NoOpRemoteStorageManager.class.getName();
    private String metadataManagerClassName = NoOpRemoteLogMetadataManager.class.getName();

    public int numPartitions() {
        return this.numPartitions;
    }

    public int numReplicationFactor() {
        return this.numReplicationFactor;
    }

    public String testTopicName() {
        return this.testTopicName;
    }

    public void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    public boolean sysRemoteStorageEnabled() {
        return this.sysRemoteStorageEnabled;
    }

    public void sysRemoteStorageEnabled_$eq(boolean x$1) {
        this.sysRemoteStorageEnabled = x$1;
    }

    public String storageManagerClassName() {
        return this.storageManagerClassName;
    }

    public void storageManagerClassName_$eq(String x$1) {
        this.storageManagerClassName = x$1;
    }

    public String metadataManagerClassName() {
        return this.metadataManagerClassName;
    }

    public void metadataManagerClassName_$eq(String x$1) {
        this.metadataManagerClassName = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overrideProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.overrideProps(), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        if (((Method)info.getTestMethod().get()).getName().endsWith("SystemRemoteStorageIsDisabled")) {
            this.sysRemoteStorageEnabled_$eq(false);
        }
        if (((Method)info.getTestMethod().get()).getName().equals("testTopicDeletion")) {
            this.storageManagerClassName_$eq(MyRemoteStorageManager.class.getName());
            this.metadataManagerClassName_$eq(MyRemoteLogMetadataManager.class.getName());
        }
        super.setUp(info);
        this.testTopicName_$eq(((Method)info.getTestMethod().get()).getName() + "-" + Random$.MODULE$.alphanumeric().take(10).mkString());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateRemoteTopicWithValidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateRemoteTopicWithValidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        topicConfig.put("local.retention.bytes", "256");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "1001");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "1025");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateCompactedRemoteStorage(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("cleanup.policy", "compact");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,true,true", "kraft,true,false", "kraft,false,true", "kraft,false,false"})
    public void testCreateRemoteTopicWithCopyDisabledAndDeleteOnDisable(String quorum, boolean copyDisabled, boolean deleteOnDisable) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.log.copy.disable", Boolean.toString(copyDisabled));
        topicConfig.put("remote.log.delete.on.disable", Boolean.toString(deleteOnDisable));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicRetentionMsValidationWithRemoteCopyDisabled(String quorum) {
        String testTopicName2 = this.testTopicName() + "2";
        String testTopicName3 = this.testTopicName() + "3";
        String errorMsgMs = "When `remote.log.copy.disable` is set to true, the `local.retention.ms` and `retention.ms` must be set to the identical value because there will be no more logs copied to the remote storage.";
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("remote.log.copy.disable", "true");
        topicConfig.put("local.retention.ms", "100");
        topicConfig.put("retention.ms", "1000");
        topicConfig.put("local.retention.bytes", "-2");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Throwable err = this.assertThrowsException(InvalidConfigurationException.class, () -> {
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
        Assertions.assertEquals((Object)errorMsgMs, (Object)err.getMessage());
        topicConfig.put("local.retention.ms", "1000");
        String x$10 = this.testTopicName();
        Buffer<KafkaBroker> x$11 = this.brokers();
        Seq<ControllerServer> x$12 = this.controllerServers();
        int x$13 = this.numPartitions();
        int x$14 = this.numReplicationFactor();
        Map x$16 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$10, x$11, x$12, x$13, x$14, (Map<Object, Seq<Object>>)x$16, topicConfig);
        topicConfig.put("local.retention.ms", "-2");
        Buffer<KafkaBroker> x$19 = this.brokers();
        Seq<ControllerServer> x$20 = this.controllerServers();
        int x$21 = this.numPartitions();
        int x$22 = this.numReplicationFactor();
        Map x$24 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName2, x$19, x$20, x$21, x$22, (Map<Object, Seq<Object>>)x$24, topicConfig);
        topicConfig.clear();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("local.retention.ms", "100");
        topicConfig.put("retention.ms", "1000");
        topicConfig.put("local.retention.bytes", "-2");
        Buffer<KafkaBroker> x$27 = this.brokers();
        Seq<ControllerServer> x$28 = this.controllerServers();
        int x$29 = this.numPartitions();
        int x$30 = this.numReplicationFactor();
        Map x$32 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName3, x$27, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$32, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        Throwable err2 = this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
        Assertions.assertEquals((Object)errorMsgMs, (Object)err2.getMessage());
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "1000"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicRetentionBytesValidationWithRemoteCopyDisabled(String quorum) {
        String testTopicName2 = this.testTopicName() + "2";
        String testTopicName3 = this.testTopicName() + "3";
        String errorMsgBytes = "When `remote.log.copy.disable` is set to true, the `local.retention.bytes` and `retention.bytes` must be set to the identical value because there will be no more logs copied to the remote storage.";
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("remote.log.copy.disable", "true");
        topicConfig.put("local.retention.bytes", "100");
        topicConfig.put("retention.bytes", "1000");
        topicConfig.put("local.retention.ms", "-2");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Throwable err = this.assertThrowsException(InvalidConfigurationException.class, () -> {
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
        Assertions.assertEquals((Object)errorMsgBytes, (Object)err.getMessage());
        topicConfig.put("local.retention.bytes", "1000");
        String x$10 = this.testTopicName();
        Buffer<KafkaBroker> x$11 = this.brokers();
        Seq<ControllerServer> x$12 = this.controllerServers();
        int x$13 = this.numPartitions();
        int x$14 = this.numReplicationFactor();
        Map x$16 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$10, x$11, x$12, x$13, x$14, (Map<Object, Seq<Object>>)x$16, topicConfig);
        topicConfig.put("local.retention.bytes", "-2");
        Buffer<KafkaBroker> x$19 = this.brokers();
        Seq<ControllerServer> x$20 = this.controllerServers();
        int x$21 = this.numPartitions();
        int x$22 = this.numReplicationFactor();
        Map x$24 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName2, x$19, x$20, x$21, x$22, (Map<Object, Seq<Object>>)x$24, topicConfig);
        topicConfig.clear();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("local.retention.bytes", "100");
        topicConfig.put("retention.bytes", "1000");
        topicConfig.put("local.retention.ms", "-2");
        Buffer<KafkaBroker> x$27 = this.brokers();
        Seq<ControllerServer> x$28 = this.controllerServers();
        int x$29 = this.numPartitions();
        int x$30 = this.numReplicationFactor();
        Map x$32 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName3, x$27, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$32, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        Throwable err2 = this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
        Assertions.assertEquals((Object)errorMsgBytes, (Object)err2.getMessage());
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "1000"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testEnableRemoteLogOnExistingTopicTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testEnableRemoteLogWhenSystemRemoteStorageIsDisabled(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfigWithRemoteStorage = new Properties();
        topicConfigWithRemoteStorage.put("remote.storage.enable", "true");
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfigWithRemoteStorage);
        }, "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
        TestUtils$.MODULE$.createTopicWithAdmin(admin, this.testTopicName(), this.brokers(), this.controllerServers(), this.numPartitions(), this.numReplicationFactor(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithValidRetentionTimeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithValidRetentionSizeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionTime(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionSize(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "512"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Invalid local retention size");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithDisablingRemoteStorage(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "false"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Disabling remote storage feature on the topic level is not supported.");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testTopicDeletion(String quorum) {
        MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().set(0);
        int numPartitions = 2;
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, numPartitions, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        TestUtils$.MODULE$.deleteTopicWithAdmin(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName(), this.brokers(), this.controllerServers());
        this.assertThrowsException(UnknownTopicOrPartitionException.class, () -> TestUtils$.MODULE$.describeTopic(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName()), "Topic should be deleted");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$testTopicDeletion$2(numPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Remote log segments should be deleted only once by the leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testClusterWideDisablementOfTieredStorageWithEnabledTieredTopic(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
        Assertions.assertTrue((boolean)(this.faultHandler().firstException().getCause() instanceof ConfigException));
        this.faultHandler().setIgnore(true);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testClusterWithoutTieredStorageStartsSuccessfullyIfTopicWithTieringDisabled(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", Boolean.toString(false));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
    }

    private Throwable assertThrowsException(Class<? extends Throwable> exceptionType, Executable executable, String message) {
        return Assertions.assertThrows(exceptionType, () -> {
            try {
                executable.execute();
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, (String)message);
    }

    private String assertThrowsException$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private void verifyRemoteLogTopicConfigs(Properties topicConfig) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$1(this, topicConfig)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$3(topicConfig));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties overrideProps() {
        Properties props = new Properties();
        props.put("remote.log.storage.system.enable", Boolean.toString(this.sysRemoteStorageEnabled()));
        props.put("remote.log.storage.manager.class.name", this.storageManagerClassName());
        props.put("remote.log.metadata.manager.class.name", this.metadataManagerClassName());
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2000");
        props.put("log.local.retention.ms", "1000");
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "2048");
        props.put("log.local.retention.bytes", "1024");
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$2(int numPartitions$1) {
        return numPartitions$1 * MyRemoteLogMetadataManager$.MODULE$.segmentCountPerPartition() == MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().get();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$3() {
        return "Remote log segments should be deleted only once by the leader";
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteLogTopicConfigs$1(RemoteTopicCrudTest $this, Properties topicConfig$6) {
        Buffer logBuffer = (Buffer)$this.brokers().flatMap((Function1 & Serializable)x$2 -> {
            LogManager qual$1 = x$2.logManager();
            TopicPartition x$1 = new TopicPartition($this.testTopicName(), 0);
            boolean x$22 = qual$1.getLog$default$2();
            return qual$1.getLog(x$1, x$22);
        });
        boolean result = logBuffer.nonEmpty();
        if (result) {
            if (topicConfig$6.containsKey("remote.storage.enable")) {
                boolean bl = result = result && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.storage.enable"))) == ((UnifiedLog)logBuffer.head()).config().remoteStorageEnable();
            }
            if (topicConfig$6.containsKey("local.retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("local.retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionBytes();
            }
            if (topicConfig$6.containsKey("local.retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("local.retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionMs();
            }
            if (topicConfig$6.containsKey("retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().retentionMs;
            }
            if (topicConfig$6.containsKey("retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().retentionSize;
            }
            if (topicConfig$6.contains("remote.log.copy.disable")) {
                boolean bl = result = result && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.log.copy.disable")))), (Object)((UnifiedLog)logBuffer.head()).config().remoteLogCopyDisable());
            }
            if (topicConfig$6.contains("remote.log.delete.on.disable")) {
                result = result && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.log.delete.on.disable")))), (Object)((UnifiedLog)logBuffer.head()).config().remoteLogDeleteOnDisable());
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$verifyRemoteLogTopicConfigs$3(Properties topicConfig$6) {
        return "Failed to update topic config " + topicConfig$6;
    }

    public RemoteTopicCrudTest() {
        this.numPartitions = 2;
        this.numReplicationFactor = 2;
    }
}

