/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.test.api.Flaky;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u001dc!\u0002\u0014(\u0003\u0003a\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u00024\u0001\t\u00039\u0007\"B7\u0001\t\u0003qwaBA\u0004O!\u0005\u0011\u0011\u0002\u0004\u0007M\u001dB\t!a\u0003\t\rE2A\u0011AA\n\u0011%\t)B\u0002b\u0001\n\u0003\t9\u0002\u0003\u0005\u00022\u0019\u0001\u000b\u0011BA\r\u0011%\t\u0019D\u0002b\u0001\n\u0003\t9\u0002\u0003\u0005\u00026\u0019\u0001\u000b\u0011BA\r\r\u0019\t9D\u0002\u0001\u0002:!1\u0011\u0007\u0004C\u0001\u0003OBq!!\u001c\r\t\u0003\ny\u0007C\u0004\u0002|1!\t%! \u0007\r\u0005\u001de\u0001AAE\u0011\u0019\t\u0004\u0003\"\u0001\u0002\u0012\"9\u0011Q\u000e\t\u0005B\u0005U\u0005bBAM!\u0011\u0005\u00131\u0014\u0004\u0007\u0003C3\u0001!a)\t\rE\"B\u0011AAS\u0011%\tI\u000b\u0006a\u0001\n\u0003\tY\u000bC\u0005\u00024R\u0001\r\u0011\"\u0001\u00026\"A\u00111\u0018\u000b!B\u0013\ti\u000bC\u0004\u0002|Q!\t%!0\t\u000f\u0005MG\u0003\"\u0011\u0002V\"9!Q\u0001\u000b\u0005B\t\u001d\u0001bBA>)\u0011\u0005#\u0011\u0002\u0004\u0007\u0005\u001f1\u0001A!\u0005\t\rEjB\u0011\u0001B\n\u0011%\u00119\"\ba\u0001\n\u0003\u0011I\u0002C\u0005\u0003\"u\u0001\r\u0011\"\u0001\u0003$!A!qE\u000f!B\u0013\u0011Y\u0002C\u0004\u0002\u001av!\tE!\u000b\t\u000f\u0005MW\u0004\"\u0011\u00032!9!QA\u000f\u0005B\t\u001d\u0001bBAM;\u0011\u0005#\u0011\t\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRT!\u0001K\u0015\u0002\u0007\u0005\u0004\u0018NC\u0001+\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0017\u0011\u00059zS\"A\u0014\n\u0005A:#\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011a\u0006A\u0001\u0016i\u0016\u001cHoU5na2,7i\u001c8tk6\u0004H/[8o)\r1D(\u0013\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000fC\u0003>\u0005\u0001\u0007a(\u0001\u0004rk>\u0014X/\u001c\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005CT\"\u0001\"\u000b\u0005\r[\u0013A\u0002\u001fs_>$h(\u0003\u0002Fq\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)\u0005\bC\u0003K\u0005\u0001\u0007a(A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0005\u00051C\u0016\f\u0005\u0002N-6\taJ\u0003\u0002P!\u00061\u0001/\u0019:b[NT!!\u0015*\u0002\u000f),\b/\u001b;fe*\u00111\u000bV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002+\u0006\u0019qN]4\n\u0005]s%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005Q\u0016AK>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{::'o\\;q!J|Go\\2pYvZ\u0018' \u0015\u0005\u0005q\u00137\r\u0005\u0002^A6\taL\u0003\u0002`\u001d\u0006A\u0001O]8wS\u0012,'/\u0003\u0002b=\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\nA-I\u0001f\u0003):W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f1\u0004^3ti\u000ecWo\u001d;feJ+7o\\;sG\u0016d\u0015n\u001d;f]\u0016\u0014Hc\u0001\u001ciS\")Qh\u0001a\u0001}!)!j\u0001a\u0001}!\"1\u0001\u0014-ZQ\u0011\u0019AL\u00197-\u0003\u0011\fq\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$bS2|g/\u001a:\u0015\u0007Yz\u0007\u000fC\u0003>\t\u0001\u0007a\bC\u0003K\t\u0001\u0007a\b\u000b\u0003\u0005e\nt\bCA:}\u001b\u0005!(B\u0001\u0015v\u0015\t1x/\u0001\u0003uKN$(B\u0001=z\u0003\u0019\u0019w.\\7p]*\u0011!F\u001f\u0006\u0003wR\u000ba!\u00199bG\",\u0017BA?u\u0005\u00151E.Y6zC\u0005y\u0018aC&B\r.\u000bU&M\u001b:eABC\u0001\u0002'Y3\"*A\u0001\u00182\u0002\u00061\nA-\u0001\tCCN,7i\u001c8tk6,'\u000fV3tiB\u0011aFB\n\u0004\r\u00055\u0001cA\u001c\u0002\u0010%\u0019\u0011\u0011\u0003\u001d\u0003\r\u0005s\u0017PU3g)\t\tI!A\nva\u0012\fG/\u001a)s_\u0012,8-\u001a:D_VtG/\u0006\u0002\u0002\u001aA!\u00111DA\u0017\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012AB1u_6L7M\u0003\u0003\u0002$\u0005\u0015\u0012AC2p]\u000e,(O]3oi*!\u0011qEA\u0015\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006LA!a\f\u0002\u001e\ti\u0011\t^8nS\u000eLe\u000e^3hKJ\fA#\u001e9eCR,\u0007K]8ek\u000e,'oQ8v]R\u0004\u0013aE;qI\u0006$XmQ8ogVlWM]\"pk:$\u0018\u0001F;qI\u0006$XmQ8ogVlWM]\"pk:$\bEA\u0013UKN$8\t\\;ti\u0016\u0014(+Z:pkJ\u001cW\rT5ti\u0016tWM]*fe&\fG.\u001b>feN9A\"a\u000f\u0002H\u0005}\u0003\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\t\u0005\u0005\u0013\u0011F\u0001\u0005Y\u0006tw-\u0003\u0003\u0002F\u0005}\"AB(cU\u0016\u001cG\u000f\u0005\u0004\u0002J\u0005=\u00131K\u0007\u0003\u0003\u0017R1!!\u0014x\u00035\u0019XM]5bY&T\u0018\r^5p]&!\u0011\u0011KA&\u0005)\u0019VM]5bY&TXM\u001d\t\u0006o\u0005U\u0013\u0011L\u0005\u0004\u0003/B$!B!se\u0006L\bcA\u001c\u0002\\%\u0019\u0011Q\f\u001d\u0003\t\tKH/\u001a\t\u0005\u0003C\n\u0019'D\u0001x\u0013\r\t)g\u001e\u0002\u0018\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dK2K7\u000f^3oKJ$\"!!\u001b\u0011\u0007\u0005-D\"D\u0001\u0007\u0003!yg.\u00169eCR,Gc\u0001\u001c\u0002r!9\u00111\u000f\bA\u0002\u0005U\u0014aD2mkN$XM\u001d*fg>,(oY3\u0011\t\u0005\u0005\u0014qO\u0005\u0004\u0003s:(aD\"mkN$XM\u001d*fg>,(oY3\u0002\u0013M,'/[1mSj,GCBA*\u0003\u007f\n\u0019\t\u0003\u0004\u0002\u0002>\u0001\rAP\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003\u000b{\u0001\u0019AA*\u0003\u0011!\u0017\r^1\u0003OQ+7\u000f^\"mkN$XM\u001d*fg>,(oY3MSN$XM\\3s\t\u0016\u001cXM]5bY&TXM]\n\b!\u0005m\u00121RA0!\u0019\tI%!$\u0002T%!\u0011qRA&\u00051!Um]3sS\u0006d\u0017N_3s)\t\t\u0019\nE\u0002\u0002lA!2ANAL\u0011\u001d\t\u0019H\u0005a\u0001\u0003k\n1\u0002Z3tKJL\u0017\r\\5{KR1\u00111KAO\u0003?Ca!!!\u0014\u0001\u0004q\u0004bBAC'\u0001\u0007\u00111\u000b\u0002\u000f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018*\u001c9m'\u0015!\u00121HA$)\t\t9\u000bE\u0002\u0002lQ\t!b]3sS\u0006d\u0017N_3s+\t\ti\u000b\u0005\u0003\u0002J\u0005=\u0016\u0002BAY\u0003\u0017\u00121CQ=uK\u0006\u0013(/Y=TKJL\u0017\r\\5{KJ\fab]3sS\u0006d\u0017N_3s?\u0012*\u0017\u000fF\u00027\u0003oC\u0011\"!/\u0018\u0003\u0003\u0005\r!!,\u0002\u0007a$\u0013'A\u0006tKJL\u0017\r\\5{KJ\u0004C\u0003CA*\u0003\u007f\u000b\t-!5\t\r\u0005\u0005\u0015\u00041\u0001?\u0011\u001d\t\u0019-\u0007a\u0001\u0003\u000b\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003\u0002H\u00065WBAAe\u0015\r\tYm^\u0001\u0007Q\u0016\fG-\u001a:\n\t\u0005=\u0017\u0011\u001a\u0002\b\u0011\u0016\fG-\u001a:t\u0011\u001d\t))\u0007a\u0001\u0003'\n\u0011bY8oM&<WO]3\u0015\u000bY\n9.a?\t\u000f\u0005e'\u00041\u0001\u0002\\\u000691m\u001c8gS\u001e\u001c\b\u0007BAo\u0003S\u0004r!a8\u0002bz\n)/\u0004\u0002\u0002&%!\u00111]A\u0013\u0005\ri\u0015\r\u001d\t\u0005\u0003O\fI\u000f\u0004\u0001\u0005\u0019\u0005-\u0018q[A\u0001\u0002\u0003\u0015\t!!<\u0003\u0007}#\u0013'\u0005\u0003\u0002p\u0006U\bcA\u001c\u0002r&\u0019\u00111\u001f\u001d\u0003\u000f9{G\u000f[5oOB\u0019q'a>\n\u0007\u0005e\bHA\u0002B]fDq!!@\u001b\u0001\u0004\ty0A\u0003jg.+\u0017\u0010E\u00028\u0005\u0003I1Aa\u00019\u0005\u001d\u0011un\u001c7fC:\fQa\u00197pg\u0016$\u0012A\u000e\u000b\u0007\u0003'\u0012YA!\u0004\t\r\u0005\u0005E\u00041\u0001?\u0011\u001d\t)\t\ba\u0001\u0003'\u0012\u0001\u0003R3tKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u000bu\tY$a#\u0015\u0005\tU\u0001cAA6;\u0005aA-Z:fe&\fG.\u001b>feV\u0011!1\u0004\t\u0005\u0003\u0013\u0012i\"\u0003\u0003\u0003 \u0005-#!\u0006\"zi\u0016\f%O]1z\t\u0016\u001cXM]5bY&TXM]\u0001\u0011I\u0016\u001cXM]5bY&TXM]0%KF$2A\u000eB\u0013\u0011%\tI\fIA\u0001\u0002\u0004\u0011Y\"A\u0007eKN,'/[1mSj,'\u000f\t\u000b\t\u0003'\u0012YC!\f\u00030!1\u0011\u0011\u0011\u0012A\u0002yBq!a1#\u0001\u0004\t)\rC\u0004\u0002\u0006\n\u0002\r!a\u0015\u0015\u000bY\u0012\u0019Da\u0010\t\u000f\u0005e7\u00051\u0001\u00036A\"!q\u0007B\u001e!\u001d\ty.!9?\u0005s\u0001B!a:\u0003<\u0011a!Q\bB\u001a\u0003\u0003\u0005\tQ!\u0001\u0002n\n\u0019q\f\n\u001a\t\u000f\u0005u8\u00051\u0001\u0002\u0000R1\u00111\u000bB\"\u0005\u000bBa!!!&\u0001\u0004q\u0004bBACK\u0001\u0007\u00111\u000b")
public abstract class BaseConsumerTest
extends AbstractConsumerTest {
    public static AtomicInteger updateConsumerCount() {
        return BaseConsumerTest$.MODULE$.updateConsumerCount();
    }

    public static AtomicInteger updateProducerCount() {
        return BaseConsumerTest$.MODULE$.updateProducerCount();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSimpleConsumption(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testClusterResourceListener(String quorum, String groupProtocol) {
        int numRecords = 100;
        Properties producerProps = new Properties();
        producerProps.put("key.serializer", TestClusterResourceListenerSerializer.class);
        producerProps.put("value.serializer", TestClusterResourceListenerSerializer.class);
        KafkaProducer producer = this.createProducer(null, null, producerProps);
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties consumerProps = new Properties();
        consumerProps.put("key.deserializer", TestClusterResourceListenerDeserializer.class);
        consumerProps.put("value.deserializer", TestClusterResourceListenerDeserializer.class);
        Consumer consumer = this.createConsumer(null, null, consumerProps, this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp().topic(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateProducerCount().get());
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateConsumerCount().get());
    }

    @Flaky(value="KAFKA-15920")
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCoordinatorFailover(String quorum, String groupProtocol) {
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("session.timeout.ms", "5001");
            this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        }
        this.consumerConfig().setProperty("max.poll.interval.ms", "15000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Buffer parts = null;
        while (parts == null) {
            parts = CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assertions.assertEquals((int)1, (int)parts.size());
        Assertions.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaBroker)this.brokers().apply(coordinator)).shutdown();
        this.ensureNoRebalance(consumer, listener);
    }

    public static class DeserializerImpl
    implements Deserializer<byte[]> {
        private ByteArrayDeserializer deserializer = new ByteArrayDeserializer();

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public ByteArrayDeserializer deserializer() {
            return this.deserializer;
        }

        public void deserializer_$eq(ByteArrayDeserializer x$1) {
            this.deserializer = x$1;
        }

        public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public void close() {
            this.deserializer().close();
        }

        public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }
    }

    public static class SerializerImpl
    implements Serializer<byte[]> {
        private ByteArraySerializer serializer = new ByteArraySerializer();

        public ByteArraySerializer serializer() {
            return this.serializer;
        }

        public void serializer_$eq(ByteArraySerializer x$1) {
            this.serializer = x$1;
        }

        public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public void close() {
            this.serializer().close();
        }

        public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }
    }

    public static class TestClusterResourceListenerDeserializer
    implements Deserializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public Object deserialize(String x$1, Headers x$2, byte[] x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateConsumerCount().incrementAndGet();
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }
    }

    public static class TestClusterResourceListenerSerializer
    implements Serializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public byte[] serialize(String x$1, Headers x$2, Object x$3) {
            return super.serialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateProducerCount().incrementAndGet();
        }

        public byte[] serialize(String topic, byte[] data) {
            return data;
        }
    }
}

