/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.FixedPortTestUtils$;
import kafka.log.UnifiedLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.util.ShutdownableThread;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r5c\u0001B\u00193\u0001]BQA\u0011\u0001\u0005\u0002\rCq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004N\u0001\u0001\u0006Ia\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u00191\u0006\u0001)A\u0005!\"9q\u000b\u0001b\u0001\n\u0003A\u0006BB2\u0001A\u0003%\u0011\fC\u0004e\u0001\t\u0007I\u0011A3\t\rI\u0004\u0001\u0015!\u0003g\u0011\u0015\u0019\b\u0001\"\u0011u\u0011!y\bA1A\u0005\u0002\u0005\u0005\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0001\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011q\n\u0001\u0005\n\u0005E\u0003\"CA+\u0001E\u0005I\u0011BA,\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!a \u0001\t\u0003\t\t\tC\u0004\u00026\u0002!\t!a.\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\ti\u000f\u0001C\u0005\u0003_Dq!!?\u0001\t\u0013\tY\u0010C\u0004\u0003\b\u0001!IA!\u0003\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B\u001b\u0001\u0011\u0005!q\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'BqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003\u001c\u0002!IA!(\t\u0013\t\u001d\u0006!%A\u0005\n\t%\u0006b\u0002BW\u0001\u0011%!q\u0016\u0005\b\u0005#\u0004A\u0011\u0002Bj\r\u0019\u0011Y\u000e\u0001\u0003\u0003^\"I\u00111\u0018\u0013\u0003\u0006\u0004%\tA\u0012\u0005\n\u0005W$#\u0011!Q\u0001\n\u001dCaA\u0011\u0013\u0005\u0002\t5\b\u0002\u0003BzI\u0001\u0007I\u0011\u0002$\t\u0013\tUH\u00051A\u0005\n\t]\bb\u0002B\u007fI\u0001\u0006Ka\u0012\u0005\b\u0005\u007f$C\u0011IA8\u0011\u001d\u0019\t\u0001\u0001C\u0005\u0007\u0007A\u0011b!\n\u0001#\u0003%Iaa\n\t\u000f\r-\u0002\u0001\"\u0003\u0004.!I1Q\t\u0001\u0012\u0002\u0013%\u0011q\u000b\u0005\n\u0007\u000f\u0002\u0011\u0013!C\u0005\u0007\u0013\u0012!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0007N\u0001\u0004CBL'\"A\u001b\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u000f\u001f\u0011\u0005eRT\"\u0001\u001a\n\u0005m\u0012$\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH\u000f\u0005\u0002>\u00016\taH\u0003\u0002@i\u0005)Q\u000f^5mg&\u0011\u0011I\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA\t\u0005\u0002:\u0001\u0005aQ.\u0019=He>,\boU5{KV\tq\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0002J]R\fQ\"\\1y\u000fJ|W\u000f]*ju\u0016\u0004\u0013aE4sC\u000e,g-\u001e7DY>\u001cX\rV5nK6\u001bX#\u0001)\u0011\u0007!\u000b6+\u0003\u0002S\u0013\n!1k\\7f!\tAE+\u0003\u0002V\u0013\n!Aj\u001c8h\u0003Q9'/Y2fMVd7\t\\8tKRKW.Z'tA\u0005AQ\r_3dkR|'/F\u0001Z!\tQ\u0016-D\u0001\\\u0015\taV,\u0001\u0006d_:\u001cWO\u001d:f]RT!AX0\u0002\tU$\u0018\u000e\u001c\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u00117L\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\u001f\r|gn];nKJ\u0004v\u000e\u001c7feN,\u0012A\u001a\t\u0004O2tW\"\u00015\u000b\u0005%T\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003W&\u000b!bY8mY\u0016\u001cG/[8o\u0013\ti\u0007N\u0001\u0004Ck\u001a4WM\u001d\t\u0003_Bl\u0011\u0001A\u0005\u0003cj\u0012\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s\u0003A\u0019wN\\:v[\u0016\u0014\bk\u001c7mKJ\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005)\bc\u0001<xs6\t!.\u0003\u0002yU\n\u00191+Z9\u0011\u0005ilX\"A>\u000b\u0005q$\u0014AB:feZ,'/\u0003\u0002\u007fw\nY1*\u00194lC\u000e{gNZ5h\u0003-!Xm\u001d;D_:4\u0017nZ:\u0016\u0005\u0005\r\u0001\u0003CA\u0003\u0003\u0017\ty!a\u0004\u000e\u0005\u0005\u001d!bAA\u0005U\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u001b\t9AA\u0002NCB\u0004B!!\u0005\u0002 9!\u00111CA\u000e!\r\t)\"S\u0007\u0003\u0003/Q1!!\u00077\u0003\u0019a$o\\8u}%\u0019\u0011QD%\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\"S\u0001\ri\u0016\u001cHoQ8oM&<7\u000fI\u0001\u0017WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hgR!\u00111FA\u001b!\u00111x/!\f\u0011\t\u0005=\u0012\u0011G\u0007\u0002;&\u0019\u00111G/\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u000285\u0001\r!!\u000f\u0002\u0011Q,7\u000f^%oM>\u0004B!a\u000f\u0002L5\u0011\u0011Q\b\u0006\u0004g\u0005}\"\u0002BA!\u0003\u0007\nqA[;qSR,'O\u0003\u0003\u0002F\u0005\u001d\u0013!\u00026v]&$(BAA%\u0003\ry'oZ\u0005\u0005\u0003\u001b\niD\u0001\u0005UKN$\u0018J\u001c4p\u0003Q9WM\\3sCR,7*\u00194lC\u000e{gNZ5hgR\u0019Q/a\u0015\t\u0011\u0015s\u0001\u0013!a\u0001\u0003\u001f\tadZ3oKJ\fG/Z&bM.\f7i\u001c8gS\u001e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e#\u0006BA\b\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003OJ\u0015AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\ti\u0016\f'\u000fR8x]R\u0011\u0011\u0011\u000f\t\u0004\u0011\u0006M\u0014bAA;\u0013\n!QK\\5uQ\r\u0001\u0012\u0011\u0010\t\u0005\u0003w\tY(\u0003\u0003\u0002~\u0005u\"!C!gi\u0016\u0014X)Y2i\u0003\u0005\"Xm\u001d;D_:\u001cX/\u001c9uS>tw+\u001b;i\u0005J|7.\u001a:GC&dWO]3t)\u0019\t\t(a!\u0002\b\"9\u0011QQ\tA\u0002\u0005=\u0011AB9v_J,X\u000eC\u0004\u0002\nF\u0001\r!a\u0004\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8mQ\u001d\t\u0012QRAM\u00037\u0003B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000by$\u0001\u0004qCJ\fWn]\u0005\u0005\u0003/\u000b\tJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011QT\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u001d\t\u0012\u0011UAW\u0003_\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000b\t*\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\tY+!*\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005E\u0016EAAZ\u0003):W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f\u0011dY8ogVlWmV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fgR!\u0011\u0011OA]\u0011\u0019\tYL\u0005a\u0001\u000f\u0006Aa.^7Ji\u0016\u00148/A\u0012uKN$8+Z3l\u0003:$7i\\7nSR<\u0016\u000e\u001e5Ce>\\WM\u001d$bS2,(/Z:\u0015\r\u0005E\u0014\u0011YAb\u0011\u001d\t)i\u0005a\u0001\u0003\u001fAq!!#\u0014\u0001\u0004\ty\u0001K\u0004\u0014\u0003\u001b\u000bI*a')\u000fM\t\t+!,\u0002J2\u0012\u0011\u0011W\u0001 g\u0016,7.\u00118e\u0007>lW.\u001b;XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cH\u0003BA9\u0003\u001fDa!a/\u0015\u0001\u00049\u0015!\t;fgR\u001cVOY:de&\u0014Wm\u00165f]R{\u0007/[2V]\u00064\u0018-\u001b7bE2,GCBA9\u0003+\f9\u000eC\u0004\u0002\u0006V\u0001\r!a\u0004\t\u000f\u0005%U\u00031\u0001\u0002\u0010!:Q#!$\u0002\u001a\u0006m\u0005fB\u000b\u0002\"\u00065\u0016Q\u001c\u0017\u0003\u0003c\u000b\u0011\u0002^3ti\u000ecwn]3\u0015\r\u0005E\u00141]As\u0011\u001d\t)I\u0006a\u0001\u0003\u001fAq!!#\u0017\u0001\u0004\ty\u0001K\u0004\u0017\u0003\u001b\u000bI*a')\u000fY\t\t+!,\u0002l2\u0012\u0011\u0011W\u0001\u0013G\",7m[\"m_N,wi\\8e!\u0006$\b\u000e\u0006\u0004\u0002r\u0005E\u0018Q\u001f\u0005\u0007\u0003g<\u0002\u0019A$\u0002\u00159,XNU3d_J$7\u000fC\u0004\u0002x^\u0001\r!a\u0004\u0002\u000f\u001d\u0014x.\u001e9JI\u0006\u00013\r[3dW\u000ecwn]3XSRD7i\\8sI&t\u0017\r^8s\r\u0006LG.\u001e:f)!\t\t(!@\u0002\u0000\n\r\u0001BBAz1\u0001\u0007q\tC\u0004\u0003\u0002a\u0001\r!a\u0004\u0002\u0019\u0011Lh.Y7jG\u001e\u0013x.\u001e9\t\u000f\t\u0015\u0001\u00041\u0001\u0002\u0010\u0005YQ.\u00198vC2<%o\\;q\u0003=1\u0017N\u001c3D_>\u0014H-\u001b8bi>\u0014HcA$\u0003\f!9!QB\rA\u0002\u0005=\u0011!B4s_V\u0004\u0018\u0001H2iK\u000e\\7\t\\8tK^KG\u000f[\"mkN$XM\u001d$bS2,(/\u001a\u000b\u000b\u0003c\u0012\u0019B!\u0006\u0003\u001a\tu\u0001BBAz5\u0001\u0007q\tC\u0004\u0003\u0018i\u0001\r!a\u0004\u0002\r\u001d\u0014x.\u001e92\u0011\u001d\u0011YB\u0007a\u0001\u0003\u001f\taa\u001a:pkB\u0014\u0004bBAE5\u0001\u0007\u0011qB\u0001Gi\u0016\u001cHOU8mY&twM\u0011:pW\u0016\u0014(+Z:uCJ$8oV5uQNk\u0017\r\u001c7fe6\u000b\u0007p\u0012:pkB\u001c\u0016N_3D_:4\u0017n\u001a#jgJ,\b\u000f^:CS\u001e<%o\\;q)\u0019\t\tHa\t\u0003&!9\u0011QQ\u000eA\u0002\u0005=\u0001bBAE7\u0001\u0007\u0011q\u0002\u0015\b7\u00055\u0015\u0011TANQ\u001dY\u0012\u0011UAW\u0005Wa#!!-)\u0007m\u0011y\u0003\u0005\u0003\u0002<\tE\u0012\u0002\u0002B\u001a\u0003{\u0011\u0001\u0002R5tC\ndW\rZ\u00019i\u0016\u001cHoQ8ogVlWM\u001d*fG\u0016Lg/Z:GCR\fG.\u0012=dKB$\u0018n\u001c8XQ\u0016twI]8vaB\u000b7o]3t\u001b\u0006D8+\u001b>f)\u0019\t\tH!\u000f\u0003<!9\u0011Q\u0011\u000fA\u0002\u0005=\u0001bBAE9\u0001\u0007\u0011q\u0002\u0015\b9\u00055\u0015\u0011TANQ\u001da\u0012\u0011UAW\u0005\u0003b#!!-\u00021Q,7\u000f^\"m_N,G)\u001e:j]\u001e\u0014VMY1mC:\u001cW\r\u0006\u0004\u0002r\t\u001d#\u0011\n\u0005\b\u0003\u000bk\u0002\u0019AA\b\u0011\u001d\tI)\ba\u0001\u0003\u001fAs!HAG\u00033\u000bY\nK\u0004\u001e\u0003C\u000biKa\u0014-\u0005\u0005E\u0016!G2iK\u000e\\7\t\\8tK\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$\"\"!\u001d\u0003V\t]#1\fB2\u0011\u001d\t9P\ba\u0001\u0003\u001fAqA!\u0017\u001f\u0001\u0004\ty!A\u0003u_BL7\r\u0003\u0004X=\u0001\u0007!Q\f\t\u00045\n}\u0013b\u0001B17\nyQ\t_3dkR|'oU3sm&\u001cW\rC\u0004\u0003fy\u0001\rAa\u001a\u00027\t\u0014xn[3sg\u00063\u0018-\u001b7bE2,G)\u001e:j]\u001e\u001cEn\\:f!\rA%\u0011N\u0005\u0004\u0005WJ%a\u0002\"p_2,\u0017M\\\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3s\u0003:$'+Z2fSZ,G\u0003\u0003B9\u0005'\u0013)J!'\u0011\u0011\tM$1\u0011BD\u0005\u000fk!A!\u001e\u000b\t\t]$\u0011P\u0001\tG>t7/^7fe*!!1\u0010B?\u0003\u001d\u0019G.[3oiNT1!\u000eB@\u0015\u0011\u0011\t)a\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011)I!\u001e\u0003\u0011\r{gn];nKJ\u0004R\u0001\u0013BE\u0005\u001bK1Aa#J\u0005\u0015\t%O]1z!\rA%qR\u0005\u0004\u0005#K%\u0001\u0002\"zi\u0016Dq!a> \u0001\u0004\ty\u0001C\u0004\u0003\u0018~\u0001\rAa\u001a\u0002\u00195\fg.^1m\u0003N\u001c\u0018n\u001a8\t\r\u0005Mx\u00041\u0001H\u0003M\u0011XmY3jm\u0016,\u00050Y2u%\u0016\u001cwN\u001d3t)!\t\tHa(\u0003\"\n\r\u0006B\u0002B<A\u0001\u0007a\u000e\u0003\u0004\u0002t\u0002\u0002\ra\u0012\u0005\t\u0005K\u0003\u0003\u0013!a\u0001'\u0006IA/[7f_V$Xj]\u0001\u001ee\u0016\u001cW-\u001b<f\u000bb\f7\r\u001e*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0016\u0016\u0004'\u0006m\u0013AF:vE6LGo\u00117pg\u0016\fe\u000e\u001a,bY&$\u0017\r^3\u0015\u0015\tE&Q\u0018B`\u0005\u0007\u0014i\rE\u0003[\u0005g\u00139,C\u0002\u00036n\u0013aAR;ukJ,\u0007c\u0001%\u0003:&\u0019!1X%\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003x\t\u0002\rA!\u001d\t\r\t\u0005'\u00051\u0001T\u00039\u0019Gn\\:f)&lWm\\;u\u001bNDqA!2#\u0001\u0004\u00119-\u0001\bnS:\u001cEn\\:f)&lW-T:\u0011\t!\u0013ImU\u0005\u0004\u0005\u0017L%AB(qi&|g\u000eC\u0004\u0003P\n\u0002\rAa2\u0002\u001d5\f\u0007p\u00117pg\u0016$\u0016.\\3Ng\u0006\u00012\r[3dW\u000ecwn]3e'R\fG/\u001a\u000b\u0007\u0003c\u0012)Na6\t\u000f\u0005]8\u00051\u0001\u0002\u0010!1!\u0011\\\u0012A\u0002\u001d\u000b\u0001cY8n[&$H/\u001a3SK\u000e|'\u000fZ:\u0003+\t{WO\\2f\u0005J|7.\u001a:TG\",G-\u001e7feN\u0019AEa8\u0011\t\t\u0005(q]\u0007\u0003\u0005GT1A\u0018Bs\u0015\ra(QP\u0005\u0005\u0005S\u0014\u0019O\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017!\u00038v[&#XM]:!)\u0011\u0011yO!=\u0011\u0005=$\u0003BBA^O\u0001\u0007q)\u0001\u0003ji\u0016\u0014\u0018\u0001C5uKJ|F%Z9\u0015\t\u0005E$\u0011 \u0005\t\u0005wL\u0013\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\u0002\u000b%$XM\u001d\u0011\u0002\r\u0011|wk\u001c:l\u0003U\u0019'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N$\"b!\u0002\u0004\u0018\re1QDB\u0011!\u0019\t\tba\u0002\u0004\f%!1\u0011BA\u0012\u0005\r\u0019V\r\u001e\t\u0005\u0007\u001b\u0019\u0019\"\u0004\u0002\u0004\u0010)!1\u0011\u0003B?\u0003\u0019\u0019w.\\7p]&!1QCB\b\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!\u0017-\u0001\u0004\ty\u0001\u0003\u0004\u0004\u001c1\u0002\raR\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\r}A\u00061\u0001H\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\n\u0007Ga\u0003\u0013!a\u0001\u0003[\t1\u0002^8qS\u000e\u001cuN\u001c4jO\u0006y2M]3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r%\"\u0006BA\u0017\u00037\nA\u0002\u001d:pIV\u001cWM]*f]\u0012$\"\"!\u001d\u00040\ru2qHB!\u0011\u001d\u0019\tD\fa\u0001\u0007g\t\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0007k\u0019IDa\"\u0003\b6\u00111q\u0007\u0006\u0005\u0007c\u0011I(\u0003\u0003\u0004<\r]\"!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0003\u0004\u0002t:\u0002\ra\u0012\u0005\n\u00053r\u0003\u0013!a\u0001\u0003\u001fA\u0011ba\u0007/!\u0003\u0005\raa\u0011\u0011\t!\u0013ImR\u0001\u0017aJ|G-^2feN+g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u00051\u0002O]8ek\u000e,'oU3oI\u0012\"WMZ1vYR$C'\u0006\u0002\u0004L)\"11IA.\u0001")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Map<String, String> testConfigs;

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    public Map<String, String> testConfigs() {
        return this.testConfigs;
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return (Seq)super.kraftControllerConfigs(testInfo).map((Function1 & Serializable)props -> {
            this.testConfigs().foreachEntry((Function2 & Serializable)(k, v) -> props.setProperty((String)k, (String)v));
            return props;
        });
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        this.testConfigs().foreachEntry((Function2 & Serializable)(k, v) -> properties.setProperty((String)k, (String)v));
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), false, false).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties));
    }

    private String generateKafkaConfigs$default$1() {
        return Integer.toString(this.maxGroupSize());
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1 & Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdownNow();
            Assertions.assertTrue((boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS), (String)"Executor did not terminate");
        }
        finally {
            super.tearDown();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumptionWithBrokerFailures(String quorum, String groupProtocol) {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        LongRef consumed = LongRef.create((long)0L);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        try {
            scheduler.start();
            while (scheduler.isRunning()) {
                Iterable records = CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)consumer.poll(Duration.ofMillis(100L))).asScala();
                records.foreach((Function1 & Serializable)record -> {
                    ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                    return BoxedUnit.UNIT;
                });
                if (!records.nonEmpty()) continue;
                consumer.commitSync();
                Assertions.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
                if (consumer.position(this.tp()) != (long)numRecords) continue;
                consumer.seekToBeginning(Collections.emptyList());
                consumed.elem = 0L;
            }
        }
        finally {
            scheduler.shutdown();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSeekAndCommitWithBrokerFailures(String quorum, String groupProtocol) {
        this.seekAndCommitWithBrokerFailures(5);
    }

    /*
     * WARNING - void declaration
     */
    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$1(this, numRecords)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to update high watermark for followers after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        try {
            scheduler.start();
            while (scheduler.isRunning()) {
                int coin = TestUtils$.MODULE$.random().nextInt(3);
                if (coin == 0) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Seeking to end of log");
                    consumer.seekToEnd(Collections.emptyList());
                    Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                    continue;
                }
                if (coin == 1) {
                    long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Seeking to " + pos);
                    consumer.seek(this.tp(), pos);
                    Assertions.assertEquals((long)pos, (long)consumer.position(this.tp()));
                    continue;
                }
                if (coin != 2) continue;
                this.info((Function0<String>)(Function0 & Serializable)() -> "Committing offset.");
                consumer.commitSync();
                Assertions.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
            }
        }
        finally {
            scheduler.shutdown();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubscribeWhenTopicUnavailable(String quorum, String groupProtocol) {
        int numRecords = 1000;
        String newtopic = "newtopic";
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4(), this.$outer.createTopic$default$5(), this.$outer.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.brokerServers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testClose(String quorum, String groupProtocol) {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5", groupProtocol);
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        Consumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        Consumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        Consumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    /*
     * WARNING - void declaration
     */
    private int findCoordinator(String group) {
        int n;
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setCoordinatorKeys(Collections.singletonList(group))).build();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            FindCoordinatorResponse $anonfun$findCoordinator$1_response = (FindCoordinatorResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class));
            n = $anonfun$findCoordinator$1_response.node().id();
            Errors errors = $anonfun$findCoordinator$1_response.error();
            Errors errors2 = Errors.NONE;
            boolean bl = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            Object var9_6 = null;
            errors2 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$findCoordinator$2(group));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return n;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2, String groupProtocol) {
        Consumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("session.timeout.ms", "5000");
            this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        }
        this.consumerConfig().setProperty("request.timeout.ms", Integer.toString(requestTimeout));
        Consumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.brokerServers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Disabled
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup(String quorum, String groupProtocol) {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        }
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), new Properties());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<Consumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(Integer.toString(maxGroupSize));
        this.brokerServers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)serverIdx -> {
            this.killBroker(serverIdx);
            KafkaConfig config = (KafkaConfig)newConfigs.apply(serverIdx);
            this.servers().update(serverIdx, (Object)this.createBroker(config, this.brokerTime(config.brokerId()), this.createBroker$default$3(), this.createBroker$default$4()));
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The remaining consumers in the group could not fetch the expected records");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)this.raisedExceptions$1().size());
        Assertions.assertTrue((boolean)(this.raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize(String quorum, String groupProtocol) {
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        }
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), new Properties());
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            void var8_8;
            this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<Consumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
            Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<Consumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Buffer rejectedConsumerPollers = (Buffer)tuple2._2();
            AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)var8_8.head());
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(rejectedConsumer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Extra consumer did not throw an exception");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
            this.producerSend(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitions.size())));
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 10000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!consumerPollers.forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(p)))) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"The consumers in the group could not fetch the expected records");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCloseDuringRebalance(String quorum, String groupProtocol) {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        }
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        Consumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, (Option)None$.MODULE$, executor, topic), (scala.collection.immutable.Seq)Nil$.MODULE$);
        Consumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, (Option)None$.MODULE$, executor, topic), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Consumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Consumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.brokerServers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private Consumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        Consumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = manualAssign ? this.subscribeConsumerAndStartPolling(consumer, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})))) : this.subscribeConsumerAndStartPolling(consumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        this.consumerPollers().$plus$eq((Object)consumerPoller);
        this.receiveExactRecords(consumerPoller, numRecords, 60000L);
        consumerPoller.shutdown();
        return consumer;
    }

    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$receiveExactRecords$1(consumer, numRecords)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeoutMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$receiveExactRecords$2(numRecords, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeoutMs), waitUntilTrue_pause));
        }
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(Consumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(() -> {
            int closeGraceTimeMs = 2000;
            long startMs = System.currentTimeMillis();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing consumer with timeout " + closeTimeoutMs + " ms.");
            consumer.close(Duration.ofMillis(closeTimeoutMs));
            long timeTakenMs = System.currentTimeMillis() - startMs;
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)ms -> Assertions.assertTrue((timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0, (String)("Close took too long " + timeTakenMs)));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)ms -> Assertions.assertTrue((timeTakenMs >= ms ? 1 : 0) != 0, (String)("Close finished too quickly " + timeTakenMs)));
            this.info((Function0<String>)(Function0 & Serializable)() -> "consumer.close() completed in " + timeTakenMs + " ms.");
        }, BoxesRunTime.boxToInteger((int)0));
    }

    /*
     * WARNING - void declaration
     */
    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        Consumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$checkClosedState$1(consumer, assignSemaphore)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Assignment did not complete on time");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (committedRecords > 0) {
            Assertions.assertEquals((long)committedRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
        consumer.close();
    }

    private scala.collection.immutable.Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        return package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable)part -> ConsumerBounceTest.$anonfun$createTopicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)part))).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    private void producerSend(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> ConsumerBounceTest.$anonfun$producerSend$1(this, producer, topic, numPartitions, partitionIndex, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$5 -> (RecordMetadata)x$5.get());
    }

    private String producerSend$default$3() {
        return this.topic();
    }

    private Option<Object> producerSend$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assertions.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, BrokerServer server) {
        return ((UnifiedLog)server.replicaManager().localLog($this.tp()).get()).highWatermark() == (long)numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$1(ConsumerBounceTest $this, int numRecords$1) {
        return $this.brokerServers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2($this, numRecords$1, server)));
    }

    public static final /* synthetic */ String $anonfun$seekAndCommitWithBrokerFailures$3() {
        return "Failed to update high watermark for followers after timeout";
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable)i -> producer$1.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes()))).map((Function1 & Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            });
        }
        Assertions.assertEquals((int)0, (int)remainingRecords.elem);
    }

    public static final /* synthetic */ boolean $anonfun$findCoordinator$1(ConsumerBounceTest $this, FindCoordinatorRequest request$1, IntRef nodeId$1) {
        FindCoordinatorResponse response = (FindCoordinatorResponse)$this.connectAndReceive((AbstractRequest)request$1, $this.connectAndReceive$default$2(), $this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class));
        nodeId$1.elem = response.node().id();
        Errors errors = response.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ String $anonfun$findCoordinator$2(String group$1) {
        return "Failed to find coordinator for group " + group$1;
    }

    private final Seq raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1 & Serializable)x$3 -> x$3.thrownException());
    }

    public static final /* synthetic */ boolean $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(ConsumerBounceTest $this) {
        return $this.raisedExceptions$1().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4() {
        return "The remaining consumers in the group could not fetch the expected records";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer$1) {
        return rejectedConsumer$1.thrownException().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2() {
        return "Extra consumer did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(AbstractConsumerTest.ConsumerAssignmentPoller p) {
        return p.receivedMessages() >= 100;
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5() {
        return "The consumers in the group could not fetch the expected records";
    }

    private static final Future subscribeAndPoll$1(Consumer consumer, Option revokeSemaphore, ExecutorService executor$1, String topic$2) {
        return executor$1.submit(() -> {
            consumer.subscribe(Collections.singletonList(topic$2));
            revokeSemaphore.foreach((Function1 & Serializable)s -> {
                s.release();
                return BoxedUnit.UNIT;
            });
            consumer.poll(Duration.ofMillis(500L));
        }, BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, scala.collection.immutable.Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable)consumer -> consumer.poll(Duration.ofMillis(100L)));
        }
        Assertions.assertTrue((boolean)future.isDone(), (String)"Rebalance did not complete in time");
    }

    private final Future createConsumerToRebalance$1(String groupId$1, ExecutorService executor$1, String topic$2) {
        Consumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$1, topic$2);
        Assertions.assertTrue((boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS), (String)"Rebalance not triggered");
        Assertions.assertFalse((boolean)future.isDone(), (String)"Rebalance completed too early");
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$receiveExactRecords$1(AbstractConsumerTest.ConsumerAssignmentPoller consumer$2, int numRecords$2) {
        return consumer$2.receivedMessages() == numRecords$2;
    }

    public static final /* synthetic */ String $anonfun$receiveExactRecords$2(int numRecords$2, AbstractConsumerTest.ConsumerAssignmentPoller consumer$2) {
        return "Consumer did not receive expected " + numRecords$2 + ". It received " + consumer$2.receivedMessages();
    }

    public static final /* synthetic */ boolean $anonfun$checkClosedState$1(Consumer consumer$4, Semaphore assignSemaphore$1) {
        consumer$4.poll(Duration.ofMillis(100L));
        return assignSemaphore$1.tryAcquire();
    }

    public static final /* synthetic */ String $anonfun$checkClosedState$2() {
        return "Assignment did not complete on time";
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        if (numPartitions$1 instanceof Some) {
            int partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            return nextPart;
        }
        if (None$.MODULE$.equals(numPartitions$1)) {
            return this.part();
        }
        throw new MatchError((Object)numPartitions$1);
    }

    public static final /* synthetic */ Future $anonfun$producerSend$1(ConsumerBounceTest $this, KafkaProducer producer$2, String topic$4, Option numPartitions$1, IntRef partitionIndex$1, int i) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int getPartition$1_partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int getPartition$1_nextPart = partitionIndex$1.elem % getPartition$1_partitions;
            ++partitionIndex$1.elem;
            n = getPartition$1_nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = $this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return producer$2.send(new ProducerRecord(topic$4, Predef$.MODULE$.int2Integer(n), (Object)Integer.toString(i).getBytes(), (Object)Integer.toString(i).getBytes()));
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.testConfigs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets.topic.replication.factor"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets.topic.num.partitions"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.min.session.timeout.ms"), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.initial.rebalance.delay.ms"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.consumer.max.size"), (Object)Integer.toString(this.maxGroupSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.max.size"), (Object)Integer.toString(this.maxGroupSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.create.topics.enable"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.interval.ms"), (Object)"50"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker.heartbeat.interval.ms"), (Object)"50"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker.session.timeout.ms"), (Object)"300")}));
    }

    private class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        private int iter() {
            return this.iter;
        }

        private void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers(this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers$default$1());
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
                return;
            }
            Thread.sleep(500L);
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

