/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005\u0002qAQ!\u0014\u0001\u0005\u00029CQ\u0001\u0016\u0001\u0005\u0002UCQa\u0017\u0001\u0005\u0002qCQA\u0019\u0001\u0005\u0002\rDQ!\u001b\u0001\u0005\n)DQ\u0001\u001d\u0001\u0005\u0002EDQa\u001e\u0001\u0005\naDQa\u001f\u0001\u0005\u0002qDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\u00035Ac\u0017-\u001b8uKb$8i\u001c8tk6,'OR3uG\"$Vm\u001d;\u000b\u0005=\u0001\u0012aA1qS*\t\u0011#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005q\u0011BA\f\u000f\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\u0007\t\u0003+\u0001\ta\u0003^3ti\u001a+Go\u00195J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u000b\u0004;\r\u0002\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001\n\u0002A\u0002\u0015\na!];peVl\u0007C\u0001\u0014.\u001d\t93\u0006\u0005\u0002)?5\t\u0011F\u0003\u0002+%\u00051AH]8pizJ!\u0001L\u0010\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y}AQ!\r\u0002A\u0002\u0015\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0006\u0002\u00024\u007f\u0001\u0003\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\rA\f'/Y7t\u0015\tA\u0014(A\u0004kkBLG/\u001a:\u000b\u0005iZ\u0014!\u00026v]&$(\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u0003\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\b\u0006\u0002\u0002D\u0013*\u0003\"\u0001R$\u000e\u0003\u0015S!AR\u001b\u0002\u0011A\u0014xN^5eKJL!\u0001S#\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003-\u000b\u0013\u0001T\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u00031\"Xm\u001d;GKR\u001c\u0007nT;u\u001f\u001a\u0014\u0016M\\4f\u001f\u001a47/\u001a;SKN,GoQ8oM&<W)\u0019:mS\u0016\u001cH\u000fF\u0002\u001e\u001fBCQ\u0001J\u0002A\u0002\u0015BQ!M\u0002A\u0002\u0015BCaA\u001a@\u0001\"\"1aQ%TY\u0005Y\u0015A\u000b;fgR4U\r^2i\u001fV$xJ\u001a*b]\u001e,wJ\u001a4tKR\u0014Vm]3u\u0007>tg-[4MCR,7\u000f\u001e\u000b\u0004;Y;\u0006\"\u0002\u0013\u0005\u0001\u0004)\u0003\"B\u0019\u0005\u0001\u0004)\u0003\u0006\u0002\u00034\u007f\u0001CC\u0001B\"J52\n1*\u0001\u0018uKN$h)\u001a;dQ>+Ho\u00144SC:<Wm\u00144gg\u0016$(+Z:fi\u000e{gNZ5h\u0005f$UO]1uS>tGcA\u000f^=\")A%\u0002a\u0001K!)\u0011'\u0002a\u0001K!\"QaM AQ\u0011)1)S1-\u0003-\u000ba\u0005^3ti\u001a+Go\u00195SK\u000e|'\u000f\u001a'be\u001e,'\u000f\u00165b]\u001a+Go\u00195NCb\u0014\u0015\u0010^3t)\riB-\u001a\u0005\u0006I\u0019\u0001\r!\n\u0005\u0006c\u0019\u0001\r!\n\u0015\u0005\rMz\u0004\t\u000b\u0003\u0007\u0007&CG&A&\u0002!\rDWmY6MCJ<WMU3d_J$GCA\u000fl\u0011\u0015aw\u00011\u0001n\u0003I\u0001(o\u001c3vG\u0016\u0014(+Z2pe\u0012\u001c\u0016N_3\u0011\u0005yq\u0017BA8 \u0005\rIe\u000e^\u0001/i\u0016\u001cHOR3uG\"DuN\\8veN4U\r^2i'&TX-\u00134MCJ<WMU3d_J$gj\u001c;GSJ\u001cH\u000fF\u0002\u001eeNDQ\u0001\n\u0005A\u0002\u0015BQ!\r\u0005A\u0002\u0015BC\u0001C\u001a@\u0001\"\"\u0001bQ%wY\u0005Y\u0015AK2iK\u000e\\g)\u001a;dQ\"{gn\\;sgNK'0Z%g\u0019\u0006\u0014x-\u001a*fG>\u0014HMT8u\r&\u00148\u000f\u001e\u000b\u0003;eDQA_\u0005A\u00025\fq\u0003\\1sO\u0016\u0004&o\u001c3vG\u0016\u0014(+Z2pe\u0012\u001c\u0016N_3\u0002wQ,7\u000f\u001e$fi\u000eD\u0007j\u001c8pkJ\u001cX*\u0019=QCJ$\u0018\u000e^5p]\u001a+Go\u00195CsR,7/\u00134MCJ<WMU3d_J$gj\u001c;GSJ\u001cH\u000fF\u0002\u001e{zDQ\u0001\n\u0006A\u0002\u0015BQ!\r\u0006A\u0002\u0015BCAC\u001a@\u0001\"*!bQ%\u0002\u00041\n1*A\u0018uKN$h)\u001a;dQJ+7m\u001c:e\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=QCJ$\u0018\u000e^5p]\u001a+Go\u00195CsR,7\u000fF\u0003\u001e\u0003\u0013\tY\u0001C\u0003%\u0017\u0001\u0007Q\u0005C\u00032\u0017\u0001\u0007Q\u0005\u000b\u0003\fg}\u0002\u0005&B\u0006D\u0013\u0006EA&A&\u0002SQ,7\u000f\u001e'po6\u000b\u0007PR3uG\"\u001c\u0016N_3G_J\u0014V-];fgR\fe\u000e\u001a)beRLG/[8o)\u0015i\u0012qCA\r\u0011\u0015!C\u00021\u0001&\u0011\u0015\tD\u00021\u0001&Q\u0011a1g\u0010!)\u000b1\u0019\u0015*a\b-\u0003-Cc\u0001AA\u0012\u0013\u00065\u0002\u0003BA\u0013\u0003Si!!a\n\u000b\u0005=9\u0014\u0002BA\u0016\u0003O\u0011q\u0001V5nK>,HO\b\u0002\u00031\u0002")
public class PlaintextConsumerFetchTest
extends AbstractConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchInvalidOffset(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ofMillis(15000L)));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        Map outOfRangePartitions = ((OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> consumer.poll(Duration.ofMillis(20000L)))).offsetOutOfRangePartitions();
        Assertions.assertNotNull((Object)outOfRangePartitions);
        Assertions.assertEquals((int)1, (int)outOfRangePartitions.size());
        Assertions.assertEquals((long)outOfRangePos, (Long)((Long)outOfRangePartitions.get(this.tp())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOutOfRangeOffsetResetConfigEarliest(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        long totalRecords = 10L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords(consumer, (int)totalRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
        long outOfRangePos = totalRecords + 1L;
        consumer.seek(this.tp(), outOfRangePos);
        this.consumeAndVerifyRecords(consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOutOfRangeOffsetResetConfigLatest(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "latest");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        long totalRecords = 10L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords(consumer, (int)totalRecords / 2, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
        long outOfRangePos = totalRecords + 17L;
        consumer.seek(this.tp(), outOfRangePos);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        this.sendRecords(producer, (int)totalRecords, this.tp(), totalRecords, this.sendRecords$default$5());
        ConsumerRecord nextRecord = (ConsumerRecord)consumer.poll(Duration.ofMillis(50L)).iterator().next();
        Assertions.assertEquals((long)totalRecords, (long)nextRecord.offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOutOfRangeOffsetResetConfigByDuration(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "by_duration:PT1H");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer1 = this.createConsumer(x$2, x$3, x$1, x$4);
        KafkaProducer producer1 = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long totalRecords = 10L;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer1, (int)totalRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer1.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$6 = (int)totalRecords;
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        long x$13 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer1, x$6, 0, x$9, startingTimestamp, x$10, x$11, x$12, x$13);
        long outOfRangePos = totalRecords + 1L;
        consumer1.seek(this.tp(), outOfRangePos);
        int x$18 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$19 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$20 = this.consumeAndVerifyRecords$default$7();
        int x$21 = this.consumeAndVerifyRecords$default$8();
        long x$22 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer1, 1, 0, x$18, startingTimestamp, x$19, x$20, x$21, x$22);
        Properties x$23 = this.consumerConfig();
        ByteArrayDeserializer x$24 = this.createConsumer$default$1();
        ByteArrayDeserializer x$25 = this.createConsumer$default$2();
        List<String> x$26 = this.createConsumer$default$4();
        Consumer consumer2 = this.createConsumer(x$24, x$25, x$23, x$26);
        KafkaProducer producer2 = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long totalRecords2 = 25L;
        startingTimestamp = Instant.now().minus(Duration.ofHours(24L)).toEpochMilli();
        this.sendRecords(producer2, (int)totalRecords2, this.tp2(), startingTimestamp, Duration.ofHours(1L).toMillis());
        consumer2.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        long x$31 = startingTimestamp + 24L * Duration.ofHours(1L).toMillis();
        TopicPartition x$32 = this.tp2();
        long x$33 = Duration.ofHours(1L).toMillis();
        TimestampType x$34 = this.consumeAndVerifyRecords$default$6();
        int x$35 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer2, 1, 24, 24, x$31, x$34, x$32, x$35, x$33);
        outOfRangePos = totalRecords2 + 1L;
        consumer2.seek(this.tp2(), outOfRangePos);
        long x$40 = startingTimestamp + 24L * Duration.ofHours(1L).toMillis();
        TopicPartition x$41 = this.tp2();
        long x$42 = Duration.ofHours(1L).toMillis();
        TimestampType x$43 = this.consumeAndVerifyRecords$default$6();
        int x$44 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer2, 1, 24, 24, x$40, x$43, x$41, x$44, x$42);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchRecordLargerThanFetchMaxBytes(String quorum, String groupProtocol) {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst(String quorum, String groupProtocol) {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst(String quorum, String groupProtocol) {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchRecordLargerThanMaxPartitionFetchBytes(String quorum, String groupProtocol) {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testLowMaxFetchSizeForRequestAndPartition(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(20000));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        .colon.colon topics = new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)));
        topics.foreach((Function1 & Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()));
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)topics.flatMap((Function1 & Serializable)topic -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable)x$1 -> PlaintextConsumerFetchTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1))));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Seq producerRecords = (scala.collection.immutable.Seq)partitions.flatMap((Function1 & Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2, this.sendRecords$default$4(), this.sendRecords$default$5()));
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        Set expected = ((IterableOnceOps)producerRecords.map((Function1 & Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()))).toSet();
        Set actual = ((IterableOnceOps)consumerRecords.map((Function1 & Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())))).toSet();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }
}

