/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.regex.Pattern;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.SubscriptionPattern;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidRegularExpression;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005\u0002}AQ\u0001\u0015\u0001\u0005\u0002ECQa\u0016\u0001\u0005\u0002aCQA\u0018\u0001\u0005\u0002}CQa\u001a\u0001\u0005\u0002!DQA\u001c\u0001\u0005\u0002=DQ!\u001e\u0001\u0005\u0002YDQ\u0001 \u0001\u0005\u0002uDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u001b\u0002A\u0011AA(\u0005\u0005\u0002F.Y5oi\u0016DHoQ8ogVlWM]*vEN\u001c'/\u001b9uS>tG+Z:u\u0015\t\u00112#A\u0002ba&T\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011#\u0003\u0002\u001b#\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#A\u000f\u0011\u0005a\u0001\u0011a\u0006;fgR\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8o)\r\u0001ce\r\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG\u000fC\u0003(\u0005\u0001\u0007\u0001&\u0001\u0004rk>\u0014X/\u001c\t\u0003SAr!A\u000b\u0018\u0011\u0005-\u0012S\"\u0001\u0017\u000b\u00055*\u0012A\u0002\u001fs_>$h(\u0003\u00020E\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\ty#\u0005C\u00035\u0005\u0001\u0007\u0001&A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0005\u0005Y\u00125\t\u0005\u00028\u00016\t\u0001H\u0003\u0002:u\u00051\u0001/\u0019:b[NT!a\u000f\u001f\u0002\u000f),\b/\u001b;fe*\u0011QHP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005C$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005!\u0015AK>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{::'o\\;q!J|Go\\2pYvZ\u0018' \u0015\u0005\u0005\u0019cU\n\u0005\u0002H\u00156\t\u0001J\u0003\u0002Jq\u0005A\u0001O]8wS\u0012,'/\u0003\u0002L\u0011\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\na*I\u0001P\u0003):W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f\u0011\u0005^3tiN+(m]3rk\u0016tG\u000fU1ui\u0016\u0014hnU;cg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001\t*T\u0011\u001593\u00011\u0001)\u0011\u0015!4\u00011\u0001)Q\u0011\u0019aGQ\")\t\r1EJ\u0016\u0017\u0002\u001d\u0006IB/Z:u!\u0006$H/\u001a:o+:\u001cXOY:de&\u0004H/[8o)\r\u0001\u0013L\u0017\u0005\u0006O\u0011\u0001\r\u0001\u000b\u0005\u0006i\u0011\u0001\r\u0001\u000b\u0015\u0005\tY\u00125\t\u000b\u0003\u0005\r2kF&\u0001(\u00027Q,7\u000f\u001e*fe)\u0003\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8o)\r\u0001\u0003-\u0019\u0005\u0006O\u0015\u0001\r\u0001\u000b\u0005\u0006i\u0015\u0001\r\u0001\u000b\u0015\u0005\u000bY\u00125\t\u000b\u0003\u0006\r2#G&A3\"\u0003\u0019\f\u0001iZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u000e{gn];nKJ<%o\\;q!J|Go\\2pY>sG._\u0001!i\u0016\u001cHOU33\u0015B\u000bG\u000f^3s]N+(m]2sSB$\u0018n\u001c8GKR\u001c\u0007\u000eF\u0002!S*DQa\n\u0004A\u0002!BQ\u0001\u000e\u0004A\u0002!BCA\u0002\u001cC\u0007\"\"aA\u0012'nY\u0005)\u0017!\t;fgR\u0014VM\r&QCR$XM\u001d8FqB\fg\u000eZ*vEN\u001c'/\u001b9uS>tGc\u0001\u0011qc\")qe\u0002a\u0001Q!)Ag\u0002a\u0001Q!\"qA\u000e\"DQ\u00119a\t\u0014;-\u0003\u0015\fq\u0006^3tiJ+'G\u0013)biR,'O\\*vEN\u001c'/\u001b9uS>t\u0017I\u001c3U_BL7mU;cg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001I<y\u0011\u00159\u0003\u00021\u0001)\u0011\u0015!\u0004\u00021\u0001)Q\u0011AaGQ\")\t!1Ej\u001f\u0017\u0002K\u00069C/Z:u%\u0016\u0014$\nU1ui\u0016\u0014hnU;cg\u000e\u0014\u0018\u000e\u001d;j_:LeN^1mS\u0012\u0014VmZ3y)\r\u0001cp \u0005\u0006O%\u0001\r\u0001\u000b\u0005\u0006i%\u0001\r\u0001\u000b\u0015\u0005\u0013Y\u00125\tK\u0003\n\r2\u000b)\u0001L\u0001f\u0003}!Xm\u001d;FqB\fg\u000eZ5oOR{\u0007/[2Tk\n\u001c8M]5qi&|gn\u001d\u000b\u0006A\u0005-\u0011Q\u0002\u0005\u0006O)\u0001\r\u0001\u000b\u0005\u0006i)\u0001\r\u0001\u000b\u0015\u0005\u0015Y\u00125\tK\u0003\u000b\r2\u000b\u0019\u0002L\u0001O\u0003}!Xm\u001d;TQJLgn[5oOR{\u0007/[2Tk\n\u001c8M]5qi&|gn\u001d\u000b\u0006A\u0005e\u00111\u0004\u0005\u0006O-\u0001\r\u0001\u000b\u0005\u0006i-\u0001\r\u0001\u000b\u0015\u0005\u0017Y\u00125\tK\u0003\f\r2\u000b\t\u0003L\u0001O\u0003Q!Xm\u001d;V]N,(m]2sS\n,Gk\u001c9jGR)\u0001%a\n\u0002*!)q\u0005\u0004a\u0001Q!)A\u0007\u0004a\u0001Q!\"AB\u000e\"DQ\u0015aa\tTA\u0018Y\u0005q\u0015a\n;fgR\u001cVOY:de&\u0014W-\u00138wC2LG\rV8qS\u000e\u001c\u0015M\\+ogV\u00147o\u0019:jE\u0016$R\u0001IA\u001b\u0003oAQaJ\u0007A\u0002!BQ\u0001N\u0007A\u0002!BC!\u0004\u001cC\u0007\"*QB\u0012'\u0002>1\na*A\u0011uKN$8+\u001e2tGJL'-Z%om\u0006d\u0017\u000e\u001a+pa&\u001c7)\u00198DY>\u001cX\rF\u0003!\u0003\u0007\n)\u0005C\u0003(\u001d\u0001\u0007\u0001\u0006C\u00035\u001d\u0001\u0007\u0001\u0006\u000b\u0003\u000fm\t\u001b\u0005&\u0002\bG\u0019\u0006-C&\u0001(\u00025M,G/\u001e9Tk\n\u001c8M]5cK&sg/\u00197jIR{\u0007/[2\u0015\u0007\u0001\n\t\u0006C\u0004\u0002T=\u0001\r!!\u0016\u0002\u0011\r|gn];nKJ\u0004\u0002\"a\u0016\u0002f\u0005%\u0014\u0011N\u0007\u0003\u00033RA!a\u0015\u0002\\)!\u0011QLA0\u0003\u001d\u0019G.[3oiNT1\u0001FA1\u0015\r\t\u0019GP\u0001\u0007CB\f7\r[3\n\t\u0005\u001d\u0014\u0011\f\u0002\t\u0007>t7/^7feB)\u0011%a\u001b\u0002p%\u0019\u0011Q\u000e\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0005\n\t(C\u0002\u0002t\t\u0012AAQ=uK\"2\u0001!a\u001eM\u0003\u0003\u0003B!!\u001f\u0002~5\u0011\u00111\u0010\u0006\u0003%iJA!a \u0002|\t9A+[7f_V$hD\u0001\u0002Y\u0001")
public class PlaintextConsumerSubscriptionTest
extends AbstractConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPatternSubscription(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4(), this.sendRecords$default$5());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4(), this.sendRecords$default$5());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4(), this.sendRecords$default$5());
        assignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubsequentPatternSubscription(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        assignment = (Set)assignment.$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPatternUnsubscription(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testRe2JPatternSubscription(String quorum, String groupProtocol) {
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        SubscriptionPattern pattern = new SubscriptionPattern("t.*c");
        consumer.subscribe(pattern);
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        pattern = new SubscriptionPattern(topic2 + ".*");
        consumer.subscribe(pattern);
        assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testRe2JPatternSubscriptionFetch(String quorum, String groupProtocol) {
        String topic1 = "topic1";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        SubscriptionPattern pattern = new SubscriptionPattern("topic.*");
        consumer.subscribe(pattern);
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long totalRecords = 10L;
        long startingTimestamp = System.currentTimeMillis();
        TopicPartition tp = new TopicPartition(topic1, 0);
        this.sendRecords(producer, (int)totalRecords, tp, startingTimestamp, this.sendRecords$default$5());
        int x$2 = (int)totalRecords;
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, x$2, 0, x$6, startingTimestamp, x$7, tp, x$8, x$9);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testRe2JPatternExpandSubscription(String quorum, String groupProtocol) {
        String topic1 = "topic1";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        SubscriptionPattern pattern = new SubscriptionPattern("topic1.*");
        consumer.subscribe(pattern);
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        pattern = new SubscriptionPattern("topic1|topic2");
        consumer.subscribe(pattern);
        Set expandedAssignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)expandedAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testRe2JPatternSubscriptionAndTopicSubscription(String quorum, String groupProtocol) {
        String topic1 = "topic1";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic11 = "topic11";
        this.createTopic(topic11, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        SubscriptionPattern pattern = new SubscriptionPattern("topic1.*");
        consumer.subscribe(pattern);
        Set patternAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic1, 0), new TopicPartition(topic1, 1), new TopicPartition(topic11, 0), new TopicPartition(topic11, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)patternAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava());
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        consumer.subscribe(pattern);
        this.awaitAssignment(consumer, (Set<TopicPartition>)patternAssignment);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testRe2JPatternSubscriptionInvalidRegex(String quorum, String groupProtocol) {
        Object var10_13;
        Tuple2 tuple2;
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        SubscriptionPattern pattern = new SubscriptionPattern("(t.*c");
        consumer.subscribe(pattern);
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                InvalidRegularExpression $anonfun$tryUntilNoAssertionError$1_res = PlaintextConsumerSubscriptionTest.$anonfun$testRe2JPatternSubscriptionInvalidRegex$1(consumer);
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var14_9 = null;
            Object var15_10 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (!(var10_13 instanceof Left)) {
            if (var10_13 instanceof Right) {
                throw (AssertionError)((Right)var10_13).value();
            }
            throw new MatchError((Object)var10_13);
        }
        ((Left)var10_13).value();
        tuple22 = null;
        var10_13 = null;
        consumer.unsubscribe();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testExpandingTopicSubscriptions(String quorum, String groupProtocol) {
        String otherTopic = "other";
        Set initialAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Set expandedAssignment = (Set)initialAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expandedAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testShrinkingTopicSubscriptions(String quorum, String groupProtocol) {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Set initialAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)initialAssignment);
        Set shrunkenAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)shrunkenAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUnsubscribeTopic(String quorum, String groupProtocol) {
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("session.timeout.ms", "100");
            this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        }
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubscribeInvalidTopicCanUnsubscribe(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.setupSubscribeInvalidTopic(consumer);
        String string = groupProtocol;
        String string2 = "consumer";
        if (string != null && string.equals(string2)) {
            long x$4 = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(consumer.groupMetadata().memberId()))) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting for first consumer group heartbeat response");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), x$4));
            }
        }
        Assertions.assertDoesNotThrow((Executable)new Executable(null, consumer){
            private final Consumer consumer$2;

            public void execute() {
                this.consumer$2.unsubscribe();
            }
            {
                this.consumer$2 = consumer$2;
            }
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubscribeInvalidTopicCanClose(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.setupSubscribeInvalidTopic(consumer);
        Assertions.assertDoesNotThrow((Executable)new Executable(null, consumer){
            private final Consumer consumer$3;

            public void execute() {
                this.consumer$3.close();
            }
            {
                this.consumer$3 = consumer$3;
            }
        });
    }

    public void setupSubscribeInvalidTopic(Consumer<byte[], byte[]> consumer) {
        String invalidTopicName = "topic abc";
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)invalidTopicName, (List)Nil$.MODULE$)).asJava());
        Object var9_3 = null;
        long x$4 = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            try {
                consumer.poll(Duration.ofMillis(500L));
            }
            catch (InvalidTopicException invalidTopicException) {
            }
            catch (Throwable throwable) {
                Assertions.fail((String)("An InvalidTopicException should be thrown. But " + throwable.getClass() + " is thrown"));
            }
            if ((InvalidTopicException)var9_3 != null) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"An InvalidTopicException should be thrown.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), x$4));
        }
        Assertions.assertEquals((Object)("Invalid topics: [" + invalidTopicName + "]"), (Object)((InvalidTopicException)var9_3).getMessage());
    }

    public static final /* synthetic */ InvalidRegularExpression $anonfun$testRe2JPatternSubscriptionInvalidRegex$1(Consumer consumer$1) {
        return (InvalidRegularExpression)Assertions.assertThrows(InvalidRegularExpression.class, () -> consumer$1.poll(Duration.ZERO));
    }

    public static final /* synthetic */ String $anonfun$testSubscribeInvalidTopicCanUnsubscribe$2() {
        return "Timeout waiting for first consumer group heartbeat response";
    }

    public static final /* synthetic */ boolean $anonfun$setupSubscribeInvalidTopic$1(Consumer consumer$4, ObjectRef exception$1) {
        try {
            consumer$4.poll(Duration.ofMillis(500L));
        }
        catch (InvalidTopicException e) {
            exception$1.elem = e;
        }
        catch (Throwable throwable) {
            Assertions.fail((String)("An InvalidTopicException should be thrown. But " + throwable.getClass() + " is thrown"));
        }
        return (InvalidTopicException)((Object)exception$1.elem) != null;
    }

    public static final /* synthetic */ String $anonfun$setupSubscribeInvalidTopic$2() {
        return "An InvalidTopicException should be thrown.";
    }
}

