/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.BaseProducerSendTest;
import kafka.api.PlaintextProducerSendTest$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0017\u0001\u0005\u0002eCQA\u001f\u0001\u0005\u0002mDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t\t\b\u0001C\u0001\u0003g:q!a \u0013\u0011\u0003\t\tI\u0002\u0004\u0012%!\u0005\u00111\u0011\u0005\u000799!\t!a#\t\u000f\u0005ub\u0002\"\u0001\u0002\u000e\nI\u0002\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-\u001a:TK:$G+Z:u\u0015\t\u0019B#A\u0002ba&T\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a55\t!#\u0003\u0002\u001c%\t!\")Y:f!J|G-^2feN+g\u000e\u001a+fgR\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005e\u0001\u0011a\u0005;fgR<&o\u001c8h'\u0016\u0014\u0018.\u00197ju\u0016\u0014HcA\u0011(iA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t!QK\\5u\u0011\u0015A#\u00011\u0001*\u0003\u0019\tXo\u001c:v[B\u0011!&\r\b\u0003W=\u0002\"\u0001L\u0012\u000e\u00035R!A\f\f\u0002\rq\u0012xn\u001c;?\u0013\t\u00014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019$\u0011\u0015)$\u00011\u0001*\u000359'o\\;q!J|Go\\2pY\"\"!aN\"E!\tA\u0014)D\u0001:\u0015\tQ4(\u0001\u0004qCJ\fWn\u001d\u0006\u0003yu\nqA[;qSR,'O\u0003\u0002?\u007f\u0005)!.\u001e8ji*\t\u0001)A\u0002pe\u001eL!AQ\u001d\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%A#\u0002Um$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TPL4s_V\u0004\bK]8u_\u000e|G.P>2{\"\"!aR'O!\tA5*D\u0001J\u0015\tQ\u0015(\u0001\u0005qe>4\u0018\u000eZ3s\u0013\ta\u0015J\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001PC\u0005\u0001\u0016AK4fiR+7\u000f^)v_J,X.\u00118e\u000fJ|W\u000f\u001d)s_R|7m\u001c7QCJ\fW.\u001a;feN\fE\u000e\\\u0001\u0012i\u0016\u001cHOQ1uG\"\u001c\u0016N_3[KJ|GcA\u0011T)\")\u0001f\u0001a\u0001S!)Qg\u0001a\u0001S!\"1aN\"EQ\u0011\u0019q)T,-\u0003=\u000bq\u0005^3ti\n\u000bGo\u00195TSj,',\u001a:p\u001d>\u0004\u0016M\u001d;ji&|gNT8SK\u000e|'\u000fZ&fsR\u0019\u0011EW.\t\u000b!\"\u0001\u0019A\u0015\t\u000bU\"\u0001\u0019A\u0015)\u0011\u0011iVJY2e_B\u0004\"A\u00181\u000e\u0003}S!aE\u001e\n\u0005\u0005|&a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002\u001f\u0005!QO\\5uI\u0005)\u0017B\u00014h\u0003\u001d\u0019ViQ(O\tNS!\u0001[5\u0002\u0011QKW.Z+oSRT!A[6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006\f!\u0002\u001e5sK\u0006$Wj\u001c3fI\u0005\t\u0018B\u0001:t\u0003=\u0019V\tU!S\u0003R+u\f\u0016%S\u000b\u0006#%B\u0001;v\u0003)!\u0006N]3bI6{G-\u001a\u0006\u0003m~\u000bq\u0001V5nK>,H\u000f\u000b\u0003\u0005o\r#\u0005\u0006\u0002\u0003H\u001bfd\u0013aT\u0001+i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ2{w-\u00119qK:$G+[7f)\r\tC0 \u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006k\u0015\u0001\r!\u000b\u0015\u0005\u000b]\u001aE\tK\u0003\u0006\u000f6\u000b\t\u0001L\u0001P\u00035\"Xm\u001d;TK:$gj\u001c8D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u000b\u0006C\u0005\u001d\u0011\u0011\u0002\u0005\u0006Q\u0019\u0001\r!\u000b\u0005\u0006k\u0019\u0001\r!\u000b\u0015\u0005\r]\u001aE\tK\u0003\u0007\u000f6\u000by\u0001L\u0001P\u0003M!Xm\u001d;BkR|7I]3bi\u0016$v\u000e]5d)\u0015\t\u0013QCA\f\u0011\u0015As\u00011\u0001*\u0011\u0015)t\u00011\u0001*Q\u00119qg\u0011#)\u000b\u001d9U*!\b-\u0003=\u000b!\u0006^3tiN+g\u000eZ,ji\"LeN^1mS\u0012\u0014UMZ8sK\u0006sG-\u00114uKJ$\u0016.\\3ti\u0006l\u0007\u000fF\u0005\"\u0003G\t)#a\n\u0002,!)\u0001\u0006\u0003a\u0001S!)Q\u0007\u0003a\u0001S!1\u0011\u0011\u0006\u0005A\u0002%\na#\\3tg\u0006<W\rV5nKN#\u0018-\u001c9D_:4\u0017n\u001a\u0005\b\u0003[A\u0001\u0019AA\u0018\u0003=\u0011XmY8sIRKW.Z:uC6\u0004\bc\u0001\u0012\u00022%\u0019\u00111G\u0012\u0003\t1{gn\u001a\u0015\u0005\u0011]\u001aE\tK\u0003\t\u000f6\u000bI\u0004\f\u0002\u0002<\u0005\u0012\u0011QH\u0001!cV|'/^7B]\u0012$\u0016.\\3ti\u0006l\u0007oQ8oM&<\u0007K]8wS\u0012,'/\u0001\u0017uKN$h+\u00197jI\n+gm\u001c:f\u0003:$\u0017I\u001a;feRKW.Z:uC6\u00048/\u0011;UQJ,7\u000f[8mIRI\u0011%a\u0011\u0002F\u0005\u001d\u0013\u0011\n\u0005\u0006Q%\u0001\r!\u000b\u0005\u0006k%\u0001\r!\u000b\u0005\u0007\u0003SI\u0001\u0019A\u0015\t\u000f\u00055\u0012\u00021\u0001\u00020!\"\u0011bN\"EQ\u0015Iq)TA(Y\t\tY$\u0001\u0019uKN$h+\u00197jI\n+gm\u001c:f\u0003:$\u0017I\u001a;feRKW.Z:uC6\u00048oV5uQ&tG\u000b\u001b:fg\"|G\u000e\u001a\u000b\nC\u0005U\u0013qKA-\u00037BQ\u0001\u000b\u0006A\u0002%BQ!\u000e\u0006A\u0002%Ba!!\u000b\u000b\u0001\u0004I\u0003bBA\u0017\u0015\u0001\u0007\u0011q\u0006\u0015\u0005\u0015]\u001aE\tK\u0003\u000b\u000f6\u000b\t\u0007\f\u0002\u0002<\u00059B/Z:u\u001d>t'\t\\8dW&tw\r\u0015:pIV\u001cWM\u001d\u000b\u0006C\u0005\u001d\u0014\u0011\u000e\u0005\u0006Q-\u0001\r!\u000b\u0005\u0006k-\u0001\r!\u000b\u0015\u0005\u0017]\u001aE\tK\u0003\f\u000f6\u000by\u0007L\u0001P\u00039\"Xm\u001d;TK:$'+Z2pe\u0012\u0014\u0015\r^2i/&$\b.T1y%\u0016\fX/Z:u'&TX-\u00118e\u0011&<\u0007.\u001a:\u0015\u000b\u0005\n)(a\u001e\t\u000b!b\u0001\u0019A\u0015\t\u000bUb\u0001\u0019A\u0015)\t194\t\u0012\u0015\u0006\u0019\u001dk\u0015Q\u0010\u0017\u0002\u001f\u0006I\u0002\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-\u001a:TK:$G+Z:u!\tIbbE\u0002\u000f\u0003\u000b\u00032AIAD\u0013\r\tIi\t\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0005UCAAH!\u0019\t\t*a&\u0002\u001c6\u0011\u00111\u0013\u0006\u0004\u0003+[\u0017AB:ue\u0016\fW.\u0003\u0003\u0002\u001a\u0006M%AB*ue\u0016\fW\u000eE\u0002I\u0003;K1!a(J\u0005%\t%oZ;nK:$8\u000f")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    public static Stream<Arguments> quorumAndTimestampConfigProvider() {
        return PlaintextProducerSendTest$.MODULE$.quorumAndTimestampConfigProvider();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testWrongSerializer(String quorum, String groupProtocol) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testBatchSizeZero(String quorum, String groupProtocol) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testBatchSizeZeroNoPartitionNoRecordKey(String quorum, String groupProtocol) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        String x$4 = this.createProducer$default$4();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        int numRecords = 10;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, 0, x$4, x$5, x$6);){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 2, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable)i -> PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(this, producer, BoxesRunTime.unboxToInt((Object)i)));
            producer.flush();
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(this, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSendCompressedMessageWithLogAppendTime(String quorum, String groupProtocol) {
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, x$4, "gzip", x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSendNonCompressedMessageWithLogAppendTime(String quorum, String groupProtocol) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoCreateTopic(String quorum, String groupProtocol) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testSendWithInvalidBeforeAndAfterTimestamp(String quorum, String groupProtocol, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long oneMinuteInMs = 3600000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(oneMinuteInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsAtThreshold(String quorum, String groupProtocol, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        topicProps.setProperty(messageTimeStampConfig, Long.toString(recordTimestamp));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsWithinThreshold(String quorum, String groupProtocol, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long tenMinutesInMs = 36000000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(tenMinutesInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNonBlockingProducer(String quorum, String groupProtocol) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, 0L, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(15000, x$11, 1100, x$12, 0L, 1500L);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String quorum, String groupProtocol) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = 0x10000C - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(PlaintextProducerSendTest $this, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), null, (Object)("value" + i).getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(PlaintextProducerSendTest $this, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        return offset + 1;
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple22._1();
        return var3_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)("Invalid offset " + recordMetadata));
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

