/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaBroker;
import kafka.server.QuotaFactory;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.quota.QuotaType;
import org.junit.jupiter.api.Assertions;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMv!B\u00181\u0011\u0003)d!B\u001c1\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\u001d\u0006\u0001\u000b\u0011B\"\t\u000b=\u000bA\u0011\u0001)\u0007\u000b]\u0002\u0014\u0011A1\t\u0011\t4!\u0011!Q\u0001\n\rC\u0001b\u0019\u0004\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u001a\u0011\t\u0011)A\u0005\u0007\"A1N\u0002B\u0001B\u0003%1\t\u0003\u0005m\r\t\u0015\r\u0011\"\u0001n\u0011!YhA!A!\u0002\u0013q\u0007\u0002\u0003?\u0007\u0005\u000b\u0007I\u0011A?\t\u0013\u0005\u001daA!A!\u0002\u0013q\bBCA\u0005\r\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011\u0011\u0004\u0004\u0003\u0002\u0003\u0006I!!\u0004\t\r}2A\u0011AA\u000e\u0011\u001d\tiC\u0002D\u0001\u0003_Aq!!\u0013\u0007\r\u0003\tY\u0005C\u0004\u0002N\u00191\t\"a\u0014\t\u000f\u0005\u0005dA\"\u0005\u0002d!9\u0011Q\u000f\u0004\u0005\u0002\u0005]\u0004\"CAG\rE\u0005I\u0011AAH\u0011\u001d\t)K\u0002C\u0001\u0003OC\u0011\"!,\u0007#\u0003%\t!a$\t\u000f\u0005=f\u0001\"\u0003\u00022\"9\u0011Q\u001a\u0004\u0005\n\u0005=\u0007bBAv\r\u0011\u0005\u0011Q\u001e\u0005\n\u0003s4\u0011\u0013!C\u0001\u0003\u001fC\u0011\"a?\u0007#\u0003%\t!a$\t\u000f\u0005uh\u0001\"\u0001\u0002\u0000\"I!q\u0001\u0004\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0005\u00131\u0011\u0013!C\u0001\u0003\u001fCqAa\u0003\u0007\t\u0013\u0011i\u0001C\u0004\u0003$\u0019!IA!\n\t\u000f\tEb\u0001\"\u0001\u00034!9!q\b\u0004\u0005\n\t\u0005\u0003b\u0002B$\r\u0011\u0005!\u0011\n\u0005\b\u0005\u00172A\u0011\u0002B'\u0011\u001d\u0011\tF\u0002C\u0001\u0005'B\u0011B!\u0019\u0007#\u0003%\tAa\u0019\t\u000f\t\u001dd\u0001\"\u0001\u0003j!9!Q\u0010\u0004\u0005\u0002\t}\u0004b\u0002BJ\r\u0011\u0005!Q\u0013\u0005\b\u0005C3A\u0011\u0001BR\u0011%\u0011iKBI\u0001\n\u0003\u0011y+\u0001\tRk>$\u0018\rV3ti\u000ec\u0017.\u001a8ug*\u0011\u0011GM\u0001\u0004CBL'\"A\u001a\u0002\u000b-\fgm[1\u0004\u0001A\u0011a'A\u0007\u0002a\t\u0001\u0012+^8uCR+7\u000f^\"mS\u0016tGo]\n\u0003\u0003e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00016\u00035!UMZ1vYR,e\u000e^5usV\t1\t\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\rnj\u0011a\u0012\u0006\u0003\u0011R\na\u0001\u0010:p_Rt\u0014B\u0001&<\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)[\u0014A\u0004#fM\u0006,H\u000e^#oi&$\u0018\u0010I\u0001\f[\u0016$(/[2WC2,X\r\u0006\u0002R)B\u0011!HU\u0005\u0003'n\u0012a\u0001R8vE2,\u0007\"B+\u0006\u0001\u00041\u0016AB7fiJL7\r\u0005\u0002X?6\t\u0001L\u0003\u0002Z5\u000611m\\7n_:T!aM.\u000b\u0005qk\u0016AB1qC\u000eDWMC\u0001_\u0003\ry'oZ\u0005\u0003Ab\u0013a!T3ue&\u001c7C\u0001\u0004:\u0003\u0015!x\u000e]5d\u0003)aW-\u00193fe:{G-\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003OJ\naa]3sm\u0016\u0014\u0018BA5g\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002!A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0017\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003!\u0001(o\u001c3vG\u0016\u0014X#\u00018\u0011\t=\u001cX/^\u0007\u0002a*\u0011A.\u001d\u0006\u0003ej\u000bqa\u00197jK:$8/\u0003\u0002ua\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u00042A\u000f<y\u0013\t98HA\u0003BeJ\f\u0017\u0010\u0005\u0002;s&\u0011!p\u000f\u0002\u0005\u0005f$X-A\u0005qe>$WoY3sA\u0005A1m\u001c8tk6,'/F\u0001\u007f!\u0015y\u00181A;v\u001b\t\t\tA\u0003\u0002}c&!\u0011QAA\u0001\u0005!\u0019uN\\:v[\u0016\u0014\u0018!C2p]N,X.\u001a:!\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0005\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0011/A\u0003bI6Lg.\u0003\u0003\u0002\u0018\u0005E!!B!e[&t\u0017\u0001D1e[&t7\t\\5f]R\u0004C\u0003EA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016!\t1d\u0001C\u0003c#\u0001\u00071\tC\u0003d#\u0001\u0007A\rC\u0003k#\u0001\u00071\tC\u0003l#\u0001\u00071\tC\u0003m#\u0001\u0007a\u000eC\u0003}#\u0001\u0007a\u0010C\u0004\u0002\nE\u0001\r!!\u0004\u0002\u001d=4XM\u001d:jI\u0016\fVo\u001c;bgRA\u0011\u0011GA\u001c\u0003\u0003\n)\u0005E\u0002;\u0003gI1!!\u000e<\u0005\u0011)f.\u001b;\t\u000f\u0005e\"\u00031\u0001\u0002<\u0005i\u0001O]8ek\u000e,'/U;pi\u0006\u00042AOA\u001f\u0013\r\tyd\u000f\u0002\u0005\u0019>tw\rC\u0004\u0002DI\u0001\r!a\u000f\u0002\u001b\r|gn];nKJ\fVo\u001c;b\u0011\u0019\t9E\u0005a\u0001#\u0006a!/Z9vKN$\u0018+^8uC\u0006!\"/Z7pm\u0016\fVo\u001c;b\u001fZ,'O]5eKN$\"!!\r\u0002\u001bU\u001cXM\u001d)sS:\u001c\u0017\u000e]1m+\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u00037B\u0016\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005}\u0013Q\u000b\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003=\tXo\u001c;b\u001b\u0016$(/[2UC\u001e\u001cH\u0003BA3\u0003c\u0002b!a\u001a\u0002n\r\u001bUBAA5\u0015\r\tYgO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA8\u0003S\u00121!T1q\u0011\u0019\t\u0019(\u0006a\u0001\u0007\u0006A1\r\\5f]RLE-A\u000bqe>$WoY3V]RLG\u000e\u00165s_R$H.\u001a3\u0015\r\u0005e\u0014qPAB!\rQ\u00141P\u0005\u0004\u0003{Z$aA%oi\"9\u0011\u0011\u0011\fA\u0002\u0005e\u0014AC7bqJ+7m\u001c:eg\"I\u0011Q\u0011\f\u0011\u0002\u0003\u0007\u0011qQ\u0001\u0019o\u0006LGOR8s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007c\u0001\u001e\u0002\n&\u0019\u00111R\u001e\u0003\u000f\t{w\u000e\\3b]\u0006y\u0002O]8ek\u000e,WK\u001c;jYRC'o\u001c;uY\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E%\u0006BAD\u0003'[#!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?[\u0014AC1o]>$\u0018\r^5p]&!\u00111UAM\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016G>t7/^7f+:$\u0018\u000e\u001c+ie>$H\u000f\\3e)\u0019\tI(!+\u0002,\"9\u0011\u0011\u0011\rA\u0002\u0005e\u0004\"CAC1A\u0005\t\u0019AAD\u0003}\u0019wN\\:v[\u0016,f\u000e^5m)\"\u0014x\u000e\u001e;mK\u0012$C-\u001a4bk2$HEM\u0001\u0006cV|G/\u0019\u000b\t\u0003g\u000by,!3\u0002LB!\u0011QWA^\u001b\t\t9LC\u0002\u0002:b\u000bq!\\3ue&\u001c7/\u0003\u0003\u0002>\u0006]&!B)v_R\f\u0007bBAa5\u0001\u0007\u00111Y\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0004K\u0006\u0015\u0017bAAdM\n\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u001d\tiE\u0007a\u0001\u0003#Ba!a\u001d\u001b\u0001\u0004\u0019\u0015A\n<fe&4\u0017\u0010\u00165s_R$H.\u001a+j[\u0016\u0014V-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGRQ\u0011\u0011GAi\u0003C\f)/a:\t\u000f\u0005M7\u00041\u0001\u0002V\u00061\u0011\r]5LKf\u0004B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0004\u00037D\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005}\u0017\u0011\u001c\u0002\b\u0003BL7*Z=t\u0011\u0019\t\u0019o\u0007a\u0001\u0007\u0006\u0001R.\u001a;sS\u000et\u0015-\\3Tk\u001a4\u0017\u000e\u001f\u0005\u0007\u0003gZ\u0002\u0019A\"\t\u000f\u0005%8\u00041\u0001\u0002\b\u0006qQ\r\u001f9fGR$\u0006N]8ui2,\u0017!\u0006<fe&4\u0017\u0010\u0015:pIV\u001cW\r\u00165s_R$H.\u001a\u000b\t\u0003c\ty/!=\u0002v\"9\u0011\u0011\u001e\u000fA\u0002\u0005\u001d\u0005\"CAz9A\u0005\t\u0019AAD\u0003I1XM]5gs\u000ec\u0017.\u001a8u\u001b\u0016$(/[2\t\u0013\u0005]H\u0004%AA\u0002\u0005\u001d\u0015A\u0007<fe&4\u0017PU3rk\u0016\u001cHo\u00115b]:,G.T3ue&\u001c\u0017a\b<fe&4\u0017\u0010\u0015:pIV\u001cW\r\u00165s_R$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005yb/\u001a:jMf\u0004&o\u001c3vG\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000fJ\u001a\u0002+Y,'/\u001b4z\u0007>t7/^7f)\"\u0014x\u000e\u001e;mKRA\u0011\u0011\u0007B\u0001\u0005\u0007\u0011)\u0001C\u0004\u0002j~\u0001\r!a\"\t\u0013\u0005Mx\u0004%AA\u0002\u0005\u001d\u0005\"CA|?A\u0005\t\u0019AAD\u0003}1XM]5gs\u000e{gn];nKRC'o\u001c;uY\u0016$C-\u001a4bk2$HEM\u0001 m\u0016\u0014\u0018NZ=D_:\u001cX/\\3UQJ|G\u000f\u001e7fI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0007<fe&4\u0017\u0010\u00165s_R$H.\u001a+j[\u0016lU\r\u001e:jGRA\u0011\u0011\u0007B\b\u0005?\u0011\t\u0003C\u0004\u0003\u0012\t\u0002\rAa\u0005\u0002\u0013E,x\u000e^1UsB,\u0007\u0003\u0002B\u000b\u00057i!Aa\u0006\u000b\t\u0005=&\u0011\u0004\u0006\u0003OjKAA!\b\u0003\u0018\tI\u0011+^8uCRK\b/\u001a\u0005\u0007\u0003g\u0012\u0003\u0019A\"\t\u000f\u0005%(\u00051\u0001\u0002\b\u0006\u0011B\u000f\u001b:piRdW-T3ue&\u001cg*Y7f)\u0019\u00119C!\f\u00030A\u0019qK!\u000b\n\u0007\t-\u0002L\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016DqA!\u0005$\u0001\u0004\u0011\u0019\u0002\u0003\u0004\u0002t\r\u0002\raQ\u0001\u000fi\"\u0014x\u000e\u001e;mK6+GO]5d)\u0019\u0011)Da\u000f\u0003>A!\u0011Q\u0017B\u001c\u0013\u0011\u0011I$a.\u0003\u0017-\u000bgm[1NKR\u0014\u0018n\u0019\u0005\b\u0005#!\u0003\u0019\u0001B\n\u0011\u0019\t\u0019\b\na\u0001\u0007\u0006\u0011#M]8lKJ\u0014V-];fgRlU\r\u001e:jGN$\u0006N]8ui2,G+[7f\u001bN$R!\u0015B\"\u0005\u000bBq!a5&\u0001\u0004\t)\u000e\u0003\u0004\u0002d\u0016\u0002\raQ\u0001\u0014Kb,W\u000e\u001d;SKF,Xm\u001d;NKR\u0014\u0018nY\u000b\u0003\u0005k\taE^3sS\u001aL\bK]8ek\u000e,'o\u00117jK:$H\u000b\u001b:piRdW\rV5nK6+GO]5d)\u0011\t\tDa\u0014\t\u000f\u0005%x\u00051\u0001\u0002\b\u00061c/\u001a:jMf\u001cuN\\:v[\u0016\u00148\t\\5f]R$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\r\u0005E\"Q\u000bB,\u0011\u001d\tI\u000f\u000ba\u0001\u0003\u000fC\u0011B!\u0017)!\u0003\u0005\rAa\u0017\u0002\u001f5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016\u0004BA\u000fB/#&\u0019!qL\u001e\u0003\r=\u0003H/[8o\u0003A2XM]5gs\u000e{gn];nKJ\u001cE.[3oiRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\r\u0016\u0005\u00057\n\u0019*A\tdY&,g\u000e^)v_R\fWI\u001c;jif$bAa\u001b\u0003v\tm\u0004\u0003\u0002B7\u0005cj!Aa\u001c\u000b\u0007\u0005=\u0006,\u0003\u0003\u0003t\t=$!E\"mS\u0016tG/U;pi\u0006,e\u000e^5us\"9!q\u000f\u0016A\u0002\te\u0014\u0001B;tKJ\u0004BA\u000fB/\u0007\"9\u00111\u000f\u0016A\u0002\te\u0014!F2mS\u0016tG/U;pi\u0006\fE\u000e^3sCRLwN\u001c\u000b\u000b\u0005\u0003\u00139Ia#\u0003\u0010\nE\u0005\u0003\u0002B7\u0005\u0007KAA!\"\u0003p\t)2\t\\5f]R\fVo\u001c;b\u00032$XM]1uS>t\u0007b\u0002BEW\u0001\u0007!1N\u0001\fcV|G/Y#oi&$\u0018\u0010C\u0004\u0002:-\u0002\rA!$\u0011\u000bi\u0012i&a\u000f\t\u000f\u0005\r3\u00061\u0001\u0003\u000e\"9\u0011qI\u0016A\u0002\tm\u0013!E1mi\u0016\u00148\t\\5f]R\fVo\u001c;bgR!\u0011\u0011\u0007BL\u0011\u001d\u0011I\n\fa\u0001\u00057\u000b\u0001#];pi\u0006\fE\u000e^3sCRLwN\\:\u0011\u000bi\u0012iJ!!\n\u0007\t}5H\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n!c^1ji\u001a{'/U;pi\u0006,\u0006\u000fZ1uKRQ\u0011\u0011\u0007BS\u0005O\u0013IKa+\t\u000f\u0005eR\u00061\u0001\u0002<!9\u00111I\u0017A\u0002\u0005m\u0002BBA$[\u0001\u0007\u0011\u000bC\u0004h[A\u0005\t\u0019\u00013\u00029]\f\u0017\u000e\u001e$peF+x\u000e^1Va\u0012\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0017\u0016\u0004I\u0006M\u0005")
public abstract class QuotaTestClients {
    private final String topic;
    private final KafkaBroker leaderNode;
    private final String producerClientId;
    private final String consumerClientId;
    private final KafkaProducer<byte[], byte[]> producer;
    private final Consumer<byte[], byte[]> consumer;
    private final Admin adminClient;

    public static double metricValue(org.apache.kafka.common.Metric metric) {
        return BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public static String DefaultEntity() {
        return QuotaTestClients$.MODULE$.DefaultEntity();
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    public abstract KafkaPrincipal userPrincipal();

    public abstract Map<String, String> quotaMetricTags(String var1);

    public int produceUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        boolean throttled;
        int numProduced = 0;
        do {
            byte[] payload = Integer.toString(numProduced).getBytes();
            Future future = this.producer().send(new ProducerRecord(this.topic, null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic, null, null, true));
            ++numProduced;
            do {
                boolean bl;
                KafkaMetric metric;
                if ((metric = this.throttleMetric(QuotaType.PRODUCE, this.producerClientId)) != null) {
                    if (BoxesRunTime.unboxToDouble((Object)metric.metricValue()) > 0.0) {
                        bl = true;
                        continue;
                    }
                }
                bl = throttled = false;
            } while (!future.isDone() && (!throttled || waitForRequestCompletion));
        } while (numProduced < maxRecords && !throttled);
        return numProduced;
    }

    public boolean produceUntilThrottled$default$2() {
        return true;
    }

    public int consumeUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        boolean throttled;
        long timeoutMs = TimeUnit.MINUTES.toMillis(1L);
        this.consumer().subscribe(Collections.singleton(this.topic));
        int numConsumed = 0;
        long startMs = System.currentTimeMillis();
        do {
            boolean bl;
            numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            KafkaMetric metric = this.throttleMetric(QuotaType.FETCH, this.consumerClientId);
            if (metric != null) {
                if (BoxesRunTime.unboxToDouble((Object)metric.metricValue()) > 0.0) {
                    bl = true;
                    continue;
                }
            }
            bl = throttled = false;
        } while (numConsumed < maxRecords && !throttled && System.currentTimeMillis() < startMs + timeoutMs);
        if (throttled && numConsumed < maxRecords && waitForRequestCompletion) {
            int minRecords = numConsumed + 1;
            long startMs2 = System.currentTimeMillis();
            while (numConsumed < minRecords && System.currentTimeMillis() < startMs2 + timeoutMs) {
                numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            }
        }
        return numConsumed;
    }

    public boolean consumeUntilThrottled$default$2() {
        return true;
    }

    private Quota quota(ClientQuotaManager quotaManager, KafkaPrincipal userPrincipal, String clientId) {
        return quotaManager.quota(userPrincipal, clientId);
    }

    private void verifyThrottleTimeRequestChannelMetric(ApiKeys apiKey, String metricNameSuffix, String clientId, boolean expectThrottle) {
        double throttleTimeMs = this.brokerRequestMetricsThrottleTimeMs(apiKey, metricNameSuffix);
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0.0 ? 1 : 0) != 0, (String)("Client with id=" + clientId + " should have been throttled, " + throttleTimeMs));
            return;
        }
        Assertions.assertEquals((double)0.0, (double)throttleTimeMs, (double)0.0, (String)("Client with id=" + clientId + " should not have been throttled"));
    }

    public void verifyProduceThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric(QuotaType.PRODUCE, this.producerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.PRODUCE, "", this.producerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyProducerClientThrottleTimeMetric(expectThrottle);
            return;
        }
    }

    public boolean verifyProduceThrottle$default$2() {
        return true;
    }

    public boolean verifyProduceThrottle$default$3() {
        return true;
    }

    public void verifyConsumeThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric(QuotaType.FETCH, this.consumerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.FETCH, "Consumer", this.consumerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyConsumerClientThrottleTimeMetric(expectThrottle, this.verifyConsumerClientThrottleTimeMetric$default$2());
            return;
        }
    }

    public boolean verifyConsumeThrottle$default$2() {
        return true;
    }

    public boolean verifyConsumeThrottle$default$3() {
        return true;
    }

    private void verifyThrottleTimeMetric(QuotaType quotaType, String clientId, boolean expectThrottle) {
        KafkaMetric metricValue_metric = this.throttleMetric(quotaType, clientId);
        Object var6_4 = null;
        double throttleMetricValue = BoxesRunTime.unboxToDouble((Object)metricValue_metric.metricValue());
        if (expectThrottle) {
            Assertions.assertTrue((throttleMetricValue > 0.0 ? 1 : 0) != 0, (String)("Client with id=" + clientId + " should have been throttled"));
            return;
        }
        Assertions.assertTrue((boolean)Double.isNaN(throttleMetricValue), (String)("Client with id=" + clientId + " should not have been throttled"));
    }

    /*
     * WARNING - void declaration
     */
    private MetricName throttleMetricName(QuotaType quotaType, String clientId) {
        void metricName_tags;
        void metricName_group;
        void metricName_name;
        Metrics metrics = this.leaderNode.metrics();
        java.util.Map map = CollectionConverters$.MODULE$.MapHasAsJava(this.quotaMetricTags(clientId)).asJava();
        String string = quotaType.toString();
        String string2 = "throttle-time";
        if (metrics == null) {
            throw null;
        }
        return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, String clientId) {
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(this.throttleMetricName(quotaType, clientId));
    }

    private double brokerRequestMetricsThrottleTimeMs(ApiKeys apiKey, String metricNameSuffix) {
        return QuotaTestClients.yammerMetricValue$1("kafka.network:type=RequestMetrics,name=ThrottleTimeMs,request=" + apiKey.name + metricNameSuffix);
    }

    public KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode.metrics().metricName("exempt-request-time", QuotaType.REQUEST.toString(), "");
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(metricName);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyProducerClientThrottleTimeMetric(boolean expectThrottle) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        if (expectThrottle) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$2(avgMetric, maxMetric));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()), (double)0.0, (String)"Should not have been throttled");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyConsumerClientThrottleTimeMetric(boolean expectThrottle, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        if (expectThrottle) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$2(avgMetric, maxMetric));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable)max -> Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()) <= max ? 1 : 0) != 0, (String)("Maximum consumer throttle too high: " + BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()))));
            return;
        }
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()), (double)0.0, (String)"Should not have been throttled");
    }

    public Option<Object> verifyConsumerClientThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    public ClientQuotaEntity clientQuotaEntity(Option<String> user2, Option<String> clientId2) {
        ObjectRef entries = ObjectRef.create((Object)((Map)Map$.MODULE$.empty()));
        user2.foreach((Function1 & Serializable)user -> {
            entries.elem = (Map)((Map)entries.elem).$plus$plus((IterableOnce)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user)})));
            return BoxedUnit.UNIT;
        });
        clientId2.foreach((Function1 & Serializable)clientId -> {
            entries.elem = (Map)((Map)entries.elem).$plus$plus((IterableOnce)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)})));
            return BoxedUnit.UNIT;
        });
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)entries.elem).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public ClientQuotaAlteration clientQuotaAlteration(ClientQuotaEntity quotaEntity, Option<Object> producerQuota, Option<Object> consumerQuota, Option<Object> requestQuota) {
        void addOp$1_value;
        void addOp$1_value2;
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Option option = producerQuota.map((Function1)(JFunction1.mcDJ.sp & Serializable)x$5 -> x$5);
        String addOp$1_key = "producer_byte_rate";
        seq = (scala.collection.immutable.Seq)seq.$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(addOp$1_key, (Double)addOp$1_value2.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
        Object var5_7 = null;
        option = null;
        Option option2 = consumerQuota.map((Function1)(JFunction1.mcDJ.sp & Serializable)x$6 -> x$6);
        String addOp$1_key2 = "consumer_byte_rate";
        seq = (scala.collection.immutable.Seq)seq.$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(addOp$1_key2, (Double)addOp$1_value.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
        Object var7_9 = null;
        option2 = null;
        String addOp$1_key3 = "request_percentage";
        seq = (scala.collection.immutable.Seq)seq.$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(addOp$1_key3, (Double)requestQuota.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
        Object var9_10 = null;
        return new ClientQuotaAlteration(quotaEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)seq).asJava());
    }

    public void alterClientQuotas(scala.collection.immutable.Seq<ClientQuotaAlteration> quotaAlterations) {
        this.adminClient().alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(quotaAlterations).asJava()).all().get();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota, KafkaBroker server) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                QuotaTestClients.$anonfun$waitForQuotaUpdate$1(this, server, producerQuota, consumerQuota, requestQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var15_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += scala.math.package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public KafkaBroker waitForQuotaUpdate$default$4() {
        return this.leaderNode;
    }

    public static final /* synthetic */ boolean $anonfun$brokerRequestMetricsThrottleTimeMs$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith(name$1);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private static final double yammerMetricValue$1(String name) {
        void var3_3;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaTestClients.$anonfun$brokerRequestMetricsThrottleTimeMs$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("Unable to find broker metric " + name + ": allMetrics: " + allMetrics.keySet().map((Function1 & Serializable)x$4 -> x$4.getMBeanName()))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var3_3 instanceof Meter) {
            return ((Meter)var3_3).count();
        }
        if (var3_3 instanceof Histogram) {
            return ((Histogram)var3_3).max();
        }
        throw new AssertionError((Object)("Unexpected broker metric of class " + var3_3.getClass()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyProducerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        if (BoxesRunTime.unboxToDouble((Object)avgMetric$1.metricValue()) > 0.0) {
            if (BoxesRunTime.unboxToDouble((Object)maxMetric$1.metricValue()) > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$verifyProducerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        return "Producer throttle metric not updated: avg=" + BoxesRunTime.unboxToDouble((Object)avgMetric$1.metricValue()) + " max=" + BoxesRunTime.unboxToDouble((Object)maxMetric$1.metricValue());
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        if (BoxesRunTime.unboxToDouble((Object)avgMetric$2.metricValue()) > 0.0) {
            if (BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue()) > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$verifyConsumerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        return "Consumer throttle metric not updated: avg=" + BoxesRunTime.unboxToDouble((Object)avgMetric$2.metricValue()) + " max=" + BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue());
    }

    public static final /* synthetic */ Double $anonfun$clientQuotaAlteration$1(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    private static final void addOp$1(String key, Option value, ObjectRef ops$1) {
        ops$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)ops$1.elem).$plus$plus((IterableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForQuotaUpdate$1(QuotaTestClients $this, KafkaBroker server$1, long producerQuota$1, long consumerQuota$1, double requestQuota$1) {
        void quota_clientId;
        void quota_userPrincipal;
        void quota_clientId2;
        void quota_userPrincipal2;
        void quota_clientId3;
        void quota_userPrincipal3;
        void quota_clientId4;
        void quota_userPrincipal4;
        QuotaFactory.QuotaManagers quotaManagers = server$1.dataPlaneRequestProcessor().quotas();
        String string = $this.producerClientId;
        KafkaPrincipal kafkaPrincipal = $this.userPrincipal();
        ClientQuotaManager quota_quotaManager = quotaManagers.produce();
        Object var17_8 = null;
        kafkaPrincipal = null;
        string = null;
        Quota overrideProducerQuota = quota_quotaManager.quota((KafkaPrincipal)quota_userPrincipal4, (String)quota_clientId4);
        String string2 = $this.consumerClientId;
        KafkaPrincipal kafkaPrincipal2 = $this.userPrincipal();
        ClientQuotaManager quota_quotaManager2 = quotaManagers.fetch();
        Object var20_12 = null;
        kafkaPrincipal2 = null;
        string2 = null;
        Quota overrideConsumerQuota = quota_quotaManager2.quota((KafkaPrincipal)quota_userPrincipal3, (String)quota_clientId3);
        String string3 = $this.producerClientId;
        KafkaPrincipal kafkaPrincipal3 = $this.userPrincipal();
        ClientRequestQuotaManager quota_quotaManager3 = quotaManagers.request();
        Object var23_16 = null;
        kafkaPrincipal3 = null;
        string3 = null;
        Quota overrideProducerRequestQuota = quota_quotaManager3.quota((KafkaPrincipal)quota_userPrincipal2, (String)quota_clientId2);
        String string4 = $this.consumerClientId;
        KafkaPrincipal kafkaPrincipal4 = $this.userPrincipal();
        ClientRequestQuotaManager quota_quotaManager4 = quotaManagers.request();
        Object var26_20 = null;
        kafkaPrincipal4 = null;
        string4 = null;
        Quota overrideConsumerRequestQuota = quota_quotaManager4.quota((KafkaPrincipal)quota_userPrincipal, (String)quota_clientId);
        double upperBound_upperBound = producerQuota$1;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)("ClientId " + $this.producerClientId + " of user " + $this.userPrincipal() + " must have producer quota"));
        double upperBound_upperBound2 = consumerQuota$1;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)("ClientId " + $this.consumerClientId + " of user " + $this.userPrincipal() + " must have consumer quota"));
        Assertions.assertEquals((Object)new Quota(requestQuota$1, true), (Object)overrideProducerRequestQuota, (String)("ClientId " + $this.producerClientId + " of user " + $this.userPrincipal() + " must have request quota"));
        Assertions.assertEquals((Object)new Quota(requestQuota$1, true), (Object)overrideConsumerRequestQuota, (String)("ClientId " + $this.consumerClientId + " of user " + $this.userPrincipal() + " must have request quota"));
    }

    public QuotaTestClients(String topic, KafkaBroker leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer, Admin adminClient) {
        this.topic = topic;
        this.leaderNode = leaderNode;
        this.producerClientId = producerClientId;
        this.consumerClientId = consumerClientId;
        this.producer = producer;
        this.consumer = consumer;
        this.adminClient = adminClient;
    }
}

