/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.TransactionalIdNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u00011\u0011\u0019Y\u0004\u0001)A\u0005c!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\t\u0007I\u0011A\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\u0002!Ca\u0001\u0016\u0001!\u0002\u0013I\u0005\"C+\u0001\u0001\u0004\u0005\r\u0011\"\u0001W\u0011%!\u0007\u00011AA\u0002\u0013\u0005Q\rC\u0005l\u0001\u0001\u0007\t\u0011)Q\u0005/\"IA\u000e\u0001a\u0001\u0002\u0004%\t!\u001c\u0005\ng\u0002\u0001\r\u00111A\u0005\u0002QD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u00028\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0003A\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAn\u0001\u0011%\u0011Q\t\u0005\b\u0003;\u0004A\u0011BA#\u0011\u001d\ty\u000e\u0001C\u0005\u0003C\u0014!\u0004\u0016:b]N\f7\r^5p]N,\u0005\u0010]5sCRLwN\u001c+fgRT!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018NC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\n\u0013aC5oi\u0016<'/\u0019;j_:L!AK\u0014\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u0010\u0002\rQ|\u0007/[22+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0002%I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\u0004iB\u0004T#A%\u0011\u0005)\u0013V\"A&\u000b\u00051k\u0015AB2p[6|gN\u0003\u0002#\u001d*\u0011q\nU\u0001\u0007CB\f7\r[3\u000b\u0003E\u000b1a\u001c:h\u0013\t\u00196J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\b\u0007I\u0001\taJ|G-^2feV\tq\u000b\u0005\u0003Y9zsV\"A-\u000b\u0005US&BA.N\u0003\u001d\u0019G.[3oiNL!!X-\u0003\u001b-\u000bgm[1Qe>$WoY3s!\ryt,Y\u0005\u0003A\u0002\u0013Q!\u0011:sCf\u0004\"a\u00102\n\u0005\r\u0004%\u0001\u0002\"zi\u0016\fA\u0002\u001d:pIV\u001cWM]0%KF$\"AZ5\u0011\u0005}:\u0017B\u00015A\u0005\u0011)f.\u001b;\t\u000f)l\u0011\u0011!a\u0001/\u0006\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u00039\u0004Ba\\9_=6\t\u0001O\u0003\u0002m5&\u0011!\u000f\u001d\u0002\t\u0007>t7/^7fe\u0006a1m\u001c8tk6,'o\u0018\u0013fcR\u0011a-\u001e\u0005\bUB\t\t\u00111\u0001o\u0003%\u0019wN\\:v[\u0016\u0014\b%A\u0003bI6Lg.F\u0001z!\tQH0D\u0001|\u0015\t9(,\u0003\u0002~w\n)\u0011\tZ7j]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0004M\u0006\u0005\u0001b\u00026\u0014\u0003\u0003\u0005\r!_\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!!\u0003\u0011\r\u0005-\u0011\u0011CA\u000b\u001b\t\tiAC\u0002\u0002\u0010\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0004\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"I\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005}\u0011\u0011\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0003tKR,\u0006\u000fF\u0002g\u0003KAq!a\n\u0017\u0001\u0004\tI#\u0001\u0005uKN$\u0018J\u001c4p!\u0011\tY#a\u000e\u000e\u0005\u00055\"b\u0001\u0011\u00020)!\u0011\u0011GA\u001a\u0003\u001dQW\u000f]5uKJT1!!\u000eQ\u0003\u0015QWO\\5u\u0013\u0011\tI$!\f\u0003\u0011Q+7\u000f^%oM>D3AFA\u001f!\u0011\tY#a\u0010\n\t\u0005\u0005\u0013Q\u0006\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0019D3aFA%!\u0011\tY#a\u0013\n\t\u00055\u0013Q\u0006\u0002\n\u0003\u001a$XM]#bG\"\f1\u0006^3ti\u001a\u000bG/\u00197FeJ|'/\u00114uKJLeN^1mS\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ'baBLgn\u001a\u000b\bM\u0006M\u00131NA8\u0011\u001d\t)\u0006\u0007a\u0001\u0003/\na!];peVl\u0007\u0003BA-\u0003OrA!a\u0017\u0002dA\u0019\u0011Q\f!\u000e\u0005\u0005}#bAA1G\u00051AH]8pizJ1!!\u001aA\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001(!\u001b\u000b\u0007\u0005\u0015\u0004\tC\u0004\u0002na\u0001\r!a\u0016\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8m\u0011\u001d\t\t\b\u0007a\u0001\u0003g\nA\"[:U-J*e.\u00192mK\u0012\u00042aPA;\u0013\r\t9\b\u0011\u0002\b\u0005>|G.Z1oQ\rA\u00121\u0010\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)!\u0011\u0011QA\u0018\u0003\u0019\u0001\u0018M]1ng&!\u0011QQA@\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b1\u0005%\u0015QSAL!\u0011\tY)!%\u000e\u0005\u00055%\u0002BAH\u0003\u007f\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003'\u000biIA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2B\u0011\u0011TAO\u0003C\u000b)+\t\u0002\u0002\u001c\u0006\u00192N]1gi2\u001aG.Y:tS\u000edc-\u00197tK\u0006\u0012\u0011qT\u0001\u0015WJ\fg\r\u001e\u0017d_:\u001cX/\\3sY\u0019\fGn]3\"\u0005\u0005\r\u0016AE6sC\u001a$Hf\u00197bgNL7\r\f;sk\u0016\f#!a*\u0002'-\u0014\u0018M\u001a;-G>t7/^7fe2\"(/^3\u0002KQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\fe\r^3s!J|G-^2fe&#W\t\u001f9je\u0016\u001cHc\u00024\u0002.\u0006=\u0016\u0011\u0017\u0005\b\u0003+J\u0002\u0019AA,\u0011\u001d\ti'\u0007a\u0001\u0003/Bq!!\u001d\u001a\u0001\u0004\t\u0019\bK\u0004\u001a\u0003w\n),a.\u0002\t9\fW.Z\u0011\u0003\u0003s\u000b1h\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\fTPL5t)Z\u0013TI\\1cY\u0016$Wh\u001f\u001a~Q\u001dI\u0012\u0011RAK\u0003{c\u0003\"!'\u0002\u001e\u0006\u0005\u0016QU\u0001\u000eaJ|G-^2feN#\u0018\r^3\u0016\u0005\u0005\r\u0007CBAc\u0003\u001f\f)N\u0004\u0003\u0002H\u0006-g\u0002BA/\u0003\u0013L\u0011!Q\u0005\u0004\u0003\u001b\u0004\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003#\f\u0019N\u0001\u0003MSN$(bAAg\u0001B\u0019!0a6\n\u0007\u0005e7PA\u0007Qe>$WoY3s'R\fG/Z\u0001#o\u0006LG/\u00168uS2$&/\u00198tC\u000e$\u0018n\u001c8bYN#\u0018\r^3FqBL'/Z:\u0002C]\f\u0017\u000e^+oi&dGK]1og\u0006\u001cG/[8oC2\u001cF/\u0019;f\u000bbL7\u000f^:\u0002\u0017M,'O^3s!J|\u0007o\u001d\u000b\u0003\u0003G\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004\u0003S,\u0014\u0001B;uS2LA!!<\u0002h\nQ\u0001K]8qKJ$\u0018.Z:")
public class TransactionsExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final int replicationFactor;
    private final TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
    private KafkaProducer<byte[], byte[]> producer;
    private Consumer<byte[], byte[]> consumer;
    private Admin admin;

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$4 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$4, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        GroupProtocol x$2 = this.groupProtocolFromTestParameters();
        String x$5 = "group";
        String x$6 = "earliest";
        int x$7 = 500;
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$2, x$5, x$6, false, true, x$7, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12));
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()));
        this.createTopic(this.topic1(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        if (this.consumer() != null) {
            this.consumer().close();
        }
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @CsvSource(value={"kraft,classic,false", "kraft,consumer,false", "kraft,classic,true", "kraft,consumer,true"})
    public void testFatalErrorAfterInvalidProducerIdMapping(String quorum, String groupProtocol, boolean isTV2Enabled) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(0), "4", "4", false));
        this.producer().abortTransaction();
        this.waitUntilTransactionalStateExists();
        this.waitUntilTransactionalStateExpires();
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "1", "1", false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!failedFuture.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer future never completed.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        Assertions.assertThrows(KafkaException.class, () -> this.producer().abortTransaction());
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(2), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "1", "1", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        this.waitUntilTransactionalStateExists();
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 4, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}.isTV2Enabled={2}")
    @CsvSource(value={"kraft,classic,false", "kraft,consumer,false", "kraft,classic,true", "kraft,consumer,true"})
    public void testTransactionAfterProducerIdExpires(String quorum, String groupProtocol, boolean isTV2Enabled) {
        List<ProducerState> list;
        List<ProducerState> list2;
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().flush();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(list2 = this.producerState()).nonEmpty()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer IDs for topic1 did not propagate quickly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)list2.size(), (String)"Unexpected producer to topic1");
        long oldProducerId = ((ProducerState)list2.head()).producerId();
        int oldProducerEpoch = ((ProducerState)list2.head()).producerEpoch();
        this.producer().abortTransaction();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TransactionsExpirationTest.$anonfun$testTransactionAfterProducerIdExpires$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Producer IDs for topic1 did not expire.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(list = this.producerState()).nonEmpty()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Producer IDs for topic1 did not propagate quickly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)list.size(), (String)"Unexpected producer to topic1");
        long newProducerId = ((ProducerState)list.head()).producerId();
        int newProducerEpoch = ((ProducerState)list.head()).producerEpoch();
        Assertions.assertEquals((long)oldProducerId, (long)newProducerId);
        if (isTV2Enabled) {
            Assertions.assertTrue((oldProducerEpoch + 2 <= newProducerEpoch ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((int)(oldProducerEpoch + 1), (int)newProducerEpoch);
        }
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    private List<ProducerState> producerState() {
        java.util.List activeProducers = ((DescribeProducersResult.PartitionProducerState)this.admin().describeProducers(Collections.singletonList(this.tp0())).partitionResult(this.tp0()).get()).activeProducers();
        return CollectionConverters$.MODULE$.ListHasAsScala(activeProducers).asScala().toList();
    }

    private void waitUntilTransactionalStateExpires() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsExpirationTest.$anonfun$waitUntilTransactionalStateExpires$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transaction state never expired.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTransactionalStateExists() {
        KafkaFuture describeState = this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!describeState.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transactional state was never added.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties serverProps() {
        Properties serverProps = new Properties();
        serverProps.put("auto.create.topics.enable", Boolean.toString(false));
        serverProps.put("offsets.topic.num.partitions", Integer.toString(1));
        serverProps.put("transaction.state.log.num.partitions", Integer.toString(3));
        serverProps.put("transaction.state.log.replication.factor", Integer.toString(2));
        serverProps.put("transaction.state.log.min.isr", Integer.toString(2));
        serverProps.put("controlled.shutdown.enable", Boolean.toString(true));
        serverProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(false));
        serverProps.put("auto.leader.rebalance.enable", Boolean.toString(false));
        serverProps.put("group.initial.rebalance.delay.ms", "0");
        serverProps.put("transaction.abort.timed.out.transaction.cleanup.interval.ms", "200");
        serverProps.put("transactional.id.expiration.ms", "10000");
        serverProps.put("transaction.remove.expired.transaction.cleanup.interval.ms", "500");
        serverProps.put("producer.id.expiration.ms", "5000");
        serverProps.put("producer.id.expiration.check.interval.ms", "500");
        return serverProps;
    }

    public static final /* synthetic */ boolean $anonfun$testFatalErrorAfterInvalidProducerIdMapping$1(Future failedFuture$1) {
        return failedFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testFatalErrorAfterInvalidProducerIdMapping$2() {
        return "Producer future never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$1(TransactionsExpirationTest $this, ObjectRef pState$1) {
        pState$1.elem = $this.producerState();
        return ((List)pState$1.elem).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$2() {
        return "Producer IDs for topic1 did not propagate quickly";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$3(TransactionsExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$4() {
        return "Producer IDs for topic1 did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$5(TransactionsExpirationTest $this, ObjectRef pState2$1) {
        pState2$1.elem = $this.producerState();
        return ((List)pState2$1.elem).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$6() {
        return "Producer IDs for topic1 did not propagate quickly";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExpires$1(TransactionsExpirationTest $this) {
        boolean removedTransactionState = false;
        try {
            $this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer").get();
        }
        catch (Exception exception) {
            removedTransactionState = exception.getCause() instanceof TransactionalIdNotFoundException;
        }
        return removedTransactionState;
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExpires$2() {
        return "Transaction state never expired.";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExists$1(KafkaFuture describeState$1) {
        return describeState$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExists$2() {
        return "Transactional state was never added.";
    }

    public TransactionsExpirationTest() {
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
        this.replicationFactor = 3;
    }
}

