/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterPartitionManager;
import kafka.server.MetadataCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpoints;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogLoader;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogReadInfo;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002\u001c8\u0001qBQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001O\u0011\u0019!\u0006\u0001)A\u0005\u001f\"9Q\u000b\u0001b\u0001\n\u0003q\u0005B\u0002,\u0001A\u0003%q\nC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r\u0019\u0004\u0001\u0015!\u0003Z\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001d\u0001!\u0002\u0013I\u0007b\u0002:\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007g\u0002\u0001\u000b\u0011B5\t\u000fQ\u0004!\u0019!C\u0001k\"1Q\u0010\u0001Q\u0001\nYDqA \u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\b\u0001\u0001\u000b\u0011BA\u0001\u0011!\tI\u0001\u0001b\u0001\n\u0003y\b\u0002CA\u0006\u0001\u0001\u0006I!!\u0001\t\u0017\u00055\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0002\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0002C\u0006\u0002,\u0001\u0001\r\u0011!Q!\n\u0005E\u0001bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0001\u0003_A1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002:!Y\u0011Q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0019\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\"\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA+\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001e\u0001\t\u0003\ty\u0006C\u0004\u0002\u0002\u0002!\t!a\u0018\t\u000f\u0005-\u0005\u0001\"\u0001\u0002`!9\u0011q\u0012\u0001\u0005\u0002\u0005}\u0003bBAJ\u0001\u0011\u0005\u0011q\f\u0005\b\u0003/\u0003A\u0011BA0\u0011\u001d\tI\n\u0001C\u0005\u0003?Bq!a'\u0001\t\u0013\ti\nC\u0004\u0002V\u0002!I!a6\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u00172aAa\u0016\u0001\t\te\u0003BCA\f[\t\u0005\t\u0015!\u0003\u0003\\!Q!\u0011M\u0017\u0003\u0002\u0003\u0006IAa\u0004\t\u0015\t\rTF!A!\u0002\u0013\u0011)\u0007\u0003\u0006\u0003x5\u0012\t\u0011)A\u0005\u0005sBAB!\".\u0005\u0003\u0005\u000b\u0011\u0002BD\u0005\u001bC\u0011B`\u0017\u0003\u0002\u0003\u0006I!!\u0001\t\r%kC\u0011\u0001BH\u0011\u001d\u0011\t+\fC!\u0005G\u0013\u0011\u0003U1si&$\u0018n\u001c8M_\u000e\\G+Z:u\u0015\tA\u0014(A\u0004dYV\u001cH/\u001a:\u000b\u0003i\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0007C\u0001#H\u001b\u0005)%B\u0001$:\u0003\u0015)H/\u001b7t\u0013\tAUIA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0005C\u0001'\u0001\u001b\u00059\u0014A\u00058v[J+\u0007\u000f\\5dC\u001a+Go\u00195feN,\u0012a\u0014\t\u0003}AK!!U \u0003\u0007%sG/A\nok6\u0014V\r\u001d7jG\u00064U\r^2iKJ\u001c\b%\u0001\u0007ok6\u0004&o\u001c3vG\u0016\u00148/A\u0007ok6\u0004&o\u001c3vG\u0016\u00148\u000fI\u0001\u0016]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3s\u0003YqW/\u001c*fG>\u0014Hm\u001d)feB\u0013x\u000eZ;dKJ\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003e\u0003\"A\u00173\u000e\u0003mS!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0003=~\u000baa]3sm\u0016\u0014(B\u0001\u001ea\u0015\t\t'-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0006\u0019qN]4\n\u0005\u0015\\&\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013A\u0002;na\u0012K'/F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0002j_*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f+\u00051\bCA<|\u001b\u0005A(BA={\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u000396L!\u0001 =\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0001#\u001a=fGV$xN]*feZL7-\u001a\u0011\u0002\u001f\u0005\u0004\b/\u001a8e'\u0016l\u0017\r\u001d5pe\u0016,\"!!\u0001\u0011\u0007]\f\u0019!C\u0002\u0002\u0006a\u0014\u0011bU3nCBDwN]3\u0002!\u0005\u0004\b/\u001a8e'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013AE:ie&t7.S:s'\u0016l\u0017\r\u001d5pe\u0016\f1c\u001d5sS:\\\u0017j\u001d:TK6\f\u0007\u000f[8sK\u0002\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\"O\u0001\u0004Y><\u0017\u0002BA\u000e\u0003+\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$B!!\t\u0002(A\u0019a(a\t\n\u0007\u0005\u0015rH\u0001\u0003V]&$\b\"CA\u0015+\u0005\u0005\t\u0019AA\t\u0003\rAH%M\u0001\fY><W*\u00198bO\u0016\u0014\b%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0007\t\u0004\u0019\u0006M\u0012bAA\u001bo\tI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\t\u0005\u0005\u00121\b\u0005\n\u0003SA\u0012\u0011!a\u0001\u0003c\t!\u0002]1si&$\u0018n\u001c8!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013`\u0003\u0019\u0019w.\\7p]&!\u0011QJA$\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\bi>\u0004\u0018nY%e+\t\t)\u0006\u0005\u0003\u0002F\u0005]\u0013\u0002BA-\u0003\u000f\u0012A!V;jI\u0006AAo\u001c9jG&#\u0007%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\"!\u001aa$a\u0019\u0011\t\u0005\u0015\u00141O\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005\u0019\u0011\r]5\u000b\t\u00055\u0014qN\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tHY\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\n9G\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004?\u0005m\u0004\u0003BA3\u0003{JA!a \u0002h\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001%i\u0016\u001cHOT8M_\u000e\\7i\u001c8uK:$\u0018n\u001c8XSRDw.\u001e;JgJ,\u0006\u000fZ1uK\"\u001a\u0001%!\"\u0011\t\u0005\u0015\u0014qQ\u0005\u0005\u0003\u0013\u000b9G\u0001\u0003UKN$\u0018\u0001\u000e;fgR\f\u0005\u000f]3oIJ+\u0007\u000f\\5dC\u001a+Go\u00195XSRD7k\u00195fIVdWM]\"iK\u000e\\gi\u001c:TQJLgn[%te\"\u001a\u0011%!\"\u0002GQ,7\u000f^!qa\u0016tGMU3qY&\u001c\u0017MR3uG\"<\u0016\u000e\u001e5Va\u0012\fG/Z%te\"\u001a!%!\"\u0002QQ,7\u000f^$fiJ+\u0007\u000f\\5dC^KG\u000f[+qI\u0006$X-Q:tS\u001etW.\u001a8u\u0003:$\u0017j\u001d:)\u0007\r\n))\u0001\u0014d_:\u001cWO\u001d:f]R\u0004&o\u001c3vG\u00164U\r^2i/&$\bNU3bI2{7m[(oYf\f1eY8oGV\u0014(/\u001a8u!J|G-^2f\r\u0016$8\r[,ji\"<&/\u001b;f\u0019>\u001c7.A\btG\",G-\u001e7f\u0003B\u0004XM\u001c3t)\t\ty\n\u0005\u0004\u0002\"\u0006E\u0016q\u0017\b\u0005\u0003G\u000biK\u0004\u0003\u0002&\u0006-VBAAT\u0015\r\tIkO\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K1!a,@\u0003\u001d\u0001\u0018mY6bO\u0016LA!a-\u00026\n\u00191+Z9\u000b\u0007\u0005=v\b\r\u0003\u0002:\u0006\r\u0007#B<\u0002<\u0006}\u0016bAA_q\n1a)\u001e;ve\u0016\u0004B!!1\u0002D2\u0001AaCAcM\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00141a\u0018\u00132#\u0011\tI-a4\u0011\u0007y\nY-C\u0002\u0002N~\u0012qAT8uQ&tw\rE\u0002?\u0003#L1!a5@\u0005\r\te._\u0001\u0018g\u000eDW\rZ;mK\u001a{G\u000e\\8xKJ4U\r^2iKN$b!!7\u0002f\u0006%\bCBAQ\u0003c\u000bY\u000e\r\u0003\u0002^\u0006\u0005\b#B<\u0002<\u0006}\u0007\u0003BAa\u0003C$1\"a9(\u0003\u0003\u0005\tQ!\u0001\u0002H\n\u0019q\f\n\u001a\t\r\u0005\u001dx\u00051\u0001P\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\r\u0005-x\u00051\u0001P\u0003)qW/\u001c*fG>\u0014Hm]\u0001\u0012g\u000eDW\rZ;mKNC'/\u001b8l\u0013N\u0014HCBAy\u0003w\u0014Y\u0001\r\u0003\u0002t\u0006]\b#B<\u0002<\u0006U\b\u0003BAa\u0003o$1\"!?)\u0003\u0003\u0005\tQ!\u0001\u0002H\n\u0019q\fJ\u001a\t\u000f\u0005u\b\u00061\u0001\u0002\u0000\u0006Q\u0011m\u0019;jm\u00164E.Y4\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007Q1A!\u0002y\u0003\u0019\tGo\\7jG&!!\u0011\u0002B\u0002\u00055\tEo\\7jG\n{w\u000e\\3b]\"9!Q\u0002\u0015A\u0002\t=\u0011aD7pG.$\u0016.\\3TY\u0016,\u0007/T:\u0011\u0007y\u0012\t\"C\u0002\u0003\u0014}\u0012A\u0001T8oO\u000692/\u001a;vaB\u000b'\u000f^5uS>tw+\u001b;i\u001b>\u001c7n\u001d\u000b\u0005\u0003c\u0011I\u0002C\u0004\u0002\u000e%\u0002\r!!\u0005\u0002'\r\u0014X-\u0019;f\u0019><\u0007K]8qKJ$\u0018.Z:\u0015\t\t}!q\u0005\t\u0005\u0005C\u0011\u0019#D\u0001{\u0013\r\u0011)C\u001f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\u0015U\u0001\u0007!1F\u0001\n_Z,'O]5eKN\u0004\u0002B!\f\u00036\tm\"1\b\b\u0005\u0005_\u0011\t\u0004E\u0002\u0002&~J1Aa\r@\u0003\u0019\u0001&/\u001a3fM&!!q\u0007B\u001d\u0005\ri\u0015\r\u001d\u0006\u0004\u0005gy\u0004\u0003\u0002B\u0017\u0005{IAAa\u0010\u0003:\t11\u000b\u001e:j]\u001e\fa!\u00199qK:$GCBA\u0011\u0005\u000b\u00129\u0005C\u0004\u0002.-\u0002\r!!\r\t\r\u0005-8\u00061\u0001P\u000351W\r^2i\r>dGn\\<feRQ\u0011\u0011\u0005B'\u0005\u001f\u0012\u0019F!\u0016\t\u000f\u00055B\u00061\u0001\u00022!1!\u0011\u000b\u0017A\u0002=\u000b!BZ8mY><XM]%e\u0011\u0019\t9\u000f\fa\u0001\u001f\"1\u00111\u001e\u0017A\u0002=\u0013qa\u00157po2{wmE\u0002.\u00057\u0002B!a\u0005\u0003^%!!qLA\u000b\u0005))f.\u001b4jK\u0012dunZ\u0001\u000fY><7\u000b^1si>3gm]3u\u0003!awnY1m\u0019><\u0007\u0003\u0002B4\u0005gj!A!\u001b\u000b\t\u0005]!1\u000e\u0006\u0005\u0005[\u0012y'A\u0005j]R,'O\\1mg*\u0019!\u0011O0\u0002\u000fM$xN]1hK&!!Q\u000fB5\u0005!aunY1m\u0019><\u0017\u0001\u00057fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f!\u0011\u0011YH!!\u000e\u0005\tu$\u0002\u0002B@\u0005W\nQ!\u001a9pG\"LAAa!\u0003~\t!B*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016\fA\u0003\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\b\u0003\u0002B4\u0005\u0013KAAa#\u0003j\t!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJLAA!\"\u0003^Qq!\u0011\u0013BK\u0005/\u0013IJa'\u0003\u001e\n}\u0005c\u0001BJ[5\t\u0001\u0001C\u0004\u0002\u0018Q\u0002\rAa\u0017\t\u000f\t\u0005D\u00071\u0001\u0003\u0010!9!1\r\u001bA\u0002\t\u0015\u0004b\u0002B<i\u0001\u0007!\u0011\u0010\u0005\b\u0005\u000b#\u0004\u0019\u0001BD\u0011\u0019qH\u00071\u0001\u0002\u0002\u0005q\u0011\r\u001d9f]\u0012\f5\u000fT3bI\u0016\u0014H\u0003\u0004BS\u0005W\u0013YL!0\u0003H\nU\u0007\u0003\u0002B4\u0005OKAA!+\u0003j\tiAj\\4BaB,g\u000eZ%oM>DqA!,6\u0001\u0004\u0011y+A\u0004sK\u000e|'\u000fZ:\u0011\t\tE&qW\u0007\u0003\u0005gSAA!.\u0002H\u00051!/Z2pe\u0012LAA!/\u00034\niQ*Z7pef\u0014VmY8sINDa!a:6\u0001\u0004y\u0005\"\u0003B`kA\u0005\t\u0019\u0001Ba\u0003\u0019y'/[4j]B!!q\rBb\u0013\u0011\u0011)M!\u001b\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\t\u0013\t%W\u0007%AA\u0002\t-\u0017\u0001\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007\u0003\u0002Bg\u0005#l!Aa4\u000b\u0007\u0005%S,\u0003\u0003\u0003T\n='\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0007\"\u0003BlkA\u0005\t\u0019\u0001Bm\u0003E1XM]5gS\u000e\fG/[8o\u000fV\f'\u000f\u001a\t\u0005\u0005O\u0012Y.\u0003\u0003\u0003^\n%$!\u0005,fe&4\u0017nY1uS>tw)^1sI\u0002")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    private final Uuid topicId = Uuid.randomUuid();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, configRepository, new CleanerConfig(false), this.mockTime(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false, 30000L));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"shrinkIsr not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequest.PartitionState x$1 = PartitionLockTest.partitionState$1(secondReplicaSet);
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        qual$1.makeLeader(x$1, offsetCheckpoints, (Option)x$3, x$4);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)("Expected replica " + replicaToCheck + " to be defined"));
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                Partition qual$2 = this.partition();
                LeaderAndIsrRequest.PartitionState x$5 = PartitionLockTest.partitionState$1(replicas);
                None$ x$7 = None$.MODULE$;
                Option x$8 = qual$2.makeLeader$default$4();
                qual$2.makeLeader(x$5, offsetCheckpoints, (Option)x$7, x$8);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)("Expected replica " + replicaToCheck + " to be defined"));
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)("Expected replica " + replicaToCheck + " to be defined"));
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleFollowerFetches(leaderEpoch, 1).foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable)x$10 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$10)));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleFollowerFetches(int leaderEpoch, int numRecords) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable)index -> PartitionLockTest.$anonfun$scheduleFollowerFetches$1(this, leaderEpoch, numRecords, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        AlterPartitionListener isrChangeListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty(), logManager.startup$default$2());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(CommittedPartitionState currentState, scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(currentState, outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId, Option<Uuid> targetLogDirectoryId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                LeaderEpochFileCache leaderEpochCache = UnifiedLog$.MODULE$.createLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, (Option)None$.MODULE$, (Scheduler)this.$outer.mockTime().scheduler);
                int maxTransactionTimeout = 300000;
                ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(86400000, false);
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeout, producerStateManagerConfig, (Time)this.$outer.mockTime());
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.$outer.mockTime().scheduler, (Time)this.$outer.mockTime(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap<K, V>(), false).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.$outer.mockTime().scheduler, (Time)this.$outer.mockTime(), log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset, localLog, leaderEpochCache, producerStateManager, this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), 30000L, brokerId$1, (Function0)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final long apply() {
                        return 1L;
                    }

                    public final long apply$mcJ$sp() {
                        return 1L;
                    }
                }, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1, (Option)None$.MODULE$);
            }
        };
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.topicId(), this.kafka$cluster$PartitionLockTest$$topicPartition().partition());
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn(Optional.empty());
        Mockito.when((Object)alterIsrManager.submit((TopicIdPartition)ArgumentMatchers.eq((Object)topicIdPartition), (LeaderAndIsr)ArgumentMatchers.any())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)new Some((Object)this.topicId()), partition.createLogIfNotExists$default$5());
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i))).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequest.PartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)new Some((Object)this.topicId()), partition.makeLeader$default$4()), (String)"Expected become leader transition to succeed");
        return partition;
    }

    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    private void append(Partition partition, int numRecords) {
        RequestLocal requestLocal = RequestLocal.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)x$11 -> PartitionLockTest.$anonfun$append$1(partition, requestLocal, BoxesRunTime.unboxToInt((Object)x$11)));
    }

    private void fetchFollower(Partition partition, int followerId, int leaderEpoch, int numRecords) {
        long logStartOffset = 0L;
        long fetchOffset = 0L;
        Optional<Object> lastFetchedEpoch = Optional.empty();
        int maxBytes = 1;
        while (fetchOffset < (long)numRecords) {
            FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), followerId, 1L, 0L, 1, maxBytes, FetchIsolation.LOG_END, Optional.empty());
            FetchRequest.PartitionData fetchPartitionData = new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, maxBytes, Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), lastFetchedEpoch);
            LogReadInfo logReadInfo = partition.fetchRecords(fetchParams, fetchPartitionData, this.mockTime().milliseconds(), maxBytes, true, true);
            Assertions.assertTrue((!logReadInfo.divergingEpoch.isPresent() ? 1 : 0) != 0);
            Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.fetchedData.records.batches()).asScala();
            if (!batches.nonEmpty()) continue;
            Assertions.assertEquals((int)1, (int)batches.size());
            RecordBatch batch = (RecordBatch)batches.head();
            lastFetchedEpoch = Optional.of(BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch()));
            fetchOffset = batch.lastOffset() + 1L;
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequest.PartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequest.PartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$10) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleFollowerFetches$1(PartitionLockTest $this, int leaderEpoch$1, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.fetchFollower($this.partition(), index, leaderEpoch$1, numRecords$1);
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$append$1(Partition partition$1, RequestLocal requestLocal$1, int x$11) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, (Compression)Compression.NONE, -1L, (short)-1, -1, 0L, -1);
        return partition$1.appendRecordsToLeader(batch, AppendOrigin.CLIENT, 0, requestLocal$1, partition$1.appendRecordsToLeader$default$5());
    }

    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, RequestLocal requestLocal, VerificationGuard verificationGuard) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, requestLocal, verificationGuard);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, LeaderEpochFileCache leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true, false, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        }
    }
}

