/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.PartitionListener;
import kafka.coordinator.group.CoordinatorPartitionWriter;
import kafka.coordinator.group.ListenerAdapter;
import kafka.server.ReplicaManager;
import kafka.server.TransactionSupportedOperation;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.coordinator.common.runtime.PartitionWriter;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u3A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u0006\u0001C\u0001;!)\u0001\u0007\u0001C\u0001;!)!\u0007\u0001C\u0001g!)q\u000b\u0001C\u0001;!)\u0011\f\u0001C\u0001;!)1\f\u0001C\u0001;\tq2i\\8sI&t\u0017\r^8s!\u0006\u0014H/\u001b;j_:<&/\u001b;feR+7\u000f\u001e\u0006\u0003\u00171\tQa\u001a:pkBT!!\u0004\b\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011AC\u0001\u001fi\u0016\u001cHOU3hSN$XM\u001d#fe\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ$\u0012A\b\t\u0003'}I!\u0001\t\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\t\u0002\"a\t\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u00059!.\u001e9ji\u0016\u0014(BA\u0015+\u0003\u0015QWO\\5u\u0015\u0005Y\u0013aA8sO&\u0011Q\u0006\n\u0002\u0005)\u0016\u001cH/\u0001\u0006uKN$8i\u001c8gS\u001eD#a\u0001\u0012\u0002!Q,7\u000f^,sSR,'+Z2pe\u0012\u001c\bF\u0001\u0003#\u0003\u0015\"Xm\u001d;NCf\u0014Wm\u0015;beR$&/\u00198tC\u000e$\u0018n\u001c8WKJLg-[2bi&|g\u000e\u0006\u0002\u001fi!)Q'\u0002a\u0001m\u0005)QM\u001d:peB\u0011qgP\u0007\u0002q)\u0011\u0011HO\u0001\taJ|Go\\2pY*\u00111\bP\u0001\u0007G>lWn\u001c8\u000b\u0005=i$B\u0001 +\u0003\u0019\t\u0007/Y2iK&\u0011\u0001\t\u000f\u0002\u0007\u000bJ\u0014xN]:)\u0005\u0015\u0011\u0005CA\"G\u001b\u0005!%BA#'\u0003\u0019\u0001\u0018M]1ng&\u0011q\t\u0012\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bFB\u0003J\u001fB\u000b&\u000b\u0005\u0002K\u001b6\t1J\u0003\u0002M\t\u0006A\u0001O]8wS\u0012,'/\u0003\u0002O\u0017\nQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0003Y\nQA\\1nKNd#aU+\"\u0003Q\u000bAAT(O\u000b\u0006\na+A\nO\u001fR{VIT(V\u000f\"{&+\u0012)M\u0013\u000e\u000b5+A\u000euKN$xK]5uKJ+7m\u001c:eg^KG\u000f\u001b$bS2,(/\u001a\u0015\u0003\r\t\na\u0005^3ti\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\u001c\bo\u001c8tK\u000e{g\u000e^1j]N,%O]8sQ\t9!%\u0001\ruKN$H)\u001a7fi\u0016\u0014VmY8sIN\u001cVoY2fgND#\u0001\u0003\u0012")
public class CoordinatorPartitionWriterTest {
    @Test
    public void testRegisterDeregisterListener() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        PartitionWriter.Listener listener = new PartitionWriter.Listener(null){

            public void onHighWatermarkUpdated(TopicPartition tp, long offset) {
            }
        };
        partitionRecordWriter.registerListener(tp, listener);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(tp, (PartitionListener)new ListenerAdapter(listener));
        partitionRecordWriter.deregisterListener(tp, listener);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).removeListener(tp, (PartitionListener)new ListenerAdapter(listener));
        Assertions.assertEquals((Object)new ListenerAdapter(listener), (Object)new ListenerAdapter(listener));
        Assertions.assertEquals((int)new ListenerAdapter(listener).hashCode(), (int)new ListenerAdapter(listener).hashCode());
    }

    @Test
    public void testConfig() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava())));
        Assertions.assertEquals((Object)new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava()), (Object)partitionRecordWriter.config(tp));
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)None$.MODULE$);
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> partitionRecordWriter.config(tp));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWriteRecords() {
        void withRecords_records;
        void withRecords_timestampType;
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)VerificationGuard.SENTINEL)}))));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteRecords$1(callbackCapture, tp, x$1);
            return BoxedUnit.UNIT;
        });
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, "foo".getBytes(Charset.defaultCharset()), "bar".getBytes(Charset.defaultCharset()))};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var7_7 = null;
        simpleRecordArray = null;
        MemoryRecords batch = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Assertions.assertEquals((long)11L, (long)partitionRecordWriter.append(tp, VerificationGuard.SENTINEL, batch));
        Assertions.assertEquals((Object)batch, (Object)((MapOps)recordsCapture.getValue()).getOrElse((Object)tp, (Function0 & Serializable)() -> {
            throw new AssertionError((Object)("No records for " + tp));
        }));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "NOT_ENOUGH_REPLICAS"})
    public void testMaybeStartTransactionVerification(Errors error) {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        VerificationGuard verificationGuard = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new VerificationGuard() : VerificationGuard.SENTINEL;
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.maybeSendPartitionToTransactionCoordinator((TopicPartition)ArgumentMatchers.eq((Object)tp), (String)ArgumentMatchers.eq((Object)"transactional-id"), ArgumentMatchers.eq((long)10L), ArgumentMatchers.eq((short)((short)5)), ArgumentMatchers.eq((int)-1), (Function1)callbackCapture.capture(), (TransactionSupportedOperation)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            CoordinatorPartitionWriterTest.$anonfun$testMaybeStartTransactionVerification$1(callbackCapture, error, verificationGuard, x$2);
            return BoxedUnit.UNIT;
        });
        CompletableFuture future = partitionRecordWriter.maybeStartTransactionVerification(tp, "transactional-id", 10L, (short)5, ApiKeys.TXN_OFFSET_COMMIT.latestVersion());
        Errors errors3 = error;
        Errors errors4 = Errors.NONE;
        if (!(errors3 != null ? !errors3.equals(errors4) : errors4 != null)) {
            Assertions.assertEquals((Object)verificationGuard, future.get());
            return;
        }
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWriteRecordsWithFailure() {
        void withRecords_records;
        void withRecords_timestampType;
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)VerificationGuard.SENTINEL)}))));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteRecordsWithFailure$1(callbackCapture, tp, x$3);
            return BoxedUnit.UNIT;
        });
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, "foo".getBytes(Charset.defaultCharset()), "bar".getBytes(Charset.defaultCharset()))};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var7_7 = null;
        simpleRecordArray = null;
        MemoryRecords batch = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> partitionRecordWriter.append(tp, VerificationGuard.SENTINEL, batch));
    }

    @Test
    public void testDeleteRecordsResponseContainsError() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.deleteRecords(ArgumentMatchers.anyLong(), (Map)ArgumentMatchers.any(), (Function1)callbackCapture.capture(), ArgumentMatchers.eq((boolean)true));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            CoordinatorPartitionWriterTest.$anonfun$testDeleteRecordsResponseContainsError$1(callbackCapture, x$4);
            return BoxedUnit.UNIT;
        });
        partitionRecordWriter.deleteRecords(new TopicPartition("random-topic", 0), 10L).whenComplete((x$5, exp) -> Assertions.assertEquals((Object)((Object)Errors.NOT_LEADER_OR_FOLLOWER.exception()), (Object)exp));
        replicaManager.deleteRecords(ArgumentMatchers.anyLong(), (Map)ArgumentMatchers.any(), (Function1)callbackCapture.capture(), ArgumentMatchers.eq((boolean)true));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
            CoordinatorPartitionWriterTest.$anonfun$testDeleteRecordsResponseContainsError$3(callbackCapture, x$6);
            return BoxedUnit.UNIT;
        });
        partitionRecordWriter.deleteRecords(new TopicPartition("random-topic", 0), 10L).whenComplete((x$7, exp) -> Assertions.assertTrue((boolean)(exp instanceof IllegalStateException)));
    }

    @Test
    public void testDeleteRecordsSuccess() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.deleteRecords(ArgumentMatchers.anyLong(), (Map)ArgumentMatchers.any(), (Function1)callbackCapture.capture(), ArgumentMatchers.eq((boolean)true));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$8 -> {
            CoordinatorPartitionWriterTest.$anonfun$testDeleteRecordsSuccess$1(callbackCapture, x$8);
            return BoxedUnit.UNIT;
        });
        partitionRecordWriter.deleteRecords(new TopicPartition("random-topic", 0), 10L).whenComplete((x$9, exp) -> Assertions.assertNull((Object)exp));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecords$1(ArgumentCaptor callbackCapture$1, TopicPartition tp$2, InvocationOnMock x$1) {
        ((Function1)callbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 5L, 10L, -1L, -1L, Collections.emptyList(), ""))})));
    }

    public static final /* synthetic */ void $anonfun$testMaybeStartTransactionVerification$1(ArgumentCaptor callbackCapture$2, Errors error$1, VerificationGuard verificationGuard$1, InvocationOnMock x$2) {
        ((Function1)callbackCapture$2.getValue()).apply((Object)new Tuple2((Object)error$1, (Object)verificationGuard$1));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordsWithFailure$1(ArgumentCaptor callbackCapture$3, TopicPartition tp$3, InvocationOnMock x$3) {
        ((Function1)callbackCapture$3.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$3), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_LEADER_OR_FOLLOWER))})));
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecordsResponseContainsError$1(ArgumentCaptor callbackCapture$4, InvocationOnMock x$4) {
        ((Function1)callbackCapture$4.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("random-topic", 0)), (Object)new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()))})));
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecordsResponseContainsError$3(ArgumentCaptor callbackCapture$4, InvocationOnMock x$6) {
        ((Function1)callbackCapture$4.getValue()).apply(Map$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecordsSuccess$1(ArgumentCaptor callbackCapture$5, InvocationOnMock x$8) {
        ((Function1)callbackCapture$5.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("random-topic", 0)), (Object)new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setErrorCode(Errors.NONE.code()))})));
    }
}

