/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogManagerTest$;
import kafka.log.LogMetricNames$;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileIntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011}a\u0001B8q\u0001UDQ\u0001 \u0001\u0005\u0002uD\u0011\"!\u0001\u0001\u0005\u0004%\t!a\u0001\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\t\u0001\u0005\u0004%\t!a\t\t\u0011\u0005-\u0002\u0001)A\u0005\u0003KA\u0011\"!\f\u0001\u0005\u0004%\t!a\t\t\u0011\u0005=\u0002\u0001)A\u0005\u0003KA\u0011\"!\r\u0001\u0005\u0004%\t!a\r\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003kA\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u0012\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u0013B1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002`!Y\u0011Q\u000e\u0001A\u0002\u0003\u0007I\u0011AA8\u0011-\tY\b\u0001a\u0001\u0002\u0003\u0006K!!\u0019\t\u0017\u0005u\u0004\u00011AA\u0002\u0013\u0005\u0011q\u0010\u0005\f\u0003\u000f\u0003\u0001\u0019!a\u0001\n\u0003\tI\tC\u0006\u0002\u000e\u0002\u0001\r\u0011!Q!\n\u0005\u0005\u0005\"CAH\u0001\t\u0007I\u0011AAI\u0011!\ty\n\u0001Q\u0001\n\u0005M\u0005\"CAQ\u0001\t\u0007I\u0011AAR\u0011!\tY\u000b\u0001Q\u0001\n\u0005\u0015\u0006\"CAW\u0001\t\u0007I\u0011AAR\u0011!\ty\u000b\u0001Q\u0001\n\u0005\u0015\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003\u0017\u0004A\u0011AAZ\u0011\u001d\t)\u000e\u0001C\u0001\u0003gCq!a8\u0001\t\u0003\t\u0019\fC\u0004\u0002d\u0002!\t!a-\t\u000f\u0005\u001d\b\u0001\"\u0001\u00024\"9\u00111\u001e\u0001\u0005\u0002\u0005M\u0006bBAx\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003g\u0004A\u0011AAZ\u0011\u001d\t9\u0010\u0001C\u0001\u0003gCq!a?\u0001\t\u0003\t\u0019\fC\u0004\u0002\u0000\u0002!\t!a-\t\u000f\t\r\u0001\u0001\"\u0001\u00024\"9!q\u0001\u0001\u0005\u0002\u0005M\u0006b\u0002B\u0006\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005\u001f\u0001A\u0011AAZ\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\f\u0001\t\u0003\t\u0019\fC\u0004\u00034\u0001!\t!a-\t\u000f\t]\u0002\u0001\"\u0001\u00024\"9!1\b\u0001\u0005\u0002\u0005M\u0006b\u0002B \u0001\u0011\u0005\u00111\u0017\u0005\b\u0005\u0007\u0002A\u0011AAZ\u0011\u001d\u00119\u0005\u0001C\u0001\u0003gCqAa\u0013\u0001\t\u0003\t\u0019\fC\u0004\u0003P\u0001!IA!\u0015\t\u000f\te\u0004\u0001\"\u0003\u0003|!I!\u0011\u0014\u0001\u0012\u0002\u0013%!1\u0014\u0005\n\u0005c\u0003\u0011\u0013!C\u0005\u0005gC\u0011Ba.\u0001#\u0003%IA!/\t\u000f\tu\u0006\u0001\"\u0001\u00024\"9!\u0011\u0019\u0001\u0005\u0002\u0005M\u0006b\u0002Bc\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u0011%\u0011\u0019\u000fAI\u0001\n\u0013\u0011I\fC\u0004\u0003f\u0002!\t!a-\t\u000f\t%\b\u0001\"\u0001\u00024\"9!Q\u001e\u0001\u0005\u0002\u0005M\u0006b\u0002By\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005k\u0004A\u0011AAZ\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005wDqa!\b\u0001\t\u0013\u0019y\u0002C\u0004\u00046\u0001!Iaa\u000e\t\u000f\r]\u0003\u0001\"\u0003\u0004Z!91Q\f\u0001\u0005\u0002\u0005M\u0006bBB1\u0001\u0011\u0005\u00111\u0017\u0005\b\u0007K\u0002A\u0011AAZ\u0011\u001d\u0019I\u0007\u0001C\u0001\u0003gCqa!\u001c\u0001\t\u0003\t\u0019\fC\u0004\u0004r\u0001!\t!a-\t\u000f\rU\u0004\u0001\"\u0001\u00024\"91\u0011\u0010\u0001\u0005\u0002\u0005M\u0006bBB?\u0001\u0011\u00051q\u0010\u0005\n\u0007+\u0003\u0011\u0013!C\u0001\u0007/C\u0011ba'\u0001\u0005\u0004%\ta!(\t\u0011\r\u0015\u0006\u0001)A\u0005\u0007?C\u0011ba*\u0001\u0005\u0004%\ta!(\t\u0011\r%\u0006\u0001)A\u0005\u0007?C\u0011ba+\u0001\u0005\u0004%\ta!(\t\u0011\r5\u0006\u0001)A\u0005\u0007?C\u0011ba,\u0001\u0005\u0004%\ta!(\t\u0011\rE\u0006\u0001)A\u0005\u0007?C\u0011ba-\u0001\u0005\u0004%\ta!(\t\u0011\rU\u0006\u0001)A\u0005\u0007?C\u0011ba.\u0001\u0005\u0004%\ta!(\t\u0011\re\u0006\u0001)A\u0005\u0007?C\u0011ba/\u0001\u0005\u0004%\ta!(\t\u0011\ru\u0006\u0001)A\u0005\u0007?C\u0011ba0\u0001\u0005\u0004%\ta!(\t\u0011\r\u0005\u0007\u0001)A\u0005\u0007?C\u0011ba1\u0001\u0005\u0004%\ta!(\t\u0011\r\u0015\u0007\u0001)A\u0005\u0007?C\u0011ba2\u0001\u0005\u0004%\ta!(\t\u0011\r%\u0007\u0001)A\u0005\u0007?Cqaa3\u0001\t\u0003\t\u0019\fC\u0004\u0004P\u0002!\t!a-\t\u000f\rM\u0007\u0001\"\u0001\u00024\"91q\u001b\u0001\u0005\u0002\u0005M\u0006bBBn\u0001\u0011\u0005\u00111\u0017\u0005\b\u0007?\u0004A\u0011AAZ\u0011\u001d\u0019\u0019\u000f\u0001C\u0001\u0003g;qaa:q\u0011\u0003\u0019IO\u0002\u0004pa\"\u000511\u001e\u0005\u0007y*$\ta!<\t\u000f\r=(\u000e\"\u0001\u0004r\"91q\u001f6\u0005\u0002\re\bb\u0002C\bU\u0012\u0005A\u0011\u0003\u0002\u000f\u0019><W*\u00198bO\u0016\u0014H+Z:u\u0015\t\t(/A\u0002m_\u001eT\u0011a]\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u000f\u0005\u0002xu6\t\u0001PC\u0001z\u0003\u0015\u00198-\u00197b\u0013\tY\bP\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0004\"a \u0001\u000e\u0003A\fA\u0001^5nKV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tY\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0011)H/\u001b7\u000b\t\u0005=\u0011\u0011C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007M\f\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001a\u0005\u0019qN]4\n\t\u0005u\u0011\u0011\u0002\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005yQ.\u0019=S_2d\u0017J\u001c;feZ\fG.\u0006\u0002\u0002&A\u0019q/a\n\n\u0007\u0005%\u0002PA\u0002J]R\f\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\u0002\u00175\f\u0007\u0010T8h\u0003\u001e,Wj]\u0001\r[\u0006DHj\\4BO\u0016l5\u000fI\u0001\tY><\u0007K]8qgV\u0011\u0011Q\u0007\t\u0005\u0003o\ty$\u0004\u0002\u0002:)!\u00111BA\u001e\u0015\t\ti$\u0001\u0003kCZ\f\u0017\u0002BA!\u0003s\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n9&\u0004\u0002\u0002N)\u0019\u0011/a\u0014\u000b\t\u0005E\u00131K\u0001\nS:$XM\u001d8bYNTA!!\u0016\u0002\u0012\u000591\u000f^8sC\u001e,\u0017\u0002BA-\u0003\u001b\u0012\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0004m_\u001e$\u0015N]\u000b\u0003\u0003C\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\nY$\u0001\u0002j_&!\u00111NA3\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0003\u0002r\u0005]\u0004cA<\u0002t%\u0019\u0011Q\u000f=\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003sj\u0011\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003\u001dawn\u001a#je\u0002\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\t\t\t\tE\u0002\u0000\u0003\u0007K1!!\"q\u0005)aunZ'b]\u0006<WM]\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\t(a#\t\u0013\u0005e\u0004#!AA\u0002\u0005\u0005\u0015a\u00037pO6\u000bg.Y4fe\u0002\nAA\\1nKV\u0011\u00111\u0013\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*!\u0011\u0011TA\u001e\u0003\u0011a\u0017M\\4\n\t\u0005u\u0015q\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\fW.\u001a\u0011\u00023Y,'/\u001f'be\u001e,Gj\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\\u000b\u0003\u0003K\u00032a^AT\u0013\r\tI\u000b\u001f\u0002\u0005\u0019>tw-\u0001\u000ewKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006d\u0007%\u0001\nj]&$\u0018.\u00197UCN\\G)\u001a7bs6\u001b\u0018aE5oSRL\u0017\r\u001c+bg.$U\r\\1z\u001bN\u0004\u0013!B:fiV\u0003HCAA9Q\rA\u0012q\u0017\t\u0005\u0003s\u000b9-\u0004\u0002\u0002<*!\u0011QXA`\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0003\f\u0019-A\u0004kkBLG/\u001a:\u000b\t\u0005\u0015\u0017qC\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0013\fYL\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00043\u0005=\u0007\u0003BA]\u0003#LA!a5\u0002<\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\u0007i\tI\u000e\u0005\u0003\u0002:\u0006m\u0017\u0002BAo\u0003w\u0013A\u0001V3ti\u0006\u0019C/Z:u\u0007J,\u0017\r^3M_\u001e|e\u000eV1sO\u0016$X\r\u001a'pO\u0012K'/Z2u_JL\bfA\u000e\u0002Z\u0006!D/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5UCJ<W\r^3e\u0019><G)\u001b:fGR|'/_*fi\u0006\u001bXK\\1tg&<g.\u001a3)\u0007q\tI.A'uKN$8I]3bi\u0016dunZ,ji\"$\u0016M]4fi\u0016$Gj\\4ESJ,7\r^8ssN+G/Q:V].twn\u001e8XSRDw.\u001e;B]f|eM\u001a7j]\u0016$\u0015N]3di>\u0014\u0018.Z:)\u0007u\tI.\u0001\u0013uKN$\b*\u00198eY&tw-\u0012=dKB$\u0018n\u001c8t\tV\u0014\u0018N\\4TQV$Hm\\<oQ\rq\u0012\u0011\\\u0001%i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7f/&$\bN\u0011:pW\u0016\u0014X\t]8dQ\"\u001aq$!7\u0002yQ,7\u000f^\"mK\u0006t7\u000b[;uI><hNR5mK^CWM\\*ikR$wn\u001e8DC2dW\r\u001a\"fM>\u0014Xm\u0015;beR,\boQ8na2,G/\u001a\u0015\u0004A\u0005e\u0017A\b;fgR\u001c%/Z1uK2{wmV5uQ&sg/\u00197jI2{w\rR5sQ\r\t\u0013\u0011\\\u0001 i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDGj\\4ESJ4\u0015\r\u001c7cC\u000e\\\u0007f\u0001\u0012\u0002Z\u0006)B/Z:u\u000f\u0016$hj\u001c8Fq&\u001cH/\u001a8u\u0019><\u0007fA\u0012\u0002Z\u0006QB/Z:u\u00072,\u0017M\\;q\u000bb\u0004\u0018N]3e'\u0016<W.\u001a8ug\"\u001aA%!7\u0002CQ,7\u000f^\"mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3)\u0007\u0015\nI.\u0001\u0016uKN$Hi\\3t]R\u001cE.Z1o\u0019><7oV5uQ\u000e{W\u000e]1di\u0012+G.\u001a;f!>d\u0017nY=)\u0007\u0019\nI.\u0001\u0013uKN$Hi\\3t]R\u001cE.Z1o\u0019><7oV5uQ\u000e{W\u000e]1diB{G.[2zQ\r9\u0013\u0011\\\u0001\u0014i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm\u001d\u000b\u0005\u0003c\u00129\u0002C\u0004\u0003\u001a!\u0002\rAa\u0007\u0002\rA|G.[2z!\u0011\u0011iBa\u000b\u000f\t\t}!q\u0005\t\u0004\u0005CAXB\u0001B\u0012\u0015\r\u0011)\u0003^\u0001\u0007yI|w\u000e\u001e \n\u0007\t%\u00020\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\u0013iCC\u0002\u0003*a\f!\u0003^3tiRKW.\u001a\"bg\u0016$g\t\\;tQ\"\u001a\u0011&!7\u00023Q,7\u000f\u001e'fCN$Hj\\1eK\u0012\f5o]5h]6,g\u000e\u001e\u0015\u0004U\u0005e\u0017\u0001\t;fgRdu.\u00193M_\u001e\u001c8k[5q%\u0016lw\u000e^3J]\u0012,\u0007pQ1dQ\u0016D3aKAm\u0003\u0015\"Xm\u001d;M_\u0006$Gj\\4SK:\fW.\u001a'pORC\u0017\r^*i_VdGMQ3TiJ\f\u0017\u0010K\u0002-\u00033\f1\u0005^3tiR;x\u000eT8h\u001b\u0006t\u0017mZ3sgV\u001b\u0018N\\4TC6,G)\u001b:GC&d7\u000fK\u0002.\u00033\fA\u0004^3ti\u000eCWmY6q_&tGOU3d_Z,'/\u001f)pS:$8\u000fK\u0002/\u00033\fQ\u0006^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:iQ\ry\u0013\u0011\\\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\r\u0001\u0014\u0011\\\u0001\u0019m\u0016\u0014\u0018NZ=DQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJLH\u0003CA9\u0005'\u0012)Ha\u001e\t\u000f\tU\u0013\u00071\u0001\u0003X\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003Z\t\r$\u0011\u000e\b\u0005\u00057\u0012yF\u0004\u0003\u0003\"\tu\u0013\"A=\n\u0007\t\u0005\u00040A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015$q\r\u0002\u0004'\u0016\f(b\u0001B1qB!!1\u000eB9\u001b\t\u0011iG\u0003\u0003\u0003p\u0005E\u0011AB2p[6|g.\u0003\u0003\u0003t\t5$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003{\n\u0004\u0019AAA\u0011\u001d\ti&\ra\u0001\u0003C\n\u0001c\u0019:fCR,Gj\\4NC:\fw-\u001a:\u0015\u0011\u0005\u0005%Q\u0010BB\u0005+C\u0011Ba 3!\u0003\u0005\rA!!\u0002\u000f1|w\rR5sgB1!\u0011\fB2\u0003CB\u0011B!\"3!\u0003\u0005\rAa\"\u0002!\r|gNZ5h%\u0016\u0004xn]5u_JL\b\u0003\u0002BE\u0005#k!Aa#\u000b\t\t5%qR\u0001\t[\u0016$\u0018\rZ1uC*\u0019\u0011q\u0002:\n\t\tM%1\u0012\u0002\u0011\u0007>tg-[4SKB|7/\u001b;pefD\u0011Ba&3!\u0003\u0005\r!!\n\u00023I,7m\u001c<fef$\u0006N]3bIN\u0004VM\u001d#bi\u0006$\u0015N]\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$H%M\u000b\u0003\u0005;SCA!!\u0003 .\u0012!\u0011\u0015\t\u0005\u0005G\u0013i+\u0004\u0002\u0003&*!!q\u0015BU\u0003%)hn\u00195fG.,GMC\u0002\u0003,b\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yK!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ede\u0016\fG/\u001a'pO6\u000bg.Y4fe\u0012\"WMZ1vYR$#'\u0006\u0002\u00036*\"!q\u0011BP\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YL\u000b\u0003\u0002&\t}\u0015A\t;fgR4\u0015\u000e\\3SK\u001a,'/\u001a8dKN\fe\r^3s\u0003NLhn\u0019#fY\u0016$X\rK\u00027\u00033\f!\u0005^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016|e/\u001a:ms2{gn\u001a+pa&\u001c\u0007fA\u001c\u0002Z\u0006\tC/Z:u\u0007\",7m\u001b9pS:$hi\u001c:P]2L\u0018I\u001a4fGR,G\rT8hg\"\u001a\u0001(!7\u0002\u000fI,\u0017\r\u001a'pORA!Q\u001aBj\u00057\u0014y\u000e\u0005\u0003\u0002L\t=\u0017\u0002\u0002Bi\u0003\u001b\u0012QBR3uG\"$\u0015\r^1J]\u001a|\u0007BB9:\u0001\u0004\u0011)\u000eE\u0002\u0000\u0005/L1A!7q\u0005))f.\u001b4jK\u0012dun\u001a\u0005\b\u0005;L\u0004\u0019AAS\u0003\u0019ygMZ:fi\"I!\u0011]\u001d\u0011\u0002\u0003\u0007\u0011QE\u0001\n[\u0006DH*\u001a8hi\"\f\u0011C]3bI2{w\r\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0015\"Xm\u001d;U_BL7mQ8oM&<7\t[1oO\u0016,\u0006\u000fZ1uKNdunZ\"p]\u001aLw\rK\u0002<\u00033\fQ\u0004^3ti\u000e{gNZ5h\u0007\"\fgnZ3HKR\u001c8\t\\3b]\u0016$W\u000b\u001d\u0015\u0004y\u0005e\u0017\u0001\u000b;fgR\u0014%o\\6fe\u000e{gNZ5h\u0007\"\fgnZ3EK2Lg/\u001a:fIR{\u0017\t\u001c7M_\u001e\u001c\bfA\u001f\u0002Z\u0006\u0019D/Z:u)>\u0004\u0018nY\"p]\u001aLwm\u00115b]\u001e,7\u000b^8q\u00072,\u0017M\\5oO&37i\\7qC\u000e$\u0018j\u001d*f[>4X\r\u001a\u0015\u0004}\u0005e\u0017\u0001\f;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4fg^KG\u000f\u001b(p\u0019><w)\u001a;uS:<\u0017J\\5uS\u0006d\u0017N_3eQ\ry\u0014\u0011\\\u0001\u0013CB\u0004XM\u001c3SK\u000e|'\u000fZ:U_2{w\r\u0006\u0007\u0002r\tu(q`B\u0002\u0007\u000f\u0019I\u0002C\u0004\u0002\u0002\u0001\u0003\r!!\u0002\t\u000f\r\u0005\u0001\t1\u0001\u0002b\u0005a\u0001/\u0019:f]Rdun\u001a#je\"91Q\u0001!A\u0002\u0005\u0015\u0012a\u00039beRLG/[8o\u0013\u0012Dqa!\u0003A\u0001\u0004\u0019Y!\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB!1QBB\u000b\u001b\t\u0019yA\u0003\u0003\u0004\u0012\rM\u0011aB7fiJL7m\u001d\u0006\u0004c\u0006M\u0013\u0002BB\f\u0007\u001f\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\u000f\rm\u0001\t1\u0001\u0002&\u00051R\r\u001f9fGR,GmU3h[\u0016tGo\u001d)fe2{w-\u0001\u0012wKJLg-\u001f*f[\u0006Lg.\u001b8h\u0019><7\u000fV8SK\u000e|g/\u001a:NKR\u0014\u0018n\u0019\u000b\u0007\u0003c\u001a\tc!\n\t\u000f\r\r\u0012\t1\u0001\u0002\u0002\u0006i1\u000f]=M_\u001el\u0015M\\1hKJDqaa\nB\u0001\u0004\u0019I#\u0001\bfqB,7\r^3e!\u0006\u0014\u0018-\\:\u0011\u0011\r-2\u0011\u0007B\u000e\u0003Ki!a!\f\u000b\u0007\r=\u00020\u0001\u0006d_2dWm\u0019;j_:LAaa\r\u0004.\t\u0019Q*\u00199\u0002MY,'/\u001b4z%\u0016l\u0017-\u001b8j]\u001e\u001cVmZ7f]R\u001cHk\u001c*fG>4XM]'fiJL7\r\u0006\u0007\u0002r\re21HB\u001f\u0007\u007f\u0019)\u0006C\u0004\u0004$\t\u0003\r!!!\t\u000f\t}$\t1\u0001\u0003\u0002\"9!q\u0013\"A\u0002\u0005\u0015\u0002bBB!\u0005\u0002\u000711I\u0001\b[>\u001c7.T1q!!\u0019)ea\u0013\u0003\u001c\r=SBAB$\u0015\u0011\u0019I%!\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0004N\r\u001d#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011QSB)\u0013\u0011\u0019\u0019&a&\u0003\u000f%sG/Z4fe\"91q\u0005\"A\u0002\r%\u0012A\b<fe&4\u0017\u0010T8h%\u0016\u001cwN^3s\u001b\u0016$(/[2t%\u0016lwN^3e)\u0011\t\tha\u0017\t\u000f\r\r2\t1\u0001\u0002\u0002\u00061B/Z:u\u0019><'+Z2pm\u0016\u0014\u00180T3ue&\u001c7\u000fK\u0002E\u00033\fa\u0007^3ti2{wMU3d_Z,'/_'fiJL7m]*i_VdGMQ3SK6|g/\u001a3BMR,'\u000fT8h%\u0016\u001cwN^3sK\u0012D3!RAm\u0003A\"Xm\u001d;NKR\u0014\u0018nY:Fq&\u001cHo\u00165f]2{w-S:SK\u000e\u0014X-\u0019;fI\n+gm\u001c:f\t\u0016dW\r^5p]\"\u001aa)!7\u0002cQ,7\u000f^'fiJL7m]!sKJ+Wn\u001c<fI^CWM\\'pm&twmQ;se\u0016tG\u000fV8GkR,(/\u001a'pO\"\u001aq)!7\u00021Q,7\u000f^,bSR4uN]!mYR{7i\\7qY\u0016$X\rK\u0002I\u00033\fA\u0003^3ti2{\u0017\r\u001a#je\u0016\u001cGo\u001c:z\u0013\u0012\u001c\bfA%\u0002Z\u0006QC/Z:u\u0007\",7m\u001b9pS:$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$hi\u001c:SK6|G/\u001a+pa&\u001c\u0007f\u0001&\u0002Z\u0006QC/Z:u\u0007\",7m\u001b9pS:$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$hi\u001c:O_Jl\u0017\r\u001c+pa&\u001c\u0007fA&\u0002Z\u0006\u0019rO]5uK6+G/\u0019)s_B,'\u000f^5fgR1\u0011\u0011OBA\u0007\u000bCqaa!M\u0001\u0004\t\t'A\u0002eSJD\u0011ba\"M!\u0003\u0005\ra!#\u0002\u0017\u0011L'/Z2u_JL\u0018\n\u001a\t\u0007\u0003o\u0019Yia$\n\t\r5\u0015\u0011\b\u0002\t\u001fB$\u0018n\u001c8bYB!!1NBI\u0013\u0011\u0019\u0019J!\u001c\u0003\tU+\u0018\u000eZ\u0001\u001eoJLG/Z'fi\u0006\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u0014\u0016\u0005\u0007\u0013\u0013y*\u0001\u0003g_>\u0004TCABP!\u0011\u0011Yg!)\n\t\r\r&Q\u000e\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\fQAZ8pa\u0001\nAAZ8pc\u0005)am\\82A\u0005!!-\u0019:1\u0003\u0015\u0011\u0017M\u001d\u0019!\u0003\u0011\u0011\u0017M]\u0019\u0002\u000b\t\f'/\r\u0011\u0002\t\t\f'\u0010M\u0001\u0006E\u0006T\b\u0007I\u0001\u0005E\u0006T\u0018'A\u0003cCj\f\u0004%\u0001\u0003cCj\u0014\u0014!\u00022buJ\u0002\u0013!B9vkb\u0004\u0014AB9vkb\u0004\u0004%A\u0007sK\u000e\u0014X-\u0019;fI\u001a{w\u000eM\u0001\u000fe\u0016\u001c'/Z1uK\u00124un\u001c\u0019!\u00035\u0011Xm\u0019:fCR,GMR8pc\u0005q!/Z2sK\u0006$X\r\u001a$p_F\u0002\u0013!\n;fgRL5o\u0015;sCf\\%/\u00194u%\u0016\u0004H.[2b/&$\b.R7qifLU.Y4fQ\r\u0011\u0017\u0011\\\u0001\u001fi\u0016\u001cH/S:TiJ\f\u0017p\u0013:bMR\u0014V\r\u001d7jG\u0006Le.S7bO\u0016D3aYAm\u0003A\"Xm\u001d;JgN#(/Y=Le\u00064GOU3qY&\u001c\u0017-\u00138J[\u0006<WmV5uQJ+Wn\u001c;f%\u0016\u0004H.[2bg\"\u001aA-!7\u0002=Q,7\u000f^%t'R\u0014\u0018-_&sC\u001a$X*[:tS:<Gk\u001c9jG&#\u0007fA3\u0002Z\u0006AA/Z:u\u0019>\u001c7\u000eK\u0002g\u00033\fQ\u0005^3tiNCW\u000f\u001e3po:<\u0016\u000e\u001e5[KJ|g)\u001b7f\t\u0016dW\r^3EK2\f\u00170T:)\u0007\u001d\fI.\u0001\u0012uKN$\u0018J\u001c<bY&$Gj\\4ESJtu\u000e\u001e$bS2dunZ'b]\u0006<WM\u001d\u0015\u0004Q\u0006e\u0017A\u0004'pO6\u000bg.Y4feR+7\u000f\u001e\t\u0003\u007f*\u001c\"A\u001b<\u0015\u0005\r%\u0018aB7pG.dun\u001a\u000b\u0005\u0005+\u001c\u0019\u0010C\u0004\u0004v2\u0004\raa(\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0017A\u0003;pa&\u001c\u0017*\\1hKR!11 C\u0004!\u0011\u0019i\u0010b\u0001\u000e\u0005\r}(\u0002\u0002C\u0001\u0003#\tQ![7bO\u0016LA\u0001\"\u0002\u0004\u0000\nQAk\u001c9jG&k\u0017mZ3\t\u000f\u0011%Q\u000e1\u0001\u0005\f\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u0011\r-2\u0011GBP\t\u001b\u0001bA!\u0017\u0003d\u0005\u0015\u0012a\u0003;pa&\u001c7/S7bO\u0016$B\u0001b\u0005\u0005\u001aA!1Q C\u000b\u0013\u0011!9ba@\u0003\u0017Q{\u0007/[2t\u00136\fw-\u001a\u0005\b\t7q\u0007\u0019\u0001C\u000f\u0003\u0019!x\u000e]5dgB1!\u0011\fB2\u0007w\u0004")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;
    private final long initialTaskDelayMs;
    private final TopicIdPartition foo0;
    private final TopicIdPartition foo1;
    private final TopicIdPartition bar0;
    private final TopicIdPartition bar1;
    private final TopicIdPartition baz0;
    private final TopicIdPartition baz1;
    private final TopicIdPartition baz2;
    private final TopicIdPartition quux0;
    private final TopicIdPartition recreatedFoo0;
    private final TopicIdPartition recreatedFoo1;

    public static TopicsImage topicsImage(scala.collection.immutable.Seq<TopicImage> topics) {
        return LogManagerTest$.MODULE$.topicsImage(topics);
    }

    public static TopicImage topicImage(Map<TopicIdPartition, scala.collection.immutable.Seq<Object>> partitions) {
        return LogManagerTest$.MODULE$.topicImage(partitions);
    }

    public static UnifiedLog mockLog(TopicIdPartition topicIdPartition) {
        return LogManagerTest$.MODULE$.mockLog(topicIdPartition);
    }

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    public long initialTaskDelayMs() {
        return this.initialTaskDelayMs;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$1 = Predef$.MODULE$.Set().empty();
        Function1 x$2 = qual$1.startup$default$2();
        qual$1.startup((Set)x$1, x$2);
        Assertions.assertEquals((long)this.initialTaskDelayMs(), (long)this.logManager().initialTaskDelayMs());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            LogManager qual$1 = this.logManager();
            long x$12 = qual$1.shutdown$default$1();
            qual$1.shutdown(x$12);
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), this.name() + "-0").exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogOnTargetedLogDirectory() {
        Uuid targetedLogDirectoryId = DirectoryId.random();
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(5, (Function0 & Serializable)() -> TestUtils$.MODULE$.tempDir());
        this.writeMetaProperties((File)dirs.head(), this.writeMetaProperties$default$2());
        this.writeMetaProperties((File)dirs.apply(1), Optional.of(targetedLogDirectoryId));
        this.writeMetaProperties((File)dirs.apply(3), Optional.of(DirectoryId.random()));
        this.writeMetaProperties((File)dirs.apply(4), this.writeMetaProperties$default$2());
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)targetedLogDirectoryId);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$4, x$5, (Option)x$2, (Option)x$3);
        Assertions.assertEquals((int)5, (int)this.logManager().liveLogDirs().size());
        File logFile = new File((File)dirs.apply(1), this.name() + "-0");
        Assertions.assertTrue((boolean)logFile.exists());
        Assertions.assertEquals((Object)((File)dirs.apply(1)).getAbsolutePath(), (Object)logFile.getParent());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithTargetedLogDirectorySetAsUnassigned() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)DirectoryId.UNASSIGNED);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$4, x$5, (Option)x$2, (Option)x$3);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), this.name() + "-0");
        Assertions.assertTrue((boolean)logFile.exists());
        Assertions.assertFalse((boolean)this.logManager().directoryId(logFile.getParent()).equals((Object)DirectoryId.UNASSIGNED));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithTargetedLogDirectorySetAsUnknownWithoutAnyOfflineDirectories() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        Some x$3 = new Some((Object)DirectoryId.LOST);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$4, x$5, (Option)x$2, (Option)x$3);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), this.name() + "-0");
        Assertions.assertTrue((boolean)logFile.exists());
        Assertions.assertFalse((boolean)this.logManager().directoryId(logFile.getParent()).equals((Object)DirectoryId.random()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            scala.collection.immutable.Set x$1 = Predef$.MODULE$.Set().empty();
            Function1 x$2 = qual$1.startup$default$2();
            qual$1.startup((Set)x$1, x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$3 = new TopicPartition(this.name(), 0);
            None$ x$4 = None$.MODULE$;
            boolean x$5 = qual$2.getOrCreateLog$default$2();
            boolean x$6 = qual$2.getOrCreateLog$default$3();
            Option x$7 = qual$2.getOrCreateLog$default$5();
            UnifiedLog log1 = qual$2.getOrCreateLog(x$3, x$5, x$6, (Option)x$4, x$7);
            LogManager qual$3 = (LogManager)logManagerForTest.get();
            TopicPartition x$8 = new TopicPartition(this.name(), 1);
            None$ x$9 = None$.MODULE$;
            boolean x$10 = qual$3.getOrCreateLog$default$2();
            boolean x$11 = qual$3.getOrCreateLog$default$3();
            Option x$12 = qual$3.getOrCreateLog$default$5();
            UnifiedLog log2 = qual$3.getOrCreateLog(x$8, x$10, x$11, (Option)x$9, x$12);
            File logFile1 = new File(logDir1, this.name() + "-0");
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, this.name() + "-1").exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown(3L);
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((LogManager)logManagerForTest.get()).readBrokerEpochFromCleanShutdownFiles());
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCleanShutdownFileWithBrokerEpoch() {
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            scala.collection.immutable.Set x$1 = Predef$.MODULE$.Set().empty();
            Function1 x$2 = qual$1.startup$default$2();
            qual$1.startup((Set)x$1, x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$3 = new TopicPartition(this.name(), 0);
            None$ x$4 = None$.MODULE$;
            boolean x$5 = qual$2.getOrCreateLog$default$2();
            boolean x$6 = qual$2.getOrCreateLog$default$3();
            Option x$7 = qual$2.getOrCreateLog$default$5();
            qual$2.getOrCreateLog(x$3, x$5, x$6, (Option)x$4, x$7);
            LogManager qual$3 = (LogManager)logManagerForTest.get();
            TopicPartition x$8 = new TopicPartition(this.name(), 1);
            None$ x$9 = None$.MODULE$;
            boolean x$10 = qual$3.getOrCreateLog$default$2();
            boolean x$11 = qual$3.getOrCreateLog$default$3();
            Option x$12 = qual$3.getOrCreateLog$default$5();
            qual$3.getOrCreateLog(x$8, x$10, x$11, (Option)x$9, x$12);
            Assertions.assertTrue((boolean)new File(logDir1, this.name() + "-0").exists());
            Assertions.assertTrue((boolean)new File(logDir2, this.name() + "-1").exists());
            ((LogManager)logManagerForTest.get()).shutdown(3L);
            Assertions.assertTrue((boolean)Files.exists(new File(logDir1, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
            Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)((LogManager)logManagerForTest.get()).readBrokerEpochFromCleanShutdownFiles());
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testCleanShutdownFileWithBrokerEpoch$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete() {
        TopicPartition topicPartition0 = new TopicPartition(this.name(), 0);
        TopicPartition topicPartition1 = new TopicPartition(this.name(), 1);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log0 = qual$1.getOrCreateLog(topicPartition0, x$3, x$4, (Option)x$2, x$5);
        LogManager qual$2 = this.logManager();
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        boolean x$9 = qual$2.getOrCreateLog$default$3();
        Option x$10 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log1 = qual$2.getOrCreateLog(topicPartition1, x$8, x$9, (Option)x$7, x$10);
        File logFile0 = new File(this.logDir(), this.name() + "-0");
        File logFile1 = new File(this.logDir(), this.name() + "-1");
        Assertions.assertTrue((boolean)logFile0.exists());
        Assertions.assertTrue((boolean)logFile1.exists());
        log0.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        log0.takeProducerSnapshot();
        log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
        log1.takeProducerSnapshot();
        LogManager qual$3 = this.logManager();
        long x$11 = qual$3.shutdown$default$1();
        qual$3.shutdown(x$11);
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), ".kafka_cleanshutdown").toPath()));
        VolatileIntRef loadLogCalled = VolatileIntRef.create((int)0);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1)));
        ((LogManager)Mockito.doAnswer(invocation -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(loadLogCalled, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.logManager())).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (java.util.Map)ArgumentMatchers.any(), (java.util.Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any());
        new Thread(this){
            private final /* synthetic */ LogManagerTest $outer;

            public void run() {
                LogManager qual$1 = this.$outer.logManager();
                scala.collection.immutable.Set x$1 = Predef$.MODULE$.Set().empty();
                Function1 x$2 = qual$1.startup$default$2();
                qual$1.startup((Set)x$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(loadLogCalled.elem == 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for only the first log to be loaded");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$4 = this.logManager();
        long x$12 = qual$4.shutdown$default$1();
        qual$4.shutdown(x$12);
        this.logManager_$eq(null);
        Assertions.assertFalse((boolean)Files.exists(new File(this.logDir(), ".kafka_cleanshutdown").toPath(), new LinkOption[0]));
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        LogManager qual$2 = this.logManager();
        scala.collection.immutable.Set x$2 = Predef$.MODULE$.Set().empty();
        Function1 x$3 = qual$2.startup$default$2();
        qual$2.startup((Set)x$2, x$3);
        LogManager qual$3 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$3.getOrCreateLog$default$3();
        Option x$8 = qual$3.getOrCreateLog$default$5();
        UnifiedLog log = qual$3.getOrCreateLog(x$4, true, x$7, (Option)x$6, x$8);
        Assertions.assertTrue((boolean)new File(this.logDir(), this.name() + "-0").exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$3 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$3))).map((Function1 & Serializable)x$4 -> this.logDir().toPath().resolve((String)x$4).toFile());
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1)));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        LogManager qual$2 = this.logManager();
        scala.collection.immutable.Set x$2 = Predef$.MODULE$.Set().empty();
        Function1 x$32 = qual$2.startup$default$2();
        qual$2.startup((Set)x$2, x$32);
        LogManager qual$3 = this.logManager();
        TopicPartition x$42 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$3.getOrCreateLog$default$3();
        Option x$8 = qual$3.getOrCreateLog$default$5();
        qual$3.getOrCreateLog(x$42, true, x$7, (Option)x$6, x$8);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), this.name() + "-0").exists());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupExpiredSegments() {
        void readLog_maxLength;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$52 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$52);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().forEach(s -> s.log().file().setLastModified(this.time().milliseconds()));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        log.logSegments().forEach(s -> {
            s.offsetIndex();
            s.timeIndex();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read((long)readLog_offset, (int)readLog_maxLength, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            void readLog_maxLength;
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, (int)readLog_maxLength, FetchIsolation.LOG_END, true);
        }, () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupSegmentsToMaintainSize() {
        void readLog_maxLength;
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2).sizeInBytes();
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4));
        LogManager qual$2 = this.logManager();
        scala.collection.immutable.Set x$5 = Predef$.MODULE$.Set().empty();
        Function1 x$62 = qual$2.startup$default$2();
        qual$2.startup((Set)x$5, x$62);
        LogManager qual$3 = this.logManager();
        TopicPartition x$7 = new TopicPartition(this.name(), 0);
        None$ x$8 = None$.MODULE$;
        boolean x$9 = qual$3.getOrCreateLog$default$2();
        boolean x$10 = qual$3.getOrCreateLog$default$3();
        Option x$11 = qual$3.getOrCreateLog$default$5();
        UnifiedLog log = qual$3.getOrCreateLog(x$7, x$9, x$10, (Option)x$8, x$11);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = info.firstOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().initialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read((long)readLog_offset, (int)readLog_maxLength, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            void readLog_maxLength;
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, (int)readLog_maxLength, FetchIsolation.LOG_END, true);
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs("compact,delete");
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs("compact");
    }

    private void testDoesntCleanLogs(String policy) {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "cleanup.policy", policy);
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$72 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Option x$9 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log = qual$2.getOrCreateLog(x$5, x$72, x$8, (Option)x$6, x$9);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().forEach(s -> s.log().file().setLastModified(this.time().milliseconds()));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "flush.ms", "1000");
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4));
        LogManager qual$2 = this.logManager();
        scala.collection.immutable.Set x$5 = Predef$.MODULE$.Set().empty();
        Function1 x$6 = qual$2.startup$default$2();
        qual$2.startup((Set)x$5, x$6);
        LogManager qual$3 = this.logManager();
        TopicPartition x$7 = new TopicPartition(this.name(), 0);
        None$ x$82 = None$.MODULE$;
        boolean x$9 = qual$3.getOrCreateLog$default$2();
        boolean x$10 = qual$3.getOrCreateLog$default$3();
        Option x$11 = qual$3.getOrCreateLog$default$5();
        UnifiedLog log = qual$3.getOrCreateLog(x$7, x$9, x$10, (Option)x$82, x$11);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable)x$8 -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)x$8)));
        this.time().sleep(this.logManager().initialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$2 = this.logManager();
            TopicPartition x$2 = new TopicPartition("test", partition);
            None$ x$3 = None$.MODULE$;
            boolean x$4 = qual$2.getOrCreateLog$default$2();
            boolean x$5 = qual$2.getOrCreateLog$default$3();
            Option x$6 = qual$2.getOrCreateLog$default$5();
            qual$2.getOrCreateLog(x$2, x$4, x$5, (Option)x$3, x$6);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable)x$9 -> x$9.dir().getParent()).values().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()));
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testLoadLogsSkipRemoteIndexCache() {
        File logDir = TestUtils.tempDirectory(null, null);
        new File(logDir, "remote-log-index-cache").mkdir();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        this.logManager().loadLogs(this.logConfig(), (Map)Map$.MODULE$.empty(), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLoadLogsSkipRemoteIndexCache$1(x$11)));
    }

    @Test
    public void testLoadLogRenameLogThatShouldBeStray() {
        IntRef invokedCount = IntRef.create((int)0);
        File logDir = TestUtils.tempDirectory(null, null);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        String testTopic = "test-stray-topic";
        TopicPartition testTopicPartition = new TopicPartition(testTopic, 0);
        LogManager qual$1 = this.logManager();
        Some x$2 = new Some((Object)Uuid.randomUuid());
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log2 = qual$1.getOrCreateLog(testTopicPartition, x$3, x$4, (Option)x$2, x$5);
        this.logManager().loadLog(log2.dir(), true, Collections.emptyMap(), Collections.emptyMap(), this.logConfig(), (Map)Map$.MODULE$.empty(), new ConcurrentHashMap(), (Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.providedIsStray$1(log, invokedCount)));
        Assertions.assertEquals((int)1, (int)invokedCount.elem);
        Assertions.assertTrue((boolean)Predef$.MODULE$.wrapRefArray((Object[])logDir.listFiles()).toSet().exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLoadLogRenameLogThatShouldBeStray$2(testTopic, f))));
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(TestUtils.tempDirectory(null, null).getAbsolutePath() + File.separator), (List)Nil$.MODULE$), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), new MockTime(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false, 30000L));
        LogManager qual$2 = this.logManager();
        scala.collection.immutable.Set x$2 = Predef$.MODULE$.Set().empty();
        Function1 x$3 = qual$2.startup$default$2();
        qual$2.startup((Set)x$2, x$3);
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), new MockConfigRepository(), 1));
        LogManager qual$2 = this.logManager();
        scala.collection.immutable.Set x$2 = Predef$.MODULE$.Set().empty();
        Function1 x$3 = qual$2.startup$default$2();
        qual$2.startup((Set)x$2, x$3);
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$12 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            Option x$5 = logManager.getOrCreateLog$default$5();
            return logManager.getOrCreateLog(x$12, x$3, x$4, (Option)x$2, x$5);
        });
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        java.util.Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        long x$6 = this.initialTaskDelayMs();
        CleanerConfig x$7 = new CleanerConfig(false);
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        boolean x$10 = false;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, configRepository, x$7, x$4, recoveryThreadsPerDataDir, x$8, (Option<UnifiedLog>)x$9, x$10, x$6);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        Object[] indexFilesOnDiskBeforeDelete = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$14)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$6 = new TopicPartition(this.name(), 0);
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        boolean x$9 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$6, x$7, x$8, x$9).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.offsetIndexFile(), (List)new .colon.colon((Object)removedSegment.timeIndexFile(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.offsetIndexFile());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.timeIndexFile());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFilesOnDiskBeforeDelete), arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((scala.collection.immutable.Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep(this.logManager().initialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs - this.logManager().initialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        LogManager qual$2 = this.logManager();
        TopicPartition x$6 = new TopicPartition(invalidTopicName, 0);
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        boolean x$9 = qual$2.asyncDelete$default$4();
        qual$2.asyncDelete(x$6, x$7, x$8, x$9);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$17 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            Option x$5 = qual$1.getOrCreateLog$default$5();
            return qual$1.getOrCreateLog(x$17, x$3, x$4, (Option)x$2, x$5);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        java.util.Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, FetchIsolation.LOG_END, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, spyConfigRepository, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, spyConfigRepository, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, spyConfigRepository, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        MockConfigRepository x$2 = new MockConfigRepository();
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, x$2, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put("cleanup.policy", "compact");
        LogConfig oldLogConfig = LogConfig.fromProps((java.util.Map)this.logConfig().originals(), (Properties)oldProperties);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = spyLogManager.getOrCreateLog$default$2();
        boolean x$8 = spyLogManager.getOrCreateLog$default$3();
        Option x$9 = spyLogManager.getOrCreateLog$default$5();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$7, x$8, (Option)x$6, x$9);
        log0.updateConfig(oldLogConfig);
        None$ x$11 = None$.MODULE$;
        boolean x$12 = spyLogManager.getOrCreateLog$default$2();
        boolean x$13 = spyLogManager.getOrCreateLog$default$3();
        Option x$14 = spyLogManager.getOrCreateLog$default$5();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$12, x$13, (Option)x$11, x$14);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put("cleanup.policy", "delete");
        spyLogManager.updateTopicConfig(topic, newProperties, false, false);
        Assertions.assertTrue((boolean)log0.config().delete);
        Assertions.assertTrue((boolean)log1.config().delete);
        Assertions.assertFalse((boolean)log0.config().compact);
        Assertions.assertFalse((boolean)log1.config().compact);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, this.name() + "-" + partitionId);
        int segmentBytes = 1024;
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, (Scheduler)time.scheduler, (Time)time, 0L, 0L, 300000, new ProducerStateManagerConfig(86400000, false), 600000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)x$19 -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, scala.collection.immutable.Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Integer> mockMap, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable)num -> num + 1)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)capturedNumRemainingSegments.capture())));
        logSegmentMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$4 = new MockConfigRepository();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$4, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = LocalLog.parseTopicPartitionName((File)dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable)() -> this.logConfig());
            ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(300000, false);
            Scheduler x$12 = (Scheduler)Mockito.mock(Scheduler.class);
            LogDirFailureChannel x$15 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            None$ x$17 = None$.MODULE$;
            boolean x$20 = false;
            LogOffsetsListener x$21 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, x$12, mockBrokerTopicStats, (Time)mockTime, 300000, x$10, 600000, x$15, false, (Option)x$17, false, (ConcurrentMap)mockMap, x$20, x$21);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (java.util.Map)ArgumentMatchers.any(), (java.util.Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty(), spyLogManager.startup$default$2());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (scala.collection.immutable.Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$4 = new MockConfigRepository();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$4, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty(), spyLogManager.startup$default$2());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = "topic=" + tp.topic() + ",partition=" + tp.partition();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2, x$5);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        boolean x$9 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$7, x$8, x$9).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$11 = None$.MODULE$;
        boolean x$12 = qual$3.getOrCreateLog$default$2();
        boolean x$13 = qual$3.getOrCreateLog$default$3();
        Option x$14 = qual$3.getOrCreateLog$default$5();
        qual$3.getOrCreateLog(tp, x$12, x$13, (Option)x$11, x$14);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils.tempDirectory(null, null);
        File dir2 = TestUtils.tempDirectory(null, null);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$1 = Predef$.MODULE$.Set().empty();
        Function1 x$2 = qual$1.startup$default$2();
        qual$1.startup((Set)x$1, x$2);
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = "topic=" + tp.topic() + ",partition=" + tp.partition();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        None$ x$4 = None$.MODULE$;
        boolean x$5 = qual$2.getOrCreateLog$default$2();
        boolean x$6 = qual$2.getOrCreateLog$default$3();
        Option x$7 = qual$2.getOrCreateLog$default$5();
        qual$2.getOrCreateLog(tp, x$5, x$6, (Option)x$4, x$7);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$3 = this.logManager();
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$3.getOrCreateLog$default$2();
        Option x$12 = qual$3.getOrCreateLog$default$5();
        qual$3.getOrCreateLog(tp, x$11, true, (Option)x$10, x$12);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$3(topicName).count((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(m))));
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    @Test
    public void testWaitForAllToComplete() {
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$20 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$20)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$21 -> {
            ++invokedCount$2.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Assertions.assertFalse((new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$22 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$22);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$23 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$23);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertTrue((new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$24 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$24);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$25 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$25);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    @Test
    public void testLoadDirectoryIds() {
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(5, (Function0 & Serializable)() -> TestUtils$.MODULE$.tempDir());
        this.writeMetaProperties((File)dirs.head(), this.writeMetaProperties$default$2());
        this.writeMetaProperties((File)dirs.apply(1), Optional.of(Uuid.fromString((String)"ZwkGXjB0TvSF6mjVh6gO7Q")));
        this.writeMetaProperties((File)dirs.apply(3), Optional.of(Uuid.fromString((String)"kQfNPJ2FTHq_6Qlyyv6Jqg")));
        this.writeMetaProperties((File)dirs.apply(4), this.writeMetaProperties$default$2());
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1));
        Assertions.assertFalse((boolean)this.logManager().directoryId(((File)dirs.head()).getAbsolutePath()).isDefined());
        Assertions.assertTrue((boolean)this.logManager().directoryId(((File)dirs.apply(1)).getAbsolutePath()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)Uuid.fromString((String)"ZwkGXjB0TvSF6mjVh6gO7Q")), (Object)this.logManager().directoryId(((File)dirs.apply(1)).getAbsolutePath()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.logManager().directoryId(((File)dirs.apply(2)).getAbsolutePath()));
        Assertions.assertEquals((Object)new Some((Object)Uuid.fromString((String)"kQfNPJ2FTHq_6Qlyyv6Jqg")), (Object)this.logManager().directoryId(((File)dirs.apply(3)).getAbsolutePath()));
        Assertions.assertTrue((boolean)this.logManager().directoryId(((File)dirs.apply(3)).getAbsolutePath()).isDefined());
        Assertions.assertEquals((int)2, (int)this.logManager().directoryIdsSet().size());
    }

    @Test
    public void testCheckpointLogStartOffsetForRemoteTopic() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        Properties props = new Properties();
        props.putAll((java.util.Map<?, ?>)this.logProps());
        props.put("remote.storage.enable", "true");
        LogConfig logConfig = new LogConfig((java.util.Map)props);
        MockConfigRepository x$3 = new MockConfigRepository();
        .colon.colon x$4 = new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
        MockTime x$5 = this.time();
        CleanerConfig x$8 = new CleanerConfig(false);
        boolean x$9 = false;
        None$ x$10 = None$.MODULE$;
        long x$11 = 30000L;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$4, logConfig, x$3, x$8, x$5, 1, x$9, (Option<UnifiedLog>)x$10, true, x$11));
        File checkpointFile = new File(this.logDir(), LogManager$.MODULE$.LogStartOffsetCheckpointFile());
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(checkpointFile, null);
        TopicPartition topicPartition = new TopicPartition("test", 0);
        LogManager qual$2 = this.logManager();
        None$ x$13 = None$.MODULE$;
        boolean x$14 = qual$2.getOrCreateLog$default$2();
        boolean x$15 = qual$2.getOrCreateLog$default$3();
        Option x$16 = qual$2.getOrCreateLog$default$5();
        UnifiedLog log = qual$2.getOrCreateLog(topicPartition, x$14, x$15, (Option)x$13, x$16);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$26 -> LogManagerTest.$anonfun$testCheckpointLogStartOffsetForRemoteTopic$1(log, offset, BoxesRunTime.unboxToInt((Object)x$26)));
        Assertions.assertEquals((int)5, (int)log.logSegments().size());
        log.updateHighWatermark(49L);
        log.updateHighestOffsetInRemoteStorage(30L);
        log.maybeIncrementLocalLogStartOffset(31L, LogStartOffsetIncrementReason.SegmentDeletion);
        log.deleteOldSegments();
        Assertions.assertEquals((int)2, (int)log.logSegments().size());
        long logStartOffset = 21L;
        log.maybeIncrementLogStartOffset(logStartOffset, LogStartOffsetIncrementReason.SegmentDeletion);
        this.logManager().checkpointLogStartOffsets();
        Assertions.assertEquals((long)logStartOffset, (long)log.logStartOffset());
        Assertions.assertEquals((long)logStartOffset, (Long)checkpoint.read().getOrDefault(topicPartition, Predef$.MODULE$.long2Long(-1L)));
    }

    @Test
    public void testCheckpointLogStartOffsetForNormalTopic() {
        File checkpointFile = new File(this.logDir(), LogManager$.MODULE$.LogStartOffsetCheckpointFile());
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(checkpointFile, null);
        TopicPartition topicPartition = new TopicPartition("test", 0);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        Option x$5 = qual$1.getOrCreateLog$default$5();
        UnifiedLog log = qual$1.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$5);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$27 -> LogManagerTest.$anonfun$testCheckpointLogStartOffsetForNormalTopic$1(log, offset, BoxesRunTime.unboxToInt((Object)x$27)));
        Assertions.assertEquals((int)5, (int)log.logSegments().size());
        log.updateHighWatermark(49L);
        long logStartOffset = 31L;
        log.maybeIncrementLogStartOffset(logStartOffset, LogStartOffsetIncrementReason.SegmentDeletion);
        this.logManager().checkpointLogStartOffsets();
        Assertions.assertEquals((int)5, (int)log.logSegments().size());
        Assertions.assertEquals((long)logStartOffset, (Long)checkpoint.read().getOrDefault(topicPartition, Predef$.MODULE$.long2Long(-1L)));
        log.deleteOldSegments();
        Assertions.assertEquals((int)2, (int)log.logSegments().size());
        Assertions.assertEquals((long)logStartOffset, (long)log.logStartOffset());
        this.logManager().checkpointLogStartOffsets();
        Assertions.assertEquals((long)-1L, (Long)checkpoint.read().getOrDefault(topicPartition, Predef$.MODULE$.long2Long(-1L)));
    }

    public void writeMetaProperties(File dir, Optional<Uuid> directoryId) {
        PropertiesUtils.writePropertiesFile((Properties)new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V0).setClusterId("IVT1Seu3QjacxS7oBTKhDQ").setNodeId(1).setDirectoryId(directoryId).build().toProperties(), (String)new File(dir, "meta.properties").getAbsolutePath(), (boolean)false);
    }

    public Optional<Uuid> writeMetaProperties$default$2() {
        return Optional.empty();
    }

    public TopicIdPartition foo0() {
        return this.foo0;
    }

    public TopicIdPartition foo1() {
        return this.foo1;
    }

    public TopicIdPartition bar0() {
        return this.bar0;
    }

    public TopicIdPartition bar1() {
        return this.bar1;
    }

    public TopicIdPartition baz0() {
        return this.baz0;
    }

    public TopicIdPartition baz1() {
        return this.baz1;
    }

    public TopicIdPartition baz2() {
        return this.baz2;
    }

    public TopicIdPartition quux0() {
        return this.quux0;
    }

    public TopicIdPartition recreatedFoo0() {
        return this.recreatedFoo0;
    }

    public TopicIdPartition recreatedFoo1() {
        return this.recreatedFoo1;
    }

    @Test
    public void testIsStrayKraftReplicaWithEmptyImage() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)Nil$.MODULE$);
        Assertions.assertTrue((boolean)((scala.collection.immutable.Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$))))).map((Function1 & Serializable)topicIdPartition -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)topicIdPartition))).forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManager$.MODULE$.isStrayKraftReplica(0, image, log))));
    }

    @Test
    public void testIsStrayKraftReplicaInImage() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.foo0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar1()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)Nil$.MODULE$)));
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$))))).map((Function1 & Serializable)topicIdPartition -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)topicIdPartition));
        scala.collection.immutable.Set expectedStrays = (scala.collection.immutable.Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo1(), this.quux0()}))).map((Function1 & Serializable)x$28 -> x$28.topicPartition());
        onDisk.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testIsStrayKraftReplicaInImage$3(expectedStrays, image, log);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIsStrayKraftReplicaInImageWithRemoteReplicas() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.foo0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, scala.collection.immutable.Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar0()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar1()), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})))), (List)Nil$.MODULE$)));
        scala.collection.immutable.Seq onDisk = (scala.collection.immutable.Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)Nil$.MODULE$))).map((Function1 & Serializable)topicIdPartition -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)topicIdPartition));
        scala.collection.immutable.Set expectedStrays = (scala.collection.immutable.Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.bar0()}))).map((Function1 & Serializable)x$29 -> x$29.topicPartition());
        onDisk.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testIsStrayKraftReplicaInImageWithRemoteReplicas$3(expectedStrays, image, log);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIsStrayKraftMissingTopicId() {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)Option$.MODULE$.empty());
        Assertions.assertTrue((boolean)LogManager$.MODULE$.isStrayKraftReplica(0, LogManagerTest$.MODULE$.topicsImage((scala.collection.immutable.Seq<TopicImage>)Nil$.MODULE$), log));
    }

    @Test
    public void testLock() {
        File tmpLogDir = TestUtils.tempDirectory(null, null);
        LogManager tmpLogManager = this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)tmpLogDir, (List)Nil$.MODULE$), new MockConfigRepository(), 1);
        try {
            Assertions.assertFalse((boolean)new FileLock(new File(tmpLogDir, LogManager$.MODULE$.LockFileName())).tryLock());
        }
        finally {
            tmpLogManager.shutdown(tmpLogManager.shutdown$default$1());
            Assertions.assertFalse((boolean)new File(tmpLogDir, LogManager$.MODULE$.LockFileName()).exists());
        }
    }

    @Test
    public void testShutdownWithZeroFileDeleteDelayMs() {
        File tmpLogDir = TestUtils.tempDirectory(null, null);
        Properties tmpProperties = new Properties();
        tmpProperties.put("file.delete.delay.ms", "0");
        KafkaScheduler scheduler = new KafkaScheduler(1, true, "log-manager-test");
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)new .colon.colon((Object)tmpLogDir, (List)Nil$.MODULE$).map((Function1 & Serializable)x$30 -> x$30.getAbsoluteFile());
        ArraySeq.ofRef x$2 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        MockConfigRepository x$3 = new MockConfigRepository();
        LogConfig x$4 = new LogConfig((java.util.Map)tmpProperties);
        CleanerConfig x$5 = new CleanerConfig(false);
        ProducerStateManagerConfig x$12 = new ProducerStateManagerConfig(86400000, false);
        Time x$15 = Time.SYSTEM;
        BrokerTopicStats x$16 = new BrokerTopicStats();
        LogDirFailureChannel x$17 = new LogDirFailureChannel(1);
        LogManager tmpLogManager = new LogManager((Seq)x$1, (Seq)x$2, (ConfigRepository)x$3, x$4, x$5, 1, 1000L, 10000L, 10000L, 1000L, 300000, x$12, 600000, (Scheduler)scheduler, x$16, x$17, x$15, true, false, 0L);
        scheduler.startup();
        tmpLogManager.startup((Set)Predef$.MODULE$.Set().empty(), tmpLogManager.startup$default$2());
        Executable stopLogManager = () -> tmpLogManager.shutdown(tmpLogManager.shutdown$default$1());
        Executable stopScheduler = () -> scheduler.shutdown();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(5000L), (Executable)stopLogManager);
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(5000L), (Executable)stopScheduler);
    }

    @Test
    public void testInvalidLogDirNotFailLogManager() {
        LogManager qual$1 = this.logManager();
        long x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        java.util.Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(this.logDir().toPath(), new LinkOption[0]);
        permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
        permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
        permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
        Files.setPosixFilePermissions(this.logDir().toPath(), permissions);
        try {
            this.logManager_$eq((LogManager)Assertions.assertDoesNotThrow(() -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1)));
            Assertions.assertEquals((int)0, (int)this.logManager().dirLocks().size());
        }
        finally {
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.GROUP_WRITE);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            Files.setPosixFilePermissions(this.logDir().toPath(), permissions);
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWithBrokerEpoch$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWithBrokerEpoch$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWithBrokerEpoch$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(VolatileIntRef loadLogCalled$1, InvocationOnMock invocation) {
        Thread.sleep(5000L);
        UnifiedLog cfr_ignored_0 = (UnifiedLog)invocation.callRealMethod();
        ++loadLogCalled$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(VolatileIntRef loadLogCalled$1) {
        return loadLogCalled$1.elem == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3() {
        return "Timed out waiting for only the first log to be loaded";
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$3) {
        return Integer.toString(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, $this.name() + "-0").exists();
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int x$8) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$testLoadLogsSkipRemoteIndexCache$1(UnifiedLog x$11) {
        return false;
    }

    private static final boolean providedIsStray$1(UnifiedLog log, IntRef invokedCount$1) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testLoadLogRenameLogThatShouldBeStray$2(String testTopic$1, File f) {
        return f.getName().startsWith(testTopic$1) && f.getName().endsWith(UnifiedLog$.MODULE$.StrayDirSuffix());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$13 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(java.util.Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((Long)((Long)checkpoints$1.get(tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$14) {
        return x$14.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$15) {
        String string = x$15.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$15)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable)x$16 -> x$16.getName()), (String)("Could not find index file " + fileBeforeDelete.getName() + " in indexFilesAfterDelete"));
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$18 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(java.util.Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((Long)((Long)checkpoints$2.get(tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, x$2, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String logManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$1);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingLogsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String logManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$2);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingSegmentsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                    return;
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$1, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(MetricName m) {
        return m.getMBeanName().contains("is-future");
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$2, InvocationOnMock x$20) {
        ++invokedCount$2.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$22) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$23) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$24) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$25) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ Object $anonfun$testCheckpointLogStartOffsetForRemoteTopic$1(UnifiedLog log$8, LongRef offset$4, int x$26) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2);
        LogAppendInfo info = log$8.appendAsLeader(set, 0, log$8.appendAsLeader$default$3(), log$8.appendAsLeader$default$4(), log$8.appendAsLeader$default$5());
        offset$4.elem = info.lastOffset();
        if (offset$4.elem != 0L && offset$4.elem % 10L == 0L) {
            return log$8.roll(log$8.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCheckpointLogStartOffsetForNormalTopic$1(UnifiedLog log$9, LongRef offset$5, int x$27) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2);
        LogAppendInfo info = log$9.appendAsLeader(set, 0, log$9.appendAsLeader$default$3(), log$9.appendAsLeader$default$4(), log$9.appendAsLeader$default$5());
        offset$5.elem = info.lastOffset();
        if (offset$5.elem != 0L && offset$5.elem % 10L == 0L) {
            return log$9.roll(log$9.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testIsStrayKraftReplicaInImage$3(scala.collection.immutable.Set expectedStrays$1, TopicsImage image$2, UnifiedLog log) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedStrays$1.contains((Object)log.topicPartition())), (Object)BoxesRunTime.boxToBoolean((boolean)LogManager$.MODULE$.isStrayKraftReplica(0, image$2, log)));
    }

    public static final /* synthetic */ void $anonfun$testIsStrayKraftReplicaInImageWithRemoteReplicas$3(scala.collection.immutable.Set expectedStrays$2, TopicsImage image$3, UnifiedLog log) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedStrays$2.contains((Object)log.topicPartition())), (Object)BoxesRunTime.boxToBoolean((boolean)LogManager$.MODULE$.isStrayKraftReplica(0, image$3, log)));
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(4096));
        this.logProps().put("retention.ms", Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
        this.initialTaskDelayMs = 10000L;
        this.foo0 = new TopicIdPartition(Uuid.fromString((String)"Sl08ZXU2QW6uF5hIoSzc8w"), new TopicPartition("foo", 0));
        this.foo1 = new TopicIdPartition(Uuid.fromString((String)"Sl08ZXU2QW6uF5hIoSzc8w"), new TopicPartition("foo", 1));
        this.bar0 = new TopicIdPartition(Uuid.fromString((String)"69O438ZkTSeqqclTtZO2KA"), new TopicPartition("bar", 0));
        this.bar1 = new TopicIdPartition(Uuid.fromString((String)"69O438ZkTSeqqclTtZO2KA"), new TopicPartition("bar", 1));
        this.baz0 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 0));
        this.baz1 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 1));
        this.baz2 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 2));
        this.quux0 = new TopicIdPartition(Uuid.fromString((String)"YS9owjv5TG2OlsvBM0Qw6g"), new TopicPartition("quux", 0));
        this.recreatedFoo0 = new TopicIdPartition(Uuid.fromString((String)"_dOOzPe3TfiWV21Lh7Vmqg"), new TopicPartition("foo", 0));
        this.recreatedFoo1 = new TopicIdPartition(Uuid.fromString((String)"_dOOzPe3TfiWV21Lh7Vmqg"), new TopicPartition("foo", 1));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

