/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.network.RequestChannel;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.network.RequestConvertToJson;
import org.apache.kafka.network.Session;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005M3Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u0001_!)A\t\u0001C\u0005\u000b\nA\"+Z9vKN$8i\u001c8wKJ$Hk\u001c&t_:$Vm\u001d;\u000b\u0005%Q\u0011a\u00028fi^|'o\u001b\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011\u0001C\u0001\u0016i\u0016\u001cHOU3rk\u0016\u001cH\u000fS3bI\u0016\u0014hj\u001c3f)\u0005Q\u0002CA\b\u001c\u0013\ta\u0002C\u0001\u0003V]&$\bF\u0001\u0002\u001f!\ty\u0002&D\u0001!\u0015\t\t#%A\u0002ba&T!a\t\u0013\u0002\u000f),\b/\u001b;fe*\u0011QEJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002O\u0005\u0019qN]4\n\u0005%\u0002#\u0001\u0002+fgR\fq\u0002^3tiJ+\u0017/^3ti\u0012+7o\u0019\u0015\u0003\u0007y\ta\u0003^3tiJ+\u0017/^3ti\u0012+7oY'fiJL7m\u001d\u0015\u0003\ty\tqA]3rk\u0016\u001cH\u000f\u0006\u00021oA\u0011\u0011\u0007\u000e\b\u0003/IJ!a\r\u0005\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011QG\u000e\u0002\b%\u0016\fX/Z:u\u0015\t\u0019\u0004\u0002C\u00039\u000b\u0001\u0007\u0011(A\u0002sKF\u0004\"A\u000f\"\u000e\u0003mR!\u0001P\u001f\u0002\u0011I,\u0017/^3tiNT!AP \u0002\r\r|W.\\8o\u0015\tY\u0001I\u0003\u0002BM\u00051\u0011\r]1dQ\u0016L!aQ\u001e\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\f\u0011C\\3x%\u0016\fX/Z:u\u0007>tG/\u001a=u)\t1\u0015\n\u0005\u0002;\u000f&\u0011\u0001j\u000f\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u0015Qe\u00011\u0001L\u0003\u0019\u0011WO\u001a4feB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0004]&|'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%6\u0013!BQ=uK\n+hMZ3s\u0001")
public class RequestConvertToJsonTest {
    @Test
    public void testRequestHeaderNode() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), ApiKeys.ALTER_PARTITION.latestVersion());
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson.requestHeaderNode((RequestHeader)header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), ApiKeys.ALTER_PARTITION.latestVersion());
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson.requestHeaderNode((RequestHeader)req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson.requestDesc((RequestHeader)req.header(), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(req.requestLog())), (boolean)req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), ApiKeys.ALTER_PARTITION.latestVersion());
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        NetworkSend send = new NetworkSend(req.context().connectionId, alterIsrRequest.toSend(req.header()));
        JsonNode headerLog = RequestConvertToJson.requestHeaderNode((RequestHeader)req.header());
        RequestChannel.SendResponse res = new RequestChannel.SendResponse(req, (Send)send, (Option)new Some((Object)headerLog), (Option)None$.MODULE$);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int temporaryMemoryBytes = 8;
        int messageConversionsTimeMs = 9;
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson.requestDesc((RequestHeader)req.header(), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(req.requestLog())), (boolean)req.isForwarded());
        expectedNode.set("response", (JsonNode)res.responseLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)new TextNode(req.session().principal.toString()));
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson.clientInfoNode((ClientInformation)req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson.requestDescMetrics((RequestHeader)req.header(), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(req.requestLog())), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(res.responseLog())), (RequestContext)req.context(), (Session)req.session(), (boolean)req.isForwarded(), (double)((double)totalTimeMs), (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class), (Option)None$.MODULE$);
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }
}

