/*
 * Decompiled with CFR 0.152.
 */
package kafka.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class JaasModule {
    private final String name;
    private final boolean debug;
    private final Map<String, String> entries;

    public static JaasModule krb5LoginModule(boolean useKeyTab, boolean storeKey, String keyTab, String principal, boolean debug, Optional<String> serviceName, boolean isIbmSecurity) {
        String name = isIbmSecurity ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        HashMap<String, String> entries = new HashMap<String, String>();
        if (isIbmSecurity) {
            entries.put("principal", principal);
            entries.put("credsType", "both");
            if (useKeyTab) {
                entries.put("useKeytab", "file:" + keyTab);
            }
        } else {
            entries.put("useKeyTab", Boolean.toString(useKeyTab));
            entries.put("storeKey", Boolean.toString(storeKey));
            entries.put("keyTab", keyTab);
            entries.put("principal", principal);
            serviceName.ifPresent(s -> entries.put("serviceName", (String)s));
        }
        return new JaasModule(name, debug, entries);
    }

    public static JaasModule oAuthBearerLoginModule(String username, boolean debug) {
        String name = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule";
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("unsecuredLoginStringClaim_sub", username);
        return new JaasModule(name, debug, entries);
    }

    public static JaasModule plainLoginModule(String username, String password) {
        return JaasModule.plainLoginModule(username, password, false, Collections.emptyMap());
    }

    public static JaasModule plainLoginModule(String username, String password, boolean debug, Map<String, String> validUsers) {
        String name = "org.apache.kafka.common.security.plain.PlainLoginModule";
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("username", username);
        entries.put("password", password);
        validUsers.forEach((user, pass) -> entries.put("user_" + user, (String)pass));
        return new JaasModule(name, debug, entries);
    }

    public static JaasModule scramLoginModule(String username, String password) {
        return JaasModule.scramLoginModule(username, password, false, Collections.emptyMap());
    }

    public static JaasModule scramLoginModule(String username, String password, boolean debug, Map<String, String> tokenProps) {
        String name = "org.apache.kafka.common.security.scram.ScramLoginModule";
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("username", username);
        entries.put("password", password);
        entries.putAll(tokenProps);
        return new JaasModule(name, debug, entries);
    }

    private JaasModule(String name, boolean debug, Map<String, String> entries) {
        this.name = name;
        this.debug = debug;
        this.entries = entries;
    }

    public String name() {
        return this.name;
    }

    public boolean debug() {
        return this.debug;
    }

    public String toString() {
        return String.format("%s required\n  debug=%b\n  %s;\n", this.name, this.debug, this.entries.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").collect(Collectors.joining("\n  ")));
    }
}

