/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t%f\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001A\u0002\u0013E\u0001\bC\u0004F\u0001\u0001\u0007I\u0011\u0003$\t\r=\u0003\u0001\u0015)\u0003:\u0011\u0015\u0001\u0006\u0001\"\u00159\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u001d!\bA1A\u0005\nUDa\u0001 \u0001!\u0002\u00131\bbB?\u0001\u0005\u0004%I!\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002<\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0005\u0001A\u0003%\u00111\u0001\u0005\n\u0003+\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0006\u0001A\u0003%\u00111\u0001\u0005\n\u00033\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0007\u0001A\u0003%\u00111\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!1\u0001\t\u0013\t\u0019\rC\u0005\u0002n\u0002\t\n\u0011\"\u0003\u0002p\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001\"\u0003B\r\u0001E\u0005I\u0011BAx\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\u0019\u0001\t\u0013\u0011)\u0007C\u0004\u0003j\u0001!IAa\u001b\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!q\u000f\u0001\u0005\n\te\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\b\u0005/\u0003A\u0011\u0002BM\u0011\u001d\u0011y\n\u0001C\u0005\u0005C\u0013A%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AK\u0005\u0003g)\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"!\r\u0001\u0002'Q,7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0003e\u0002\"AO\"\u000e\u0003mR!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\tYcH\u0003\u0002.\u007f)\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5HA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003]!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u001dq5!!AA\u0002e\n1\u0001\u001f\u00132\u0003Q!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8oA\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g.A\u0003tKR,\u0006\u000f\u0006\u0002H'\")AK\u0002a\u0001+\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039\u0006\u000bQA[;oSRL!AX,\u0003\u0011Q+7\u000f^%oM>D#A\u00021\u0011\u0005Y\u000b\u0017B\u00012X\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0017WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hgR\u0011Qm\u001d\t\u0004M&\\W\"A4\u000b\u0005!L\u0015AC2pY2,7\r^5p]&\u0011!n\u001a\u0002\u0004'\u0016\f\bC\u00017r\u001b\u0005i'B\u00018p\u0003\u0011)H/\u001b7\u000b\u0003A\fAA[1wC&\u0011!/\u001c\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002+\b\u0001\u0004)\u0016aE:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001cX#\u0001<\u0011\u0007!;\u00180\u0003\u0002y\u0013\n)\u0011I\u001d:bsB\u0011\u0001J_\u0005\u0003w&\u0013AAQ=uK\u0006!2/\u00197uK\u0012\u0004\u0016m]:x_J$')\u001f;fg\u0002\n\u0011b]1mi\nKH/Z:\u0002\u0015M\fG\u000e\u001e\"zi\u0016\u001c\b%A\u0003vg\u0016\u0014\u0018'\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n=\fA\u0001\\1oO&!\u0011QBA\u0004\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013!B;tKJ\u001c\u0014AB;tKJ\u001c\u0004%A\u0006v].twn\u001e8Vg\u0016\u0014\u0018\u0001D;oW:|wO\\+tKJ\u0004\u0013\u0001\u0005;fgR\fE\u000e^3s\u001d>$\b.\u001b8h)\r9\u0015\u0011\u0005\u0005\b\u0003G!\u0002\u0019AA\u0013\u0003\u0019\tXo\u001c:v[B!\u0011qEA\u001b\u001d\u0011\tI#!\r\u0011\u0007\u0005-\u0012*\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0018\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019$S\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0007\u0006\u0004\u0003gI\u0005f\u0001\u000b\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002Be\u000ba\u0001]1sC6\u001c\u0018\u0002BA#\u0003\u007f\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d!\u0012\u0011JA+\u0003/\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\ny$\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t\u0019&!\u0014\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\tI&\t\u0002\u0002\\\u0005)1N]1gi\u00069B/Z:u\u00032$XM]*b[\u0016$\u0006.\u001b8h)^L7-\u001a\u000b\u0004\u000f\u0006\u0005\u0004bBA\u0012+\u0001\u0007\u0011Q\u0005\u0015\u0004+\u0005m\u0002fB\u000b\u0002J\u0005U\u0013q\r\u0017\u0003\u00033\n!\u0003^3ti\u0006cG/\u001a:F[B$\u00180V:feR\u0019q)!\u001c\t\u000f\u0005\rb\u00031\u0001\u0002&!\u001aa#a\u000f)\u000fY\tI%!\u0016\u0002t1\u0012\u0011\u0011L\u0001\u001ai\u0016\u001cH/\u00117uKJ,fn\u001b8po:lUm\u00195b]&\u001cX\u000eF\u0002H\u0003sBq!a\t\u0018\u0001\u0004\t)\u0003K\u0002\u0018\u0003wAsaFA%\u0003+\ny\b\f\u0002\u0002Z\u0005IB/Z:u\u00032$XM\u001d+p_\u001a+w/\u0013;fe\u0006$\u0018n\u001c8t)\r9\u0015Q\u0011\u0005\b\u0003GA\u0002\u0019AA\u0013Q\rA\u00121\b\u0015\b1\u0005%\u0013QKAFY\t\tI&\u0001\u000euKN$\u0018\t\u001c;feR{w.T1os&#XM]1uS>t7\u000fF\u0002H\u0003#Cq!a\t\u001a\u0001\u0004\t)\u0003K\u0002\u001a\u0003wAs!GA%\u0003+\n9\n\f\u0002\u0002Z\u0005\u0019C/Z:u\t\u0016dW\r^3T_6,G\u000f[5oORC\u0017\r\u001e#pKNtu\u000e^#ySN$HcA$\u0002\u001e\"9\u00111\u0005\u000eA\u0002\u0005\u0015\u0002f\u0001\u000e\u0002<!:!$!\u0013\u0002V\u0005\rFFAA-\u0003Q!Xm\u001d;BYR,'/\u00118e\t\u0016\u001c8M]5cKR\u0019q)!+\t\u000f\u0005\r2\u00041\u0001\u0002&!\u001a1$a\u000f)\u000fm\tI%!\u0016\u000202\u0012\u0011\u0011L\u0001\u001ai\u0016\u001cH/T3uC\u0012\fG/\u0019,feNLwN\u001c+p_2{w\u000fF\u0002H\u0003kCq!a\t\u001d\u0001\u0004\t)\u0003K\u0002\u001d\u0003wAs\u0001HA%\u0003+\nY\f\f\u0002\u0002>\u0006\u0012\u0011qX\u0001\u000eWJ\fg\r^\u0017J\u0005B{6g\u0018\u001b\u0002IM,g\u000eZ!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$b!!2\u0002T\u0006u\u0007\u0003BAd\u0003\u001fl!!!3\u000b\t\u0005-\u0017QZ\u0001\te\u0016\fX/Z:ug*\u0011AHP\u0005\u0005\u0003#\fIMA\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rC\u0004\u0002Vv\u0001\r!a6\u0002\u000fI,\u0017/^3tiB!\u0011qYAm\u0013\u0011\tY.!3\u0003A\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0005\n\u0003?l\u0002\u0013!a\u0001\u0003C\fAb]8dW\u0016$8+\u001a:wKJ\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003Od\u0013a\u00028fi^|'o[\u0005\u0005\u0003W\f)O\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\u0018tK:$\u0017\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAAyU\u0011\t\t/a=,\u0005\u0005U\b\u0003BA|\u0005\u0003i!!!?\u000b\t\u0005m\u0018Q`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a@J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\tIPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqe]3oI\u0012+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR1!\u0011\u0002B\b\u0005/\u0001B!a2\u0003\f%!!QBAe\u0005\u0011\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm\u001d9p]N,\u0007bBAk?\u0001\u0007!\u0011\u0003\t\u0005\u0003\u000f\u0014\u0019\"\u0003\u0003\u0003\u0016\u0005%'a\t#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0005\n\u0003?|\u0002\u0013!a\u0001\u0003C\f\u0011g]3oI\u0012+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3ti\u0012\"WMZ1vYR$#'A\u0011dQ\u0016\u001c7.\u00117m\u000bJ\u0014xN]:BYR,'/\u001b8h\u0007J,G-\u001a8uS\u0006d7\u000fF\u0004H\u0005?\u0011yEa\u0018\t\u000f\t\u0005\u0012\u00051\u0001\u0003$\u0005q!/Z:vYR\u001cHk\\\"iK\u000e\\\u0007#\u00027\u0003&\t%\u0012b\u0001B\u0014[\n!A*[:u!\u0011\u0011YC!\u0013\u000f\t\t5\"1\t\b\u0005\u0005_\u0011yD\u0004\u0003\u00032\tub\u0002\u0002B\u001a\u0005wqAA!\u000e\u0003:9!\u00111\u0006B\u001c\u0013\u0005\u0011\u0015B\u0001!B\u0013\tis(\u0003\u0002=}%!!\u0011IAg\u0003\u001diWm]:bO\u0016LAA!\u0012\u0003H\u0005)\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0005\u0003\ni-\u0003\u0003\u0003L\t5#aH!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi*!!Q\tB$\u0011\u001d\u0011\t&\ta\u0001\u0005'\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014\b\u0003\u0002B+\u00057j!Aa\u0016\u000b\t\te\u0013QZ\u0001\taJ|Go\\2pY&!!Q\fB,\u0005\u0019)%O]8sg\"9!\u0011M\u0011A\u0002\u0005\u0015\u0012AC2p]R,\u0007\u0010^'tO\u0006\u00013\r[3dW:{WI\u001d:peN\fE\u000e^3sS:<7I]3eK:$\u0018.\u00197t)\r9%q\r\u0005\b\u0005C\u0011\u0003\u0019\u0001B\u0012\u0003y\u0019\u0007.Z2l+N,'/\u00119qK\u0006\u00148/\u00138BYR,'OU3tk2$8\u000fF\u0003H\u0005[\u0012y\u0007C\u0004\u0003\"\r\u0002\rAa\t\t\u000f\tE4\u00051\u0001\u0002&\u0005!Qo]3s\u0003\u001d\"Wm]2sS\n,\u0017\t\u001c7XSRDgj\u001c+pa2+g/\u001a7FeJ|'oQ8oM&\u0014X.\u001a3\u0015\u0005\t%\u0011!K2iK\u000e\\gj\u001c+pa2+g/\u001a7FeJ|'\u000fR3tGJL'-\u001b8h\u0007J,G-\u001a8uS\u0006d7\u000fF\u0002H\u0005wBqA! &\u0001\u0004\u0011I!A\bsKN\u0004xN\\:f)>\u001c\u0005.Z2l\u0003i\u0019\u0007.Z2l+N,'\u000fS1t)^|7I]3eK:$\u0018.\u00197t)\u00159%1\u0011BK\u0011\u001d\u0011\tC\na\u0001\u0005\u000b\u0003R\u0001\u001cB\u0013\u0005\u000f\u0003BA!#\u0003\u0010:!!Q\u0006BF\u0013\u0011\u0011iIa\u0012\u0002Q\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016$\u0015\r^1\n\t\tE%1\u0013\u0002#\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001cX\u000f\u001c;\u000b\t\t5%q\t\u0005\b\u0005c2\u0003\u0019AA\u0013\u00031\u001a\u0007.Z2l\r>\u00148+\u001b8hY\u0016\u001c\u0006.Y\u001b2e%#XM]1uS>t7\u000fO\u0019:e\r\u0013X\rZ3oi&\fG\u000eF\u0003H\u00057\u0013i\nC\u0004\u0003\"\u001d\u0002\rA!\"\t\u000f\tEt\u00051\u0001\u0002&\u0005)2\r[3dW\u0012+7o\u0019:jE\u00164uN]#se>\u0014HcB$\u0003$\n\u0015&q\u0015\u0005\b\u0005CA\u0003\u0019\u0001BC\u0011\u001d\u0011\t\b\u000ba\u0001\u0003KAqA!\u0015)\u0001\u0004\u0011\u0019\u0006")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latestTesting();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String user3;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.serverConfig().setProperty("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
            this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
        }
        this.serverConfig().setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        super.setUp(testInfo);
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        ((Properties)controllerConfigs.head()).setProperty("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        ((Properties)controllerConfigs.head()).setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        return controllerConfigs;
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String user3() {
        return this.user3;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterNothing(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterSameThingTwice(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion1)).setUpsertions(Arrays.asList(upsertion2, upsertion2))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion2)).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterEmptyUser(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty)).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty, deletionEmpty)).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterUnknownMechanism(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user6 = "user6";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown6 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user6).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionUnknown1, deletionValid1, deletionUnknown2)).setUpsertions(Arrays.asList(upsertionUnknown4, upsertionValid4, upsertionUnknown5, upsertionUnknown6))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        CollectionConverters$.MODULE$.ListHasAsScala(results).asScala().foreach((Function1 & Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterTooFewIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterTooManyIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteSomethingThatDoesNotExist(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterAndDescribe(String quorum) {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results1_0.size());
        this.checkNoErrorsAlteringCredentials(results1_0);
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)3, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        this.checkUserAppearsInAlterResults(results1_1, this.user3());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see 3 users");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)3, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user3());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see only 2 users");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user3());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        this.checkUserAppearsInAlterResults(results6, this.user3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see empty user");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionMetadataVersionTooLow))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IBP version");
        Assertions.assertEquals((Object)"The current metadata.version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)("Expected all '" + expectedError.name() + "' errors when altering credentials " + contextMsg));
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)("Expected result to contain '" + user + "'"));
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)("Expected result to contain '" + user + "' with 2 credentials: " + resultsToCheck));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)("Expected result to contain '" + user + "' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: " + resultsToCheck));
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)("Expected result to contain '" + user + "' with 1 credential: " + resultsToCheck));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)("Expected result to contain '" + user + "' with SCRAM_SHA_512/8192 credential: " + resultsToCheck));
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)("Expected result to contain '" + user + "' with a " + expectedError.name() + " error: " + resultsToCheck));
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$2() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 3 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$3(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$4() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$5(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$6() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.user3 = "user3@user3.com";
        this.unknownUser = "unknownUser";
    }
}

