/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C!1!)q\u0004\u0001C!A!)a\u0006\u0001C\u0005_!)!\t\u0001C\u0001\u0007\")q\n\u0001C\u0001\u0007\")\u0011\u000b\u0001C\u0001%\")q\u000f\u0001C\u0005q\n\u0011\u0013\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK&sG/Z4sCRLwN\u001c+fgRT!a\u0003\u0007\u0002\rM,'O^3s\u0015\u0005i\u0011!B6bM.\f7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003)I!a\u0005\u0006\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\f\u0011\u0005E\u0001\u0011a\u00032s_.,'oQ8v]R,\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0004\u0013:$\u0018a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\tC\u0005\u0005\u0002\u001bE%\u00111e\u0007\u0002\u0005+:LG\u000fC\u0003&\u0007\u0001\u0007a%\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0006Qe>\u0004XM\u001d;jKN\fac]3oI\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u000b\u0003au\u0002\"!M\u001e\u000e\u0003IR!a\r\u001b\u0002\u0011I,\u0017/^3tiNT!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\tiqG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f3\u0005M\t\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f\u0011\u0015qD\u00011\u0001@\u0003\u001d1XM]:j_:\u0004\"A\u0007!\n\u0005\u0005[\"!B*i_J$\u0018\u0001\b;fgR\u001cVM\u001c3Wg\u0005\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u000b\u0002C!\u0012Q!\u0012\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000b1!\u00199j\u0015\tQ5*A\u0004kkBLG/\u001a:\u000b\u00051K\u0014!\u00026v]&$\u0018B\u0001(H\u0005\u0011!Vm\u001d;\u00029Q,7\u000f^*f]\u00124F'\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\"\u0012a!R\u0001\u001bCN\u001cXM\u001d;GK\u0006$XO]3ICNl\u0015N\u001c,feNLwN\u001c\u000b\u0005CM\u0003W\u000fC\u0003U\u000f\u0001\u0007Q+\u0001\u0003oC6,\u0007C\u0001,^\u001d\t96\f\u0005\u0002Y75\t\u0011L\u0003\u0002[\u001d\u00051AH]8pizJ!\u0001X\u000e\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039nAQ!Y\u0004A\u0002\t\fAaY8mYB\u00111M\u001d\b\u0003I>t!!Z7\u000f\u0005\u0019dgBA4l\u001d\tA'N\u0004\u0002YS&\t!(\u0003\u00029s%\u0011QbN\u0005\u0003kYJ!A\u001c\u001b\u0002\u000f5,7o]1hK&\u0011\u0001/]\u0001\u0018\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a#bi\u0006T!A\u001c\u001b\n\u0005M$(!H*vaB|'\u000f^3e\r\u0016\fG/\u001e:f\u0017\u0016L8i\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005A\f\b\"\u0002<\b\u0001\u0004y\u0014AE3ya\u0016\u001cG/\u001a3NS:4VM]:j_:\fA#Y:tKJ$h)Z1ukJ,W*[:tS:<GcA\u0011zu\")A\u000b\u0003a\u0001+\")\u0011\r\u0003a\u0001E\u0002")
public class ApiVersionsResponseIntegrationTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("controlled.shutdown.enable", "false");
        properties.put("offsets.topic.replication.factor", "1");
        properties.put("offsets.topic.num.partitions", "1");
    }

    private ApiVersionsResponse sendApiVersionsRequest(short version) {
        ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
        return (ApiVersionsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
    }

    @Test
    public void testSendV3ApiVersionsRequest() {
        ApiVersionsResponse response = this.sendApiVersionsRequest((short)3);
        this.assertFeatureHasMinVersion("metadata.version", response.data().supportedFeatures(), MetadataVersion.MINIMUM_VERSION.featureLevel());
        this.assertFeatureMissing("kraft.version", response.data().supportedFeatures());
    }

    @Test
    public void testSendV4ApiVersionsRequest() {
        ApiVersionsResponse response = this.sendApiVersionsRequest((short)4);
        this.assertFeatureHasMinVersion("metadata.version", response.data().supportedFeatures(), MetadataVersion.MINIMUM_VERSION.featureLevel());
        this.assertFeatureHasMinVersion("kraft.version", response.data().supportedFeatures(), (short)0);
    }

    public void assertFeatureHasMinVersion(String name, ApiVersionsResponseData.SupportedFeatureKeyCollection coll, short expectedMinVersion) {
        ApiVersionsResponseData.SupportedFeatureKey key = coll.find(name);
        Assertions.assertNotNull((Object)key);
        Assertions.assertEquals((Object)name, (Object)key.name());
        Assertions.assertEquals((short)expectedMinVersion, (short)key.minVersion());
    }

    private void assertFeatureMissing(String name, ApiVersionsResponseData.SupportedFeatureKeyCollection coll) {
        Assertions.assertNull((Object)coll.find(name));
    }
}

