/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.quota.ThrottleCallback;
import org.junit.jupiter.api.AfterEach;
import org.mockito.Mockito;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013E!\u0005\u0003\u00041\u0001\u0001\u0006Ia\t\u0005\bc\u0001\u0001\r\u0011\"\u00053\u0011\u001d1\u0004\u00011A\u0005\u0012]Ba!\u0010\u0001!B\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%\tb\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002!\t\u000b\u0019\u0003A\u0011A$\t\u000bM\u0003A\u0011\u0003+\t\u000bq\u0003A\u0011C/\t\u0013\u0005U\u0001!%A\u0005\u0012\u0005]\u0001bBA\u0019\u0001\u0011E\u00111\u0007\u0005\b\u00033\u0002A\u0011CA.\u0011\u001d\t9\b\u0001C\t\u0003s\u0012!DQ1tK\u000ec\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgRT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0012\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0002\"\u0001\n\u0018\u000e\u0003\u0015R!AJ\u0014\u0002\u000bU$\u0018\u000e\\:\u000b\u0005!J\u0013AB2p[6|gN\u0003\u0002\u0015U)\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0013\tySE\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u00031qW/\\\"bY2\u0014\u0017mY6t+\u0005\u0019\u0004C\u0001\r5\u0013\t)\u0014DA\u0002J]R\f\u0001C\\;n\u0007\u0006dGNY1dWN|F%Z9\u0015\u0005aZ\u0004C\u0001\r:\u0013\tQ\u0014D\u0001\u0003V]&$\bb\u0002\u001f\u0006\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014!\u00048v[\u000e\u000bG\u000e\u001c2bG.\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!AP\u0014\n\u0005\u0011\u0013%aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005AA/Z1s\t><h\u000eF\u00019Q\tI\u0011\n\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00059{\u0015a\u00026va&$XM\u001d\u0006\u0003!2\nQA[;oSRL!AU&\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001C2bY2\u0014\u0017mY6\u0016\u0003U\u0003\"A\u0016.\u000e\u0003]S!\u0001W-\u0002\u000bE,x\u000e^1\u000b\u0005II\u0013BA.X\u0005A!\u0006N]8ui2,7)\u00197mE\u0006\u001c7.\u0001\u0007ck&dGMU3rk\u0016\u001cH/\u0006\u0002_IR!qL_A\u0004!\u0011A\u0002M\u00199\n\u0005\u0005L\"A\u0002+va2,'\u0007\u0005\u0002dI2\u0001A!B3\f\u0005\u00041'!\u0001+\u0012\u0005\u001dT\u0007C\u0001\ri\u0013\tI\u0017DA\u0004O_RD\u0017N\\4\u0011\u0005-tW\"\u00017\u000b\u00055<\u0013\u0001\u0003:fcV,7\u000f^:\n\u0005=d'aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0011\u0005E<hB\u0001:v\u001b\u0005\u0019(B\u0001;\u0014\u0003\u001dqW\r^<pe.L!A^:\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011\u00010\u001f\u0002\b%\u0016\fX/Z:u\u0015\t18\u000fC\u0003|\u0017\u0001\u0007A0A\u0004ck&dG-\u001a:\u0011\tu\f\tA\u0019\b\u0003WzL!a 7\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!a\u0001\u0002\u0006\t9!)^5mI\u0016\u0014(BA@m\u0011%\tIa\u0003I\u0001\u0002\u0004\tY!\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002\u000e\u0005EQBAA\b\u0015\t!x%\u0003\u0003\u0002\u0014\u0005=!\u0001\u0004'jgR,g.\u001a:OC6,\u0017A\u00062vS2$'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005e\u0011qF\u000b\u0003\u00037QC!a\u0003\u0002\u001e-\u0012\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0002*e\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003f\u0019\t\u0007a-\u0001\u0007ck&dGmU3tg&|g\u000e\u0006\u0003\u00026\u0005}\u0002\u0003BA\u001c\u0003wi!!!\u000f\u000b\u0005QL\u0013\u0002BA\u001f\u0003s\u0011qaU3tg&|g\u000eC\u0004\u0002B5\u0001\r!a\u0011\u0002\tU\u001cXM\u001d\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003cAA%35\u0011\u00111\n\u0006\u0004\u0003\u001b*\u0012A\u0002\u001fs_>$h(C\u0002\u0002Re\ta\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)3\u0005YQ.Y=cKJ+7m\u001c:e)%\u0019\u0014QLA4\u0003S\ni\u0007C\u0004\u0002`9\u0001\r!!\u0019\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0007\u0001\n\u0019'C\u0002\u0002fE\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\"9\u0011\u0011\t\bA\u0002\u0005\r\u0003bBA6\u001d\u0001\u0007\u00111I\u0001\tG2LWM\u001c;JI\"9\u0011q\u000e\bA\u0002\u0005E\u0014!\u0002<bYV,\u0007c\u0001\r\u0002t%\u0019\u0011QO\r\u0003\r\u0011{WO\u00197f\u0003!!\bN]8ui2,Gc\u0003\u001d\u0002|\u0005u\u0014qPAA\u0003\u000bCq!a\u0018\u0010\u0001\u0004\t\t\u0007C\u0004\u0002B=\u0001\r!a\u0011\t\u000f\u0005-t\u00021\u0001\u0002D!1\u00111Q\bA\u0002M\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f\u0003\u0004\u0002\b>\u0001\r!V\u0001\u001aG\"\fgN\\3m)\"\u0014x\u000e\u001e;mS:<7)\u00197mE\u0006\u001c7\u000e")
public class BaseClientQuotaManagerTest {
    private final MockTime time = new MockTime();
    private int numCallbacks = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    public MockTime time() {
        return this.time;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public ThrottleCallback callback() {
        return new ThrottleCallback(this){
            private final /* synthetic */ BaseClientQuotaManagerTest $outer;

            public void startThrottling() {
            }

            public void endThrottling() {
                this.$outer.numCallbacks_$eq(this.$outer.numCallbacks() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannelMetrics requestChannelMetrics = (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics, (Option)None$.MODULE$));
    }

    public <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public Session buildSession(String user) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return new Session(principal, null);
    }

    public int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        return quotaManager.maybeRecordAndGetThrottleTimeMs(this.buildSession(user), clientId, value, this.time().milliseconds());
    }

    /*
     * WARNING - void declaration
     */
    public void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, ThrottleCallback channelThrottlingCallback) {
        void var7_7;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle((RequestChannel.Request)var7_7, channelThrottlingCallback, throttleTimeMs);
    }
}

