/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerChannelManagerImpl;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u0004\t\u00015AQ\u0001\u0006\u0001\u0005\u0002UAQ\u0001\u0007\u0001\u0005\u0002eAQa\f\u0001\u0005\u0002ABQa\u0016\u0001\u0005\u0002aCq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\f\u0001!\t!!\u0004\u0003;\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c*fcV,7\u000f\u001e+fgRT!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\t\u0003\u0001\u0012'o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0015\u0005i1\u0003CA\u000e%\u001b\u0005a\"BA\u000f\u001f\u0003\u0019\u0019w.\\7p]*\u0011\u0011b\b\u0006\u0003\u0017\u0001R!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO&\u0011Q\u0005\b\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJDQa\n\u0002A\u0002!\nqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003S5j\u0011A\u000b\u0006\u0003W1\nA\u0001^3ti*\u0011QdH\u0005\u0003])\u0012qb\u00117vgR,'/\u00138ti\u0006t7-Z\u0001\u000fg\u0016tG-\u00118e%\u0016\u001cW-\u001b<f+\r\tD\n\u000e\u000b\u0005e\u0001\u0013%\u000b\u0005\u00024i1\u0001A!B\u001b\u0004\u0005\u00041$!\u0001*\u0012\u0005]R\u0004CA\b9\u0013\tI\u0004CA\u0004O_RD\u0017N\\4\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ub\u0013\u0001\u0003:fcV,7\u000f^:\n\u0005}b$\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0011\u0015\t5\u00011\u0001\u001b\u00039\u0019\u0007.\u00198oK2l\u0015M\\1hKJDQaQ\u0002A\u0002\u0011\u000b!B]3r\u0005VLG\u000eZ3s!\r)\u0005j\u0013\b\u0003w\u0019K!a\u0012\u001f\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRL!!\u0013&\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011q\t\u0010\t\u0003g1#Q!T\u0002C\u00029\u0013\u0011\u0001V\t\u0003o=\u0003\"a\u000f)\n\u0005Ec$aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000bM\u001b\u0001\u0019\u0001+\u0002\u0013QLW.Z8vi6\u001b\bCA\bV\u0013\t1\u0006CA\u0002J]R\faB]3hSN$XM\u001d\"s_.,'\u000f\u0006\u0004Z?\u0002lwn\u001e\t\u00035vk\u0011a\u0017\u0006\u000392\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003=n\u0013a!\u0012:s_J\u001c\b\"B!\u0005\u0001\u0004Q\u0002\"B1\u0005\u0001\u0004\u0011\u0017!C2mkN$XM]%e!\t\u0019'N\u0004\u0002eQB\u0011Q\rE\u0007\u0002M*\u0011q\rD\u0001\u0007yI|w\u000e\u001e \n\u0005%\u0004\u0012A\u0002)sK\u0012,g-\u0003\u0002lY\n11\u000b\u001e:j]\u001eT!!\u001b\t\t\u000b9$\u0001\u0019\u0001+\u0002\u0011\t\u0014xn[3s\u0013\u0012DQ\u0001\u001d\u0003A\u0002E\fqA_6Fa>\u001c\u0007\u000eE\u0002\u0010eRL!a\u001d\t\u0003\r=\u0003H/[8o!\tyQ/\u0003\u0002w!\t!Aj\u001c8h\u0011\u0015AH\u00011\u0001z\u0003I1W-\u0019;ve\u0016dUM^3m)>\u001cVM\u001c3\u0011\u0007=\u0011(\u0010\u0005\u0003\u0010wvl\u0018B\u0001?\u0011\u0005\u0019!V\u000f\u001d7feA\u0011qB`\u0005\u0003\u007fB\u0011Qa\u00155peR\fAb\u0019:fCR,Gk\u001c9jGN$R!WA\u0003\u0003\u000fAQ!Q\u0003A\u0002iAa!!\u0003\u0006\u0001\u0004\u0011\u0017!\u0003;pa&\u001cg*Y7f\u0003y!Xm\u001d;SK\u001eL7\u000f^3s5.<\u0016\u000e\u001e54g\r{g\u000e\u001e:pY2,'\u000f\u0006\u0003\u0002\u0010\u0005U\u0001cA\b\u0002\u0012%\u0019\u00111\u0003\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006O\u0019\u0001\r\u0001\u000b\u0015\u0014\r\u0005e\u0011QEA\u0014\u0003g\t)$a\u000e\u0002:\u0005m\u0012Q\b\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u0016\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002$\u0005u!aC\"mkN$XM\u001d+fgR\fQ\u0001^=qKNd#!!\u000b%\u0005\u0005-\u0012\u0002BA\u0017\u0003_\tQa\u0013*B\rRSA!!\r\u0002\u001e\u0005!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012\u0001A\u0001\fG>tGO]8mY\u0016\u00148/H\u0001\u0002\u0003=iW\r^1eCR\fg+\u001a:tS>tGEAA \u0013\u0011\t\t%a\u0011\u0002\u0017%\u0013\u0005kX\u001a`g}Kek\r\u0006\u0004\u0003\u000bb\u0012aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8")
public class BrokerRegistrationRequestTest {
    public NodeToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        return new NodeToControllerChannelManagerImpl(new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort((ListenerName)this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return (ListenerName)this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        }, Time.SYSTEM, new Metrics(), clusterInstance.anyControllerSocketServer().config(), "heartbeat", "test-heartbeat-", 10000L);
    }

    public <T extends AbstractRequest, R extends AbstractResponse> R sendAndReceive(NodeToControllerChannelManager channelManager, AbstractRequest.Builder<T> reqBuilder, int timeoutMs) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest(reqBuilder, new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(response.responseBody());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (R)((AbstractResponse)responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS));
    }

    public Errors registerBroker(NodeToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<Object, Object>> featureLevelToSend) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        featureLevelToSend.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(features, x0$1)));
        Feature.PRODUCTION_FEATURES.stream().filter(x$1 -> {
            String string = x$1.featureName();
            String string2 = "metadata.version";
            return string == null || !string.equals(string2);
        }).forEach(feature -> features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName(feature.featureName()).setMinSupportedVersion(feature.minimumProduction()).setMaxSupportedVersion(feature.latestTesting())));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setLogDirs(Collections.singletonList(Uuid.randomUuid())).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features).setListeners(new BrokerRegistrationRequestData.ListenerCollection(Arrays.asList(new BrokerRegistrationRequestData.Listener().setName("EXTERNAL").setHost("example.com").setPort(8082).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id)).iterator()));
        return Errors.forCode((short)((BrokerRegistrationResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), 30000)).data().errorCode());
    }

    public Errors createTopics(NodeToControllerChannelManager channelManager, String topicName) {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTopics(new CreateTopicsRequestData.CreatableTopicCollection());
        createTopics.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(10).setReplicationFactor((short)1));
        createTopics.setTimeoutMs(500);
        CreateTopicsRequest.Builder req = new CreateTopicsRequest.Builder(createTopics);
        return Errors.forCode((short)((CreateTopicsResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)req, 3000)).data().topics().find(topicName).errorCode());
    }

    @ClusterTest(types={Type.KRAFT}, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3)
    public void testRegisterZkWith33Controller(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<Object, Object>>)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)4), (Object)BoxesRunTime.boxToShort((short)MetadataVersion.IBP_3_3_IV3.featureLevel())))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<Object, Object>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<Object, Object>>)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)MetadataVersion.IBP_3_4_IV0.featureLevel()), (Object)BoxesRunTime.boxToShort((short)MetadataVersion.IBP_3_4_IV0.featureLevel())))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<Object, Object>>)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)MetadataVersion.IBP_3_3_IV3.featureLevel()), (Object)BoxesRunTime.boxToShort((short)MetadataVersion.IBP_3_4_IV0.featureLevel())))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            short min = BoxesRunTime.unboxToShort((Object)x0$1._1());
            short max = BoxesRunTime.unboxToShort((Object)x0$1._2());
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min).setMaxSupportedVersion(max));
        }
        throw new MatchError(null);
    }
}

