/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001\u0002\u0006\f\u0001AAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005\u0002}AQa\u0013\u0001\u0005\u00021CQ!\u0015\u0001\u0005\nICQ\u0001\u0019\u0001\u0005\n\u0005DQa\u0019\u0001\u0005\n\u0011DQa\u001a\u0001\u0005\n!Dq!\u001e\u0001\u0012\u0002\u0013%a\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\u0003/\u0011+G.\u001a;f)>\u0004\u0018nY:SKF,Xm\u001d;UKN$(B\u0001\u0007\u000e\u0003\u0019\u0019XM\u001d<fe*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\tR\u0003\u0005\u0002\u0013'5\t1\"\u0003\u0002\u0015\u0017\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000f\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u001b\u0005)Q\u000f^5mg&\u0011!d\u0006\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0013\u0001\u0005aC/Z:u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8DYV\u001cH/\u001a:ICN|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\")qE\u0001a\u0001Q\u00051\u0011/^8sk6\u0004\"!\u000b\u0019\u000f\u0005)r\u0003CA\u0016#\u001b\u0005a#BA\u0017\u0010\u0003\u0019a$o\\8u}%\u0011qFI\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020E!\u0012!\u0001\u000e\t\u0003kyj\u0011A\u000e\u0006\u0003oa\na\u0001]1sC6\u001c(BA\u001d;\u0003\u001dQW\u000f]5uKJT!a\u000f\u001f\u0002\u000b),h.\u001b;\u000b\u0003u\n1a\u001c:h\u0013\tydGA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDCAA!H\u0011B\u0011!)R\u0007\u0002\u0007*\u0011AIN\u0001\taJ|g/\u001b3fe&\u0011ai\u0011\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003%\u000b\u0013AS\u0001\u0006WJ\fg\r^\u0001\u001di\u0016\u001cHOV1mS\u0012$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;t)\t\u0001S\nC\u0003(\u0007\u0001\u0007\u0001\u0006\u000b\u0002\u0004i!\"1!Q$QY\u0005I\u0015\u0001\t<bY&$\u0017\r^3WC2LG\rR3mKR,Gk\u001c9jGJ+\u0017/^3tiN$\"\u0001I*\t\u000bQ#\u0001\u0019A+\u0002\u000fI,\u0017/^3tiB\u0011aKX\u0007\u0002/*\u0011\u0001,W\u0001\te\u0016\fX/Z:ug*\u0011!lW\u0001\u0007G>lWn\u001c8\u000b\u00059a&BA/=\u0003\u0019\t\u0007/Y2iK&\u0011ql\u0016\u0002\u0014\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f^\u0001(m\u0006d\u0017\u000eZ1uKZ\u000bG.\u001b3EK2,G/\u001a+pa&\u001c'+Z9vKN$8oV5uQ&#7\u000f\u0006\u0002!E\")A+\u0002a\u0001+\u00061b/\u00197jI\u0006$X\rV8qS\u000eL5\u000fR3mKR,G\r\u0006\u0002!K\")aM\u0002a\u0001Q\u0005)Ao\u001c9jG\u000692/\u001a8e\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u000b\u0004S2l\u0007C\u0001,k\u0013\tYwK\u0001\u000bEK2,G/\u001a+pa&\u001c7OU3ta>t7/\u001a\u0005\u0006)\u001e\u0001\r!\u0016\u0005\b]\u001e\u0001\n\u00111\u0001p\u00031\u0019xnY6fiN+'O^3s!\t\u00018/D\u0001r\u0015\t\u0011X\"A\u0004oKR<xN]6\n\u0005Q\f(\u0001D*pG.,GoU3sm\u0016\u0014\u0018!I:f]\u0012$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T#A<+\u0005=D8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!C;oG\",7m[3e\u0015\tq(%\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019i\u0016\u001cH\u000fR3mKR,Gk\u001c9jGN4VM]:j_:\u001cHc\u0001\u0011\u0002\b!)q%\u0003a\u0001Q!\u0012\u0011\u0002\u000e\u0015\u0006\u0013\u0005;\u0015Q\u0002\u0017\u0002\u0013\u0002")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testTopicDeletionClusterHasOfflinePartitions(String quorum) {
        String offlineTopic = "topic-1";
        String onlineTopic = "topic-2";
        this.createTopicWithAssignment(offlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}))), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(onlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))}))), this.createTopicWithAssignment$default$3());
        this.killBroker(0);
        this.ensureConsistentKRaftMetadata();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$1(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic partition is not offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.deleteTopic(onlineTopic, this.deleteTopic$default$2());
        this.deleteTopic(offlineTopic, this.deleteTopic$default$2());
        this.ensureConsistentKRaftMetadata();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$5(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The topics are found in the Broker's cache");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testValidDeleteTopicRequests(String quorum) {
        int timeout = 10000;
        this.createTopic("topic-1", this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-1")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-3", "topic-4")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        scala.collection.immutable.Map<String, Uuid> ids = this.getTopicIds();
        this.validateValidDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6")))).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$5))).isEmpty(), (String)("There should be no errors, found " + CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala()));
        this.ensureConsistentKRaftMetadata();
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
    }

    private void validateValidDeleteTopicRequestsWithIds(DeleteTopicsRequest request) {
        DeleteTopicsResponse response2 = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response2.errorCounts()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequestsWithIds$1(x$6))).isEmpty(), (String)("There should be no errors, found " + CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response2.data().responses()).asScala()));
        this.ensureConsistentKRaftMetadata();
        response2.data().responses().forEach(response -> this.validateTopicIsDeleted(response.name()));
    }

    /*
     * WARNING - void declaration
     */
    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class))).topicMetadata()).asScala();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.adminSocketServer();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteTopicsVersions(String quorum) {
        int timeout = 10000;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.DELETE_TOPICS.oldestVersion()), (int)ApiKeys.DELETE_TOPICS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Creating and deleting tests for version " + version);
            String topicName = "topic-" + version;
            this.createTopic(topicName, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
            DeleteTopicsRequestData data = new DeleteTopicsRequestData().setTimeoutMs(timeout);
            if (version < 6) {
                data.setTopicNames(Arrays.asList(topicName));
            } else {
                data.setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setName(topicName)));
            }
            this.validateValidDeleteTopicRequests(new DeleteTopicsRequest.Builder(data).build((short)version));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$2(LeaderAndIsr x$1) {
        return x$1.leader() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$3(LeaderAndIsr x$2) {
        return x$2.leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$1(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getLeaderAndIsr(onlineTopic$1, 0).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$2(x$1))) && ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getLeaderAndIsr(offlineTopic$1, 0).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$4() {
        return "Topic partition is not offline";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$6(String onlineTopic$1, KafkaBroker x$3) {
        return x$3.metadataCache().contains(onlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$7(String offlineTopic$1, KafkaBroker x$4) {
        return x$4.metadataCache().contains(offlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$5(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return !$this.aliveBrokers().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$6(onlineTopic$1, x$3))) && !$this.aliveBrokers().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$7(offlineTopic$1, x$4)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$8() {
        return "The topics are found in the Broker's cache";
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$5) {
        Object object = x$5._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequestsWithIds$1(Tuple2 x$6) {
        Object object = x$6._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return "The topic " + topic$1 + " should not exist";
    }
}

