/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.EndPoint;
import kafka.log.LogManager;
import kafka.log.remote.RemoteLogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001B!C\u0001\u001dCQA\u0014\u0001\u0005\u0002=CQA\u0015\u0001\u0005\u0002MCQ\u0001\u001a\u0001\u0005\u0002MCQA\u001a\u0001\u0005\u0002MCQ\u0001\u001b\u0001\u0005\u0002MCQA\u001b\u0001\u0005\u0002MCQ\u0001\u001c\u0001\u0005\u0002MCQA\u001c\u0001\u0005\u0002MCQ\u0001\u001d\u0001\u0005\u0002MCQA\u001d\u0001\u0005\u0002MCQ\u0001\u001e\u0001\u0005\u0002MCQA\u001e\u0001\u0005\n]Dq!!\f\u0001\t\u0013\ty\u0003\u0003\u0004\u0002Z\u0001!\ta\u0015\u0004\u0007\u0003;\u0002\u0001!a\u0018\t\r9{A\u0011AAA\u0011%\t9i\u0004a\u0001\n\u0003\tI\tC\u0005\u0002\u0010>\u0001\r\u0011\"\u0001\u0002\u0012\"A\u0011qS\b!B\u0013\tY\tC\u0004\u0002\">!\t%a)\t\u000f\u0005uw\u0002\"\u0011\u0002`\"9!1A\b\u0005B\t\u0015\u0001b\u0002B\u0018\u001f\u0011\u0005#\u0011\u0007\u0005\b\u0005+zA\u0011\tB,\u0011\u0019\u0011\u0019g\u0004C!'\"9!QM\b\u0005B\t\u001d\u0004b\u0002B@\u001f\u0011\u0005#\u0011\u0011\u0005\b\u0005\u0013{A\u0011\tBF\u0011\u001d\u0011Ij\u0004C!\u00057CaA!+\u0001\t\u0003\u0019\u0006b\u0002BW\u0001\u0011%!q\u0016\u0005\u0007\u0005\u007f\u0003A\u0011A*\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"1!1\u001a\u0001\u0005\u0002MCaAa4\u0001\t\u0003\u0019\u0006B\u0002Bj\u0001\u0011\u00051\u000b\u0003\u0004\u0003X\u0002!\ta\u0015\u0005\u0007\u00057\u0004A\u0011A*\t\r\t}\u0007\u0001\"\u0001T\u0011\u0019\u0011\u0019\u000f\u0001C\u0001'\"1!q\u001d\u0001\u0005\u0002MCaAa;\u0001\t\u0003\u0019\u0006B\u0002Bx\u0001\u0011\u00051\u000b\u0003\u0004\u0003t\u0002!\ta\u0015\u0005\u0007\u0005o\u0004A\u0011A*\t\r\tm\b\u0001\"\u0001T\u0011\u0019\u0011y\u0010\u0001C\u0001'\"111\u0001\u0001\u0005\u0002MCaaa\u0002\u0001\t\u0003\u0019\u0006bBB\u0006\u0001\u0011\u00051Q\u0002\u0004\u0007\u0007K\u0001\u0001aa\n\t\u0015\u0005u2G!A!\u0002\u0013\ty\u0004\u0003\u0004Og\u0011\u00051\u0011\u0006\u0005\n\u0003g\u0019$\u0019!C\u0001\u0007_A\u0001b!\r4A\u0003%\u0011Q\u0007\u0005\n\u0007g\u0019$\u0019!C\u0001\u0007kA\u0001b!\u00104A\u0003%1q\u0007\u0005\n\u0007\u007f\u0019$\u0019!C\u0001\u0007\u0003B\u0001ba\u00144A\u0003%11\t\u0005\n\u0007#\u001a$\u0019!C\u0001\u0007'B\u0001ba\u001d4A\u0003%1Q\u000b\u0005\u0007\u0007k\u0002A\u0011A*\t\r\re\u0004\u0001\"\u0001T\u0011\u0019\u0019i\b\u0001C\u0001'\n9B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0012\u000baa]3sm\u0016\u0014(\"A#\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0006CA)\u0001\u001b\u0005\u0011\u0015\u0001\u0005;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f)\u0005!\u0006CA%V\u0013\t1&J\u0001\u0003V]&$\bF\u0001\u0002Y!\tI&-D\u0001[\u0015\tYF,A\u0002ba&T!!\u00180\u0002\u000f),\b/\u001b;fe*\u0011q\fY\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002C\u0006\u0019qN]4\n\u0005\rT&\u0001\u0002+fgR\f1\u0004^3tiV\u0003H-\u0019;f\tft\u0017-\\5d)\"\u0014X-\u00193Q_>d\u0007FA\u0002Y\u0003-\"Xm\u001d;Va\u0012\fG/\u001a*f[>$X\rT8h\u001b\u0006t\u0017mZ3s\tft\u0017-\\5d)\"\u0014X-\u00193Q_>d\u0007F\u0001\u0003Y\u0003=\"Xm\u001d;SK6|G/\u001a'pO\u0012Kh.Y7jGRC'/Z1e!>|GnV5uQ&sg/\u00197jIZ\u000bG.^3tQ\t)\u0001,\u0001\u0014uKN$8i\u001c8gS\u001e,\u0006\u000fZ1uK^KG\u000f[*p[\u0016LeN^1mS\u0012\u001cuN\u001c4jOND#A\u0002-\u0002gQ,7\u000f^\"p]\u001aLw-\u00169eCR,w+\u001b;i%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f-\u0006d\u0017\u000eZ1uS>tg)Y5mkJ,\u0007FA\u0004Y\u0003q!Xm\u001d;SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:D#\u0001\u0003-\u0002'Q,7\u000f^*fGV\u0014\u0018\u000e^=D_:4\u0017nZ:)\u0005%A\u0016a\u0005;fgR\u001cuN\u001c8fGRLwN\\)v_R\f\u0007F\u0001\u0006Y\u0003]!Xm\u001d;D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018\r\u000b\u0002\f1\u0006\u0011b/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f)!!\u00060a\u0003\u0002 \u0005%\u0002\"B=\r\u0001\u0004Q\u0018\u0001\u00028b[\u0016\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{*k\u0011A \u0006\u0003\u007f\u001a\u000ba\u0001\u0010:p_Rt\u0014bAA\u0002\u0015\u00061\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001K\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001f\tQA^1mk\u0016\u0004B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\u0007\u001f\nTWm\u0019;\t\u000f\u0005\u0005B\u00021\u0001\u0002$\u0005y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rE\u0002J\u0003KI1!a\nK\u0005\u001d\u0011un\u001c7fC:Dq!a\u000b\r\u0001\u0004\t\u0019#A\u0007fqB,7\r\u001e$bS2,(/Z\u0001$m\u0016\u0014\u0018NZ=D_:4\u0017nZ+qI\u0006$XmV5uQ&sg/\u00197jI\u000e{gNZ5h)%!\u0016\u0011GA\u001e\u0003\u0017\n)\u0006C\u0004\u000245\u0001\r!!\u000e\u0002\r\r|gNZ5h!\r\t\u0016qG\u0005\u0004\u0003s\u0011%aC&bM.\f7i\u001c8gS\u001eDq!!\u0010\u000e\u0001\u0004\ty$A\u0005pe&<\u0007K]8qgB!\u0011\u0011IA$\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005]\u0011\u0001B;uS2LA!!\u0013\u0002D\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u00055S\u00021\u0001\u0002P\u0005Qa/\u00197jIB\u0013x\u000e]:\u0011\u000bm\f\tF\u001f>\n\t\u0005M\u0013\u0011\u0002\u0002\u0004\u001b\u0006\u0004\bbBA,\u001b\u0001\u0007\u0011qJ\u0001\rS:4\u0018\r\\5e!J|\u0007o]\u0001\u001ai\u0016\u001cH\u000fR=oC6L7\rT5ti\u0016tWM]\"p]\u001aLw\r\u000b\u0002\u000f1\nqA+Z:u\u0003V$\bn\u001c:ju\u0016\u00148cB\b\u0002\u0010\u0005\u0005\u0014Q\u000f\t\u0005\u0003G\n\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0004\u0007\u0006-$bA#\u0002n)\u0019\u0011q\u000e1\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019(!\u001a\u0003\u0015\u0005+H\u000f[8sSj,'\u000f\u0005\u0003\u0002x\u0005uTBAA=\u0015\u0011\tY(a\u001b\u0002\r\r|W.\\8o\u0013\u0011\ty(!\u001f\u0003\u001dI+7m\u001c8gS\u001e,(/\u00192mKR\u0011\u00111\u0011\t\u0004\u0003\u000b{Q\"\u0001\u0001\u0002\u0015M,\b/\u001a:Vg\u0016\u00148/\u0006\u0002\u0002\fB!\u0011\u0011CAG\u0013\u0011\t9!a\u0005\u0002\u001dM,\b/\u001a:Vg\u0016\u00148o\u0018\u0013fcR\u0019A+a%\t\u0013\u0005U%#!AA\u0002\u0005-\u0015a\u0001=%c\u0005Y1/\u001e9feV\u001bXM]:!Q\r\u0019\u00121\u0014\t\u0004\u0013\u0006u\u0015bAAP\u0015\nAao\u001c7bi&dW-A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002&\u0006M\u0007\u0007BAT\u0003k\u0003\u0002\"!\u0011\u0002*\u0006-\u0016\u0011W\u0005\u0005\u0003'\n\u0019\u0005\u0005\u0003\u0002x\u00055\u0016\u0002BAX\u0003s\u0012\u0001\"\u00128ea>Lg\u000e\u001e\t\u0005\u0003g\u000b)\f\u0004\u0001\u0005\u0017\u0005]F#!A\u0001\u0002\u000b\u0005\u0011\u0011\u0018\u0002\u0004?\u0012B\u0014\u0003BA^\u0003\u0003\u00042!SA_\u0013\r\tyL\u0013\u0002\b\u001d>$\b.\u001b8h!\u0019\t\u0019-!3\u0002N6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\f\u0019%\u0001\u0006d_:\u001cWO\u001d:f]RLA!a3\u0002F\ny1i\\7qY\u0016$\u0018n\u001c8Ti\u0006<W\r\u0005\u0003\u0002\u0012\u0005=\u0017\u0002BAi\u0003'\u0011AAV8jI\"9\u0011Q\u001b\u000bA\u0002\u0005]\u0017AC:feZ,'/\u00138g_B!\u00111MAm\u0013\u0011\tY.!\u001a\u0003)\u0005+H\u000f[8sSj,'oU3sm\u0016\u0014\u0018J\u001c4p\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0004\u0002b\u00065\u0018q\u001f\t\u0007\u0003\u0003\n\u0019/a:\n\t\u0005\u0015\u00181\t\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002d\u0005%\u0018\u0002BAv\u0003K\u00121#Q;uQ>\u0014\u0018N_1uS>t'+Z:vYRDq!a<\u0016\u0001\u0004\t\t0\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\u0005\r\u00141_\u0005\u0005\u0003k\f)G\u0001\u000eBkRDwN]5{C\ndWMU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002zV\u0001\r!a?\u0002\u000f\u0005\u001cG/[8ogB1\u0011\u0011IAr\u0003{\u0004B!a\u0019\u0002\u0000&!!\u0011AA3\u0005\u0019\t5\r^5p]\u0006Q1M]3bi\u0016\f5\r\\:\u0015\r\t\u001d!1\u0004B\u000fa\u0011\u0011IA!\u0004\u0011\r\u0005\u0005\u00131\u001dB\u0006!\u0011\t\u0019L!\u0004\u0005\u0017\t=a#!A\u0001\u0002\u000b\u0005!\u0011\u0003\u0002\u0004?\u0012J\u0014\u0003BA^\u0005'\u0001b!a1\u0002J\nU\u0001\u0003BA2\u0005/IAA!\u0007\u0002f\ty\u0011i\u00197De\u0016\fG/\u001a*fgVdG\u000fC\u0004\u0002pZ\u0001\r!!=\t\u000f\t}a\u00031\u0001\u0003\"\u0005Y\u0011m\u00197CS:$\u0017N\\4t!\u0019\t\t%a9\u0003$A!!Q\u0005B\u0016\u001b\t\u00119C\u0003\u0003\u0003*\u0005e\u0014aA1dY&!!Q\u0006B\u0014\u0005)\t5\r\u001c\"j]\u0012LgnZ\u0001\u000bI\u0016dW\r^3BG2\u001cHC\u0002B\u001a\u0005\u000f\u0012I\u0005\r\u0003\u00036\te\u0002CBA!\u0003G\u00149\u0004\u0005\u0003\u00024\neBa\u0003B\u001e/\u0005\u0005\t\u0011!B\u0001\u0005{\u0011Aa\u0018\u00132aE!\u00111\u0018B !\u0019\t\u0019-!3\u0003BA!\u00111\rB\"\u0013\u0011\u0011)%!\u001a\u0003\u001f\u0005\u001bG\u000eR3mKR,'+Z:vYRDq!a<\u0018\u0001\u0004\t\t\u0010C\u0004\u0003L]\u0001\rA!\u0014\u0002#\u0005\u001cGNQ5oI&twMR5mi\u0016\u00148\u000f\u0005\u0004\u0002B\u0005\r(q\n\t\u0005\u0005K\u0011\t&\u0003\u0003\u0003T\t\u001d\"\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0003\u0011\t7\r\\:\u0015\t\te#q\f\t\u0007\u0003#\u0011YFa\t\n\t\tu\u00131\u0003\u0002\t\u0013R,'/\u00192mK\"9!\u0011\r\rA\u0002\t=\u0013A\u00024jYR,'/A\u0003dY>\u001cX-A\u0005d_:4\u0017nZ;sKR\u0019AK!\u001b\t\u000f\t-$\u00041\u0001\u0003n\u000591m\u001c8gS\u001e\u001c\b\u0007\u0002B8\u0005g\u0002r!!\u0011\u0002*j\u0014\t\b\u0005\u0003\u00024\nMD\u0001\u0004B;\u0005S\n\t\u0011!A\u0003\u0002\t]$\u0001B0%cE\nB!a/\u0003zA\u0019\u0011Ja\u001f\n\u0007\tu$JA\u0002B]f\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0006\u0002\u0003\u0004B)\u0011\u0011\tBCu&!!qQA\"\u0005\r\u0019V\r^\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$2\u0001\u0016BG\u0011\u001d\u0011Y\u0007\ba\u0001\u0005\u001f\u0003DA!%\u0003\u0016B9\u0011\u0011IAUu\nM\u0005\u0003BAZ\u0005+#ABa&\u0003\u000e\u0006\u0005\t\u0011!B\u0001\u0005o\u0012Aa\u0018\u00132e\u0005Y!/Z2p]\u001aLw-\u001e:f)\r!&Q\u0014\u0005\b\u0005Wj\u0002\u0019\u0001BPa\u0011\u0011\tK!*\u0011\u000f\u0005\u0005\u0013\u0011\u0016>\u0003$B!\u00111\u0017BS\t1\u00119K!(\u0002\u0002\u0003\u0005)\u0011\u0001B<\u0005\u0011yF%M\u001a\u0002)Q,7\u000f^!vi\"|'/\u001b>fe\u000e{gNZ5hQ\tq\u0002,\u0001\u0010de\u0016\fG/Z\"p[\nLg.\u001a3D_:$(o\u001c7mKJ\u001cuN\u001c4jOR1\u0011q\bBY\u0005wCqAa- \u0001\u0004\u0011),\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0004\u0013\n]\u0016b\u0001B]\u0015\n\u0019\u0011J\u001c;\t\u000f\tuv\u00041\u0001\u00036\u0006!\u0001o\u001c:u\u0003\u0019\"Xm\u001d;D_6\u0014\u0017N\\3e\u0007>tGO]8mY\u0016\u0014\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003Aa\u000bad\u0019:fCR,\u0017j]8mCR,GmQ8oiJ|G\u000e\\3s\u0007>tg-[4\u0015\r\u0005}\"q\u0019Be\u0011\u001d\u0011\u0019,\ta\u0001\u0005kCqA!0\"\u0001\u0004\u0011),\u0001\u0014uKN$\u0018j]8mCR,GmQ8oiJ|G\u000e\\3s\u0003V$\bn\u001c:ju\u0016\u00148i\u001c8gS\u001eD#A\t-\u0002\u0019Q,7\u000f^*z]>t\u00170\\:)\u0005\rB\u0016!\b;fgRLU\u000e\u001d:pa\u0016\u00148i\u001c8gS\u001e\u001c\u0018I]3SK6|g/\u001a3)\u0005\u0011B\u0016!\u0007;fgR,\u0006\u000fZ1uK6+GO]5d%\u0016\u0004xN\u001d;feND#!\n-\u0002MQ,7\u000f^+qI\u0006$X-T3ue&\u001c'+\u001a9peR,'o\u001d(p\u00156D(+\u001a9peR,'\u000f\u000b\u0002'1\u0006\tD/Z:u\u001d>t\u0017J\u001c;fe:\fGNV1mk\u0016\u001cHi\\3t\u001d>$X\t\u001f9pg\u0016Le\u000e^3s]\u0006d7i\u001c8gS\u001e\u001c\bFA\u0014Y\u0003\u0011\"Xm\u001d;Es:\fW.[2M_\u001edunY1m%\u0016$XM\u001c;j_:l5oQ8oM&<\u0007F\u0001\u0015Y\u0003\u0019\"Xm\u001d;Es:\fW.[2M_\u001edunY1m%\u0016$XM\u001c;j_:\u001c\u0016N_3D_:4\u0017n\u001a\u0015\u0003Sa\u000b\u0001\u0007^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|gnU6jaN|e.\u00138wC2LGmQ8oM&<\u0007F\u0001\u0016Y\u0003M\"Xm\u001d;Es:\fW.[2M_\u001edunY1m%\u0016$XM\u001c;j_:$\u0006N]8xg>s\u0017J\\2peJ,7\r^\"p]\u001aLw\r\u000b\u0002,1\u0006)C/Z:u\tft\u0017-\\5d%\u0016lw\u000e^3GKR\u001c\u0007.T1y/\u0006LG/T:D_:4\u0017n\u001a\u0015\u0003Ya\u000b!\u0007^3ti\u0012Kh.Y7jGJ+Wn\u001c;f\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000fV5nK>,H/T:D_:4\u0017n\u001a\u0015\u0003[a\u000bq\u0005^3tiV\u0003H-\u0019;f\tft\u0017-\\5d%\u0016lw\u000e^3M_\u001el\u0015M\\1hKJ\u001cuN\u001c4jO\"\u0012a\u0006W\u0001%i\u0016\u001cHOU3n_R,Gj\\4NC:\fw-\u001a:D_BL\u0018+^8uCV\u0003H-\u0019;fg\"\u0012q\u0006W\u0001&i\u0016\u001cHOU3n_R,Gj\\4NC:\fw-\u001a:GKR\u001c\u0007.U;pi\u0006,\u0006\u000fZ1uKND#\u0001\r-\u0002SQ,7\u000f\u001e*f[>$X\rT8h\u001b\u0006t\u0017mZ3s\u001bVdG/\u001b9mK\u000e{gNZ5h+B$\u0017\r^3tQ\t\t\u0004,A\u0013wKJLg-_%oG>\u0014(/Z2u\u0019><Gj\\2bYJ+G/\u001a8uS>t\u0007K]8qgRIAka\u0004\u0004\u001a\ru1\u0011\u0005\u0005\b\u0007#\u0011\u0004\u0019AB\n\u0003Mawn\u001a'pG\u0006d'+\u001a;f]RLwN\\'t!\rI5QC\u0005\u0004\u0007/Q%\u0001\u0002'p]\u001eDqaa\u00073\u0001\u0004\u0019\u0019\"A\u0006sKR,g\u000e^5p]6\u001b\bbBB\u0010e\u0001\u000711C\u0001\u0017Y><Gj\\2bYJ+G/\u001a8uS>t')\u001f;fg\"911\u0005\u001aA\u0002\rM\u0011A\u0004:fi\u0016tG/[8o\u0005f$Xm\u001d\u0002\u0018\tft\u0017-\\5d\u0019><7i\u001c8gS\u001e\u001cuN\u001c;fqR\u001c\"a\r%\u0015\t\r-2Q\u0006\t\u0004\u0003\u000b\u001b\u0004bBA\u001fk\u0001\u0007\u0011qH\u000b\u0003\u0003k\tqaY8oM&<\u0007%\u0001\u0006tKJ4XM]'pG.,\"aa\u000e\u0011\u0007E\u001bI$C\u0002\u0004<\t\u0013AB\u0011:pW\u0016\u00148+\u001a:wKJ\f1b]3sm\u0016\u0014Xj\\2lA\u0005qAn\\4NC:\fw-\u001a:N_\u000e\\WCAB\"!\u0011\u0019)ea\u0013\u000e\u0005\r\u001d#bAB%\t\u0006\u0019An\\4\n\t\r53q\t\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018a\u00047pO6\u000bg.Y4fe6{7m\u001b\u0011\u0002/\r,(O]3oi\u0012+g-Y;mi2{wmQ8oM&<WCAB+!\u0019\u00199f!\u0018\u0004b5\u00111\u0011\f\u0006\u0005\u00077\n)-\u0001\u0004bi>l\u0017nY\u0005\u0005\u0007?\u001aIFA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0011\u0019\u0019ga\u001c\u000e\u0005\r\u0015$\u0002BB%\u0007ORAa!\u001b\u0004l\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0007[\nY'A\u0004ti>\u0014\u0018mZ3\n\t\rE4Q\r\u0002\n\u0019><7i\u001c8gS\u001e\f\u0001dY;se\u0016tG\u000fR3gCVdG\u000fT8h\u0007>tg-[4!\u00031\"Xm\u001d;Es:\fW.[2M_\u001e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fgNKhn\u001c8z[N\u001cuN\u001d:fGRd\u0017\u0010\u000b\u0002?1\u0006ID/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016l\u0015N\\;uKNL5OT8u\tft\u0017-\\5dC2d\u0017PU3d_:4\u0017nZ;sC\ndW\r\u000b\u0002@1\u0006)D/Z:u\u0003\u00124XM\u001d;jg\u0016$G*[:uK:,'o]%t\u001d>$H)\u001f8b[&\u001c\u0017\r\u001c7z%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fQ\t\u0001\u0005\f")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = "ks" + i + ".jks";
            props1.put("listener.name.external.ssl.keystore.location", newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var31_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var32_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var33_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("num.io.threads", "4");
        origProps.put("num.network.threads", "2");
        origProps.put("num.replica.fetchers", "1");
        origProps.put("num.recovery.threads.per.data.dir", "1");
        origProps.put("background.threads", "3");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put("num.io.threads", "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put("num.network.threads", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey("num.network.threads"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get("num.network.threads"));
        props.put("num.replica.fetchers", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put("num.recovery.threads.per.data.dir", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put("background.threads", "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testUpdateRemoteLogManagerDynamicThreadPool() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Assertions.assertEquals((int)10, (int)config.remoteLogManagerConfig().remoteLogManagerCopierThreadPoolSize());
        Assertions.assertEquals((int)10, (int)config.remoteLogManagerConfig().remoteLogManagerExpirationThreadPoolSize());
        Assertions.assertEquals((int)10, (int)config.remoteLogManagerConfig().remoteLogReaderThreads());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.manager.copier.thread.pool.size", "8");
        config.dynamicConfig().validate(props, true);
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (int)config.remoteLogManagerConfig().remoteLogManagerCopierThreadPoolSize());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCopierThreadPool(8);
        props.put("remote.log.manager.expiration.thread.pool.size", "7");
        config.dynamicConfig().validate(props, false);
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)7, (int)config.remoteLogManagerConfig().remoteLogManagerExpirationThreadPoolSize());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeExpirationThreadPool(7);
        props.put("remote.log.reader.threads", "6");
        config.dynamicConfig().validate(props, true);
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (int)config.remoteLogManagerConfig().remoteLogReaderThreads());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeReaderThreadPool(6);
        props.clear();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogDynamicThreadPoolWithInvalidValues() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.manager.copier.thread.pool.size", "0");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true))).getMessage().contains("Value must be at least 1"));
        Properties props1 = new Properties();
        props1.put("remote.log.manager.expiration.thread.pool.size", "-1");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props1, false))).getMessage().contains("Value must be at least 1"));
        Properties props2 = new Properties();
        props2.put("remote.log.reader.threads", "2");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props2, false))).getMessage().contains("value should be at least half the current value"));
        new Properties().put("remote.log.reader.threads", "-1");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true))).getMessage().contains("Value must be at least 1"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var26_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var27_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var28_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("ssl.keystore.type", "JKS");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"node.id"), (Object)"123")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var26_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var27_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var28_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("log.cleaner.dedupe.buffer.size", "100000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "broker.id", "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "log.cleaner.dedupe.buffer.size", "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate("max.connections.per.ip", "100", true, false);
        this.verifyConfigUpdate("max.connections.per.ip", "100", false, false);
        this.verifyConfigUpdate("max.connections.per.ip", "0", false, true);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName#:100", true, true);
        this.verifyConfigUpdate("max.connections", "100", true, false);
        this.verifyConfigUpdate("max.connections", "100", false, false);
        String listenerMaxConnectionsProp = "listener.name.external.max.connections";
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate("max.connection.creation.rate", "110", true, false);
        this.verifyConfigUpdate("max.connection.creation.rate", "120", false, false);
        String listenerMaxConnectionsProp = "listener.name.external.max.connection.creation.rate";
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var30_18 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDynamicListenerConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker kafkaServer = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put("listeners", "PLAINTEXT://hostname:9092");
        boolean apply_doLog = true;
        new DynamicListenerConfig(kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig(kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean apply_doLog = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var30_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var31_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var32_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaBroker kafkaServer = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        kafkaServer.config().dynamicConfig().addReconfigurables(kafkaServer);
        props.put("super.users", "User:admin");
        DynamicBrokerConfig qual$1 = kafkaServer.config().dynamicConfig();
        boolean x$23 = qual$1.updateBrokerConfig$default$3();
        qual$1.updateBrokerConfig(0, props, x$23);
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put("process.roles", "broker,controller");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", retval.get("listeners") + ",CONTROLLER://localhost:0");
        retval.put("controller.quorum.voters", nodeId + "@localhost:0");
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put("process.roles", "controller");
        retval.remove("advertised.listeners");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", "CONTROLLER://localhost:0");
        retval.put("controller.quorum.voters", nodeId + "@localhost:0");
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.hours", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, true));
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put("max.connections", "9999");
        newProps.put("message.max.bytes", "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put("max.connections", "INVALID_INT");
        newProps.put("message.max.bytes", "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put("metric.reporters", JmxReporter.class.getName() + "," + MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("metric.reporters", "");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put("metric.reporters", MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove("metric.reporters");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testNonInternalValuesDoesNotExposeInternalConfigs() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var21_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var22_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var23_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put("metadata.log.segment.min.bytes", "1024");
        KafkaConfig config = new KafkaConfig((java.util.Map)props);
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey("metadata.log.segment.min.bytes"));
        config.updateCurrentConfig(new KafkaConfig((java.util.Map)props));
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey("metadata.log.segment.min.bytes"));
    }

    @Test
    public void testDynamicLogLocalRetentionMsConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2592000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", "2160000000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)2160000000L, (long)config.remoteLogManagerConfig().logLocalRetentionMs());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.ms", "2150000000");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)2150000000L, (long)config.remoteLogManagerConfig().logLocalRetentionMs());
    }

    @Test
    public void testDynamicLogLocalRetentionSizeConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "4294967296");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.bytes", "4294967295");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)config.remoteLogManagerConfig().logLocalRetentionBytes());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.bytes", "4294967294");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)0xFFFFFFFEL, (long)config.remoteLogManagerConfig().logLocalRetentionBytes());
    }

    @Test
    public void testDynamicLogLocalRetentionSkipsOnInvalidConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put("log.local.retention.ms", "1000");
        props.put("log.local.retention.bytes", "1024");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.ms"), (Object)"-3")}))));
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.bytes"), (Object)"-3")}))));
    }

    @Test
    public void testDynamicLogLocalRetentionThrowsOnIncorrectConfig() {
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, 2L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(500L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(-1L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, -1L, 100L);
    }

    @Test
    public void testDynamicRemoteFetchMaxWaitMsConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        KafkaBroker kafkaBroker = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaBroker.config()).thenReturn((Object)config);
        Mockito.when((Object)kafkaBroker.remoteLogManagerOpt()).thenReturn((Object)None$.MODULE$);
        Assertions.assertEquals((int)500, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        DynamicRemoteLogConfig dynamicRemoteLogConfig = new DynamicRemoteLogConfig(kafkaBroker);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicRemoteLogConfig);
        Properties newProps = new Properties();
        newProps.put("remote.fetch.max.wait.ms", "30000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)30000, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        newProps.put("remote.fetch.max.wait.ms", "10000");
        config.dynamicConfig().validate(newProps, true);
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((int)10000, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, 0})).foreach((Function1 & Serializable)maxWaitMs -> DynamicBrokerConfigTest.$anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(newProps, config, BoxesRunTime.unboxToInt((Object)maxWaitMs)));
    }

    @Test
    public void testDynamicRemoteListOffsetsRequestTimeoutMsConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        KafkaBroker kafkaBroker = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaBroker.config()).thenReturn((Object)config);
        Mockito.when((Object)kafkaBroker.remoteLogManagerOpt()).thenReturn((Object)None$.MODULE$);
        Assertions.assertEquals((long)30000L, (long)config.remoteLogManagerConfig().remoteListOffsetsRequestTimeoutMs());
        DynamicRemoteLogConfig dynamicRemoteLogConfig = new DynamicRemoteLogConfig(kafkaBroker);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicRemoteLogConfig);
        Properties newProps = new Properties();
        newProps.put("remote.list.offsets.request.timeout.ms", "60000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)60000L, (long)config.remoteLogManagerConfig().remoteListOffsetsRequestTimeoutMs());
        newProps.put("remote.list.offsets.request.timeout.ms", "10000");
        config.dynamicConfig().validate(newProps, true);
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)10000L, (long)config.remoteLogManagerConfig().remoteListOffsetsRequestTimeoutMs());
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, 0})).foreach((Function1 & Serializable)timeoutMs -> DynamicBrokerConfigTest.$anonfun$testDynamicRemoteListOffsetsRequestTimeoutMsConfig$1(newProps, config, BoxesRunTime.unboxToInt((Object)timeoutMs)));
    }

    @Test
    public void testUpdateDynamicRemoteLogManagerConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("remote.log.index.file.cache.total.size.bytes", "2");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.index.file.cache.total.size.bytes", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerCopyQuotaUpdates() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var23_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var24_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var25_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        props.put("remote.log.manager.copy.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        props.put("remote.log.manager.copy.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerFetchQuotaUpdates() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var23_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var24_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var25_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        props.put("remote.log.manager.fetch.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(100L);
        props.put("remote.log.manager.fetch.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerMultipleConfigUpdates() {
        String indexFileCacheSizeProp = "remote.log.index.file.cache.total.size.bytes";
        String copyQuotaProp = "remote.log.manager.copy.max.bytes.per.second";
        String fetchQuotaProp = "remote.log.manager.fetch.max.bytes.per.second";
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var28_17 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((long)0x40000000L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        props.put(indexFileCacheSizeProp, "4");
        props.put(copyQuotaProp, "100");
        props.put(fetchQuotaProp, "200");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        props.put(indexFileCacheSizeProp, "8");
        props.put(copyQuotaProp, "200");
        props.put(fetchQuotaProp, "400");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)8L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)400L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(8L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(400L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    public void verifyIncorrectLogLocalRetentionProps(long logLocalRetentionMs, long retentionMs, long logLocalRetentionBytes, long retentionBytes) {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var32_12 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var33_15 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var34_18 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, Long.toString(retentionMs));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, Long.toString(retentionBytes));
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", Long.toString(logLocalRetentionMs));
        newProps.put("log.local.retention.bytes", Long.toString(logLocalRetentionBytes));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, false));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, true));
    }

    @Test
    public void testDynamicLogConfigHandlesSynonymsCorrectly() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("log.retention.minutes", "1");
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Assertions.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Properties props = new Properties();
        props.put("message.max.bytes", "12345678");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)ctx.currentDefaultLogConfig().get().retentionMs);
    }

    @Test
    public void testLogRetentionTimeMinutesIsNotDynamicallyReconfigurable() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("log.retention.hours", "1");
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Properties props = new Properties();
        props.put("log.retention.minutes", "3");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Assertions.assertFalse((boolean)((AbstractConfig)ctx.currentDefaultLogConfig().get()).originals().containsKey("log.retention.minutes"));
    }

    @Test
    public void testAdvertisedListenersIsNotDynamicallyReconfigurable() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Properties props = new Properties();
        props.put("advertised.listeners", "SASL_PLAINTEXT://localhost:8181");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        ctx.config().effectiveAdvertisedBrokerListeners().foreach((Function1 & Serializable)e -> {
            DynamicBrokerConfigTest.$anonfun$testAdvertisedListenersIsNotDynamicallyReconfigurable$1(e);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)((AbstractConfig)ctx.currentDefaultLogConfig().get()).originals().containsKey("advertised.listeners"));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get("log.cleaner.threads").toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException("Invalid cleaner threads " + cleanerThreads);
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate("listener.name.external." + name, value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate("listener.name.external." + name, value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$4, Properties props$2) {
        if (perBrokerConfig$1) {
            config$4.dynamicConfig().updateBrokerConfig(0, config$4.dynamicConfig().toPersistentProps(props$2, perBrokerConfig$1), config$4.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$4.dynamicConfig().updateDefaultConfig(props$2, config$4.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$5, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$5.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$5, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$5.originals().get(name));
    }

    public static final /* synthetic */ ConfigException $anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(Properties newProps$1, KafkaConfig config$6, int maxWaitMs) {
        newProps$1.put("remote.fetch.max.wait.ms", Integer.toString(maxWaitMs));
        Assertions.assertThrows(ConfigException.class, () -> config$6.dynamicConfig().validate(newProps$1, true));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> config$6.dynamicConfig().validate(newProps$1, false));
    }

    public static final /* synthetic */ ConfigException $anonfun$testDynamicRemoteListOffsetsRequestTimeoutMsConfig$1(Properties newProps$2, KafkaConfig config$7, int timeoutMs) {
        newProps$2.put("remote.list.offsets.request.timeout.ms", Integer.toString(timeoutMs));
        Assertions.assertThrows(ConfigException.class, () -> config$7.dynamicConfig().validate(newProps$2, true));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> config$7.dynamicConfig().validate(newProps$2, false));
    }

    public static final /* synthetic */ void $anonfun$testAdvertisedListenersIsNotDynamicallyReconfigurable$1(EndPoint e) {
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)e.listenerName().value());
    }

    public class DynamicLogConfigContext {
        private final KafkaConfig config;
        private final BrokerServer serverMock;
        private final LogManager logManagerMock;
        private final AtomicReference<LogConfig> currentDefaultLogConfig;

        public KafkaConfig config() {
            return this.config;
        }

        public BrokerServer serverMock() {
            return this.serverMock;
        }

        public LogManager logManagerMock() {
            return this.logManagerMock;
        }

        public AtomicReference<LogConfig> currentDefaultLogConfig() {
            return this.currentDefaultLogConfig;
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$DynamicLogConfigContext$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public static final /* synthetic */ void $anonfun$new$2(DynamicLogConfigContext $this, InvocationOnMock invocation) {
            $this.currentDefaultLogConfig().set((LogConfig)invocation.getArgument(0));
        }

        public DynamicLogConfigContext(Properties origProps) {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            boolean apply_doLog = true;
            this.config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
            this.serverMock = (BrokerServer)Mockito.mock(BrokerServer.class);
            this.logManagerMock = (LogManager)Mockito.mock(LogManager.class);
            Mockito.when((Object)this.serverMock().config()).thenReturn((Object)this.config());
            Mockito.when((Object)this.serverMock().logManager()).thenReturn((Object)this.logManagerMock());
            Mockito.when((Object)this.logManagerMock().allLogs()).thenReturn(package$.MODULE$.Iterable().empty());
            this.currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
            Mockito.when((Object)this.logManagerMock().currentDefaultConfig()).thenAnswer(x$1 -> this.currentDefaultLogConfig().get());
            this.logManagerMock().reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
                DynamicLogConfigContext.$anonfun$new$2(this, invocation);
                return BoxedUnit.UNIT;
            });
            this.config().dynamicConfig().initialize((Option)None$.MODULE$);
            this.config().dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(this.logManagerMock()));
        }
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

