/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteLogManager;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005U2A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u00015!)Q\u0006\u0001C\u00015!)q\u0006\u0001C\u00015!)\u0011\u0007\u0001C\u00015!)1\u0007\u0001C\u00015\tYB)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKVs\u0017\u000e\u001e+fgRT!AC\u0006\u0002\rM,'O^3s\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\n\u0003\u0015\u001a\bn\\;mIB\u000b'o]3SKBd\u0017nY1uS>t\u0017+^8uCB\u0013x\u000e]3si&,7\u000fF\u0001\u001c!\t\u0001B$\u0003\u0002\u001e#\t!QK\\5uQ\t\u0011q\u0004\u0005\u0002!S5\t\u0011E\u0003\u0002#G\u0005\u0019\u0011\r]5\u000b\u0005\u0011*\u0013a\u00026va&$XM\u001d\u0006\u0003M\u001d\nQA[;oSRT\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016\"\u0005\u0011!Vm\u001d;\u0002[MDw.\u001e7e!\u0006\u00148/Z,jY\u0012\u001c\u0017M\u001d3SKBd\u0017nY1uS>t\u0017+^8uCB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0004?\u0005i3\u000f[8vY\u0012\u0004\u0016M]:f%\u0016<\u0017M\u001d3mKN\u001cxJZ,iSR,7\u000f]1dK\u0006\u0013x.\u001e8e-\u0006dW/Z:)\u0005\u0011y\u0012\u0001I:i_VdG\rU1sg\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018MU3tKRD#!B\u0010\u0002CQ,7\u000f^#oC\ndWMU3n_R,Gj\\4Ti>\u0014\u0018mZ3P]R{\u0007/[2)\u0005\u0019y\u0012A\u000e;fgR,e.\u00192mKJ+Wn\u001c;f\u0019><7\u000b^8sC\u001e,wJ\u001c+pa&\u001cwJ\\!me\u0016\fG-_#oC\ndW\r\u001a+pa&\u001c\u0007FA\u0004 \u0001")
public class DynamicConfigChangeUnitTest {
    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas"));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, "leader.replication.throttled.replicas"));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas");
        Assertions.assertEquals((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ReplicationQuotaManager.ALL_REPLICAS).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)))).toSeq(), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Assertions.assertEquals((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ReplicationQuotaManager.ALL_REPLICAS).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)))).toSeq(), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "* "));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " 6:102"));
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put("follower.replication.throttled.replicas", "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "follower.replication.throttled.replicas");
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void testEnableRemoteLogStorageOnTopic() {
        String topic = "test-topic";
        Uuid topicUuid = Uuid.randomUuid();
        RemoteLogManager rlm = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)replicaManager.remoteLogManager()).thenReturn((Object)new Some((Object)rlm));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)metadataCache);
        Mockito.when((Object)metadataCache.getTopicId(topic)).thenReturn((Object)topicUuid);
        TopicPartition tp0 = new TopicPartition(topic, 0);
        UnifiedLog log0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)log0.topicPartition()).thenReturn((Object)tp0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log0.remoteLogEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition0.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(tp0)).thenReturn((Object)new Some((Object)partition0));
        Mockito.when((Object)log0.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        TopicPartition tp1 = new TopicPartition(topic, 1);
        UnifiedLog log1 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition1 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)log1.topicPartition()).thenReturn((Object)tp1);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log1.remoteLogEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition1.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)replicaManager.onlinePartition(tp1)).thenReturn((Object)new Some((Object)partition1));
        Mockito.when((Object)log1.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        ArgumentCaptor leaderPartitionsArg = ArgumentCaptor.forClass(Set.class);
        ArgumentCaptor followerPartitionsArg = ArgumentCaptor.forClass(Set.class);
        ((RemoteLogManager)Mockito.doNothing().when((Object)rlm)).onLeadershipChange((Set)leaderPartitionsArg.capture(), (Set)followerPartitionsArg.capture(), (Map)ArgumentMatchers.any());
        boolean isRemoteLogEnabledBeforeUpdate = false;
        new TopicConfigHandler(replicaManager, null, null).maybeUpdateRemoteLogComponents(topic, (Seq)new .colon.colon((Object)log0, (List)new .colon.colon((Object)log1, (List)Nil$.MODULE$)), isRemoteLogEnabledBeforeUpdate, false);
        Assertions.assertEquals(Collections.singleton(partition0), (Object)leaderPartitionsArg.getValue());
        Assertions.assertEquals(Collections.singleton(partition1), (Object)followerPartitionsArg.getValue());
    }

    @Test
    public void testEnableRemoteLogStorageOnTopicOnAlreadyEnabledTopic() {
        String topic = "test-topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        RemoteLogManager rlm = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)replicaManager.remoteLogManager()).thenReturn((Object)new Some((Object)rlm));
        Mockito.when((Object)replicaManager.onlinePartition(tp0)).thenReturn((Object)new Some((Object)partition));
        UnifiedLog log0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log0.remoteLogEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ((RemoteLogManager)Mockito.doNothing().when((Object)rlm)).onLeadershipChange((Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)log0.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        Mockito.when((Object)log0.topicPartition()).thenReturn((Object)tp0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        boolean isRemoteLogEnabledBeforeUpdate = true;
        new TopicConfigHandler(replicaManager, null, null).maybeUpdateRemoteLogComponents(topic, (Seq)new .colon.colon((Object)log0, (List)Nil$.MODULE$), isRemoteLogEnabledBeforeUpdate, false);
        ((RemoteLogManager)Mockito.verify((Object)rlm, (VerificationMode)Mockito.never())).onLeadershipChange((Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    private static final Seq parse$1(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", value), 102, "leader.replication.throttled.replicas");
    }
}

