/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockNodeToControllerChannelManager;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001\u0002\u0013&\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004D\u0001\u0001\u0006Ia\u000e\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019a\u0005\u0001)A\u0005\r\"9Q\n\u0001b\u0001\n\u0013q\u0005B\u0002*\u0001A\u0003%q\nC\u0004T\u0001\t\u0007I\u0011\u0002+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u001dI\u0006A1A\u0005\niCaA\u0019\u0001!\u0002\u0013Y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B3\t\u000f%\u0004!\u0019!C\u0005U\"11\u000f\u0001Q\u0001\n-Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003v\u0011\u0019Y\b\u0001)A\u0005m\"9A\u0010\u0001b\u0001\n\u0013)\bBB?\u0001A\u0003%a\u000fC\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\n!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u001a\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003o\u0001A\u0011AA\u000b\u0011\u001d\tY\u0004\u0001C\u0001\u0003+Aq!a\u0010\u0001\t\u0003\t)\u0002C\u0004\u0002D\u0001!\t!!\u0006\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\u0016!9\u00111\n\u0001\u0005\u0002\u0005U\u0001bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003\u001f\u0002A\u0011BAE\u0011\u001d\t9\f\u0001C\u0005\u0003s\u0013QCR8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002'O\u000511/\u001a:wKJT\u0011\u0001K\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0002\"\u0001\u000e\u0001\u000e\u0003\u0015\nA\u0001^5nKV\tq\u0007\u0005\u00029\u00036\t\u0011H\u0003\u0002;w\u0005!Q\u000f^5m\u0015\t1CH\u0003\u0002){)\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011\u0015H\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019\u0019G.[3oiV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002Jy\u000591\r\\5f]R\u001c\u0018BA&I\u0005)iunY6DY&,g\u000e^\u0001\bG2LWM\u001c;!\u0003Y\u0019wN\u001c;s_2dWM\u001d(pI\u0016\u0004&o\u001c<jI\u0016\u0014X#A(\u0011\u0005Q\u0002\u0016BA)&\u0005Y\u0019uN\u001c;s_2dWM\u001d(pI\u0016\u0004&o\u001c<jI\u0016\u0014\u0018aF2p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0003U\u0003\"\u0001\u000e,\n\u0005]+#AI'pG.tu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/A\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003m\u0003\"\u0001\u00181\u000e\u0003uS!!\u00170\u000b\u0005}c\u0014AB2p[6|g.\u0003\u0002b;\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002#\u0019|'o^1sI&tw-T1oC\u001e,'/F\u0001f!\t!d-\u0003\u0002hK\t)bi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:J[Bd\u0017A\u00054pe^\f'\u000fZ5oO6\u000bg.Y4fe\u0002\n\u0001\u0003\u001d:j]\u000eL\u0007/\u00197Ck&dG-\u001a:\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s\u0015\t\u0001h,\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\u0011XN\u0001\u000fEK\u001a\fW\u000f\u001c;LC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197Ck&dG-\u001a:\u0002#A\u0014\u0018N\\2ja\u0006d')^5mI\u0016\u0014\b%A\brk\u0016,X\rV5nK6\u001b\b+O\u001d:+\u00051\bC\u0001/x\u0013\tAXLA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0017\u0001E9vKV,G+[7f\u001bN\u0004\u0016(O\u001d!\u0003-\tX/Z;f\u0019\u0016tw\r\u001e5\u0002\u0019E,X-^3MK:<G\u000f\u001b\u0011\u0002!I,Wn\u001c;f)&lW-T:QseJ\u0014!\u0005:f[>$X\rV5nK6\u001b\b+O\u001d:A\u0005)2m\u001c8ue>dG.\u001a:Ba&4VM]:j_:\u001cXCAA\u0001!\r9\u00151A\u0005\u0004\u0003\u000bA%a\u0004(pI\u0016\f\u0005/\u001b,feNLwN\\:\u0002\u001d\r|g\u000e\u001e:pY2,'/\u00138g_V\u0011\u00111\u0002\t\u0004i\u00055\u0011bAA\bK\t)2i\u001c8ue>dG.\u001a:J]\u001a|'/\\1uS>t\u0017aE3naRL8i\u001c8ue>dG.\u001a:J]\u001a|\u0017!\t;fgR\u0014Vm\u001d9p]N,7i\u001c:sK2\fG/[8o\u0013\u0012l\u0015n]7bi\u000eDGCAA\f!\ra\u0013\u0011D\u0005\u0004\u00037i#\u0001B+oSRD3!GA\u0010!\u0011\t\t#a\f\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t1!\u00199j\u0015\u0011\tI#a\u000b\u0002\u000f),\b/\u001b;fe*\u0019\u0011QF \u0002\u000b),h.\u001b;\n\t\u0005E\u00121\u0005\u0002\u0005)\u0016\u001cH/A\fuKN$XK\\:vaB|'\u000f^3e-\u0016\u00148/[8og\"\u001a!$a\b\u0002eQ,7\u000f\u001e$pe^\f'\u000fZ5oORKW.Z8vi^\u000b\u0017\u000e^5oO\u001a{'oQ8oiJ|G\u000e\\3s\t&\u001c8m\u001c<fefD3aGA\u0010\u0003}!Xm\u001d;G_J<\u0018M\u001d3j]\u001e$\u0016.\\3pkR\fe\r^3s%\u0016$(/\u001f\u0015\u00049\u0005}\u0011a\n;fgR,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Ge>lg*\u001a;x_J\\7\t\\5f]RD3!HA\u0010\u0003a!Xm\u001d;GC&dW\rZ!vi\",g\u000e^5dCRLwN\u001c\u0015\u0004=\u0005}\u0011A\n;fgR4uN]<be\u0012LgnZ'b]\u0006<WM]'fiJL7m](o\u0007>l\u0007\u000f\\3uK\"\u001aq$a\b\u0002KQ,7\u000f\u001e$pe^\f'\u000fZ5oO6\u000bg.Y4fe6+GO]5dg>sG+[7f_V$\bf\u0001\u0011\u0002 \u0005a!-^5mIJ+\u0017/^3tiR1\u00111KA;\u0003\u007f\u0002r\u0001LA+\u00033\n)'C\u0002\u0002X5\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c,\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\u0019'!\u0018\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n1A\\5p\u0015\t\ty'\u0001\u0003kCZ\f\u0017\u0002BA:\u0003S\u0012!BQ=uK\n+hMZ3s\u0011\u001d\t9(\ta\u0001\u0003s\nAAY8esB!\u00111LA>\u0013\u0011\ti(!\u0018\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!!!\"\u0001\u0004\t\u0019)A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\t\u0004Y\u0005\u0015\u0015bAAD[\t\u0019\u0011J\u001c;\u0015\u0011\u0005-\u0015qTAR\u0003O\u0003B!!$\u0002\u001a:!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014\u001e\nqA\\3uo>\u00148.\u0003\u0003\u0002\u0018\u0006E\u0015A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u00037\u000biJA\u0004SKF,Xm\u001d;\u000b\t\u0005]\u0015\u0011\u0013\u0005\b\u0003C\u0013\u0003\u0019AA-\u00035\u0011X-];fgRDU-\u00193fe\"9\u0011Q\u0015\u0012A\u0002\u0005\u0015\u0014!\u0004:fcV,7\u000f\u001e\"vM\u001a,'\u000fC\u0004\u0002*\n\u0002\r!a+\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007\u0003BAW\u0003gk!!a,\u000b\u0007\u0005Ev.\u0001\u0003bkRD\u0017\u0002BA[\u0003_\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\fuKN$\u0018\t\u001c;fe\u000e{gNZ5h%\u0016\fX/Z:u+\t\tY\f\u0005\u0003\u0002\\\u0005u\u0016\u0002BA`\u0003;\u00121#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR\u0004")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockNodeToControllerChannelManager brokerToController = new MockNodeToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), 60000, 30000);
    private final Metrics metrics = new Metrics();
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((NodeToControllerChannelManager)this.brokerToController(), this.metrics());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);
    private final KafkaMetric queueTimeMsP999 = (KafkaMetric)this.metrics().metrics().get(this.forwardingManager().forwardingManagerMetrics().queueTimeMsHist().latencyP999Name());
    private final KafkaMetric queueLength = (KafkaMetric)this.metrics().metrics().get(this.forwardingManager().forwardingManagerMetrics().queueLengthName());
    private final KafkaMetric remoteTimeMsP999 = (KafkaMetric)this.metrics().metrics().get(this.forwardingManager().forwardingManagerMetrics().remoteTimeMsHist().latencyP999Name());

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockNodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private KafkaMetric queueTimeMsP999() {
        return this.queueTimeMsP999;
    }

    private KafkaMetric queueLength() {
        return this.queueLength;
    }

    private KafkaMetric remoteTimeMsP999() {
        return this.remoteTimeMsP999;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava());
    }

    private ControllerInformation controllerInfo() {
        return new ControllerInformation((Option)new Some((Object)new Node(0, "host", 1234)), new ListenerName(""), SecurityProtocol.PLAINTEXT, "");
    }

    private ControllerInformation emptyControllerInfo() {
        return new ControllerInformation((Option)None$.MODULE$, new ListenerName(""), SecurityProtocol.PLAINTEXT, "");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareUnsupportedVersionResponse(isEnvelopeRequest);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().createPendingAuthenticationError((Node)this.controllerInfo().node().get(), 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingManagerMetricsOnComplete() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)this.queueLength().metricValue()));
        this.brokerToController().poll();
        this.client().poll(10000L, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)this.queueLength().metricValue()));
        Assertions.assertNotEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)this.queueTimeMsP999().metricValue()));
        Assertions.assertNotEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)this.remoteTimeMsP999().metricValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingManagerMetricsOnTimeout() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$5.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)this.queueLength().metricValue()));
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)this.queueLength().metricValue()));
        Assertions.assertEquals((double)((double)this.brokerToController().retryTimeoutMs() * 0.999), (double)BoxesRunTime.unboxToDouble((Object)this.queueTimeMsP999().metricValue()));
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)this.remoteTimeMsP999().metricValue()));
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), Optional.empty(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannelMetrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }
}

