/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019A\u0004\u0001)A\u0005[!)\u0011\b\u0001C!u!)q\n\u0001C\u0001!\")1\u000f\u0001C\u0001i\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001\u0002CA\u0011\u0001\u0001&I!a\t\t\u0011\u0005\r\u0004\u0001)C\u0005\u0003KB\u0001\"a\u001d\u0001A\u0013%\u0011Q\u000f\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!a'\u0001\t\u0013\ti\nC\u0004\u0002\"\u0001!I!a-\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\n1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b75\t1#\u0003\u0002\u001d'\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011!\u0004A\u0001\u0006i>\u0004\u0018nY\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012!\f\t\u0003]Yj\u0011a\f\u0006\u0003aE\naaY8n[>t'B\u0001\f3\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\n\u0005]z#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!D7pI&4\u0017pQ8oM&<7\u000f\u0006\u0002<\u0003B\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t!QK\\5u\u0011\u0015\u0011e\u00011\u0001D\u0003\u0015\u0001(o\u001c9t!\r!u)S\u0007\u0002\u000b*\u0011a)P\u0001\u000bG>dG.Z2uS>t\u0017B\u0001%F\u0005\r\u0019V-\u001d\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u001a\nA!\u001e;jY&\u0011aj\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u0007;fgRd\u0015n\u001d;PM\u001a\u001cX\r^:FeJ|'oQ8eKN$\"aO)\t\u000bI;\u0001\u0019A*\u0002\rE,xN];n!\t!6L\u0004\u0002V3B\u0011a+P\u0007\u0002/*\u0011\u0001lF\u0001\u0007yI|w\u000e\u001e \n\u0005ik\u0014A\u0002)sK\u0012,g-\u0003\u0002*9*\u0011!,\u0010\u0015\u0003\u000fy\u0003\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\rA\f'/Y7t\u0015\t\u0019G-A\u0004kkBLG/\u001a:\u000b\u0005\u0015$\u0014!\u00026v]&$\u0018BA4a\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\u0005\u000f%|\u0007\u000f\u0005\u0002k[6\t1N\u0003\u0002mA\u0006A\u0001O]8wS\u0012,'/\u0003\u0002oW\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd\u0013!]\u0011\u0002e\u0006)1N]1gi\u0006Y\u0012m]:feR\u0014Vm\u001d9p]N,WI\u001d:pe\u001a{'/\u00129pG\"$RaO;~\u0003\u000bAQA\u001e\u0005A\u0002]\fQ!\u001a:s_J\u0004\"\u0001_>\u000e\u0003eT!A_\u0018\u0002\u0011A\u0014x\u000e^8d_2L!\u0001`=\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015q\b\u00021\u0001\u0000\u0003!\u0011'o\\6fe&#\u0007c\u0001\u001f\u0002\u0002%\u0019\u00111A\u001f\u0003\u0007%sG\u000fC\u0004\u0002\b!\u0001\r!!\u0003\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\t\u0006\u0015\u0006-\u0011qB\u0005\u0004\u0003\u001bY%\u0001C(qi&|g.\u00197\u0011\u0007\r\n\t\"C\u0002\u0002\u0014\u0011\u0012q!\u00138uK\u001e,'/\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000eF\u0002<\u00033AQAU\u0005A\u0002MC#!\u00030)\u000b%Iw.a\b-\u0003E\f1b]3oIJ+\u0017/^3tiRA\u0011QEA&\u0003\u001f\nI\u0006\u0005\u0003\u0002(\u0005\u0015c\u0002BA\u0015\u0003\u007fqA!a\u000b\u0002<9!\u0011QFA\u001d\u001d\u0011\ty#a\u000e\u000f\t\u0005E\u0012Q\u0007\b\u0004-\u0006M\u0012\"A\u001b\n\u0005M\"\u0014B\u0001\f3\u0013\t\u0001\u0014'C\u0002\u0002>=\nq!\\3tg\u0006<W-\u0003\u0003\u0002B\u0005\r\u0013a\u0006'jgR|eMZ:fiN\u0014Vm\u001d9p]N,G)\u0019;b\u0015\r\tidL\u0005\u0005\u0003\u000f\nIE\u0001\u000fMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\u0005\u0005\u00131\t\u0005\u0007\u0003\u001bR\u0001\u0019A@\u0002\u0011M,'O^3s\u0013\u0012Dq!!\u0015\u000b\u0001\u0004\t\u0019&A\u0005uS6,7\u000f^1naB\u0019A(!\u0016\n\u0007\u0005]SH\u0001\u0003M_:<\u0007bBA.\u0015\u0001\u0007\u0011QL\u0001\bm\u0016\u00148/[8o!\ra\u0014qL\u0005\u0004\u0003Cj$!B*i_J$\u0018a\u00054fi\u000eDwJ\u001a4tKR\fe\u000eZ#q_\u000eDG\u0003CA4\u0003[\ny'!\u001d\u0011\rq\nI'a\u0015\u0000\u0013\r\tY'\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\r\u000553\u00021\u0001\u0000\u0011\u001d\t\tf\u0003a\u0001\u0003'Bq!a\u0017\f\u0001\u0004\ti&\u0001\u000fgKR\u001c\u0007n\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007nV5uQ\u0016\u0013(o\u001c:\u0015\u0011\u0005]\u0014QPA@\u0003\u0003\u0003\u0002\u0002PA=\u0003'z\u0018QL\u0005\u0004\u0003wj$A\u0002+va2,7\u0007\u0003\u0004\u0002N1\u0001\ra \u0005\b\u0003#b\u0001\u0019AA*\u0011\u001d\tY\u0006\u0004a\u0001\u0003;\nq\u0004^3tiJ+7\u000f]8og\u0016Len\u00197vI\u0016\u001cH*Z1eKJ,\u0005o\\2i)\rY\u0014q\u0011\u0005\u0006%6\u0001\ra\u0015\u0015\u0003\u001byCS!D5p\u0003\u001bc\u0013!]\u00016i\u0016\u001cHOU3ta>t7/\u001a#fM\u0006,H\u000e^(gMN,G/\u00118e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR8s\u00032dg+\u001a:tS>t7\u000fF\u0002<\u0003'CQA\u0015\bA\u0002MC#A\u00040)\u000b9Iw.!'-\u0003E\f1#Y:tKJ$(+Z:q_:\u001cX-\u0012:s_J$raOAP\u0003C\u000b\u0019\u000bC\u0003w\u001f\u0001\u0007q\u000fC\u0003\u007f\u001f\u0001\u0007q\u0010C\u0004\u0002&>\u0001\r!a*\u0002\u000fI,\u0017/^3tiB!\u0011\u0011VAX\u001b\t\tYKC\u0002\u0002.>\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003c\u000bYK\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$HCBA[\u0003w\u000by\f\u0005\u0003\u0002*\u0006]\u0016\u0002BA]\u0003W\u00131\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016Da!!0\u0011\u0001\u0004y\u0018\u0001\u00037fC\u0012,'/\u00133\t\u000f\u0005\u0015\u0006\u00031\u0001\u0002(\u0006Y1M]3bi\u0016$v\u000e]5d)\u0019\t)-a3\u0002PB)A+a2\u0000\u007f&\u0019\u0011\u0011\u001a/\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0002NF\u0001\ra`\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\u0005E\u0017\u00031\u0001\u0000\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        super.modifyConfigs(props);
        props.foreach((Function1 & Serializable)p -> p.put("unstable.api.versions.enable", "true"));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testListOffsetsErrorCodes(String quorum) {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaBroker)this.brokers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Map topicDescription = (Map)this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.partition().topic(), (List)Nil$.MODULE$)).asJava()).allTopicNames().get();
        Set replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)((TopicDescription)topicDescription.get(this.partition().topic())).partitions().get(this.partition().partition())).replicas()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.brokers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$3(x$3)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCurrentEpochValidation(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(this.sendRequest(serverId, request).topics()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$5))).get()).partitions()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$6))).get();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        void var8_6;
        void var6_5;
        Tuple3<Object, Object, Object> tuple3 = this.fetchOffsetAndEpochWithError(serverId, timestamp, version);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int leaderEpoch = BoxesRunTime.unboxToInt((Object)tuple3._2());
        return new Tuple2.mcJI.sp((long)var6_5, (int)var8_6);
    }

    private Tuple3<Object, Object, Object> fetchOffsetAndEpochWithError(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)partitionData.offset()), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testResponseIncludesLeaderEpoch(String quorum) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"the second leader does not sync to follower");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)firstLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -3L, (short)-1));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions(String quorum) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version == 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version >= 8) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                return;
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return super.createTopic(this.topic(), numPartitions, replicationFactor, super.createTopic$default$4(), super.createTopic$default$5(), super.createTopic$default$6());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$3(KafkaBroker x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$5) {
        String string = x$5.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$6) {
        return x$6.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, -1L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$1.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().foreach((Function1 & Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

