/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.DelayedActionQueue;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015e\u0001\u0002\u00192\u0001YBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004V\u0001\u0001\u0006I!\u0013\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0011\u0019q\u0006\u0001)A\u00051\"9q\f\u0001b\u0001\n\u0003\u0001\u0007BB5\u0001A\u0003%\u0011\rC\u0004k\u0001\t\u0007I\u0011A6\t\r=\u0004\u0001\u0015!\u0003m\u0011\u001d\u0001\bA1A\u0005\u0002EDa!\u001e\u0001!\u0002\u0013\u0011\bb\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002=\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0003\t\t\u0001C\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0001bCA\f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007A1\"!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001c!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0013\u0011-\tI\u0003\u0001a\u0001\u0002\u0003\u0006K!!\b\t\u0017\u0005-\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0006\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0003\ti\u0005C\u0006\u0002R\u0001\u0001\r\u0011!Q!\n\u0005=\u0002bCA*\u0001\u0001\u0007\t\u0019!C\u0001\u0003+B1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002d!Y\u0011q\r\u0001A\u0002\u0003\u0005\u000b\u0015BA,\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!a!\u0001\t\u0003\tY\u0007C\u0004\u0002\u000e\u0002!\t!a\u001b\t\u000f\u0005]\u0005\u0001\"\u0001\u0002l!9\u00111\u0014\u0001\u0005\u0002\u0005-\u0004bBAP\u0001\u0011\u0005\u00111\u000e\u0004\u0007\u0003G\u0003A!!*\t\r\r\u0003C\u0011AAU\u0011%\t)\r\ta\u0001\n\u0013\t9\rC\u0005\u0002P\u0002\u0002\r\u0011\"\u0003\u0002R\"A\u0011Q\u001b\u0011!B\u0013\tI\rC\u0005\u0002X\u0002\u0002\r\u0011\"\u0003\u0002Z\"I\u00111\u001d\u0011A\u0002\u0013%\u0011Q\u001d\u0005\t\u0003S\u0004\u0003\u0015)\u0003\u0002\\\"9\u00111\u001e\u0011\u0005\n\u00055\bbBA{A\u0011\u0005\u0011q\u001f\u0005\b\u0003w\u0004C\u0011AA\u007f\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0003WBqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0005\u0003f\u0001\t\n\u0011\"\u0003\u0003h!I!Q\u0010\u0001\u0012\u0002\u0013%!q\u0010\u0005\b\u0005k\u0001A\u0011\u0002BB\u0005]aunY1m\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u)\u0016\u001cHO\u0003\u00023g\u000511/\u001a:wKJT\u0011\u0001N\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\nU\"A \u000b\u0005\u0001\u001b\u0014!B;uS2\u001c\u0018B\u0001\"@\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A#\u0011\u0005\u0019\u0003Q\"A\u0019\u0002\tQLW.Z\u000b\u0002\u0013B\u0011!jU\u0007\u0002\u0017*\u0011A*T\u0001\u0005kRLGN\u0003\u00023\u001d*\u0011Ag\u0014\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0017\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004u_BL7-\u00133\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!a\u0017(\u0002\r\r|W.\\8o\u0013\ti&L\u0001\u0003Vk&$\u0017\u0001\u0003;pa&\u001c\u0017\n\u001a\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\t1\fgn\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0013A\f'\u000f^5uS>tW#\u00017\u0011\u0005aj\u0017B\u00018:\u0005\rIe\u000e^\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002eB\u0011\u0011l]\u0005\u0003ij\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u00031\u0019x.\u001e:dK\n\u0013xn[3s+\u0005A\bCA=}\u001b\u0005Q(BA>N\u0003\u001dqW\r^<pe.L!! >\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\u0006i1o\\;sG\u0016\u0014%o\\6fe\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002\u0004A\u0019a)!\u0002\n\u0007\u0005\u001d\u0011G\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u001b\t\u0019\u0002E\u00029\u0003\u001fI1!!\u0005:\u0005\u0011)f.\u001b;\t\u0013\u0005Uq\"!AA\u0002\u0005\r\u0011a\u0001=%c\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005f]\u0012\u0004v.\u001b8u+\t\ti\u0002E\u0002G\u0003?I1!!\t2\u00059aU-\u00193fe\u0016sG\rU8j]R\fA\"\u001a8e!>Lg\u000e^0%KF$B!!\u0004\u0002(!I\u0011Q\u0003\n\u0002\u0002\u0003\u0007\u0011QD\u0001\nK:$\u0007k\\5oi\u0002\nA\"];pi\u0006l\u0015M\\1hKJ,\"!a\f\u0011\t\u0005E\u0012Q\t\b\u0005\u0003g\t\tE\u0004\u0003\u00026\u0005}b\u0002BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mR'\u0001\u0004=e>|GOP\u0005\u0002i%\u0011!gM\u0005\u0004\u0003\u0007\n\u0014\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA$\u0003\u0013\u0012Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA\"c\u0005\u0001\u0012/^8uC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u001b\ty\u0005C\u0005\u0002\u0016U\t\t\u00111\u0001\u00020\u0005i\u0011/^8uC6\u000bg.Y4fe\u0002\nQ![7bO\u0016,\"!a\u0016\u0011\t\u0005e\u0013QL\u0007\u0003\u00037R1!a\u0015O\u0013\u0011\ty&a\u0017\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003%IW.Y4f?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005\u0015\u0004\"CA\u000b1\u0005\u0005\t\u0019AA,\u0003\u0019IW.Y4fA\u0005)1/\u001a;VaR\u0011\u0011Q\u0002\u0015\u00045\u0005=\u0004\u0003BA9\u0003\u007fj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0004CBL'\u0002BA=\u0003w\nqA[;qSR,'OC\u0002\u0002~E\u000bQA[;oSRLA!!!\u0002t\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aGAD!\u0011\t\t(!#\n\t\u0005-\u00151\u000f\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0003^3ti\u001a+Go\u00195MCR,7\u000f^(gMN,G\u000fK\u0002\u001d\u0003#\u0003B!!\u001d\u0002\u0014&!\u0011QSA:\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e$fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$\bfA\u000f\u0002\u0012\u0006aB/Z:u\r\u0016$8\r[#be2LWm\u001d;M_\u000e\fGn\u00144gg\u0016$\bf\u0001\u0010\u0002\u0012\u0006AB/Z:u\r\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:)\u0007}\t\tJ\u0001\bDC2d'-Y2l%\u0016\u001cX\u000f\u001c;\u0016\t\u0005\u001d\u00161W\n\u0003A]\"\"!a+\u0011\u000b\u00055\u0006%a,\u000e\u0003\u0001\u0001B!!-\u000242\u0001AaBA[A\t\u0007\u0011q\u0017\u0002\u0002)F!\u0011\u0011XA`!\rA\u00141X\u0005\u0004\u0003{K$a\u0002(pi\"Lgn\u001a\t\u0004q\u0005\u0005\u0017bAAbs\t\u0019\u0011I\\=\u0002\u000bY\fG.^3\u0016\u0005\u0005%\u0007#\u0002\u001d\u0002L\u0006=\u0016bAAgs\t1q\n\u001d;j_:\f\u0011B^1mk\u0016|F%Z9\u0015\t\u00055\u00111\u001b\u0005\n\u0003+\u0019\u0013\u0011!a\u0001\u0003\u0013\faA^1mk\u0016\u0004\u0013a\u00014v]V\u0011\u00111\u001c\t\u0006q\u0005-\u0017Q\u001c\t\bq\u0005}\u0017qVA\u0007\u0013\r\t\t/\u000f\u0002\n\rVt7\r^5p]F\nqAZ;o?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005\u001d\b\"CA\u000bM\u0005\u0005\t\u0019AAn\u0003\u00111WO\u001c\u0011\u0002\u0011!\f7OR5sK\u0012,\"!a<\u0011\u0007a\n\t0C\u0002\u0002tf\u0012qAQ8pY\u0016\fg.\u0001\u0003gSJ,G\u0003BA\u0007\u0003sDq!!2*\u0001\u0004\ty+\u0001\u0004p]\u001aK'/\u001a\u000b\u0005\u0003W\u000by\u0010C\u0004\u0002X*\u0002\r!!8\u0002\u001f\t,X\u000e\u001d'fC\u0012,'/\u00129pG\"\fQ\"\u00199qK:$'+Z2pe\u0012\u001cH\u0003\u0004B\u0004\u0005_\u0011\tDa\r\u0003D\tm\u0003#BAWA\t%\u0001\u0003\u0002B\u0006\u0005SqAA!\u0004\u0003$9!!q\u0002B\u0010\u001d\u0011\u0011\tB!\b\u000f\t\tM!1\u0004\b\u0005\u0005+\u0011IB\u0004\u0003\u00028\t]\u0011\"\u0001*\n\u0005A\u000b\u0016B\u0001\u001bP\u0013\tYf*C\u0002\u0003\"i\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005K\u00119#A\bQe>$WoY3SKN\u0004xN\\:f\u0015\r\u0011\tCW\u0005\u0005\u0005W\u0011iCA\tQCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TAA!\n\u0003(!1q\u0010\fa\u0001\u0003\u0007AQA\u001b\u0017A\u0002IDqA!\u000e-\u0001\u0004\u00119$A\u0004sK\u000e|'\u000fZ:\u0011\t\te\"qH\u0007\u0003\u0005wQ1A!\u0010[\u0003\u0019\u0011XmY8sI&!!\u0011\tB\u001e\u00055iU-\\8ssJ+7m\u001c:eg\"I!Q\t\u0017\u0011\u0002\u0003\u0007!qI\u0001\u0007_JLw-\u001b8\u0011\t\t%#qK\u0007\u0003\u0005\u0017RAA!\u0014\u0003P\u0005\u0019An\\4\u000b\t\tE#1K\u0001\nS:$XM\u001d8bYNT1A!\u0016O\u0003\u001d\u0019Ho\u001c:bO\u0016LAA!\u0017\u0003L\ta\u0011\t\u001d9f]\u0012|%/[4j]\"I!Q\f\u0017\u0011\u0002\u0003\u0007!qL\u0001\re\u0016\fX/\u001b:fI\u0006\u001b7n\u001d\t\u0004q\t\u0005\u0014b\u0001B2s\t)1\u000b[8si\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005SRCAa\u0012\u0003l-\u0012!Q\u000e\t\u0005\u0005_\u0012I(\u0004\u0002\u0003r)!!1\u000fB;\u0003%)hn\u00195fG.,GMC\u0002\u0003xe\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YH!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!\u0011\u0011\u0016\u0005\u0005?\u0012Y'\u0006\u0002\u00038\u0001")
public class LocalLeaderEndPointTest
implements Logging {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;
    private QuotaFactory.QuotaManagers quotaManager;
    private MetadataImage image;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public MetadataImage image() {
        return this.image;
    }

    public void image_$eq(MetadataImage x$1) {
        this.image = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void kRaftMetadataCache_kraftVersionSupplier;
        int x$1 = this.sourceBroker().id();
        int x$2 = this.sourceBroker().port();
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$52 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var48_10 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var49_13 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var50_16 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$3, x$4, x$2, (Option<SecurityProtocol>)x$52, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable)x$5 -> new File((String)x$5))), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), new MockTime(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false, 30000L);
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        this.quotaManager_$eq(QuotaFactory.instantiate((KafkaConfig)config, (Metrics)metrics, (Time)this.time(), (String)""));
        MockTime x$23 = this.time();
        MockScheduler x$24 = new MockScheduler((Time)this.time());
        QuotaFactory.QuotaManagers x$26 = this.quotaManager();
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = config.brokerId();
        supplier = null;
        KRaftMetadataCache x$27 = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        LogDirFailureChannel x$28 = new LogDirFailureChannel(config.logDirs().size());
        None$ x$30 = None$.MODULE$;
        BrokerTopicStats x$31 = new BrokerTopicStats();
        AtomicBoolean x$32 = new AtomicBoolean(false);
        None$ x$33 = None$.MODULE$;
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        None$ x$38 = None$.MODULE$;
        None$ x$39 = None$.MODULE$;
        Function0 x$40 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$41 = None$.MODULE$;
        DirectoryEventHandler x$42 = DirectoryEventHandler.NOOP;
        DelayedActionQueue x$43 = new DelayedActionQueue();
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$23, (Scheduler)x$24, mockLogMgr, (Option)x$30, x$26, (MetadataCache)x$27, x$28, alterPartitionManager, x$31, x$32, (Option)x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, x$40, (Option)x$41, x$42, (ActionQueue)x$43));
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.MINIMUM_VERSION.featureLevel()));
        delta.replay(new TopicRecord().setName(this.topic()).setTopicId(this.topicId()));
        delta.replay(new PartitionRecord().setPartitionId(this.partition()).setTopicId(this.topicId()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava()).setLeader(this.sourceBroker().id()).setLeaderEpoch(0).setPartitionEpoch(0));
        this.image_$eq(delta.apply(MetadataProvenance.EMPTY));
        this.replicaManager().applyDelta(delta.topicsDelta(), this.image());
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), QuotaFactory.UNBOUNDED_QUOTA));
    }

    @AfterEach
    public void tearDown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replicaManager().shutdown(false), (Logging)this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.quotaManager().shutdown(), (Logging)this, Level.WARN);
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        this.bumpLeaderEpoch();
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 1), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        this.bumpLeaderEpoch();
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(response);
            return BoxedUnit.UNIT;
        });
        ReplicaManager qual$1 = this.replicaManager();
        Map x$2 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))}));
        Function1 & Serializable x$3 = (Function1 & Serializable)x$6 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(x$6);
            return BoxedUnit.UNIT;
        };
        boolean x$4 = qual$1.deleteRecords$default$4();
        qual$1.deleteRecords(1000L, x$2, (Function1)x$3, x$4);
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 1), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 0));
        this.bumpLeaderEpoch();
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$2(response);
            return BoxedUnit.UNIT;
        });
        LogManager qual$1 = this.replicaManager().logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        qual$1.getLog(x$1, x$2).foreach((Function1 & Serializable)log -> {
            log._localLogStartOffset_$eq(3L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 1), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        this.bumpLeaderEpoch();
        this.bumpLeaderEpoch();
        Assertions.assertEquals((int)2, (int)this.replicaManager().getPartitionOrException(this.topicPartition()).getLeaderEpoch());
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(response);
            return BoxedUnit.UNIT;
        });
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(2))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(2).setEndOffset(6L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(1))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private void bumpLeaderEpoch() {
        MetadataDelta delta = new MetadataDelta(this.image());
        delta.replay(new PartitionChangeRecord().setTopicId(this.topicId()).setPartitionId(this.partition()).setLeader(this.sourceBroker().id()));
        this.image_$eq(delta.apply(MetadataProvenance.EMPTY));
        this.replicaManager().applyDelta(delta.topicsDelta(), this.image());
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9(), replicaManager.appendRecords$default$10(), replicaManager.appendRecords$default$11());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(Map x$6) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
        this.partition = 5;
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        private boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

