/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadataFile;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

public class LogManagerIntegrationTest {
    private final ClusterInstance cluster;

    public LogManagerIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, brokers=3)
    public void testRestartBrokerNoErrorIfMissingPartitionMetadata() throws IOException, ExecutionException, InterruptedException {
        try (Admin admin = this.cluster.admin();){
            admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, 3))).all().get();
        }
        this.cluster.waitForTopic("foo", 1);
        Optional<PartitionMetadataFile> partitionMetadataFile = Optional.ofNullable((PartitionMetadataFile)((UnifiedLog)((KafkaBroker)this.cluster.brokers().get(0)).logManager().getLog(new TopicPartition("foo", 0), false).get()).partitionMetadataFile().getOrElse(null));
        Assertions.assertTrue((boolean)partitionMetadataFile.isPresent());
        ((KafkaBroker)this.cluster.brokers().get(0)).shutdown();
        try (Admin admin = this.cluster.admin();){
            TestUtils.waitForCondition(() -> {
                List partitionInfos = ((TopicDescription)((KafkaFuture)admin.describeTopics(Collections.singletonList("foo")).topicNameValues().get("foo")).get()).partitions();
                return ((TopicPartitionInfo)partitionInfos.get(0)).isr().size() == 2;
            }, (String)"isr size is not shrink to 2");
        }
        partitionMetadataFile.get().delete();
        Assertions.assertFalse((boolean)partitionMetadataFile.get().exists());
        ((KafkaBroker)this.cluster.brokers().get(0)).startup();
        Assertions.assertTrue((boolean)this.cluster.firstFatalException().isEmpty());
        admin = this.cluster.admin();
        try {
            TestUtils.waitForCondition(() -> {
                List partitionInfos = ((TopicDescription)((KafkaFuture)admin.describeTopics(Collections.singletonList("foo")).topicNameValues().get("foo")).get()).partitions();
                return ((TopicPartitionInfo)partitionInfos.get(0)).isr().size() == 3;
            }, (String)"isr size is not expand to 3");
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
        HashMap<String, String> producerConfigs = new HashMap<String, String>();
        producerConfigs.put("bootstrap.servers", this.cluster.bootstrapServers());
        producerConfigs.put("key.serializer", StringSerializer.class.getName());
        producerConfigs.put("value.serializer", StringSerializer.class.getName());
        try (KafkaProducer producer = new KafkaProducer(producerConfigs);){
            producer.send(new ProducerRecord("foo", Integer.valueOf(0), null, (Object)"bar")).get();
            producer.flush();
        }
        HashMap<String, String> consumerConfigs = new HashMap<String, String>();
        consumerConfigs.put("bootstrap.servers", this.cluster.bootstrapServers());
        consumerConfigs.put("group.id", UUID.randomUUID().toString());
        consumerConfigs.put("key.deserializer", StringDeserializer.class.getName());
        consumerConfigs.put("value.deserializer", StringDeserializer.class.getName());
        try (KafkaConsumer consumer = new KafkaConsumer(consumerConfigs);){
            consumer.assign(Collections.singletonList(new TopicPartition("foo", 0)));
            consumer.seekToBeginning(Collections.singletonList(new TopicPartition("foo", 0)));
            ArrayList<String> values = new ArrayList<String>();
            ConsumerRecords records = consumer.poll(Duration.ofMinutes(1L));
            for (ConsumerRecord record : records) {
                values.add((String)record.value());
            }
            Assertions.assertEquals((int)1, (int)values.size());
            Assertions.assertEquals((Object)"bar", values.get(0));
        }
    }
}

