/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.AbstractMetadataRequestTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005B}AQ\u0001\u000f\u0001\u0005\u0002eBQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQ!\u001d\u0001\u0005\u0002IDQa\u001e\u0001\u0005\u0002aDQ! \u0001\u0005\u0002yDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0002\u0014\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003%M\taa]3sm\u0016\u0014(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0006\t\u00031ei\u0011!E\u0005\u00035E\u00111$\u00112tiJ\f7\r^'fi\u0006$\u0017\r^1SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001e!\tA\u0002!A\u0003tKR,\u0006\u000f\u0006\u0002!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!QK\\5u\u0011\u00159#\u00011\u0001)\u0003!!Xm\u001d;J]\u001a|\u0007CA\u00153\u001b\u0005Q#BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0003[9\nqA[;qSR,'O\u0003\u00020a\u0005)!.\u001e8ji*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003\u0011Q+7\u000f^%oM>D#AA\u001b\u0011\u0005%2\u0014BA\u001c+\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001!i\u0016\u001cHo\u00117vgR,'/\u00133XSRD'+Z9vKN$h+\u001a:tS>t\u0017\u0007\u0006\u0002!u!)1h\u0001a\u0001y\u00051\u0011/^8sk6\u0004\"!\u0010#\u000f\u0005y\u0012\u0005CA #\u001b\u0005\u0001%BA!\u0016\u0003\u0019a$o\\8u}%\u00111II\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002DE!\u00121\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u00172\na\u0001]1sC6\u001c\u0018BA'K\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\u0005\u0007=+f\u000b\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0015\u0006A\u0001O]8wS\u0012,'/\u0003\u0002U#\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd\u0013aV\u0011\u00021\u0006)1N]1gi\u0006!B/Z:u\u00072,8\u000f^3s\u0013\u0012L5OV1mS\u0012$\"\u0001I.\t\u000bm\"\u0001\u0019\u0001\u001f)\u0005\u0011A\u0005\u0006\u0002\u0003P+zc\u0013aV\u0001\ti\u0016\u001cHOU1dWR\u0011\u0001%\u0019\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0015\u0003\u000b!CC!B(VI2\nq+\u0001\buKN$\u0018j]%oi\u0016\u0014h.\u00197\u0015\u0005\u0001:\u0007\"B\u001e\u0007\u0001\u0004a\u0004F\u0001\u0004IQ\u00111q*\u00166-\u0003]\u000b1\u0003^3ti:{Gk\u001c9jGN\u0014V-];fgR$\"\u0001I7\t\u000bm:\u0001\u0019\u0001\u001f)\u0005\u001dA\u0005\u0006B\u0004P+Bd\u0013aV\u0001\u0016i\u0016\u001cH/Q;u_R{\u0007/[2De\u0016\fG/[8o)\t\u00013\u000fC\u0003<\u0011\u0001\u0007A\b\u000b\u0002\t\u0011\"\"\u0001bT+wY\u00059\u0016a\f;fgR\fU\u000f^8De\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0013:4\u0018\r\\5e%\u0016\u0004H.[2bi&|gNR1di>\u0014HC\u0001\u0011z\u0011\u0015Y\u0014\u00021\u0001=Q\tI\u0001\n\u000b\u0003\n\u001fVcH&A,\u0002)Q,7\u000f^!mYR{\u0007/[2t%\u0016\fX/Z:u)\t\u0001s\u0010C\u0003<\u0015\u0001\u0007A\b\u000b\u0002\u000b\u0011\"*!bT+\u0002\u00061\nq+\u0001\fuKN$Hk\u001c9jG&#7/\u00138SKN\u0004xN\\:f)\r\u0001\u00131\u0002\u0005\u0006w-\u0001\r\u0001\u0010\u0015\u0003\u0017!CSaC(V\u0003#a\u0013aV\u0001\u0015i\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1\u0015\u0007\u0001\n9\u0002C\u0003<\u0019\u0001\u0007A\b\u000b\u0002\r\u0011\"*AbT+\u0002\u001e1\nq+A\fuKN$(+\u001a9mS\u000e\fGi\\<o%\u0016\u001c\bo\u001c8tKR\u0019\u0001%a\t\t\u000bmj\u0001\u0019\u0001\u001f)\u00055A\u0005&B\u0007P+\u0006%B&A,\u0002MQ,7\u000f^%te\u00063G/\u001a:Ce>\\WM]*ikR$un\u001e8B]\u0012Tu.\u001b8t\u0005\u0006\u001c7\u000eF\u0002!\u0003_AQa\u000f\bA\u0002qB#A\u0004%)\u000b9yU+!\u000e-\u0003]\u000bA\u0004^3ti\u0006c\u0017N^3Ce>\\WM]:XSRDgj\u001c+pa&\u001c7\u000fF\u0002!\u0003wAQaO\bA\u0002qB#a\u0004%)\u000b=yU+!\u0011-\u0003]\u0003")
public class MetadataRequestTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testClusterIdWithRequestVersion1(String quorum) {
        Assertions.assertNull((Object)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).clusterId(), (String)"v1 clusterId should be null");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testClusterIdIsValid(String quorum) {
        TestUtils.isValidClusterId((String)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)4), this.sendMetadataRequest$default$2()).clusterId());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testRack(String quorum) {
        this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)4), this.sendMetadataRequest$default$2()).brokers().forEach(broker -> Assertions.assertEquals((Object)("rack/" + broker.id()), (Object)broker.rack(), (String)"Rack information should match config"));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIsInternal(String quorum) {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)4), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Iterable topicMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$1))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$2))).get();
        Assertions.assertTrue((boolean)internalTopicMetadata.isInternal(), (String)"internalTopic should show isInternal");
        Assertions.assertFalse((boolean)notInternalTopicMetadata.isInternal(), (String)"notInternalTopic topic not should show isInternal");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.buildCluster().internalTopics());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testNoTopicsRequest(String quorum) {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), true, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertTrue((boolean)metadataResponse.topicMetadata().isEmpty(), (String)"Response should have no topics");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAutoTopicCreation(String quorum) {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAutoCreateTopicWithInvalidReplicationFactor(String quorum) {
        ((IterableOnceOps)this.brokers().tail()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.brokers().tail()).foreach((Function1 & Serializable)x$4 -> {
            x$4.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response1.topicMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAllTopicsRequest(String quorum) {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)Nil$.MODULE$, true), (short)0), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV0.errors().isEmpty(), (String)"V0 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV0.topicMetadata().size(), (String)"V0 Response should have 2 (all) topics");
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV1.errors().isEmpty(), (String)"V1 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV1.topicMetadata().size(), (String)"V1 Response should have 2 (all) topics");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testTopicIdsInResponse(String quorum) {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(topic2, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        MetadataResponse resp1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 0, 9).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp1.topicMetadata().size());
        resp1.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
        MetadataResponse resp2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp2.topicMetadata().size());
        resp2.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
            Assertions.assertNotNull((Object)topicMetadata.topicId());
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testPreferredReplica(String quorum) {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopicWithAssignment("t1", (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        ((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)index -> this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)((KafkaBroker)this.brokers().apply(BoxesRunTime.unboxToInt((Object)index))).socketServer())))).foreach((Function1 & Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$2(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testReplicaDownResponse(String quorum) {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        KafkaBroker downNode = (KafkaBroker)this.brokers().find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, broker))).get();
        downNode.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 50000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testReplicaDownResponse$2(this, replicaDownTopic, downNode)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replica was not found down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$), true), (short)0), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v0BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()))).toSeq();
        Assertions.assertTrue((boolean)v0MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v0BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertTrue((v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0, (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Errors errors = v0PartitionMetadata.error;
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assertions.assertTrue((!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0, (String)"PartitionMetadata should have an error");
        Assertions.assertTrue((v0PartitionMetadata.replicaIds.size() == replicaCount - 1 ? 1 : 0) != 0, (String)("Response should have " + (replicaCount - 1) + " replicas"));
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v1BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toSeq();
        Assertions.assertTrue((boolean)v1MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v1BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertEquals((int)1, (int)v1MetadataResponse.topicMetadata().size(), (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)v1PartitionMetadata.error, (String)"PartitionMetadata should have no errors");
        Assertions.assertEquals((int)replicaCount, (int)v1PartitionMetadata.replicaIds.size(), (String)("Response should have " + replicaCount + " replicas"));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIsrAfterBrokerShutDownAndJoinsBack(String quorum) {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ((KafkaBroker)this.brokers().last()).shutdown();
        ((KafkaBroker)this.brokers().last()).awaitShutdown();
        ((KafkaBroker)this.brokers().last()).startup();
        this.checkIsr$1((Seq)this.brokers(), topic);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAliveBrokersWithNoTopics(String quorum) {
        KafkaBroker brokerToShutdown = (KafkaBroker)this.brokers().last();
        brokerToShutdown.shutdown();
        brokerToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size() - 1);
        brokerToShutdown.startup();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size());
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$1) {
        String string = x$1.topic();
        return !(string != null ? !string.equals(internalTopic$1) : internalTopic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$2) {
        String string = x$2.topic();
        return !(string != null ? !string.equals(notInternalTopic$1) : notInternalTopic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$2(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()))).toSet());
        topicMetadata.partitionMetadata().forEach(partitionMetadata -> {
            Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaIds).asScala());
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala());
            Assertions.assertEquals(Optional.of(assignment.head()), (Object)partitionMetadata.leaderId);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaBroker broker) {
        int serverId = broker.dataPlaneRequestProcessor().brokerId();
        Optional leaderId = partitionMetadata$1.leaderId;
        Buffer replicaIds = CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata$1.replicaIds).asScala();
        return leaderId.isPresent() && !BoxesRunTime.equals(leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)serverId)) && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$3(KafkaBroker downNode$1, Node x$6) {
        return x$6.id() == downNode$1.dataPlaneRequestProcessor().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$2(MetadataRequestTest $this, String replicaDownTopic$1, KafkaBroker downNode$1) {
        MetadataResponse response = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic$1, (List)Nil$.MODULE$)).asJava(), true).build(), $this.sendMetadataRequest$default$2());
        return !CollectionConverters$.MODULE$.CollectionHasAsScala(response.brokers()).asScala().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$3(downNode$1, x$6)));
    }

    public static final /* synthetic */ String $anonfun$testReplicaDownResponse$4() {
        return "Replica was not found down";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaBroker x$9) {
        BrokerState brokerState = x$9.brokerState();
        BrokerState brokerState2 = BrokerState.NOT_RUNNING;
        return brokerState == null ? brokerState2 != null : !brokerState.equals(brokerState2);
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(KafkaBroker x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, KafkaBroker broker$1, ObjectRef actualIsr$1, scala.collection.immutable.Set expectedIsr$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$1.config().brokerId())));
        Option firstPartitionMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.partitionMetadata()).asScala().headOption());
        actualIsr$1.elem = (scala.collection.immutable.Set)firstPartitionMetadata.map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set set = expectedIsr$1;
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)actualIsr$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(KafkaBroker broker$1, scala.collection.immutable.Set expectedIsr$1, ObjectRef actualIsr$1) {
        return "Topic metadata not updated correctly in broker " + broker$1 + "\nExpected ISR: " + expectedIsr$1 + " \nActual ISR : " + (scala.collection.immutable.Set)actualIsr$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(MetadataRequestTest $this, String topic$1, scala.collection.immutable.Set expectedIsr$1, KafkaBroker broker) {
        Predef$.MODULE$.Set().empty();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            MetadataResponse $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker.config().brokerId())));
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.CollectionHasAsScala($anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.partitionMetadata()).asScala().headOption()).map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            scala.collection.immutable.Set set2 = expectedIsr$1;
            Object var10_7 = null;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Topic metadata not updated correctly in broker " + broker + "\nExpected ISR: " + expectedIsr$1 + " \nActual ISR : " + set));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void checkIsr$1(Seq brokers, String topic) {
        Seq activeBrokers = (Seq)brokers.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$9)));
        scala.collection.immutable.Set expectedIsr = ((IterableOnceOps)activeBrokers.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(x$10)))).toSet();
        activeBrokers.foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$1(MetadataRequestTest $this, ObjectRef response$1, int expectedBrokersCount$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.anySocketServer()));
        response$1.elem = new Some((Object)metadataResponse);
        return metadataResponse.brokers().size() == expectedBrokersCount$1;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$2(int expectedBrokersCount$1, ObjectRef response$1) {
        return "Expected " + expectedBrokersCount$1 + " brokers, but there are " + ((MetadataResponse)((Option)response$1.elem).get()).brokers().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaBroker x$13) {
        BrokerState brokerState = x$13.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$6(MetadataRequestTest $this, KafkaBroker broker$2, scala.collection.immutable.Seq brokersSorted$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$2.config().brokerId())));
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Seq topicMetadata = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$15 -> x$15.topic(), (Ordering)Ordering.String$.MODULE$);
        scala.collection.immutable.Seq seq = brokersSorted$1;
        if (!(seq != null ? !seq.equals(brokers) : brokers != null)) {
            Object object = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$16 -> x$16.topic(), (Ordering)Ordering.String$.MODULE$);
            if (!(object != null ? !object.equals(topicMetadata) : topicMetadata != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$10() {
        return "Topic metadata not updated correctly";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAliveBrokersWithNoTopics$5(MetadataRequestTest $this, scala.collection.immutable.Seq brokersSorted$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$6($this, broker, brokersSorted$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic metadata not updated correctly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMetadata$1(Seq brokers, int expectedBrokersCount) {
        Some some;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            MetadataResponse $anonfun$testAliveBrokersWithNoTopics$1_metadataResponse = this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
            some = new Some((Object)$anonfun$testAliveBrokersWithNoTopics$1_metadataResponse);
            Object var10_6 = null;
            if ($anonfun$testAliveBrokersWithNoTopics$1_metadataResponse.brokers().size() == expectedBrokersCount) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Expected " + expectedBrokersCount + " brokers, but there are " + ((MetadataResponse)some.get()).brokers().size()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Seq brokersSorted = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)some.get()).brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableOnceOps)brokers.filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$13)))).foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$5(this, brokersSorted, broker);
            return BoxedUnit.UNIT;
        });
    }
}

