/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.Socket;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.IntegrationTestUtils$;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.test.junit.ClusterTestExtensions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.None$;
import scala.Option;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005-4Aa\u0002\u0005\u0001\u001b!A!\u0003\u0001B\u0001B\u0003%1\u0003C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0003F\u0001\u0011\u0005Q\u0005C\u0003I\u0001\u0011\u0005Q\u0005C\u0003L\u0001\u0011%AJ\u0001\u000eTCNd\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\n\u0015\u000511/\u001a:wKJT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t\u0001\"\u0003\u0002\u0012\u0011\tq\u0012IY:ue\u0006\u001cG/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR+7\u000f^\u0001\bG2,8\u000f^3s!\t!b$D\u0001\u0016\u0015\t1r#\u0001\u0003uKN$(B\u0001\r\u001a\u0003\u0019\u0019w.\\7p]*\u00111B\u0007\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014x-\u0003\u0002 +\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003E\r\u0002\"a\u0004\u0001\t\u000bI\u0011\u0001\u0019A\n\u0002aQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR\u0014UMZ8sKN\u000b7\u000f\u001c%b]\u0012\u001c\b.Y6f%\u0016\fX/Z:u)\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRD\u0003bA\u00174iiZDi\u000f\t\u0003]Ej\u0011a\f\u0006\u0003aU\t1!\u00199j\u0013\t\u0011tFA\u0006DYV\u001cH/\u001a:UKN$\u0018!\u0002;za\u0016\u001cH&A\u001b%\u0003YJ!a\u000e\u001d\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0005ez\u0013\u0001\u0002+za\u0016\faC\u0019:pW\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0013\u0002y%\u0011QHP\u0001\u000f'\u0006\u001bFj\u0018)M\u0003&sE+\u0012-U\u0015\ty\u0004)\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY*\u0011\u0011IQ\u0001\u0005CV$\bN\u0003\u0002D/\u0005A1/Z2ve&$\u00180\u0001\u000ed_:$(o\u001c7mKJ\u001cVmY;sSRL\bK]8u_\u000e|G.A\u0018uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0003\u001a$XM]*bg2D\u0015M\u001c3tQ\u0006\\WMU3rk\u0016\u001cH\u000f\u000b\u0005\u0005[M:%h\u000f#<Y\u0005)\u0014\u0001\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;XSRDWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ!)Qf\r&;w\u0011[D&A\u001b\u0002QM,g\u000eZ*bg2D\u0015M\u001c3tQ\u0006\\WMU3rk\u0016\u001cHOV1mS\u0012\fG/\u001a*fgB|gn]3\u0015\u0005\u0019j\u0005\"\u0002(\u0007\u0001\u0004y\u0015AB:pG.,G\u000f\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006\u0019a.\u001a;\u000b\u0003Q\u000bAA[1wC&\u0011a+\u0015\u0002\u0007'>\u001c7.\u001a;)\t\u0001A6\r\u001a\t\u00033\u0006l\u0011A\u0017\u0006\u00037r\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0005Aj&B\u00010`\u0003\u001dQW\u000f]5uKJT!\u0001\u0019\u000f\u0002\u000b),h.\u001b;\n\u0005\tT&AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nQmI\u0001g!\t9\u0017.D\u0001i\u0015\t\u0001W#\u0003\u0002kQ\n)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class SaslApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(types={Type.KRAFT}, brokerSecurityProtocol=SecurityProtocol.SASL_PLAINTEXT, controllerSecurityProtocol=SecurityProtocol.SASL_PLAINTEXT)
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
            boolean x$2 = !"false".equals(this.cluster.config().serverProperties().get("unstable.api.versions.enable"));
            short x$3 = (short)0;
            ListenerName x$4 = this.validateApiVersionsResponse$default$2();
            boolean x$5 = this.validateApiVersionsResponse$default$4();
            this.validateApiVersionsResponse(apiVersionsResponse, x$4, x$2, x$5, x$3);
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @ClusterTest(types={Type.KRAFT}, brokerSecurityProtocol=SecurityProtocol.SASL_PLAINTEXT, controllerSecurityProtocol=SecurityProtocol.SASL_PLAINTEXT)
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            this.sendSaslHandshakeRequestValidateResponse(socket);
            ApiVersionsResponse response = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
            Assertions.assertEquals((short)Errors.ILLEGAL_SASL_STATE.code(), (short)response.data().errorCode());
        }
    }

    @ClusterTest(types={Type.KRAFT}, brokerSecurityProtocol=SecurityProtocol.SASL_PLAINTEXT, controllerSecurityProtocol=SecurityProtocol.SASL_PLAINTEXT)
    public void testApiVersionsRequestWithUnsupportedVersion() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
            ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
            Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
            ApiVersionsResponse apiVersionsResponse2 = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
            boolean x$2 = !"false".equals(this.cluster.config().serverProperties().get("unstable.api.versions.enable"));
            short x$3 = (short)0;
            ListenerName x$4 = this.validateApiVersionsResponse$default$2();
            boolean x$5 = this.validateApiVersionsResponse$default$4();
            this.validateApiVersionsResponse(apiVersionsResponse2, x$4, x$2, x$5, x$3);
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"), ApiKeys.SASL_HANDSHAKE.latestVersion());
        SaslHandshakeResponse response = (SaslHandshakeResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)request, socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(SaslHandshakeResponse.class));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals(Collections.singletonList("PLAIN"), (Object)response.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

