/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import kafka.server.ClientQuotaManager;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.ClientQuotaMetadataManager$;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.UserEntity;
import org.apache.kafka.image.ClientQuotaDelta;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-2A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011\tq2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\r\u001d\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005)\u0011!\u0005;fgRD\u0015M\u001c3mK&\u0003\u0018+^8uCR\t\u0011\u0004\u0005\u0002\u000f5%\u00111d\u0004\u0002\u0005+:LG\u000f\u000b\u0002\u0003;A\u0011adJ\u0007\u0002?)\u0011\u0001%I\u0001\u0004CBL'B\u0001\u0012$\u0003\u001dQW\u000f]5uKJT!\u0001J\u0013\u0002\u000b),h.\u001b;\u000b\u0003\u0019\n1a\u001c:h\u0013\tAsD\u0001\u0003UKN$\u0018a\b;fgR$&/\u00198tM\u0016\u0014Hk\\\"mS\u0016tG/U;pi\u0006,e\u000e^5us\"\u00121!\b")
public class ClientQuotaMetadataManagerTest {
    @Test
    public void testHandleIpQuota() {
        ClientQuotaMetadataManager manager = new ClientQuotaMetadataManager(null, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> manager.handleIpQuota((QuotaEntity)new IpEntity("a"), new ClientQuotaDelta(null)));
        Assertions.assertThrows(IllegalStateException.class, () -> manager.handleIpQuota((QuotaEntity)new UserEntity("a"), new ClientQuotaDelta(null)));
        Assertions.assertDoesNotThrow((Executable)new Executable(null, manager){
            private final ClientQuotaMetadataManager manager$1;

            public void execute() {
                this.manager$1.handleIpQuota((QuotaEntity)DefaultIpEntity$.MODULE$, new ClientQuotaDelta(null));
            }
            {
                this.manager$1 = manager$1;
            }
        });
        Assertions.assertDoesNotThrow((Executable)new Executable(null, manager){
            private final ClientQuotaMetadataManager manager$1;

            public void execute() {
                this.manager$1.handleIpQuota((QuotaEntity)new IpEntity("192.168.1.1"), new ClientQuotaDelta(null));
            }
            {
                this.manager$1 = manager$1;
            }
        });
        Assertions.assertDoesNotThrow((Executable)new Executable(null, manager){
            private final ClientQuotaMetadataManager manager$1;

            public void execute() {
                this.manager$1.handleIpQuota((QuotaEntity)new IpEntity("2001:db8::1"), new ClientQuotaDelta(null));
            }
            {
                this.manager$1 = manager$1;
            }
        });
    }

    @Test
    public void testTransferToClientQuotaEntity() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)new IpEntity("a")));
        Assertions.assertThrows(IllegalStateException.class, () -> ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)DefaultIpEntity$.MODULE$));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)new ClientQuotaManager.UserEntity("user")), (Object)None$.MODULE$), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)new UserEntity("user")));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Object)None$.MODULE$), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)DefaultUserEntity$.MODULE$));
        Assertions.assertEquals((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new ClientQuotaManager.ClientIdEntity("client"))), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)new ClientIdEntity("client")));
        Assertions.assertEquals((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$)), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)DefaultClientIdEntity$.MODULE$));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)new ClientQuotaManager.UserEntity("user")), (Object)new Some((Object)new ClientQuotaManager.ClientIdEntity("client"))), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)new ExplicitUserExplicitClientIdEntity("user", "client")));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)new ClientQuotaManager.UserEntity("user")), (Object)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$)), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)new ExplicitUserDefaultClientIdEntity("user")));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Object)new Some((Object)new ClientQuotaManager.ClientIdEntity("client"))), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)new DefaultUserExplicitClientIdEntity("client")));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Object)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$)), (Object)ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity((QuotaEntity)DefaultUserDefaultClientIdEntity$.MODULE$));
    }
}

