/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.cluster.Partition;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.share.DelayedShareFetch;
import kafka.server.share.SharePartition;
import kafka.server.share.SharePartitionManagerTest;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.purgatory.DelayedOperationPurgatory;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.SystemTimerReaper;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.collection.Seq;

public class DelayedShareFetchTest {
    private static final int MAX_WAIT_MS = 5000;
    private static final int MAX_FETCH_RECORDS = 100;
    private static final FetchParams FETCH_PARAMS = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 5000L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty(), true);
    private Timer mockTimer;

    @BeforeEach
    public void setUp() {
        this.mockTimer = new SystemTimerReaper("DelayedShareFetchTestReaper", (Timer)new SystemTimer("DelayedShareFetchTestTimer"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.mockTimer.close();
    }

    @Test
    public void testDelayedShareFetchTryCompleteReturnsFalseDueToNonAcquirablePartitions() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)false);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)false);
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions).build());
        Assertions.assertFalse((boolean)delayedShareFetch.tryComplete());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)0))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    @Test
    public void testTryCompleteWhenMinBytesNotSatisfiedOnFirstFetch() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 5000L, 2, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)false);
        Mockito.when((Object)sp0.acquire((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        Mockito.when((Object)sp0.fetchOffsetMetadata(ArgumentMatchers.anyLong())).thenReturn(Optional.empty()).thenReturn(Optional.of(new LogOffsetMetadata(0L, 1L, 0)));
        LogOffsetMetadata hwmOffsetMetadata = new LogOffsetMetadata(1L, 1L, 1);
        this.mockTopicIdPartitionFetchBytes(replicaManager, tp0, hwmOffsetMetadata);
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp0))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        BiConsumer<SharePartitionKey, Throwable> exceptionHandler = DelayedShareFetchTest.mockExceptionHandler();
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions).withReplicaManager(replicaManager).withExceptionHandler(exceptionHandler).build());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        Assertions.assertFalse((boolean)delayedShareFetch.tryComplete());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
        ((BiConsumer)Mockito.verify(exceptionHandler, (VerificationMode)Mockito.times((int)1))).accept((SharePartitionKey)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }

    @Test
    public void testTryCompleteWhenMinBytesNotSatisfiedOnSubsequentFetch() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 5000L, 2, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)false);
        Mockito.when((Object)sp0.acquire((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        LogOffsetMetadata hwmOffsetMetadata = (LogOffsetMetadata)Mockito.mock(LogOffsetMetadata.class);
        Mockito.when((Object)hwmOffsetMetadata.positionDiff((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)1);
        Mockito.when((Object)sp0.fetchOffsetMetadata(ArgumentMatchers.anyLong())).thenReturn(Optional.of((LogOffsetMetadata)Mockito.mock(LogOffsetMetadata.class)));
        this.mockTopicIdPartitionFetchBytes(replicaManager, tp0, hwmOffsetMetadata);
        BiConsumer<SharePartitionKey, Throwable> exceptionHandler = DelayedShareFetchTest.mockExceptionHandler();
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions).withReplicaManager(replicaManager).withExceptionHandler(exceptionHandler).build());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        Assertions.assertFalse((boolean)delayedShareFetch.tryComplete());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
        ((BiConsumer)Mockito.verify(exceptionHandler, (VerificationMode)Mockito.times((int)1))).accept((SharePartitionKey)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }

    @Test
    public void testDelayedShareFetchTryCompleteReturnsTrue() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)false);
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp0))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.fetchOffsetMetadata(ArgumentMatchers.anyLong())).thenReturn(Optional.of(new LogOffsetMetadata(0L, 1L, 0)));
        DelayedShareFetchTest.mockTopicIdPartitionToReturnDataEqualToMinBytes(replicaManager, tp0, 1);
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions).withReplicaManager(replicaManager).build());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        Assertions.assertTrue((boolean)delayedShareFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    @Test
    public void testEmptyFutureReturnedByDelayedShareFetchOnComplete() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        CompletableFuture future = new CompletableFuture();
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), future, partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)false);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)false);
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withReplicaManager(replicaManager).withSharePartitions(sharePartitions).build());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        delayedShareFetch.forceComplete();
        Assertions.assertEquals((int)0, (int)((Map)future.join()).size());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)0))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    @Test
    public void testReplicaManagerFetchShouldHappenOnComplete() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)false);
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp0))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withReplicaManager(replicaManager).withSharePartitions(sharePartitions).build());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        delayedShareFetch.forceComplete();
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).nextFetchOffset();
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).nextFetchOffset();
        Assertions.assertTrue((boolean)delayedShareFetch.isCompleted());
        Assertions.assertTrue((boolean)shareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    @Test
    public void testToCompleteAnAlreadyCompletedFuture() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        CompletableFuture future = new CompletableFuture();
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), future, partitionMaxBytes, 100);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)false);
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withReplicaManager(replicaManager).withSharePartitions(sharePartitions).build());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        delayedShareFetch.forceComplete();
        Assertions.assertTrue((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).acquirablePartitions();
        Assertions.assertEquals((int)0, (int)((Map)future.join()).size());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
        delayedShareFetch.forceComplete();
        Assertions.assertTrue((boolean)delayedShareFetch.isCompleted());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).acquirablePartitions();
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)0))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    @Test
    public void testForceCompleteTriggersDelayedActionsQueue() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(topicId, new TopicPartition("foo", 2));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes1 = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes1.put(tp0, 40000);
        partitionMaxBytes1.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)false);
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)false);
        Mockito.when((Object)sp2.maybeAcquireFetchLock()).thenReturn((Object)false);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions1 = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions1.put(tp0, sp0);
        sharePartitions1.put(tp1, sp1);
        sharePartitions1.put(tp2, sp2);
        ShareFetch shareFetch1 = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes1, 100);
        DelayedOperationPurgatory delayedShareFetchPurgatory = new DelayedOperationPurgatory("TestShareFetch", this.mockTimer, replicaManager.localBrokerId(), 1000, true, true);
        SharePartitionManagerTest.mockReplicaManagerDelayedShareFetch(replicaManager, (DelayedOperationPurgatory<DelayedShareFetch>)delayedShareFetchPurgatory);
        ArrayList delayedShareFetchWatchKeys = new ArrayList();
        partitionMaxBytes1.keySet().forEach(topicIdPartition -> delayedShareFetchWatchKeys.add(new DelayedShareFetchGroupKey(groupId, topicIdPartition.topicId(), topicIdPartition.partition())));
        DelayedShareFetch delayedShareFetch1 = DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch1).withReplicaManager(replicaManager).withSharePartitions(sharePartitions1).build();
        delayedShareFetchPurgatory.tryCompleteElseWatch((DelayedOperation)delayedShareFetch1, delayedShareFetchWatchKeys);
        Assertions.assertEquals((int)2, (int)delayedShareFetchPurgatory.watched());
        Assertions.assertFalse((boolean)shareFetch1.isCompleted());
        Assertions.assertTrue((boolean)delayedShareFetch1.lock().tryLock());
        delayedShareFetch1.lock().unlock();
        HashMap<TopicIdPartition, Integer> partitionMaxBytes2 = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes2.put(tp1, 40000);
        partitionMaxBytes2.put(tp2, 40000);
        ShareFetch shareFetch2 = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes2, 100);
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp1))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions2 = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions2.put(tp0, sp0);
        sharePartitions2.put(tp1, sp1);
        sharePartitions2.put(tp2, sp2);
        DelayedShareFetch delayedShareFetch2 = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch2).withReplicaManager(replicaManager).withSharePartitions(sharePartitions2).build());
        Mockito.when((Object)sp1.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp1.canAcquireRecords()).thenReturn((Object)true);
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        delayedShareFetch2.forceComplete();
        Assertions.assertTrue((boolean)delayedShareFetch2.isCompleted());
        Assertions.assertTrue((boolean)shareFetch2.isCompleted());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        Assertions.assertFalse((boolean)delayedShareFetch1.isCompleted());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).addToActionQueue((Runnable)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).tryCompleteActions();
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch2, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch2.lock().tryLock());
        delayedShareFetch2.lock().unlock();
    }

    @Test
    public void testCombineLogReadResponse() {
        String groupId = "grp";
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        CompletableFuture future = new CompletableFuture();
        ShareFetch shareFetch = new ShareFetch(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 5000L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, Uuid.randomUuid().toString(), future, partitionMaxBytes, 100);
        DelayedShareFetch delayedShareFetch = DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withReplicaManager(replicaManager).withSharePartitions(sharePartitions).build();
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> topicPartitionData = new LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData>();
        topicPartitionData.put(tp0, (FetchRequest.PartitionData)Mockito.mock(FetchRequest.PartitionData.class));
        topicPartitionData.put(tp1, (FetchRequest.PartitionData)Mockito.mock(FetchRequest.PartitionData.class));
        LinkedHashMap<TopicIdPartition, LogReadResult> logReadResponse = new LinkedHashMap<TopicIdPartition, LogReadResult>();
        logReadResponse.put(tp0, (LogReadResult)Mockito.mock(LogReadResult.class));
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp1))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        LinkedHashMap combinedLogReadResponse = delayedShareFetch.combineLogReadResponse(topicPartitionData, logReadResponse);
        Assertions.assertEquals(topicPartitionData.keySet(), combinedLogReadResponse.keySet());
        Assertions.assertEquals(combinedLogReadResponse.get(tp0), logReadResponse.get(tp0));
        logReadResponse = new LinkedHashMap();
        logReadResponse.put(tp0, (LogReadResult)Mockito.mock(LogReadResult.class));
        logReadResponse.put(tp1, (LogReadResult)Mockito.mock(LogReadResult.class));
        combinedLogReadResponse = delayedShareFetch.combineLogReadResponse(topicPartitionData, logReadResponse);
        Assertions.assertEquals(topicPartitionData.keySet(), combinedLogReadResponse.keySet());
        Assertions.assertEquals(combinedLogReadResponse.get(tp0), logReadResponse.get(tp0));
        Assertions.assertEquals(combinedLogReadResponse.get(tp1), logReadResponse.get(tp1));
    }

    @Test
    public void testExceptionInMinBytesCalculation() {
        String groupId = "grp";
        Uuid topicId = Uuid.randomUuid();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        ShareFetch shareFetch = new ShareFetch(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 5000L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        Mockito.when((Object)sp0.acquire((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp0))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)replicaManager.getPartitionOrException(tp0.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot((Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("Exception thrown")});
        BiConsumer<SharePartitionKey, Throwable> exceptionHandler = DelayedShareFetchTest.mockExceptionHandler();
        DelayedShareFetch delayedShareFetch = (DelayedShareFetch)Mockito.spy((Object)DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions).withReplicaManager(replicaManager).withExceptionHandler(exceptionHandler).build());
        Assertions.assertFalse((boolean)delayedShareFetch.tryComplete());
        Assertions.assertFalse((boolean)delayedShareFetch.isCompleted());
        Assertions.assertTrue((boolean)shareFetch.errorInAllPartitions());
        ((BiConsumer)Mockito.verify(exceptionHandler, (VerificationMode)Mockito.times((int)1))).accept((SharePartitionKey)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)delayedShareFetch.forceComplete());
        Assertions.assertTrue((boolean)delayedShareFetch.isCompleted());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        ((DelayedShareFetch)Mockito.verify((Object)delayedShareFetch, (VerificationMode)Mockito.times((int)1))).releasePartitionLocks((Set)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
        ((BiConsumer)Mockito.verify(exceptionHandler, (VerificationMode)Mockito.times((int)1))).accept((SharePartitionKey)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }

    @Test
    public void testLocksReleasedForCompletedFetch() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions1 = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions1.put(tp0, sp0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ((ReplicaManager)Mockito.doAnswer(invocation -> SharePartitionManagerTest.buildLogReadResult(Collections.singleton(tp0))).when((Object)replicaManager)).readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), ArgumentMatchers.anyBoolean());
        DelayedShareFetchTest.mockTopicIdPartitionToReturnDataEqualToMinBytes(replicaManager, tp0, 1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), Map.of(tp0, 40000), 100);
        DelayedShareFetch delayedShareFetch = DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions1).withReplicaManager(replicaManager).build();
        DelayedShareFetch spy = (DelayedShareFetch)Mockito.spy((Object)delayedShareFetch);
        ((DelayedShareFetch)Mockito.doReturn((Object)false).when((Object)spy)).forceComplete();
        Assertions.assertFalse((boolean)spy.tryComplete());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).releaseFetchLock();
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    @Test
    public void testLocksReleasedAcquireException() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp0.canAcquireRecords()).thenThrow(new Throwable[]{new RuntimeException("Acquire exception")});
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), Map.of(tp0, 40000), 100);
        DelayedShareFetch delayedShareFetch = DelayedShareFetchBuilder.builder().withShareFetchData(shareFetch).withSharePartitions(sharePartitions).build();
        Assertions.assertFalse((boolean)delayedShareFetch.tryComplete());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).releaseFetchLock();
        Assertions.assertTrue((boolean)delayedShareFetch.lock().tryLock());
        delayedShareFetch.lock().unlock();
    }

    static void mockTopicIdPartitionToReturnDataEqualToMinBytes(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, int minBytes) {
        LogOffsetMetadata hwmOffsetMetadata = new LogOffsetMetadata(1L, 1L, minBytes);
        LogOffsetSnapshot endOffsetSnapshot = new LogOffsetSnapshot(1L, (LogOffsetMetadata)Mockito.mock(LogOffsetMetadata.class), hwmOffsetMetadata, (LogOffsetMetadata)Mockito.mock(LogOffsetMetadata.class));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.isLeader()).thenReturn((Object)true);
        Mockito.when((Object)partition.getLeaderEpoch()).thenReturn((Object)1);
        Mockito.when((Object)partition.fetchOffsetSnapshot((Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)endOffsetSnapshot);
        Mockito.when((Object)replicaManager.getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
    }

    private void mockTopicIdPartitionFetchBytes(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, LogOffsetMetadata hwmOffsetMetadata) {
        LogOffsetSnapshot endOffsetSnapshot = new LogOffsetSnapshot(1L, (LogOffsetMetadata)Mockito.mock(LogOffsetMetadata.class), hwmOffsetMetadata, (LogOffsetMetadata)Mockito.mock(LogOffsetMetadata.class));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.fetchOffsetSnapshot((Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)endOffsetSnapshot);
        Mockito.when((Object)replicaManager.getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
    }

    private static BiConsumer<SharePartitionKey, Throwable> mockExceptionHandler() {
        return (BiConsumer)Mockito.mock(BiConsumer.class);
    }

    static class DelayedShareFetchBuilder {
        ShareFetch shareFetch = (ShareFetch)Mockito.mock(ShareFetch.class);
        private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        private BiConsumer<SharePartitionKey, Throwable> exceptionHandler = DelayedShareFetchTest.mockExceptionHandler();
        private LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = (LinkedHashMap)Mockito.mock(LinkedHashMap.class);

        DelayedShareFetchBuilder() {
        }

        DelayedShareFetchBuilder withShareFetchData(ShareFetch shareFetch) {
            this.shareFetch = shareFetch;
            return this;
        }

        DelayedShareFetchBuilder withReplicaManager(ReplicaManager replicaManager) {
            this.replicaManager = replicaManager;
            return this;
        }

        DelayedShareFetchBuilder withExceptionHandler(BiConsumer<SharePartitionKey, Throwable> exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        DelayedShareFetchBuilder withSharePartitions(LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions) {
            this.sharePartitions = sharePartitions;
            return this;
        }

        public static DelayedShareFetchBuilder builder() {
            return new DelayedShareFetchBuilder();
        }

        public DelayedShareFetch build() {
            return new DelayedShareFetch(this.shareFetch, this.replicaManager, this.exceptionHandler, this.sharePartitions);
        }
    }
}

