/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.network.RequestChannel;
import kafka.security.JaasTestUtils;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.javaapi.OptionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$ = new TestUtils$();
    private static final Random random = TestUtils.RANDOM;
    private static final int RandomPort = 0;
    private static final int IncorrectBrokerPort = 225;
    private static final String SslCertificateCn = "localhost";
    private static final String kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
    private static final byte[] kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
    private static final byte[] kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    private static final AuthorizableRequestContext anonymousAuthorizableContext = new AuthorizableRequestContext(){

        public String listenerName() {
            return "";
        }

        public SecurityProtocol securityProtocol() {
            return SecurityProtocol.PLAINTEXT;
        }

        public KafkaPrincipal principal() {
            return KafkaPrincipal.ANONYMOUS;
        }

        public InetAddress clientAddress() {
            return null;
        }

        public int requestType() {
            return 0;
        }

        public int requestVersion() {
            return 0;
        }

        public String clientId() {
            return "";
        }

        public int correlationId() {
            return 0;
        }
    };
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$((Logging)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String logIdent() {
        return logIdent;
    }

    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Random random() {
        return random;
    }

    public int RandomPort() {
        return RandomPort;
    }

    public int IncorrectBrokerPort() {
        return IncorrectBrokerPort;
    }

    public String SslCertificateCn() {
        return SslCertificateCn;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory(null, null);
    }

    public File tempRelativeDir(String root) {
        return TestUtils.tempRelativeDir((String)root);
    }

    public File randomPartitionLogDir(File parentDir) {
        return TestUtils.randomPartitionLogDir((File)parentDir);
    }

    public File tempFile() {
        return TestUtils.tempFile((String)"kafka", (String)".tmp");
    }

    public File tempFile(String prefix, String suffix) {
        return TestUtils.tempFile((String)prefix, (String)suffix);
    }

    public File tempPropertiesFile(Map<String, String> properties) {
        return TestUtils.tempFile((String)((IterableOnceOps)properties.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return k + "=" + v;
            }
            throw new MatchError(null);
        })).mkString(System.lineSeparator()));
    }

    public scala.collection.Seq<Properties> createBrokerConfigs(int numConfigs, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor, int startingIdNumber, boolean enableFetchFromFollower) {
        int endingIdNumber = startingIdNumber + numConfigs - 1;
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startingIdNumber), endingIdNumber).map((Function1 & Serializable)node -> TestUtils$.$anonfun$createBrokerConfigs$1(enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, logDirCount, enableToken, numPartitions, defaultReplicationFactor, enableFetchFromFollower, BoxesRunTime.unboxToInt((Object)node)));
    }

    public <B extends KafkaBroker> String plaintextBootstrapServers(scala.collection.Seq<B> brokers) {
        return this.bootstrapServers(brokers, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
    }

    public <B extends KafkaBroker> String bootstrapServers(scala.collection.Seq<B> brokers, ListenerName listenerName) {
        return ((IterableOnceOps)brokers.map((Function1 & Serializable)s -> Utils.formatAddress((String)((EndPoint)s.config().effectiveAdvertisedBrokerListeners().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$bootstrapServers$2(listenerName, x$1))).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error("Could not find listener with name " + listenerName.value()))).host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(listenerName))))).mkString(",");
    }

    public <B extends KafkaBroker> void shutdownServers(scala.collection.Seq<B> brokers, boolean deleteLogDirs) {
        Future future = Future$.MODULE$.traverse(brokers, (Function1 & Serializable)s -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            s.shutdown();
            if (deleteLogDirs) {
                CoreUtils$.MODULE$.delete(s.config().logDirs());
                return;
            }
        }, ExecutionContext.Implicits$.MODULE$.global()), BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)future, (Duration)FiniteDuration$.MODULE$.apply(5L, TimeUnit.MINUTES));
    }

    public <B extends KafkaBroker> boolean shutdownServers$default$2() {
        return true;
    }

    public Properties createDummyBrokerConfig() {
        return this.createBrokerConfig(0, true, true, this.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, this.RandomPort(), false, this.RandomPort(), false, this.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
    }

    public Properties createBrokerConfig(int nodeId, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor, boolean enableFetchFromFollower) {
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (enablePlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port)));
        }
        if (enableSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort)));
        }
        if (enableSaslPlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort)));
        }
        if (enableSaslSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort)));
        }
        String listeners = ((IterableOnceOps)protocolAndPorts.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                SecurityProtocol protocol = (SecurityProtocol)x0$1._1();
                int port = x0$1._2$mcI$sp();
                return protocol.name + "://localhost:" + port;
            }
            throw new MatchError(null);
        })).mkString(",");
        Properties props = new Properties();
        props.put("unstable.feature.versions.enable", "true");
        props.put("unstable.api.versions.enable", "true");
        props.setProperty("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.put("node.id", Integer.toString(nodeId));
        props.put("broker.id", Integer.toString(nodeId));
        props.put("advertised.listeners", listeners);
        props.put("listeners", listeners);
        props.put("controller.listener.names", "CONTROLLER");
        props.put("listener.security.protocol.map", ((IterableOnceOps)protocolAndPorts.map((Function1 & Serializable)p -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p._1(), p._1()})))).mkString(",") + ",CONTROLLER:PLAINTEXT");
        if (logDirCount > 1) {
            String logDirs = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), logDirCount).toList().map((Function1 & Serializable)i -> TestUtils$.$anonfun$createBrokerConfig$5(BoxesRunTime.unboxToInt((Object)i))).mkString(",");
            props.put("log.dirs", logDirs);
        } else {
            props.put("log.dir", TestUtils.tempDirectory(null, null).getAbsolutePath());
        }
        props.put("process.roles", "broker");
        props.put("controller.quorum.voters", "1000@localhost:0");
        props.put("replica.socket.timeout.ms", "1500");
        props.put("controller.socket.timeout.ms", "1500");
        props.put("controlled.shutdown.enable", Boolean.toString(enableControlledShutdown));
        props.put("delete.topic.enable", Boolean.toString(enableDeleteTopic));
        props.put(ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, "1000");
        props.put("log.cleaner.dedupe.buffer.size", "2097152");
        props.put("offsets.topic.replication.factor", "1");
        props.put("log.initial.task.delay.ms", "100");
        if (!props.containsKey("offsets.topic.num.partitions")) {
            props.put("offsets.topic.num.partitions", "5");
        }
        if (!props.containsKey("group.initial.rebalance.delay.ms")) {
            props.put("group.initial.rebalance.delay.ms", "0");
        }
        rack.foreach((Function1 & Serializable)x$3 -> props.put("broker.rack", x$3));
        props.put("num.network.threads", "2");
        props.put("background.threads", "2");
        if (protocolAndPorts.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$7(x0$2)))) {
            new Implicits.PropertiesOps(props).$plus$plus$eq(JaasTestUtils.sslConfigs(ConnectionMode.SERVER, false, OptionConverters$.MODULE$.toJava(trustStoreFile), "server" + nodeId));
        }
        if (protocolAndPorts.exists((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$8(x0$3)))) {
            new Implicits.PropertiesOps(props).$plus$plus$eq(JaasTestUtils.saslConfigs(OptionConverters.RichOption$.MODULE$.toJava$extension(scala.jdk.OptionConverters$.MODULE$.RichOption(saslProperties))));
        }
        interBrokerSecurityProtocol.foreach((Function1 & Serializable)protocol -> props.put("security.inter.broker.protocol", protocol.name));
        if (enableToken) {
            props.put("delegation.token.secret.key", "secretkey");
        }
        props.put("num.partitions", Integer.toString(numPartitions));
        props.put("default.replication.factor", Short.toString(defaultReplicationFactor));
        if (enableFetchFromFollower) {
            props.put("broker.rack", Integer.toString(nodeId));
            props.put("replica.selector.class", "org.apache.kafka.common.replica.RackAwareReplicaSelector");
        }
        return props;
    }

    public boolean createBrokerConfigs$default$2() {
        return true;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$4() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$7() {
        return true;
    }

    public boolean createBrokerConfigs$default$8() {
        return false;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$11() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int createBrokerConfigs$default$12() {
        return 1;
    }

    public boolean createBrokerConfigs$default$13() {
        return false;
    }

    public int createBrokerConfigs$default$14() {
        return 1;
    }

    public short createBrokerConfigs$default$15() {
        return 1;
    }

    public int createBrokerConfigs$default$16() {
        return 0;
    }

    public boolean createBrokerConfigs$default$17() {
        return false;
    }

    public boolean createBrokerConfig$default$2() {
        return true;
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public int createBrokerConfig$default$4() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$8() {
        return true;
    }

    public boolean createBrokerConfig$default$9() {
        return false;
    }

    public int createBrokerConfig$default$10() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$11() {
        return false;
    }

    public int createBrokerConfig$default$12() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$13() {
        return false;
    }

    public int createBrokerConfig$default$14() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$15() {
        return None$.MODULE$;
    }

    public int createBrokerConfig$default$16() {
        return 1;
    }

    public boolean createBrokerConfig$default$17() {
        return false;
    }

    public int createBrokerConfig$default$18() {
        return 1;
    }

    public short createBrokerConfig$default$19() {
        return 1;
    }

    public boolean createBrokerConfig$default$20() {
        return false;
    }

    public <B extends KafkaBroker> Admin createAdminClient(scala.collection.Seq<B> brokers, ListenerName listenerName, Properties adminConfig) {
        Properties adminClientProperties = new Properties();
        adminClientProperties.putAll((java.util.Map<?, ?>)adminConfig);
        if (!adminClientProperties.containsKey("bootstrap.servers") && !adminClientProperties.containsKey("bootstrap.controllers")) {
            adminClientProperties.put("bootstrap.servers", this.bootstrapServers(brokers, listenerName));
        }
        return Admin.create((Properties)adminClientProperties);
    }

    public <B extends KafkaBroker> Properties createAdminClient$default$3() {
        return new Properties();
    }

    public <B extends KafkaBroker> Uuid createTopicWithAdminRaw(Admin admin, String topic, int numPartitions, int replicationFactor, Map<Object, scala.collection.Seq<Object>> replicaAssignment, Properties topicConfig) {
        CreateTopicsResult createTopicsResult;
        java.util.HashMap configsMap = new java.util.HashMap();
        topicConfig.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> configsMap.put(k.toString(), v.toString())));
        if (replicaAssignment.isEmpty()) {
            createTopicsResult = admin.createTopics(Collections.singletonList(new NewTopic(topic, numPartitions, (short)replicationFactor).configs(configsMap)));
        } else {
            java.util.HashMap assignment = new java.util.HashMap();
            replicaAssignment.foreachEntry((Function2 & Serializable)(x0$1, x1$1) -> TestUtils$.$anonfun$createTopicWithAdminRaw$2(assignment, BoxesRunTime.unboxToInt((Object)x0$1), x1$1));
            createTopicsResult = admin.createTopics(Collections.singletonList(new NewTopic(topic, assignment).configs(configsMap)));
        }
        return (Uuid)createTopicsResult.topicId(topic).get();
    }

    public <B extends KafkaBroker> scala.collection.immutable.Map<Object, Object> createTopicWithAdmin(Admin admin, String topic, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers, int numPartitions, int replicationFactor, Map<Object, scala.collection.Seq<Object>> replicaAssignment, Properties topicConfig) {
        int effectiveNumPartitions;
        block2: {
            effectiveNumPartitions = replicaAssignment.isEmpty() ? numPartitions : replicaAssignment.size();
            try {
                this.createTopicWithAdminRaw(admin, topic, numPartitions, replicationFactor, replicaAssignment, topicConfig);
            }
            catch (ExecutionException e) {
                if (this.isTopicExistsAndHasSameNumPartitionsAndReplicationFactor$1(e.getCause(), brokers, topic, effectiveNumPartitions, admin, replicationFactor)) break block2;
                throw e;
            }
        }
        Map<TopicPartition, LeaderAndIsr> allPartitionsMetadata = this.waitForAllPartitionsMetadata(brokers, topic, effectiveNumPartitions);
        controllers.foreach((Function1 & Serializable)controller -> {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((scala.collection.Seq<KafkaBroker>)brokers, controller, "Timeout waiting for controller metadata propagating to brokers");
            return BoxedUnit.UNIT;
        });
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), effectiveNumPartitions).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), allPartitionsMetadata.get((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.leader())).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Cannot get the partition leader for topic: " + topic$1 + ", partition: " + i + " in server metadata cache");
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <B extends KafkaBroker> int createTopicWithAdminRaw$default$3() {
        return 1;
    }

    public <B extends KafkaBroker> int createTopicWithAdminRaw$default$4() {
        return 1;
    }

    public <B extends KafkaBroker> Map<Object, scala.collection.Seq<Object>> createTopicWithAdminRaw$default$5() {
        return (Map)Map$.MODULE$.empty();
    }

    public <B extends KafkaBroker> Properties createTopicWithAdminRaw$default$6() {
        return new Properties();
    }

    public <B extends KafkaBroker> int createTopicWithAdmin$default$5() {
        return 1;
    }

    public <B extends KafkaBroker> int createTopicWithAdmin$default$6() {
        return 1;
    }

    public <B extends KafkaBroker> Map<Object, scala.collection.Seq<Object>> createTopicWithAdmin$default$7() {
        return (Map)Map$.MODULE$.empty();
    }

    public <B extends KafkaBroker> Properties createTopicWithAdmin$default$8() {
        return new Properties();
    }

    public TopicDescription describeTopic(Admin admin, String topic) {
        return (TopicDescription)((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).get(topic);
    }

    public boolean topicHasSameNumPartitionsAndReplicationFactor(Admin adminClient, String topic, int numPartitions, int replicationFactor) {
        TopicDescription description = this.describeTopic(adminClient, topic);
        return description != null && description.partitions().size() == numPartitions && ((TopicPartitionInfo)description.partitions().iterator().next()).replicas().size() == replicationFactor;
    }

    public <B extends KafkaBroker> Map<Object, Object> createOffsetsTopicWithAdmin(Admin admin, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        KafkaBroker broker = (KafkaBroker)brokers.head();
        int x$3 = Predef$.MODULE$.Integer2int(broker.config().getInt("offsets.topic.num.partitions"));
        short x$4 = Predef$.MODULE$.Short2short(broker.config().getShort("offsets.topic.replication.factor"));
        Properties x$7 = broker.groupCoordinator().groupMetadataTopicConfigs();
        Map x$8 = (Map)Map$.MODULE$.empty();
        return this.createTopicWithAdmin(admin, "__consumer_offsets", brokers, controllers, x$3, x$4, (Map<Object, scala.collection.Seq<Object>>)x$8, x$7);
    }

    public <B extends KafkaBroker> Map<Object, Object> createTransactionStateTopicWithAdmin(Admin admin, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        KafkaBroker broker = (KafkaBroker)brokers.head();
        int x$3 = Predef$.MODULE$.Integer2int(broker.config().getInt("transaction.state.log.num.partitions"));
        short x$4 = Predef$.MODULE$.Short2short(broker.config().getShort("transaction.state.log.replication.factor"));
        Properties x$7 = new Properties();
        Map x$8 = (Map)Map$.MODULE$.empty();
        return this.createTopicWithAdmin(admin, "__transaction_state", brokers, controllers, x$3, x$4, (Map<Object, scala.collection.Seq<Object>>)x$8, x$7);
    }

    public <B extends KafkaBroker> void deleteTopicWithAdmin(Admin admin, String topic, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        block2: {
            try {
                admin.deleteTopics(Collections.singletonList(topic)).all().get();
            }
            catch (Throwable throwable) {
                ExecutionException executionException;
                if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null && executionException.getCause() instanceof UnknownTopicOrPartitionException) break block2;
                throw throwable;
            }
        }
        this.waitForAllPartitionsMetadata(brokers, topic, 0);
        controllers.foreach((Function1 & Serializable)controller -> {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((scala.collection.Seq<KafkaBroker>)brokers, controller, "Timeout waiting for controller metadata propagating to brokers");
            return BoxedUnit.UNIT;
        });
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, Compression codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(timestamp, key, value), (List)Nil$.MODULE$), magicValue, codec, -1L, (short)-1, -1, 0L, -1);
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public Compression singletonRecords$default$3() {
        return Compression.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(Iterable<SimpleRecord> records, byte magicValue, Compression codec, long producerId, short producerEpoch, int sequence, long baseOffset, int partitionLeaderEpoch) {
        void builder_isTransactional;
        void builder_logAppendTime;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        boolean bl = false;
        long l = System.currentTimeMillis();
        TimestampType builder_timestampType = TimestampType.CREATE_TIME;
        Object var13_12 = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (Compression)codec, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)sequence, (boolean)builder_isTransactional, (boolean)false, (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public Compression records$default$3() {
        return Compression.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public int records$default$8() {
        return -1;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public <K, V> KafkaProducer<K, V> createProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, int deliveryTimeoutMs, int lingerMs, int batchSize, String compressionType, int requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean enableIdempotence) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", Integer.toString(acks));
        producerProps.put("max.block.ms", Long.toString(maxBlockMs));
        producerProps.put("buffer.memory", Long.toString(bufferSize));
        producerProps.put("retries", Integer.toString(retries));
        producerProps.put("delivery.timeout.ms", Integer.toString(deliveryTimeoutMs));
        producerProps.put("request.timeout.ms", Integer.toString(requestTimeoutMs));
        producerProps.put("linger.ms", Integer.toString(lingerMs));
        producerProps.put("batch.size", Integer.toString(batchSize));
        producerProps.put("compression.type", compressionType);
        producerProps.put("enable.idempotence", Boolean.toString(enableIdempotence));
        new Implicits.PropertiesOps(producerProps).$plus$plus$eq(JaasTestUtils.producerSecurityConfigs(securityProtocol, OptionConverters$.MODULE$.toJava(trustStoreFile), OptionConverters$.MODULE$.toJava(saslProperties)));
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createProducer$default$2() {
        return -1;
    }

    public <K, V> long createProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createProducer$default$5() {
        return Integer.MAX_VALUE;
    }

    public <K, V> int createProducer$default$6() {
        return 30000;
    }

    public <K, V> int createProducer$default$7() {
        return 0;
    }

    public <K, V> int createProducer$default$8() {
        return 16384;
    }

    public <K, V> String createProducer$default$9() {
        return "none";
    }

    public <K, V> int createProducer$default$10() {
        return 20000;
    }

    public <K, V> SecurityProtocol createProducer$default$11() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createProducer$default$12() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createProducer$default$13() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createProducer$default$14() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$15() {
        return new ByteArraySerializer();
    }

    public <K, V> boolean createProducer$default$16() {
        return false;
    }

    public <K, V> Consumer<K, V> createConsumer(String brokerList, GroupProtocol groupProtocol, String groupId, String autoOffsetReset, boolean enableAutoCommit, boolean readCommitted, int maxPollRecords, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("group.protocol", groupProtocol.toString());
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", Boolean.toString(enableAutoCommit));
        consumerProps.put("max.poll.records", Integer.toString(maxPollRecords));
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        new Implicits.PropertiesOps(consumerProps).$plus$plus$eq(JaasTestUtils.consumerSecurityConfigs(securityProtocol, OptionConverters$.MODULE$.toJava(trustStoreFile), OptionConverters$.MODULE$.toJava(saslProperties)));
        return new KafkaConsumer(consumerProps, keyDeserializer, valueDeserializer);
    }

    public <K, V> String createConsumer$default$3() {
        return "group";
    }

    public <K, V> String createConsumer$default$4() {
        return "earliest";
    }

    public <K, V> boolean createConsumer$default$5() {
        return true;
    }

    public <K, V> boolean createConsumer$default$6() {
        return false;
    }

    public <K, V> int createConsumer$default$7() {
        return 500;
    }

    public <K, V> SecurityProtocol createConsumer$default$8() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createConsumer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createConsumer$default$10() {
        return None$.MODULE$;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$11() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$12() {
        return new ByteArrayDeserializer();
    }

    public int waitUntilLeaderIsElectedOrChangedWithAdmin(Admin admin, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0 & Serializable)() -> "Can't define both the old and the new leader");
        long doWaitUntilLeaderIsElectedOrChanged_startTime = System.currentTimeMillis();
        TopicPartition doWaitUntilLeaderIsElectedOrChanged_topicPartition = new TopicPartition(topic, partition);
        if (this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$2(doWaitUntilLeaderIsElectedOrChanged_topicPartition, oldLeaderOpt, newLeaderOpt);
            Object var16_9 = null;
            this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        ObjectRef doWaitUntilLeaderIsElectedOrChanged_leader = ObjectRef.create((Object)None$.MODULE$);
        None$ doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = None$.MODULE$;
        while (doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < doWaitUntilLeaderIsElectedOrChanged_startTime + timeoutMs) {
            doWaitUntilLeaderIsElectedOrChanged_leader.elem = TestUtils$.getPartitionLeader$1(topic, partition, admin);
            Option option = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
            if (option instanceof Some) {
                int doWaitUntilLeaderIsElectedOrChanged_oldLeader;
                int doWaitUntilLeaderIsElectedOrChanged_l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (newLeaderOpt instanceof Some && BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value()) == doWaitUntilLeaderIsElectedOrChanged_l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$3(doWaitUntilLeaderIsElectedOrChanged_l, doWaitUntilLeaderIsElectedOrChanged_topicPartition);
                        Object var17_15 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (oldLeaderOpt instanceof Some && (doWaitUntilLeaderIsElectedOrChanged_oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value())) != doWaitUntilLeaderIsElectedOrChanged_l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$4(doWaitUntilLeaderIsElectedOrChanged_topicPartition, doWaitUntilLeaderIsElectedOrChanged_oldLeader, doWaitUntilLeaderIsElectedOrChanged_l);
                        Object var18_16 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (None$.MODULE$.equals(newLeaderOpt) && None$.MODULE$.equals(oldLeaderOpt)) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$5(doWaitUntilLeaderIsElectedOrChanged_l, doWaitUntilLeaderIsElectedOrChanged_topicPartition);
                        Object var19_17 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (this.logger().underlying().isTraceEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$6(doWaitUntilLeaderIsElectedOrChanged_topicPartition, doWaitUntilLeaderIsElectedOrChanged_l);
                    Object var20_18 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
            } else if (None$.MODULE$.equals(option)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$7(doWaitUntilLeaderIsElectedOrChanged_topicPartition);
                    Object var21_19 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
            } else {
                throw new MatchError((Object)option);
            }
            Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader.getOrElse((Function0 & Serializable)() -> {
            String string;
            if (newLeaderOpt instanceof Some) {
                int newLeader = BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value());
                string = "Timing out after " + timeoutMs + " ms since expected new leader " + newLeader + " was not elected for partition " + doWaitUntilLeaderIsElectedOrChanged_topicPartition + ", leader is " + (Option)leader$1.elem;
            } else if (oldLeaderOpt instanceof Some) {
                int oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value());
                string = "Timing out after " + timeoutMs + " ms since a new leader that is different from " + oldLeader + " was not elected for partition " + doWaitUntilLeaderIsElectedOrChanged_topicPartition + ", leader is " + (Option)leader$1.elem;
            } else {
                string = "Timing out after " + timeoutMs + " ms since a leader was not elected for partition " + doWaitUntilLeaderIsElectedOrChanged_topicPartition;
            }
            String errorMessage = string;
            throw new AssertionError((Object)errorMessage);
        }));
    }

    public long waitUntilLeaderIsElectedOrChangedWithAdmin$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChangedWithAdmin$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChangedWithAdmin$default$6() {
        return None$.MODULE$;
    }

    private int doWaitUntilLeaderIsElectedOrChanged(Function2<String, Object, Option<Object>> getPartitionLeader, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0 & Serializable)() -> "Can't define both the old and the new leader");
        long startTime = System.currentTimeMillis();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        if (this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$2(topicPartition, oldLeaderOpt, newLeaderOpt);
            Object var16_9 = null;
            this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        None$ electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            leader.elem = (Option)getPartitionLeader.apply((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partition));
            Option option = (Option)leader.elem;
            if (option instanceof Some) {
                int oldLeader;
                int l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (newLeaderOpt instanceof Some && BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value()) == l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$3(l, topicPartition);
                        Object var17_15 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (oldLeaderOpt instanceof Some && (oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value())) != l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$4(topicPartition, oldLeader, l);
                        Object var18_16 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (None$.MODULE$.equals(newLeaderOpt) && None$.MODULE$.equals(oldLeaderOpt)) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$5(l, topicPartition);
                        Object var19_17 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (this.logger().underlying().isTraceEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$6(topicPartition, l);
                    Object var20_18 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
            } else if (None$.MODULE$.equals(option)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$7(topicPartition);
                    Object var21_19 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
            } else {
                throw new MatchError((Object)option);
            }
            Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0 & Serializable)() -> {
            String string;
            if (newLeaderOpt instanceof Some) {
                int newLeader = BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value());
                string = "Timing out after " + timeoutMs + " ms since expected new leader " + newLeader + " was not elected for partition " + doWaitUntilLeaderIsElectedOrChanged_topicPartition + ", leader is " + (Option)leader$1.elem;
            } else if (oldLeaderOpt instanceof Some) {
                int oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value());
                string = "Timing out after " + timeoutMs + " ms since a new leader that is different from " + oldLeader + " was not elected for partition " + doWaitUntilLeaderIsElectedOrChanged_topicPartition + ", leader is " + (Option)leader$1.elem;
            } else {
                string = "Timing out after " + timeoutMs + " ms since a leader was not elected for partition " + doWaitUntilLeaderIsElectedOrChanged_topicPartition;
            }
            String errorMessage = string;
            throw new AssertionError((Object)errorMessage);
        }));
    }

    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        long l = 1L;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                block.apply$mcV$sp();
                return;
            }
            catch (AssertionError e) {
                if (System.currentTimeMillis() - startTime > maxWaitMs) {
                    throw e;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = "Attempt failed, sleeping for " + l + ", and then retrying.";
                    Object var7_6 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void pollUntilTrue(Consumer<?, ?> consumer, Function0<Object> action, Function0<String> msg, long waitTimeMs) {
        long waitUntilTrue_pause = 0L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(java.time.Duration.ofMillis(100L));
            if (action.apply$mcZ$sp()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), waitUntilTrue_pause));
        }
    }

    public long pollUntilTrue$default$4() {
        return 15000L;
    }

    public <K, V> void pollRecordsUntilTrue(Consumer<K, V> consumer, Function1<ConsumerRecords<K, V>, Object> action, Function0<String> msg, long waitTimeMs, long pollTimeoutMs) {
        long waitUntilTrue_pause = 0L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            ConsumerRecords $anonfun$pollRecordsUntilTrue$1_records = consumer.poll(java.time.Duration.ofMillis(pollTimeoutMs));
            Object var12_8 = null;
            if (BoxesRunTime.unboxToBoolean((Object)action.apply((Object)$anonfun$pollRecordsUntilTrue$1_records))) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), waitUntilTrue_pause));
        }
    }

    public <K, V> long pollRecordsUntilTrue$default$4() {
        return 15000L;
    }

    public <K, V> long pollRecordsUntilTrue$default$5() {
        return 100L;
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTimeMs, long pause) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pause));
        }
        return;
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T tryUntilNoAssertionError(long waitTime, long pause, Function0<T> assertions) {
        void var7_10;
        Tuple2 tuple2;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Right right;
            try {
                Object $anonfun$tryUntilNoAssertionError$1_res = assertions.apply();
                right = new Left($anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var11_6 = null;
            Object var12_7 = null;
            Right computeUntilTrue_result = right;
            if (((Either)computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either either = (Either)tuple22._1();
        if (var7_10 instanceof Left) {
            return (T)((Left)var7_10).value();
        }
        if (var7_10 instanceof Right) {
            throw (AssertionError)((Right)var7_10).value();
        }
        throw new MatchError((Object)var7_10);
    }

    public <T> long tryUntilNoAssertionError$default$1() {
        return 15000L;
    }

    public <T> long tryUntilNoAssertionError$default$2() {
        return 100L;
    }

    public int findLeaderEpoch(int brokerId, TopicPartition topicPartition, Iterable<KafkaBroker> brokers) {
        return ((Partition)brokers.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findLeaderEpoch$1(brokerId, x$7))).flatMap((Function1 & Serializable)x$8 -> x$8.replicaManager().onlinePartition(topicPartition)).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("Failed to find expected replica on broker " + brokerId));
        })).getLeaderEpoch();
    }

    public int findFollowerId(TopicPartition topicPartition, Iterable<KafkaBroker> brokers) {
        return BoxesRunTime.unboxToInt((Object)brokers.find((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findFollowerId$1(topicPartition, server))).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$findFollowerId$2(x$9))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("Unable to locate follower for " + topicPartition));
        }));
    }

    public <B extends KafkaBroker> void waitUntilBrokerMetadataIsPropagated(scala.collection.Seq<B> brokers, long timeout) {
        scala.collection.immutable.Set expectedBrokerIds = ((IterableOnceOps)brokers.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$1(x$10)))).toSet();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$3(expectedBrokerIds$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)"Timed out waiting for broker metadata to propagate to all servers");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
    }

    public <B extends KafkaBroker> long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    /*
     * WARNING - void declaration
     */
    public <B extends KafkaBroker> Map<TopicPartition, LeaderAndIsr> waitForAllPartitionsMetadata(scala.collection.Seq<B> brokers, String topic, int expectedNumPartitions) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForAllPartitionsMetadata$2(expectedNumPartitions$1, topic$2, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForAllPartitionsMetadata$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), expectedNumPartitions).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))), ((KafkaBroker)brokers.head()).metadataCache().getLeaderAndIsr(topic, BoxesRunTime.unboxToInt((Object)i)).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Cannot get topic: " + topic$2 + ", partition: " + i + " in server metadata cache");
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <B extends KafkaBroker> LeaderAndIsr waitForPartitionMetadata(scala.collection.Seq<B> brokers, String topic, int partition, long timeout) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForPartitionMetadata$2(topic$3, partition$2, broker)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return (LeaderAndIsr)((KafkaBroker)brokers.head()).metadataCache().getLeaderAndIsr(topic, partition).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Cannot get topic: " + topic + ", partition: " + partition + " in server metadata cache");
        });
    }

    public <B extends KafkaBroker> long waitForPartitionMetadata$default$4() {
        return 15000L;
    }

    /*
     * WARNING - void declaration
     */
    public void ensureConsistentKRaftMetadata(scala.collection.Seq<KafkaBroker> brokers, ControllerServer controllerServer, String msg) {
        long controllerOffset = controllerServer.raftManager().replicatedLog().endOffset().offset() - 1L;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureConsistentKRaftMetadata$2(controllerOffset$1, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public String ensureConsistentKRaftMetadata$default$3() {
        return "Timeout waiting for controller metadata propagating to brokers";
    }

    public <B extends KafkaBroker> int awaitLeaderChange(scala.collection.Seq<B> brokers, TopicPartition tp, Option<Object> oldLeaderOpt, Option<Object> expectedLeaderOpt, long timeout) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$awaitLeaderChange$14(this, expectedLeaderOpt, brokers, tp, oldLeaderOpt)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$awaitLeaderChange$15(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return BoxesRunTime.unboxToInt((Object)this.newLeaderExists$1(expectedLeaderOpt, brokers, tp, oldLeaderOpt).get());
    }

    public <B extends KafkaBroker> Option<Object> awaitLeaderChange$default$3() {
        return None$.MODULE$;
    }

    public <B extends KafkaBroker> Option<Object> awaitLeaderChange$default$4() {
        return None$.MODULE$;
    }

    public <B extends KafkaBroker> long awaitLeaderChange$default$5() {
        return 15000L;
    }

    public <B extends KafkaBroker> int waitUntilLeaderIsKnown(scala.collection.Seq<B> brokers, TopicPartition tp, long timeout) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitUntilLeaderIsKnown$4(brokers, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$waitUntilLeaderIsKnown$5(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return BoxesRunTime.unboxToInt((Object)TestUtils$.leaderIfExists$1(brokers, tp).get());
    }

    public <B extends KafkaBroker> long waitUntilLeaderIsKnown$default$3() {
        return 15000L;
    }

    public void appendNonsenseToFile(File file, int size) {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> outputStream.write(MODULE$.random().nextInt(255)));
        }
    }

    public void assertNoNonDaemonThreads(String threadNamePrefix) {
        Set nonDaemonThreads = (Set)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$assertNoNonDaemonThreads$1(threadNamePrefix, t)));
        int threadCount = nonDaemonThreads.size();
        Assertions.assertEquals((int)0, (int)threadCount, (String)("Found unexpected " + threadCount + " NonDaemon threads=" + ((IterableOnceOps)nonDaemonThreads.map((Function1 & Serializable)t -> t.getName())).mkString(", ")));
    }

    public LogManager createLogManager(scala.collection.Seq<File> logDirs, LogConfig defaultConfig, ConfigRepository configRepository, CleanerConfig cleanerConfig, MockTime time, int recoveryThreadsPerDataDir, boolean transactionVerificationEnabled, Option<UnifiedLog> log, boolean remoteStorageSystemEnable, long initialTaskDelayMs) {
        scala.collection.Seq x$1 = (scala.collection.Seq)logDirs.map((Function1 & Serializable)x$22 -> x$22.getAbsoluteFile());
        ArraySeq.ofRef x$2 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        ProducerStateManagerConfig x$12 = new ProducerStateManagerConfig(86400000, transactionVerificationEnabled);
        MockScheduler x$14 = time.scheduler;
        BrokerTopicStats x$16 = new BrokerTopicStats();
        LogDirFailureChannel x$17 = new LogDirFailureChannel(logDirs.size());
        LogManager logManager = new LogManager(x$1, (scala.collection.Seq)x$2, configRepository, defaultConfig, cleanerConfig, recoveryThreadsPerDataDir, 1000L, 10000L, 10000L, 1000L, 300000, x$12, 600000, (Scheduler)x$14, x$16, x$17, (Time)time, true, remoteStorageSystemEnable, initialTaskDelayMs);
        if (log.isDefined()) {
            LogManager spyLogManager = (LogManager)Mockito.spy((Object)logManager);
            ((LogManager)Mockito.doReturn((Object)log.get(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLogManager)).getOrCreateLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (Option)ArgumentMatchers.any(Option.class), (Option)ArgumentMatchers.any(Option.class));
            return spyLogManager;
        }
        return logManager;
    }

    public scala.collection.Seq<File> createLogManager$default$1() {
        return (scala.collection.Seq)Seq$.MODULE$.empty();
    }

    public LogConfig createLogManager$default$2() {
        return new LogConfig((java.util.Map)new Properties());
    }

    public ConfigRepository createLogManager$default$3() {
        return new MockConfigRepository();
    }

    public CleanerConfig createLogManager$default$4() {
        return new CleanerConfig(false);
    }

    public MockTime createLogManager$default$5() {
        return new MockTime();
    }

    public int createLogManager$default$6() {
        return 4;
    }

    public boolean createLogManager$default$7() {
        return false;
    }

    public Option<UnifiedLog> createLogManager$default$8() {
        return None$.MODULE$;
    }

    public boolean createLogManager$default$9() {
        return false;
    }

    public long createLogManager$default$10() {
        return 30000L;
    }

    public TestUtils.MockAlterPartitionManager createAlterIsrManager() {
        return new TestUtils.MockAlterPartitionManager();
    }

    public <B extends KafkaBroker> scala.collection.Seq<String> generateAndProduceMessages(scala.collection.Seq<B> brokers, String topic, int numMessages, int acks) {
        IndexedSeq values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable)x -> TestUtils$.$anonfun$generateAndProduceMessages$1(BoxesRunTime.unboxToInt((Object)x)));
        IntegerSerializer intSerializer = new IntegerSerializer();
        IndexedSeq records = (IndexedSeq)((IndexedSeqOps)values.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String v = (String)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return new ProducerRecord(topic, (Object)intSerializer.serialize(topic, Predef$.MODULE$.int2Integer(i)), (Object)v.getBytes());
            }
            throw new MatchError(null);
        });
        try (KafkaProducer producer = this.createProducer(this.plaintextBootstrapServers(brokers), acks, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer(), false);){
            ((IndexedSeq)records.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$23 -> (RecordMetadata)x$23.get());
        }
        IndexedSeq topics = (IndexedSeq)((SeqOps)records.map((Function1 & Serializable)x$24 -> x$24.topic())).distinct();
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$generateAndProduceMessages$6(records, topics);
            Object var11_11 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        return values;
    }

    public <B extends KafkaBroker> int generateAndProduceMessages$default$4() {
        return -1;
    }

    public <B extends KafkaBroker> void produceMessage(scala.collection.Seq<B> brokers, String topic, String message, Long timestamp, int deliveryTimeoutMs, int requestTimeoutMs) {
        String x$1 = this.plaintextBootstrapServers(brokers);
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 0;
        int x$9 = 16384;
        String x$10 = "none";
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = this.createProducer(x$1, x$4, x$5, x$6, x$7, deliveryTimeoutMs, x$8, x$9, x$10, requestTimeoutMs, x$11, (Option<File>)x$12, (Option<Properties>)x$13, (Serializer)x$14, (Serializer)x$15, x$16);){
            producer.send(new ProducerRecord(topic, null, timestamp, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        }
    }

    public <B extends KafkaBroker> Long produceMessage$default$4() {
        return null;
    }

    public <B extends KafkaBroker> int produceMessage$default$5() {
        return 30000;
    }

    public <B extends KafkaBroker> int produceMessage$default$6() {
        return 20000;
    }

    /*
     * WARNING - void declaration
     */
    public <B extends KafkaBroker> void verifyTopicDeletion(String topic, int numPartitions, scala.collection.Seq<B> brokers) {
        IndexedSeq topicPartitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)x$25 -> TestUtils$.$anonfun$verifyTopicDeletion$1(topic, BoxesRunTime.unboxToInt((Object)x$25)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$4(broker, tp)))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replica manager's should have deleted all of this topic's partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$8(broker, tp)))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Replica logs not deleted after delete topic is complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$12(broker, tp)))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Cleaner offset for deleted partition should have been removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$17(topicPartitions$1, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Failed to soft-delete the data to a delete directory");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$22(topicPartitions$1, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Failed to hard-delete the delete directory");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public void waitAndVerifyAcls(scala.collection.immutable.Set<AccessControlEntry> expected, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 45000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitAndVerifyAcls$1(authorizer, filter, expected)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitAndVerifyAcls$3(expected, newLine, authorizer, filter));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public AccessControlEntryFilter waitAndVerifyAcls$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    public <K, V, B extends KafkaBroker> scala.collection.Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(scala.collection.Seq<B> brokers, String topic, int numMessages, GroupProtocol groupProtocol, String groupId, SecurityProtocol securityProtocol, Option<File> trustStoreFile, long waitTime) {
        scala.collection.Seq<ConsumerRecord<K, V>> seq;
        String x$1 = this.bootstrapServers(brokers, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
        String x$6 = "earliest";
        boolean x$7 = true;
        boolean x$8 = false;
        int x$9 = 500;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        try (Consumer<K, V> consumer = this.createConsumer(x$1, groupProtocol, groupId, x$6, x$7, x$8, x$9, securityProtocol, trustStoreFile, (Option<Properties>)x$10, (Deserializer<K>)x$11, (Deserializer<V>)x$12);){
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords(consumer, numMessages, waitTime);
        }
        return seq;
    }

    public <K, V, B extends KafkaBroker> String consumeTopicRecords$default$5() {
        return "group";
    }

    public <K, V, B extends KafkaBroker> SecurityProtocol consumeTopicRecords$default$6() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V, B extends KafkaBroker> Option<File> consumeTopicRecords$default$7() {
        return None$.MODULE$;
    }

    public <K, V, B extends KafkaBroker> long consumeTopicRecords$default$8() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> pollUntilAtLeastNumRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        ArrayBuffer records = new ArrayBuffer();
        long x$5 = 100L;
        long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.pollAction$1(consumer.poll(java.time.Duration.ofMillis(x$5)), records, numRecords)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$pollUntilAtLeastNumRecords$2(records, numRecords));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pollRecordsUntilTrue_waitUntilTrue_pause));
        }
        return records;
    }

    public <K, V> long pollUntilAtLeastNumRecords$default$3() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        scala.collection.Seq<ConsumerRecord<K, V>> records = this.pollUntilAtLeastNumRecords(consumer, numRecords, waitTimeMs);
        Assertions.assertEquals((int)numRecords, (int)records.size(), (String)"Consumed more records than expected");
        return records;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <B extends KafkaBroker> KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, scala.collection.Seq<B> brokers, int batchSize, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs, int maxInFlight) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.plaintextBootstrapServers(brokers));
        props.put("acks", "all");
        props.put("batch.size", Integer.toString(batchSize));
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        props.put("transaction.timeout.ms", Long.toString(transactionTimeoutMs));
        props.put("max.block.ms", Long.toString(maxBlockMs));
        props.put("delivery.timeout.ms", Integer.toString(deliveryTimeoutMs));
        props.put("request.timeout.ms", Integer.toString(requestTimeoutMs));
        props.put("max.in.flight.requests.per.connection", Integer.toString(maxInFlight));
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$3() {
        return 16384;
    }

    public <B extends KafkaBroker> long createTransactionalProducer$default$4() {
        return 60000L;
    }

    public <B extends KafkaBroker> long createTransactionalProducer$default$5() {
        return 60000L;
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$6() {
        return 120000;
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$7() {
        return 30000;
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$8() {
        return 5;
    }

    public <B extends KafkaBroker> void seedTopicWithNumberedRecords(String topic, int numRecords, scala.collection.Seq<B> brokers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("bootstrap.servers", this.plaintextBootstrapServers(brokers));
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> producer.send(new ProducerRecord(topic, (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8))));
            producer.flush();
        }
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = CollectionConverters$.MODULE$.IterableHasAsScala(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).asScala().headOption();
        if (option instanceof Some) {
            Header header = (Header)((Some)option).value();
            byte[] asString_bytes = this.kafka$utils$TestUtils$$committedValue();
            Object var4_4 = null;
            byte[] asString_bytes2 = header.value();
            Object var5_5 = null;
            byte[] asString_bytes3 = header.value();
            Object var6_6 = null;
            Assertions.assertEquals((Object)new String(asString_bytes, StandardCharsets.UTF_8), (Object)new String(asString_bytes2, StandardCharsets.UTF_8), (String)("Got " + new String(asString_bytes3, StandardCharsets.UTF_8) + " but expected the value to indicate committed status."));
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"expected the record header to include an expected transaction status, but received nothing.");
        } else {
            throw new MatchError((Object)option);
        }
        return this.recordValueAsString(record);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        byte[] asString_bytes = (byte[])record.value();
        return new String(asString_bytes, StandardCharsets.UTF_8);
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, Integer partition, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                if (this.willBeCommitted$1) {
                    return TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue();
                }
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, partition, (Object)key, (Object)value, Collections.singleton(header));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, Integer partition, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, partition, key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(Consumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        consumer.assignment().forEach(topicPartition -> offsetsToCommit.put(topicPartition, (Object)new OffsetAndMetadata(consumer.position(topicPartition))));
        return offsetsToCommit.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void resetToCommittedPositions(Consumer<byte[], byte[]> consumer) {
        scala.collection.mutable.Map committed = (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(consumer.committed(consumer.assignment())).asScala().filter((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$resetToCommittedPositions$1(x$28)))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            }
            throw new MatchError(null);
        });
        consumer.assignment().forEach(topicPartition -> {
            if (committed.contains(topicPartition)) {
                consumer.seek(topicPartition, BoxesRunTime.unboxToLong((Object)committed.apply(topicPartition)));
                return;
            }
            consumer.seekToBeginning(Collections.singletonList(topicPartition));
        });
    }

    public <B extends KafkaBroker> AlterConfigsResult incrementalAlterConfigs(scala.collection.Seq<B> servers, Admin adminClient, Properties props, boolean perBrokerConfig, AlterConfigOp.OpType opType) {
        Collection configEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new AlterConfigOp(new ConfigEntry(k, v), opType);
            }
            throw new MatchError(null);
        })).toList()).asJavaCollection();
        java.util.Map configs = perBrokerConfig ? CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)servers.map((Function1 & Serializable)server -> {
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(server.config().brokerId()));
            return new Tuple2((Object)resource, (Object)configEntries);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava() : CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)configEntries)}))).asJava();
        return adminClient.incrementalAlterConfigs(configs);
    }

    public <B extends KafkaBroker> AlterConfigOp.OpType incrementalAlterConfigs$default$5() {
        return AlterConfigOp.OpType.SET;
    }

    public void assertLeader(Admin client, TopicPartition topicPartition, int expectedLeader) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)expectedLeader)));
    }

    public void assertNoLeader(Admin client, TopicPartition topicPartition) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void waitForOnlineBroker(Admin client, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForOnlineBroker$1(client, brokerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForOnlineBroker$3(brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitForLeaderToBecome(Admin client, TopicPartition topicPartition, Option<Object> expectedLeaderOpt) {
        void var7_11;
        Tuple2 tuple2;
        String topic = topicPartition.topic();
        int partitionId = topicPartition.partition();
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Try computeUntilTrue_result;
            if (TestUtils$.$anonfun$waitForLeaderToBecome$6(expectedLeaderOpt, computeUntilTrue_result = TestUtils$.currentLeader$1(client, topic, partitionId))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Try lastLeaderCheck = (Try)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)("Timed out waiting for leader to become " + expectedLeaderOpt + ". Last metadata lookup returned leader = " + var7_11.getOrElse((Function0 & Serializable)() -> "unknown")));
    }

    /*
     * WARNING - void declaration
     */
    public void waitForBrokersOutOfIsr(Admin client, scala.collection.immutable.Set<TopicPartition> partition, scala.collection.immutable.Set<Object> brokerIds) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForBrokersOutOfIsr$1(client, partition, brokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForBrokersOutOfIsr$6(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public scala.collection.immutable.Set<Object> currentIsr(Admin admin, TopicPartition partition) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)admin.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{partition.topic()}))).asJava()).allTopicNames().get()).asScala().values().flatMap((Function1 & Serializable)x$37 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$37.partitions()).asScala().flatMap((Function1 & Serializable)x$38 -> CollectionConverters$.MODULE$.ListHasAsScala(x$38.isr()).asScala()))).map((Function1 & Serializable)x$39 -> BoxesRunTime.boxToInteger((int)x$39.id()))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForBrokersInIsr(Admin client, TopicPartition partition, scala.collection.immutable.Set<Object> brokerIds) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForBrokersInIsr$1(client, partition, brokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForBrokersInIsr$2(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public void assertBadConfigContainingMessage(Properties props, String expectedExceptionContainsText) {
        try {
            KafkaConfig$.MODULE$.fromProps(props);
            Assertions.fail((String)"Expected illegal configuration but instead it was legal");
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException) {
                Assertions.assertTrue((boolean)throwable.getMessage().contains(expectedExceptionContainsText), (String)("\"" + throwable.getMessage() + "\" doesn't contain \"" + expectedExceptionContainsText + "\""));
                return;
            }
            throw throwable;
        }
    }

    public long totalMetricValue(KafkaBroker broker, String metricName) {
        return this.totalMetricValue(broker.metrics(), metricName);
    }

    public long totalMetricValue(Metrics metrics, String metricName) {
        java.util.Map allMetrics = metrics.metrics();
        return (long)BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(allMetrics.values()).asScala().filter((Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$totalMetricValue$1(metricName, x$40)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(total, metric) -> BoxesRunTime.boxToDouble((double)TestUtils$.$anonfun$totalMetricValue$2(BoxesRunTime.unboxToDouble((Object)total), metric))));
    }

    public long meterCount(String metricName) {
        return BoxesRunTime.unboxToLong((Object)this.meterCountOpt(metricName).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("Unable to find metric " + metricName))));
    }

    public Option<Object> meterCountOpt(String metricName) {
        return ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$meterCountOpt$1(metricName, x0$1)))).values().headOption().map((Function1 & Serializable)x$41 -> BoxesRunTime.boxToLong((long)TestUtils$.$anonfun$meterCountOpt$2(x$41)));
    }

    public long metersCount(String metricName) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$metersCount$1(metricName, x0$1)))).values().map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)TestUtils$.$anonfun$metersCount$2(x0$2)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void clearYammerMetrics() {
        CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().foreach((Function1 & Serializable)metricName -> {
            TestUtils$.$anonfun$clearYammerMetrics$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    public <B extends KafkaBroker> Authorizer pickAuthorizerForWrite(scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        Authorizer authorizer;
        if (controllers.isEmpty()) {
            return (Authorizer)((KafkaBroker)brokers.head()).authorizer().get();
        }
        long retry_maxWaitMs = 120000L;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                authorizer = (Authorizer)((ControllerServer)((IterableOps)controllers.filter((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$pickAuthorizerForWrite$2(x$42)))).head()).authorizer().get();
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = "Attempt failed, sleeping for " + l + ", and then retrying.";
                    Object var8_8 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
        return authorizer;
    }

    public AuthorizableRequestContext anonymousAuthorizableContext() {
        return anonymousAuthorizableContext;
    }

    public RequestChannel.Request buildEnvelopeRequest(AbstractRequest request, KafkaPrincipalSerde principalSerde, RequestChannelMetrics requestChannelMetrics, long startTimeNanos, long dequeueTimeNanos, boolean fromPrivilegedListener) {
        String clientId = "id";
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        RequestHeader requestHeader = new RequestHeader(request.apiKey(), request.version(), clientId, 0);
        ByteBuffer requestBuffer = request.serializeWithHeader(requestHeader);
        RequestHeader envelopeHeader = new RequestHeader(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion(), clientId, 0);
        ByteBuffer envelopeBuffer = new EnvelopeRequest.Builder(requestBuffer, principalSerde.serialize(KafkaPrincipal.ANONYMOUS), InetAddress.getLocalHost().getAddress()).build().serializeWithHeader(envelopeHeader);
        RequestHeader.parse((ByteBuffer)envelopeBuffer);
        RequestContext envelopeContext = new RequestContext(envelopeHeader, "1", InetAddress.getLocalHost(), Optional.empty(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, fromPrivilegedListener, Optional.of(principalSerde));
        RequestChannel.Request envelopRequest = new RequestChannel.Request(1, envelopeContext, startTimeNanos, MemoryPool.NONE, envelopeBuffer, requestChannelMetrics, (Option)None$.MODULE$);
        envelopRequest.requestDequeueTimeNanos_$eq(dequeueTimeNanos);
        return envelopRequest;
    }

    public long buildEnvelopeRequest$default$5() {
        return -1L;
    }

    public boolean buildEnvelopeRequest$default$6() {
        return true;
    }

    public static final /* synthetic */ Properties $anonfun$createBrokerConfigs$1(boolean enableControlledShutdown$1, boolean enableDeleteTopic$1, Option interBrokerSecurityProtocol$1, Option trustStoreFile$1, Option saslProperties$1, boolean enablePlaintext$1, boolean enableSsl$1, boolean enableSaslPlaintext$1, boolean enableSaslSsl$1, Map rackInfo$1, int logDirCount$1, boolean enableToken$1, int numPartitions$1, short defaultReplicationFactor$1, boolean enableFetchFromFollower$1, int node) {
        int x$4 = MODULE$.RandomPort();
        Option x$12 = rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
        TestUtils$ createBrokerConfig$default$10_this = MODULE$;
        Object var21_18 = null;
        int x$18 = createBrokerConfig$default$10_this.RandomPort();
        TestUtils$ createBrokerConfig$default$12_this = MODULE$;
        Object var22_20 = null;
        int x$19 = createBrokerConfig$default$12_this.RandomPort();
        TestUtils$ createBrokerConfig$default$14_this = MODULE$;
        Object var23_22 = null;
        int x$20 = createBrokerConfig$default$14_this.RandomPort();
        return MODULE$.createBrokerConfig(node, enableControlledShutdown$1, enableDeleteTopic$1, x$4, (Option<SecurityProtocol>)interBrokerSecurityProtocol$1, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProperties$1, enablePlaintext$1, enableSaslPlaintext$1, x$18, enableSsl$1, x$19, enableSaslSsl$1, x$20, (Option<String>)x$12, logDirCount$1, enableToken$1, numPartitions$1, defaultReplicationFactor$1, enableFetchFromFollower$1);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrapServers$2(ListenerName listenerName$1, EndPoint x$1) {
        ListenerName listenerName = x$1.listenerName();
        return !(listenerName != null ? !listenerName.equals(listenerName$1) : listenerName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$2(SecurityProtocol protocol$1, SecurityProtocol x$2) {
        SecurityProtocol securityProtocol = x$2;
        return !(securityProtocol != null ? !securityProtocol.equals(protocol$1) : protocol$1 != null);
    }

    private static final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$2(protocol, x$2))));
    }

    public static final /* synthetic */ Object $anonfun$createBrokerConfig$5(int i) {
        if (i % 2 == 0) {
            return TestUtils.tempDirectory(null, null).getAbsolutePath();
        }
        return TestUtils.tempRelativeDir((String)"data");
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$7(Tuple2 x0$2) {
        if (x0$2 != null) {
            return JaasTestUtils.usesSslTransportLayer((SecurityProtocol)x0$2._1());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$8(Tuple2 x0$3) {
        if (x0$3 != null) {
            return JaasTestUtils.usesSaslAuthentication((SecurityProtocol)x0$3._1());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ java.util.List $anonfun$createTopicWithAdminRaw$2(java.util.HashMap assignment$1, int x0$1, scala.collection.Seq x1$1) {
        ArrayList replicas = new ArrayList();
        x1$1.foreach((Function1)(JFunction1.mcZI.sp & Serializable)r -> replicas.add(BoxesRunTime.boxToInteger((int)r)));
        return assignment$1.put(BoxesRunTime.boxToInteger((int)x0$1), replicas);
    }

    private final boolean isTopicExistsAndHasSameNumPartitionsAndReplicationFactor$1(Throwable cause, scala.collection.Seq brokers$1, String topic$1, int effectiveNumPartitions$1, Admin admin$1, int replicationFactor$1) {
        return cause != null && cause instanceof TopicExistsException && this.waitForAllPartitionsMetadata(brokers$1, topic$1, effectiveNumPartitions$1).nonEmpty() && this.topicHasSameNumPartitionsAndReplicationFactor(admin$1, topic$1, effectiveNumPartitions$1, replicationFactor$1);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsElectedOrChangedWithAdmin$1(int partition$1, TopicPartitionInfo x$5) {
        return x$5.partition() == partition$1;
    }

    private static final Option getPartitionLeader$1(String topic, int partition, Admin admin$2) {
        return CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)admin$2.describeTopics(Collections.singletonList(topic)).allTopicNames().get()).get(topic)).partitions()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChangedWithAdmin$1(partition, x$5))).flatMap((Function1 & Serializable)p -> {
            if (p.leader().id() == Node.noNode().id()) {
                return None$.MODULE$;
            }
            return new Some((Object)BoxesRunTime.boxToInteger((int)p.leader().id()));
        });
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$2(TopicPartition topicPartition$1, Option oldLeaderOpt$1, Option newLeaderOpt$1) {
        return "Waiting for leader to be elected or changed for partition " + topicPartition$1 + ", old leader is " + oldLeaderOpt$1 + ", new leader is " + newLeaderOpt$1;
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$3(int l$1, TopicPartition topicPartition$1) {
        return "Expected new leader " + l$1 + " is elected for partition " + topicPartition$1;
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$4(TopicPartition topicPartition$1, int oldLeader$1, int l$1) {
        return "Leader for partition " + topicPartition$1 + " is changed from " + oldLeader$1 + " to " + l$1;
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$5(int l$1, TopicPartition topicPartition$1) {
        return "Leader " + l$1 + " is elected for partition " + topicPartition$1;
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$6(TopicPartition topicPartition$1, int l$1) {
        return "Current leader for partition " + topicPartition$1 + " is " + l$1;
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$7(TopicPartition topicPartition$1) {
        return "Leader for partition " + topicPartition$1 + " is not elected yet";
    }

    public static final /* synthetic */ String $anonfun$retry$1(LongRef wait$1) {
        return "Attempt failed, sleeping for " + wait$1.elem + ", and then retrying.";
    }

    public static final /* synthetic */ boolean $anonfun$pollUntilTrue$1(Consumer consumer$1, Function0 action$1) {
        consumer$1.poll(java.time.Duration.ofMillis(100L));
        return action$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$pollRecordsUntilTrue$1(Consumer consumer$2, long pollTimeoutMs$1, Function1 action$2) {
        ConsumerRecords records = consumer$2.poll(java.time.Duration.ofMillis(pollTimeoutMs$1));
        return BoxesRunTime.unboxToBoolean((Object)action$2.apply((Object)records));
    }

    public static final /* synthetic */ Either $anonfun$tryUntilNoAssertionError$1(Function0 assertions$1) {
        try {
            Object res = assertions$1.apply();
            return new Left(res);
        }
        catch (AssertionError ae) {
            return new Right((Object)ae);
        }
    }

    public static final /* synthetic */ boolean $anonfun$findLeaderEpoch$1(int brokerId$1, KafkaBroker x$7) {
        return x$7.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$findFollowerId$1(TopicPartition topicPartition$3, KafkaBroker server) {
        Option option = server.replicaManager().onlinePartition(topicPartition$3);
        if (option instanceof Some) {
            return !((Partition)((Some)option).value()).leaderReplicaIdOpt().contains((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId()));
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ int $anonfun$findFollowerId$2(KafkaBroker x$9) {
        return x$9.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$waitUntilBrokerMetadataIsPropagated$1(KafkaBroker x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilBrokerMetadataIsPropagated$3(scala.collection.immutable.Set expectedBrokerIds$1, KafkaBroker server) {
        scala.collection.immutable.Set set = expectedBrokerIds$1;
        scala.collection.immutable.Set set2 = ((IterableOnceOps)server.dataPlaneRequestProcessor().metadataCache().getAliveBrokers().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$waitUntilBrokerMetadataIsPropagated$5() {
        return "Timed out waiting for broker metadata to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllPartitionsMetadata$2(int expectedNumPartitions$1, String topic$2, KafkaBroker broker) {
        if (expectedNumPartitions$1 == 0) {
            Option option = broker.metadataCache().numPartitions(topic$2);
            None$ none$ = None$.MODULE$;
            return option != null && option.equals(none$);
        }
        Option option = broker.metadataCache().numPartitions(topic$2);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)expectedNumPartitions$1));
        return option != null && option.equals(some);
    }

    public static final /* synthetic */ String $anonfun$waitForAllPartitionsMetadata$3(String topic$2) {
        return "Topic [" + topic$2 + "] metadata not propagated after 60000 ms";
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionMetadata$2(String topic$3, int partition$2, KafkaBroker broker) {
        Option option = broker.metadataCache().getLeaderAndIsr(topic$3, partition$2);
        if (option instanceof Some) {
            return FetchRequest.isValidBrokerId((int)((LeaderAndIsr)((Some)option).value()).leader());
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$ensureConsistentKRaftMetadata$2(long controllerOffset$1, KafkaBroker broker) {
        MetadataLoader loader = ((BrokerServer)broker).sharedServer().loader();
        return loader == null || loader.lastAppliedOffset() >= controllerOffset$1;
    }

    public static final /* synthetic */ String $anonfun$ensureConsistentKRaftMetadata$3(String msg$1) {
        return msg$1;
    }

    public static final /* synthetic */ String $anonfun$awaitLeaderChange$1(Option expectedLeaderOpt$1) {
        return "Checking leader that has changed to " + expectedLeaderOpt$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$3(Partition x$12) {
        return x$12.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$2(Option expectedLeaderOpt$1, TopicPartition tp$1, KafkaBroker broker) {
        return broker.config().brokerId() == BoxesRunTime.unboxToInt((Object)expectedLeaderOpt$1.get()) && broker.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$3(x$12)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$4(KafkaBroker x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ String $anonfun$awaitLeaderChange$5(Option oldLeaderOpt$2) {
        return "Checking leader that has changed from " + oldLeaderOpt$2;
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$7(Partition x$14) {
        return x$14.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$8(Partition x$15) {
        return x$15.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$6(TopicPartition tp$1, Option oldLeaderOpt$2, KafkaBroker broker) {
        broker.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$7(x$14)));
        return broker.config().brokerId() != BoxesRunTime.unboxToInt((Object)oldLeaderOpt$2.get()) && broker.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$8(x$15)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$9(KafkaBroker x$16) {
        return x$16.config().brokerId();
    }

    public static final /* synthetic */ String $anonfun$awaitLeaderChange$10() {
        return "Checking the elected leader";
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$12(Partition x$17) {
        return x$17.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$11(TopicPartition tp$1, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$12(x$17)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$13(KafkaBroker x$18) {
        return x$18.config().brokerId();
    }

    private final Option newLeaderExists$1(Option expectedLeaderOpt$1, scala.collection.Seq brokers$7, TopicPartition tp$1, Option oldLeaderOpt$2) {
        if (expectedLeaderOpt$1.isDefined()) {
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = TestUtils$.$anonfun$awaitLeaderChange$1(expectedLeaderOpt$1);
                Object var5_5 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            }
            return brokers$7.find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$2(expectedLeaderOpt$1, tp$1, broker))).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$4(x$13)));
        }
        if (oldLeaderOpt$2.isDefined()) {
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = TestUtils$.$anonfun$awaitLeaderChange$5(oldLeaderOpt$2);
                Object var6_6 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            }
            return brokers$7.find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$6(tp$1, oldLeaderOpt$2, broker))).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$9(x$16)));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = "Checking the elected leader";
            Object var7_7 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        return brokers$7.find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$11(tp$1, broker))).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$13(x$18)));
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$14(TestUtils$ $this, Option expectedLeaderOpt$1, scala.collection.Seq brokers$7, TopicPartition tp$1, Option oldLeaderOpt$2) {
        return $this.newLeaderExists$1(expectedLeaderOpt$1, brokers$7, tp$1, oldLeaderOpt$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$awaitLeaderChange$15(TopicPartition tp$1, long timeout$2) {
        return "Did not observe leader change for partition " + tp$1 + " after " + timeout$2 + " ms";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$2(Partition x$19) {
        return x$19.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$1(TopicPartition tp$2, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(tp$2).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$2(x$19)));
    }

    public static final /* synthetic */ int $anonfun$waitUntilLeaderIsKnown$3(KafkaBroker x$20) {
        return x$20.config().brokerId();
    }

    private static final Option leaderIfExists$1(scala.collection.Seq brokers$8, TopicPartition tp$2) {
        return brokers$8.find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$1(tp$2, broker))).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilLeaderIsKnown$3(x$20)));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$4(scala.collection.Seq brokers$8, TopicPartition tp$2) {
        return TestUtils$.leaderIfExists$1(brokers$8, tp$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsKnown$5(TopicPartition tp$2, long timeout$3) {
        return "Partition " + tp$2 + " leaders not made yet after " + timeout$3 + " ms";
    }

    public static final /* synthetic */ boolean $anonfun$assertNoNonDaemonThreads$1(String threadNamePrefix$1, Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(threadNamePrefix$1);
    }

    public static final /* synthetic */ String $anonfun$generateAndProduceMessages$1(int x) {
        return "test-" + x;
    }

    public static final /* synthetic */ String $anonfun$generateAndProduceMessages$6(IndexedSeq records$1, IndexedSeq topics$1) {
        return "Sent " + records$1.size() + " messages for topics " + topics$1.mkString(",");
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyTopicDeletion$1(String topic$5, int x$25) {
        return new TopicPartition(topic$5, x$25);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$4(KafkaBroker broker$1, TopicPartition tp) {
        return broker$1.replicaManager().onlinePartition(tp).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$5() {
        return "Replica manager's should have deleted all of this topic's partitions";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$8(KafkaBroker broker$2, TopicPartition tp) {
        LogManager qual$1 = broker$2.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp, x$2).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$9() {
        return "Replica logs not deleted after delete topic is complete";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$14(TopicPartition tp$3, java.util.Map checkpointsPerLogDir) {
        return !checkpointsPerLogDir.containsKey(tp$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$12(KafkaBroker broker$3, TopicPartition tp) {
        return ((scala.collection.Seq)broker$3.logManager().liveLogDirs().map((Function1 & Serializable)logDir -> new OffsetCheckpointFile(new File((File)logDir, "cleaner-offset-checkpoint"), null).read())).forall((Function1 & Serializable)checkpointsPerLogDir -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$14(tp, checkpointsPerLogDir)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$15() {
        return "Cleaner offset for deleted partition should have been removed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$19(String logDir$1, TopicPartition tp) {
        return !new File(logDir$1, tp.topic() + "-" + tp.partition()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$17(IndexedSeq topicPartitions$1, KafkaBroker broker) {
        return broker.config().logDirs().forall((Function1 & Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$19(logDir, tp)))));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$20() {
        return "Failed to soft-delete the data to a delete directory";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$26(TopicPartition tp$4, String directoryName) {
        return directoryName.startsWith(tp$4.topic() + "-" + tp$4.partition()) && directoryName.endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix());
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$24(String logDir$2, TopicPartition tp) {
        return !CollectionConverters$.MODULE$.ListHasAsScala(Arrays.asList(new String[][]{new File(logDir$2).list()})).asScala().exists((Function1 & Serializable)partitionDirectoryNames -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryNames), (Function1 & Serializable)directoryName -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$26(tp$4, directoryName)))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$22(IndexedSeq topicPartitions$1, KafkaBroker broker) {
        return broker.config().logDirs().forall((Function1 & Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$24(logDir, tp)))));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$27() {
        return "Failed to hard-delete the delete directory";
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyAcls$1(Authorizer authorizer$1, AclBindingFilter filter$1, scala.collection.immutable.Set expected$1) {
        scala.collection.immutable.Set set = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(filter$1)).asScala().map((Function1 & Serializable)x$26 -> x$26.entry())).toSet();
        return !(set != null ? !set.equals(expected$1) : expected$1 != null);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyAcls$3(scala.collection.immutable.Set expected$1, String newLine$1, Authorizer authorizer$1, AclBindingFilter filter$1) {
        return "expected acls:" + expected$1.mkString(newLine$1 + "\t", newLine$1 + "\t", newLine$1) + "but got:" + ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(filter$1)).asScala().map((Function1 & Serializable)x$27 -> x$27.entry())).mkString(newLine$1 + "\t", newLine$1 + "\t", newLine$1);
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, ArrayBuffer records$2, int numRecords$1) {
        records$2.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$pollUntilAtLeastNumRecords$2(ArrayBuffer records$2, int numRecords$1) {
        return "Consumed " + records$2.size() + " records before timeout instead of the expected " + numRecords$1 + " records";
    }

    public static final /* synthetic */ boolean $anonfun$resetToCommittedPositions$1(Tuple2 x$28) {
        return x$28._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$waitForOnlineBroker$2(int brokerId$2, Node x$29) {
        return x$29.id() == brokerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$waitForOnlineBroker$1(Admin client$1, int brokerId$2) {
        Collection nodes = (Collection)client$1.describeCluster().nodes().get();
        return CollectionConverters$.MODULE$.CollectionHasAsScala(nodes).asScala().exists((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForOnlineBroker$2(brokerId$2, x$29)));
    }

    public static final /* synthetic */ String $anonfun$waitForOnlineBroker$3(int brokerId$2) {
        return "Timed out waiting for brokerId " + brokerId$2 + " to come online";
    }

    public static final /* synthetic */ boolean $anonfun$waitForLeaderToBecome$2(int partitionId$1, TopicPartitionInfo x$30) {
        return x$30.partition() == partitionId$1;
    }

    private static final Try currentLeader$1(Admin client$2, String topic$7, int partitionId$1) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            TopicDescription topicDescription = (TopicDescription)((java.util.Map)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)topic$7, (List)Nil$.MODULE$)).asJava()).allTopicNames().get()).get(topic$7);
            return CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().find((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForLeaderToBecome$2(partitionId$1, x$30))).flatMap((Function1 & Serializable)partitionState -> Option$.MODULE$.apply((Object)partitionState.leader())).map((Function1 & Serializable)x$31 -> BoxesRunTime.boxToInteger((int)x$31.id()));
        });
    }

    public static final /* synthetic */ Try $anonfun$waitForLeaderToBecome$5(Admin client$2, String topic$7, int partitionId$1) {
        return TestUtils$.currentLeader$1(client$2, topic$7, partitionId$1);
    }

    public static final /* synthetic */ boolean $anonfun$waitForLeaderToBecome$6(Option expectedLeaderOpt$2, Try x0$1) {
        boolean bl = false;
        Failure failure = null;
        if (x0$1 instanceof Success) {
            Option option = (Option)((Success)x0$1).value();
            return !(option != null ? !option.equals(expectedLeaderOpt$2) : expectedLeaderOpt$2 != null);
        }
        if (x0$1 instanceof Failure) {
            bl = true;
            failure = (Failure)x0$1;
            Throwable e = failure.exception();
            if (e instanceof ExecutionException && ((ExecutionException)e).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
        }
        if (bl) {
            throw failure.exception();
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokersOutOfIsr$1(Admin client$3, scala.collection.immutable.Set partition$3, scala.collection.immutable.Set brokerIds$1) {
        scala.collection.immutable.Set isr = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client$3.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)partition$3.map((Function1 & Serializable)x$33 -> x$33.topic())).asJava()).allTopicNames().get()).asScala().values().flatMap((Function1 & Serializable)x$34 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$34.partitions()).asScala().flatMap((Function1 & Serializable)x$35 -> CollectionConverters$.MODULE$.ListHasAsScala(x$35.isr()).asScala()))).map((Function1 & Serializable)x$36 -> BoxesRunTime.boxToInteger((int)x$36.id()))).toSet();
        return brokerIds$1.intersect((scala.collection.Set)isr).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForBrokersOutOfIsr$6(scala.collection.immutable.Set brokerIds$1, scala.collection.immutable.Set partition$3) {
        return "Expected brokers " + brokerIds$1 + " to no longer be in the ISR for " + partition$3;
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokersInIsr$1(Admin client$4, TopicPartition partition$4, scala.collection.immutable.Set brokerIds$2) {
        scala.collection.immutable.Set<Object> isr = MODULE$.currentIsr(client$4, partition$4);
        return brokerIds$2.subsetOf(isr);
    }

    public static final /* synthetic */ String $anonfun$waitForBrokersInIsr$2(scala.collection.immutable.Set brokerIds$2, TopicPartition partition$4) {
        return "Expected brokers " + brokerIds$2 + " to be in the ISR for " + partition$4;
    }

    public static final /* synthetic */ boolean $anonfun$totalMetricValue$1(String metricName$1, KafkaMetric x$40) {
        String string = x$40.metricName().name();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ double $anonfun$totalMetricValue$2(double total, KafkaMetric metric) {
        return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public static final /* synthetic */ boolean $anonfun$meterCountOpt$1(String metricName$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getMBeanName().endsWith(metricName$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$meterCountOpt$2(Metric x$41) {
        return ((Meter)x$41).count();
    }

    public static final /* synthetic */ boolean $anonfun$metersCount$1(String metricName$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getMBeanName().endsWith(metricName$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$metersCount$2(Metric x0$2) {
        if (x0$2 instanceof Histogram) {
            return ((Histogram)x0$2).count();
        }
        if (x0$2 instanceof Meter) {
            return ((Meter)x0$2).count();
        }
        return 0L;
    }

    public static final /* synthetic */ void $anonfun$clearYammerMetrics$1(MetricName metricName) {
        KafkaYammerMetrics.defaultRegistry().removeMetric(metricName);
    }

    public static final /* synthetic */ boolean $anonfun$pickAuthorizerForWrite$2(ControllerServer x$42) {
        return x$42.controller().isActive();
    }

    public static final /* synthetic */ void $anonfun$pickAuthorizerForWrite$1(scala.collection.Seq controllers$1, ObjectRef result$1) {
        ControllerServer active = (ControllerServer)((IterableOps)controllers$1.filter((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$pickAuthorizerForWrite$2(x$42)))).head();
        result$1.elem = (Authorizer)active.authorizer().get();
    }

    private TestUtils$() {
    }

    public static final /* synthetic */ Option $anonfun$waitUntilLeaderIsElectedOrChangedWithAdmin$3$adapted(Admin admin$2, String topic, Object partition) {
        return TestUtils$.getPartitionLeader$1(topic, BoxesRunTime.unboxToInt((Object)partition), admin$2);
    }

    public static final /* synthetic */ Object $anonfun$tryUntilNoAssertionError$2$adapted(Either x$6) {
        return BoxesRunTime.boxToBoolean((boolean)x$6.isLeft());
    }

    public static final /* synthetic */ Object $anonfun$pollUntilAtLeastNumRecords$1$adapted(ArrayBuffer records$2, int numRecords$1, ConsumerRecords polledRecords) {
        return BoxesRunTime.boxToBoolean((boolean)TestUtils$.pollAction$1(polledRecords, records$2, numRecords$1));
    }

    public static final /* synthetic */ Object $anonfun$waitForLeaderToBecome$6$adapted(Option expectedLeaderOpt$2, Try x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForLeaderToBecome$6(expectedLeaderOpt$2, x0$1));
    }
}

