/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import kafka.api.AdminClientWithPoliciesIntegrationTest$;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaa\u0016\u0001!\u0002\u0013!\u0006\"\u0002-\u0001\t\u0003J\u0006\"B5\u0001\t\u0003R\u0007\"B8\u0001\t\u0003\u0001\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBa!!\u0016\u0001\t\u0003Q\u0007BBA0\u0001\u0011\u0005!\u000e\u0003\u0004\u0002d\u0001!\tA[\u0004\b\u0003g\u0012\u0003\u0012AA;\r\u0019\t#\u0005#\u0001\u0002x!1A'\u0005C\u0001\u0003\u007fB\u0011\"!!\u0012\u0005\u0004%\t!a!\t\u0011\u0005\u001d\u0016\u0003)A\u0005\u0003\u000bCq!!+\u0012\t\u0003\tYK\u0002\u0004\u0002DF\u0001\u0011Q\u0019\u0005\u0007iY!\t!!4\t\u0017\u0005Mg\u00031AA\u0002\u0013\u0005\u0011Q\u001b\u0005\f\u0003k4\u0002\u0019!a\u0001\n\u0003\t9\u0010C\u0006\u0002fZ\u0001\r\u0011!Q!\n\u0005]\u0007\"\u0003B\u0002-\u0001\u0007I\u0011\u0001B\u0003\u0011%\u0011iA\u0006a\u0001\n\u0003\u0011y\u0001\u0003\u0005\u0003\u0014Y\u0001\u000b\u0015\u0002B\u0004\u0011\u001d\u0011)B\u0006C\u0001\u0005/AqA!\n\u0017\t\u0003\u00119\u0003\u0003\u0004\u0003.Y!\tA\u001b\u0002'\u0003\u0012l\u0017N\\\"mS\u0016tGoV5uQB{G.[2jKNLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0012%\u0003\r\t\u0007/\u001b\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006J\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002.U\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u00020e5\t\u0001G\u0003\u00022I\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\t!%\u0001\u0004dY&,g\u000e^\u000b\u0002uA\u00111(R\u0007\u0002y)\u0011QHP\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003\u007f\u0001\u000bqa\u00197jK:$8O\u0003\u0002&\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1EHA\u0003BI6Lg.\u0001\u0006dY&,g\u000e^0%KF$\"!S(\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\tUs\u0017\u000e\u001e\u0005\b!\u000e\t\t\u00111\u0001;\u0003\rAH%M\u0001\bG2LWM\u001c;!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003Q\u0003\"AS+\n\u0005Y[%aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)1/\u001a;VaR\u0011\u0011J\u0017\u0005\u00067\u001e\u0001\r\u0001X\u0001\ti\u0016\u001cH/\u00138g_B\u0011QlY\u0007\u0002=*\u00111e\u0018\u0006\u0003A\u0006\fqA[;qSR,'O\u0003\u0002c\u0007\u0006)!.\u001e8ji&\u0011AM\u0018\u0002\t)\u0016\u001cH/\u00138g_\"\u0012qA\u001a\t\u0003;\u001eL!\u0001\u001b0\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005I\u0005F\u0001\u0005m!\tiV.\u0003\u0002o=\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\rGJ,\u0017\r^3D_:4\u0017nZ\u000b\u0002cB)!o^=\u0002\n5\t1O\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\u00075\u000b\u0007\u000fE\u0002{\u0003\u0007q!a_@\u0011\u0005q\\U\"A?\u000b\u0005y4\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0002-\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001\u0017B!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010U\fA\u0001\\1oO&!\u00111CA\u0007\u0005\u0019y%M[3di\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0002\u001aA1\u00111DA\u0011\u0003Ki!!!\b\u000b\u0007\u0005}1*\u0001\u0006d_2dWm\u0019;j_:LA!a\t\u0002\u001e\t\u00191+Z9\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b%\u0003\u0019\u0019XM\u001d<fe&!\u0011qFA\u0015\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002--\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u001cuN\u001c4jON$B!!\u000e\u0002LA1\u0011qGA!\u0003\u000brA!!\u000f\u0002>9\u0019A0a\u000f\n\u00031K1!a\u0010L\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\t\u0002D)\u0019\u0011qH&\u0011\u0007I\f9%C\u0002\u0002JM\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015Y6\u00021\u0001]\u0003Myg/\u001a:sS\u0012,gj\u001c3f\u0007>tg-[4t)\rI\u0015\u0011\u000b\u0005\b\u0003'b\u0001\u0019AA#\u0003\u0015\u0001(o\u001c9t\u0003U!Xm\u001d;WC2LG-\u00117uKJ\u001cuN\u001c4jOND3!DA-!\ri\u00161L\u0005\u0004\u0003;r&\u0001\u0002+fgR\fq\u0003^3ti&sg/\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:)\u00079\tI&\u0001\u0012uKN$\u0018J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hg\u0012+X\rV8Q_2L7-\u001f\u0015\u0004\u001f\u0005e\u0003f\u0002\u0001\u0002j\u0005=\u0014\u0011\u000f\t\u0004;\u0006-\u0014bAA7=\n9A+[7f_V$\u0018!\u0002<bYV,g$\u0001=\u0002M\u0005#W.\u001b8DY&,g\u000e^,ji\"\u0004v\u000e\\5dS\u0016\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u00028#M\u0019\u0011#!\u001f\u0011\u0007)\u000bY(C\u0002\u0002~-\u0013a!\u00118z%\u00164GCAA;\u0003-1\u0018\r\\5eCRLwN\\:\u0016\u0005\u0005\u0015\u0005CBAD\u0003\u001b\u000b\t*\u0004\u0002\u0002\n*!\u00111RA\u000f\u0003\u001diW\u000f^1cY\u0016LA!a$\u0002\n\nQA*[:u\u0005V4g-\u001a:\u0011\t\u0005M\u0015\u0011\u0015\b\u0005\u0003+\u000bi*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0019\u0001x\u000e\\5ds*\u0019\u00111\u0006!\n\t\u0005}\u0015qS\u0001\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\u0018\u0002BAR\u0003K\u0013qBU3rk\u0016\u001cH/T3uC\u0012\fG/\u0019\u0006\u0005\u0003?\u000b9*\u0001\u0007wC2LG-\u0019;j_:\u001c\b%\u0001\fwC2LG-\u0019;j_:\u001chi\u001c:SKN|WO]2f)\u0011\ti+a,\u0011\r\u0005]\u0012\u0011IAI\u0011\u001d\t\t,\u0006a\u0001\u0003g\u000b\u0001B]3t_V\u00148-\u001a\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0019\u0019wN\u001c4jO*\u0019\u0011Q\u0018!\u0002\r\r|W.\\8o\u0013\u0011\t\t-a.\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\n1\u0001k\u001c7jGf\u001cRAFA\u0005\u0003\u000f\u0004B!!&\u0002J&!\u00111ZAL\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u000b\u0003\u0003\u001f\u00042!!5\u0017\u001b\u0005\t\u0012aB2p]\u001aLwm]\u000b\u0003\u0003/\u0004D!!7\u0002bB1!0a7z\u0003;L1\u0001_A\u0004!\u0011\ty.!9\r\u0001\u0011Y\u00111\u001d\u000e\u0002\u0002\u0003\u0005)\u0011AAt\u0005\ryF%M\u0001\tG>tg-[4tAE!\u0011\u0011^Ax!\rQ\u00151^\u0005\u0004\u0003[\\%a\u0002(pi\"Lgn\u001a\t\u0004\u0015\u0006E\u0018bAAz\u0017\n\u0019\u0011I\\=\u0002\u0017\r|gNZ5hg~#S-\u001d\u000b\u0004\u0013\u0006e\b\u0002\u0003)\u001a\u0003\u0003\u0005\r!a?1\t\u0005u(\u0011\u0001\t\u0007u\u0006m\u00170a@\u0011\t\u0005}'\u0011\u0001\u0003\r\u0003G\fI0!A\u0001\u0002\u000b\u0005\u0011q]\u0001\u0007G2|7/\u001a3\u0016\u0005\t\u001d\u0001c\u0001&\u0003\n%\u0019!1B&\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0007%\u0013\t\u0002\u0003\u0005Q9\u0005\u0005\t\u0019\u0001B\u0004\u0003\u001d\u0019Gn\\:fI\u0002\n\u0011bY8oM&<WO]3\u0015\u0007%\u0013I\u0002C\u0004\u0002Tz\u0001\rAa\u00071\t\tu!\u0011\u0005\t\u0006e^L(q\u0004\t\u0005\u0003?\u0014\t\u0003\u0002\u0007\u0003$\te\u0011\u0011!A\u0001\u0006\u0003\t9OA\u0002`II\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0004\u0013\n%\u0002b\u0002B\u0016?\u0001\u0007\u0011\u0011S\u0001\u0010e\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uC\u0006)1\r\\8tK\u0002")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client;
    private final int brokerCount;

    public static scala.collection.immutable.Seq<AlterConfigPolicy.RequestMetadata> validationsForResource(ConfigResource resource) {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(resource);
    }

    public static ListBuffer<AlterConfigPolicy.RequestMetadata> validations() {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validations();
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), 15000L);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return java.util.Map.of("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        configs.foreach((Function1 & Serializable)props -> {
            this.overrideNodeConfigs(props);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    public scala.collection.immutable.Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties props = new Properties();
        props.put("alter.config.policy.class.name", Policy.class);
        return new .colon.colon((Object)props, (List)Nil$.MODULE$);
    }

    private void overrideNodeConfigs(Properties props) {
        props.put("alter.config.policy.class.name", Policy.class);
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        String maxMessageBytes = "500000";
        String retentionMs = "60000000";
        topicConfig1.setProperty("max.message.bytes", maxMessageBytes);
        topicConfig1.setProperty("retention.ms", retentionMs);
        this.createTopic(topic1, 1, 1, topicConfig1, this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), this, topicResource1, topicResource2, maxMessageBytes, retentionMs);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this, this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId()));
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs(java.util.Map.of(brokerResource, java.util.List.of(new AlterConfigOp(new ConfigEntry("message.max.bytes", "50000"), AlterConfigOp.OpType.SET))));
        alterResult.all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.bytes"})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> alterConfigs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        alterConfigs.put(topicResource1, java.util.List.of(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("min.insync.replicas", "2"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(topicResource2, java.util.List.of(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "0.8"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(topicResource3, java.util.List.of(new AlterConfigOp(new ConfigEntry("min.insync.replicas", "-1"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(brokerResource, java.util.List.of(new AlterConfigOp(new ConfigEntry("ssl.truststore.password", "12313"), AlterConfigOp.OpType.SET)));
        alterResult = this.client().incrementalAlterConfigs(alterConfigs);
        Assertions.assertEquals(Set.of(topicResource1, topicResource2, topicResource3, brokerResource), alterResult.values().keySet());
        TestUtils.assertFutureThrows(PolicyViolationException.class, (Future)((Future)alterResult.values().get(topicResource1)));
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils.assertFutureThrows(InvalidConfigurationException.class, (Future)((Future)alterResult.values().get(topicResource3)));
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)((Future)alterResult.values().get(brokerResource)));
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs(java.util.List.of(topicResource1, topicResource2, topicResource3, brokerResource)).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get("ssl.truststore.password").value());
        alterConfigs.put(topicResource2, java.util.List.of(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "0.7"), AlterConfigOp.OpType.SET)));
        alterResult = this.client().incrementalAlterConfigs(alterConfigs, new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals(Set.of(topicResource1, topicResource2, topicResource3, brokerResource), alterResult.values().keySet());
        TestUtils.assertFutureThrows(PolicyViolationException.class, (Future)((Future)alterResult.values().get(topicResource1)));
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils.assertFutureThrows(InvalidConfigurationException.class, (Future)((Future)alterResult.values().get(topicResource3)));
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)((Future)alterResult.values().get(brokerResource)));
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)this.client().describeConfigs(java.util.List.of(topicResource1, topicResource2, topicResource3, brokerResource)).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get("ssl.truststore.password").value());
        alterResult = this.client().incrementalAlterConfigs(java.util.Map.of(brokerResource, java.util.List.of(new AlterConfigOp(new ConfigEntry("max.connections", "9999"), AlterConfigOp.OpType.SET))));
        alterResult.all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections"})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, Object> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, Object> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, Object> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
            this.configs_$eq((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(configs).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().append((Object)requestMetadata);
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(this.configs().nonEmpty(), (Function0 & Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(requestMetadata.resource().name())), (Function0 & Serializable)() -> "resource name should not be empty");
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

